(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17598,        650]
NotebookOptionsPosition[     13748,        523]
NotebookOutlinePosition[     15136,        561]
CellTagsIndexPosition[     15051,        556]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Conditionals" :> 
          Documentation`HelpLookup["paclet:tutorial/Conditionals"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Conditionals\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"If" :> Documentation`HelpLookup["paclet:ref/If"], "Condition" :> 
          Documentation`HelpLookup["paclet:ref/Condition"], "Which" :> 
          Documentation`HelpLookup["paclet:ref/Which"], "Piecewise" :> 
          Documentation`HelpLookup["paclet:ref/Piecewise"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"If\"\>", 2->"\<\"Condition\"\>", 
       3->"\<\"Which\"\>", 4->"\<\"Piecewise\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Conditionals" :> 
          Documentation`HelpLookup["paclet:guide/Conditionals"], 
          "Procedural Programming" :> 
          Documentation`HelpLookup["paclet:guide/ProceduralProgramming"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Conditionals\"\>", 
       2->"\<\"Procedural Programming\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Switch", "ObjectName",
 CellID->2206],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Switch",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Switch"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        SubscriptBox[
         StyleBox["form", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["value", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["form", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["value", "TI"], 
         StyleBox["2", "TR"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]evaluates ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", then compares it with each of the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["form", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " in turn, evaluating and returning the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["value", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " corresponding to the first match found. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27171]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Only the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["value", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " corresponding to the first ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["form", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " that matches ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " is evaluated. Each ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["form", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " is evaluated only when the match is tried. "
}], "Notes",
 CellID->18166],

Cell[TextData[{
 "If the last ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["form", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " is the pattern ",
 Cell[BoxData["_"], "InlineFormula"],
 ", then the corresponding ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["value", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " is always returned if this case is reached. "
}], "Notes",
 CellID->3396],

Cell[TextData[{
 "If none of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["form", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " match ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ", the ",
 Cell[BoxData[
  ButtonBox["Switch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Switch"]], "InlineFormula"],
 " is returned unevaluated. "
}], "Notes",
 CellID->16697],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Switch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Switch"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldRest",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldRest"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31020],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Break",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Break"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Return",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Return"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Throw",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Throw"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["Switch",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Switch"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23694]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->567363891],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->173284691],

Cell["\<\
Process Boolean value to 1 or 0, giving a message and defaulting to 0 when \
not Boolean:\
\>", "ExampleText",
 CellID->509356465],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f", "::", "boole"}], "=", 
   "\"\<The value `1` is not True or False.\>\""}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->43328641],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", "b_", "]"}], ":=", 
  RowBox[{"Switch", "[", 
   RowBox[{
   "b", ",", "True", ",", "1", ",", "False", ",", "0", ",", "_", ",", 
    RowBox[{
     RowBox[{"Message", "[", 
      RowBox[{
       RowBox[{"f", "::", "boole"}], ",", "b"}], "]"}], ";", "0"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->690072688],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "True", "]"}], ",", " ", 
   RowBox[{"f", "[", "False", "]"}], ",", 
   RowBox[{"f", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->112203737],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "::", "\<\"boole\"\>"}], ":", 
  " ", "\<\"The value \\!\\(x\\) is not True or False.\"\>"}]], "Message", \
"MSG",
 CellID->57840299],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->384777110]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->591434064],

Cell["Give a suggested symbolic transformation for an expression:", \
"ExampleText",
 CellID->676888253],

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "[", "e_", "]"}], " ", ":=", 
  RowBox[{"Switch", "[", 
   RowBox[{
   "e", ",", "_Plus", ",", " ", "Together", ",", "_Times", ",", "Apart", ",", 
    "_", ",", "Identity"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->718196771],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"e", " ", "=", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{"1", "-", "x"}], ")"}]}], " ", "+", " ", 
    RowBox[{"x", "/", 
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}]}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"t", "[", "e", "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->340827482],

Cell[BoxData["Together"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->102678429]
}, Open  ]],

Cell["Try the transformation:", "ExampleText",
 CellID->146815257],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"e1", "=", 
  RowBox[{
   RowBox[{"t", "[", "e", "]"}], "[", "e", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->41400856],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "1"}], "-", 
   RowBox[{"3", " ", "x"}]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}]}]]], "Output",
 ImageSize->{101, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->236412356]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11969],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["If",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/If"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Condition",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Condition"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Which",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Which"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Piecewise",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Piecewise"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28978]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15529],

Cell[TextData[ButtonBox["Conditionals",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Conditionals"]], "Tutorials",
 CellID->14788]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Switch",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Switch"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->242865598],

Cell[TextData[ButtonBox["Conditionals",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Conditionals"]], "MoreAbout",
 CellID->29446057],

Cell[TextData[ButtonBox["Procedural Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ProceduralProgramming"]], "MoreAbout",
 CellID->52729370]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Switch - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 25, 36.2526316}", "context" -> "System`", 
    "keywords" -> {
     "Cases", "code branching", "conditionals", "which", "control flow"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Switch[expr, form_1, value_1, form_2, value_2, ...] evaluates expr, then \
compares it with each of the form_i in turn, evaluating and returning the \
value_i corresponding to the first match found. ", "synonyms" -> {}, "title" -> 
    "Switch", "type" -> "Symbol", "uri" -> "ref/Switch"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6877, 244, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->567363891]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14908, 549}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2099, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2722, 77, 43, 1, 70, "ObjectName",
 CellID->2206],
Cell[2768, 80, 1339, 42, 70, "Usage",
 CellID->27171]
}, Open  ]],
Cell[CellGroupData[{
Cell[4144, 127, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4622, 144, 553, 21, 70, "Notes",
 CellID->18166],
Cell[5178, 167, 405, 15, 70, "Notes",
 CellID->3396],
Cell[5586, 184, 395, 16, 70, "Notes",
 CellID->16697],
Cell[5984, 202, 304, 12, 70, "Notes",
 CellID->31020],
Cell[6291, 216, 549, 23, 70, "Notes",
 CellID->23694]
}, Closed]],
Cell[CellGroupData[{
Cell[6877, 244, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->567363891],
Cell[CellGroupData[{
Cell[7262, 258, 148, 5, 70, "ExampleSection",
 CellID->173284691],
Cell[7413, 265, 140, 4, 70, "ExampleText",
 CellID->509356465],
Cell[7556, 271, 184, 6, 70, "Input",
 CellID->43328641],
Cell[7743, 279, 366, 12, 70, "Input",
 CellID->690072688],
Cell[CellGroupData[{
Cell[8134, 295, 224, 7, 70, "Input",
 CellID->112203737],
Cell[8361, 304, 172, 5, 70, "Message",
 CellID->57840299],
Cell[8536, 311, 213, 7, 36, "Output",
 CellID->384777110]
}, Open  ]],
Cell[8764, 321, 125, 3, 70, "ExampleDelimiter",
 CellID->591434064],
Cell[8892, 326, 104, 2, 70, "ExampleText",
 CellID->676888253],
Cell[8999, 330, 275, 8, 70, "Input",
 CellID->718196771],
Cell[CellGroupData[{
Cell[9299, 342, 420, 14, 70, "Input",
 CellID->340827482],
Cell[9722, 358, 165, 5, 36, "Output",
 CellID->102678429]
}, Open  ]],
Cell[9902, 366, 66, 1, 70, "ExampleText",
 CellID->146815257],
Cell[CellGroupData[{
Cell[9993, 371, 149, 5, 70, "Input",
 CellID->41400856],
Cell[10145, 378, 387, 15, 53, "Output",
 CellID->236412356]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10593, 400, 311, 9, 70, "SeeAlsoSection",
 CellID->11969],
Cell[10907, 411, 927, 35, 70, "SeeAlso",
 CellID->28978]
}, Open  ]],
Cell[CellGroupData[{
Cell[11871, 451, 314, 9, 70, "TutorialsSection",
 CellID->15529],
Cell[12188, 462, 135, 3, 70, "Tutorials",
 CellID->14788]
}, Open  ]],
Cell[CellGroupData[{
Cell[12360, 470, 305, 8, 70, "RelatedLinksSection"],
Cell[12668, 480, 357, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13062, 497, 319, 9, 70, "MoreAboutSection",
 CellID->242865598],
Cell[13384, 508, 135, 3, 70, "MoreAbout",
 CellID->29446057],
Cell[13522, 513, 154, 3, 70, "MoreAbout",
 CellID->52729370]
}, Open  ]],
Cell[13691, 519, 27, 0, 70, "History"],
Cell[13721, 521, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

