(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     30850,       1187]
NotebookOptionsPosition[     22974,        906]
NotebookOutlinePosition[     24258,        944]
CellTagsIndexPosition[     24173,        939]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Specifying Types of Expression in Patterns" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecifyingTypesOfExpressionInPatterns"], 
          "Manipulating Symbols and Contexts by Name" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingSymbolsAndContextsByName"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Specifying Types of Expression in Patterns\"\>", 
       2->"\<\"Manipulating Symbols and Contexts by Name\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SymbolName" :> 
          Documentation`HelpLookup["paclet:ref/SymbolName"], "ToExpression" :> 
          Documentation`HelpLookup["paclet:ref/ToExpression"], "Unique" :> 
          Documentation`HelpLookup["paclet:ref/Unique"], "Remove" :> 
          Documentation`HelpLookup["paclet:ref/Remove"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"SymbolName\"\>", 2->"\<\"ToExpression\"\>", 
       3->"\<\"Unique\"\>", 4->"\<\"Remove\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Atomic Elements of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AtomicElementsOfExpressions"], 
          "Converting between Expressions & Strings" :> 
          Documentation`HelpLookup[
           "paclet:guide/ConvertingBetweenExpressionsAndStrings"], 
          "Expressions" :> 
          Documentation`HelpLookup["paclet:guide/Expressions"], 
          "Expression Structure" :> 
          Documentation`HelpLookup["paclet:guide/ExpressionStructure"], 
          "Symbol Handling" :> 
          Documentation`HelpLookup["paclet:guide/SymbolHandling"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Atomic Elements of Expressions\"\>",
        2->"\<\"Converting between Expressions & Strings\"\>", 
       3->"\<\"Expressions\"\>", 4->"\<\"Expression Structure\"\>", 
       5->"\<\"Symbol Handling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Symbol", "ObjectName",
 CellID->16225],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Symbol",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Symbol"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]refers to a symbol with the specified name. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->1009]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "All symbols, whether explicitly entered using ",
 Cell[BoxData[
  ButtonBox["Symbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Symbol"]], "InlineFormula"],
 " or not, have head ",
 Cell[BoxData[
  ButtonBox["Symbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Symbol"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22012],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["x", "TI"], "_Symbol"}]]], "InlineFormula"],
 " can be used as a pattern to represent any symbol. "
}], "Notes",
 CellID->18136],

Cell[TextData[{
 "The string ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\""], "InlineFormula"],
 " in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Symbol",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Symbol"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " must be an appropriate name for a symbol. It can contain any letters, \
letter\[Hyphen]like forms, or digits, but cannot start with a digit. "
}], "Notes",
 CellID->11455],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Symbol",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Symbol"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " creates a new symbol if none exists with the specified name. "
}], "Notes",
 CellID->18762],

Cell[TextData[{
 "A symbol such as ",
 Cell[BoxData["x"], "InlineFormula"],
 " has a name ",
 Cell[BoxData["\"\<x\>\""], "InlineFormula"],
 ". "
}], "Notes",
 CellID->25043],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Symbol",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Symbol"], "[", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " creates a new symbol, it does so in the context specified by ",
 Cell[BoxData[
  ButtonBox["$Context",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Context"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->742]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->215878873],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->34644707],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Symbol", "[", "\"\<x\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->453280135],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->626048549]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Head", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2467392],

Cell[BoxData["Symbol"], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->68391376]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3169],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Symbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Symbol"]], "InlineFormula"],
 " to create new symbols in a program:"
}], "ExampleText",
 CellID->289902431],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Symbol", "[", 
  RowBox[{"\"\<x\>\"", "<>", "\"\<1\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->135522474],

Cell[BoxData["x1"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->483942481]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->491925258],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Symbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Symbol"]], "InlineFormula"],
 " for pattern matching:"
}], "ExampleText",
 CellID->78081672],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], ",", 
    RowBox[{"f", "[", "\"\<x\>\"", "]"}], ",", 
    RowBox[{"f", "[", "2", "]"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"f", "[", "s_Symbol", "]"}], "\[RuleDelayed]", 
   RowBox[{"g", "[", "s", "]"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->687246891],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"g", "[", "x", "]"}], ",", 
   RowBox[{"f", "[", "\<\"x\"\>", "]"}], ",", 
   RowBox[{"f", "[", "2", "]"}]}], "}"}]], "Output",
 ImageSize->{125, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->110672837]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->682864806],

Cell["Create a symbol in a given context:", "ExampleText",
 CellID->42538061],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Symbol", "[", "\"\<a`x\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->98910196],

Cell[BoxData["a`x"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->188606920]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Context", "[", 
  RowBox[{"Evaluate", "[", "%", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->292838966],

Cell[BoxData["\<\"a`\"\>"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->37657228]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->96286311],

Cell["Create a symbol in the current context:", "ExampleText",
 CellID->552243565],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Symbol", "[", "\"\<`x\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->85927300],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17762209]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22640],

Cell["Create several symbols in a program:", "ExampleText",
 CellID->54756746],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Symbol", "[", 
    RowBox[{"\"\<x\>\"", "<>", 
     RowBox[{"ToString", "[", "i", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"i", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6731061],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x1", ",", "x2", ",", "x3", ",", "x4", ",", "x5"}], "}"}]], "Output",\

 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->279661652]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21979],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Symbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Symbol"]], "InlineFormula"],
 " creates new symbols in the current context:"
}], "ExampleText",
 CellID->1477271],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Names", "[", "\"\<`x*\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->759101389],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->161639320]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Symbol", "[", "\"\<x1\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->202315574],

Cell[BoxData["x1"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->53733705]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Names", "[", "\"\<`x*\>\"", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->45182436],

Cell[BoxData[
 RowBox[{"{", "\<\"x1\"\>", "}"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->695065090]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1787071],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Unique",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Unique"]], "InlineFormula"],
 " creates symbols with a unique new name:"
}], "ExampleText",
 CellID->154567212],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Unique", "[", "\"\<x\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->86462042],

Cell[BoxData["x1"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->676207784]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Unique", "[", "\"\<x\>\"", "]"}], ",", 
   RowBox[{"{", "5", "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->134211680],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"x2", ",", "x3", ",", "x4", ",", "x5", ",", "x6"}], "}"}]], "Output",\

 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->77703541]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->64214203],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Module",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Module"]], "InlineFormula"],
 " creates new temporary symbols every time it is evaluated:"
}], "ExampleText",
 CellID->27137009],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", "x", "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->190091476],

Cell[BoxData["x$371"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->530695294]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->127169802],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Symbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Symbol"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["SymbolName",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SymbolName"]], "InlineFormula"],
 " are inverses of each other:"
}], "ExampleText",
 CellID->538533441],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Symbol", "[", 
  RowBox[{"SymbolName", "[", "x17", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->315455163],

Cell[BoxData["x17"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->180953356]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SymbolName", "[", 
   RowBox[{"Symbol", "[", "\"\<y32\>\"", "]"}], "]"}], "//", 
  "InputForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18097332],

Cell["\"y32\"", "Output",
 ImageSize->{35, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->535131633]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->38175923],

Cell["\<\
Many functions of symbols also accept symbol names as arguments:\
\>", "ExampleText",
 CellID->1040314],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "\"\<Pi\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->180197289],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Constant", ",", "Protected", ",", "ReadProtected"}], 
  "}"}]], "Output",
 ImageSize->{251, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->132782534]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23471543],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Context",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Context"]], "InlineFormula"],
 " gives the context of a symbol:"
}], "ExampleText",
 CellID->804136391],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Context", "[", "Integrate", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33008484],

Cell[BoxData["\<\"System`\"\>"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->307609987]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11181044],

Cell["\<\
Possible symbol names can be characterized by regular expressions:\
\>", "ExampleText",
 CellID->30240520],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"StringMatchQ", "[", 
    RowBox[{"#", ",", 
     RowBox[{
     "RegularExpression", "[", "\"\<[[:alpha:]$][[:alnum:]$]*\>\"", "]"}]}], 
    "]"}], "&"}], "/@", 
  RowBox[{"{", 
   RowBox[{
   "\"\<sym1\>\"", ",", "\"\<1x\>\"", ",", "\"\<m\[ADoubleDot]der\>\"", ",", 
    "\"\<x_1\>\"", ",", "\"\<$1\>\""}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->284721580],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "False", ",", "True", ",", "False", ",", "True"}], 
  "}"}]], "Output",
 ImageSize->{217, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->239367415]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24199],

Cell["The name must satisfy the syntax for symbol names:", "ExampleText",
 CellID->98120672],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Symbol", "[", "\"\<1x\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->899837891],

Cell[BoxData[
 RowBox[{
  RowBox[{"Symbol", "::", "\<\"symname\"\>"}], ":", 
  " ", "\<\"The string \\\"\\!\\(\\\"1x\\\"\\)\\\" cannot be used for a \
symbol name. A symbol name must start with a letter followed by letters and \
numbers.\"\>"}]], "Message", "MSG",
 CellID->109512535],

Cell[BoxData[
 RowBox[{"Symbol", "[", "\<\"1x\"\>", "]"}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->911723605]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23717],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SymbolName",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SymbolName"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Unique",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Unique"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Remove",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Remove"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->9714]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21],

Cell[TextData[ButtonBox["Specifying Types of Expression in Patterns",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/SpecifyingTypesOfExpressionInPatterns"]], "Tutorials",
 CellID->17922],

Cell[TextData[ButtonBox["Manipulating Symbols and Contexts by Name",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingSymbolsAndContextsByName"]], "Tutorials",
 CellID->24512]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->408839847],

Cell[TextData[ButtonBox["Atomic Elements of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AtomicElementsOfExpressions"]], "MoreAbout",
 CellID->310584163],

Cell[TextData[ButtonBox["Converting between Expressions & Strings",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ConvertingBetweenExpressionsAndStrings"]], "MoreAbout",
 CellID->528227100],

Cell[TextData[ButtonBox["Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Expressions"]], "MoreAbout",
 CellID->490261877],

Cell[TextData[ButtonBox["Expression Structure",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ExpressionStructure"]], "MoreAbout",
 CellID->75668687],

Cell[TextData[ButtonBox["Symbol Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolHandling"]], "MoreAbout",
 CellID->39759955]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Symbol - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 25, 37.1120286}", "context" -> "System`", 
    "keywords" -> {
     "names", "symbol table", "variables", "variable names", "function names",
       "option names"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Symbol[\"name\"] refers to a symbol with the specified name. ", 
    "synonyms" -> {}, "title" -> "Symbol", "type" -> "Symbol", "uri" -> 
    "ref/Symbol"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6671, 214, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->215878873]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24030, 932}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3000, 67, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3623, 94, 44, 1, 70, "ObjectName",
 CellID->16225],
Cell[3670, 97, 499, 15, 70, "Usage",
 CellID->1009]
}, Open  ]],
Cell[CellGroupData[{
Cell[4206, 117, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4684, 134, 355, 13, 70, "Notes",
 CellID->22012],
Cell[5042, 149, 196, 7, 70, "Notes",
 CellID->18136],
Cell[5241, 158, 483, 14, 70, "Notes",
 CellID->11455],
Cell[5727, 174, 298, 9, 70, "Notes",
 CellID->18762],
Cell[6028, 185, 173, 7, 70, "Notes",
 CellID->25043],
Cell[6204, 194, 430, 15, 70, "Notes",
 CellID->742]
}, Closed]],
Cell[CellGroupData[{
Cell[6671, 214, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->215878873],
Cell[CellGroupData[{
Cell[7056, 228, 147, 5, 70, "ExampleSection",
 CellID->34644707],
Cell[CellGroupData[{
Cell[7228, 237, 110, 3, 28, "Input",
 CellID->453280135],
Cell[7341, 242, 158, 5, 36, "Output",
 CellID->626048549]
}, Open  ]],
Cell[CellGroupData[{
Cell[7536, 252, 98, 3, 28, "Input",
 CellID->2467392],
Cell[7637, 257, 162, 5, 36, "Output",
 CellID->68391376]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7848, 268, 215, 7, 70, "ExampleSection",
 CellID->3169],
Cell[8066, 277, 218, 8, 70, "ExampleText",
 CellID->289902431],
Cell[CellGroupData[{
Cell[8309, 289, 142, 4, 70, "Input",
 CellID->135522474],
Cell[8454, 295, 159, 5, 36, "Output",
 CellID->483942481]
}, Open  ]],
Cell[8628, 303, 125, 3, 70, "ExampleDelimiter",
 CellID->491925258],
Cell[8756, 308, 203, 8, 70, "ExampleText",
 CellID->78081672],
Cell[CellGroupData[{
Cell[8984, 320, 349, 11, 70, "Input",
 CellID->687246891],
Cell[9336, 333, 309, 10, 36, "Output",
 CellID->110672837]
}, Open  ]],
Cell[9660, 346, 125, 3, 70, "ExampleDelimiter",
 CellID->682864806],
Cell[9788, 351, 77, 1, 70, "ExampleText",
 CellID->42538061],
Cell[CellGroupData[{
Cell[9890, 356, 111, 3, 70, "Input",
 CellID->98910196],
Cell[10004, 361, 160, 5, 36, "Output",
 CellID->188606920]
}, Open  ]],
Cell[CellGroupData[{
Cell[10201, 371, 138, 4, 70, "Input",
 CellID->292838966],
Cell[10342, 377, 166, 5, 36, "Output",
 CellID->37657228]
}, Open  ]],
Cell[10523, 385, 124, 3, 70, "ExampleDelimiter",
 CellID->96286311],
Cell[10650, 390, 82, 1, 70, "ExampleText",
 CellID->552243565],
Cell[CellGroupData[{
Cell[10757, 395, 110, 3, 70, "Input",
 CellID->85927300],
Cell[10870, 400, 157, 5, 36, "Output",
 CellID->17762209]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11076, 411, 223, 7, 70, "ExampleSection",
 CellID->22640],
Cell[11302, 420, 78, 1, 70, "ExampleText",
 CellID->54756746],
Cell[CellGroupData[{
Cell[11405, 425, 277, 9, 70, "Input",
 CellID->6731061],
Cell[11685, 436, 241, 8, 36, "Output",
 CellID->279661652]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11975, 450, 233, 7, 70, "ExampleSection",
 CellID->21979],
Cell[12211, 459, 215, 7, 70, "ExampleText",
 CellID->1477271],
Cell[CellGroupData[{
Cell[12451, 470, 111, 3, 70, "Input",
 CellID->759101389],
Cell[12565, 475, 175, 6, 36, "Output",
 CellID->161639320]
}, Open  ]],
Cell[CellGroupData[{
Cell[12777, 486, 111, 3, 70, "Input",
 CellID->202315574],
Cell[12891, 491, 158, 5, 36, "Output",
 CellID->53733705]
}, Open  ]],
Cell[CellGroupData[{
Cell[13086, 501, 110, 3, 70, "Input",
 CellID->45182436],
Cell[13199, 506, 189, 6, 36, "Output",
 CellID->695065090]
}, Open  ]],
Cell[13403, 515, 123, 3, 70, "ExampleDelimiter",
 CellID->1787071],
Cell[13529, 520, 213, 7, 70, "ExampleText",
 CellID->154567212],
Cell[CellGroupData[{
Cell[13767, 531, 109, 3, 70, "Input",
 CellID->86462042],
Cell[13879, 536, 159, 5, 36, "Output",
 CellID->676207784]
}, Open  ]],
Cell[CellGroupData[{
Cell[14075, 546, 190, 6, 70, "Input",
 CellID->134211680],
Cell[14268, 554, 240, 8, 36, "Output",
 CellID->77703541]
}, Open  ]],
Cell[14523, 565, 124, 3, 70, "ExampleDelimiter",
 CellID->64214203],
Cell[14650, 570, 230, 7, 70, "ExampleText",
 CellID->27137009],
Cell[CellGroupData[{
Cell[14905, 581, 149, 5, 70, "Input",
 CellID->190091476],
Cell[15057, 588, 162, 5, 36, "Output",
 CellID->530695294]
}, Open  ]],
Cell[15234, 596, 125, 3, 70, "ExampleDelimiter",
 CellID->127169802],
Cell[15362, 601, 334, 12, 70, "ExampleText",
 CellID->538533441],
Cell[CellGroupData[{
Cell[15721, 617, 141, 4, 70, "Input",
 CellID->315455163],
Cell[15865, 623, 160, 5, 36, "Output",
 CellID->180953356]
}, Open  ]],
Cell[CellGroupData[{
Cell[16062, 633, 184, 6, 70, "Input",
 CellID->18097332],
Cell[16249, 641, 166, 5, 50, "Output",
 CellID->535131633]
}, Open  ]],
Cell[16430, 649, 124, 3, 70, "ExampleDelimiter",
 CellID->38175923],
Cell[16557, 654, 113, 3, 70, "ExampleText",
 CellID->1040314],
Cell[CellGroupData[{
Cell[16695, 661, 115, 3, 70, "Input",
 CellID->180197289],
Cell[16813, 666, 244, 8, 36, "Output",
 CellID->132782534]
}, Open  ]],
Cell[17072, 677, 124, 3, 70, "ExampleDelimiter",
 CellID->23471543],
Cell[17199, 682, 206, 7, 70, "ExampleText",
 CellID->804136391],
Cell[CellGroupData[{
Cell[17430, 693, 110, 3, 70, "Input",
 CellID->33008484],
Cell[17543, 698, 172, 5, 36, "Output",
 CellID->307609987]
}, Open  ]],
Cell[17730, 706, 124, 3, 70, "ExampleDelimiter",
 CellID->11181044],
Cell[17857, 711, 116, 3, 70, "ExampleText",
 CellID->30240520],
Cell[CellGroupData[{
Cell[17998, 718, 415, 13, 70, "Input",
 CellID->284721580],
Cell[18416, 733, 254, 8, 36, "Output",
 CellID->239367415]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18719, 747, 226, 7, 70, "ExampleSection",
 CellID->24199],
Cell[18948, 756, 92, 1, 70, "ExampleText",
 CellID->98120672],
Cell[CellGroupData[{
Cell[19065, 761, 111, 3, 70, "Input",
 CellID->899837891],
Cell[19179, 766, 284, 6, 70, "Message",
 CellID->109512535],
Cell[19466, 774, 199, 6, 36, "Output",
 CellID->911723605]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19726, 787, 311, 9, 70, "SeeAlsoSection",
 CellID->23717],
Cell[20040, 798, 944, 35, 70, "SeeAlso",
 CellID->9714]
}, Open  ]],
Cell[CellGroupData[{
Cell[21021, 838, 311, 9, 70, "TutorialsSection",
 CellID->21],
Cell[21335, 849, 193, 4, 70, "Tutorials",
 CellID->17922],
Cell[21531, 855, 191, 4, 70, "Tutorials",
 CellID->24512]
}, Open  ]],
Cell[CellGroupData[{
Cell[21759, 864, 319, 9, 70, "MoreAboutSection",
 CellID->408839847],
Cell[22081, 875, 169, 3, 70, "MoreAbout",
 CellID->310584163],
Cell[22253, 880, 193, 4, 70, "MoreAbout",
 CellID->528227100],
Cell[22449, 886, 134, 3, 70, "MoreAbout",
 CellID->490261877],
Cell[22586, 891, 150, 3, 70, "MoreAbout",
 CellID->75668687],
Cell[22739, 896, 140, 3, 70, "MoreAbout",
 CellID->39759955]
}, Open  ]],
Cell[22894, 902, 50, 0, 70, "History"],
Cell[22947, 904, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

