(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     17460,        660]
NotebookOptionsPosition[     12937,        502]
NotebookOutlinePosition[     14239,        540]
CellTagsIndexPosition[     14154,        535]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Manipulating Symbols and Contexts by Name" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ManipulatingSymbolsAndContextsByName"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Manipulating Symbols and Contexts by Name\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ToString" :> Documentation`HelpLookup["paclet:ref/ToString"], 
          "Symbol" :> Documentation`HelpLookup["paclet:ref/Symbol"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"ToString\"\>", 
       2->"\<\"Symbol\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Atomic Elements of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AtomicElementsOfExpressions"], 
          "Converting between Expressions & Strings" :> 
          Documentation`HelpLookup[
           "paclet:guide/ConvertingBetweenExpressionsAndStrings"], 
          "Symbol Handling" :> 
          Documentation`HelpLookup["paclet:guide/SymbolHandling"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Atomic Elements of Expressions\"\>",
        2->"\<\"Converting between Expressions & Strings\"\>", 
       3->"\<\"Symbol Handling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SymbolName", "ObjectName",
 CellID->12259],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SymbolName",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SymbolName"], "[", 
       StyleBox["symbol", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the name of the specified symbol. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->26653]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SymbolName",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SymbolName"]], "InlineFormula"],
 " evaluates its input. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->12319537]
}], "Notes",
 CellID->2095],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SymbolName",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SymbolName"]], "InlineFormula"],
 " always returns a string. "
}], "Notes",
 CellID->24365]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->110415895],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->6051188],

Cell[TextData[{
 "The name of the symbol ",
 Cell[BoxData["x"], "InlineFormula"],
 " is the string ",
 Cell[BoxData["\"\<x\>\""], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->323950],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SymbolName", "[", "x", "]"}], "//", "InputForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->276577083],

Cell["\"x\"", "Output",
 ImageSize->{21, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//InputForm=",
 CellID->517533137]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10440],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Symbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Symbol"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["SymbolName",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SymbolName"]], "InlineFormula"],
 " are inverses of each other:"
}], "ExampleText",
 CellID->538533441],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Symbol", "[", 
  RowBox[{"SymbolName", "[", "x17", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->315455163],

Cell[BoxData["x17"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->51274048]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SymbolName", "[", 
   RowBox[{"Symbol", "[", "\"\<y32\>\"", "]"}], "]"}], "//", 
  "InputForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18097332],

Cell["\"y32\"", "Output",
 ImageSize->{35, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->147488533]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->38175923],

Cell["\<\
Many functions of symbols also accept symbol names as arguments:\
\>", "ExampleText",
 CellID->1040314],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "\"\<Pi\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->180197289],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Constant", ",", "Protected", ",", "ReadProtected"}], 
  "}"}]], "Output",
 ImageSize->{251, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->132782534]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->331604157],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SymbolName",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SymbolName"]], "InlineFormula"],
 " always gives the short name, without any context:"
}], "ExampleText",
 CellID->253895420],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SymbolName", "/@", 
   RowBox[{"{", 
    RowBox[{"x", ",", "a`x", ",", "b`x"}], "}"}]}], "//", 
  "InputForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->459301925],

Cell["{\"x\", \"x\", \"x\"}", "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//InputForm=",
 CellID->202071550]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToString",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToString"]], "InlineFormula"],
 " takes the settings of ",
 Cell[BoxData[
  ButtonBox["$Context",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Context"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["$ContextPath",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$ContextPath"]], "InlineFormula"],
 " into account:"
}], "ExampleText",
 CellID->173886975],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToString", "/@", 
   RowBox[{"{", 
    RowBox[{"x", ",", "a`x", ",", "b`x"}], "}"}]}], "//", 
  "InputForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->282015439],

Cell["{\"x\", \"a`x\", \"b`x\"}", "Output",
 ImageSize->{133, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->21542077]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7375],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SymbolName",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SymbolName"]], "InlineFormula"],
 " evaluates its input:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->12319537],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", "=", "5"}], ";"}], "\n", 
 RowBox[{"SymbolName", "[", "x", "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->301632914],

Cell[BoxData[
 RowBox[{
  RowBox[{"SymbolName", "::", "\<\"sym\"\>"}], ":", 
  " ", "\<\"Argument \\!\\(5\\) at position \\!\\(1\\) is expected to be a \
symbol.\"\>"}]], "Message", "MSG",
 CellID->42618514],

Cell[BoxData[
 RowBox[{"SymbolName", "[", "5", "]"}]], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->586139429]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SymbolName", "[", 
  RowBox[{"Unevaluated", "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->51930659],

Cell[BoxData["\<\"x\"\>"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->106961980]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8976],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Symbol",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Symbol"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18455]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11874],

Cell[TextData[ButtonBox["Manipulating Symbols and Contexts by Name",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ManipulatingSymbolsAndContextsByName"]], "Tutorials",
 CellID->7720]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Atomic Elements of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AtomicElementsOfExpressions"]], "MoreAbout",
 CellID->61395],

Cell[TextData[ButtonBox["Converting between Expressions & Strings",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ConvertingBetweenExpressionsAndStrings"]], "MoreAbout",
 CellID->790112536],

Cell[TextData[ButtonBox["Symbol Handling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolHandling"]], "MoreAbout",
 CellID->432735734]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SymbolName - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 25, 36.7995206}", "context" -> "System`", 
    "keywords" -> {
     "function name", "names", "option name", "symbol table", "symbols", 
      "variable name"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "SymbolName[symbol] gives the name of the specified symbol. ", 
    "synonyms" -> {"symbol name"}, "title" -> "SymbolName", "type" -> 
    "Symbol", "uri" -> "ref/SymbolName"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4476, 146, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->110415895]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14011, 528}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2281, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2904, 82, 48, 1, 70, "ObjectName",
 CellID->12259],
Cell[2955, 85, 491, 15, 70, "Usage",
 CellID->26653]
}, Open  ]],
Cell[CellGroupData[{
Cell[3483, 105, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3961, 122, 278, 10, 70, "Notes",
 CellID->2095],
Cell[4242, 134, 197, 7, 70, "Notes",
 CellID->24365]
}, Closed]],
Cell[CellGroupData[{
Cell[4476, 146, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->110415895],
Cell[CellGroupData[{
Cell[4861, 160, 146, 5, 70, "ExampleSection",
 CellID->6051188],
Cell[5010, 167, 188, 7, 70, "ExampleText",
 CellID->323950],
Cell[CellGroupData[{
Cell[5223, 178, 138, 4, 28, "Input",
 CellID->276577083],
Cell[5364, 184, 164, 5, 50, "Output",
 CellID->517533137]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5577, 195, 233, 7, 70, "ExampleSection",
 CellID->10440],
Cell[5813, 204, 334, 12, 70, "ExampleText",
 CellID->538533441],
Cell[CellGroupData[{
Cell[6172, 220, 141, 4, 70, "Input",
 CellID->315455163],
Cell[6316, 226, 159, 5, 36, "Output",
 CellID->51274048]
}, Open  ]],
Cell[CellGroupData[{
Cell[6512, 236, 184, 6, 70, "Input",
 CellID->18097332],
Cell[6699, 244, 166, 5, 50, "Output",
 CellID->147488533]
}, Open  ]],
Cell[6880, 252, 124, 3, 70, "ExampleDelimiter",
 CellID->38175923],
Cell[7007, 257, 113, 3, 70, "ExampleText",
 CellID->1040314],
Cell[CellGroupData[{
Cell[7145, 264, 115, 3, 70, "Input",
 CellID->180197289],
Cell[7263, 269, 244, 8, 36, "Output",
 CellID->132782534]
}, Open  ]],
Cell[7522, 280, 125, 3, 70, "ExampleDelimiter",
 CellID->331604157],
Cell[7650, 285, 231, 7, 70, "ExampleText",
 CellID->253895420],
Cell[CellGroupData[{
Cell[7906, 296, 200, 7, 70, "Input",
 CellID->459301925],
Cell[8109, 305, 181, 5, 50, "Output",
 CellID->202071550]
}, Open  ]],
Cell[8305, 313, 475, 17, 70, "ExampleText",
 CellID->173886975],
Cell[CellGroupData[{
Cell[8805, 334, 198, 7, 70, "Input",
 CellID->282015439],
Cell[9006, 343, 184, 5, 50, "Output",
 CellID->21542077]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9239, 354, 225, 7, 70, "ExampleSection",
 CellID->7375],
Cell[9467, 363, 249, 8, 70, "ExampleText",
 CellID->12319537],
Cell[CellGroupData[{
Cell[9741, 375, 159, 5, 70, "Input",
 CellID->301632914],
Cell[9903, 382, 207, 5, 70, "Message",
 CellID->42618514],
Cell[10113, 389, 194, 6, 36, "Output",
 CellID->586139429]
}, Open  ]],
Cell[CellGroupData[{
Cell[10344, 400, 143, 4, 70, "Input",
 CellID->51930659],
Cell[10490, 406, 166, 5, 36, "Output",
 CellID->106961980]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10717, 418, 310, 9, 70, "SeeAlsoSection",
 CellID->8976],
Cell[11030, 429, 447, 17, 70, "SeeAlso",
 CellID->18455]
}, Open  ]],
Cell[CellGroupData[{
Cell[11514, 451, 314, 9, 70, "TutorialsSection",
 CellID->11874],
Cell[11831, 462, 190, 4, 70, "Tutorials",
 CellID->7720]
}, Open  ]],
Cell[CellGroupData[{
Cell[12058, 471, 299, 8, 70, "MoreAboutSection"],
Cell[12360, 481, 165, 3, 70, "MoreAbout",
 CellID->61395],
Cell[12528, 486, 193, 4, 70, "MoreAbout",
 CellID->790112536],
Cell[12724, 492, 141, 3, 70, "MoreAbout",
 CellID->432735734]
}, Open  ]],
Cell[12880, 498, 27, 0, 70, "History"],
Cell[12910, 500, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

