(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     24255,        877]
NotebookOptionsPosition[     19809,        731]
NotebookOutlinePosition[     21177,        769]
CellTagsIndexPosition[     21092,        764]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Messages" :> Documentation`HelpLookup["paclet:ref/Messages"], 
          "Attributes" :> 
          Documentation`HelpLookup["paclet:ref/Attributes"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Messages\"\>", 
       2->"\<\"Attributes\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Package Development" :> 
          Documentation`HelpLookup["paclet:guide/PackageDevelopment"], 
          "New in 6.0: Core Language" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60CoreLanguage"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Package Development\"\>", 
       2->"\<\"New in 6.0: Core Language\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["SyntaxInformation", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SyntaxInformation",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SyntaxInformation"], "[", 
       StyleBox["f", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives information used to generate syntax coloring and \
other advisories when ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "[", 
       StyleBox["\[Ellipsis]", "TR"], "]"}]], "InlineFormula"],
     " is entered as input. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23692]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{"SyntaxInformation", "[", 
    StyleBox["f", "TI"], "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"prop\", \"TI\"], 
StyleBox[\"1\", \"TR\"]]\)\>\"", "->", 
      SubscriptBox[
       StyleBox["data", "TI"], 
       StyleBox["1", "TR"]]}], ",", 
     RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"prop\", \"TI\"], 
StyleBox[\"2\", \"TR\"]]\)\>\"", "->", 
      SubscriptBox[
       StyleBox["data", "TI"], 
       StyleBox["2", "TR"]]}], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " defines syntax properties ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["prop", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->19771],

Cell["Possible properties include:", "Notes",
 CellID->20363],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<ArgumentsPattern\>\"", Cell[
    "patterns for the sequence of allowed arguments", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<LocalVariables\>\"", Cell[
    "type and allowed positions of local variables", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<ColorEqualSigns\>\"", Cell[
    "argument positions for which = should be colored", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->29301],

Cell[TextData[{
 "The setting for ",
 Cell[BoxData["\"\<ArgumentsPattern\>\""], "InlineFormula"],
 " is of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["patt", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["patt", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 ", where the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["patt", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " can be ",
 Cell[BoxData["_"], "InlineFormula"],
 ", ",
 Cell[BoxData["__"], "InlineFormula"],
 ", ",
 Cell[BoxData["___"], "InlineFormula"],
 ", ",
 Cell[BoxData["_."], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["OptionsPattern",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/OptionsPattern"], "[", "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["p", "TI"], 
     StyleBox["1", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22363],

Cell[TextData[{
 "If the setting for ",
 Cell[BoxData["\"\<ArgumentsPattern\>\""], "InlineFormula"],
 " specifies that ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " takes options, then valid option names are determined from ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Options",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Options"], "[", 
   StyleBox["f", "TI"], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->7721],

Cell[TextData[{
 "The setting for ",
 Cell[BoxData["\"\<LocalVariables\>\""], "InlineFormula"],
 " is of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"type\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["max", "TI"]]}], "}"}]}], "}"}]], "InlineFormula"],
 ". Possible types include ",
 Cell[BoxData[
  ButtonBox["\"\<Table\>\"",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/format/Table"]], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Solve\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Integrate\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Limit\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Plot\>\""], "InlineFormula"],
 ", ",
 Cell[BoxData["\"\<Manipulate\>\""], "InlineFormula"],
 ". ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["i", "TI"], 
   StyleBox["min", "TI"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["i", "TI"], 
   StyleBox["max", "TI"]]], "InlineFormula"],
 " give the minimum and maximum argument positions at which the variables can \
appear.",
 " ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["i", "TI"], 
   StyleBox["max", "TI"]]], "InlineFormula"],
 " can be ",
 Cell[BoxData[
  ButtonBox["Infinity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Infinity"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->17421],

Cell[TextData[{
 "A setting for ",
 Cell[BoxData["\"\<LocalVariables\>\""], "InlineFormula"],
 " of ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"type\", \"TI\"]\)\>\"", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["min", "TI"]], ",", 
      SubscriptBox[
       StyleBox["i", "TI"], 
       StyleBox["max", "TI"]]}], "}"}], ",", "\"\<Lexical\>\""}], "}"}]], 
  "InlineFormula"],
 " specifies that local variables that appear inside ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " should not be specially colored."
}], "Notes",
 CellID->23445],

Cell[TextData[{
 "The setting for ",
 Cell[BoxData["\"\<ColorEqualSigns\>\""], "InlineFormula"],
 " is of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["i", "TI"], 
     StyleBox["min", "TI"]], ",", 
    SubscriptBox[
     StyleBox["i", "TI"], 
     StyleBox["max", "TI"]]}], "}"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->18610]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->280253805],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->423860931],

Cell[TextData[{
 "Specify that ",
 Cell[BoxData["f"], "InlineFormula"],
 " should take exactly two arguments:"
}], "ExampleText",
 CellID->19882],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SyntaxInformation", "[", "f", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"\"\<ArgumentsPattern\>\"", "->", 
     RowBox[{"{", 
      RowBox[{"_", ",", "_"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1608],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", "]"}], ",", 
    RowBox[{"f", "[", "x", "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{"x", ",", "y", ",", "z"}], "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{"x", ",", "y", ",", "z", ",", "w"}], "]"}]}], "}"}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12654],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->144],

Cell[TextData[{
 "Set up options for ",
 Cell[BoxData["f"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->22290],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Options", "[", "f", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"aaa", "->", "1"}], ",", 
     RowBox[{"bbb", "->", "2"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31339],

Cell[TextData[{
 "Specify that ",
 Cell[BoxData["f"], "InlineFormula"],
 " should have two arguments, followed by options: "
}], "ExampleText",
 CellID->23154],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SyntaxInformation", "[", "f", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"\"\<ArgumentsPattern\>\"", "->", 
     RowBox[{"{", 
      RowBox[{"_", ",", "_", ",", 
       RowBox[{"OptionsPattern", "[", "]"}]}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24604],

Cell["Inappropriate options are colored red:", "ExampleText",
 CellID->4623],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x", ",", "y", ",", 
    RowBox[{"aab", "->", "2"}], ",", 
    RowBox[{"aaa", "->", "3"}], ",", 
    RowBox[{"bba", "->", "4"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->22225]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21724],

Cell[TextData[{
 "The first argument of ",
 Cell[BoxData["f"], "InlineFormula"],
 " should be a list of exactly two elements:"
}], "ExampleText",
 CellID->31981],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SyntaxInformation", "[", "f", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"\"\<ArgumentsPattern\>\"", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"_", ",", "_"}], "}"}], ",", "_"}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2330],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{
      RowBox[{"{", "a", "}"}], ",", "x"}], "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", "x"}], "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", "x"}], "]"}]}], "}"}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29733],

Cell["\<\
The first argument is allowed to be an expression such as a symbol, which \
could evaluate to a list:\
\>", "ExampleText",
 CellID->28223],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", "a", "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{"a", ",", "x"}], "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{"a", ",", "x", ",", "y"}], "]"}]}], "}"}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->20594],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29130],

Cell[TextData[{
 Cell[BoxData["f"], "InlineFormula"],
 " can have any number of arguments, but each should be a two-element list: "
}], "ExampleText",
 CellID->18846],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SyntaxInformation", "[", "f", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"\"\<ArgumentsPattern\>\"", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"_", ",", "_"}], "}"}], "..."}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4987],

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"x", ",", "y"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}]}], "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{
      RowBox[{"{", "x", "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "b"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "y", ",", "z"}], "}"}]}], "]"}]}], "}"}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29445],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->18805],

Cell[TextData[{
 Cell[BoxData["f"], "InlineFormula"],
 " should allow \[OpenCurlyDoubleQuote]Table-like",
 "\[CloseCurlyDoubleQuote]",
 " local iterator specifications at positions 2 through infinity:"
}], "ExampleText",
 CellID->8616],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SyntaxInformation", "[", "f", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{"\"\<LocalVariables\>\"", "->", 
     RowBox[{"{", 
      RowBox[{"\"\<Table\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"2", ",", "Infinity"}], "}"}]}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5750],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"x", "+", "y"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}]}], "]"}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20489],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27338],

Cell[TextData[{
 Cell[BoxData["f"], "InlineFormula"],
 " should have one ordinary argument, followed by iterator-type list \
arguments:"
}], "ExampleText",
 CellID->21963],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SyntaxInformation", "[", "f", "]"}], "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"\"\<LocalVariables\>\"", "->", 
      RowBox[{"{", 
       RowBox[{"\"\<Table\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "Infinity"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"\"\<ArgumentsPattern\>\"", "->", 
      RowBox[{"{", 
       RowBox[{"_", ",", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"_", ",", "_", ",", "_.", ",", "_."}], "}"}], ".."}]}], 
       "}"}]}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28135],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{
    RowBox[{"x", "+", "y", "+", "z"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "0", ",", "1", ",", "2", ",", "3"}], "}"}]}], "]"}], 
  ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14697]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->29151],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Messages",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Messages"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Attributes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Attributes"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23015]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->310638472],

Cell[TextData[ButtonBox["Package Development",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageDevelopment"]], "MoreAbout",
 CellID->80923179],

Cell[TextData[ButtonBox["New in 6.0: Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60CoreLanguage"]], "MoreAbout",
 CellID->169324308]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SyntaxInformation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 25, 43.1746838}", "context" -> "System`", 
    "keywords" -> {
     "argument pattern", "local variables", "color equal signs"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "SyntaxInformation[f] gives information used to generate syntax coloring \
and other advisories when f[...] is entered as input. ", 
    "synonyms" -> {"syntax information"}, "title" -> "SyntaxInformation", 
    "type" -> "Symbol", "uri" -> "ref/SyntaxInformation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10574, 358, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->280253805]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20948, 757}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1415, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2038, 61, 1582, 37, 70, "ObjectNameGrid"],
Cell[3623, 100, 703, 21, 70, "Usage",
 CellID->23692]
}, Open  ]],
Cell[CellGroupData[{
Cell[4363, 126, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4841, 143, 841, 30, 70, "Notes",
 CellID->19771],
Cell[5685, 175, 61, 1, 70, "Notes",
 CellID->20363],
Cell[5749, 178, 685, 13, 70, "2ColumnTableMod",
 CellID->29301],
Cell[6437, 193, 1088, 43, 70, "Notes",
 CellID->22363],
Cell[7528, 238, 444, 15, 70, "Notes",
 CellID->7721],
Cell[7975, 255, 1482, 55, 70, "Notes",
 CellID->17421],
Cell[9460, 312, 698, 24, 70, "Notes",
 CellID->23445],
Cell[10161, 338, 376, 15, 70, "Notes",
 CellID->18610]
}, Closed]],
Cell[CellGroupData[{
Cell[10574, 358, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->280253805],
Cell[CellGroupData[{
Cell[10959, 372, 148, 5, 70, "ExampleSection",
 CellID->423860931],
Cell[11110, 379, 145, 5, 70, "ExampleText",
 CellID->19882],
Cell[11258, 386, 276, 9, 70, "Input",
 CellID->1608],
Cell[11537, 397, 416, 14, 70, "Input",
 CellID->12654],
Cell[11956, 413, 119, 3, 70, "ExampleDelimiter",
 CellID->144],
Cell[12078, 418, 117, 5, 70, "ExampleText",
 CellID->22290],
Cell[12198, 425, 248, 9, 70, "Input",
 CellID->31339],
Cell[12449, 436, 159, 5, 70, "ExampleText",
 CellID->23154],
Cell[12611, 443, 331, 11, 70, "Input",
 CellID->24604],
Cell[12945, 456, 76, 1, 70, "ExampleText",
 CellID->4623],
Cell[13024, 459, 249, 8, 70, "Input",
 CellID->22225]
}, Open  ]],
Cell[CellGroupData[{
Cell[13310, 472, 216, 7, 70, "ExampleSection",
 CellID->21724],
Cell[13529, 481, 161, 5, 70, "ExampleText",
 CellID->31981],
Cell[13693, 488, 336, 12, 70, "Input",
 CellID->2330],
Cell[14032, 502, 458, 17, 70, "Input",
 CellID->29733],
Cell[14493, 521, 148, 4, 70, "ExampleText",
 CellID->28223],
Cell[14644, 527, 292, 10, 70, "Input",
 CellID->20594],
Cell[14939, 539, 121, 3, 70, "ExampleDelimiter",
 CellID->29130],
Cell[15063, 544, 166, 4, 70, "ExampleText",
 CellID->18846],
Cell[15232, 550, 333, 12, 70, "Input",
 CellID->4987],
Cell[15568, 564, 512, 19, 70, "Input",
 CellID->29445],
Cell[16083, 585, 121, 3, 70, "ExampleDelimiter",
 CellID->18805],
Cell[16207, 590, 235, 6, 70, "ExampleText",
 CellID->8616],
Cell[16445, 598, 353, 12, 70, "Input",
 CellID->5750],
Cell[16801, 612, 221, 8, 70, "Input",
 CellID->20489],
Cell[17025, 622, 121, 3, 70, "ExampleDelimiter",
 CellID->27338],
Cell[17149, 627, 171, 5, 70, "ExampleText",
 CellID->21963],
Cell[17323, 634, 602, 19, 70, "Input",
 CellID->28135],
Cell[17928, 655, 325, 11, 70, "Input",
 CellID->14697]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18302, 672, 311, 9, 70, "SeeAlsoSection",
 CellID->29151],
Cell[18616, 683, 455, 17, 70, "SeeAlso",
 CellID->23015]
}, Open  ]],
Cell[CellGroupData[{
Cell[19108, 705, 319, 9, 70, "MoreAboutSection",
 CellID->310638472],
Cell[19430, 716, 148, 3, 70, "MoreAbout",
 CellID->80923179],
Cell[19581, 721, 156, 3, 70, "MoreAbout",
 CellID->169324308]
}, Open  ]],
Cell[19752, 727, 27, 0, 70, "History"],
Cell[19782, 729, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

