(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11039,        388]
NotebookOptionsPosition[      8110,        293]
NotebookOutlinePosition[      9489,        330]
CellTagsIndexPosition[      9405,        325]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Converting between Strings, Boxes and Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ConvertingBetweenStringsBoxesAndExpressions"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Converting between Strings, Boxes and Expressions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SyntaxQ" :> Documentation`HelpLookup["paclet:ref/SyntaxQ"], 
          "$SyntaxHandler" :> 
          Documentation`HelpLookup["paclet:ref/$SyntaxHandler"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"SyntaxQ\"\>", 
       2->"\<\"$SyntaxHandler\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Converting between Expressions & Strings" :> 
          Documentation`HelpLookup[
           "paclet:guide/ConvertingBetweenExpressionsAndStrings"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Converting between Expressions & Strings\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SyntaxLength", "ObjectName",
 CellID->8793],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SyntaxLength",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SyntaxLength"], "[", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]finds the number of characters starting at the \
beginning of a string that correspond to syntactically correct input for a \
single ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " expression. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3432]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SyntaxLength",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SyntaxLength"]], "InlineFormula"],
 " effectively returns the position of a syntax error, if one exists. "
}], "Notes",
 CellID->2136],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  ButtonBox["SyntaxLength",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SyntaxLength"]], "InlineFormula"],
 " returns a position past the end of the string, it indicates that the \
string is syntactically correct as far as it goes, but needs to be continued \
in order to correspond to input for a complete ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expression. "
}], "Notes",
 CellID->4580]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->49340219],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->602104920],

Cell["\<\
Give the length of the syntatically correct beginning substring:\
\>", "ExampleText",
 CellID->180305740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SyntaxLength", "[", "\"\<a[1]] + b[2]\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->552053454],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->181039519]
}, Open  ]],

Cell["\<\
The syntactically correct part can be converted to an expression:\
\>", "ExampleText",
 CellID->704125936],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", 
  RowBox[{"StringTake", "[", 
   RowBox[{"\"\<a[1]] + b[2]\>\"", ",", "%"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->109792889],

Cell[BoxData[
 RowBox[{"a", "[", "1", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->46597455]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8719],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["SyntaxQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SyntaxQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$SyntaxHandler",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$SyntaxHandler"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26790]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14875],

Cell[TextData[ButtonBox["Converting between Strings, Boxes and Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ConvertingBetweenStringsBoxesAndExpressions"]], "Tutorials",\

 CellID->5907]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Converting between Expressions & Strings",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ConvertingBetweenExpressionsAndStrings"]], "MoreAbout",
 CellID->486607841]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SyntaxLength - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 25, 43.9872046}", "context" -> "System`", 
    "keywords" -> {"error syntax in string", "syntax error position"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "SyntaxLength[\"string\"] finds the number of characters starting at the \
beginning of a string that correspond to syntactically correct input for a \
single Mathematica expression. ", "synonyms" -> {"syntax length"}, "title" -> 
    "SyntaxLength", "type" -> "Symbol", "uri" -> "ref/SyntaxLength"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4616, 150, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->49340219]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9263, 318}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2016, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2639, 78, 49, 1, 70, "ObjectName",
 CellID->8793],
Cell[2691, 81, 681, 20, 70, "Usage",
 CellID->3432]
}, Open  ]],
Cell[CellGroupData[{
Cell[3409, 106, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3887, 123, 242, 7, 70, "Notes",
 CellID->2136],
Cell[4132, 132, 447, 13, 70, "Notes",
 CellID->4580]
}, Closed]],
Cell[CellGroupData[{
Cell[4616, 150, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->49340219],
Cell[CellGroupData[{
Cell[5000, 164, 148, 5, 70, "ExampleSection",
 CellID->602104920],
Cell[5151, 171, 115, 3, 70, "ExampleText",
 CellID->180305740],
Cell[CellGroupData[{
Cell[5291, 178, 127, 3, 28, "Input",
 CellID->552053454],
Cell[5421, 183, 158, 5, 36, "Output",
 CellID->181039519]
}, Open  ]],
Cell[5594, 191, 116, 3, 70, "ExampleText",
 CellID->704125936],
Cell[CellGroupData[{
Cell[5735, 198, 188, 5, 28, "Input",
 CellID->109792889],
Cell[5926, 205, 184, 6, 36, "Output",
 CellID->46597455]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6171, 218, 310, 9, 70, "SeeAlsoSection",
 CellID->8719],
Cell[6484, 229, 461, 17, 70, "SeeAlso",
 CellID->26790]
}, Open  ]],
Cell[CellGroupData[{
Cell[6982, 251, 314, 9, 70, "TutorialsSection",
 CellID->14875],
Cell[7299, 262, 207, 5, 70, "Tutorials",
 CellID->5907]
}, Open  ]],
Cell[CellGroupData[{
Cell[7543, 272, 299, 8, 70, "MoreAboutSection"],
Cell[7845, 282, 193, 4, 70, "MoreAbout",
 CellID->486607841]
}, Open  ]],
Cell[8053, 289, 27, 0, 70, "History"],
Cell[8083, 291, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

