(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     47234,       1084]
NotebookOptionsPosition[     41591,        937]
NotebookOutlinePosition[     44893,       1003]
CellTagsIndexPosition[     44808,        998]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"$System" :> Documentation`HelpLookup["paclet:ref/$System"], 
          "$Version" :> Documentation`HelpLookup["paclet:ref/$Version"], 
          "Options" :> Documentation`HelpLookup["paclet:ref/Options"], 
          "CurrentValue" :> 
          Documentation`HelpLookup["paclet:ref/CurrentValue"], 
          "ControllerInformation" :> 
          Documentation`HelpLookup["paclet:ref/ControllerInformation"], 
          "NotebookInformation" :> 
          Documentation`HelpLookup["paclet:ref/NotebookInformation"], 
          "Environment" :> 
          Documentation`HelpLookup["paclet:ref/Environment"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"$System\"\>", 2->"\<\"$Version\"\>",
        3->"\<\"Options\"\>", 4->"\<\"CurrentValue\"\>", 
       5->"\<\"ControllerInformation\"\>", 6->"\<\"NotebookInformation\"\>", 
       7->"\<\"Environment\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Global Computation Settings & Parameters" :> 
          Documentation`HelpLookup[
           "paclet:guide/GlobalComputationSettingsAndParameters"], 
          "Low-Level System Optimization" :> 
          Documentation`HelpLookup["paclet:guide/LowLevelSystemOptimization"],
           "Mathematica Session Information" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaSessionInformation"], 
          "Mathematica Sessions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicaSessions"], 
          "Mathematica System Setup" :> 
          Documentation`HelpLookup["paclet:guide/MathematicaSystemSetup"], 
          "Namespace Management" :> 
          Documentation`HelpLookup["paclet:guide/NamespaceManagement"], 
          "System & License Management" :> 
          Documentation`HelpLookup["paclet:guide/SystemAndLicenseManagement"],
           "System Information" :> 
          Documentation`HelpLookup["paclet:guide/SystemInformation"], 
          "Tuning & Debugging" :> 
          Documentation`HelpLookup["paclet:guide/TuningAndDebugging"], 
          "New in 6.0: System Interfaces & Deployment" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60SystemInterfacesAndDeployment"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Global Computation Settings & Parameters\"\>", 
       2->"\<\"Low-Level System Optimization\"\>", 
       3->"\<\"Mathematica Session Information\"\>", 
       4->"\<\"Mathematica Sessions\"\>", 
       5->"\<\"Mathematica System Setup\"\>", 
       6->"\<\"Namespace Management\"\>", 
       7->"\<\"System & License Management\"\>", 
       8->"\<\"System Information\"\>", 9->"\<\"Tuning & Debugging\"\>", 
       10->"\<\"New in 6.0: System Interfaces & Deployment\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["SystemInformation", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SystemInformation",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SystemInformation"], "[", "]"}]], 
      "InlineFormula"],
     "\[LineSeparator]gives detailed information about the ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " system being run. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SystemInformation",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SystemInformation"], "[", "\"\<\!\(\*
StyleBox[\"comp\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of rules with information about the \
component ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"comp\", \"TI\"]\)\>\""], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["SystemInformation",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/SystemInformation"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"comp\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"prop\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the value of property ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"prop\", \"TI\"]\)\>\""], "InlineFormula"],
     " for component ",
     Cell[BoxData["\"\<\!\(\*
StyleBox[\"comp\", \"TI\"]\)\>\""], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->15818]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "When run in a notebook interface ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["SystemInformation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SystemInformation"], "[", "]"}]], 
  "InlineFormula"],
 " yields a graphical form; otherwise it gives a list of rules. "
}], "Notes",
 CellID->24471],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SystemInformation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SystemInformation"], "[", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"], "]"}]], "InlineFormula"],
 " always gives a list of rules. "
}], "Notes",
 CellID->7342],

Cell["Typical possible components to specify include:", "Notes",
 CellID->347864858],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Kernel\>\"", Cell[TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " kernel used for evaluation"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<FrontEnd\>\"", Cell[TextData[{
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " front end used for display"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Devices\>\"", Cell[
    "devices, drivers, etc.", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->310899023],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SystemInformation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SystemInformation"]], "InlineFormula"],
 " gives information on the kernel in which it is evaluated, and the front \
end in which it is displayed."
}], "Notes",
 CellID->293782271],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["SystemInformation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SystemInformation"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"comp\", \"TI\"]\)\>\"", ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "]"}]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Missing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Missing"], "[", "\"\<NotActive\>\"", "]"}]], 
  "InlineFormula"],
 " if the specified component is not active in your current system."
}], "Notes",
 CellID->50336697]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->66677799],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->59478609],

Cell["\<\
Display system information; browse to relevant tab for details:\
\>", "ExampleText",
 CellID->83487619],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SystemInformation", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->963689088],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{527, 284},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1982358692]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1791168283],

Cell["Get a list of information rules for currently open links:", \
"ExampleText",
 CellID->739568735],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{
   RowBox[{"SystemInformation", "[", "\"\<Links\>\"", "]"}], ",", "2"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->296380309],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\<\"OpenStreams\"\>", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"OutputStream", "[", 
        RowBox[{"\<\"stdout\"\>", ",", "1"}], "]"}], ",", 
       RowBox[{"OutputStream", "[", 
        RowBox[{"\<\"stderr\"\>", ",", "2"}], "]"}]}], "}"}]}], ",", 
    RowBox[{"\[LeftSkeleton]", "18", "\[RightSkeleton]"}], ",", 
    RowBox[{"\<\"InstalledWebServices\"\>", "\[Rule]", 
     RowBox[{"{", "}"}]}]}], "}"}],
  Short[#, 2]& ]], "Output",
 ImageSize->{453, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//Short=",
 CellID->2129950114]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["$System",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$System"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Version",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Version"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Options",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Options"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CurrentValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CurrentValue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ControllerInformation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ControllerInformation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NotebookInformation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NotebookInformation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Environment",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Environment"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->464919972],

Cell[TextData[ButtonBox["Global Computation Settings & Parameters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GlobalComputationSettingsAndParameters"]], "MoreAbout",
 CellID->34925936],

Cell[TextData[ButtonBox["Low-Level System Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelSystemOptimization"]], "MoreAbout",
 CellID->44788964],

Cell[TextData[ButtonBox["Mathematica Session Information",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSessionInformation"]], "MoreAbout",
 CellID->555268268],

Cell[TextData[ButtonBox["Mathematica Sessions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSessions"]], "MoreAbout",
 CellID->331825866],

Cell[TextData[ButtonBox["Mathematica System Setup",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSystemSetup"]], "MoreAbout",
 CellID->505273546],

Cell[TextData[ButtonBox["Namespace Management",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NamespaceManagement"]], "MoreAbout",
 CellID->143379270],

Cell[TextData[ButtonBox["System & License Management",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SystemAndLicenseManagement"]], "MoreAbout",
 CellID->46633977],

Cell[TextData[ButtonBox["System Information",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SystemInformation"]], "MoreAbout",
 CellID->108298974],

Cell[TextData[ButtonBox["Tuning & Debugging",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TuningAndDebugging"]], "MoreAbout",
 CellID->71121675],

Cell[TextData[ButtonBox["New in 6.0: System Interfaces & Deployment",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60SystemInterfacesAndDeployment"]], "MoreAbout",
 CellID->999951765]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SystemInformation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 25, 50.1904884}", "context" -> "System`", 
    "keywords" -> {
     "allow internet use", "available add-ons", "base directory", 
      "byte ordering", "character encoding", "classpath", "color depth", 
      "command line", "command line arguments", "command line parameters", 
      "configuration information", "context path", "creation date", 
      "current directory", "debugger enabled", "default format types", 
      "device information", "directory path", "DirectX", 
      "downloads directory", "files loaded", "hardware information", 
      "home directory", "initialization cell warning", "initialization files",
       "installation directory", "installation information", 
      "installed programs", "IP addresses", "Java running", "Java version", 
      "jlink", "J/Link version", "language", "license ID", "license server", 
      "loaded classes", "loaded packages", "load on demand", "locale", 
      "machine domain", "machine epsilon", "machine ID", "machine name", 
      "machine number limits", "machine precision", "machine type", 
      "mathlink connections", "mathlink version", "maximum kernels", 
      "max license processes", "notebook indexers", "notebook path", 
      "notebook security", "number limits", "OpenGL", "open links", 
      "open mathlink connections", "open streams", "operating system", 
      "paclets", "paclet server", "parent process ID", "platform", 
      "platform information", "process ID", "processor model", 
      "processor name", "processor type", "properties dialog", "release ID", 
      "screen information", "screen resolution", "screen size", 
      "syntax coloring enabled", "system character encoding", 
      "system discovery", "system ID", "system probing", "time zone", 
      "trust by default", "trusted path", "untrusted path", 
      "user base directory", "user documents directory", "user name", 
      "version"}, "index" -> True, "label" -> "Built-in Mathematica Symbol", 
    "language" -> "en", "paclet" -> "Mathematica", "status" -> "None", 
    "summary" -> 
    "SystemInformation[] gives detailed information about the Mathematica \
system being run. SystemInformation[\"comp\"] gives a list of rules with \
information about the component \" comp\". SystemInformation[\"comp\", \" \
prop\"] gives the value of property \" prop\" for component \" comp\".", 
    "synonyms" -> {"system information"}, "title" -> "SystemInformation", 
    "type" -> "Symbol", "uri" -> "ref/SystemInformation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10188, 290, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->66677799]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 44665, 991}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3483, 72, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4106, 99, 1582, 37, 70, "ObjectNameGrid"],
Cell[5691, 138, 1605, 48, 70, "Usage",
 CellID->15818]
}, Open  ]],
Cell[CellGroupData[{
Cell[7333, 191, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[7811, 208, 314, 10, 70, "Notes",
 CellID->24471],
Cell[8128, 220, 320, 11, 70, "Notes",
 CellID->7342],
Cell[8451, 233, 84, 1, 70, "Notes",
 CellID->347864858],
Cell[8538, 236, 752, 19, 70, "2ColumnTableMod",
 CellID->310899023],
Cell[9293, 257, 293, 8, 70, "Notes",
 CellID->293782271],
Cell[9589, 267, 562, 18, 70, "Notes",
 CellID->50336697]
}, Closed]],
Cell[CellGroupData[{
Cell[10188, 290, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->66677799],
Cell[CellGroupData[{
Cell[10572, 304, 147, 5, 70, "ExampleSection",
 CellID->59478609],
Cell[10722, 311, 113, 3, 70, "ExampleText",
 CellID->83487619],
Cell[CellGroupData[{
Cell[10860, 318, 108, 3, 28, "Input",
 CellID->963689088],
Cell[10971, 323, 25286, 420, 305, "Output",
 Evaluatable->False,
 CellID->1982358692]
}, Open  ]],
Cell[36272, 746, 126, 3, 70, "ExampleDelimiter",
 CellID->1791168283],
Cell[36401, 751, 102, 2, 70, "ExampleText",
 CellID->739568735],
Cell[CellGroupData[{
Cell[36528, 757, 184, 6, 70, "Input",
 CellID->296380309],
Cell[36715, 765, 659, 19, 54, "Output",
 CellID->2129950114]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[37435, 791, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[37754, 802, 1738, 62, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[39529, 869, 319, 9, 70, "MoreAboutSection",
 CellID->464919972],
Cell[39851, 880, 192, 4, 70, "MoreAbout",
 CellID->34925936],
Cell[40046, 886, 166, 3, 70, "MoreAbout",
 CellID->44788964],
Cell[40215, 891, 172, 3, 70, "MoreAbout",
 CellID->555268268],
Cell[40390, 896, 151, 3, 70, "MoreAbout",
 CellID->331825866],
Cell[40544, 901, 158, 3, 70, "MoreAbout",
 CellID->505273546],
Cell[40705, 906, 151, 3, 70, "MoreAbout",
 CellID->143379270],
Cell[40859, 911, 164, 3, 70, "MoreAbout",
 CellID->46633977],
Cell[41026, 916, 147, 3, 70, "MoreAbout",
 CellID->108298974],
Cell[41176, 921, 147, 3, 70, "MoreAbout",
 CellID->71121675],
Cell[41326, 926, 193, 4, 70, "MoreAbout",
 CellID->999951765]
}, Open  ]],
Cell[41534, 933, 27, 0, 70, "History"],
Cell[41564, 935, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

