(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15542,        526]
NotebookOptionsPosition[     12118,        410]
NotebookOutlinePosition[     13443,        447]
CellTagsIndexPosition[     13358,        442]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tables and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/TablesAndMatrices"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Tables and Matrices\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ArrayDepth" :> 
          Documentation`HelpLookup["paclet:ref/ArrayDepth"], "TableForm" :> 
          Documentation`HelpLookup["paclet:ref/TableForm"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ArrayDepth\"\>", 
       2->"\<\"TableForm\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TableDepth", "ObjectName",
 CellID->10324],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["TableDepth",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/TableDepth"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["TableForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/TableForm"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["MatrixForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
     " which specifies the maximum number of levels to be printed in tabular \
or matrix format. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12274]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["TableForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TableForm"], "[", 
   RowBox[{
    StyleBox["list", "TI"], ",", 
    RowBox[{"TableDepth", "->", 
     StyleBox["n", "TI"]}]}], "]"}]], "InlineFormula"],
 " prints elements in ",
 Cell[BoxData[
  StyleBox["list", "TI"]], "InlineFormula"],
 " below level ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " as ordinary lists, rather than arranging them in tabular form. "
}], "Notes",
 CellID->18133],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{"TableDepth", "->", 
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"]}]], "InlineFormula"],
 ", as many levels as possible are printed in tabular form. In ",
 Cell[BoxData[
  ButtonBox["TableForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TableForm"]], "InlineFormula"],
 ", the levels printed need not consist of elements with the same list \
structure. In ",
 Cell[BoxData[
  ButtonBox["MatrixForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
 ", they must. "
}], "Notes",
 CellID->22885]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->270867334],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->128635367],

Cell["Format a tensor of rank 3 as a table of lists:", "ExampleText",
 CellID->136721940],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"TableDepth", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->183350669],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWNtOAjEQ7W5ZiBoRXwyJL3yIvOqTH7EhJvBgNMj/43YBbQ7TTm9bEJdk
2Z1JOzOnnV7mvNab5dt7vVkt6tnLuv5crhZfs+ePdaOShRDFkxDicSqa723z
1T7qN28eIQbqXx50W3Hd/JWNeAP6O0JW7SrQTyL7Y7tTxyPbUZKgRWuHKA/e
7gkrlJ7rh7NzeyZxlOSoKLkSx/pyr0crQ089yqPM/nD0Lx0vPcuttvqR2zbH
tsytVH5dEZ5NeqrdqMMY3GxzuZFilMyR5B4reyRhI7bLrhK00skW5uQEZNzd
ydmK9jIGGc8OlHG3DsOK2DCqNFip89EHa7Gl9g4lDxxyg/OO7ccd2XU5Af4y
npgdHmccV0OaNch5wexHLGn2ae6WilGlwcrNLofVfEtTInobMiPlkrMhdvGu
iSeCyxp08Yvxo51QPNwscXjoWcKzgs5T3/X/EGTVLXt9axXaN+0rDS7adhi6
3ayZqmell/u49bqq2r+nlnZS/N6sXKtj3Y5uz+ZPf5v87apf9Tn3+upZBXv/
nlWg4uhZhf+AN+bOaapx8/AJvt5zMgn+yPKNz7mxB7FVVNiNgasZumEPqFst
nmTpsXK1YM8eXAKelDv5adZgHvYAZY5HTIOV40TTsgcpcjbEblfsAfZDP6Hs
AWe3G/YgdnawvubsdcMYuK2LWCx5WQK9PrKxBNhOanoflkDvb2MJsJ3NH7IE
ovgG+qFkvA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{316, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->138779546]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23024],

Cell[TextData[{
 "Use with ",
 Cell[BoxData[
  ButtonBox["MatrixForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->289012416],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["a", "##"], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"TableDepth", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->143149236],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWMFOwkAQXVpK0Vgl8dKLws3oh+jJGD+hISZwMBrkH73zQ7hbisLrdGd2
aExLUrqzM/vmsbO7ffS5WC/e3ov1cl7MnlbF52I5/5o9fqxsVzwwxmzsdZMb
297aVnlttlt7v3XfsbPLj0nBnjL+hxPH5yWLDHrH9suZMfQnthkRfRh3yY0f
/vZVkUMCoZFRbTSVx8uJRmBZlfNkEujFqDPKnxxi2/YOheyN7P1KjvHH2jaw
vhcSbkcIo3Be9fFeTuT81WYRo1yFqPWH6GgjbtoSDs5s1/iNCH78LJdZa9XH
vSThEu0r3wqab+b7wFlWDbRjksvhynD2mOGSqVBG4MdfcK7imjJZZVwRBW3k
Sp0l9ZpSNRoStXdxUcXd3SdMHHnmMicJhYd13eM35decPLV9xc4SvfvuyF5U
O7KdLMPSsXd+Z95X96mgNr54HYtXJiv6ZVkw6gVs1Fjox71JZ/nudVTOzNmU
8Z+qv69FLKmd3KTFJfo848YH6/MjRip9nvEILCvZitU9yfx6fSLHCNLrJLcA
vU7yCtTr+pO1S3q463q9zadvt7RvH/W6rBqkrjyZC62BJWrQp4Flp5xvvTm/
TK9zKJxeJ1e5WK+76EN9jjod/Vp9HjWMR13eFKdbg7p/8P+vx3XvH9rW4zoW
oXqczoKoaIfqccyye2+2e49sBj9KCv/Q\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{210, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->547070090]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->351969742],

Cell["Format rows of a matrix as lists:", "ExampleText",
 CellID->337560346],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["a", "##"], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}]}], "]"}], ",", 
   RowBox[{"TableDepth", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->193913254],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVV11Pg0AQvPJR0ARs1MS+VPpr9Ml/YExIY9I+GLX2sf8db2nRcxh6x4km
NKHc7M4ty+7BHA/lbv38Uu42q3J5vy3f1pvVx/LudatN4UQptdfHYq70uNKj
+thXlT7fyn8ouP6pwoJv6lkZWFP9JzAEe0xsucmNvuxHa+TMDgi7zkvFYEXW
GfPHZmw9rqPINS4Y+zsTPZieYho4sGCadysKsqQykjxGSyzZJH88D/s+ZX7r
3QW0Nxib5SwdSf5hdsoy7n3fiEN6bTO2YLx25jQrAZx7zcJOsXXZrharRkSq
2jxTsw4/9ix35Nn8gVPWfFUuelivBslD/AILOF8PEv3JKwqyHgHT56UV5X3U
rDngwoIvvSrb9SZmqpuZXKvqdrOZ6rp1FFfXOWD+xmtUeMbYVIUps4cK+z+J
Y1DhId93Y1Jht/umGtY7c67Cp2osfq7CtlmYMe2cswoHx5qn1U/1bey4c84t
frfV57cH/I3a+u1FXdXWLzqqLY9i23Wh2mKUwzfF4dtPTT4BzMKO6w==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{124, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->78507082]
}, Open  ]],

Cell["Format the same matrix as a row vector of the rows:", "ExampleText",
 CellID->396236230],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["a", "##"], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}]}], "]"}], ",", 
   RowBox[{"TableDepth", "\[Rule]", "1"}], ",", 
   RowBox[{"TableDirections", "\[Rule]", "Row"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->556580989],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVVsFOwzAMzdJuHYhlSCDBBbYrPwIn/gAhVRPSdkCgsc/ePwQ76kb06sxp
NSatUjM7fo6f49TLa71ZfnzWm9Winr+s6+/lavEzf/5a01QxMMZs6Z3eG5I9
SeF99N6bgqXwmJmiP3XE3/FghjCLekXDkFSLOBILmJvE2HI/Tw+Dymy0FdAO
9HGzKnKQeLkYq/JKoyVeI9CDvYXCXb0EvdhR38ciOXhxzGsJ/ceMhNEhZKRj
FVG/Av1Cyi7JcyqhRZ4isgNP3PWQZytbCSWd5Uphk/oGjuWHvLEK58Ib7Tar
KgHVOlPa2syZT1J1Au+xxPhAvc4/o7xKYleTu5jGfJLlFZ8atrteXv36sIVV
cPfkDNCr8jkZaF6Ygfg1ZXXCsolmm4x2/x/xPPZ/p9hzOlmZqFMcXzszLhP3
nx3qocPsjbIvx4/QL1O2szqD31uFf66fzEq7Lb0r0dEu3w60m+4b6HjjRLt8
89smRjP4Be2UWD4=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{236, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->613855715]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5084],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArrayDepth",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayDepth"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TableForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TableForm"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->11909]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15038],

Cell[TextData[ButtonBox["Tables and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TablesAndMatrices"]], "Tutorials",
 CellID->12170]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TableDepth - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 25, 51.9249078}", "context" -> "System`", 
    "keywords" -> {"tabular depth", "recursive tables"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "TableDepth is an option for TableForm and MatrixForm which specifies the \
maximum number of levels to be printed in tabular or matrix format. ", 
    "synonyms" -> {"table depth"}, "title" -> "TableDepth", "type" -> 
    "Symbol", "uri" -> "ref/TableDepth"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4461, 153, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->270867334]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13215, 435}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1263, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1886, 59, 48, 1, 70, "ObjectName",
 CellID->10324],
Cell[1937, 62, 794, 24, 70, "Usage",
 CellID->12274]
}, Open  ]],
Cell[CellGroupData[{
Cell[2768, 91, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3246, 108, 529, 18, 70, "Notes",
 CellID->18133],
Cell[3778, 128, 646, 20, 70, "Notes",
 CellID->22885]
}, Closed]],
Cell[CellGroupData[{
Cell[4461, 153, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->270867334],
Cell[CellGroupData[{
Cell[4846, 167, 148, 5, 70, "ExampleSection",
 CellID->128635367],
Cell[4997, 174, 89, 1, 70, "ExampleText",
 CellID->136721940],
Cell[CellGroupData[{
Cell[5111, 179, 288, 9, 28, "Input",
 CellID->183350669],
Cell[5402, 190, 967, 20, 62, "Output",
 Evaluatable->False,
 CellID->138779546]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6418, 216, 216, 7, 70, "ExampleSection",
 CellID->23024],
Cell[6637, 225, 196, 8, 70, "ExampleText",
 CellID->289012416],
Cell[CellGroupData[{
Cell[6858, 237, 337, 11, 70, "Input",
 CellID->143149236],
Cell[7198, 250, 927, 19, 70, "Output",
 Evaluatable->False,
 CellID->547070090]
}, Open  ]],
Cell[8140, 272, 125, 3, 70, "ExampleDelimiter",
 CellID->351969742],
Cell[8268, 277, 76, 1, 70, "ExampleText",
 CellID->337560346],
Cell[CellGroupData[{
Cell[8369, 282, 327, 11, 70, "Input",
 CellID->193913254],
Cell[8699, 295, 767, 16, 70, "Output",
 Evaluatable->False,
 CellID->78507082]
}, Open  ]],
Cell[9481, 314, 94, 1, 70, "ExampleText",
 CellID->396236230],
Cell[CellGroupData[{
Cell[9600, 319, 383, 12, 70, "Input",
 CellID->556580989],
Cell[9986, 333, 728, 16, 70, "Output",
 Evaluatable->False,
 CellID->613855715]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10775, 356, 310, 9, 70, "SeeAlsoSection",
 CellID->5084],
Cell[11088, 367, 457, 17, 70, "SeeAlso",
 CellID->11909]
}, Open  ]],
Cell[CellGroupData[{
Cell[11582, 389, 314, 9, 70, "TutorialsSection",
 CellID->15038],
Cell[11899, 400, 147, 3, 70, "Tutorials",
 CellID->12170]
}, Open  ]],
Cell[12061, 406, 27, 0, 70, "History"],
Cell[12091, 408, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

