(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    133415,       3420]
NotebookOptionsPosition[    120772,       2968]
NotebookOutlinePosition[    122210,       3008]
CellTagsIndexPosition[    122123,       3003]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Making Tables of Values" :> 
          Documentation`HelpLookup["paclet:tutorial/MakingTablesOfValues"], 
          "Tables and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/TablesAndMatrices"], 
          "Formatted Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormattedOutput"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Making Tables of Values\"\>",
        2->"\<\"Tables and Matrices\"\>", 
       3->"\<\"Formatted Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MatrixForm" :> 
          Documentation`HelpLookup["paclet:ref/MatrixForm"], "Grid" :> 
          Documentation`HelpLookup["paclet:ref/Grid"], "GraphicsGrid" :> 
          Documentation`HelpLookup["paclet:ref/GraphicsGrid"], "ArrayPlot" :> 
          Documentation`HelpLookup["paclet:ref/ArrayPlot"], "PaddedForm" :> 
          Documentation`HelpLookup["paclet:ref/PaddedForm"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"MatrixForm\"\>", 2->"\<\"Grid\"\>", 
       3->"\<\"GraphicsGrid\"\>", 4->"\<\"ArrayPlot\"\>", 
       5->"\<\"PaddedForm\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Layout & Tables" :> 
          Documentation`HelpLookup["paclet:guide/LayoutAndTables"], 
          "Numerical Data" :> 
          Documentation`HelpLookup["paclet:guide/NumericalData"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Layout & Tables\"\>", 
       2->"\<\"Numerical Data\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TableForm", "ObjectName",
 CellID->5507],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["TableForm",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TableForm"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints with the elements of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     " arranged in an array of rectangular cells. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8007]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
The height of each row and the width of each column are determined by the \
maximum size of an element in the row or column. \
\>", "Notes",
 CellID->17584],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TableForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TableForm"]], "InlineFormula"],
 " prints a single\[Hyphen]level list in a column. It prints a \
two\[Hyphen]level list as a two\[Hyphen]dimensional table. More deeply nested \
lists are by default printed with successive dimensions alternating between \
rows and columns. "
}], "Notes",
 CellID->10951],

Cell[TextData[{
 "Arrays in which all sublists at a particular level are not of the same \
length display as ragged tables. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->24855876]
}], "Notes",
 CellID->23101],

Cell["The following options can be given: ", "Notes",
 CellID->14489],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TableAlignments",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TableAlignments"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how to align entries in each dimension ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TableDepth",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TableDepth"], 
    ButtonBox["Infinity",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Infinity"], Cell[
    "maximum number of levels to include ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TableDirections",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TableDirections"], 
    ButtonBox["Column",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Column"], Cell[
    "whether to arrange dimensions as rows or columns ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TableHeadings",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TableHeadings"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "how to label table entries ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TableSpacing",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/TableSpacing"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "how many spaces to put between entries in each dimension ", 
     "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->24958],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TableForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TableForm"]], "InlineFormula"],
 " acts as a \"wrapper\", which affects printing, but not evaluation. "
}], "Notes",
 CellID->15441]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->172160645],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->532572952],

Cell["Show vector, matrix and general arrays in tabular form:", "ExampleText",
 CellID->388738335],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"Array", "[", 
   RowBox[{"a", ",", 
    RowBox[{"{", "2", "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->729883225],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwyACxtAQDkP0fyAJj
mf//gTQXkGQCcrmhNDNclIEZpAoMwLLIfEawKiYgyQrTgyQLE2fBqgtqBQNM
JbpODD4rnA/RSAVz0V3MitN/LFjsI8Qn3T3o9qO7D+EekCC6ajYCpkN0o8cp
KWELSyUsUBew/EdOLTJ4ycGdwqgfl8SZSL+0Rbx7sKUt4nSjxybxumCpiglq
N3qqYmAEAIEzgS0=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{28, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->1934098]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"Array", "[", 
   RowBox[{"a", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->546923698],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVcsKwjAQjI1VtD5BRPDi1+jJjyhi0YMo6v/XPNoaxo1NSvQgCk27s8lk
d9qM2/R+2J/S+3GXrjbX9HI47m6r9fkqIN5ijGXiWi6YeM7Fk7qyPBf3vhgj
ESYy4hJXPzYu8HlNvl2xmNmSdQr4zHFepFjlGAuQE9m43NvAOxZ8EIhHV6Vp
FKgRnIFxXMV6oeKVXfdgNu6XWFe779F15/DqDLWcBOkFWccQx2TdcmwTbBgj
G/WdhODxVxP7GgVRE1mxbuo8aDUliKs7EA8d1HThwapIrV4chv7q694M+g/N
MnRS91lX6YO8qCAqujb908xz43xq/8zejn+P/qRHU6c9nDvb2D/ly75e1awL
9Kdf9eXvqIn/nX6+3ERNFx7yvNf6sm816DaYb+rF8j7J7V5c5m1ezFoPNj3y
Bg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{102, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TableForm=",
 CellID->46373496]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"Array", "[", 
   RowBox[{"a", ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "2", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->359268233],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWEtuwjAQNSShaiktlSrUJdfoBdpVDxGhSrCoqCinyKVTOx9ivY4ztmOC
VIyUhBlP5uNJ5vH4yI/bz6/8uNvk6/dD/r3dbX7Wb/uDVCUTIUQhj9cXIb+X
8lt1FGUpr3fyPJXiXEmJ0lcf8UjIym7laJ+eouirbdRlc32C9WdH+2kVRZ0z
qUyI1azNRdPPHPX3Z/ZfV1G7r5S1Bi1Qzk5yfWPlV+3SLVi3+hvjXbr13Mqq
PwNzJPs83HcF+7ME+QHkzKtyjEK9AX1Rumc2JbyjzHmnntVz+HXvBtaNu4/d
wX216wZG4eqi3uG6G0qJ3mYgL0Am5xF0w8YvlzW513+mK/1Ooq+F1b7iJKZ9
077sInQ1tHiRNNm2Ez/RZsaKsNOvaanjTtF7jth3fdhH6cdFPS6D8HjHzfQw
eIdR6boi3oXpBod3GNXcDR+8s+mGD95hHDNWuOMdl/MQpLN7ivowbtrsFodx
ul3EuG71f2IcNc3GYnam2JfhdNwcD8PpUOZm97VyOi5iGE6HMve7xo3TcTX4
cjr0i378OB2XrR+bw/WwPE6f6H08Tl+PPC5i3BgMzg/dwnO3obM7DK5F7nbJ
bnD/T7txtxDd8ME1P+42NFs/RHPna4hlJr6GWGbia2LyCy89nic=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{138, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//TableForm=",
 CellID->1916662]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6266],

Cell["Tables of numbers and formulas:", "ExampleText",
 CellID->483114827],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"5", ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->335469525],

Cell[BoxData[
 TagBox[GridBox[{
    {"0.2830858739326336`", "0.472935592453948`", "0.2634989404568133`", 
     "3.5087640679932375`"},
    {"2.2433323069418565`", "3.678316212916811`", "4.291946524058017`", 
     "4.895804932177574`"},
    {"4.277764321761621`", "0.6571601681338934`", "3.368501539690829`", 
     "1.8816732392544755`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{245, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->164446122]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"i", "+", "j"}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", "4"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->364253162],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztls0OgjAMgPeHBw8qevHowxA9+QgeiDHBg9Eo78ejYTdAZu02YtQQAwkd
3br+kH6DbZpnh1OaH/fpanNNL9lxf1utz1eYkpwxlsC9WzJ4LuHJ3ElZwhhp
KbVuLjYFIUCdo/kZ0qXZraxZkE9WWo8J7/a62c9GyGrylhdVZx7X48Kzi66A
qhNXhPU2trRizyz9NWbikMKYFEXBqksaAXq9e/yFdQ4qh3n+ko3ONQKLiWOU
ZP/43p+7j/7PC+5GPEbeTmjZlKjnSg+jVeQQTSFG2/wVsRpi030u+NgUj3oF
UW+ISfcpQjGpvO98YPB/vHyCwcaHZs3HYuUL9yC2DrGoyOp1jC4sdvuaYhaj
R52Y6y4s0hlTmdosDgz2n55+Mdiw52OR/qML/cnSFIWqdzEpyN0hcpvKaBap
LzbFZrfMXWwOTPafpt8zyfgdjNYKEw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{68, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TableForm=",
 CellID->317738783]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"RotationMatrix", "[", 
   RowBox[{"\[Theta]", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"UnitVector", "[", 
       RowBox[{"5", ",", "2"}], "]"}], ",", 
      RowBox[{"UnitVector", "[", 
       RowBox[{"5", ",", "4"}], "]"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->711306018],

Cell[BoxData[
 TagBox[GridBox[{
    {"1", "0", "0", "0", "0"},
    {"0", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}], "0", 
     RowBox[{"-", 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}], "0"},
    {"0", "0", "1", "0", "0"},
    {"0", 
     RowBox[{"Sin", "[", "\[Theta]", "]"}], "0", 
     RowBox[{"Cos", "[", "\[Theta]", "]"}], "0"},
    {"0", "0", "0", "0", "1"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{149, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//TableForm=",
 CellID->11583865]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->196508329],

Cell["A table of lists: ", "ExampleText",
 CellID->745442669],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Outer", "[", 
  RowBox[{"List", ",", 
   RowBox[{"Range", "[", "4", "]"}], ",", 
   RowBox[{"Range", "[", "4", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->285294656],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWttu1DAQzcZ7aaFdCk88lp+BJz5iVSG1D6io9MvgA0ucrGF1Ms6Z8SVZ
pFZqGiczJ/bxeOKc6dfD8/2374fnh7vD7Zenw4/7h7uft58fn7pLbtU0q19N
03z62HTnL91Z/+t/fne/w+lw9tYfXbj70qyhfQntd8T+zcL+OB6rP+tPbX5u
zpxfbDt/oCz5+23XfC94++voX9oeoyJmL41Oel6p8X2YmQ82m61qNv1TfXMD
17fdYdM12VMuFsLbRa6zNR3Duzxed0aWsb94fxPBTeUjhrergKfhV4uXyq8u
inurzd927zNw4VcOxoD0TMluGnUXvTs3NrIzjY35s01kB+22Am4O+zG8iyze
Y6h5sxlDTeF6HP2MwR20r6GNaxjvo/8VGR3zx30Hrvk98fesbRW5DPshvds8
Dj6P8RHzYzwEP9z34fhjflfKcWN75Q80R7Leoz3OYml/vI9rA1lE/35tqVbs
1FN1bxLmJY5lhMK+B3QouA9E3nQo10nspb2dQ9a0jj/4STtljd/N8S+ud6kf
bZjl9b/r+dHkRojWSBojWNmQ+yDxwj33ZobSImbuXFM7V532v0SWWgOeNarQ
H79dGT/ob81JU/2vl4dq5nZdPi2JhTHHR3eOkbdP4g1R0tivE4VMhfVWbiIL
S2sp2DuhV1Z7aa274xr2/WFf6Bodqj3OrGZ8p29fzfhO8S32YTdgVSAGVdSf
ot5uP7NG1KtiPy8//6dib43oVwVftl9awQ/+66RZ9XlcUoBTlea58FKV/Bhe
LSV/Tj6W4FeLl6fkW720CmyuXZ7+WwZVq6PUUvCXqKLkqfnLVWhS52B4Y1vr
AEypYYo23rcq22wPzxR+qX8lFH72Tcx4Yf5WHUraQVj890pe+lWTnUtzvt1L
3GeqEduNp2nY1j127ihTVG8LS8w/jaU+Gy4eYaySpsHXVgBG+atoJYBlYIbH
RsCYkZ6vqQGIGdTEzHlEUu4qys1VpXXY0hUSUU02+OdWWKwVkvOIqnzdWY8y
d4TVrJakqf71Ky9WDocotEZd+O+gWH1ayjXB3gm9stpLFYCgf5WoAKRWOCzj
C/gWe22Fo/8O7xsaTb9Z/QE2Tsv2\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{434, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->710901200]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"%", ",", 
   RowBox[{"TableDepth", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->37815891],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWdtugzAMTUkv6tb70x77G/uB7WkfgapJ7cO0quvH9e9YEkHHjIOdC7BJ
qVTAjo+T2Lkcwlt+Pb5/5NfTId+/XvLz8XT42r98XpRKjoQQN/V/fhLquVBP
5n8rCnUf66vUsvmJOZDXhDy0vTS9kED7oC6ZErdAvxzILkNbOVEXLUL9VF0m
opkbWFtX+Fmpn3ji5xY9HoUpYqVjCDNP9cbmZ2aaetebNtCx6cfbIxahRsSg
VkdwqsQVko+6DL1XOKp1NtwG0XNwi/IOozQqsPGQoRGG856KeJde0Nnt7GWJ
amGL8Dlj5PGP7N6zpgcqu7QH3YaMsW40kauGhheHupVPfiHeNbOx8WsgDxMF
3sjsxwsvIlCr5awcV9iIxCJU2Uukllj2m/KOzmdxa70mpjYcU9Myxoi4TKsr
PJep2fBuTA3fx6qx7crX2r358az+ffoxuBlRJ8XkIH4BZIrRQTw6Vx3wupzP
8GDr2vYArDw2Hvae2rXR6HoyufrO4LpnY+sXxdrgTkStHJW9iZEHQ/truQrF
18v5We7ybcSPZ3Xvy4+5aa0U9ncJLH+VPYeJ+dpvi8Tcfmv/B3PTWoxhcZlX
V3guc7PhE3MbhrnBOuG+TTE3ar2hmBvE74BMMTeI12+wfObGec912e1D8SHn
LfdyT+YGMw1PYzmn7+Sq64C3nXVQOFOemF1idmxfidklZtenXWJ29ijYTr5d
OZ3Njx/z6sebH4Oj1h2KwVH7PsXgIJ46waHwOlqJwbWPKN7cCe2L6xdUrH7u
mVxjBAZ+PY3R/9BchuLDv57GiEL4d894XvyZWtsZMcakKnuJ1BLLflfQTE2M
vgH/b/aZ\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{184, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TableForm=",
 CellID->37553695]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->307306740],

Cell["Format a ragged array:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->24855876],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Range", "[", "i", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "5"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21924417],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzFUt0OwTAU7jY8A5n9eBLhgrjwDJRIuBCCFxAXHrvOurLl+GadSizpTr+2
5zt/31xetpu9vOzWMp2e5HG7W5/TyeFER4EnhLjTmnUF7RXt9LorRfb9L4Lc
ZF9AKyTYJtsnm+HE2NBYXz/XThlU+tO3ov3ChhKfJsy3B195ME6f4RRwdQjG
ZL1Klohhu4ySj5wxyNQnqGO1ivOis7iTPBeea1jCwrCV793nE1lF8E19sakm
UoVefOPVenWrSn3f6zF1rpN3OoGMtorD+XyntAHkslcY9uex65SFWVyUlDPW
KSd/9TvFjJ3rGEGGOmUMoVedIrBX1exxbZyTx8QxmnekapLjH01QNsgTv+Uz
WlnNBHPxGSyter9oXAPv6sqxm1eYwT9On5Xdytl6D+xJhow=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{135, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->132662504]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15275],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "TableDepth",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->532],

Cell["By default all dimensions are formatted:", "ExampleText",
 CellID->27010148],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"e", ",", "f"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->874568247],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytUskOgjAQ7UIT3NcQj9z9Dz35EQ0xgYPRIP+PM3SoBSqIsUln65vpzGsv
ukivN11kiY7PuX6kWfKMT/ccQpIzxiLYxwMDuwSr2lFZgu5KATIAwBS0As2r
KJNGoVyikMZBU4xE4MLD2WAd0UJMvBko63rvjjde7Jaw/MP0faxg3pzu6O8z
RKGsT2N3mVz8Geftw+XAZtWvjJzVUW5P9w1v52DGcoZNh6SH3/db3sbkuf/5
19qCuueNqvYPB5RaLTPlulXFXLCiWsphifEXLIjIoA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{22, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->115636833]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->203951038],

Cell["Only use tabular formatting for the outermost dimension:", "ExampleText",
 CellID->501087176],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "f"}], "}"}]}], "}"}], ",", 
   RowBox[{"TableDepth", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->246466859],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVVdsKgkAQHV3tBmVFho8+Cv1HPfURIkE9RFH9v+3aGDGdpVWDSHDcM+6c
ndk5rtv8tt8d89uhyNPNJT/vD8U1XZ8u2qU8Isr0vUpIj0s9qu6sLPXzYQNj
lfFWFw0FjgRWVZQS3pE2voYz4ffhbIMDel+7p00I/JjFB9Emh4Hwh5BNRkv2
KWB/xZ41J1PBxCkHWFH4xNWctlwGK45239PYaS3JFfNaKIdaZzb7K/0ZKKvr
817Bvjh2K+BM+ta3zbUYQS6ZvV2Rn7kafHFvsWM5y5mvPgcmvGfcXEJ7gBmS
D9VivS55vX/SK9JlyP4up8vX9Ip10VK1tTIwR1e1mnqhUhqdqhSwVAnVheMX
Asu/Ctbr/LVHFr2SdwcgGzl1\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{40, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->136065204]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "TableDirections",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->10761],

Cell["By default the outermost dimension is a column:", "ExampleText",
 CellID->194365554],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"e", ",", "f"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->234241432],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytUskOgjAQ7UIT3NcQj9z9Dz35EQ0xgYPRIP+PM3SoBSqIsUln65vpzGsv
ukivN11kiY7PuX6kWfKMT/ccQpIzxiLYxwMDuwSr2lFZgu5KATIAwBS0As2r
KJNGoVyikMZBU4xE4MLD2WAd0UJMvBko63rvjjde7Jaw/MP0faxg3pzu6O8z
RKGsT2N3mVz8Geftw+XAZtWvjJzVUW5P9w1v52DGcoZNh6SH3/db3sbkuf/5
19qCuueNqvYPB5RaLTPlulXFXLCiWsphifEXLIjIoA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{22, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->7838572]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->230687880],

Cell["Format the first dimension as a row instead:", "ExampleText",
 CellID->285974128],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "f"}], "}"}]}], "}"}], ",", 
   RowBox[{"TableDirections", "\[Rule]", "Row"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32962944],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwqAKxtAQDkP0fyAJj
1f//gTQyyQoU5gGyQDQnlGYEyzAwQygQyQQimCEcEJMDRLDC+RCFDNxoqpgG
tTkggNUcZB3EuQYahiAaWRx3eAqimcmJ1Q6QeYJQc0HmM8PNwoxHXCQT1A1c
UP0gc1goiGMuNFXMxJmDxOfBagIT1F3o5sPSJkXuxRBlhNuJHCbcUD4TjrBk
YAQACFit7w==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{37, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->821262589]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "TableHeadings",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->5469],

Cell["Specify headings for rows:", "ExampleText",
 CellID->237827221],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "f"}], "}"}]}], "}"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<r1\>\"", ",", "\"\<r2\>\"", ",", "\"\<r3\>\""}], "}"}], 
      ",", "None"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->323318069],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNVtsOgjAMLQO8oCZeo4++G39Dn/wIYkzwwWiU/8ddis5SbpKgS6C06063
9mzjEMbR6RLG52O43t/DW3Q+Pta7612aXAcAtvLZrEB+J/JLP9skkdK8Z+rt
KqtusCywgmuEai6qSnaJt7J7Ug2k9KV09DDBeIH/0hG6Q7zoqBHXn/GiM/Ja
Q1ULGuSiCVyhYLIm2HzwWCa0bhZq0dzSWg0+atKrVIMpO4d+wld/hnYToQ6/
2rVSNqfVo6tPMzfE/kZMzngFrJXfMbSmLIMsfVgD2yd62T4sw+YYTmMUZMT2
euF+x3oPWZ/iODXZv/gYk8f6uRXhP/jdnPXK3kPJn4iVWNOI87+PYN9mZYyn
Y6vPVmCO30zLsp2yO++k0neGZ+zwPrEyO4uOnzB4hvECmWD3jtGu84d/E+A8
AYkSWzA=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{45, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->604516693]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->444614298],

Cell["Specify headings for columns:", "ExampleText",
 CellID->136879370],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "f"}], "}"}]}], "}"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", 
      RowBox[{"{", 
       RowBox[{"\"\<c1\>\"", ",", "\"\<c2\>\""}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33602098],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytUkkOwjAMTNKFVSo7BS4c+gvucOIRFUKCAwIB/y924oaQBEoRlWrHrmfq
sbPN74f9Kb8fd/lyc80vh+Putlyfr5AKOGMsg3eVMjgXcJJvVhTgXSvAhlDQ
Bx+Bb8osC5RDO0YTqACPrZoV+ODHQSWPsCp6XgRWlXzPjlNv7Yxqm2/Uf5oK
4ob0j0ZlrwmaSMck3Z3m6M913j6MWGhUuWmcm2CvLErfwsLGMjun+l9miAIS
8tX7/naGdXDm/f6VG9Xb+Viz67sdEoV8lNqphWrL7IQ4u+7kJPa7uxnQXDtW
zCs12XHbOxvhzbrsDR+bEUe+v9diiK34XwqxM06auJ4trjG08B3KxwaCOX36
75iqbdHOR7QtYWyU8Qc8beBT\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{36, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->785128598]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->530018099],

Cell["Specify headings for rows and columns:", "ExampleText",
 CellID->687548857],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "f"}], "}"}]}], "}"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<r1\>\"", ",", "\"\<r2\>\"", ",", "\"\<r3\>\""}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"\"\<c1\>\"", ",", "\"\<c2\>\""}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->450242684],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdVttOwzAMTdN2tyKhrUiMy8Ne+Iq+wxMfUU1I2wMCjf1/iROnBPeslw1t
EpHa1I7tuD7HaV/L/ebtvdxv1+XqZVd+brbrr9Xzx86o4kgpVdC1VOa5Mk/2
KqrKzO6e0z0mrR3qqUWrYjfRiFmkeSysSZ8YcW7m1MwT66aBlUprmUOPhJX0
uhHyFMaWGSVni0ovtDgYTfMbalA1DeuBY7mt7QiituXmsVr8wmTSC4M7mMO0
wujfs97tMIRf59VKNnv05Nv7yuW8Pq7RPJLNDas51OKukbhCFgVyPiB2KuSu
XuyKjVgu92ipSGhVxz2O+QkzX6sf3Ovq9eyCR1Sdg13wwLv9py4g/TXP+ITs
xaCT+H/5HcKvWxf7pW//bLVqZuYY1+wAyfhDJ5j9liRMfTscirMO/6WQrb31
rRkerN6y/qoaysXC5nTZrvC18nzPhBxBL4yjxGUGrbBvyz4tSEkk4Wl7clS5
/vc1obwjrgKO7rtQxstYPwoiNL0zIeNexr6UMfGb/hn9ien/plX0DfjE+sw=
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{59, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->81001380]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "TableSpacing",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->32503],

Cell["The default automatic spacing:", "ExampleText",
 CellID->102370557],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"e", ",", "f"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->534913025],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytUskOgjAQ7UIT3NcQj9z9Dz35EQ0xgYPRIP+PM3SoBSqIsUln65vpzGsv
ukivN11kiY7PuX6kWfKMT/ccQpIzxiLYxwMDuwSr2lFZgu5KATIAwBS0As2r
KJNGoVyikMZBU4xE4MLD2WAd0UJMvBko63rvjjde7Jaw/MP0faxg3pzu6O8z
RKGsT2N3mVz8Geftw+XAZtWvjJzVUW5P9w1v52DGcoZNh6SH3/db3sbkuf/5
19qCuueNqvYPB5RaLTPlulXFXLCiWsphifEXLIjIoA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{22, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->218090509]
}, Open  ]],

Cell["\<\
Explicitly specify the spacing between rows and between columns:\
\>", "ExampleText",
 CellID->84581312],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"e", ",", "f"}], "}"}]}], "}"}], ",", 
   RowBox[{"TableSpacing", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"5", ",", "2"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->289595654],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzzTSzJSM1NLMlMTlRwL0osyMhMLlZwyy8CCjEzMjAwyANxoAQDkP0fyAJj
+f//gTQmyQQkWYAKhIE0K5BmBIsyMEMoECkOIpghHBCTiUQVIACSFCFoDhOa
CiGsOkAkzDyEi6WwqpWGqmXE4fvBQ8J8JQr1Ff6QEQQRrHA+NKAx406Myuqw
ugM51OG6YOkKFEswUUa4rCwKTwZJzUDHA+FYAgWTIJQmnIaJjSlS9CHnWXLN
ZoK6nhHFVHg+ZYFqBQOILyXRTIFYIAE1ixUplBgYAbkRQIk=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{31, 81},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TableForm=",
 CellID->50225060]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32729],

Cell["Display data in a formatted table:", "ExampleText",
 CellID->15516363],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"5", ",", "7"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "3"}], "}"}]}], "}"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "\"\<Group A\>\"", ",", "\"\<Group B\>\"", ",", "\"\<Group C\>\""}], 
       "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<y1\>\"", ",", "\"\<y2\>\""}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->421643955],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWM1OwzAMTpN2rOvETxk/B5AmwXgELtzhxCtMqiak7YBAY+8fktbeMsel
3WjLJCp1ThzbcVz7q7vXbDV/e89Wi1k2fllmn/PF7Gv8/LE0LBUIIabmfroW
ZqzNKL+nWhta/N6YX2WYV3ZmBzq/xCRfvSXcS1ZKgg1laATUzkNDpYCByC8z
CA1JQOKI2JPEwhBoXBhQBUFJEa01YYOI5Uq6C/I8yZjl9oh+yHjtaw1Ybv/3
J6nJjYmX/b1OcUykegU/XPuviydEY6wO238n/pYj8Ug7eCyZU9N83s/nIVj3
sz6CFeThUBGf/KqTmJEdRJRG5Y6103xVWQ2LLg9A6Q4K4hBpDl0eifSkVe7f
4G4MkjRPMSKnsN4ASjWIt3R+wmp1jKyVXlvdnpmeET5UdVcIWstPX+qcSPnR
bRo3QyYv8+3CzVyIEaMpmsbInbDKrl+Q9TYwUWAuVaDfvS6vcXvCVP9H1FPb
K4gDJNcUk2GHhYX7VmubWBgxftJ5SuZQtx2goNv1CKYuanraEvK5PRjnHWYl
RZimcS+p4cdPtVmNeJOKuNMdUjaOfqcnkUts2XWLl5t+ZhekmubBaR4H0fNU
b7DJl6K9MF/fVVr4NT0s4QelVrBLdvn4VcJXJG/LfaaCsUmzjv0G4K1udQVU
L6mU4P3la5fq8j2CPVsAkXCsh66c/xaiWV/+rkLbvtcJmfNdAq87gKc60g7+
wn9DIvgGt+ZW5Q==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{94, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->254625441]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->7759639],

Cell["Create a multiplication table:", "ExampleText",
 CellID->173850812],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Outer", "[", 
    RowBox[{"Times", ",", 
     RowBox[{"Range", "[", "10", "]"}], ",", 
     RowBox[{"Range", "[", "10", "]"}]}], "]"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->129605735],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      StyleBox["\[Null]",
       ShowStringCharacters->False], "1", "2", "3", "4", "5", "6", "7", "8", 
      "9", "10"},
     {"1", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"},
     {"2", "2", "4", "6", "8", "10", "12", "14", "16", "18", "20"},
     {"3", "3", "6", "9", "12", "15", "18", "21", "24", "27", "30"},
     {"4", "4", "8", "12", "16", "20", "24", "28", "32", "36", "40"},
     {"5", "5", "10", "15", "20", "25", "30", "35", "40", "45", "50"},
     {"6", "6", "12", "18", "24", "30", "36", "42", "48", "54", "60"},
     {"7", "7", "14", "21", "28", "35", "42", "49", "56", "63", "70"},
     {"8", "8", "16", "24", "32", "40", "48", "56", "64", "72", "80"},
     {"9", "9", "18", "27", "36", "45", "54", "63", "72", "81", "90"},
     {"10", "10", "20", "30", "40", "50", "60", "70", "80", "90", "100"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxDividers->{
     "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
      "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$, TableHeadings -> Automatic]]]], "Output",
 ImageSize->{246, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->361725868]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->910112257],

Cell[TextData[{
 "Multiplication table for the cyclic group ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["C", "5"], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->429506165],

Cell[BoxData[
 RowBox[{
  RowBox[{"c5", "=", 
   RowBox[{"{", 
    RowBox[{
    "1", ",", "\"\<A\>\"", ",", "\"\<B\>\"", ",", "\"\<C\>\"", ",", 
     "\"\<D\>\""}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->656865022],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"RotateLeft", "[", 
      RowBox[{"c5", ",", "n"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "0", ",", "4"}], "}"}]}], "]"}], ",", 
   RowBox[{"TableHeadings", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"c5", ",", "c5"}], "}"}]}], ",", 
   RowBox[{"TableSpacing", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->188409282],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVWM1uwyAMTgJpuz9pW5tpxz7NdtoD7BhVk9pDtanrA+TNGQ6kS103gQAp
RQpOTII/sP0F+Cj3669tud+syuX7rvxZb1a/y7fvnVSxNEmSSl6fr4m8F/Ku
viohpFT1I9QMtHVJth1aLhX3qGUiK9AXUuZSPksJzQmvP9HlSbcWujVTjbkS
uitZ7lDvU6h4+5UX9MYcqvzwrPux0aZKsgMWha5lY0ahOumnIJDl3Vhab7NA
KBatZ2hfRIeGN6hinw0P0UrFiF2cduUgWMtaEkbXZB0/9GCT8eNqwceMmNeZ
1s+FDddojnGOoXmvV93Y5oFCgWPGkW1CWTXLpzGtc9Lzlx1tqLgzYxOFJ9Nz
c0tg4TqXujhEzWkMLEFrc4I3JuJ41XGWP7Sv6tlSwo/3vHGJ15gazC2XRYGz
7zjLaw0RA4CAWmH4sBnXDDii8cA/Kj76MrGLbdRQYuATWnu62rghRtq//8FM
5DWzvPn3GBUUaMR/kKmw2eeYRfr/P6sd79S60H41HxrBcLaJZdQMabHHccyH
iDqYBWAEvNeZCXpvgxkldiYxzSqz85SGT9g4/jPwajYYiSuXDIvhYScDoRGY
c8m1jtrlRORc1PVxx7nzkYZD7LmjqrPysrziwhi4r/EYwsSyH0bos+Q/F4ZY
tM34+EYVIqOxTbtMrlRX6R8yZuun\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{128, 89},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TableForm=",
 CellID->372307298]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->37157736],

Cell["Create a table of graphics: ", "ExampleText",
 CellID->25289756],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "@", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"SphericalPlot3D", "[", 
     RowBox[{
      RowBox[{"Evaluate", "@", 
       RowBox[{"Abs", "@", 
        RowBox[{"SphericalHarmonicY", "[", 
         RowBox[{"l", ",", "m", ",", "\[Theta]", ",", "\[Phi]"}], "]"}]}]}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"\[Theta]", ",", "0", ",", "Pi"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Phi]", ",", "0", ",", 
        RowBox[{"2", "Pi"}]}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", "0.6"}], ",", 
      RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
      RowBox[{"Boxed", "\[Rule]", "False"}], ",", 
      RowBox[{"Axes", "\[Rule]", "None"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "100"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"l", ",", "0", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"m", ",", "0", ",", "l"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19039535],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{475, 453},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->235378316]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17107],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TableForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TableForm"]], "InlineFormula"],
 " formats arrays in a tabular form:"
}], "ExampleText",
 CellID->198124043],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"e", ",", "f"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->220858554],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytUskOgjAQ7UIT3NcQj9z9Dz35EQ0xgYPRIP+PM3SoBSqIsUln65vpzGsv
ukivN11kiY7PuX6kWfKMT/ccQpIzxiLYxwMDuwSr2lFZgu5KATIAwBS0As2r
KJNGoVyikMZBU4xE4MLD2WAd0UJMvBko63rvjjde7Jaw/MP0faxg3pzu6O8z
RKGsT2N3mVz8Geftw+XAZtWvjJzVUW5P9w1v52DGcoZNh6SH3/db3sbkuf/5
19qCuueNqvYPB5RaLTPlulXFXLCiWsphifEXLIjIoA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{22, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->34158201]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["MatrixForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
 " formats arrays using standard matrix formatting:"
}], "ExampleText",
 CellID->216510616],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"e", ",", "f"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1671103],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"a", "b"},
     {"c", "d"},
     {"e", "f"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{46, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->63003257]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Grid",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Grid"]], "InlineFormula"],
 " formats two\[Hyphen]dimensional arrays as a grid:"
}], "ExampleText",
 CellID->173343638],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"e", ",", "f"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->387237740],

Cell[BoxData[
 TagBox[GridBox[{
    {"a", "b"},
    {"c", "d"},
    {"e", "f"}
   }],
  "Grid"]], "Output",
 ImageSize->{26, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->450284313]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->242496653],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["MatrixPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixPlot"]], "InlineFormula"],
 " to visualize the structure of large arrays:"
}], "ExampleText",
 CellID->77644622],

Cell[BoxData[
 RowBox[{
  RowBox[{"b", "[", "i_", "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Binomial", "[", 
     RowBox[{"n", ",", "k"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", "i"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "0", ",", "i"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25776438],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"b", "[", "5", "]"}], "//", "TableForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->887147311],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztV0tvgzAMDgWmrS3boCDt2F+znXbetaia1B6mTV3/f5aAUzzXvJqAWgmk
YJyHPyfx54T3/Lj7/MqP+22+fjvkP7v99nf9+n1QVb4nhNio8vEi1LdUX0XZ
SKkkfgu/FPrxVVko1cgQmjl9Seq9wkxhTFfL4hFz/QpPOkAtSa+ZRa9uCLx3
j5y3jvxqs30rHpl4iBx6Umez3gOsu/akyfa1eqTHzmAFAxil9VBW7KQ67leS
/jwb1L1plojA7hxkBvJZltnA7PCMXT8aiffsSmSkV0x0nvn1eehOqQ/smBha
E0uErtkpZmtXFuhF1ASVXiIHxuq/FhscHMOn+aH2jLS7xKLMSC2wDH+eQJrT
LAU9kRW/qji+nC+GDwZH2w9B4nqeL31ii64CH2t99oGyleYxystbRDT5MgKZ
OkcYf07jRg0+kXBEr9CKnkf65YzSvoRIJgjvUkaxe9Ixe/fO1g1n/FC4dH5j
zZfOj85/KNy2G+9QuONGF8c8zDieEfbMWxD73ZhHV6HPDck9Ayb0Cd09OmYk
ZmYzU9zdLvsx0v7PZdy7yuTD5MMQPjTdYNtYK7w/ghQ0Qw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{96, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TableForm=",
 CellID->198250254]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{"b", "[", "99", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->784481],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztXemfFeWVLmprCE4MihkyM5lkMpNJMjNJxmzGGKMxShTUKLsIyCYCBhpa
aBpawKZpoKXZXbJpVkmUVQUVEAUV2Rvww3yaD/NhfvNv9JznOed9q27de7sv
DbYS299rX/reulXnPGc/76nqe6Ytmv3wvGmL5syY9sWfNkxbMHvOjMe+OLy+
Qd6KBgRBsE/+3z0skH93yb/4/76uLnkt/zlUfkZywLXyGstrKK+hvH4Wn+KN
Lvcf3h1qr5G9Xlf4fYidLSy8fw2vhaODyJ+T1wwS/d3/5HfLjsooqXDEZ/Aj
zR9R+bghNR53dbdXrETj1RX5G9oj5UMM9SDx9NgVrvmY8nRdD98aUunzkuvW
yhmOCyueYUgf8VKdAnwSVfzk2j6Wx6WjmbdC/2af65nzLEWPUtkPuaPCKt8a
Uvi91A9V84X4dLM/KoiN4CAIyj1aUhG1zxV4G1b4vafPh1U8K65ZyatG/Lxc
oj0hHvYh7XFN1CFoDcDrpXCU+72j0ud9QgV+DZJjx555/72nZB1/d/OJdzYE
4ckj7UFy6u01p99adebwSlln33w8CM8eWhqknQeXnDuw6PwbDViv1194fV74
wWuPBskH+2ZfeGUG1t6Hzu9+MAjP75wQJOd2jDn34v3n/vIzWZ3b7w7Czhfu
knP86aedf7zj7B9+gvX7H5/93a3h2d/+KEjO/vbmM8/fhPXcD8785vtBeObX
3w2S07/81ulnv35q27/KOrnp80F4ov2aIH2/JTr1+IDzS7D+a2Hw3z8Pwv+Z
Lbz878PB/82wJf/Wd1P5WA7So+Vr8mWeJZHz6YnlCnIdu6JcGxSQFKEpIHWp
kAliSbWQL0yQm0T4UgbB6Y4xxrlgIEgoJIJNQJRSgUtAU/QERgGTqCaCrwIt
iAvuKoFUZCESUdGIjExefaij2Tfk8qFQEaSqIkKeLNWQUMgmB8KJLFUQQeGN
BkHhDWiIsI61X1C48MpMQWHv1PN7Jp3f9YCsczvGnntxVCjwCZJ/vqfzhRFY
f7qz84/DBfc/3C5n/v1tgP53t2CJIMKzz/8wSKklN575zQ1Yv/6uCC88/ew3
RGuf+urJLf+EteFzx9d9Jgjfb02F6pUDTi0fcKYZ6+zSAZ1LB4TyIpJuxvuy
5AAcGOIriXxVTiBnkoWThlCNVK6Ca8lFZYliPP9D01pQdiu14zYQHIL0BCwI
I8LRn+8Bc6FwGaTCLdgW5vdMEhQEjRCwJAKP4ATteAPaIUcLhIlACUwFWaqH
0PHWqiAV1AV7EYJXj1CkE39kPqRfSz5ZWmKBPHCxvizPuFh9WCaroA8LLrw+
3+nDHNGHV6EPL4s+TFZ9OL9j3LmXRos+3CcxRtDbPhLrBdWHTuqDCy1Y1Adx
5KmIA55dpUOVoNSS07/45uln/l3WqW1fObnlS+J/N34+iE90DDvx5FARtqzw
+NqrVe7yFj7oGCbH8Fj5jpxBvi4nkVj1y28hiIRyetEGXOkHclWs394shIRC
D7TVBZI/3K40v3AnIsnIc9CD+7BeGi1o7BgXpFSFycI91qszBRCNuAKRAMXV
QOwEQzmzwJkLJkKdhJNUVUGkoKogcklLJdVVOQNVUV/TvVSPtsuiVFtFqk9A
qstzUl1cItULr/1clkn1YUh1GqU6EWunSvVFSvVeJ9W7JNTCXu4wqd5mUv3d
LS4yP3+zJQ0q29/cIHH8e2K3v/r26V9ej/WsiPc/BIunvyaWse0rp7Z++dTW
f+H6Z/kZyu/iE+T9p78mSw6VL8Cer+c55FzmQZ67UeT63A/oV+SicnEsWnYo
dJE+pAbMDpAchMIAeRGehDVZwqPgsWuiyBVCnSYgyBI8BJVQ8CFOLkFYDJFK
hrCMmAq2ArEszRCOSo5WyBCCuoJ9f+ZDk99cL7/p5/dMOb97ItbO8edeGiPy
u194ZsKHRUdt/k48nxkmbVN4EyGmAFEM06d+z90YIv1LALy4U1kQpGRnp39x
fRDBzJ79BjxuJD/kvW/Cfq8304O4YH2UP/K4G00vnr/JYoIXmU/oNIIIgXDH
6pGRqzLaIKl7aYxwhrV7omCxZwq5ptTmygIir88XjBYAI0hNBQexhQKl0EHB
CcJwyiK2EEl27E1R1sB+ufXLLZPbuQNFub0Gue2bJRy8Mv3CXpHbg1g7J0iq
wJyBcmMa0bl9hHoecZqJlVniMrF+nJObBCNGJRWdeLUbI8guPvPrG7z40jO/
+g4roohvyQc3IK59H0cLOhSOj22+SrqFasIr0hsaJeLGhbLtI/KZToJMZ+cE
5UbYQuY3XXjcN0sYVs41yikiKh8VEQSk6KmIFFVWrwJzEPmSKRh0WWR0plxG
j1WU0SMmI6mCJ2HtUhm9RBndh/iu+UpORsPNvGhhATOEWNNY5gw3Q/9DGEKc
JS8qLzGVG/AaQSKRl4haTKwZh9oNz5q6vEMudzvtxtewI5UyZh6jhLsdY4W7
XSKaSShjUclON+5MNMI2RSM4hAAkMbkcWnaGoQp5aCu7CCoXDVUBUY5UNP3S
+cRJp+ncwUw6C3PSeTQIP1DpzLDCT2u/HeNCpML055JGIStEaIJ0kDH/aXiu
k3SbICsiiq0QJLihSUikk4Wqmwapz4PM8JZ8AC8WwY0lhTgTMLNLXdNnOBdi
TYhgo7nd/Yw2o5GuS273gPBmhZt2fx5x3R9zZwtlCQQCheTsTczZIRWX4WnO
nqhgfM4eoH67qlfyeFJWjfKo1wLT5DEb8phphZdm6TvHizzGqDy060WDCUxT
0dkbjqKGNqPYxa4Qu4WarjKJIZPIy4SC4O8aUGgjKjvWTLeggr41H1m0zkvV
ThBdEGBgJ/n4bynALsb/yVIzvYxqWhjDAo/CK7py9SYRCkVQ0ZxbJeKzAOTc
T5bn3J/uvUyOFGTSLKsHmeyHTF6daWWTrN0qE3gECalWPNJMIJMR2mNgw5WW
cjv6JT+BTG7z9THwFd3/0VWCN16jErx/7PC2bIu1DdadaofOCuSycn1ZQkoo
NEmFI7RpkYM6RyrX2a5ynUeuDHXh9SA9VJOw7w1BPVQqGAlSxT7G1f2Yf+wx
39ID5ocE88YM8/MFzOcA84fBxd4plvHunGCYSyUt9bSsv9zb+Wdgvn2EZpjq
frDuUOxil/4CVERZNOIGCt4x8XdRl2hr7GXGqr0571ZG8CpyNcibhfyOsZq6
Cuq7H0Svckq+lhcW6FkSNvu9uxduhWv4++a8axF/fwQ9GkIuuMlS1zLkUhE/
XRviEpc84rM0PbIMadcD7EElcKUa5ejwra9hPVhVTXax/kjEb/c1B+IxNk6A
NpQ7ohQsnhJsXZrrMKKjiBvpOmGsE+7n9YUO6/3tniR+e+9Dmsm9Ogt4s32C
vSjhibw5Z94IwMWbNxOH076DcqTEm2/JvPk1l4D52tNve8xXnH2zWZZcvlMx
X6SYo9U9X/MeZAVzWe1o0uMb3rRk7p29NAqLzkXQFSVMXEfsTkVe6/NY3Yzq
MNzMYME5dh0pl1DeoTJiVgtHcpc12KjbcoFU00tcd4eGTaFkzyTxHS6V0cJM
0Bfitf/o1Zv9x0aJx4eahG3hXxbgFkQEGGQz3qFscdnMtf1YXylYr5bI0FKC
9dI81g1WauWxlrxXk0fLH3dPdHvCY7UVqu4EeNzDXVTu6tyliCt2kbpyi6C3
RwLwIEEar5GPjOrwGRxdFspGkCuZzIek6rbRbkDHAVEyFMoEWySEj2CxdAry
XVhhj9u09NxLxWsRboEC6+3VAk3ei3jHXTb30ku0D9eI9qOKNlMUZikIl1KJ
YB8aOyVj6L+h3Kp93EODco9QzLWailz4vEO77TGTeFup9duQdYclMdJ6b3dZ
ZjKSZ7fkhPlJwIohpQO3Xo9QKHRyXych8tjq0fIoyHXkgDyWQB8KDEEqiCjy
Cr7g5XpymQv/bD/2nyTs989mmjgdi0mLVeA7x2uSBi8r5m9VofYPbGNphPqL
yGXrzGCGXyUIR+rpcwgzr0/5zbu1EaETH9Y7gmMZr37c5yeJ6zbPxmK1KWSn
bt/Oz4A00rck8C2HV3iUg7wv986FvvxvLwXlUyUoY9OYKC9xKB9QlOu1BvIo
z7HUUJtn4jvRVE/gSkW1VM+pbdyRta7A3Yq11kRxLpTeCe8+SDDGK+DXT9Uk
to9kfZOq8/aajB0K5qLmvrXOEZjZM04sEVRlBt1Cv+i9AH3Ae/ElwmmIUabE
UH6r5RR1uUouWJwhu2w4L0Yv+zFXaJbgPNdSFGuDTWZ9kUCtqF9MVEa7rJjJ
imtasg4aGbIzRa1+wcCmhwHSsXqaFzKPQblQpzVgZrkJG1oMmUhPzKbgPCYT
diQpuiORYDfFDSYAdPEhC+UcSMCtXd/J8QSp/1agW0/MnQsJ8j5E91T+rh/1
jw3qmBKobb7jkqRAvyjpl6WMr8zUsj+EK82koG7G7RxZLXqvyoI9EUhCgB4x
UJDGa6QR0VJB89kuG6RHUefl8u/dzL+nWPOEaaHmsolWl76BojV0alALa4Ra
mFWuFWeF2naktuR3pP6+FMUCxtxTVKRrmGCuPoHVg0TOlksE3QqwON9L5FGM
dbKroeFVu6jQSMkmZO0cx86TdehHsSXDpvBf7tW8Pu7MAsHdUHqxhO1W4Qcq
L/SyOjVXh8d3MrpPz2jmMNbmJiY4e7B9j5en2362NnSzPcPX62kRiVqE29ll
LuP9vzeJKv7/86XY1jAPl1y07MomcEVsG40elZsGKk52gfbUdrkOLsai3ITT
etaIfjNFp+gEl4QBeyqyUiamuj+RemviGs085sX7IpcjnXPiELkg6SmREG0p
sGNfzPks2KZOLFke5LLNvVNdjM6SoXylVdJ91zmmtHSOCaLK5UMbZeXyoX/o
yt3fUAPuSYlvK5+BK0zYltrUxko2tdLZ1DK1qYOZTYG7gk3tdzZF2XAyQW3q
AfN12EcCnLFVyWx2XqnS+ceK3q4c9brL5/dMRieryqipIKMFWllARvNMRnOQ
EmhWgGpp7xTu6lnmCdc3PnDdaDUh9uG10rgP1Qb6xXUW2e91bvFnGuUthlEs
rpc8Xv2bdvAnadebcWiGi/guvX1tXr5Ws61E3bjSabFUheNT3JNZn2JjSZ/i
i33g4S5RSo2Qkt5wkEnpdZMSUwZXfk/Xqou9pgfNntih3znOuk5jXONplFjI
i/fHIgxYir76rGC0+UUGHZvmzwzGao6XaTEztW3Ele0mltR351Df2S6vH9IF
s6FwLRZjWYIZTdkO/Bd6KaGLytz6JXHxkuiqlLV1W6UIyuuxHMqrakO53nHD
IRbdu2bwmGH9y71TbFyCQOs+YKKpmY/wiCej4HXqBN3IvM8oHxps/5DVdT46
sJPBuTl2pXV/C5nWXNeX9knxgmwiHdsu2FhcpkAHnPVOeWsLXBGBXi945PNi
eKMvFTS5hsrPY7ru1NttOUyX60wdd38685gu1Mojj+mjtoMEZz9TMJ0GTB9y
W72TdHrAekqCkTU8NO8dMxjgpqakVk2My2q3XRNxBivfqK3TdKZin+1babDV
3cILbrcwm+gWytHl57wbR4Cz+f42YVq5V4Ut6uuHjKYLnagaNFfwaGK6Ul2B
ZRaiPbqJS4eg889a103wpR2yk7GIqLEUvxGmsuR37VziEHbtkSBNtNocgE6x
qXhOP+EeATgBFsa+pVncEfTdfOcHlpfMyrdhVn6dYurTGGQxX+5H8yNG84Sc
pgxNHV3QzW2P5uIMTUmRDE27wYgRAgn4rBDNlISdhqmuRJqk+/kx70d4QIvc
2PlTM29aOJ0B7s0wGGnocJiazeOUTN3oNWfZDIkGJ9ez4VxrsUYt3a9WJOk4
23BP4LogPeHM3SdxX7lMWD5hWLLtbneTVMXSlNMlyrqbgHpGeydwn1MC7mjG
jCUTFaNI0JICZELEfgvvgthtwHFNQY9BPTD29mdqDs67RbIJunl+uhG1L6cZ
SptezRJx/Pw2sFNnGYTCs8uBsyr/q32AX4PGc+tKl+IH43a1+kxrscPEH9KZ
9ciiEC1994MDiSJ2mHZP4j0kChp7ITBd3jvHWk6Nd//c/M7DPBeqdXMzmw11
TSwMpvi56lUWZI6sA3AhGhMlPcOv9SP3cUQObaFFOeTOK3LzM+TgAudoVamZ
JKtcgKc7V/GFPVMs/9kzWTCbFBtuEXfNeSeFwqb7bkwNc1VqFjPMY5x3GaLL
xBcrrYqcgmfzZ6vQP21T5NTZlfVP/+3yobdCJxry6DXm0FuYQ4+q54Myp5Vj
bIqJl5L1yozIMsepVCoN0FOoaIivrOZV2/ZODexY4MZvvzpLe8375+pdnubm
rM7XnayFfh6B+fWSbNeQXKiz06ibGHxVa5l+BPscweNlCLYqgtzz1RIw0PpU
EdQUSxEUMy5DUGowBMaEuSHbiQRRK+KYgXiqpjZ1uhu9l9mdBmj2zeVgzrWq
y4PXm8Ozcl60NNLm95eAni/xfD89NyltuUoizB7P5SrsBn79suB2uiJunVVw
qzfoXPDQPR10Oq1lAegUj4gxBGlMMFA17GWGFcvkZvrdhkfYKLV+Q66Cm5+L
E9k+kQ5TNFlV7Hflshs6c/nJ8UJ+8s0PCbFDDrHFDrEG11MsRSyI9AkfqFdn
K2rMaYFExMgLcAQv5tOvzCSeszKLnM35ARd6zDStu1wSFx7T3ahU02DfP+C+
mr/Tq81HB4kLxbj6n/1Y9TVW2JqqgNWSIlYLJR+zwZJ52n2J8wmJ+TJFTDvv
gttA5hWvIk/ZN8uMDmuO7stGHqIg10Ex47N+VGl10GR3d+ZmQFrzPist+Czh
/1uXhtOaHE72KB3DaanixHQNEfOA4ZQ6nOZ7ly/cqmqpy+G0Nu7PCZkBi+pE
xOyRC9QieY+f8UkBGg8/ANQ/z7Cab3e9LLDajkMy7p4Al9PmuneJQmX3wlb1
Vd+uHaungdXWnrBCaZ/HqtHiN/Tf6ZTfs5YfkQ+RhAv8R4JDyvsg9s+J+LtY
aOQTBH7PZQgL8q0N7RdblsoJ+qwD1+LvO82yfLOwrcKbWth3+tHoNRrvl6DR
TjTezqOhZU+GRmcBjQabAfezbAoHeVVrCGLhvU4wiIlBiX3Mq2Ajru7jM1ca
86Wf9htS23J7u1WWPn/FW4mw877DIvheRSRq2bE55pDZVEBmdXVkmlzgWqzI
iJtJbdPT5j0ADrABNIMFi8jyGY07F3iUiz4L7Qxu0qjRMhtO1vmulUNitbuX
8Ug7HesmWUJ/QE5y2fR3S3ntutwTMZ8Q3Ppk/zaPZYesbrHkfZR6Y4abWFnk
70BqyO2918M6ieZVgmJkKLLrkxRMUHeZUm54I/lxGyTNruu3MhvQd89Sk1qk
QzHEEhZQi3y/D9DL5nuOPY31HoBD9OygdBlQV3PKZ5Xtk7Gedo9FAnJL/K6g
T6ics5ccKksU5n+auuh0z/Ig0703GorVG7Ih92yZx1n+5jr3q/0TpChjQPfe
1qL2fa+rN3M3SVe1p5FWmruhtr1Xqm1H1uiOLR9P+ITW0PaEQmrbUguOtF+n
LQ43p3P10C0UbALhvDRDTVeGWmKoYS3We/gwAePzI026hQjXu1ot9OEOSmKH
OLgpiIUD4UTj4E0FVCpjodMwfEpTj087rWqlf324VXzaaCXk8DP/zNWq0bSI
0doeMWpS7+0xijKbRBamdukCRL2hJXZZH+pU4oIIh8bqzBSlrJZjSPAgaZ/A
7WNk04p8OqQzSw/SzRX0Io9B9RmFi0SiOUNiiZYwRAJ+HbJ3KGAuMVWe6+33
hfzc51H04azMyLeeO/Wq4Rm36bJSd1QWDX9Y4L96hun4fbfIbxv5RWPG+F2u
d78k3hmrjfi5We7cHmjgbRMN8MkLBzsJp1CKA5mQ5RvqydX3+rClTxvi/TXk
1/asMLPlIte7m2SpnBm5bunntGdOj5Zy6sZoz5RyutQpYCNnAp0eC4MHXAf7
Kmevyr58GmXa2+g3Hv3sXXNJMvfWKqWB8+BOgd/dhI7y1iBSywU7t/aG03c6
ZJVy2lrk9PGM0ya1WZ0zipjaLrKM6jH8rhw3BIPUShsi179UH255w8Em65x7
R56rBFPrPNkAfLvQF4Jd8+XK722XwCvG1CrxusLzyvvGqHbktZO8HtRMntnn
olj4ikWUsclS/W+pPDU3h6+z/IgpEufF9CkJ6K2t1ck5IUwozEsUdd5P+rns
HZeHPZdvNpvqUns1h4itmGBtJrwtQqoRO/68VZqqBjldbfZ5h59Ja8k1Su2e
RsnMvQ9SNoM7Lo3HdWU8PmE8Li/weKiER6uZwFed8AeDDWK+p6bY6HKqJssY
jMnlubyhxfNoHU4vSM8k/Ozwfg5r45ClmsuJVtikCQu2Znu0se6ENvFZ6U4T
jVXcMqRWyndotdZVyxK/pezyaY8ajjXLhAJW2X72r7JNgqGfXjqva5iT53hd
meOVAlWZasc/cslgI/7ZiC3MuNNlAAebzE/lY6SFDYuUuSrAtZjtPrUK1njX
5eXO3V0DcUaeO1JK3xHRxdLLfoq7xgeb9D1qpB7HO6Rd3loS+VfrU9bYGFV5
Bfl4qE50RD9H5GiD3bPWLUd8oo0ypXwJ6UtBfsjM5OCSSDOUJrwfxM5lNLOe
svwzaxJZfaHdNm9UGyplaCNr5elYOU/rS3lqVU/JmZcKPFnnLD5rPhMrcRwl
Z70rRBO+6Ct0jqHFP+FvdU5Y6/XOT7OoY+CMFnVPrzk7YZwdIWdtRc5W2h2H
y23MXXuCzeCuDlLT/tOhZi8he67nCp3uNMfXYk/FYxa9JjcbtCHTvGNO8+79
ZPOyOcdLu9bNOV5Q8CkvETSFvFB/aO8Rg9gyddHwAVqNNzuGNdFfYTuCroRz
sTer0deXPFFyK2p0Z0M/u2wc8UEU6hp07i7W1FGjCtxe7Hl609lJc1S0lZU2
d9aiVaI+3oL1i+8cr889h3FrQMpyXYfKHNWVctRVtQt1xfIZVuRwYCXua+tZ
9oSEb5R7JCKPBHOTwcJzZHsAFrQyX+iyizZlGiy7eWB9yN1WNTx2HUZ1T223
ve3KfyGtQm+7Gr8nlV+/MdCqmZ/kSMKQxnQWassZzJgLyz/4HmVN+3ZTIGqd
q0/5vZC1+tcAcjaKzn5B1kX+K/OUu2OzuGdS1tf3+yAadN5/bxu9A6MR+D7a
rjGKVFrfsTXXtlFhRxYrjXuuFXRlke6dmIf1bikf2fmAaO9pN8PTbvOednRX
bleiW26yznzNdw+bpLeVSPpou07JlUtaFDbWlFvXh8f12Io2fPl53qjzo6U8
t9G7ZTxHpw+3+Erj8Mo6xx+rvMMtWOQy0EkAnsBnNmbNKcc1RaW3eTbHXxSP
F+u38/whGTf+jhh/Klb1PzHIt076EwPBWUzOuN5q0fu6nLmqmwJ7dufu0Q43
jAruyrzzuO49VlcPOwA9cLO2hJsIlEbkBiuoo3nm5SN1gnWPVme9QGbXuvOp
fCgrzuc+UOCgp8zgSqMVs1IVaF2jtsA9fz6z861Vg0wbbP7Hq4McqNF6nd5p
j42QjRzBYp61LZ9nTew9he8Yhe28J9ZTCKcsQLbGSlmLvba6irDNVe4aW+1+
847jOfjKtPYTQKV4JVIZIbhxh5PZf6j3ALfittgoq9TavOW7XpbF6g5PZF7S
qN0m94o6TJQ46o4Sw3Wq+gpjECmQrlYlpuKdLJNY7Yhd47L+fKSx3dvE24xV
mQ9dOqVPBjE9Pm4iFpCEyraBQkuU1VNrfWPCRwTsF+ZNGBY89a+Elg2OloR/
XWudyVHC/6eUDjoNc2mZxvv0j9SUeY9pF0/RFu23kqKOAkUEaC10iihF/JtU
p/ROcDugPedvN+ipOFlabo2Xgbb1IrmjnrZ1sRJ3xJDCP7Ejuc4sA/V5h8uW
N+ndSCVZ1My/KorgtKitETtx7ao1R9aJK1obOZ/E8LPeeaaN7FwkKjBPRzCr
OhX5+RccWo2GmA25dmLTXqeR70i7vUMarEfMKL3JzW1TmZ955Eq/fkcQM2t+
UqlIWB2qBjj4oQcd/g7DTV4EOOvsXlx/s8Yu0SxeP/LXp+fA1WPvQbiVTSey
0f7qjl4eJ4Rfm3tx18dQoV1/E6//DvnvcJyuj9RHrHd+oqPgw97dalbwjK5H
r7Drv5e//kZcX+DviO2KmZ7R9bsujXwRWM+reC3XjyiZgur+2u/atTdEpoOR
4gBWtf7Y5P7C0tacrOcXzpy/qlYd+Vm2Qn1drFt6ovA4KdwYoahNvRyUxOPm
jWLf1DFrqMfpBuUrop5o0YZHjb2sD4/mXvSh8n+XrBrK+LWU0i3mAd7ZxOn9
hALPqNSZ/sQlMOrpMg2st3NW7Af1isLqmDpKoYvvbIozunRttjs2C/bYUDxn
TZRe1Kz0h0Hx5Xr6U4E2yo13VpuCigKmzrpjH0hMEx8rpaSr6tOPKl1FPGNs
8cGSX8YLvB/a+RcXvtuNr0x4v9E2NRQwgD/wYtnHVke03qzb+FGfNc6ftc7y
ND3dU/YslKZe0KgLm5MSc5IcgZ7Gpb2gEQvkRUhgYn+joKxlH9XZIs7M41Q0
pdBmOR6/iDMc82dISIlPkmUt/6jO8xQrGyaKROZpV+SsqP1M6TG7pQCaxF3q
p/H+EzWdQch/BqTgteVD+sYgObK1piMHypGrazqyTo5su8xHYltibcUjB3dp
TCv+3WxgsK6r6BFxAP9CW1D8O21Rte93Ez8G13QmSLy912firkyutl5bhd9u
aCmbyC8+NX1Y4feePh9W8axXCkX46SLu5lyE/Bt+uq/bn0MNffytlnz+zL+q
UBZ7h3aVxuDrCr8P6cp2tPLvU/vL/kLJtTkeq2cX15ZSUuEI2k0N2dKQGo+7
utsrVqLx6or8De2R8iFd1fZur/mY8nRdD98aUunzkuvWyhmOq7xrNqSPeKlO
AT6JKn5ybR/L49LRzFuhf7PP9cx5lqJHqeyH3FFhlW8NKfxe6ofKvWAw4P8B
F/zeyA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 174},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->522662323]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->217655714],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ArrayPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ArrayPlot"]], "InlineFormula"],
 " to visualize the structure of large discrete arrays:"
}], "ExampleText",
 CellID->149850061],

Cell[BoxData[
 RowBox[{
  RowBox[{"b", "[", "i_", "]"}], ":=", 
  RowBox[{"CellularAutomaton", "[", 
   RowBox[{"30", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "1", "}"}], ",", "0"}], "}"}], ",", "i"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->640644695],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"b", "[", "5", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->417844010],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmd8OgiAUxhHm1rLuu+xp6qrrrl1r04tWM1+nZ6XjnxojUUDS1j43OHJA
9AfsfDAPaZmdL2mZn9LtvkhvWX66b3fXglwiYow9KB03jO4l3dXpISVZNWei
MdUlKC2pGJNNyIrWxopft0Ptorr7+iVVM1lfbKWVq9YsfpfbT9JbuZbD9AoC
EIDgfwg45Zyca8WKtjfd79KuCaSfEdaUc9kdORPlPWq97jfV82Z02rhe5bxr
NJ1H224OXJ4d02MESlCCEpQzUr4ieJci6JHa5O+qbyK4u5LoiuC7l19JWyVZ
WI3hnHsE31UKMpCBDGT9ZHrk7VMC27NFCAUYUgLbs4WvAvjNz7zK77tWwQpW
sIL1+6ymKD/2/BFKbUyqY1Kf76pNmD3C+LmbYvWCFaxgBWtI1qEo33emGY7y
4dTG9iwzh9pMtT/4tZUMbnCDG9zTc9uqhc0/GZNqsegJEDDYHA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{157, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TableForm=",
 CellID->2500990]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"b", "[", "100", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->416295999],

Cell[BoxData[
 GraphicsBox[RasterBox[CompressedData["
1:eJzdl2uWrDYMhK3sJFvKEu45+Z11Zle5DKjqkxswM/0A4tMzzcPYqiqVRP/5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   "], {{0, 0}, {201, 101}}, {0, 1}],
  Frame->Automatic,
  FrameLabel->{None, None},
  FrameTicks->{{None, None}, {None, None}},
  PlotRangeClipping->True]], "Output",
 ImageSize->{184, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->260958570]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->206397254],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 " to affect the display of ",
 Cell[BoxData[
  ButtonBox["TableForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TableForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->85637859],

Cell[BoxData[
 RowBox[{
  RowBox[{"b", "[", "i_", "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Binomial", "[", 
     RowBox[{"n", ",", "k"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "0", ",", "i"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"k", ",", "0", ",", "i"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->299933728],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"TableForm", "[", 
    RowBox[{"b", "[", "20", "]"}], "]"}], ",", "Tiny"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->371234833],

Cell[BoxData[
 StyleBox[
  TagBox[GridBox[{
     {"1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0"},
     {"1", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0"},
     {"1", "2", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0"},
     {"1", "3", "3", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0"},
     {"1", "4", "6", "4", "1", "0", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0"},
     {"1", "5", "10", "10", "5", "1", "0", "0", "0", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0"},
     {"1", "6", "15", "20", "15", "6", "1", "0", "0", "0", "0", "0", "0", "0",
       "0", "0", "0", "0", "0", "0", "0"},
     {"1", "7", "21", "35", "35", "21", "7", "1", "0", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"1", "8", "28", "56", "70", "56", "28", "8", "1", "0", "0", "0", "0", 
      "0", "0", "0", "0", "0", "0", "0", "0"},
     {"1", "9", "36", "84", "126", "126", "84", "36", "9", "1", "0", "0", "0",
       "0", "0", "0", "0", "0", "0", "0", "0"},
     {"1", "10", "45", "120", "210", "252", "210", "120", "45", "10", "1", 
      "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"1", "11", "55", "165", "330", "462", "462", "330", "165", "55", "11", 
      "1", "0", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"1", "12", "66", "220", "495", "792", "924", "792", "495", "220", "66", 
      "12", "1", "0", "0", "0", "0", "0", "0", "0", "0"},
     {"1", "13", "78", "286", "715", "1287", "1716", "1716", "1287", "715", 
      "286", "78", "13", "1", "0", "0", "0", "0", "0", "0", "0"},
     {"1", "14", "91", "364", "1001", "2002", "3003", "3432", "3003", "2002", 
      "1001", "364", "91", "14", "1", "0", "0", "0", "0", "0", "0"},
     {"1", "15", "105", "455", "1365", "3003", "5005", "6435", "6435", "5005",
       "3003", "1365", "455", "105", "15", "1", "0", "0", "0", "0", "0"},
     {"1", "16", "120", "560", "1820", "4368", "8008", "11440", "12870", 
      "11440", "8008", "4368", "1820", "560", "120", "16", "1", "0", "0", "0",
       "0"},
     {"1", "17", "136", "680", "2380", "6188", "12376", "19448", "24310", 
      "24310", "19448", "12376", "6188", "2380", "680", "136", "17", "1", "0",
       "0", "0"},
     {"1", "18", "153", "816", "3060", "8568", "18564", "31824", "43758", 
      "48620", "43758", "31824", "18564", "8568", "3060", "816", "153", "18", 
      "1", "0", "0"},
     {"1", "19", "171", "969", "3876", "11628", "27132", "50388", "75582", 
      "92378", "92378", "75582", "50388", "27132", "11628", "3876", "969", 
      "171", "19", "1", "0"},
     {"1", "20", "190", "1140", "4845", "15504", "38760", "77520", "125970", 
      "167960", "184756", "167960", "125970", "77520", "38760", "15504", 
      "4845", "1140", "190", "20", "1"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]],
  StripOnInput->False,
  FontSize->Tiny]], "Output",
 ImageSize->{458, 147},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->246726261]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"TableForm", "[", 
    RowBox[{"b", "[", "3", "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"Large", ",", "Bold", ",", "Orange"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->476591697],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztltFugjAUhisUiO52Kg4N+DLb1R6CmCUas8w4H2Bv3p26c0Z7PBSm0ytN
6Cn0/2sp/6e81of123t92Kzq6mVf79ab1Wf1/LGHS/FAKbWFY5cr6BvoHY+t
MVDDbQTtyHypCdQU6gxrjtcjTzWGOkQ11UaVQhvhHLYmUGN0uec0nnquJdYF
m+V6qhLXM8f6JKrsaIKjthatKo2jGs/lb3TXJc9VMZW/rghXq2LoQLVd7pgI
msadOnPGqJyyc8rDj0vjXVlXhunIcF/1ryqzrTWb4+eodvdkwcZ1j3xe0lJq
H6E+YA5HuHqNeWxXTXEHtJhtShjto3b2r1HTaNVLTWkozWlqoxPKKLVSxk/V
Cyfr3eqSrSis5ncXVi+ZKqzOsWa9XBIbfIaxoJGfC7GSoyNx6HIZ8l3Eil3h
0Elb4eWJs2LVicAIMZTciBXOSGEkVjgj9K/hs8J/v2ifpkbat/9x8VyMTShd
d9f5Lom1WQ+25OdIrFGS+rmItcL4jPl55KzNWxjzs3591jhjMmucMZm1rv0K
03OZuysv4dTd3bdzS8ye9+z5e+Tf3C637dnuep+UeFWDb5VeW2o=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{107, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->302628691]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->43409348],

Cell[TextData[{
 "Use any number form such as ",
 Cell[BoxData[
  ButtonBox["ScientificForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ScientificForm"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["BaseForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseForm"]], "InlineFormula"],
 " to affect the display of numbers:"
}], "ExampleText",
 CellID->141476791],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ScientificForm", "[", 
  RowBox[{
   RowBox[{"TableForm", "[", 
    RowBox[{"RandomReal", "[", 
     RowBox[{
      RowBox[{"10", "^", "5"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "4"}], "}"}]}], "]"}], "]"}], ",", "3"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70944717],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWl9vEzEMT+/PWrqxtYMHHvcpgPEAHRLwxIeoJqTtAYHGvv9xuUvW9HfO
xUl8LSAmdblEPju248S/+L5uH+++fd8+3t9ur748bH/e3d/+uvr846EdKmdK
zSql1KdXqn1u2qfup//q9tc/4lPR/i9bsqpti7atTb/UFGZc1ZZP073Tj9aG
SlOvnb7LpTJtncUlbi6XoNGJpiuf3mJyuejHy77R/4vuZfe9wjunghytnZno
/hxmRr+1IketjaaXfwlUh5M8rjn6NU3GeUP62Xlv7p3FgMrp4+xo6WugWpJU
5AqOloV+fDahXi8pvTy+4nNN9RXaSyYOaPuhJq49pWXJ6BXyVZXEtfeVPV00
z8pnnaANaQkvCBvZs8aeHqm8efbHVZyjzdrM/rkgT2a8OP0F9HE2tBx7Zp5T
3INzj5NxBtS8KIyTcQrUqFcct0XQC2h12ucXLKm4J9D2oUdpjmly0YbTS8R9
iz5L03h3K/lpNztrdnmpzRUxX63MOiqdtmLQFw5/Dn1lvFmb+KPo+hX42tFJ
67gJ9K+h33lQvTEybqB9Z9qe6i3YbxPoXzeUvfWjH7lwn2QQDp42FEYp7c4T
jVEqdy7RWAW5pWno2aeYiGeaHGsca+D5m5appOArGW2Pjez6KEMr8nJoPGHT
crYFSSWDd2jr4ikxhiJzZU2JsHJ8l7ZaeL6zZ45kRGAuMWXcT4m09rMIi4lI
bYQw0cLIoDPKHEkrwxlzYbRUDn6xMqZAjztfjOWQyIuXPY7ioaCn42TgjPFt
9EccdkHuGIl5eHFG+iAU7ZI4CPWTRF48PDIlAkJL5mo3Mz7b+c1FOTZvWTU0
CtGzq4F+DN1YFLRs9rNZH8qx9Fz+vRaxqAj7nbW8qMi2PVUsKtoMbK6H5RGR
W6Wx7aFQB9Z8qN2bj6tCKC2uHsVFRLwKQdpN8J+KTkJ5c1pOdrxaU58PjN3S
dbvpzveEh9NwCt6/466N80hDXlhpwpN6zH98KRh/eFtL3m8kYp/QjWolvEJi
/SRzA4IWtKeuDIYL+SdtzxriHH8OmFOlsTUTrUWhpkVSp14twrzSJC4drXLr
WeGIoc+wnOyUW03BmeRhrPAunVfTQm3y8NXsCH5Jwyn41t9VjTqk3CFKclEJ
t6azbPazax+qsnwtugqhHku3ZM7nP0pCfBOHIXwoSYYL78QLYa65GS+i5pRX
L/qXvpA7Hkbz4aXFvieUFBpNzSNkKjqhDFwGXaAUWiOMvLS6EfWd0Ykat/BU
mInnubR1E+s5GSk8z8ncVMTkEhI3FB13tV9FykUJFk9hriLBk84qJb+gQ490
Egd7YK4+wzhCDJ1XE8HICEXKKos773tjngZ6VK/AMcTkj4k41MerHE1ZzZHx
y/FrRmPrTULWfmburkOLMrhoqHLGfTUgRE++mhFlhcKhk6kdfQQp7ynbDlAR
colDRx+gfzPwgR7uEY6a/QazjgGD\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{260, 69},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//ScientificForm=",
 CellID->121763013]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PaddedForm", "[", 
  RowBox[{
   RowBox[{"BaseForm", "[", 
    RowBox[{
     RowBox[{"TableForm", "[", 
      RowBox[{"RandomInteger", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "127"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"4", ",", "4"}], "}"}]}], "]"}], "]"}], ",", "2"}], "]"}], 
   ",", "8", ",", 
   RowBox[{"NumberPadding", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<0\>\"", ",", "\"\<\>\""}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->508293932],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWktOwzAQdZJWfLpBsGHJAegB2HUFEhKHiCqkdoFApfcPTlJKMI49E4+d
SRmk4tgZj5/Hz3b96pdyv3l9K/fbdXn3tCs/Ntv1593j+04XFZlS2b1S6uFW
6edKPzWf+m+pP0qt9P9CFz33pPnRShXfNavmLSbfeskPPmc9aaHT+SG15bv2
Xe8Ljx+f/7xTDvGbW+r58Lv8+uLR154Zh6yJcttcU9jGffZjcXgJKTFHz8zP
j/m20h80dit7qdniJaJuSLuwuqaVmadE78tT9iMEd3gpTc/NPkx3DnRbqPOL
gFimnwOU6FPOgRDcXOaA2Yd2t53iHJB9QPaB/74PXAXELj3nQ9Cm5DgGJxdO
n1XCYYq6wuEhpcJh4XB4bE+Hwz71qk5znc4d+Tq9BtTz+avTG4e9mbr82fz4
+mfzf95EqY7ZEvW0qsZTIPsUNojCN0Qp9PmHKptQvzkQL1aR7fML/tbtWMmx
czb9mScUIc0JhxNi3idKmtP8dLidUouLo2BxQsxbMaRRa8GK4ejc5rwKyrrN
gdvTXbdjnuFoEHNCyOtkOSwGYHVEuCncFG72IOc08sJNXO9CuGlT5PoUKpci
hlHSXP5cyh4mHaLI2dq7aKJUB2z6ipztDmDXHqpw+RQtrCIH9Yu9w+jz67rb
mPrbL/2qQH8OoVl34p/4op/6gS1y6QMli6Y5F+j1ppRzgSt69Dgx6AMli1Io
frIv8FxTZV/4nZ/mvhB+bkvJfS5oMS2OhTmkhRSqjXCZB1rhsnBZuJwOcziX
MYqlTQ1yKZamP4h/m2IJ9dO1H+LHZndKiqWp/NmUO5cCCFEQ++wwfjG4MYol
FDeH3+tD5n/M+x30uxPliRobZZpRiH8CTa9jTI3zIYrY+JyPiT7iKAxEzGUU
xlAgZZ2XdR7eD1nnTSvKeyvxOT7mLZuxtIH4UR7jHphwVjgrnOUSTeFsOs5i
FEKXsga5i2i+t9mF3I3s2kMUSwguUyFU2Rd+8cpd\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//PaddedForm=",
 CellID->339877997]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17953],

Cell["A Stirling table texture: ", "ExampleText",
 CellID->750836775],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"TableForm", "[", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"StirlingS2", "[", 
       RowBox[{"n", ",", "k"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"n", ",", "1", ",", "28"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"k", ",", "1", ",", "28"}], "}"}]}], "]"}], "]"}], ",", "2", 
   ",", "Orange"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->128334620],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmG1S2zAQhp1Y/nY+SIDyk2v0Au2vHiLDdAZ+dNqhHIDbtrdQrfDKVla7
jgWFFhBDkL0WG+l51rKSL7u766/fdnc3V7vLz7e7H9c3Vz8vP32/7ULpLElm
v5Ik+XiRdMe6O9q/zM/v7tUdp/p+f36fJGX3Z94d1uZEPQQffvto2ke7Dg/x
VojT/gXijRCneYqRPMdH95Re0khC49JMJTISSZpHInxgxJtVI87VXjVthdaO
KUNrymTWtTOTJeHrx/xPKtaPP6pUmFvKzO0YUy6eCm7UI+JSfinOjV8JcW6c
Ssgv8VFuHp6yFzV9M1xN4V7BvYJ7Bfem3b+Jtj9TKqF1qU52L7GQ2EmsOTfZ
I+IhLrkaUkL+sTiXX2mJZt/7IJqhb46rBRxncJzDcQ7Hpu0t7nU/xblfc2Nz
khhwLMcYc07ykTiXpxjJH+KWe1/lvu8BnZxl1ufwoi1Gaq6WMFvCbAGzJcyW
xOzTTOeOs37unml/hpyfx9wbod4KIU8Z6K0Yifuz7d/Vi/o+bd8KVyv4rOCz
hs8KPmvi73n98isLX6t8XUt3gURTssX1rwLjvK2SnVGfw4u2sNCgrdGaPXQD
aw2stbDWECsvY7HWh+tFiDe+qkPujYrNUgdEQ8zYDA3+p0GvBmZamGlhZgEz
S0L6/zAlrxNToqVIkyfvZ2jEKE9e9tEik2krcC/RFmgzeDBgVoTnv/VjRpZh
5Ja15cjXIV+zciVPpdyKUZfyAr2WGPMStE2bg26G1kxzTei8Lvp2JebX6amV
ahkunZZjuQLLFViuwXINlidkrq+DbamH56utR3vvumtqS0g1IFGDACVVgEiO
1gxsA1IbMvLXRc7uYCy5yqks9+ljVz23ltZOW4FMiXOX2AbEtiC2JSN+GwQL
Pex3XYK1s97Ru/CEkNsI5E5B7pSM9G2TtHvQSh8+cSvtr2MbQnArEDwjI3zb
RM1hARLurt7uWezTtHRI2rvXEjSEMpCzJOdde05G9r7J2t14AaKFHp4cdD2k
RM8nEn2fhDPUbK6HfbZLONeH6yVH9iKQbCS90MMe290fWsLbI4Q/ROIjxA2x
EgTtZ/ilHnbgmR72mXbXdDaRdCQfQl6hxpX2d/bSk+4Y8WhgioEUqww1kKLm
59rfrdHzaCLYhOpN6OF7ePv9of30vwF/On96Hn38fR9zPAvmuB/m2v/ETM+j
l5f3Mja/6OfZ/ThPFJp9cWT00Va0FW1FW9z4oq1o61ltzf4AxdUjjA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{487, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->510019350]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7093],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MatrixForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MatrixForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Grid",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Grid"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GraphicsGrid",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GraphicsGrid",
    ButtonNote->"ObsLink: GraphicsArray -> GraphicsGrid (Grid)"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArrayPlot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArrayPlot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PaddedForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PaddedForm"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8472]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1790],

Cell[TextData[ButtonBox["Making Tables of Values",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/MakingTablesOfValues"]], "Tutorials",
 CellID->17013],

Cell[TextData[ButtonBox["Tables and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TablesAndMatrices"]], "Tutorials",
 CellID->30412],

Cell[TextData[ButtonBox["Formatted Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormattedOutput"]], "Tutorials",
 CellID->34733876]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with TableForm",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=TableForm"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->3538772],

Cell[TextData[ButtonBox["Layout & Tables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LayoutAndTables"]], "MoreAbout",
 CellID->13947635],

Cell[TextData[ButtonBox["Numerical Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumericalData"]], "MoreAbout",
 CellID->573182166]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TableForm - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 25, 52.8936826}", "context" -> "System`", 
    "keywords" -> {
     "centering in tables", "formatting of lists", 
      "formatting of nested lists", "formatting of tables", 
      "formatting of arrays", "tabular format", "tabular output", 
      "tabulating data"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "TableForm[list] prints with the elements of list arranged in an array of \
rectangular cells. ", "synonyms" -> {"table form"}, "title" -> "TableForm", 
    "type" -> "Symbol", "uri" -> "ref/TableForm"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7438, 223, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->172160645]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 121980, 2996}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2554, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3177, 85, 46, 1, 70, "ObjectName",
 CellID->5507],
Cell[3226, 88, 595, 18, 70, "Usage",
 CellID->8007]
}, Open  ]],
Cell[CellGroupData[{
Cell[3858, 111, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4336, 128, 166, 4, 70, "Notes",
 CellID->17584],
Cell[4505, 134, 408, 10, 70, "Notes",
 CellID->10951],
Cell[4916, 146, 240, 7, 70, "Notes",
 CellID->23101],
Cell[5159, 155, 69, 1, 70, "Notes",
 CellID->14489],
Cell[5231, 158, 1930, 51, 70, "3ColumnTableMod",
 CellID->24958],
Cell[7164, 211, 237, 7, 70, "Notes",
 CellID->15441]
}, Closed]],
Cell[CellGroupData[{
Cell[7438, 223, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->172160645],
Cell[CellGroupData[{
Cell[7823, 237, 148, 5, 70, "ExampleSection",
 CellID->532572952],
Cell[7974, 244, 98, 1, 70, "ExampleText",
 CellID->388738335],
Cell[CellGroupData[{
Cell[8097, 249, 186, 6, 28, "Input",
 CellID->729883225],
Cell[8286, 257, 480, 12, 62, "Output",
 Evaluatable->False,
 CellID->1934098]
}, Open  ]],
Cell[CellGroupData[{
Cell[8803, 274, 212, 7, 28, "Input",
 CellID->546923698],
Cell[9018, 283, 653, 15, 62, "Output",
 Evaluatable->False,
 CellID->46373496]
}, Open  ]],
Cell[CellGroupData[{
Cell[9708, 303, 222, 7, 28, "Input",
 CellID->359268233],
Cell[9933, 312, 883, 18, 92, "Output",
 Evaluatable->False,
 CellID->1916662]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10865, 336, 215, 7, 70, "ExampleSection",
 CellID->6266],
Cell[11083, 345, 74, 1, 70, "ExampleText",
 CellID->483114827],
Cell[CellGroupData[{
Cell[11182, 350, 217, 7, 70, "Input",
 CellID->335469525],
Cell[11402, 359, 935, 25, 78, "Output",
 CellID->164446122]
}, Open  ]],
Cell[CellGroupData[{
Cell[12374, 389, 351, 12, 70, "Input",
 CellID->364253162],
Cell[12728, 403, 681, 15, 70, "Output",
 Evaluatable->False,
 CellID->317738783]
}, Open  ]],
Cell[CellGroupData[{
Cell[13446, 423, 366, 11, 70, "Input",
 CellID->711306018],
Cell[13815, 436, 965, 29, 108, "Output",
 CellID->11583865]
}, Open  ]],
Cell[14795, 468, 125, 3, 70, "ExampleDelimiter",
 CellID->196508329],
Cell[14923, 473, 61, 1, 70, "ExampleText",
 CellID->745442669],
Cell[CellGroupData[{
Cell[15009, 478, 203, 6, 70, "Input",
 CellID->285294656],
Cell[15215, 486, 1338, 26, 70, "Output",
 Evaluatable->False,
 CellID->710901200]
}, Open  ]],
Cell[CellGroupData[{
Cell[16590, 517, 166, 5, 70, "Input",
 CellID->37815891],
Cell[16759, 524, 1084, 22, 70, "Output",
 Evaluatable->False,
 CellID->37553695]
}, Open  ]],
Cell[17858, 549, 125, 3, 70, "ExampleDelimiter",
 CellID->307306740],
Cell[17986, 554, 112, 2, 70, "ExampleText",
 CellID->24855876],
Cell[CellGroupData[{
Cell[18123, 560, 245, 8, 70, "Input",
 CellID->21924417],
Cell[18371, 570, 637, 14, 70, "Output",
 Evaluatable->False,
 CellID->132662504]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19057, 590, 218, 7, 70, "ExampleSection",
 CellID->15275],
Cell[CellGroupData[{
Cell[19300, 601, 225, 7, 70, "ExampleSubsection",
 CellID->532],
Cell[19528, 610, 82, 1, 70, "ExampleText",
 CellID->27010148],
Cell[CellGroupData[{
Cell[19635, 615, 315, 11, 70, "Input",
 CellID->874568247],
Cell[19953, 628, 510, 12, 70, "Output",
 Evaluatable->False,
 CellID->115636833]
}, Open  ]],
Cell[20478, 643, 125, 3, 70, "ExampleDelimiter",
 CellID->203951038],
Cell[20606, 648, 99, 1, 70, "ExampleText",
 CellID->501087176],
Cell[CellGroupData[{
Cell[20730, 653, 385, 13, 70, "Input",
 CellID->246466859],
Cell[21118, 668, 612, 14, 70, "Output",
 Evaluatable->False,
 CellID->136065204]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21779, 688, 232, 7, 70, "ExampleSubsection",
 CellID->10761],
Cell[22014, 697, 90, 1, 70, "ExampleText",
 CellID->194365554],
Cell[CellGroupData[{
Cell[22129, 702, 315, 11, 70, "Input",
 CellID->234241432],
Cell[22447, 715, 508, 12, 70, "Output",
 Evaluatable->False,
 CellID->7838572]
}, Open  ]],
Cell[22970, 730, 125, 3, 70, "ExampleDelimiter",
 CellID->230687880],
Cell[23098, 735, 87, 1, 70, "ExampleText",
 CellID->285974128],
Cell[CellGroupData[{
Cell[23210, 740, 391, 13, 70, "Input",
 CellID->32962944],
Cell[23604, 755, 478, 12, 70, "Output",
 Evaluatable->False,
 CellID->821262589]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24131, 773, 229, 7, 70, "ExampleSubsection",
 CellID->5469],
Cell[24363, 782, 69, 1, 70, "ExampleText",
 CellID->237827221],
Cell[CellGroupData[{
Cell[24457, 787, 541, 18, 70, "Input",
 CellID->323318069],
Cell[25001, 807, 657, 15, 70, "Output",
 Evaluatable->False,
 CellID->604516693]
}, Open  ]],
Cell[25673, 825, 125, 3, 70, "ExampleDelimiter",
 CellID->444614298],
Cell[25801, 830, 72, 1, 70, "ExampleText",
 CellID->136879370],
Cell[CellGroupData[{
Cell[25898, 835, 517, 18, 70, "Input",
 CellID->33602098],
Cell[26418, 855, 612, 14, 70, "Output",
 Evaluatable->False,
 CellID->785128598]
}, Open  ]],
Cell[27045, 872, 125, 3, 70, "ExampleDelimiter",
 CellID->530018099],
Cell[27173, 877, 81, 1, 70, "ExampleText",
 CellID->687548857],
Cell[CellGroupData[{
Cell[27279, 882, 614, 21, 70, "Input",
 CellID->450242684],
Cell[27896, 905, 770, 17, 70, "Output",
 Evaluatable->False,
 CellID->81001380]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28715, 928, 229, 7, 70, "ExampleSubsection",
 CellID->32503],
Cell[28947, 937, 73, 1, 70, "ExampleText",
 CellID->102370557],
Cell[CellGroupData[{
Cell[29045, 942, 315, 11, 70, "Input",
 CellID->534913025],
Cell[29363, 955, 510, 12, 70, "Output",
 Evaluatable->False,
 CellID->218090509]
}, Open  ]],
Cell[29888, 970, 114, 3, 70, "ExampleText",
 CellID->84581312],
Cell[CellGroupData[{
Cell[30027, 977, 438, 15, 70, "Input",
 CellID->289595654],
Cell[30468, 994, 513, 12, 70, "Output",
 Evaluatable->False,
 CellID->50225060]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[31042, 1013, 223, 7, 70, "ExampleSection",
 CellID->32729],
Cell[31268, 1022, 76, 1, 70, "ExampleText",
 CellID->15516363],
Cell[CellGroupData[{
Cell[31369, 1027, 639, 22, 70, "Input",
 CellID->421643955],
Cell[32011, 1051, 970, 20, 70, "Output",
 Evaluatable->False,
 CellID->254625441]
}, Open  ]],
Cell[32996, 1074, 123, 3, 70, "ExampleDelimiter",
 CellID->7759639],
Cell[33122, 1079, 73, 1, 70, "ExampleText",
 CellID->173850812],
Cell[CellGroupData[{
Cell[33220, 1084, 322, 9, 70, "Input",
 CellID->129605735],
Cell[33545, 1095, 1737, 38, 198, "Output",
 CellID->361725868]
}, Open  ]],
Cell[35297, 1136, 125, 3, 70, "ExampleDelimiter",
 CellID->910112257],
Cell[35425, 1141, 193, 7, 70, "ExampleText",
 CellID->429506165],
Cell[35621, 1150, 233, 8, 70, "Input",
 CellID->656865022],
Cell[CellGroupData[{
Cell[35879, 1162, 514, 16, 70, "Input",
 CellID->188409282],
Cell[36396, 1180, 922, 19, 70, "Output",
 Evaluatable->False,
 CellID->372307298]
}, Open  ]],
Cell[37333, 1202, 124, 3, 70, "ExampleDelimiter",
 CellID->37157736],
Cell[37460, 1207, 70, 1, 70, "ExampleText",
 CellID->25289756],
Cell[CellGroupData[{
Cell[37555, 1212, 974, 26, 70, "Input",
 CellID->19039535],
Cell[38532, 1240, 44416, 732, 70, "Output",
 Evaluatable->False,
 CellID->235378316]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[82997, 1978, 233, 7, 70, "ExampleSection",
 CellID->17107],
Cell[83233, 1987, 213, 7, 70, "ExampleText",
 CellID->198124043],
Cell[CellGroupData[{
Cell[83471, 1998, 315, 11, 70, "Input",
 CellID->220858554],
Cell[83789, 2011, 509, 12, 70, "Output",
 Evaluatable->False,
 CellID->34158201]
}, Open  ]],
Cell[84313, 2026, 230, 7, 70, "ExampleText",
 CellID->216510616],
Cell[CellGroupData[{
Cell[84568, 2037, 314, 11, 70, "Input",
 CellID->1671103],
Cell[84885, 2050, 741, 23, 78, "Output",
 CellID->63003257]
}, Open  ]],
Cell[85641, 2076, 219, 7, 70, "ExampleText",
 CellID->173343638],
Cell[CellGroupData[{
Cell[85885, 2087, 310, 11, 70, "Input",
 CellID->387237740],
Cell[86198, 2100, 237, 11, 64, "Output",
 CellID->450284313]
}, Open  ]],
Cell[86450, 2114, 125, 3, 70, "ExampleDelimiter",
 CellID->242496653],
Cell[86578, 2119, 233, 8, 70, "ExampleText",
 CellID->77644622],
Cell[86814, 2129, 372, 12, 70, "Input",
 CellID->25776438],
Cell[CellGroupData[{
Cell[87211, 2145, 129, 4, 70, "Input",
 CellID->887147311],
Cell[87343, 2151, 819, 17, 70, "Output",
 Evaluatable->False,
 CellID->198250254]
}, Open  ]],
Cell[CellGroupData[{
Cell[88199, 2173, 132, 4, 70, "Input",
 CellID->784481],
Cell[88334, 2179, 11323, 190, 70, "Output",
 Evaluatable->False,
 CellID->522662323]
}, Open  ]],
Cell[99672, 2372, 125, 3, 70, "ExampleDelimiter",
 CellID->217655714],
Cell[99800, 2377, 241, 8, 70, "ExampleText",
 CellID->149850061],
Cell[100044, 2387, 283, 10, 70, "Input",
 CellID->640644695],
Cell[CellGroupData[{
Cell[100352, 2401, 133, 4, 70, "Input",
 CellID->417844010],
Cell[100488, 2407, 700, 15, 70, "Output",
 Evaluatable->False,
 CellID->2500990]
}, Open  ]],
Cell[CellGroupData[{
Cell[101225, 2427, 135, 4, 70, "Input",
 CellID->416295999],
Cell[101363, 2433, 2995, 55, 115, "Output",
 CellID->260958570]
}, Open  ]],
Cell[104373, 2491, 125, 3, 70, "ExampleDelimiter",
 CellID->206397254],
Cell[104501, 2496, 332, 13, 70, "ExampleText",
 CellID->85637859],
Cell[104836, 2511, 373, 12, 70, "Input",
 CellID->299933728],
Cell[CellGroupData[{
Cell[105234, 2527, 195, 6, 70, "Input",
 CellID->371234833],
Cell[105432, 2535, 3636, 69, 168, "Output",
 CellID->246726261]
}, Open  ]],
Cell[CellGroupData[{
Cell[109105, 2609, 262, 8, 70, "Input",
 CellID->476591697],
Cell[109370, 2619, 814, 17, 70, "Output",
 Evaluatable->False,
 CellID->302628691]
}, Open  ]],
Cell[110199, 2639, 124, 3, 70, "ExampleDelimiter",
 CellID->43409348],
Cell[110326, 2644, 384, 13, 70, "ExampleText",
 CellID->141476791],
Cell[CellGroupData[{
Cell[110735, 2661, 320, 11, 70, "Input",
 CellID->70944717],
Cell[111058, 2674, 1720, 32, 70, "Output",
 Evaluatable->False,
 CellID->121763013]
}, Open  ]],
Cell[CellGroupData[{
Cell[112815, 2711, 543, 17, 70, "Input",
 CellID->508293932],
Cell[113361, 2730, 1240, 24, 70, "Output",
 Evaluatable->False,
 CellID->339877997]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[114650, 2760, 224, 7, 70, "ExampleSection",
 CellID->17953],
Cell[114877, 2769, 69, 1, 70, "ExampleText",
 CellID->750836775],
Cell[CellGroupData[{
Cell[114971, 2774, 451, 14, 70, "Input",
 CellID->128334620],
Cell[115425, 2790, 1488, 28, 70, "Output",
 Evaluatable->False,
 CellID->510019350]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[116974, 2825, 310, 9, 70, "SeeAlsoSection",
 CellID->7093],
Cell[117287, 2836, 1260, 45, 70, "SeeAlso",
 CellID->8472]
}, Open  ]],
Cell[CellGroupData[{
Cell[118584, 2886, 313, 9, 70, "TutorialsSection",
 CellID->1790],
Cell[118900, 2897, 154, 3, 70, "Tutorials",
 CellID->17013],
Cell[119057, 2902, 147, 3, 70, "Tutorials",
 CellID->30412],
Cell[119207, 2907, 145, 3, 70, "Tutorials",
 CellID->34733876]
}, Open  ]],
Cell[CellGroupData[{
Cell[119389, 2915, 305, 8, 70, "RelatedLinksSection"],
Cell[119697, 2925, 363, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[120097, 2942, 317, 9, 70, "MoreAboutSection",
 CellID->3538772],
Cell[120417, 2953, 141, 3, 70, "MoreAbout",
 CellID->13947635],
Cell[120561, 2958, 139, 3, 70, "MoreAbout",
 CellID->573182166]
}, Open  ]],
Cell[120715, 2964, 27, 0, 70, "History"],
Cell[120745, 2966, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

