(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27546,        832]
NotebookOptionsPosition[     23200,        681]
NotebookOutlinePosition[     24548,        718]
CellTagsIndexPosition[     24463,        713]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tables and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/TablesAndMatrices"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Tables and Matrices\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RowSpacings" :> 
          Documentation`HelpLookup["paclet:ref/RowSpacings"], 
          "ColumnSpacings" :> 
          Documentation`HelpLookup["paclet:ref/ColumnSpacings"], 
          "TableDirections" :> 
          Documentation`HelpLookup["paclet:ref/TableDirections"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"RowSpacings\"\>", 
       2->"\<\"ColumnSpacings\"\>", 
       3->"\<\"TableDirections\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TableSpacing", "ObjectName",
 CellID->28400],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["TableSpacing",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/TableSpacing"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["TableForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/TableForm"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["MatrixForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
     " which specifies how many spaces should be left between each successive \
row or column. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6558]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"TableSpacing", "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["s", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["s", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 " specifies that ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["s", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " spaces should be left in dimension ",
 Cell[BoxData[
  StyleBox["i", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->21476],

Cell["\<\
For columns, the spaces are rendered as space characters. For rows, the \
spaces are rendered as blank lines. \
\>", "Notes",
 CellID->3154],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  ButtonBox["TableForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TableForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"TableSpacing", "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " yields spacings ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{"1", ",", "3", ",", "0", ",", "1", ",", "0", ",", "1", ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10935]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->881189600],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->38277253],

Cell["Format a table with no space between rows or columns:", "ExampleText",
 CellID->687548857],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["a", "##"], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"TableSpacing", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->450242684],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVc0OgjAMHhvjx7+o4eCRxDuPoScfghATPBgN8v7YDTaWskU0Gg9KQre2
X9eP7ose8ro8nvP6VOTpvsqv5am4pbtLBSHmEUIyeLcbAvsGdvLNmgbWhbBM
+PIhCfIDiYrAUgj6KMthG5s5X+fgEUAq6yeojqpijYU9mdtQ/Ymqh4xzdbaB
D5HPRuK89nDWLrozZoKn8vB78LRwlaNvYH5xa6NR/UyWwg+RT/X0fNUWsRP3
yB3556e2tLJcaRYCmnTrWkYzw45XJrOwVcrUOYcy8WR9K+epDfU9ZQ74xajO
jnrxRv96bMbrMXTcLO+mpnMOPeKbZFbOMxvqV/T4pm7mr/FQjWKlpP/n4yiO
e35afa0l3h1XrwM7\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{46, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->109928321]
}, Open  ]],

Cell["Use one space between rows and four between columns:", "ExampleText",
 CellID->781637214],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["a", "##"], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"TableSpacing", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->280139010],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztVc0KwjAM7tq5TQ+Cnjx6UARlCh58BD0Je4UxBD2IMvf+M+1sLTGFKqIH
HSxtki/NTz+2bV7td8e8OhT5cFPm5/2huAzXpxJMImCMZfCmAwb7Gnbqzeoa
1q6UQurqYSukRwqVgORgDJG3BduZ7QuNDx4J5Cq+g+K4DjZY2LMFhbqfqHMo
e0ufbeFjpI89cUFzuGgWkxlXgqdi6SOyHzwtHOXIG9kdNzLxymdXKfUY6dxM
L9RpUXXyHicO//NTW5JV9kwVErq6rX1lzbylP28F0YvmrfE5eIvnHpIdpRTq
e7x9qK+N4mj2vHjff7Z6SD+2xo57l7ap7XOwFd+zIDuaU6hfYeubstlf8keu
ypWz+19zguw452e4yYIrcZUpDw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{80, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//TableForm=",
 CellID->760961525]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11754],

Cell[TextData[{
 "Use with ",
 Cell[BoxData[
  ButtonBox["MatrixForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MatrixForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->391404430],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["a", "##"], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"TableSpacing", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->113358593],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9VjtvAjEMDvfgUYoqWtTSDal/oVKZGdqpP+KEKsFQtaIMbIyMjIyMjIyM
jIyMjIyMjIxX53UJxoioHD3pcrFjO3bs75z3qNv6+Iy67WZUe+tE361286f2
+tUBlp9hjDXgfaoymMcwE28jjuH7wEef0+JhFUSXhRQfPWAGaDWEacFeC5I1
eLhgSejfIT1PKyeyTMtiKWMRJjfiEwq58Xis+D4M3JiH9HOIdpXLCrrf71t6
OvbVajWbzRLuQQz4hLJOkZ/SyuqIl8sl9mg0Gtl+Hti2o+V03skjrJUj6d1u
1+v1jEe+5kqnRKZ4An0iHl4zx9ZxRiQ9GAzAdOKz0PIWi0VIRnBLcmW9Qwoh
kfuWxEluNhvtN9++or5VlHtby9TJi45eluYRqTrKWoaUKqMTwLgsIXnaSlH5
j89X4zZZO8Btwdm+bTcgz5yU2sN10Wk3npU0cZ532pWO6VTF0qg6pXWOR5fB
uVsdpIXzc+Kn8V519t/G+6OTVj1FqXTwfhXTlR+qekjW/oj3a2SX7jikFIF3
08Ht3eAvb2UlTbxLervdEv/nyWSyXq/jf8a7pKGpQxfDHgF3Pp9f2iP7pmH+
GtPpVHVC6VGA8sXpQJ24p7RsnGt+gfTR1BOyrro7XVU0vu+FAjgry2bvZmQ6
MadtfMtbwHA4VFFKLXmvlC2eT58RLaUa1sgyv9WXYWU=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{66, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->73787633]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["a", "##"], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"TableSpacing", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->276365659],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdVjtPAkEQPu54ihQ2gh2FxkSDNoafoJWthd0FTKAwGqSgo6SkpOQnUFJS
UlJSUlJSUp4z+7hdljlYBYx6ye3NzM5rd2e/m0e/WXt59Zv1il98aPjvtXrl
o3j/1gCRF3McpwpvqeAAHQDF3moQwDePo4c8e5yywZ8wLRxdEMaN2QSQ1/pc
PJyDBxVzzD7B7Pr9vrDLGn5c6Sy0Bdq5pbRUBCAyTKPdbguJx8Q8y+l0OhwO
mQkM6Nw1/KUM/sJSLylXM5lMzKi9Xk/PZW1N5g4mDf78W1acXy6XrVZLZeRJ
KU+Ke1nzra8W+bRVRqZVivTS6XQgfHh2LCN3PB5jvniQHrEOrKXLiHnzJDgP
xwyHvRqFncR8Po9e9x0p5fdB1Y7uUdUZ1jOmURbfgtxpXuIRVs8yL8HHNmgp
/j9qMVTZgDo5Ky9ZsftmlUhUCufWUMnEjWj/ul+6jkqU1gpKZa2iYU3tE6XS
VlHpNW27dzQmbLPaJaPDoJRdHeDJ7AOtdlk/jVYF6/x1tDqzsvqt2PFX0eoo
oO8tyq70uQi06na7G/0fG37p/uOG0iLQSvVqejT4dy0WiyDYP1pxfjabDQYD
JPU/KPyKRaf1k2jF+dFoRPQWsAkiz0NmpHd5CvOgDlZ6KrPvRD4udtwVVjpK
SXmGzFHVk/Luwu5/BZVO0Qb2h9mI3n+1L9bRKE/MSyvewCH5ZPBcq6qNTuwT
pCJlFA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{100, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->546041061]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->332512081],

Cell["Specify spacings for any number of dimensions:", "ExampleText",
 CellID->221290813],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{
     RowBox[{
      SubscriptBox["a", "##"], "&"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "2", ",", "2", ",", "2"}], "}"}]}], "]"}], ",", 
   RowBox[{"TableSpacing", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"6", ",", "4", ",", "2", ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->258952669],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmM1OwzAMx7N26zqBOHHguANFSCC48QiAkHiIakLaDgg09px7pZG0tGo9
J7aTDUbXSc2H6/zjpUn7k1/z1fztPV8tZvn0aZl/zhezr+njx1Kb4oFSaq2v
/ELp9ka3imu92ei6LM9MGRtr8VNjon8u9H/Ys35S/ItUl8YYg7sj3YxMY1jb
HJ4TP5Ut663zrsPqikeis2WN6lVqzjGsJqp9dVuN2gq6kaB+JyFqLcsdpkSM
EcTEUWpZilHFmtVPXrAjYT/ekU52YPEMysWKy8qUEfpMJkJdXAWeD2m0l3tR
3U+slpVNmnu0LOGJThp9hdzH442IUVB1DPoZSxWOgn2/WClV2C/fhKYcIk/K
/NMI2bOVfSQch51hbDznK+eaf0c7jDwvz6j1CrVm9Uob2euf+gX0i7FqvaPy
SGiGYSNZhsU3DJKRxsJXCacYplVAMgy+YdJMSGxctZ5qeqrxUD00qvGLl6Ia
9N0bTDXULH5UQxEZj2pSUFM0U/nBvc6lGKjDpRcbTXWVWv6q7AYtGauMajDi
SP1Utqw3TZ2A3E/qq2OhJniW4mqi2lcpfu7nNEStZbnHlLxyP2hMfe6np6Qu
UBK5sn6ZH86X2MUlOCNhPCGhG16slKo782NqF+PAjAvlb8v0REx/23zSE9RV
RjoSVmHYSFJh0QuDU6SxBGd2BIzCtAo4hUEvTFYJia3P7PTMUvSPgVl+J1pe
XoeiC7+8jlTVndeBDGLL59j8bHkcG2vY8jeU///L26jBN/TxeHU=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{206, 97},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->857233686]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3293],

Cell["Display a bit matrix with no spacing: ", "ExampleText",
 CellID->108581630],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixForm", "[", 
  RowBox[{
   RowBox[{"RandomInteger", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"20", ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"TableSpacing", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->118346888],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnT1PK0cUho0N4SaRUqe8v+be6v4IhCJBESUiFHSUlEgp4tL8A0qXlBQp
XLqkdEnpcrOfXme14znzPb48SGa9o9n5euaM3zk+u/52cXv12+8Xt9eXF5+/
3lz8eXV9+dfnL3/clEmzk8lk8lS+/v11Ur4vynf166koyuP+/7Pq/2yxWBT1
3+Tv+vz+/r49n9W5Tuu36/V6uVx2qWdlgdVx1h6r86nm2OU/1VynK3dYzrC8
H7perVarYS/m83nbt6bv1bg059M6cXdeX9Nd1edyPR+vxU/dIUtxaXfDY7vd
3t3dFTsesy61QdLmgkd4Huf1+cPDQzn4uxpqHtPX19dzOETlUC6q5dL6fw71
OrXZbArsIjqP/nNun0f/mQgP9xaa8CgXqUagwCMxj0/1ea+gTooxHpWumk4a
bdmps+5cdxyqOl0+aTn7+X8atHe8F/94zFXVLNHBKl2r0rkqvaw6V9X3o6gX
QzvzaRHuc9WnPbq0OfyoNFYILWhBC1rQgha0oJWGlomGlyjbMU2vKkdSn0zZ
htT6Up+2qY9bV77qej9aP8yONf6ONqSNmqT6WRuhAhWoNKlQMekXVKAClbyo
SPzktn513fUS7Z5eW0s1r05zS/3luvwh/ejprSP+ztRnjSG9D7CBDWxgAxvY
dLlgc+xsbHWxRJfrypHkj6+/hy2V6mKVHnf1cQ/TZSNyOjon4s9C/9/ZpN8b
+7Q/OMEJTnCCE5zgFGZUPwInW319SNeb6v5D9abX8bb6W6fHbcvzr+PTz2if
8z59u/2vkLn2FEI2qRCCkLyuXNsNIQjl0tPvm5AkPtzUl+7r3tI0Gr1qwSGN
LNXu0ntKddcP0+2+34q1Kw1vQ3m1UXcVtHJqI7T81QuteCMBLWhBK8xIfBxa
Nn53qaa3vX4/Pf/nw0jj1HUaXvocmlyfD5PfHjh8n1122RCCEIQgBCEIQQhC
hZKQzXNdfD3DUVePXJGmjH1XaXCpVtdp/+F1ucashZz38W3KtAVQgYq/dkMF
KlAJP3JQgUo4Kjbx6K6xLDrNntb/rfLkS2NedJpcWq5Ka8eKMnOZ0cfwvVV8
i4Wcn9ZADnKQO1Q75CDno3+Qg5xZfLyv56tLyx3bQ6TbM9jGwkj3DLrYmxDP
ojmWXXN8a/HZLpc1E0JuuSAEIQi55YIQhCDklssnIR+xMFKNbnPva/rntau0
uKk/3rWcLj3MbyH5nK8h53ou7XSxOdjABjb7qbDJoZ2wybedsMm3na7629dz
16V6/Thi1k119FA3S/NJ7zM1GxGXnW/KPW56qzapMZVvAkIQghCE7HsHIQjt
1QuhjAmZ+KxDx7rbK9IYPnKdT1t1lMar6Mozi30P8wvC7rMyvCWl7cmwHmhB
C1rQgha0oAWtlLRc/PCqozTuRVJOPve5qrS7qcZX7R2Ge4thPrPdz/guO5Zl
pLLAMF4Elz7n9dsX0DrcD2ipc0ELWtDyUw+0fIwitLpU/7/fZKvxpd8X5BF7
U9Us0d6mGn24B1CVp/P35xT7HnL+hrQ7/ytMTlGIUOlSoQIVqEBFnwoVqPim
YhPXLo2RkWrsQxo+/bPYh5pYqq1VGtvUv57Kjx7H/lxmeMxdcI4+CAhBSD5e
EIIQhCAEoWMjZPIcRZ1Gd41nz0OjVzX71OKmfnFdvSF/WTil3cTfTftpFzz0
ZcPDfMzgAQ94wKNJhUdePGx82K73hZro8vTPNVf5nFV62NRXLT2a3Q86vmP1
s3sLU4r/nWPcVDv7gxOc4AQnOMEJTnCy5eQSry29zka1dteb6PjHx0dBrsVi
MZJrPp+/v78XRe//lup3qX9bp8+l946e1+19e3t7fn4uuhnZ9mK5XK5Wq+qt
LiIsv/1zLLuIVU/D6eXlZb1e7+ptOZVTraUHJ1Wf4nIq147tdrurt81Vrgpt
rjOrEYSTb079at5zmpZrHnak6lOseioC03JVq9Nbe+ntJ47yg4+6nsZCeiL1
J1HLabPZOI0gnHxz6ok0nH4u7GPHbXW4yX2fv9StfGr6dPIfhAyMLg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{160, 203},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->31069384]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10443],

Cell["A bit matrix texture: ", "ExampleText",
 CellID->55159603],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Style", "[", 
  RowBox[{
   RowBox[{"TableForm", "[", 
    RowBox[{
     RowBox[{"RandomInteger", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"100", ",", "100"}], "}"}]}], "]"}], ",", 
     RowBox[{"TableSpacing", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}]}], "]"}], ",", "4"}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->86089644],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{200, 403},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->34185682]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15623],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RowSpacings",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RowSpacings"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColumnSpacings",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColumnSpacings"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TableDirections",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TableDirections"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17922]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16430],

Cell[TextData[ButtonBox["Tables and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TablesAndMatrices"]], "Tutorials",
 CellID->5831]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TableSpacing - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 26, 1.3626494}", "context" -> "System`", 
    "keywords" -> {"spaces in tables", "row spacing", "column spacing"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "TableSpacing is an option for TableForm and MatrixForm which specifies \
how many spaces should be left between each successive row or column. ", 
    "synonyms" -> {"table spacing"}, "title" -> "TableSpacing", "type" -> 
    "Symbol", "uri" -> "ref/TableSpacing"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4717, 166, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->881189600]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24320, 706}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1429, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2052, 63, 50, 1, 70, "ObjectName",
 CellID->28400],
Cell[2105, 66, 795, 24, 70, "Usage",
 CellID->6558]
}, Open  ]],
Cell[CellGroupData[{
Cell[2937, 95, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3415, 112, 575, 22, 70, "Notes",
 CellID->21476],
Cell[3993, 136, 150, 4, 70, "Notes",
 CellID->3154],
Cell[4146, 142, 534, 19, 70, "Notes",
 CellID->10935]
}, Closed]],
Cell[CellGroupData[{
Cell[4717, 166, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->881189600],
Cell[CellGroupData[{
Cell[5102, 180, 147, 5, 70, "ExampleSection",
 CellID->38277253],
Cell[5252, 187, 96, 1, 70, "ExampleText",
 CellID->687548857],
Cell[CellGroupData[{
Cell[5373, 192, 379, 13, 28, "Input",
 CellID->450242684],
Cell[5755, 207, 604, 14, 70, "Output",
 Evaluatable->False,
 CellID->109928321]
}, Open  ]],
Cell[6374, 224, 95, 1, 70, "ExampleText",
 CellID->781637214],
Cell[CellGroupData[{
Cell[6494, 229, 379, 13, 28, "Input",
 CellID->280139010],
Cell[6876, 244, 616, 14, 80, "Output",
 Evaluatable->False,
 CellID->760961525]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7541, 264, 216, 7, 70, "ExampleSection",
 CellID->11754],
Cell[7760, 273, 196, 8, 70, "ExampleText",
 CellID->391404430],
Cell[CellGroupData[{
Cell[7981, 285, 380, 13, 70, "Input",
 CellID->113358593],
Cell[8364, 300, 937, 19, 70, "Output",
 Evaluatable->False,
 CellID->73787633]
}, Open  ]],
Cell[CellGroupData[{
Cell[9338, 324, 380, 13, 70, "Input",
 CellID->276365659],
Cell[9721, 339, 964, 20, 70, "Output",
 Evaluatable->False,
 CellID->546041061]
}, Open  ]],
Cell[10700, 362, 125, 3, 70, "ExampleDelimiter",
 CellID->332512081],
Cell[10828, 367, 89, 1, 70, "ExampleText",
 CellID->221290813],
Cell[CellGroupData[{
Cell[10942, 372, 419, 13, 70, "Input",
 CellID->258952669],
Cell[11364, 387, 1007, 20, 70, "Output",
 Evaluatable->False,
 CellID->857233686]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12420, 413, 222, 7, 70, "ExampleSection",
 CellID->3293],
Cell[12645, 422, 81, 1, 70, "ExampleText",
 CellID->108581630],
Cell[CellGroupData[{
Cell[12751, 427, 395, 13, 70, "Input",
 CellID->118346888],
Cell[13149, 442, 2293, 41, 70, "Output",
 Evaluatable->False,
 CellID->31069384]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15491, 489, 224, 7, 70, "ExampleSection",
 CellID->10443],
Cell[15718, 498, 64, 1, 70, "ExampleText",
 CellID->55159603],
Cell[CellGroupData[{
Cell[15807, 503, 473, 16, 70, "Input",
 CellID->86089644],
Cell[16283, 521, 5242, 90, 70, "Output",
 Evaluatable->False,
 CellID->34185682]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21586, 618, 311, 9, 70, "SeeAlsoSection",
 CellID->15623],
Cell[21900, 629, 728, 26, 70, "SeeAlso",
 CellID->17922]
}, Open  ]],
Cell[CellGroupData[{
Cell[22665, 660, 314, 9, 70, "TutorialsSection",
 CellID->16430],
Cell[22982, 671, 146, 3, 70, "Tutorials",
 CellID->5831]
}, Open  ]],
Cell[23143, 677, 27, 0, 70, "History"],
Cell[23173, 679, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

