(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26867,        970]
NotebookOptionsPosition[     21611,        791]
NotebookOutlinePosition[     23078,        831]
CellTagsIndexPosition[     22993,        826]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Representing Textual Forms by Boxes" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/RepresentingTextualFormsByBoxes"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Representing Textual Forms by Boxes\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Annotation" :> 
          Documentation`HelpLookup["paclet:ref/Annotation"], 
          "InterpretationBox" :> 
          Documentation`HelpLookup["paclet:ref/InterpretationBox"], "FormBox" :> 
          Documentation`HelpLookup["paclet:ref/FormBox"], "ToExpression" :> 
          Documentation`HelpLookup["paclet:ref/ToExpression"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Annotation\"\>", 
       2->"\<\"InterpretationBox\"\>", 3->"\<\"FormBox\"\>", 
       4->"\<\"ToExpression\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Defining Custom Notation" :> 
          Documentation`HelpLookup["paclet:guide/DefiningCustomNotation"], 
          "Low-Level Notebook Structure" :> 
          Documentation`HelpLookup[
           "paclet:guide/LowLevelNotebookStructure"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Defining Custom Notation\"\>", 
       2->"\<\"Low-Level Notebook Structure\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TagBox", "ObjectName",
 CellID->19751],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["TagBox",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TagBox"], "[", 
       RowBox[{
        StyleBox["boxes", "TI"], ",", 
        StyleBox["tag", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a low-level box construct that displays as ",
     Cell[BoxData[
      StyleBox["boxes", "TI"]], "InlineFormula"],
     " but maintains ",
     Cell[BoxData[
      StyleBox["tag", "TI"]], "InlineFormula"],
     " to guide the interpretation of ",
     Cell[BoxData[
      StyleBox["boxes", "TI"]], "InlineFormula"],
     " on input. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29001]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TagBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
 " provides a way to store hidden information in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " output. "
}], "Notes",
 CellID->435],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TagBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
 " is generated sometimes in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " output, and often in ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " output. "
}], "Notes",
 CellID->16693],

Cell[TextData[{
 "By convention, ",
 Cell[BoxData[
  StyleBox["tag", "TI"]], "InlineFormula"],
 " is typically a symbol that corresponds to the head of the interpreted form \
of ",
 Cell[BoxData[
  StyleBox["boxes", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15072],

Cell["The following options can be given: ", "Notes",
 CellID->17916],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["AutoDelete",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/AutoDelete"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "whether to strip the ",
     Cell[BoxData[
      ButtonBox["TagBox",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["boxes", "TI"]], "InlineFormula"],
     " are modified "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["DeletionWarning",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/DeletionWarning"], 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "whether to issue a warning if ",
     Cell[BoxData[
      StyleBox["boxes", "TI"]], "InlineFormula"],
     " are deleted "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Editable",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Editable"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "whether to allow ",
     Cell[BoxData[
      StyleBox["boxes", "TI"]], "InlineFormula"],
     " to be edited "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Selectable",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Selectable"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[TextData[{
     "whether to allow ",
     Cell[BoxData[
      StyleBox["boxes", "TI"]], "InlineFormula"],
     " to be selected "
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], "StripWrapperBoxes", 
    ButtonBox["False",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/False"], Cell[TextData[{
     "whether to remove ",
     Cell[BoxData[
      ButtonBox["StyleBox",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/StyleBox"]], "InlineFormula"],
     " etc. from within ",
     StyleBox["boxes", "TI"],
     " "
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->6716],

Cell[TextData[{
 "If you modify the displayed form of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TagBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TagBox"], "[", 
   RowBox[{
    StyleBox["boxes", "TI"], ",", 
    StyleBox["tag", "TI"]}], "]"}]], "InlineFormula"],
 " only ",
 Cell[BoxData[
  StyleBox["boxes", "TI"]], "InlineFormula"],
 " will be modified, and there is no guarantee that correct correspondence \
with ",
 Cell[BoxData[
  StyleBox["tag", "TI"]], "InlineFormula"],
 " will be maintained. "
}], "Notes",
 CellID->25328]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->475339463],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->77876237],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TagBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
 " does not change the appearance of its contents:"
}], "ExampleText",
 CellID->110280404],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RowBox", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<x\>\"", ",", 
     RowBox[{"TagBox", "[", 
      RowBox[{"\"\<x\>\"", ",", "\"\<tag\>\""}], "]"}]}], "}"}], "]"}], "//", 
  "DisplayForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->177567825],

Cell[BoxData[
 TagBox[
  RowBox[{"x", 
   TagBox["x",
    "tag"]}],
  DisplayForm]], "Output",
 ImageSize->{21, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//DisplayForm=",
 CellID->204224202]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->243599250],

Cell[TextData[{
 "The standard formatting for some expressions uses ",
 Cell[BoxData[
  ButtonBox["TagBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
 " to aid interpretation: "
}], "ExampleText",
 CellID->85956211],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToBoxes", "[", 
  RowBox[{
   RowBox[{"InverseFunction", "[", "f", "]"}], ",", "StandardForm"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->986414560],

Cell[BoxData[
 RowBox[{"TagBox", "[", 
  RowBox[{
   RowBox[{"SuperscriptBox", "[", 
    RowBox[{"\<\"f\"\>", ",", 
     RowBox[{"RowBox", "[", 
      RowBox[{"{", 
       RowBox[{"\<\"(\"\>", ",", 
        RowBox[{"RowBox", "[", 
         RowBox[{"{", 
          RowBox[{"\<\"-\"\>", ",", "\<\"1\"\>"}], "}"}], "]"}], 
        ",", "\<\")\"\>"}], "}"}], "]"}]}], "]"}], ",", "InverseFunction", 
   ",", 
   RowBox[{"Editable", "\[Rule]", "False"}]}], "]"}]], "Output",
 ImageSize->{392, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->133425516]
}, Open  ]],

Cell["The formatted result looks like this:", "ExampleText",
 CellID->108907752],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"InverseFunction", "[", "f", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14089127],

Cell[BoxData[
 TagBox[
  SuperscriptBox["f", 
   RowBox[{"(", 
    RowBox[{"-", "1"}], ")"}]],
  InverseFunction,
  Editable->False]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->198640844]
}, Open  ]],

Cell[TextData[{
 "Without the ",
 Cell[BoxData[
  ButtonBox["TagBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
 ", this notation would be interpreted differently:"
}], "ExampleText",
 CellID->386901217],

Cell[CellGroupData[{

Cell[BoxData[
 SuperscriptBox["f", 
  RowBox[{"(", 
   RowBox[{"-", "1"}], ")"}]]], "Input",
 CellLabel->"In[3]:=",
 CellID->289978176],

Cell[BoxData[
 FractionBox["1", "f"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->27409304]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->292428007],

Cell[TextData[{
 "A ",
 Cell[BoxData[
  ButtonBox["GridBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GridBox"]], "InlineFormula"],
 " is normally interpreted as a matrix: "
}], "ExampleText",
 CellID->248723986],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", 
  RowBox[{
   RowBox[{"GridBox", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "\"\<a\>\"", "}"}], ",", 
      RowBox[{"{", "\"\<b\>\"", "}"}]}], "}"}], "]"}], ",", "StandardForm"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->574946869],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "a", "}"}], ",", 
   RowBox[{"{", "b", "}"}]}], "}"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->121957146]
}, Open  ]],

Cell[TextData[{
 "Use a predefined ",
 Cell[BoxData[
  ButtonBox["TagBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
 " interpretation to get a different result: "
}], "ExampleText",
 CellID->18048885],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToExpression", "[", 
   RowBox[{
    RowBox[{"TagBox", "[", 
     RowBox[{
      RowBox[{"GridBox", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", "\"\<a\>\"", "}"}], ",", 
         RowBox[{"{", "\"\<b\>\"", "}"}]}], "}"}], "]"}], ",", 
      "\"\<Column\>\""}], "]"}], ",", "StandardForm"}], "]"}], "//", 
  "InputForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27669645],

Cell["Column[{a, b}]", "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//InputForm=",
 CellID->209422466]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12021],

Cell["\<\
The following traditional notations are identical, and hence cannot be \
distinguished:\
\>", "ExampleText",
 CellID->634846733],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TraditionalForm", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Binomial", "[", 
     RowBox[{"n", ",", "k"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "n", "}"}], ",", 
      RowBox[{"{", "k", "}"}]}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->575466946],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVVstywjAMVJ6U0BfthUMPfA099cAnZJjOwIFpB/j/1HJCySwb2019aDOT
4FUkrWQrQm/1afu+r0+7Tb18PdSf293muFx9HIwoS0Rkbe6XhZh1Y1b2XjeN
+W2ft/rMVGovuQP8DPge8Mx6mYE0M4/UQMnt6+4qQWsOOA+yquzLs25BfEh+
wSITD2vhtcj6XBZd2WMEHdb4b0L4HfroP6VR5MRK4RTkD4DLAT30F8baPyuW
C7JPPPpxokhJFfkiYTa/j0aXmCPa40lgNcbZI60PzbEi0TB5OSAfx86+fFeO
T0GsKckxpN/gjiMb+kksW5tkWzC+HoPVhgy6u9qs1XMyKhcfA8/hp+fkY4lT
Df+ZRbFC938YcnMrrKrxX7oU37gjQN8YEbeK13v+VkQl9e07NW4V59TO/Rb7
AOqxmJida0q5ROWaquxk1vU8tjuD01zPxj1Z4RSJuSHDI+Aqopc4c3E7Y0vy
BagJIug=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{81, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->55011623]
}, Open  ]],

Cell[TextData[{
 "The box representation contains ",
 Cell[BoxData[
  ButtonBox["TagBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
 " data: "
}], "ExampleText",
 CellID->524816125],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"box1", "=", 
  RowBox[{"ToBoxes", "[", 
   RowBox[{
    RowBox[{"Binomial", "[", 
     RowBox[{"n", ",", "k"}], "]"}], ",", "TraditionalForm"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->232301458],

Cell[BoxData[
 RowBox[{"FormBox", "[", 
  RowBox[{
   RowBox[{"TagBox", "[", 
    RowBox[{
     RowBox[{"RowBox", "[", 
      RowBox[{"{", 
       RowBox[{"\<\"(\"\>", ",", 
        RowBox[{"GridBox", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"TagBox", "[", 
             RowBox[{"\<\"n\"\>", ",", "Identity", ",", 
              RowBox[{"Editable", "\[Rule]", "True"}], ",", 
              RowBox[{"Selectable", "\[Rule]", "True"}]}], "]"}], "}"}], ",", 
           
           RowBox[{"{", 
            RowBox[{"TagBox", "[", 
             RowBox[{"\<\"k\"\>", ",", "Identity", ",", 
              RowBox[{"Editable", "\[Rule]", "True"}], ",", 
              RowBox[{"Selectable", "\[Rule]", "True"}]}], "]"}], "}"}]}], 
          "}"}], "]"}], ",", "\<\")\"\>"}], "}"}], "]"}], ",", 
     RowBox[{"InterpretTemplate", "[", 
      RowBox[{
       RowBox[{"Binomial", "[", 
        RowBox[{"#1", ",", "#2"}], "]"}], "&"}], "]"}], ",", 
     RowBox[{"Editable", "\[Rule]", "False"}], ",", 
     RowBox[{"Selectable", "\[Rule]", "False"}]}], "]"}], ",", 
   "TraditionalForm"}], "]"}]], "Output",
 ImageSize->{585, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->132873138]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"box2", "=", 
  RowBox[{"ToBoxes", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "n", "}"}], ",", 
      RowBox[{"{", "k", "}"}]}], "}"}], ",", "TraditionalForm"}], 
   "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->17525767],

Cell[BoxData[
 RowBox[{"FormBox", "[", 
  RowBox[{
   RowBox[{"RowBox", "[", 
    RowBox[{"{", 
     RowBox[{"\<\"(\"\>", ",", "\<\"\[NoBreak]\"\>", ",", 
      RowBox[{"GridBox", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "\<\"n\"\>", "}"}], ",", 
          RowBox[{"{", "\<\"k\"\>", "}"}]}], "}"}], ",", 
        RowBox[{"RowSpacings", "\[Rule]", "1"}], ",", 
        RowBox[{"ColumnSpacings", "\[Rule]", "1"}], ",", 
        RowBox[{"ColumnAlignments", "\[Rule]", "Left"}]}], "]"}], 
      ",", "\<\"\[NoBreak]\"\>", ",", "\<\")\"\>"}], "}"}], "]"}], ",", 
   "TraditionalForm"}], "]"}]], "Output",
 ImageSize->{494, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->219397724]
}, Open  ]],

Cell["The resulting box structures can unambiguously interpreted:", \
"ExampleText",
 CellID->112670472],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "/@", 
  RowBox[{"{", 
   RowBox[{"box1", ",", "box2"}], "}"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->586451703],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Binomial", "[", 
    RowBox[{"n", ",", "k"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "n", "}"}], ",", 
     RowBox[{"{", "k", "}"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{192, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->237532615]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11544],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Annotation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Annotation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InterpretationBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InterpretationBox"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FormBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FormBox"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToExpression"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->1056]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1511],

Cell[TextData[ButtonBox["Representing Textual Forms by Boxes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/RepresentingTextualFormsByBoxes"]], "Tutorials",\

 CellID->32125]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Defining Custom Notation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DefiningCustomNotation"]], "MoreAbout",
 CellID->118171579],

Cell[TextData[ButtonBox["Low-Level Notebook Structure",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LowLevelNotebookStructure"]], "MoreAbout",
 CellID->523498192]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TagBox - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 26, 7.3159268}", "context" -> "System`", 
    "keywords" -> {
     "hidden box data", "magic cookies", "disambiguation", 
      "interpretation data", "interpretation hints", "parsing hints", 
      "parsing interpretation", "semantic hints", "semantic markup"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "TagBox[boxes, tag] is a low-level box construct that displays as boxes \
but maintains tag to guide the interpretation of boxes on input. ", 
    "synonyms" -> {"tag box"}, "title" -> "TagBox", "type" -> "Symbol", "uri" -> 
    "ref/TagBox"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8578, 282, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->475339463]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 22850, 819}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2338, 56, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2961, 83, 44, 1, 70, "ObjectName",
 CellID->19751],
Cell[3008, 86, 834, 26, 70, "Usage",
 CellID->29001]
}, Open  ]],
Cell[CellGroupData[{
Cell[3879, 117, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4357, 134, 271, 10, 70, "Notes",
 CellID->435],
Cell[4631, 146, 491, 17, 70, "Notes",
 CellID->16693],
Cell[5125, 165, 276, 10, 70, "Notes",
 CellID->15072],
Cell[5404, 177, 69, 1, 70, "Notes",
 CellID->17916],
Cell[5476, 180, 2518, 76, 70, "3ColumnTableMod",
 CellID->6716],
Cell[7997, 258, 544, 19, 70, "Notes",
 CellID->25328]
}, Closed]],
Cell[CellGroupData[{
Cell[8578, 282, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->475339463],
Cell[CellGroupData[{
Cell[8963, 296, 147, 5, 70, "ExampleSection",
 CellID->77876237],
Cell[9113, 303, 221, 7, 70, "ExampleText",
 CellID->110280404],
Cell[CellGroupData[{
Cell[9359, 314, 277, 9, 28, "Input",
 CellID->177567825],
Cell[9639, 325, 237, 10, 50, "Output",
 CellID->204224202]
}, Open  ]],
Cell[9891, 338, 125, 3, 70, "ExampleDelimiter",
 CellID->243599250],
Cell[10019, 343, 251, 8, 70, "ExampleText",
 CellID->85956211],
Cell[CellGroupData[{
Cell[10295, 355, 183, 6, 70, "Input",
 CellID->986414560],
Cell[10481, 363, 600, 18, 54, "Output",
 CellID->133425516]
}, Open  ]],
Cell[11096, 384, 80, 1, 70, "ExampleText",
 CellID->108907752],
Cell[CellGroupData[{
Cell[11201, 389, 110, 3, 70, "Input",
 CellID->14089127],
Cell[11314, 394, 274, 11, 36, "Output",
 CellID->198640844]
}, Open  ]],
Cell[11603, 408, 239, 8, 70, "ExampleText",
 CellID->386901217],
Cell[CellGroupData[{
Cell[11867, 420, 135, 5, 70, "Input",
 CellID->289978176],
Cell[12005, 427, 177, 6, 51, "Output",
 CellID->27409304]
}, Open  ]],
Cell[12197, 436, 125, 3, 70, "ExampleDelimiter",
 CellID->292428007],
Cell[12325, 441, 220, 8, 70, "ExampleText",
 CellID->248723986],
Cell[CellGroupData[{
Cell[12570, 453, 301, 10, 70, "Input",
 CellID->574946869],
Cell[12874, 465, 251, 9, 36, "Output",
 CellID->121957146]
}, Open  ]],
Cell[13140, 477, 237, 8, 70, "ExampleText",
 CellID->18048885],
Cell[CellGroupData[{
Cell[13402, 489, 429, 14, 70, "Input",
 CellID->27669645],
Cell[13834, 505, 173, 5, 50, "Output",
 CellID->209422466]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14056, 516, 216, 7, 70, "ExampleSection",
 CellID->12021],
Cell[14275, 525, 138, 4, 70, "ExampleText",
 CellID->634846733],
Cell[CellGroupData[{
Cell[14438, 533, 322, 11, 70, "Input",
 CellID->575466946],
Cell[14763, 546, 706, 16, 70, "Output",
 Evaluatable->False,
 CellID->55011623]
}, Open  ]],
Cell[15484, 565, 217, 8, 70, "ExampleText",
 CellID->524816125],
Cell[CellGroupData[{
Cell[15726, 577, 234, 8, 70, "Input",
 CellID->232301458],
Cell[15963, 587, 1277, 34, 105, "Output",
 CellID->132873138]
}, Open  ]],
Cell[CellGroupData[{
Cell[17277, 626, 275, 10, 70, "Input",
 CellID->17525767],
Cell[17555, 638, 774, 21, 54, "Output",
 CellID->219397724]
}, Open  ]],
Cell[18344, 662, 104, 2, 70, "ExampleText",
 CellID->112670472],
Cell[CellGroupData[{
Cell[18473, 668, 157, 5, 70, "Input",
 CellID->586451703],
Cell[18633, 675, 366, 13, 36, "Output",
 CellID->237532615]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19060, 695, 311, 9, 70, "SeeAlsoSection",
 CellID->11544],
Cell[19374, 706, 968, 35, 70, "SeeAlso",
 CellID->1056]
}, Open  ]],
Cell[CellGroupData[{
Cell[20379, 746, 313, 9, 70, "TutorialsSection",
 CellID->1511],
Cell[20695, 757, 179, 4, 70, "Tutorials",
 CellID->32125]
}, Open  ]],
Cell[CellGroupData[{
Cell[20911, 766, 299, 8, 70, "MoreAboutSection"],
Cell[21213, 776, 158, 3, 70, "MoreAbout",
 CellID->118171579],
Cell[21374, 781, 165, 3, 70, "MoreAbout",
 CellID->523498192]
}, Open  ]],
Cell[21554, 787, 27, 0, 70, "History"],
Cell[21584, 789, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

