(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     36512,       1416]
NotebookOptionsPosition[     27380,       1098]
NotebookOutlinePosition[     29026,       1144]
CellTagsIndexPosition[     28898,       1138]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Associating Definitions with Different Symbols" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AssociatingDefinitionsWithDifferentSymbols"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Associating Definitions with Different Symbols\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TagSetDelayed" :> 
          Documentation`HelpLookup["paclet:ref/TagSetDelayed"], "TagUnset" :> 
          Documentation`HelpLookup["paclet:ref/TagUnset"], "Set" :> 
          Documentation`HelpLookup["paclet:ref/Set"], "UpSet" :> 
          Documentation`HelpLookup["paclet:ref/UpSet"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"TagSetDelayed\"\>", 2->"\<\"TagUnset\"\>", 
       3->"\<\"Set\"\>", 4->"\<\"UpSet\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Package Development" :> 
          Documentation`HelpLookup["paclet:guide/PackageDevelopment"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Package Development\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "TagSet ",
 StyleBox["(/: =)", "OperatorCharacter"]
}], "ObjectName",
 CellID->30906],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "/:", 
       StyleBox["lhs", "TI"], "=", 
       StyleBox["rhs", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]assigns ",
     Cell[BoxData[
      StyleBox["rhs", "TI"]], "InlineFormula"],
     " to be the value of ",
     Cell[BoxData[
      StyleBox["lhs", "TI"]], "InlineFormula"],
     ", and associates the assignment with the symbol ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8314]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TagSet",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagSet"]], "InlineFormula"],
 " defines upvalues or downvalues as appropriate. "
}], "Notes",
 CellID->10350],

Cell[TextData[{
 "The symbol ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "/:", 
   StyleBox["lhs", "TI"], "=", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 " must appear in ",
 Cell[BoxData[
  StyleBox["lhs", "TI"]], "InlineFormula"],
 " as the head of ",
 Cell[BoxData[
  StyleBox["lhs", "TI"]], "InlineFormula"],
 ", the head of the head, one of the elements of ",
 Cell[BoxData[
  StyleBox["lhs", "TI"]], "InlineFormula"],
 ", or the head of one of the elements. "
}], "Notes",
 CellID->4586],

Cell[TextData[{
 "A common case is ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "/:", 
   RowBox[{
    StyleBox["h", "TI"], "[", 
    RowBox[{
     StyleBox["f", "TI"], "[", 
     StyleBox["args", "TI"], "]"}], "]"}], "=", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5279],

Cell[TextData[{
 "You can see all the rules associated with a particular symbol by typing ",
 Cell[BoxData[
  RowBox[{"?", 
   StyleBox["symbol", "TI"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->17776],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " appears several times in ",
 Cell[BoxData[
  StyleBox["lhs", "TI"]], "InlineFormula"],
 ", then ",
 Cell[BoxData[
  RowBox[{
   StyleBox["f", "TI"], "/:", 
   StyleBox["lhs", "TI"], "=", 
   StyleBox["rhs", "TI"]}]], "InlineFormula"],
 " associates the assignment with each occurrence. "
}], "Notes",
 CellID->25822],

Cell[TextData[{
 "When it appears in unevaluated symbolic form, ",
 Cell[BoxData[
  ButtonBox["TagSet",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagSet"]], "InlineFormula"],
 " is treated as a scoping construct so that variables in nested occurrences \
are renamed if necessary. "
}], "Notes",
 CellID->6879]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->212857136],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->418105097],

Cell["Define a symbolic property of a symbol:", "ExampleText",
 CellID->87490164],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"square", "/:", 
  RowBox[{"area", "[", "square", "]"}], "=", 
  RowBox[{"s", "^", "2"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->493040914],

Cell[BoxData[
 SuperscriptBox["s", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->472743995]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18200],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Different Kinds of Values",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->438015421],

Cell["For ownvalues, the tag is redundant:", "ExampleText",
 CellID->143130497],

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", "/:", "x", "=", "7"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"y", "=", "7"}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->313909595],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"OwnValues", "[", "x", "]"}], ",", 
   RowBox[{"OwnValues", "[", "y", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2630808],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"HoldPattern", "[", "x", "]"}], "\[RuleDelayed]", "7"}], "}"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"HoldPattern", "[", "y", "]"}], "\[RuleDelayed]", "7"}], "}"}]}],
   "}"}]], "Output",
 ImageSize->{300, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->368664742]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->246135006],

Cell["For downvalues, the tag is redundant:", "ExampleText",
 CellID->252214741],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "/:", 
   RowBox[{"a", "[", "zeta", "]"}], "=", "theta"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"b", "[", "zeta", "]"}], "=", "theta"}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->112103390],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"DownValues", "[", "a", "]"}], ",", 
   RowBox[{"DownValues", "[", "b", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->467586206],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"HoldPattern", "[", 
      RowBox[{"a", "[", "zeta", "]"}], "]"}], "\[RuleDelayed]", "theta"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"HoldPattern", "[", 
      RowBox[{"b", "[", "zeta", "]"}], "]"}], "\[RuleDelayed]", "theta"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{440, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->349206785]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->318029046],

Cell["Use a tag to define upvalues:", "ExampleText",
 CellID->716732190],

Cell[BoxData[{
 RowBox[{
  RowBox[{"zeta", "/:", 
   RowBox[{"a", "[", "zeta", "]"}], "=", "theta"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"b", "[", "zeta", "]"}], "=", "theta"}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->850119981],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"UpValues", "[", "zeta", "]"}], ",", 
   RowBox[{"DownValues", "[", "b", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->180075138],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"HoldPattern", "[", 
      RowBox[{"a", "[", "zeta", "]"}], "]"}], "\[RuleDelayed]", "theta"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"HoldPattern", "[", 
      RowBox[{"b", "[", "zeta", "]"}], "]"}], "\[RuleDelayed]", "theta"}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{440, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->369254684]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18061],

Cell["Build a database of exchange rates:", "ExampleText",
 CellID->760968492],

Cell[BoxData[{
 RowBox[{
  RowBox[{"chf", "/:", 
   RowBox[{"rate", "[", "chf", "]"}], "=", "0.812"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"eur", "/:", 
   RowBox[{"rate", "[", "eur", "]"}], "=", "1.317"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"gbp", "/:", 
   RowBox[{"rate", "[", "gbp", "]"}], "=", "1.963"}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->246367948],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"rate", "[", "chf", "]"}], "/", 
  RowBox[{"rate", "[", "eur", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16819144],

Cell[BoxData["0.6165527714502659`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->837107238]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2647],

Cell[TextData[{
 Cell[BoxData["^="], "InlineFormula"],
 " defines upvalues in the same way as using a tag does:"
}], "ExampleText",
 CellID->66289569],

Cell[BoxData[{
 RowBox[{
  RowBox[{"square", "/:", 
   RowBox[{"area", "[", "square", "]"}], "=", 
   RowBox[{"a", "^", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"area", "[", "rectangle", "]"}], "^=", 
   RowBox[{"a", "*", "b"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->429617745],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"UpValues", "[", "square", "]"}], ",", 
   RowBox[{"UpValues", "[", "rectangle", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10330739],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"HoldPattern", "[", 
      RowBox[{"area", "[", "square", "]"}], "]"}], "\[RuleDelayed]", 
     SuperscriptBox["a", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"HoldPattern", "[", 
      RowBox[{"area", "[", "rectangle", "]"}], "]"}], "\[RuleDelayed]", 
     RowBox[{"a", " ", "b"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{490, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->840562289]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->197068002],

Cell["\<\
The right side of an immediate definition is evaluated when the definition is \
made: \
\>", "ExampleText",
 CellID->250240923],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", "/:", 
   RowBox[{"rand", "[", "int", "]"}], "=", 
   RowBox[{"Random", "[", "Integer", "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->425316542],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"rand", "[", "int", "]"}], ",", 
   RowBox[{"rand", "[", "int", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->713048083],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->88361489]
}, Open  ]],

Cell["\<\
The right side of a delayed definition is evaluated each time the definition \
is used: \
\>", "ExampleText",
 CellID->579487176],

Cell[BoxData[
 RowBox[{"real", "/:", 
  RowBox[{"rand", "[", "real", "]"}], ":=", 
  RowBox[{"Random", "[", "Real", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->114998281],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"rand", "[", "real", "]"}], ",", 
   RowBox[{"rand", "[", "real", "]"}]}], "}"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->206362787],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.1046895357637039`", ",", "0.6297683110287378`"}], 
  "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->98147448]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->180573554],

Cell["Definitions with the same left side overwrite earlier ones:", \
"ExampleText",
 CellID->568194695],

Cell[BoxData[
 RowBox[{
  RowBox[{"sq", "/:", 
   RowBox[{"area", "[", "sq", "]"}], "=", 
   RowBox[{"a", "^", "2"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->60469846],

Cell[BoxData[
 RowBox[{
  RowBox[{"sq", "/:", 
   RowBox[{"area", "[", "sq", "]"}], "=", 
   RowBox[{"s", "^", "2"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->79552946],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"area", "[", "sq", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->583637389],

Cell[BoxData[
 SuperscriptBox["s", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->330695174]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->297742266],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Definition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Definition"]], "InlineFormula"],
 " prints definitions associated with a symbol:"
}], "ExampleText",
 CellID->1693501],

Cell[BoxData[
 RowBox[{
  RowBox[{"sq", "/:", 
   RowBox[{"area", "[", "sq", "]"}], "=", 
   RowBox[{"a", "^", "2"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->38967361],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "sq", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->283680345],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1VF2PAVEMrftBJIRMyHrjz+DJI+8T2YQHIdbf3n3gB9B7taOqrGyyk4zO
aXtOO+1cs/Kw+tyUh/WyHE335W61Xn6NJts9unwNwI0BoDMAfD7jU775muIN
MMRfh+42Wo/WEeasosoCX7lztsROYWZ3MztFIwbBZ5gvTzCQjRxWqikehJXx
AfESOF6lqULVU5RvnOpGpRHMLF3J1rK9mtuiLutmdrKnf+091w03bM9Z4o9f
OuW9aB25R2tfyc97f39uDVJ7MakgtRxr/XFfL3YtswxmNJntN6bJU3H6lFAs
kNVfgDxBFvfhOyCc4h1Rl9N+ztZpLxRuKNxT+F4p9VWQbarMvsH8zszF08hc
vcet2nMOT/76nwe1C3UawUI=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->786706183]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Information",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Information"]], "InlineFormula"],
 " prints various information about a symbol, including any definitions:"
}], "ExampleText",
 CellID->142512223],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "sq"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->147364646],

Cell[CellGroupData[{

Cell["Cell$$8060`sq", "Print", "PrintUsage",
 CellTags->"Info3381491823-8148796",
 CellID->230038617],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"area", "[", "sq", "]"}], "^=", 
         SuperscriptBox["a", "2"]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["sq"],
  Editable->False]], "Print",
 CellTags->"Info3381491823-8148796",
 CellID->33078513]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["UpValues",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UpValues"]], "InlineFormula"],
 " returns a list of rules corresponding the any upvalues defined:"
}], "ExampleText",
 CellID->34795162],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UpValues", "[", "sq", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->284210482],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", 
    RowBox[{"area", "[", "sq", "]"}], "]"}], "\[RuleDelayed]", 
   SuperscriptBox["a", "2"]}], "}"}]], "Output",
 ImageSize->{194, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->443206086]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22103626],

Cell[TextData[{
 "Use ",
 Cell[BoxData["=."], "InlineFormula"],
 " to clear definitions with a particular left-hand side:"
}], "ExampleText",
 CellID->292515749],

Cell[BoxData[{
 RowBox[{
  RowBox[{"sq", "/:", 
   RowBox[{"area", "[", "sq", "]"}], "=", 
   RowBox[{"s", "^", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sq", "/:", 
   RowBox[{"circ", "[", "sq", "]"}], "=", 
   RowBox[{"4", "s"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->521509637],

Cell[BoxData[
 RowBox[{"sq", "/:", 
  RowBox[{
   RowBox[{"circ", "[", "sq", "]"}], "=."}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->538346729],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"area", "[", "sq", "]"}], ",", 
   RowBox[{"circ", "[", "sq", "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->230290196],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SuperscriptBox["s", "2"], ",", 
   RowBox[{"circ", "[", "sq", "]"}]}], "}"}]], "Output",
 ImageSize->{98, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->483485825]
}, Open  ]],

Cell["Clear all definitions:", "ExampleText",
 CellID->57250942],

Cell[BoxData[
 RowBox[{"Clear", "[", "sq", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->634107459],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "sq", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->21692100],

Cell[BoxData[
 InterpretationBox["Null",
  Definition[$CellContext`sq],
  Editable->False]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->135239025]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5939],

Cell["\<\
In the presence of global variables, pattern variables may show unexpected \
behavior:\
\>", "ExampleText",
 CellID->898057320],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "5"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1874618489],

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "/:", 
   RowBox[{"f", "[", 
    RowBox[{"h", "[", "x_", "]"}], "]"}], "=", 
   RowBox[{"x", "^", "2"}]}], ";"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->368568924],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"h", "[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->464224334],

Cell[BoxData["25"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->265711033]
}, Open  ]],

Cell["Delayed assignments behave as expected:", "ExampleText",
 CellID->673914482],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "/:", 
   RowBox[{"f", "[", 
    RowBox[{"g", "[", "x_", "]"}], "]"}], ":=", 
   RowBox[{"x", "^", "2"}]}], ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->933709351],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"g", "[", "2", "]"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->765557145],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->50387774]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->798095414],

Cell["Use upvalues to assign to subscripted variables:", "ExampleText",
 CellID->1766750295],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "/:", 
   SubscriptBox["a", "1"], "=", "5"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1199965139],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"UpValues", "[", "a", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1823162230],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"List", "[", 
    RowBox[{"RuleDelayed", "[", 
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       RowBox[{"Subscript", "[", 
        RowBox[{"a", ",", "1"}], "]"}], "]"}], ",", "5"}], "]"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{349, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->287017400]
}, Open  ]],

Cell["Subscripted variables are distinct from indexed variables:", \
"ExampleText",
 CellID->1540210261],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"a", "[", "1", "]"}], "=", "6"}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1486088629],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"DownValues", "[", "a", "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->2036651984],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"List", "[", 
    RowBox[{"RuleDelayed", "[", 
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       RowBox[{"a", "[", "1", "]"}], "]"}], ",", "6"}], "]"}], "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{275, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//FullForm=",
 CellID->770536858]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32570],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TagSetDelayed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TagSetDelayed"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TagUnset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TagUnset"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Set",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Set"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["UpSet",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UpSet"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6038]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32301],

Cell[TextData[ButtonBox["Associating Definitions with Different Symbols",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AssociatingDefinitionsWithDifferentSymbols"]], "Tutorials",\

 CellID->15812]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->2534128],

Cell[TextData[ButtonBox["Package Development",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PackageDevelopment"]], "MoreAbout",
 CellID->670743108]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TagSet (/: =) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 26, 8.3159524}", "context" -> "System`", 
    "keywords" -> {
     "associating values", "setting values", "associating values with types", 
      "generic programming", "object programming"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "f /: lhs = rhs assigns rhs to be the value of lhs, and associates the \
assignment with the symbol f. ", "synonyms" -> {"tag set", "/:"}, "title" -> 
    "TagSet", "type" -> "Symbol", "uri" -> "ref/TagSet"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6127, 216, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->212857136]},
 "Info3381491823-8148796"->{
  Cell[17938, 704, 101, 2, 70, "Print",
   CellTags->"Info3381491823-8148796",
   CellID->230038617],
  Cell[18042, 708, 780, 23, 70, "Print",
   CellTags->"Info3381491823-8148796",
   CellID->33078513]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 28521, 1124},
 {"Info3381491823-8148796", 28670, 1128}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2104, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2727, 78, 102, 4, 70, "ObjectName",
 CellID->30906],
Cell[2832, 84, 707, 23, 70, "Usage",
 CellID->8314]
}, Open  ]],
Cell[CellGroupData[{
Cell[3576, 112, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4054, 129, 211, 7, 70, "Notes",
 CellID->10350],
Cell[4268, 138, 574, 21, 70, "Notes",
 CellID->4586],
Cell[4845, 161, 312, 13, 70, "Notes",
 CellID->5279],
Cell[5160, 176, 208, 7, 70, "Notes",
 CellID->17776],
Cell[5371, 185, 400, 15, 70, "Notes",
 CellID->25822],
Cell[5774, 202, 316, 9, 70, "Notes",
 CellID->6879]
}, Closed]],
Cell[CellGroupData[{
Cell[6127, 216, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->212857136],
Cell[CellGroupData[{
Cell[6512, 230, 148, 5, 70, "ExampleSection",
 CellID->418105097],
Cell[6663, 237, 81, 1, 70, "ExampleText",
 CellID->87490164],
Cell[CellGroupData[{
Cell[6769, 242, 167, 5, 28, "Input",
 CellID->493040914],
Cell[6939, 249, 181, 6, 36, "Output",
 CellID->472743995]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7169, 261, 216, 7, 70, "ExampleSection",
 CellID->18200],
Cell[CellGroupData[{
Cell[7410, 272, 246, 7, 70, "ExampleSubsection",
 CellID->438015421],
Cell[7659, 281, 79, 1, 70, "ExampleText",
 CellID->143130497],
Cell[7741, 284, 191, 6, 70, "Input",
 CellID->313909595],
Cell[CellGroupData[{
Cell[7957, 294, 187, 6, 70, "Input",
 CellID->2630808],
Cell[8147, 302, 417, 15, 36, "Output",
 CellID->368664742]
}, Open  ]],
Cell[8579, 320, 125, 3, 70, "ExampleDelimiter",
 CellID->246135006],
Cell[8707, 325, 80, 1, 70, "ExampleText",
 CellID->252214741],
Cell[8790, 328, 266, 9, 70, "Input",
 CellID->112103390],
Cell[CellGroupData[{
Cell[9081, 341, 191, 6, 70, "Input",
 CellID->467586206],
Cell[9275, 349, 498, 17, 36, "Output",
 CellID->349206785]
}, Open  ]],
Cell[9788, 369, 125, 3, 70, "ExampleDelimiter",
 CellID->318029046],
Cell[9916, 374, 72, 1, 70, "ExampleText",
 CellID->716732190],
Cell[9991, 377, 269, 9, 70, "Input",
 CellID->850119981],
Cell[CellGroupData[{
Cell[10285, 390, 192, 6, 70, "Input",
 CellID->180075138],
Cell[10480, 398, 498, 17, 36, "Output",
 CellID->369254684]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[11039, 422, 223, 7, 70, "ExampleSection",
 CellID->18061],
Cell[11265, 431, 78, 1, 70, "ExampleText",
 CellID->760968492],
Cell[11346, 434, 407, 13, 70, "Input",
 CellID->246367948],
Cell[CellGroupData[{
Cell[11778, 451, 157, 5, 70, "Input",
 CellID->16819144],
Cell[11938, 458, 176, 5, 36, "Output",
 CellID->837107238]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12163, 469, 232, 7, 70, "ExampleSection",
 CellID->2647],
Cell[12398, 478, 150, 4, 70, "ExampleText",
 CellID->66289569],
Cell[12551, 484, 322, 10, 70, "Input",
 CellID->429617745],
Cell[CellGroupData[{
Cell[12898, 498, 199, 6, 70, "Input",
 CellID->10330739],
Cell[13100, 506, 546, 17, 39, "Output",
 CellID->840562289]
}, Open  ]],
Cell[13661, 526, 125, 3, 70, "ExampleDelimiter",
 CellID->197068002],
Cell[13789, 531, 137, 4, 70, "ExampleText",
 CellID->250240923],
Cell[13929, 537, 197, 6, 70, "Input",
 CellID->425316542],
Cell[CellGroupData[{
Cell[14151, 547, 183, 6, 70, "Input",
 CellID->713048083],
Cell[14337, 555, 202, 7, 36, "Output",
 CellID->88361489]
}, Open  ]],
Cell[14554, 565, 139, 4, 70, "ExampleText",
 CellID->579487176],
Cell[14696, 571, 177, 5, 70, "Input",
 CellID->114998281],
Cell[CellGroupData[{
Cell[14898, 580, 185, 6, 70, "Input",
 CellID->206362787],
Cell[15086, 588, 242, 8, 36, "Output",
 CellID->98147448]
}, Open  ]],
Cell[15343, 599, 125, 3, 70, "ExampleDelimiter",
 CellID->180573554],
Cell[15471, 604, 104, 2, 70, "ExampleText",
 CellID->568194695],
Cell[15578, 608, 178, 6, 70, "Input",
 CellID->60469846],
Cell[15759, 616, 178, 6, 70, "Input",
 CellID->79552946],
Cell[CellGroupData[{
Cell[15962, 626, 101, 3, 70, "Input",
 CellID->583637389],
Cell[16066, 631, 181, 6, 36, "Output",
 CellID->330695174]
}, Open  ]],
Cell[16262, 640, 125, 3, 70, "ExampleDelimiter",
 CellID->297742266],
Cell[16390, 645, 224, 7, 70, "ExampleText",
 CellID->1693501],
Cell[16617, 654, 178, 6, 70, "Input",
 CellID->38967361],
Cell[CellGroupData[{
Cell[16820, 664, 107, 3, 70, "Input",
 CellID->283680345],
Cell[16930, 669, 602, 14, 70, "Output",
 Evaluatable->False,
 CellID->786706183]
}, Open  ]],
Cell[17547, 686, 253, 7, 70, "ExampleText",
 CellID->142512223],
Cell[CellGroupData[{
Cell[17825, 697, 88, 3, 70, "Input",
 CellID->147364646],
Cell[CellGroupData[{
Cell[17938, 704, 101, 2, 70, "Print",
 CellTags->"Info3381491823-8148796",
 CellID->230038617],
Cell[18042, 708, 780, 23, 70, "Print",
 CellTags->"Info3381491823-8148796",
 CellID->33078513]
}, Open  ]]
}, Open  ]],
Cell[18849, 735, 240, 7, 70, "ExampleText",
 CellID->34795162],
Cell[CellGroupData[{
Cell[19114, 746, 105, 3, 70, "Input",
 CellID->284210482],
Cell[19222, 751, 315, 10, 39, "Output",
 CellID->443206086]
}, Open  ]],
Cell[19552, 764, 124, 3, 70, "ExampleDelimiter",
 CellID->22103626],
Cell[19679, 769, 161, 5, 70, "ExampleText",
 CellID->292515749],
Cell[19843, 776, 313, 10, 70, "Input",
 CellID->521509637],
Cell[20159, 788, 146, 5, 70, "Input",
 CellID->538346729],
Cell[CellGroupData[{
Cell[20330, 797, 181, 6, 70, "Input",
 CellID->230290196],
Cell[20514, 805, 261, 9, 39, "Output",
 CellID->483485825]
}, Open  ]],
Cell[20790, 817, 64, 1, 70, "ExampleText",
 CellID->57250942],
Cell[20857, 820, 102, 3, 70, "Input",
 CellID->634107459],
Cell[CellGroupData[{
Cell[20984, 827, 106, 3, 70, "Input",
 CellID->21692100],
Cell[21093, 832, 232, 8, 36, "Output",
 CellID->135239025]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21374, 846, 225, 7, 70, "ExampleSection",
 CellID->5939],
Cell[21602, 855, 137, 4, 70, "ExampleText",
 CellID->898057320],
Cell[21742, 861, 111, 4, 70, "Input",
 CellID->1874618489],
Cell[21856, 867, 205, 7, 70, "Input",
 CellID->368568924],
Cell[CellGroupData[{
Cell[22086, 878, 125, 4, 70, "Input",
 CellID->464224334],
Cell[22214, 884, 159, 5, 36, "Output",
 CellID->265711033]
}, Open  ]],
Cell[22388, 892, 82, 1, 70, "ExampleText",
 CellID->673914482],
Cell[22473, 895, 206, 7, 70, "Input",
 CellID->933709351],
Cell[CellGroupData[{
Cell[22704, 906, 125, 4, 70, "Input",
 CellID->765557145],
Cell[22832, 912, 157, 5, 36, "Output",
 CellID->50387774]
}, Open  ]],
Cell[23004, 920, 125, 3, 70, "ExampleDelimiter",
 CellID->798095414],
Cell[23132, 925, 92, 1, 70, "ExampleText",
 CellID->1766750295],
Cell[23227, 928, 145, 5, 70, "Input",
 CellID->1199965139],
Cell[CellGroupData[{
Cell[23397, 937, 140, 4, 70, "Input",
 CellID->1823162230],
Cell[23540, 943, 500, 17, 50, "Output",
 CellID->287017400]
}, Open  ]],
Cell[24055, 963, 104, 2, 70, "ExampleText",
 CellID->1540210261],
Cell[24162, 967, 140, 5, 70, "Input",
 CellID->1486088629],
Cell[CellGroupData[{
Cell[24327, 976, 142, 4, 70, "Input",
 CellID->2036651984],
Cell[24472, 982, 463, 16, 50, "Output",
 CellID->770536858]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24996, 1005, 311, 9, 70, "SeeAlsoSection",
 CellID->32570],
Cell[25310, 1016, 934, 35, 70, "SeeAlso",
 CellID->6038]
}, Open  ]],
Cell[CellGroupData[{
Cell[26281, 1056, 314, 9, 70, "TutorialsSection",
 CellID->32301],
Cell[26598, 1067, 204, 5, 70, "Tutorials",
 CellID->15812]
}, Open  ]],
Cell[CellGroupData[{
Cell[26839, 1077, 317, 9, 70, "MoreAboutSection",
 CellID->2534128],
Cell[27159, 1088, 149, 3, 70, "MoreAbout",
 CellID->670743108]
}, Open  ]],
Cell[27323, 1094, 27, 0, 70, "History"],
Cell[27353, 1096, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

