(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     38359,       1479]
NotebookOptionsPosition[     28598,       1140]
NotebookOutlinePosition[     30278,       1187]
CellTagsIndexPosition[     30150,       1181]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Associating Definitions with Different Symbols" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AssociatingDefinitionsWithDifferentSymbols"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Associating Definitions with Different Symbols\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"SetDelayed" :> 
          Documentation`HelpLookup["paclet:ref/SetDelayed"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"SetDelayed\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "TagSetDelayed ",
 StyleBox["(/: :=)", "OperatorCharacter"]
}], "ObjectName",
 CellID->9729],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "/:", 
       StyleBox["lhs", "TI"], ":=", 
       StyleBox["rhs", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]assigns ",
     Cell[BoxData[
      StyleBox["rhs", "TI"]], "InlineFormula"],
     " to be the delayed value of ",
     Cell[BoxData[
      StyleBox["lhs", "TI"]], "InlineFormula"],
     ", and associates the assignment with the symbol ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24008]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->19309527],

Cell[BoxData[
 RowBox[{"g", "/:", 
  RowBox[{"f", "[", 
   RowBox[{"g", "[", "x_", "]"}], "]"}], ":=", 
  RowBox[{"fg", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->66289853],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"g", "[", "2", "]"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"h", "[", "2", "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->705566126],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"fg", "[", "2", "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"h", "[", "2", "]"}], "]"}]}], "}"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1008953992]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->27936],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Left-Hand Sides",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->214715367],

Cell["\<\
An expression with a delayed definition is evaluated every time it is used:\
\>", "ExampleText",
 CellID->14205805],

Cell[BoxData[
 RowBox[{"int", "/:", 
  RowBox[{"rand", "[", "int", "]"}], ":=", 
  RowBox[{"Random", "[", "Integer", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->66248155],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"rand", "[", "int", "]"}], ",", 
   RowBox[{"{", "5", "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->68775699],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "0", ",", "1", ",", "1"}], "}"}]], "Output",
 ImageSize->{98, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->45488115]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->79101227],

Cell["\<\
Make definitions for special and general cases using immediate and delayed \
assignments:\
\>", "ExampleText",
 CellID->849799875],

Cell[BoxData[{
 RowBox[{
  RowBox[{"h", "/:", 
   RowBox[{"f", "[", 
    RowBox[{"h", "[", "0", "]"}], "]"}], "=", "h0"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"h", "/:", 
  RowBox[{"f", "[", 
   RowBox[{"h", "[", "x_", "]"}], "]"}], ":=", 
  RowBox[{"2", 
   RowBox[{"f", "[", 
    RowBox[{"h", "[", 
     RowBox[{"x", "-", "1"}], "]"}], "]"}]}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->1855274059],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"h", "[", "10", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1897187131],

Cell[BoxData[
 RowBox[{"1024", " ", "h0"}]], "Output",
 ImageSize->{49, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->198658389]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->168657331],

Cell["The tag can appear as an argument of the left side:", "ExampleText",
 CellID->127941899],

Cell[BoxData[
 RowBox[{"sq", "/:", 
  RowBox[{"area", "[", 
   RowBox[{"sq", ",", "s_"}], "]"}], ":=", 
  RowBox[{"s", "^", "2"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->528585766],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"area", "[", 
  RowBox[{"sq", ",", "2"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->102382228],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->274451634]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->561126416],

Cell["\<\
The tag can appear as the head of an argument of the left side:\
\>", "ExampleText",
 CellID->41854356],

Cell[BoxData[
 RowBox[{"sq", "/:", 
  RowBox[{"area", "[", 
   RowBox[{"sq", "[", "s_", "]"}], "]"}], ":=", 
  RowBox[{"s", "^", "2"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->961758164],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"area", "[", 
  RowBox[{"sq", "[", "3", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->98200665],

Cell[BoxData["9"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3510171]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Different Kinds of Values",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->438015421],

Cell["For ownvalues, the tag is redundant:", "ExampleText",
 CellID->143130497],

Cell[BoxData[{
 RowBox[{"x", "/:", "x", ":=", 
  RowBox[{"Random", "[", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"y", ":=", 
  RowBox[{"Random", "[", "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->313909595],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"OwnValues", "[", "x", "]"}], ",", 
   RowBox[{"OwnValues", "[", "y", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2630808],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"HoldPattern", "[", "x", "]"}], "\[RuleDelayed]", 
     RowBox[{"Random", "[", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"HoldPattern", "[", "y", "]"}], "\[RuleDelayed]", 
     RowBox[{"Random", "[", "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{398, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->116773010]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->246135006],

Cell["For downvalues, the tag is redundant:", "ExampleText",
 CellID->252214741],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f", "/:", 
   RowBox[{"f", "[", "x_", "]"}], ":=", 
   RowBox[{"x", "^", "2"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g", "[", "x_", "]"}], ":=", 
  RowBox[{"x", "^", "2"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->112103390],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"DownValues", "[", "f", "]"}], ",", 
   RowBox[{"DownValues", "[", "g", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->467586206],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"HoldPattern", "[", 
      RowBox[{"f", "[", "x_", "]"}], "]"}], "\[RuleDelayed]", 
     SuperscriptBox["x", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"HoldPattern", "[", 
      RowBox[{"g", "[", "x_", "]"}], "]"}], "\[RuleDelayed]", 
     SuperscriptBox["x", "2"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{367, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->580550921]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->318029046],

Cell["Use a tag to define upvalues:", "ExampleText",
 CellID->716732190],

Cell[BoxData[{
 RowBox[{"g", "/:", 
  RowBox[{"f", "[", 
   RowBox[{"g", "[", "x_", "]"}], "]"}], ":=", 
  RowBox[{"f1", "[", "x", "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"h", "[", "x_", "]"}], "]"}], ":=", 
  RowBox[{"f2", "[", "x", "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->4271581],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"UpValues", "[", "g", "]"}], ",", 
   RowBox[{"DownValues", "[", "f", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->180075138],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"HoldPattern", "[", 
      RowBox[{"f", "[", 
       RowBox[{"g", "[", "x_", "]"}], "]"}], "]"}], "\[RuleDelayed]", 
     RowBox[{"f1", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"HoldPattern", "[", 
      RowBox[{"f", "[", 
       RowBox[{"h", "[", "x_", "]"}], "]"}], "]"}], "\[RuleDelayed]", 
     RowBox[{"f2", "[", "x", "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{454, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->752688400]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7523],

Cell["Implement modular arithmetic:", "ExampleText",
 CellID->192261504],

Cell[BoxData[{
 RowBox[{"mod", "/:", 
  RowBox[{
   RowBox[{"mod", "[", 
    RowBox[{"a_", ",", "p_"}], "]"}], "+", 
   RowBox[{"mod", "[", 
    RowBox[{"b_", ",", "p_"}], "]"}]}], ":=", 
  RowBox[{"mod", "[", 
   RowBox[{
    RowBox[{"Mod", "[", 
     RowBox[{
      RowBox[{"a", "+", "b"}], ",", "p"}], "]"}], ",", "p"}], "]"}]}], "\n", 
 RowBox[{"mod", "/:", 
  RowBox[{"i_Integer", " ", 
   RowBox[{"mod", "[", 
    RowBox[{"a_", ",", "p_"}], "]"}]}], ":=", 
  RowBox[{"mod", "[", 
   RowBox[{
    RowBox[{"Mod", "[", 
     RowBox[{
      RowBox[{"i", " ", "a"}], ",", "p"}], "]"}], ",", "p"}], 
   "]"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->79245154],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"mod", "[", 
   RowBox[{"2", ",", "5"}], "]"}], "+", 
  RowBox[{"3", " ", 
   RowBox[{"mod", "[", 
    RowBox[{"3", ",", "5"}], "]"}]}], "-", 
  RowBox[{"mod", "[", 
   RowBox[{"1", ",", "5"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->66544906],

Cell[BoxData[
 RowBox[{"mod", "[", 
  RowBox[{"0", ",", "5"}], "]"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->156814849]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26364],

Cell[TextData[{
 Cell[BoxData["^:="], "InlineFormula"],
 " defines upvalues in the same way as using a tag does:"
}], "ExampleText",
 CellID->66289569],

Cell[BoxData[
 RowBox[{"g", "/:", 
  RowBox[{"f", "[", 
   RowBox[{"g", "[", "x_", "]"}], "]"}], ":=", 
  RowBox[{"f1", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->757332850],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"h", "[", "x_", "]"}], "]"}], "^:=", 
  RowBox[{"f2", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->152746548],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"UpValues", "[", "g", "]"}], ",", 
   RowBox[{"UpValues", "[", "h", "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->17921066],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"HoldPattern", "[", 
      RowBox[{"f", "[", 
       RowBox[{"g", "[", "x_", "]"}], "]"}], "]"}], "\[RuleDelayed]", 
     RowBox[{"f1", "[", "x", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"HoldPattern", "[", 
      RowBox[{"f", "[", 
       RowBox[{"h", "[", "x_", "]"}], "]"}], "]"}], "\[RuleDelayed]", 
     RowBox[{"f2", "[", "x", "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{454, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->714879033]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->120594621],

Cell[TextData[{
 "A tag defines only one upvalue, ",
 Cell[BoxData["^:="], "InlineFormula"],
 " makes definitions for all symbols:"
}], "ExampleText",
 CellID->181338931],

Cell[BoxData[
 RowBox[{"g", "/:", 
  RowBox[{"f1", "[", 
   RowBox[{
    RowBox[{"g", "[", "x_", "]"}], ",", 
    RowBox[{"h", "[", "y_", "]"}]}], "]"}], ":=", 
  RowBox[{"gh", "[", 
   RowBox[{"x", " ", "y"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->270589337],

Cell[BoxData[
 RowBox[{
  RowBox[{"f2", "[", 
   RowBox[{
    RowBox[{"g", "[", "x_", "]"}], ",", 
    RowBox[{"h", "[", "y_", "]"}]}], "]"}], "^:=", 
  RowBox[{"gh", "[", 
   RowBox[{"x", " ", "y"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->117560780],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"UpValues", "[", "g", "]"}], ",", 
   RowBox[{"UpValues", "[", "h", "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->1009224116],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       RowBox[{"f1", "[", 
        RowBox[{
         RowBox[{"g", "[", "x_", "]"}], ",", 
         RowBox[{"h", "[", "y_", "]"}]}], "]"}], "]"}], "\[RuleDelayed]", 
      RowBox[{"gh", "[", 
       RowBox[{"x", " ", "y"}], "]"}]}], ",", 
     RowBox[{
      RowBox[{"HoldPattern", "[", 
       RowBox[{"f2", "[", 
        RowBox[{
         RowBox[{"g", "[", "x_", "]"}], ",", 
         RowBox[{"h", "[", "y_", "]"}]}], "]"}], "]"}], "\[RuleDelayed]", 
      RowBox[{"gh", "[", 
       RowBox[{"x", " ", "y"}], "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"HoldPattern", "[", 
      RowBox[{"f2", "[", 
       RowBox[{
        RowBox[{"g", "[", "x_", "]"}], ",", 
        RowBox[{"h", "[", "y_", "]"}]}], "]"}], "]"}], "\[RuleDelayed]", 
     RowBox[{"gh", "[", 
      RowBox[{"x", " ", "y"}], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{566, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->84399222]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->197068002],

Cell["\<\
The right side of an immediate definition is evaluated when the definition is \
made: \
\>", "ExampleText",
 CellID->250240923],

Cell[BoxData[
 RowBox[{
  RowBox[{"int", "/:", 
   RowBox[{"rand", "[", "int", "]"}], "=", 
   RowBox[{"Random", "[", "Integer", "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->425316542],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"rand", "[", "int", "]"}], ",", 
   RowBox[{"rand", "[", "int", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->713048083],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->440966230]
}, Open  ]],

Cell["\<\
The right side of a delayed definition is evaluated each time the definition \
is used: \
\>", "ExampleText",
 CellID->579487176],

Cell[BoxData[
 RowBox[{"real", "/:", 
  RowBox[{"rand", "[", "real", "]"}], ":=", 
  RowBox[{"Random", "[", "Real", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->114998281],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"rand", "[", "real", "]"}], ",", 
   RowBox[{"rand", "[", "real", "]"}]}], "}"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->206362787],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.6315834933768629`", ",", "0.9291594933239783`"}], 
  "}"}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->73208823]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->180573554],

Cell["Definitions with the same left side overwrite earlier ones:", \
"ExampleText",
 CellID->568194695],

Cell[BoxData[
 RowBox[{"h", "/:", 
  RowBox[{"f", "[", 
   RowBox[{"h", "[", "x_", "]"}], "]"}], ":=", 
  RowBox[{"f1", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->60469846],

Cell[BoxData[
 RowBox[{"h", "/:", 
  RowBox[{"f", "[", 
   RowBox[{"h", "[", "x_", "]"}], "]"}], ":=", 
  RowBox[{"f2", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->105325452],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "h", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->583637389],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNVVFuwjAMNUnDxgYCMW3ib5xg2iWgXxyiQkjwMYEYB524UOekNgQ3bSjl
g0iN68R+9kssZ5Ed1quf7LBZZtN0n+3Wm+XvdL7d45LuAKgZAAwngP85/rmP
R4ofwAvOCpf7JMckDclvkq8krefx5An6hOgsfL2HUxdVLdYToX9FcOz05yIW
UMWwBg4p8TnZ1WKZhy7ZWBbKY1WX24DshigN+ZlgZB9VopwZKLFjhO72jY8L
ATx1GZ1u7xoeCeX/JPb1jXFl/vdmqinvQYTfZ2RfRmfc7oPk/1ZxLzJqFX47
Hly7JX6tas4ET4gzHglryUB2jSa1F+wTFViFlblEz5t1CT93rgK/a0huqjZa
y+5Rc6bjCA9Zfe+hO4nWfHX/tv7aOx9m/JyH356eQPogf8Zhu/LbxPmlDTXo
/AM7fOAx\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->258961072]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->297742266],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Definition",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Definition"]], "InlineFormula"],
 " prints definitions associated with a symbol:"
}], "ExampleText",
 CellID->1693501],

Cell[BoxData[
 RowBox[{"mod", "/:", 
  RowBox[{"a_mod", "+", "b_mod"}], ":=", 
  RowBox[{"modPlus", "[", 
   RowBox[{"a", ",", "b"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->38967361],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "mod", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->283680345],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9Vl9PgzAQv7VlbCosGh58ccFEH/wgypMfgixLtgejmfsCxm/iF8W2tOM8
riJCIKHt/W9/d1d4Lo+77Ut53G/KvDiUb7v95j1/ej1olpwBiEcAWF2DXld6
ZV//FPoF+NKj0OxzQ8mTHFaOb4hPq7nQ41xzHty8JRZnzuKS8M3wYT0IPUZa
EOs5hpo2isrxI2Lp+cuAfuIiJgG5XYB/PFc6KyTVC8XEl8gC86PAfpuT1iZW
YHeFtWLrwgn9WGtFOD9h7pzZT1trOThO6pD6kZ9BHjkkMU2xEkFPirNktYSr
uG4fZpgifxyeY+ZtPU2eOuuylU3WKumZG+NFjYLTVH2UVWP2j4T2zdNPWzoE
+yI/aleQLudyIRjdUeKwSBlpOtC7BUg1vL/eU0PuOP8VZLst2EHSVbY8tXt9
XF8z/ubEsgSdDgD+4QFnGZBO0tOP4HFuOAgTnxfFIOpjpK2Thb/tt0RyQegb
QtPKvg9XwC/ZuyJ01hGl2W+OMDbz2s0LYnGHMPNYGTojc1zRP0N/jqInBbNv
CyhwvQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{581, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->179758302]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Information",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Information"]], "InlineFormula"],
 " prints various information about a symbol, including any definitions:"
}], "ExampleText",
 CellID->142512223],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "mod"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->147364646],

Cell[CellGroupData[{

Cell["Cell$$4531`mod", "Print", "PrintUsage",
 CellTags->"Info3381487882-7453361",
 CellID->24304161],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {
        RowBox[{
         RowBox[{"a_mod", "+", "b_mod"}], "^:=", 
         RowBox[{"modPlus", "[", 
          RowBox[{"a", ",", "b"}], "]"}]}]}
      },
      BaselinePosition->{Baseline, {1, 1}},
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxItemSize->{"Columns" -> {{
           Scaled[0.999]}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
        "RowsIndexed" -> {}}]}
   },
   BaselinePosition->{Baseline, {1, 1}},
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}}],
  Definition["mod"],
  Editable->False]], "Print",
 CellTags->"Info3381487882-7453361",
 CellID->450122726]
}, Open  ]]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["UpValues",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/UpValues"]], "InlineFormula"],
 " returns a list of rules corresponding to any upvalues defined:"
}], "ExampleText",
 CellID->34795162],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"UpValues", "[", "mod", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->284210482],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"HoldPattern", "[", 
    RowBox[{"a_mod", "+", "b_mod"}], "]"}], "\[RuleDelayed]", 
   RowBox[{"modPlus", "[", 
    RowBox[{"a", ",", "b"}], "]"}]}], "}"}]], "Output",
 ImageSize->{296, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->225422242]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22103626],

Cell[TextData[{
 "Use ",
 Cell[BoxData["=."], "InlineFormula"],
 " to clear definitions with a particular left-hand side:"
}], "ExampleText",
 CellID->292515749],

Cell[BoxData[{
 RowBox[{
  RowBox[{"h", "/:", 
   RowBox[{"f", "[", 
    RowBox[{"h", "[", "x_", "]"}], "]"}], ":=", 
   RowBox[{"f1", "[", "x", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"h", "/:", 
   RowBox[{"g", "[", 
    RowBox[{"h", "[", "x_", "]"}], "]"}], ":=", 
   RowBox[{"g1", "[", "x", "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->521509637],

Cell[BoxData[
 RowBox[{"h", "/:", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"h", "[", "x_", "]"}], "]"}], "=."}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->538346729],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"h", "[", "1", "]"}], "]"}], ",", 
   RowBox[{"g", "[", 
    RowBox[{"h", "[", "1", "]"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->230290196],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"h", "[", "1", "]"}], "]"}], ",", 
   RowBox[{"g1", "[", "1", "]"}]}], "}"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->51248423]
}, Open  ]],

Cell["Clear all definitions:", "ExampleText",
 CellID->57250942],

Cell[BoxData[
 RowBox[{"Clear", "[", "h", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->634107459],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Definition", "[", "h", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->21692100],

Cell[BoxData[
 InterpretationBox["Null",
  Definition[$CellContext`h],
  Editable->False]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->822971423]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->386485856],

Cell["\<\
Delayed assignment introduces a scope that is not affected by global \
variables:\
\>", "ExampleText",
 CellID->349428712],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "5"}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->706075573],

Cell[BoxData[
 RowBox[{"h", "/:", 
  RowBox[{"f", "[", 
   RowBox[{"h", "[", "x_", "]"}], "]"}], ":=", 
  RowBox[{"x", "^", "2"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->878464224],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"h", "[", "2", "]"}], "]"}], ",", "x"}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->77216795],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"4", ",", "5"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->445864154]
}, Open  ]],

Cell["Immediate assignment does not introduce a scope:", "ExampleText",
 CellID->14058106],

Cell[BoxData[
 RowBox[{
  RowBox[{"h", "/:", 
   RowBox[{"g", "[", 
    RowBox[{"h", "[", "x_", "]"}], "]"}], "=", 
   RowBox[{"x", "^", "2"}]}], ";"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->1194282924],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"h", "[", "2", "]"}], "]"}], ",", "x"}], "}"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->1763169649],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"25", ",", "5"}], "}"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->316997406]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->716],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["SetDelayed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SetDelayed"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->22646]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14541],

Cell[TextData[ButtonBox["Associating Definitions with Different Symbols",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/AssociatingDefinitionsWithDifferentSymbols"]], "Tutorials",\

 CellID->225]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TagSetDelayed (/: :=) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 26, 7.9253174}", "context" -> "System`", 
    "keywords" -> {
     "associating values", "setting values", "generic programming", 
      "type based programming", "object programming"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "f /: lhs := rhs assigns rhs to be the delayed value of lhs, and \
associates the assignment with the symbol f. ", 
    "synonyms" -> {"tag set delayed", "/:", ":="}, "title" -> "TagSetDelayed",
     "type" -> "Symbol", "uri" -> "ref/TagSetDelayed"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2745, 94, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]},
 "Info3381487882-7453361"->{
  Cell[22055, 867, 101, 2, 70, "Print",
   CellTags->"Info3381487882-7453361",
   CellID->24304161],
  Cell[22159, 871, 823, 24, 70, "Print",
   CellTags->"Info3381487882-7453361",
   CellID->450122726]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 29782, 1167},
 {"Info3381487882-7453361", 29922, 1171}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1256, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1879, 60, 109, 4, 70, "ObjectName",
 CellID->9729],
Cell[1991, 66, 717, 23, 70, "Usage",
 CellID->24008]
}, Open  ]],
Cell[CellGroupData[{
Cell[2745, 94, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[3122, 108, 147, 5, 70, "ExampleSection",
 CellID->19309527],
Cell[3272, 115, 190, 6, 70, "Input",
 CellID->66289853],
Cell[CellGroupData[{
Cell[3487, 125, 233, 8, 28, "Input",
 CellID->705566126],
Cell[3723, 135, 294, 10, 36, "Output",
 CellID->1008953992]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4066, 151, 216, 7, 70, "ExampleSection",
 CellID->27936],
Cell[CellGroupData[{
Cell[4307, 162, 236, 7, 70, "ExampleSubsection",
 CellID->214715367],
Cell[4546, 171, 125, 3, 70, "ExampleText",
 CellID->14205805],
Cell[4674, 176, 177, 5, 70, "Input",
 CellID->66248155],
Cell[CellGroupData[{
Cell[4876, 185, 181, 6, 70, "Input",
 CellID->68775699],
Cell[5060, 193, 232, 7, 36, "Output",
 CellID->45488115]
}, Open  ]],
Cell[5307, 203, 124, 3, 70, "ExampleDelimiter",
 CellID->79101227],
Cell[5434, 208, 140, 4, 70, "ExampleText",
 CellID->849799875],
Cell[5577, 214, 410, 14, 70, "Input",
 CellID->1855274059],
Cell[CellGroupData[{
Cell[6012, 232, 127, 4, 70, "Input",
 CellID->1897187131],
Cell[6142, 238, 184, 6, 36, "Output",
 CellID->198658389]
}, Open  ]],
Cell[6341, 247, 125, 3, 70, "ExampleDelimiter",
 CellID->168657331],
Cell[6469, 252, 94, 1, 70, "ExampleText",
 CellID->127941899],
Cell[6566, 255, 185, 6, 70, "Input",
 CellID->528585766],
Cell[CellGroupData[{
Cell[6776, 265, 124, 4, 70, "Input",
 CellID->102382228],
Cell[6903, 271, 158, 5, 36, "Output",
 CellID->274451634]
}, Open  ]],
Cell[7076, 279, 125, 3, 70, "ExampleDelimiter",
 CellID->561126416],
Cell[7204, 284, 113, 3, 70, "ExampleText",
 CellID->41854356],
Cell[7320, 289, 190, 6, 70, "Input",
 CellID->961758164],
Cell[CellGroupData[{
Cell[7535, 299, 128, 4, 70, "Input",
 CellID->98200665],
Cell[7666, 305, 156, 5, 36, "Output",
 CellID->3510171]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[7871, 316, 246, 7, 70, "ExampleSubsection",
 CellID->438015421],
Cell[8120, 325, 79, 1, 70, "ExampleText",
 CellID->143130497],
Cell[8202, 328, 213, 6, 70, "Input",
 CellID->313909595],
Cell[CellGroupData[{
Cell[8440, 338, 187, 6, 70, "Input",
 CellID->2630808],
Cell[8630, 346, 472, 15, 36, "Output",
 CellID->116773010]
}, Open  ]],
Cell[9117, 364, 125, 3, 70, "ExampleDelimiter",
 CellID->246135006],
Cell[9245, 369, 80, 1, 70, "ExampleText",
 CellID->252214741],
Cell[9328, 372, 281, 9, 70, "Input",
 CellID->112103390],
Cell[CellGroupData[{
Cell[9634, 385, 191, 6, 70, "Input",
 CellID->467586206],
Cell[9828, 393, 530, 17, 39, "Output",
 CellID->580550921]
}, Open  ]],
Cell[10373, 413, 125, 3, 70, "ExampleDelimiter",
 CellID->318029046],
Cell[10501, 418, 72, 1, 70, "ExampleText",
 CellID->716732190],
Cell[10576, 421, 329, 10, 70, "Input",
 CellID->4271581],
Cell[CellGroupData[{
Cell[10930, 435, 189, 6, 70, "Input",
 CellID->180075138],
Cell[11122, 443, 606, 19, 36, "Output",
 CellID->752688400]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[11789, 469, 222, 7, 70, "ExampleSection",
 CellID->7523],
Cell[12014, 478, 72, 1, 70, "ExampleText",
 CellID->192261504],
Cell[12089, 481, 664, 23, 70, "Input",
 CellID->79245154],
Cell[CellGroupData[{
Cell[12778, 508, 288, 10, 70, "Input",
 CellID->66544906],
Cell[13069, 520, 210, 7, 36, "Output",
 CellID->156814849]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13328, 533, 233, 7, 70, "ExampleSection",
 CellID->26364],
Cell[13564, 542, 151, 4, 70, "ExampleText",
 CellID->66289569],
Cell[13718, 548, 191, 6, 70, "Input",
 CellID->757332850],
Cell[13912, 556, 181, 6, 70, "Input",
 CellID->152746548],
Cell[CellGroupData[{
Cell[14118, 566, 186, 6, 70, "Input",
 CellID->17921066],
Cell[14307, 574, 606, 19, 36, "Output",
 CellID->714879033]
}, Open  ]],
Cell[14928, 596, 125, 3, 70, "ExampleDelimiter",
 CellID->120594621],
Cell[15056, 601, 170, 5, 70, "ExampleText",
 CellID->181338931],
Cell[15229, 608, 272, 9, 70, "Input",
 CellID->270589337],
Cell[15504, 619, 262, 9, 70, "Input",
 CellID->117560780],
Cell[CellGroupData[{
Cell[15791, 632, 188, 6, 70, "Input",
 CellID->1009224116],
Cell[15982, 640, 1099, 34, 54, "Output",
 CellID->84399222]
}, Open  ]],
Cell[17096, 677, 125, 3, 70, "ExampleDelimiter",
 CellID->197068002],
Cell[17224, 682, 137, 4, 70, "ExampleText",
 CellID->250240923],
Cell[17364, 688, 197, 6, 70, "Input",
 CellID->425316542],
Cell[CellGroupData[{
Cell[17586, 698, 183, 6, 70, "Input",
 CellID->713048083],
Cell[17772, 706, 203, 7, 36, "Output",
 CellID->440966230]
}, Open  ]],
Cell[17990, 716, 139, 4, 70, "ExampleText",
 CellID->579487176],
Cell[18132, 722, 177, 5, 70, "Input",
 CellID->114998281],
Cell[CellGroupData[{
Cell[18334, 731, 185, 6, 70, "Input",
 CellID->206362787],
Cell[18522, 739, 242, 8, 36, "Output",
 CellID->73208823]
}, Open  ]],
Cell[18779, 750, 125, 3, 70, "ExampleDelimiter",
 CellID->180573554],
Cell[18907, 755, 104, 2, 70, "ExampleText",
 CellID->568194695],
Cell[19014, 759, 190, 6, 70, "Input",
 CellID->60469846],
Cell[19207, 767, 191, 6, 70, "Input",
 CellID->105325452],
Cell[CellGroupData[{
Cell[19423, 777, 106, 3, 70, "Input",
 CellID->583637389],
Cell[19532, 782, 647, 15, 70, "Output",
 Evaluatable->False,
 CellID->258961072]
}, Open  ]],
Cell[20194, 800, 125, 3, 70, "ExampleDelimiter",
 CellID->297742266],
Cell[20322, 805, 224, 7, 70, "ExampleText",
 CellID->1693501],
Cell[20549, 814, 194, 6, 70, "Input",
 CellID->38967361],
Cell[CellGroupData[{
Cell[20768, 824, 108, 3, 70, "Input",
 CellID->283680345],
Cell[20879, 829, 769, 17, 70, "Output",
 Evaluatable->False,
 CellID->179758302]
}, Open  ]],
Cell[21663, 849, 253, 7, 70, "ExampleText",
 CellID->142512223],
Cell[CellGroupData[{
Cell[21941, 860, 89, 3, 70, "Input",
 CellID->147364646],
Cell[CellGroupData[{
Cell[22055, 867, 101, 2, 70, "Print",
 CellTags->"Info3381487882-7453361",
 CellID->24304161],
Cell[22159, 871, 823, 24, 70, "Print",
 CellTags->"Info3381487882-7453361",
 CellID->450122726]
}, Open  ]]
}, Open  ]],
Cell[23009, 899, 239, 7, 70, "ExampleText",
 CellID->34795162],
Cell[CellGroupData[{
Cell[23273, 910, 106, 3, 70, "Input",
 CellID->284210482],
Cell[23382, 915, 349, 11, 36, "Output",
 CellID->225422242]
}, Open  ]],
Cell[23746, 929, 124, 3, 70, "ExampleDelimiter",
 CellID->22103626],
Cell[23873, 934, 161, 5, 70, "ExampleText",
 CellID->292515749],
Cell[24037, 941, 384, 12, 70, "Input",
 CellID->521509637],
Cell[24424, 955, 172, 6, 70, "Input",
 CellID->538346729],
Cell[CellGroupData[{
Cell[24621, 965, 233, 8, 70, "Input",
 CellID->230290196],
Cell[24857, 975, 292, 10, 36, "Output",
 CellID->51248423]
}, Open  ]],
Cell[25164, 988, 64, 1, 70, "ExampleText",
 CellID->57250942],
Cell[25231, 991, 101, 3, 70, "Input",
 CellID->634107459],
Cell[CellGroupData[{
Cell[25357, 998, 105, 3, 70, "Input",
 CellID->21692100],
Cell[25465, 1003, 231, 8, 36, "Output",
 CellID->822971423]
}, Open  ]],
Cell[25711, 1014, 125, 3, 70, "ExampleDelimiter",
 CellID->386485856],
Cell[25839, 1019, 132, 4, 70, "ExampleText",
 CellID->349428712],
Cell[25974, 1025, 110, 4, 70, "Input",
 CellID->706075573],
Cell[26087, 1031, 185, 6, 70, "Input",
 CellID->878464224],
Cell[CellGroupData[{
Cell[26297, 1041, 173, 6, 70, "Input",
 CellID->77216795],
Cell[26473, 1049, 203, 7, 36, "Output",
 CellID->445864154]
}, Open  ]],
Cell[26691, 1059, 90, 1, 70, "ExampleText",
 CellID->14058106],
Cell[26784, 1062, 206, 7, 70, "Input",
 CellID->1194282924],
Cell[CellGroupData[{
Cell[27015, 1073, 175, 6, 70, "Input",
 CellID->1763169649],
Cell[27193, 1081, 204, 7, 36, "Output",
 CellID->316997406]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27458, 1095, 309, 9, 70, "SeeAlsoSection",
 CellID->716],
Cell[27770, 1106, 200, 6, 70, "SeeAlso",
 CellID->22646]
}, Open  ]],
Cell[CellGroupData[{
Cell[28007, 1117, 314, 9, 70, "TutorialsSection",
 CellID->14541],
Cell[28324, 1128, 202, 5, 70, "Tutorials",
 CellID->225]
}, Open  ]],
Cell[28541, 1136, 27, 0, 70, "History"],
Cell[28571, 1138, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

