(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26393,        972]
NotebookOptionsPosition[     20853,        778]
NotebookOutlinePosition[     22093,        814]
CellTagsIndexPosition[     22008,        809]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Applying Functions Repeatedly" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ApplyingFunctionsRepeatedly"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Applying Functions Repeatedly\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LengthWhile" :> 
          Documentation`HelpLookup["paclet:ref/LengthWhile"], "NestWhile" :> 
          Documentation`HelpLookup["paclet:ref/NestWhile"], "While" :> 
          Documentation`HelpLookup["paclet:ref/While"], "Take" :> 
          Documentation`HelpLookup["paclet:ref/Take"], "Select" :> 
          Documentation`HelpLookup["paclet:ref/Select"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"LengthWhile\"\>", 2->"\<\"NestWhile\"\>", 
       3->"\<\"While\"\>", 4->"\<\"Take\"\>", 
       5->"\<\"Select\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Conditionals" :> 
          Documentation`HelpLookup["paclet:guide/Conditionals"], 
          "Elements of Lists" :> 
          Documentation`HelpLookup["paclet:guide/ElementsOfLists"], 
          "Functional Iteration" :> 
          Documentation`HelpLookup["paclet:guide/FunctionalIteration"], 
          "Functional Programming" :> 
          Documentation`HelpLookup["paclet:guide/FunctionalProgramming"], 
          "New in 6.0: Core Language" :> 
          Documentation`HelpLookup["paclet:guide/NewIn60CoreLanguage"], 
          "New in 6.0: List Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60ListManipulation"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Conditionals\"\>", 
       2->"\<\"Elements of Lists\"\>", 3->"\<\"Functional Iteration\"\>", 
       4->"\<\"Functional Programming\"\>", 
       5->"\<\"New in 6.0: Core Language\"\>", 
       6->"\<\"New in 6.0: List Manipulation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["TakeWhile", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["TakeWhile",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TakeWhile"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["crit", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives elements ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["e", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " from the beginning of ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ", continuing so long as ",
     Cell[BoxData[
      RowBox[{
       StyleBox["crit", "TI"], "[", 
       SubscriptBox[
        StyleBox["e", "TI"], 
        StyleBox["i", "TI"]], "]"}]], "InlineFormula"],
     " is ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->479347948],

Cell["Take elements while they are all even:", "ExampleText",
 CellID->656653308],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TakeWhile", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "6", ",", "1", ",", "2", ",", "3"}], "}"}], 
   ",", "EvenQ"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->75841678],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "4", ",", "6"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->121508604]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->120242522],

Cell["\<\
Use a pure function to take elements while they are all below 10:\
\>", "ExampleText",
 CellID->944758958],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TakeWhile", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "13", ",", 
     "21"}], "}"}], ",", 
   RowBox[{
    RowBox[{"#", "<", "10"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->649655998],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->81215563]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Elements of the list can be any expression:", "ExampleText",
 CellID->330266191],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TakeWhile", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "Pi", ",", "3", ",", "2", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", "10"}], "}"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"Head", "[", "#", "]"}], "=!=", "List"}], "&"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->431239928],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "\[Pi]", ",", "3", ",", "2"}], "}"}]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->445912325]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258228157],

Cell[TextData[{
 "Find the digits of ",
 Cell[BoxData[
  StyleBox["\[Pi]", "TR"]], "InlineFormula"],
 " before the first occurrence of a 7:"
}], "ExampleText",
 CellID->18165256],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TakeWhile", "[", 
  RowBox[{
   RowBox[{"First", "[", 
    RowBox[{"RealDigits", "[", 
     RowBox[{"Pi", ",", "10", ",", "100"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"#", "!=", "7"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->268758183],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "3", ",", "1", ",", "4", ",", "1", ",", "5", ",", "9", ",", "2", ",", "6", 
   ",", "5", ",", "3", ",", "5", ",", "8", ",", "9"}], "}"}]], "Output",
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->258994552]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TakeWhile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TakeWhile"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  ButtonBox["Take",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Take"]], "InlineFormula"],
 " of ",
 Cell[BoxData[
  ButtonBox["LengthWhile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LengthWhile"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->12995697],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"{", 
   RowBox[{
   "1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "13", ",", 
    "21"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->361382676],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "13", ",", 
   "21"}], "}"}]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23154132]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TakeWhile", "[", 
  RowBox[{"data", ",", 
   RowBox[{
    RowBox[{"#", "<", "10"}], "&"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->929400656],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->9571819]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Take", "[", 
  RowBox[{"data", ",", 
   RowBox[{"LengthWhile", "[", 
    RowBox[{"data", ",", 
     RowBox[{
      RowBox[{"#", "<", "10"}], "&"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->580366616],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->27749422]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->438254890],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TakeWhile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TakeWhile"]], "InlineFormula"],
 " gives the entire list if ",
 Cell[BoxData[
  RowBox[{
   StyleBox["crit", "TI"], "[", 
   SubscriptBox[
    StyleBox["e", "TI"], 
    StyleBox["i", "TI"]], "]"}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " for all elements:"
}], "ExampleText",
 CellID->47453321],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TakeWhile", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "13", ",", 
     "21"}], "}"}], ",", "NumberQ"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->166616232],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "8", ",", "13", ",", 
   "21"}], "}"}]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->329457357]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->21202240],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TakeWhile",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TakeWhile"]], "InlineFormula"],
 " gives a subset of the elements returned by ",
 Cell[BoxData[
  ButtonBox["Select",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Select"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->364135890],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"data", "=", 
  RowBox[{"{", 
   RowBox[{"E", ",", "8", ",", "a", ",", "b", ",", "20", ",", "1.4"}], 
   "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->258142881],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "\[ExponentialE]", ",", "8", ",", "a", ",", "b", ",", "20", ",", "1.4`"}], 
  "}"}]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5022622]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TakeWhile", "[", 
  RowBox[{"data", ",", "NumericQ"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->141070777],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[ExponentialE]", ",", "8"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->378495345]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{"data", ",", "NumericQ"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->190552331],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[ExponentialE]", ",", "8", ",", "20", ",", "1.4`"}], 
  "}"}]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->183222177]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell[TextData[{
 "The list terminates for any value of ",
 Cell[BoxData[
  RowBox[{
   StyleBox["crit", "TI"], "[", 
   SubscriptBox[
    StyleBox["e", "TI"], 
    StyleBox["i", "TI"]], "]"}]], "InlineFormula"],
 " that is not ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->42305798],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TakeWhile", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"E", ",", "8", ",", "a", ",", "b", ",", "20", ",", "1.4"}], "}"}],
    ",", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"NumericQ", "[", "#", "]"}], ",", "True", ",", "#"}], "]"}], 
    "&"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->162460669],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\[ExponentialE]", ",", "8"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->108285560]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"NumericQ", "[", "#", "]"}], ",", "True", ",", "#"}], "]"}], 
    "&"}], ",", 
   RowBox[{"{", 
    RowBox[{"E", ",", "8", ",", "a", ",", "b", ",", "20", ",", "1.4"}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->127627803],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "True", ",", "a", ",", "b", ",", "True", ",", "True"}],
   "}"}]], "Output",
 ImageSize->{200, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->570754144]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LengthWhile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LengthWhile"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NestWhile",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NestWhile"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["While",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/While"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Take",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Take"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Select",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Select"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Applying Functions Repeatedly",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/ApplyingFunctionsRepeatedly"]], "Tutorials",
 CellID->15225]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Conditionals",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Conditionals"]], "MoreAbout",
 CellID->97053529],

Cell[TextData[ButtonBox["Elements of Lists",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementsOfLists"]], "MoreAbout",
 CellID->54555167],

Cell[TextData[ButtonBox["Functional Iteration",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalIteration"]], "MoreAbout",
 CellID->113779358],

Cell[TextData[ButtonBox["Functional Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalProgramming"]], "MoreAbout",
 CellID->354477368],

Cell[TextData[ButtonBox["New in 6.0: Core Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60CoreLanguage"]], "MoreAbout",
 CellID->291320603],

Cell[TextData[ButtonBox["New in 6.0: List Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60ListManipulation"]], "MoreAbout",
 CellID->251334040]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TakeWhile - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 26, 9.5659844}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "TakeWhile[list, crit] gives elements e_i from the beginning of list, \
continuing so long as crit[e_i] is True.", "synonyms" -> {"take while"}, 
    "title" -> "TakeWhile", "type" -> "Symbol", "uri" -> "ref/TakeWhile"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6257, 174, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21873, 802}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2919, 66, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3542, 93, 1574, 37, 70, "ObjectNameGrid"],
Cell[5119, 132, 1101, 37, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[6257, 174, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[6634, 188, 148, 5, 70, "ExampleSection",
 CellID->479347948],
Cell[6785, 195, 81, 1, 70, "ExampleText",
 CellID->656653308],
Cell[CellGroupData[{
Cell[6891, 200, 224, 7, 28, "Input",
 CellID->75841678],
Cell[7118, 209, 213, 7, 36, "Output",
 CellID->121508604]
}, Open  ]],
Cell[7346, 219, 125, 3, 70, "ExampleDelimiter",
 CellID->120242522],
Cell[7474, 224, 116, 3, 70, "ExampleText",
 CellID->944758958],
Cell[CellGroupData[{
Cell[7615, 231, 295, 10, 28, "Input",
 CellID->649655998],
Cell[7913, 243, 246, 8, 36, "Output",
 CellID->81215563]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8208, 257, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[8432, 266, 86, 1, 70, "ExampleText",
 CellID->330266191],
Cell[CellGroupData[{
Cell[8543, 271, 431, 14, 70, "Input",
 CellID->431239928],
Cell[8977, 287, 227, 7, 36, "Output",
 CellID->445912325]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9253, 300, 227, 7, 70, "ExampleSection",
 CellID->258228157],
Cell[9483, 309, 178, 6, 70, "ExampleText",
 CellID->18165256],
Cell[CellGroupData[{
Cell[9686, 319, 285, 9, 70, "Input",
 CellID->268758183],
Cell[9974, 330, 321, 9, 36, "Output",
 CellID->258994552]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10344, 345, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[10585, 354, 447, 17, 70, "ExampleText",
 CellID->12995697],
Cell[CellGroupData[{
Cell[11057, 375, 213, 7, 70, "Input",
 CellID->361382676],
Cell[11273, 384, 272, 9, 36, "Output",
 CellID->23154132]
}, Open  ]],
Cell[CellGroupData[{
Cell[11582, 398, 176, 6, 70, "Input",
 CellID->929400656],
Cell[11761, 406, 245, 8, 36, "Output",
 CellID->9571819]
}, Open  ]],
Cell[CellGroupData[{
Cell[12043, 419, 242, 8, 70, "Input",
 CellID->580366616],
Cell[12288, 429, 246, 8, 36, "Output",
 CellID->27749422]
}, Open  ]],
Cell[12549, 440, 125, 3, 70, "ExampleDelimiter",
 CellID->438254890],
Cell[12677, 445, 501, 19, 70, "ExampleText",
 CellID->47453321],
Cell[CellGroupData[{
Cell[13203, 468, 256, 8, 70, "Input",
 CellID->166616232],
Cell[13462, 478, 273, 9, 36, "Output",
 CellID->329457357]
}, Open  ]],
Cell[13750, 490, 124, 3, 70, "ExampleDelimiter",
 CellID->21202240],
Cell[13877, 495, 344, 12, 70, "ExampleText",
 CellID->364135890],
Cell[CellGroupData[{
Cell[14246, 511, 189, 6, 70, "Input",
 CellID->258142881],
Cell[14438, 519, 266, 9, 36, "Output",
 CellID->5022622]
}, Open  ]],
Cell[CellGroupData[{
Cell[14741, 533, 138, 4, 70, "Input",
 CellID->141070777],
Cell[14882, 539, 217, 7, 36, "Output",
 CellID->378495345]
}, Open  ]],
Cell[CellGroupData[{
Cell[15136, 551, 135, 4, 70, "Input",
 CellID->190552331],
Cell[15274, 557, 245, 8, 36, "Output",
 CellID->183222177]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15568, 571, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[15802, 580, 383, 15, 70, "ExampleText",
 CellID->42305798],
Cell[CellGroupData[{
Cell[16210, 599, 357, 12, 70, "Input",
 CellID->162460669],
Cell[16570, 613, 217, 7, 36, "Output",
 CellID->108285560]
}, Open  ]],
Cell[CellGroupData[{
Cell[16824, 625, 352, 12, 70, "Input",
 CellID->127627803],
Cell[17179, 639, 259, 8, 36, "Output",
 CellID->570754144]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17499, 654, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[17818, 665, 1180, 44, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[19035, 714, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[19356, 725, 167, 3, 70, "Tutorials",
 CellID->15225]
}, Open  ]],
Cell[CellGroupData[{
Cell[19560, 733, 299, 8, 70, "MoreAboutSection"],
Cell[19862, 743, 135, 3, 70, "MoreAbout",
 CellID->97053529],
Cell[20000, 748, 143, 3, 70, "MoreAbout",
 CellID->54555167],
Cell[20146, 753, 151, 3, 70, "MoreAbout",
 CellID->113779358],
Cell[20300, 758, 155, 3, 70, "MoreAbout",
 CellID->354477368],
Cell[20458, 763, 156, 3, 70, "MoreAbout",
 CellID->291320603],
Cell[20617, 768, 164, 3, 70, "MoreAbout",
 CellID->251334040]
}, Open  ]],
Cell[20796, 774, 27, 0, 70, "History"],
Cell[20826, 776, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

