(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    171663,       4893]
NotebookOptionsPosition[    152295,       4184]
NotebookOutlinePosition[    153458,       4219]
CellTagsIndexPosition[    153371,       4214]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Some Mathematical Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SomeMathematicalFunctions"], 
          "Elementary Transcendental Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ElementaryTranscendentalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Some Mathematical Functions\"\>", 
       2->"\<\"Elementary Transcendental Functions\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ArcTan" :> Documentation`HelpLookup["paclet:ref/ArcTan"], 
          "Cot" :> Documentation`HelpLookup["paclet:ref/Cot"], "Tanh" :> 
          Documentation`HelpLookup["paclet:ref/Tanh"], "Degree" :> 
          Documentation`HelpLookup["paclet:ref/Degree"], "TrigToExp" :> 
          Documentation`HelpLookup["paclet:ref/TrigToExp"], "TrigExpand" :> 
          Documentation`HelpLookup["paclet:ref/TrigExpand"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ArcTan\"\>", 2->"\<\"Cot\"\>", 
       3->"\<\"Tanh\"\>", 4->"\<\"Degree\"\>", 5->"\<\"TrigToExp\"\>", 
       6->"\<\"TrigExpand\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elementary Functions" :> 
          Documentation`HelpLookup["paclet:guide/ElementaryFunctions"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Precollege Education" :> 
          Documentation`HelpLookup["paclet:guide/PrecollegeEducation"], 
          "Trigonometric Functions" :> 
          Documentation`HelpLookup["paclet:guide/TrigonometricFunctions"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Elementary Functions\"\>", 
       2->"\<\"Mathematical Functions\"\>", 3->"\<\"Precollege Education\"\>",
        4->"\<\"Trigonometric Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Tan", "ObjectName",
 CellID->1954],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Tan",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Tan"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the tangent of ",
     Cell[BoxData[
      FormBox["z", TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->930]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 "The argument of ",
 Cell[BoxData[
  ButtonBox["Tan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tan"]], "InlineFormula"],
 " is assumed to be in radians. (Multiply by ",
 Cell[BoxData[
  ButtonBox["Degree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Degree"]], "InlineFormula"],
 " to convert from degrees.) "
}], "Notes",
 CellID->19904],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Sin",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Sin"], "[", 
    StyleBox["z", "TI"], "]"}], "/", 
   RowBox[{
    ButtonBox["Cos",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Cos"], "[", 
    StyleBox["z", "TI"], "]"}]}]], "InlineFormula"],
 " is automatically converted to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tan",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tan"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TrigFactorList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigFactorList"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " does decomposition. "
}], "Notes",
 CellID->20279],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Tan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tan"]], "InlineFormula"],
 " is automatically evaluated when its argument is a simple rational multiple \
of ",
 Cell[BoxData[
  FormBox["\[Pi]", TraditionalForm]], "InlineMath"],
 "; for more complicated rational multiples, ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " can sometimes be used. "
}], "Notes",
 CellID->12488],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["Tan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tan"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->619728989],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Tan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tan"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Tan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tan"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->401389190],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->301346248],

Cell["The argument is given in radians:", "ExampleText",
 CellID->30260],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tan", "[", 
  RowBox[{"Pi", "/", "6"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20514],

Cell[BoxData[
 FractionBox["1", 
  SqrtBox["3"]]], "Output",
 ImageSize->{32, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->408122242]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16657],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Degree",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Degree"]], "InlineFormula"],
 " to specify an argument in degrees:"
}], "ExampleText",
 CellID->14990],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tan", "[", 
  RowBox[{"30", "Degree"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19438],

Cell[BoxData[
 FractionBox["1", 
  SqrtBox["3"]]], "Output",
 ImageSize->{32, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->553387931]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Tan", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5242],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 87},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->283790261]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16070],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Tan", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25631],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "3"], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "5"]}], "15"], "+", 
   FractionBox[
    RowBox[{"17", " ", 
     SuperscriptBox["x", "7"]}], "315"], "+", 
   FractionBox[
    RowBox[{"62", " ", 
     SuperscriptBox["x", "9"]}], "2835"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 1, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[1, 3], 0, 
    Rational[2, 15], 0, 
    Rational[17, 315], 0, 
    Rational[62, 2835]}, 1, 11, 1],
  Editable->False]], "Output",
 ImageSize->{224, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1721847]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(11)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28781],

Cell["Evaluate numerically:", "ExampleText",
 CellID->20990],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tan", "[", "1.2", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12833],

Cell[BoxData["2.5721516221263188`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->530280383]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1563],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->21302],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Tan", "[", 
    RowBox[{"12", "/", "10"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->502],

Cell[BoxData["2.\
572151622126318935409994236033363956529409306043389279225637262239`50."], \
"Output",
 ImageSize->{361, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->699157300]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->117890470],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->30721],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tan", "[", "1.20000000000000000000000", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24898],

Cell[BoxData["2.57215162212631893540999423603336395653`22.52857168497864"], \
"Output",
 ImageSize->{172, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->45644408]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->41436957],

Cell["\<\
The precision of the output can be much smaller than the precision of the \
input:\
\>", "ExampleText",
 CellID->10945],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tan", "[", "1.5707963267948966192213216916397514421", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28406],

Cell[BoxData["1.00000000000000000014153003126`17.*^20"], "Output",
 ImageSize->{166, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->31500027]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8686],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Tan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tan"]], "InlineFormula"],
 " threads element-wise over lists and matrices:"
}], "ExampleText",
 CellID->5794],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tan", "[", 
  RowBox[{"{", 
   RowBox[{"1.2", ",", "1.5", ",", "1.8"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23577],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.5721516221263188`", ",", "14.101419947171719`", ",", 
   RowBox[{"-", "4.286261674628062`"}]}], "}"}]], "Output",
 ImageSize->{196, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->296822387]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tan", "[", 
  TagBox[
   RowBox[{"(", "\:f3a2", GridBox[{
      {"\[Pi]", "u"},
      {"v", 
       FractionBox["\[Pi]", "3"]}
     },
     GridBoxAlignment->{
      "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
       "RowsIndexed" -> {}},
     GridBoxSpacings->{
      "Columns" -> {0.28, {0.7}, 0.28}, "ColumnsIndexed" -> {}, 
       "Rows" -> {0.2, {0.4}, 0.2}, "RowsIndexed" -> {}}], "\:f3a2", ")"}],
   Function[BoxForm`e$, 
    MatrixForm[BoxForm`e$]]], " ", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18683],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"Tan", "[", "u", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Tan", "[", "v", "]"}], ",", 
     SqrtBox["3"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{195, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->164601278]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13240],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Tan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tan"]], "InlineFormula"],
 " can take complex number inputs:"
}], "ExampleText",
 CellID->485],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tan", "[", 
  RowBox[{"2.5", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16464],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.23701383091627057`"}], "+", 
  RowBox[{"0.8964379171278618`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{148, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->262094009]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20337],

Cell["Simple exact values are generated automatically:", "ExampleText",
 CellID->16653],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tan", "[", 
  RowBox[{"Pi", "/", "5"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27168],

Cell[BoxData[
 SqrtBox[
  RowBox[{"5", "-", 
   RowBox[{"2", " ", 
    SqrtBox["5"]}]}]]], "Output",
 ImageSize->{77, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->171098897]
}, Open  ]],

Cell[TextData[{
 "More complicated cases require explicit use of ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->15255],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tan", "[", 
  RowBox[{"Pi", "/", "8"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1466],

Cell[BoxData[
 RowBox[{"Tan", "[", 
  FractionBox["\[Pi]", "8"], "]"}]], "Output",
 ImageSize->{52, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->289927032]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->22512],

Cell[BoxData[
 SqrtBox[
  FractionBox[
   RowBox[{"2", "-", 
    SqrtBox["2"]}], 
   RowBox[{"2", "+", 
    SqrtBox["2"]}]]]], "Output",
 ImageSize->{71, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->12192958]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3318],

Cell["\<\
Convert multiple\[Hyphen]angle expressions:\
\>", "ExampleText",
 CellID->13201],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigExpand", "[", 
  RowBox[{"Tan", "[", 
   RowBox[{"4", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->142],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"4", " ", 
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "3"], " ", 
    RowBox[{"Sin", "[", "x", "]"}]}], 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "4"], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "2"], " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "2"]}], "+", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "4"]}]], "-", 
  FractionBox[
   RowBox[{"4", " ", 
    RowBox[{"Cos", "[", "x", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "3"]}], 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Cos", "[", "x", "]"}], "4"], "-", 
    RowBox[{"6", " ", 
     SuperscriptBox[
      RowBox[{"Cos", "[", "x", "]"}], "2"], " ", 
     SuperscriptBox[
      RowBox[{"Sin", "[", "x", "]"}], "2"]}], "+", 
    SuperscriptBox[
     RowBox[{"Sin", "[", "x", "]"}], "4"]}]]}]], "Output",
 ImageSize->{482, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->675746382]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigReduce", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31506],

Cell[BoxData[
 RowBox[{"Tan", "[", 
  RowBox[{"4", " ", "x"}], "]"}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->106163501]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10684],

Cell["Convert sums of trigonometric functions to products:", "ExampleText",
 CellID->15023],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigFactor", "[", 
  RowBox[{
   RowBox[{"Tan", "[", "x", "]"}], "+", 
   RowBox[{"Tan", "[", "y", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30270],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sec", "[", "x", "]"}], " ", 
  RowBox[{"Sec", "[", "y", "]"}], " ", 
  RowBox[{"Sin", "[", 
   RowBox[{"x", "+", "y"}], "]"}]}]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->710210378]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8250],

Cell["Expand assuming real variables:", "ExampleText",
 CellID->13475],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{"Tan", "[", 
   RowBox[{"x", "+", 
    RowBox[{"I", " ", "y"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20311],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"Sin", "[", 
    RowBox[{"2", " ", "x"}], "]"}], 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "x"}], "]"}], "+", 
    RowBox[{"Cosh", "[", 
     RowBox[{"2", " ", "y"}], "]"}]}]], "+", 
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"Sinh", "[", 
     RowBox[{"2", " ", "y"}], "]"}]}], 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "x"}], "]"}], "+", 
    RowBox[{"Cosh", "[", 
     RowBox[{"2", " ", "y"}], "]"}]}]]}]], "Output",
 ImageSize->{273, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->523670585]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19195],

Cell["Convert to complex exponentials:", "ExampleText",
 CellID->5488],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigToExp", "[", 
  RowBox[{"Tan", "[", "z", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11520],

Cell[BoxData[
 FractionBox[
  RowBox[{"\[ImaginaryI]", " ", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "\[ImaginaryI]"}], " ", "z"}]], "-", 
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{"\[ImaginaryI]", " ", "z"}]]}], ")"}]}], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", "\[ImaginaryI]"}], " ", "z"}]], "+", 
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"\[ImaginaryI]", " ", "z"}]]}]]], "Output",
 ImageSize->{90, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->133479821]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->20183],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Tan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tan"]], "InlineFormula"],
 " can deal with real\[Hyphen]valued intervals:"
}], "ExampleText",
 CellID->24798],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tan", "[", 
  RowBox[{"Interval", "[", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     RowBox[{"Pi", "/", "3"}]}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27892],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{"0", ",", 
    SqrtBox["3"]}], "}"}], "]"}]], "Output",
 ImageSize->{131, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22936558]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6784],

Cell["Infinite arguments give symbolic results:", "ExampleText",
 CellID->30245],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tan", "[", "Infinity", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12187],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], 
  "]"}]], "Output",
 ImageSize->{123, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->80955922]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tan", "[", "ComplexInfinity", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->28343],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->478400197]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16859],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Tan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tan"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText",
 CellID->8871],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tan", "[", 
  RowBox[{
   FractionBox["\[Pi]", "2"], "+", "x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "3"], "+", 
   SuperscriptBox[
    RowBox[{"O", "[", "x", "]"}], "4"]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14016],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "x"]}], "+", 
   FractionBox["1", "2"], "+", 
   FractionBox[
    RowBox[{"5", " ", "x"}], "12"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "2"],
    SeriesData[$CellContext`x, 0, {}, -1, 2, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {-1, 
    Rational[1, 2], 
    Rational[5, 12]}, -1, 2, 1],
  Editable->False]], "Output",
 ImageSize->{127, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->233728882]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22832],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Tan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tan"]], "InlineFormula"],
 " threads element-wise over sparse arrays as well as lists: "
}], "ExampleText",
 CellID->24441],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", " ", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}], "\[Rule]", "\[Pi]"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "3"}], "}"}], "\[Rule]", 
     FractionBox["\[Pi]", "3"]}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}], "\[Rule]", 
     FractionBox["\[Pi]", "12"]}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", " ", "2"}], "}"}], "->", 
     FractionBox["\[Pi]", "4"]}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17683],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "4", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 4, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->118375015]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tan", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22015],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "4", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 4, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->571483383]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Normal", "[", "%", "]"}], " ", "//", " ", "MatrixForm"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->18516],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"0", "0", 
      SqrtBox["3"]},
     {"0", "0", "0"},
     {"0", "0", 
      RowBox[{"2", "-", 
       SqrtBox["3"]}]},
     {"0", "1", "0"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{98, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->484448545]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31283],

Cell["Generate a plot with poles removed:", "ExampleText",
 CellID->3205],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Tan", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "20"}], "}"}], ",", 
   RowBox[{"Exclusions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cos", "[", "x", "]"}], "\[Equal]", "0"}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->470472475],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->160277267]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->5769],

Cell["Generate a plot over the complex argument plane:", "ExampleText",
 CellID->23675],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"Tan", "[", 
     RowBox[{"x", "+", 
      RowBox[{"I", " ", "y"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->917],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{226, 179},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->429873563]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15020],

Cell["Differential equation solution with a movable singularity:", \
"ExampleText",
 CellID->6030],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      SuperscriptBox["w", "\[Prime]",
       MultilineFunction->None], "[", "z", "]"}], "-", 
     SuperscriptBox[
      RowBox[{"w", "[", "z", "]"}], "2"], "-", "1"}], "\[Equal]", "0"}], ",", 
   
   RowBox[{"w", "[", "z", "]"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->17442],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"w", "[", "z", "]"}], "\[Rule]", 
    RowBox[{"Tan", "[", 
     RowBox[{"z", "+", 
      RowBox[{"C", "[", "1", "]"}]}], "]"}]}], "}"}], "}"}]], "Output",
 ImageSize->{159, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->83804173]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32389],

Cell["\<\
The tangent function conformally maps a parabola into the unit disk:\
\>", "ExampleText",
 CellID->20373],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"parabola", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"1", "-", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "/", "4"}], "+", 
      RowBox[{"I", " ", "x"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "20", ",", 
       RowBox[{"1", "/", "10"}]}], "}"}]}], "]"}]}], ";", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Re", "[", "#", "]"}], ",", 
           RowBox[{"Im", "[", "#", "]"}]}], "}"}], "]"}], "&"}], "/@", 
       "parabola"}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", "1"}], ",", 
      RowBox[{"Axes", "->", "True"}]}], "]"}], ",", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Point", "[", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Re", "[", "#", "]"}], ",", 
           RowBox[{"Im", "[", "#", "]"}]}], "}"}], "]"}], "&"}], "/@", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"Tan", "[", 
          RowBox[{
           RowBox[{"\[Pi]", "/", "4."}], " ", 
           RowBox[{"Sqrt", "[", "parabola", "]"}]}], "]"}], "^", "2"}], 
        ")"}]}], ",", 
      RowBox[{"PlotRange", "->", "All"}], ",", 
      RowBox[{"Axes", "->", "True"}]}], "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3480],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{386, 187},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->221947056]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->175153784],

Cell["\<\
Pursuit curve in the reference frame of the predator with prey moving half as \
fast along a line:\
\>", "ExampleText",
 CellID->302947038],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"s", "=", 
  RowBox[{"DSolve", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"\[ScriptL]", "'"}], "[", "\[Phi]", "]"}], "\[Equal]", 
       RowBox[{
        RowBox[{"\[ScriptL]", "[", "\[Phi]", "]"}], " ", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"Sin", "[", "\[Phi]", "]"}], "-", "2"}], ")"}], "/", 
         RowBox[{"Cos", "[", "\[Phi]", "]"}]}]}]}], ",", 
      RowBox[{
       RowBox[{"\[ScriptL]", "[", "0", "]"}], "\[Equal]", "1"}]}], "}"}], ",",
     
    RowBox[{"\[ScriptL]", "[", "\[Phi]", "]"}], ",", "\[Phi]"}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->52082174],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[ScriptL]", "[", "\[Phi]", "]"}], "\[Rule]", 
    RowBox[{
     SuperscriptBox["\[ExponentialE]", 
      RowBox[{
       RowBox[{"-", "4"}], " ", 
       RowBox[{"ArcTanh", "[", 
        RowBox[{"Tan", "[", 
         FractionBox["\[Phi]", "2"], "]"}], "]"}]}]], " ", 
     RowBox[{"Sec", "[", "\[Phi]", "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{217, 27},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->331613496]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolarPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"\[ScriptL]", "[", "\[Phi]", "]"}], "/.", "s"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Phi]", ",", "0", ",", 
     RowBox[{"\[Pi]", "/", "2"}]}], "}"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->375873995],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 171},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->295506517]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(13)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10777],

Cell["\<\
Basic parity and periodicity properties of the tangent function get \
automatically applied:\
\>", "ExampleText",
 CellID->786],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tan", "[", 
  RowBox[{"x", "+", 
   RowBox[{"2", "Pi"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8381],

Cell[BoxData[
 RowBox[{"Tan", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->314824385]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tan", "[", 
  RowBox[{"-", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->522],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Tan", "[", "x", "]"}]}]], "Output",
 ImageSize->{54, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->770938967]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tan", "[", 
  RowBox[{"I", " ", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->20979],

Cell[BoxData[
 RowBox[{"\[ImaginaryI]", " ", 
  RowBox[{"Tanh", "[", "x", "]"}]}]], "Output",
 ImageSize->{64, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->62147300]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"1", "/", 
  RowBox[{"Tan", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->15713],

Cell[BoxData[
 RowBox[{"Cot", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->8763064]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19735],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["TrigFactorList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TrigFactorList"]], "InlineFormula"],
 " to factor ",
 Cell[BoxData[
  ButtonBox["Tan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tan"]], "InlineFormula"],
 " into ",
 Cell[BoxData[
  ButtonBox["Sin",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sin"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Cos",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cos"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->30883],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Sin", "[", "x", "]"}], "/", 
  RowBox[{"Cos", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2186],

Cell[BoxData[
 RowBox[{"Tan", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->68152054]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigFactorList", "[", 
  RowBox[{"Tan", "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20648],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cos", "[", "x", "]"}], ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{236, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->369070566]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14752],

Cell["\<\
Complicated expressions containing trigonometric functions do not simplify \
automatically:\
\>", "ExampleText",
 CellID->521],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Tan", "[", "z", "]"}], "+", 
  RowBox[{"Cot", "[", "z", "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9260],

Cell[BoxData[
 RowBox[{
  RowBox[{"Cot", "[", "z", "]"}], "+", 
  RowBox[{"Tan", "[", "z", "]"}]}]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->505894994]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6636],

Cell[BoxData[
 RowBox[{
  RowBox[{"Csc", "[", "z", "]"}], " ", 
  RowBox[{"Sec", "[", "z", "]"}]}]], "Output",
 ImageSize->{91, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->62497426]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19919],

Cell["Simplify under assumptions on parameters:", "ExampleText",
 CellID->17236],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tan", "[", 
  RowBox[{
   RowBox[{"-", "x"}], "+", 
   RowBox[{"k", " ", "Pi"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->26792],

Cell[BoxData[
 RowBox[{"Tan", "[", 
  RowBox[{
   RowBox[{"k", " ", "\[Pi]"}], "-", "x"}], "]"}]], "Output",
 ImageSize->{77, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->489592473]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"%", ",", 
   RowBox[{"k", "\[Element]", "Integers"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19278],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Tan", "[", "x", "]"}]}]], "Output",
 ImageSize->{54, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->283888795]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31496],

Cell["Compose with inverse functions:", "ExampleText",
 CellID->26386],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Tan", "[", 
    RowBox[{"ArcTan", "[", "z", "]"}], "]"}], ",", " ", 
   RowBox[{"Tan", "[", 
    RowBox[{"2", 
     RowBox[{"ArcTan", "[", "z", "]"}]}], "]"}], ",", " ", 
   RowBox[{"Tan", "[", 
    RowBox[{"3", 
     RowBox[{"ArcTan", "[", "z", "]"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21011],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", 
   RowBox[{"Tan", "[", 
    RowBox[{"2", " ", 
     RowBox[{"ArcTan", "[", "z", "]"}]}], "]"}], ",", 
   RowBox[{"Tan", "[", 
    RowBox[{"3", " ", 
     RowBox[{"ArcTan", "[", "z", "]"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{264, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->509885898]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FunctionExpand", "[", "%", "]"}], "//", "Together"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7547],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", 
   RowBox[{"-", 
    FractionBox[
     RowBox[{"2", " ", "z"}], 
     RowBox[{
      RowBox[{"-", "1"}], "+", 
      SuperscriptBox["z", "2"]}]]}], ",", 
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "3"}], " ", "z"}], "+", 
     SuperscriptBox["z", "3"]}], 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"3", " ", 
      SuperscriptBox["z", "2"]}]}]]}], "}"}]], "Output",
 ImageSize->{153, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->378959895]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23202],

Cell["Solve a trigonometric equation:", "ExampleText",
 CellID->7245],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"Tan", "[", "z", "]"}], "2"], "-", 
     RowBox[{"2", " ", 
      RowBox[{"Tan", "[", 
       RowBox[{"z", "+", 
        RowBox[{"Pi", "/", "4"}]}], "]"}]}]}], "\[Equal]", "4"}], ",", "z"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6702],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{537, 130},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3217358]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->31539],

Cell["Solve for zeros and poles: ", "ExampleText",
 CellID->2572],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Tan", "[", 
     RowBox[{
      RowBox[{"\[Alpha]", " ", "x"}], "+", "\[Beta]"}], "]"}], "==", "0"}], 
   ",", "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2257],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Alpha]", "\[Equal]", "0"}], "&&", 
      RowBox[{"\[Beta]", "\[Equal]", 
       RowBox[{"\[Pi]", " ", 
        RowBox[{"C", "[", "1", "]"}]}]}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Alpha]", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"x", "\[Equal]", 
       FractionBox[
        RowBox[{
         RowBox[{"-", "\[Beta]"}], "+", 
         RowBox[{"\[Pi]", " ", 
          RowBox[{"C", "[", "1", "]"}]}]}], "\[Alpha]"]}]}], ")"}]}], 
   ")"}]}]], "Output",
 ImageSize->{439, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->82895104]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Tan", "[", 
      RowBox[{
       RowBox[{"\[Alpha]", " ", "x"}], "+", "\[Beta]"}], "]"}]}], "==", "0"}],
    ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21920],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Alpha]", "\[Equal]", "0"}], "&&", 
      RowBox[{"\[Beta]", "\[Equal]", 
       RowBox[{
        FractionBox["\[Pi]", "2"], "+", 
        RowBox[{"\[Pi]", " ", 
         RowBox[{"C", "[", "1", "]"}]}]}]}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[Alpha]", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"x", "\[Equal]", 
       FractionBox[
        RowBox[{
         FractionBox["\[Pi]", "2"], "-", "\[Beta]", "+", 
         RowBox[{"\[Pi]", " ", 
          RowBox[{"C", "[", "1", "]"}]}]}], "\[Alpha]"]}]}], ")"}]}], 
   ")"}]}]], "Output",
 ImageSize->{479, 42},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->814459634]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19359],

Cell["Numerically find a root of a transcendental equation:", "ExampleText",
 CellID->11080],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"Tan", "[", "z", "]"}], "2"], "+", 
     RowBox[{"3", " ", 
      RowBox[{"Tan", "[", 
       RowBox[{"z", "+", 
        RowBox[{"Pi", "/", "6"}]}], "]"}]}], "+", "z"}], "\[Equal]", "4"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", " ", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7298],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", "2.0381553427104837`"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->125044678]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23960],

Cell["Integrals:", "ExampleText",
 CellID->30510],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[Integral]", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"Tan", "[", "z", "]"}], "a"], 
   RowBox[{"\[DifferentialD]", "z"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29591],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Hypergeometric2F1", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"1", "+", "a"}], "2"], ",", "1", ",", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"1", "+", "a"}], "2"]}], ",", 
     RowBox[{"-", 
      SuperscriptBox[
       RowBox[{"Tan", "[", "z", "]"}], "2"]}]}], "]"}], " ", 
   SuperscriptBox[
    RowBox[{"Tan", "[", "z", "]"}], 
    RowBox[{"1", "+", "a"}]]}], 
  RowBox[{"1", "+", "a"}]]], "Output",
 ImageSize->{356, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->37978366]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22033],

Cell["Fourier transform:", "ExampleText",
 CellID->1675],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"Tan", "[", "t", "]"}], ",", "t", ",", "s"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12136],

Cell[BoxData[
 RowBox[{
  SqrtBox[
   FractionBox["\[Pi]", "2"]], " ", 
  RowBox[{"Csc", "[", 
   FractionBox[
    RowBox[{"\[Pi]", " ", "s"}], "2"], "]"}]}]], "Output",
 ImageSize->{97, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->229598390]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->17775],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Tan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tan"]], "InlineFormula"],
 " appears in special cases of many mathematical functions: "
}], "ExampleText",
 CellID->25790],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"MathieuS", "[", 
     RowBox[{"1", ",", "0", ",", "z"}], "]"}], 
    RowBox[{"MathieuC", "[", 
     RowBox[{"1", ",", "0", ",", "z"}], "]"}]], ",", 
   RowBox[{"JacobiSC", "[", 
    RowBox[{"z", ",", "0"}], "]"}], ",", 
   RowBox[{"JacobiCS", "[", 
    RowBox[{
     RowBox[{
      FractionBox["\[Pi]", "2"], "-", "z"}], ",", "0"}], "]"}], ",", " ", 
   RowBox[{"JacobiSN", "[", 
    RowBox[{
     RowBox[{"\[ImaginaryI]", " ", "z"}], ",", "1"}], "]"}], ",", " ", 
   RowBox[{"JacobiNS", "[", 
    RowBox[{
     RowBox[{
      FractionBox[
       RowBox[{"\[Pi]", " ", "\[ImaginaryI]"}], "2"], "-", 
      RowBox[{"\[ImaginaryI]", " ", "z"}]}], ",", "1"}], "]"}], ",", 
   RowBox[{
    RowBox[{"HypergeometricPFQ", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       FractionBox["3", "2"], "}"}], ",", 
      RowBox[{"-", "z"}]}], "]"}], "/", 
    RowBox[{"HypergeometricPFQ", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"{", 
       FractionBox["1", "2"], "}"}], ",", 
      RowBox[{"-", "z"}]}], "]"}]}], ",", 
   RowBox[{
    RowBox[{"MeijerG", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         FractionBox["1", "2"], "}"}], ",", 
        RowBox[{"{", "0", "}"}]}], "}"}], ",", "z"}], "]"}], "/", 
    RowBox[{"MeijerG", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", "}"}], ",", 
        RowBox[{"{", "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"-", 
          FractionBox["1", "2"]}], "}"}], ",", 
        RowBox[{"{", "0", "}"}]}], "}"}], ",", "z"}], "]"}]}]}], 
  "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14376],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Tan", "[", "z", "]"}], ",", 
   RowBox[{"Tan", "[", "z", "]"}], ",", 
   RowBox[{"Tan", "[", "z", "]"}], ",", 
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"Tan", "[", "z", "]"}]}], ",", 
   RowBox[{
    RowBox[{"-", "\[ImaginaryI]"}], " ", 
    RowBox[{"Tan", "[", "z", "]"}]}], ",", 
   FractionBox[
    RowBox[{"Tan", "[", 
     RowBox[{"2", " ", 
      SqrtBox["z"]}], "]"}], 
    RowBox[{"2", " ", 
     SqrtBox["z"]}]], ",", 
   RowBox[{
    SqrtBox["z"], " ", 
    RowBox[{"Tan", "[", 
     RowBox[{"2", " ", 
      SqrtBox["z"]}], "]"}]}]}], "}"}]], "Output",
 ImageSize->{494, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->763240863]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20272],

Cell["Calculate residue symbolically and numerically: ", "ExampleText",
 CellID->20703],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Residue", "[", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"Tan", "[", "z", "]"}], "k"], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", 
       FractionBox["\[Pi]", "2"]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"k", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5086],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "1"}], ",", "0", ",", "1", ",", "0", ",", 
   RowBox[{"-", "1"}]}], "}"}]], "Output",
 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->320650313]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"2", "\[Pi]", " ", "I"}]], 
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    RowBox[{"Tan", "[", "z", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{
       FractionBox["\[Pi]", "2"], "-", 
       FractionBox["1", "4"]}], ",", 
      RowBox[{
       FractionBox["\[Pi]", "2"], "-", 
       FractionBox["I", "4"]}], ",", 
      RowBox[{
       FractionBox["\[Pi]", "2"], "+", 
       FractionBox["1", "4"]}], ",", 
      RowBox[{
       FractionBox["\[Pi]", "2"], "+", 
       FractionBox["I", "4"]}], ",", 
      RowBox[{
       FractionBox["\[Pi]", "2"], "-", 
       FractionBox["1", "4"]}]}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9515],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.9999999999999983`"}], "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{64, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->78507738]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23495],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Tan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tan"]], "InlineFormula"],
 " is a numeric function:"
}], "ExampleText",
 CellID->3566],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Tan", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18456],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Listable", ",", "NumericFunction", ",", "Protected"}], 
  "}"}]], "Output",
 ImageSize->{265, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->310331583]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericQ", "[", 
  RowBox[{"Tan", "[", 
   RowBox[{"2", "+", "E"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8437],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->37353262]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12626],

Cell["\<\
Machine-precision input is insufficient to give a correct answer:\
\>", "ExampleText",
 CellID->18364],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tan", "[", 
  RowBox[{"10.", "^", "30"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1085],

Cell[BoxData[
 RowBox[{"-", "1.155891272768109`"}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->130741105]
}, Open  ]],

Cell["With exact input, the answer is correct:", "ExampleText",
 CellID->18908],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Tan", "[", 
    RowBox[{"10", "^", "30"}], "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20340],

Cell[BoxData["0.09048506806330217256622313805004127349`20."], "Output",
 ImageSize->{165, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->247908362]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2814],

Cell[TextData[{
 "A larger setting for ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " is needed:"
}], "ExampleText",
 CellID->21154],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Tan", "[", 
    RowBox[{"10", "^", "100"}], "]"}], ",", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18012],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \
\\!\\(Tan[\
100000000000000000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000]\\). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/meprec\\\", ButtonNote -> \
\\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->364530609],

Cell[BoxData["ComplexInfinity"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->132669875]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "200"}], "}"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"Tan", "[", 
      RowBox[{"10", "^", "100"}], "]"}], ",", "20"}], "]"}]}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->8706],

Cell[BoxData["0.40123196199081435418575434365329495832`20."], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->185448913]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->32517],

Cell["\<\
In traditional form parentheses are needed around the argument:\
\>", "ExampleText",
 CellID->8421],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"tan", " ", "x"}], TraditionalForm]], "Input",
 CellLabel->"In[1]:=",
 CellID->14145],

Cell[BoxData[
 RowBox[{"tan", " ", "x"}]], "Output",
 ImageSize->{35, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->306906994]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"tan", "(", "x", ")"}], TraditionalForm]], "Input",
 CellLabel->"In[2]:=",
 CellID->1969],

Cell[BoxData[
 RowBox[{"Tan", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->20175883]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16715],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Product]", 
   RowBox[{"k", "=", "1"}], 
   RowBox[{"n", "-", "1"}]], " ", 
  RowBox[{"Tan", "[", 
   RowBox[{"z", "+", 
    FractionBox[
     RowBox[{"k", " ", "\[Pi]"}], "n"]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31066],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], "n"]}], " ", 
  RowBox[{"Cot", "[", "z", "]"}], " ", 
  RowBox[{"Csc", "[", 
   RowBox[{
    FractionBox["1", "2"], " ", "n", " ", 
    RowBox[{"(", 
     RowBox[{"\[Pi]", "-", 
      RowBox[{"2", " ", "z"}]}], ")"}]}], "]"}], " ", 
  RowBox[{"Sin", "[", 
   RowBox[{"n", " ", "z"}], "]"}]}]], "Output",
 ImageSize->{260, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->331123468]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14663],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"Tan", "[", 
    RowBox[{"ArcCot", "[", "z", "]"}], "]"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11771],

Cell[BoxData[
 RowBox[{"Log", "[", "z", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->87927224]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16259],

Cell[TextData[{
 "Plot ",
 Cell[BoxData[
  ButtonBox["Tan",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tan"]], "InlineFormula"],
 " at integer points:"
}], "ExampleText",
 CellID->18631],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ArrayPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"ArcTan", "[", 
     RowBox[{"Abs", "[", 
      RowBox[{"Tan", "[", 
       RowBox[{"x", " ", "y"}], "]"}], "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "20"}], ",", "20"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "20"}], ",", "20"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23572],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{155, 155},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{155., Automatic}},
 CellLabel->"Out[1]=",
 CellID->261946701]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10966],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Tan", "[", 
   FractionBox["\[Pi]", 
    SuperscriptBox["2", "12"]], "]"}], "//", "FunctionExpand"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25988],

Cell[BoxData[
 FractionBox[
  SqrtBox[
   RowBox[{"2", "-", 
    SqrtBox[
     RowBox[{"2", "+", 
      SqrtBox[
       RowBox[{"2", "+", 
        SqrtBox[
         RowBox[{"2", "+", 
          SqrtBox[
           RowBox[{"2", "+", 
            SqrtBox[
             RowBox[{"2", "+", 
              SqrtBox[
               RowBox[{"2", "+", 
                SqrtBox[
                 RowBox[{"2", "+", 
                  SqrtBox[
                   RowBox[{"2", "+", 
                    SqrtBox[
                    RowBox[{"2", "+", 
                    SqrtBox["2"]}]]}]]}]]}]]}]]}]]}]]}]]}]]}]], 
  SqrtBox[
   RowBox[{"2", "+", 
    SqrtBox[
     RowBox[{"2", "+", 
      SqrtBox[
       RowBox[{"2", "+", 
        SqrtBox[
         RowBox[{"2", "+", 
          SqrtBox[
           RowBox[{"2", "+", 
            SqrtBox[
             RowBox[{"2", "+", 
              SqrtBox[
               RowBox[{"2", "+", 
                SqrtBox[
                 RowBox[{"2", "+", 
                  SqrtBox[
                   RowBox[{"2", "+", 
                    SqrtBox[
                    RowBox[{"2", "+", 
                    SqrtBox["2"]}]]}]]}]]}]]}]]}]]}]]}]]}]]}]]]], "Output",
 ImageSize->{411, 143},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->342698744]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->28168],

Cell["The continued fraction is highly regular:", "ExampleText",
 CellID->22199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", 
  RowBox[{
   RowBox[{"Tan", "[", "1", "]"}], ",", "22"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->655],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "1", ",", "3", ",", "1", ",", "5", ",", "1", ",", "7", 
   ",", "1", ",", "9", ",", "1", ",", "11", ",", "1", ",", "13", ",", "1", 
   ",", "15", ",", "1", ",", "17", ",", "1", ",", "19", ",", "1", ",", "21"}],
   "}"}]], "Output",
 ImageSize->{449, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->370914904]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->13444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Element", "[", 
  RowBox[{
   RowBox[{"Tan", "[", "1", "]"}], ",", " ", "Algebraics"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12936],

Cell[BoxData["False"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->130304445]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9279363],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Tan", "[", 
    RowBox[{
     RowBox[{"y", "^", "2"}], "-", 
     RowBox[{"x", "^", "3"}], "+", 
     RowBox[{"3", " ", "x"}], "-", "3"}], "]"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", " ", 
   RowBox[{"Exclusions", "->", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Cos", "[", 
       RowBox[{
        RowBox[{"y", "^", "2"}], "-", 
        RowBox[{"x", "^", "3"}], "+", 
        RowBox[{"3", " ", "x"}], "-", "3"}], "]"}], "==", "0"}], "}"}]}], ",",
    
   RowBox[{"PlotPoints", "\[Rule]", "30"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->49949951],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 152},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->549989523]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->15415],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcTan",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcTan"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cot"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tanh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tanh"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Degree",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Degree"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigToExp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigToExp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigExpand"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18086]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->24870],

Cell[TextData[ButtonBox["Some Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SomeMathematicalFunctions"]], "Tutorials",
 CellID->31754],

Cell[TextData[ButtonBox["Elementary Transcendental Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ElementaryTranscendentalFunctions"]], "Tutorials",
 CellID->26072]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->32176],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/Tangent.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/ElementaryFunctions/Tan/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Tan"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->53763465],

Cell[TextData[ButtonBox["Elementary Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementaryFunctions"]], "MoreAbout",
 CellID->570199783],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->14541730],

Cell[TextData[ButtonBox["Precollege Education",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PrecollegeEducation"]], "MoreAbout",
 CellID->120469067],

Cell[TextData[ButtonBox["Trigonometric Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TrigonometricFunctions"]], "MoreAbout",
 CellID->401512698]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Tan - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 26, 16.2536556}", "context" -> "System`", 
    "keywords" -> {"tan", "tangent", "tg"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Tan[z] gives the tangent of z. ", "synonyms" -> {}, "title" -> "Tan", 
    "type" -> "Symbol", "uri" -> "ref/Tan"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7070, 234, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->401389190]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 153228, 4207}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2889, 63, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3512, 90, 40, 1, 70, "ObjectName",
 CellID->1954],
Cell[3555, 93, 534, 18, 70, "Usage",
 CellID->930]
}, Open  ]],
Cell[CellGroupData[{
Cell[4126, 116, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4604, 133, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4727, 139, 368, 13, 70, "Notes",
 CellID->19904],
Cell[5098, 154, 772, 29, 70, "Notes",
 CellID->20279],
Cell[5873, 185, 514, 16, 70, "Notes",
 CellID->12488],
Cell[6390, 203, 238, 8, 70, "Notes",
 CellID->619728989],
Cell[6631, 213, 208, 7, 70, "Notes",
 CellID->31226],
Cell[6842, 222, 191, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[7070, 234, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->401389190],
Cell[CellGroupData[{
Cell[7455, 248, 148, 5, 70, "ExampleSection",
 CellID->301346248],
Cell[7606, 255, 72, 1, 70, "ExampleText",
 CellID->30260],
Cell[CellGroupData[{
Cell[7703, 260, 119, 4, 28, "Input",
 CellID->20514],
Cell[7825, 266, 190, 7, 55, "Output",
 CellID->408122242]
}, Open  ]],
Cell[8030, 276, 121, 3, 70, "ExampleDelimiter",
 CellID->16657],
Cell[8154, 281, 213, 8, 70, "ExampleText",
 CellID->14990],
Cell[CellGroupData[{
Cell[8392, 293, 119, 4, 70, "Input",
 CellID->19438],
Cell[8514, 299, 190, 7, 55, "Output",
 CellID->553387931]
}, Open  ]],
Cell[8719, 309, 121, 3, 70, "ExampleDelimiter",
 CellID->15447],
Cell[CellGroupData[{
Cell[8865, 316, 230, 8, 28, "Input",
 CellID->5242],
Cell[9098, 326, 2736, 49, 108, "Output",
 Evaluatable->False,
 CellID->283790261]
}, Open  ]],
Cell[11849, 378, 121, 3, 70, "ExampleDelimiter",
 CellID->16070],
Cell[CellGroupData[{
Cell[11995, 385, 212, 7, 70, "Input",
 CellID->25631],
Cell[12210, 394, 841, 29, 54, "Output",
 CellID->1721847]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13100, 429, 217, 7, 70, "ExampleSection",
 CellID->28781],
Cell[13320, 438, 60, 1, 70, "ExampleText",
 CellID->20990],
Cell[CellGroupData[{
Cell[13405, 443, 97, 3, 70, "Input",
 CellID->12833],
Cell[13505, 448, 176, 5, 36, "Output",
 CellID->530280383]
}, Open  ]],
Cell[13696, 456, 120, 3, 70, "ExampleDelimiter",
 CellID->1563],
Cell[13819, 461, 66, 1, 70, "ExampleText",
 CellID->21302],
Cell[CellGroupData[{
Cell[13910, 466, 173, 6, 70, "Input",
 CellID->502],
Cell[14086, 474, 234, 7, 36, "Output",
 CellID->699157300]
}, Open  ]],
Cell[14335, 484, 125, 3, 70, "ExampleDelimiter",
 CellID->117890470],
Cell[14463, 489, 109, 3, 70, "ExampleText",
 CellID->30721],
Cell[CellGroupData[{
Cell[14597, 496, 119, 3, 70, "Input",
 CellID->24898],
Cell[14719, 501, 217, 6, 36, "Output",
 CellID->45644408]
}, Open  ]],
Cell[14951, 510, 124, 3, 70, "ExampleDelimiter",
 CellID->41436957],
Cell[15078, 515, 129, 4, 70, "ExampleText",
 CellID->10945],
Cell[CellGroupData[{
Cell[15232, 523, 136, 4, 70, "Input",
 CellID->28406],
Cell[15371, 529, 196, 5, 36, "Output",
 CellID->31500027]
}, Open  ]],
Cell[15582, 537, 120, 3, 70, "ExampleDelimiter",
 CellID->8686],
Cell[15705, 542, 208, 7, 70, "ExampleText",
 CellID->5794],
Cell[CellGroupData[{
Cell[15938, 553, 158, 5, 70, "Input",
 CellID->23577],
Cell[16099, 560, 286, 8, 36, "Output",
 CellID->296822387]
}, Open  ]],
Cell[CellGroupData[{
Cell[16422, 573, 571, 17, 70, "Input",
 CellID->18683],
Cell[16996, 592, 383, 14, 43, "Output",
 CellID->164601278]
}, Open  ]],
Cell[17394, 609, 121, 3, 70, "ExampleDelimiter",
 CellID->13240],
Cell[17518, 614, 193, 7, 70, "ExampleText",
 CellID->485],
Cell[CellGroupData[{
Cell[17736, 625, 120, 4, 70, "Input",
 CellID->16464],
Cell[17859, 631, 271, 8, 36, "Output",
 CellID->262094009]
}, Open  ]],
Cell[18145, 642, 121, 3, 70, "ExampleDelimiter",
 CellID->20337],
Cell[18269, 647, 87, 1, 70, "ExampleText",
 CellID->16653],
Cell[CellGroupData[{
Cell[18381, 652, 119, 4, 70, "Input",
 CellID->27168],
Cell[18503, 658, 230, 9, 44, "Output",
 CellID->171098897]
}, Open  ]],
Cell[18748, 670, 238, 8, 70, "ExampleText",
 CellID->15255],
Cell[CellGroupData[{
Cell[19011, 682, 118, 4, 70, "Input",
 CellID->1466],
Cell[19132, 688, 212, 7, 49, "Output",
 CellID->289927032]
}, Open  ]],
Cell[CellGroupData[{
Cell[19381, 700, 106, 3, 70, "Input",
 CellID->22512],
Cell[19490, 705, 265, 11, 72, "Output",
 CellID->12192958]
}, Open  ]],
Cell[19770, 719, 120, 3, 70, "ExampleDelimiter",
 CellID->3318],
Cell[19893, 724, 90, 3, 70, "ExampleText",
 CellID->13201],
Cell[CellGroupData[{
Cell[20008, 731, 149, 5, 70, "Input",
 CellID->142],
Cell[20160, 738, 1091, 36, 57, "Output",
 CellID->675746382]
}, Open  ]],
Cell[CellGroupData[{
Cell[21288, 779, 102, 3, 70, "Input",
 CellID->31506],
Cell[21393, 784, 210, 7, 36, "Output",
 CellID->106163501]
}, Open  ]],
Cell[21618, 794, 121, 3, 70, "ExampleDelimiter",
 CellID->10684],
Cell[21742, 799, 91, 1, 70, "ExampleText",
 CellID->15023],
Cell[CellGroupData[{
Cell[21858, 804, 187, 6, 70, "Input",
 CellID->30270],
Cell[22048, 812, 305, 10, 36, "Output",
 CellID->710210378]
}, Open  ]],
Cell[22368, 825, 120, 3, 70, "ExampleDelimiter",
 CellID->8250],
Cell[22491, 830, 70, 1, 70, "ExampleText",
 CellID->13475],
Cell[CellGroupData[{
Cell[22586, 835, 184, 6, 70, "Input",
 CellID->20311],
Cell[22773, 843, 656, 23, 53, "Output",
 CellID->523670585]
}, Open  ]],
Cell[23444, 869, 121, 3, 70, "ExampleDelimiter",
 CellID->19195],
Cell[23568, 874, 70, 1, 70, "ExampleText",
 CellID->5488],
Cell[CellGroupData[{
Cell[23663, 879, 131, 4, 70, "Input",
 CellID->11520],
Cell[23797, 885, 641, 20, 59, "Output",
 CellID->133479821]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24487, 911, 239, 7, 70, "ExampleSection",
 CellID->20183],
Cell[24729, 920, 208, 7, 70, "ExampleText",
 CellID->24798],
Cell[CellGroupData[{
Cell[24962, 931, 206, 7, 70, "Input",
 CellID->27892],
Cell[25171, 940, 253, 9, 43, "Output",
 CellID->22936558]
}, Open  ]],
Cell[25439, 952, 120, 3, 70, "ExampleDelimiter",
 CellID->6784],
Cell[25562, 957, 80, 1, 70, "ExampleText",
 CellID->30245],
Cell[CellGroupData[{
Cell[25667, 962, 102, 3, 70, "Input",
 CellID->12187],
Cell[25772, 967, 282, 10, 36, "Output",
 CellID->80955922]
}, Open  ]],
Cell[CellGroupData[{
Cell[26091, 982, 109, 3, 70, "Input",
 CellID->28343],
Cell[26203, 987, 170, 5, 36, "Output",
 CellID->478400197]
}, Open  ]],
Cell[26388, 995, 121, 3, 70, "ExampleDelimiter",
 CellID->16859],
Cell[26512, 1000, 194, 7, 70, "ExampleText",
 CellID->8871],
Cell[CellGroupData[{
Cell[26731, 1011, 325, 11, 70, "Input",
 CellID->14016],
Cell[27059, 1024, 596, 21, 51, "Output",
 CellID->233728882]
}, Open  ]],
Cell[27670, 1048, 121, 3, 70, "ExampleDelimiter",
 CellID->22832],
Cell[27794, 1053, 222, 7, 70, "ExampleText",
 CellID->24441],
Cell[CellGroupData[{
Cell[28041, 1064, 600, 20, 70, "Input",
 CellID->17683],
Cell[28644, 1086, 479, 17, 36, "Output",
 CellID->118375015]
}, Open  ]],
Cell[CellGroupData[{
Cell[29160, 1108, 95, 3, 70, "Input",
 CellID->22015],
Cell[29258, 1113, 479, 17, 36, "Output",
 CellID->571483383]
}, Open  ]],
Cell[CellGroupData[{
Cell[29774, 1135, 143, 5, 70, "Input",
 CellID->18516],
Cell[29920, 1142, 839, 27, 102, "Output",
 CellID->484448545]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[30808, 1175, 223, 7, 70, "ExampleSection",
 CellID->31283],
Cell[31034, 1184, 73, 1, 70, "ExampleText",
 CellID->3205],
Cell[CellGroupData[{
Cell[31132, 1189, 358, 12, 70, "Input",
 CellID->470472475],
Cell[31493, 1203, 2697, 48, 70, "Output",
 Evaluatable->False,
 CellID->160277267]
}, Open  ]],
Cell[34205, 1254, 120, 3, 70, "ExampleDelimiter",
 CellID->5769],
Cell[34328, 1259, 87, 1, 70, "ExampleText",
 CellID->23675],
Cell[CellGroupData[{
Cell[34440, 1264, 384, 13, 70, "Input",
 CellID->917],
Cell[34827, 1279, 29066, 481, 70, "Output",
 Evaluatable->False,
 CellID->429873563]
}, Open  ]],
Cell[63908, 1763, 121, 3, 70, "ExampleDelimiter",
 CellID->15020],
Cell[64032, 1768, 98, 2, 70, "ExampleText",
 CellID->6030],
Cell[CellGroupData[{
Cell[64155, 1774, 387, 13, 70, "Input",
 CellID->17442],
Cell[64545, 1789, 353, 12, 36, "Output",
 CellID->83804173]
}, Open  ]],
Cell[64913, 1804, 121, 3, 70, "ExampleDelimiter",
 CellID->32389],
Cell[65037, 1809, 115, 3, 70, "ExampleText",
 CellID->20373],
Cell[CellGroupData[{
Cell[65177, 1816, 1423, 45, 70, "Input",
 CellID->3480],
Cell[66603, 1863, 3694, 65, 70, "Output",
 Evaluatable->False,
 CellID->221947056]
}, Open  ]],
Cell[70312, 1931, 125, 3, 70, "ExampleDelimiter",
 CellID->175153784],
Cell[70440, 1936, 149, 4, 70, "ExampleText",
 CellID->302947038],
Cell[CellGroupData[{
Cell[70614, 1944, 700, 22, 70, "Input",
 CellID->52082174],
Cell[71317, 1968, 540, 17, 48, "Output",
 CellID->331613496]
}, Open  ]],
Cell[CellGroupData[{
Cell[71894, 1990, 341, 10, 70, "Input",
 CellID->375873995],
Cell[72238, 2002, 3014, 53, 70, "Output",
 Evaluatable->False,
 CellID->295506517]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[75301, 2061, 234, 7, 70, "ExampleSection",
 CellID->10777],
Cell[75538, 2070, 137, 4, 70, "ExampleText",
 CellID->786],
Cell[CellGroupData[{
Cell[75700, 2078, 137, 5, 70, "Input",
 CellID->8381],
Cell[75840, 2085, 187, 6, 36, "Output",
 CellID->314824385]
}, Open  ]],
Cell[CellGroupData[{
Cell[76064, 2096, 111, 4, 70, "Input",
 CellID->522],
Cell[76178, 2102, 205, 7, 36, "Output",
 CellID->770938967]
}, Open  ]],
Cell[CellGroupData[{
Cell[76420, 2114, 118, 4, 70, "Input",
 CellID->20979],
Cell[76541, 2120, 222, 7, 36, "Output",
 CellID->62147300]
}, Open  ]],
Cell[CellGroupData[{
Cell[76800, 2132, 118, 4, 70, "Input",
 CellID->15713],
Cell[76921, 2138, 185, 6, 36, "Output",
 CellID->8763064]
}, Open  ]],
Cell[77121, 2147, 121, 3, 70, "ExampleDelimiter",
 CellID->19735],
Cell[77245, 2152, 559, 23, 70, "ExampleText",
 CellID->30883],
Cell[CellGroupData[{
Cell[77829, 2179, 147, 5, 70, "Input",
 CellID->2186],
Cell[77979, 2186, 186, 6, 36, "Output",
 CellID->68152054]
}, Open  ]],
Cell[CellGroupData[{
Cell[78202, 2197, 136, 4, 70, "Input",
 CellID->20648],
Cell[78341, 2203, 448, 16, 36, "Output",
 CellID->369070566]
}, Open  ]],
Cell[78804, 2222, 121, 3, 70, "ExampleDelimiter",
 CellID->14752],
Cell[78928, 2227, 136, 4, 70, "ExampleText",
 CellID->521],
Cell[CellGroupData[{
Cell[79089, 2235, 147, 5, 70, "Input",
 CellID->9260],
Cell[79239, 2242, 241, 8, 36, "Output",
 CellID->505894994]
}, Open  ]],
Cell[CellGroupData[{
Cell[79517, 2255, 99, 3, 70, "Input",
 CellID->6636],
Cell[79619, 2260, 239, 8, 36, "Output",
 CellID->62497426]
}, Open  ]],
Cell[79873, 2271, 121, 3, 70, "ExampleDelimiter",
 CellID->19919],
Cell[79997, 2276, 80, 1, 70, "ExampleText",
 CellID->17236],
Cell[CellGroupData[{
Cell[80102, 2281, 162, 6, 70, "Input",
 CellID->26792],
Cell[80267, 2289, 238, 8, 36, "Output",
 CellID->489592473]
}, Open  ]],
Cell[CellGroupData[{
Cell[80542, 2302, 163, 5, 70, "Input",
 CellID->19278],
Cell[80708, 2309, 205, 7, 36, "Output",
 CellID->283888795]
}, Open  ]],
Cell[80928, 2319, 121, 3, 70, "ExampleDelimiter",
 CellID->31496],
Cell[81052, 2324, 70, 1, 70, "ExampleText",
 CellID->26386],
Cell[CellGroupData[{
Cell[81147, 2329, 371, 12, 70, "Input",
 CellID->21011],
Cell[81521, 2343, 398, 13, 36, "Output",
 CellID->509885898]
}, Open  ]],
Cell[CellGroupData[{
Cell[81956, 2361, 136, 4, 70, "Input",
 CellID->7547],
Cell[82095, 2367, 580, 22, 56, "Output",
 CellID->378959895]
}, Open  ]],
Cell[82690, 2392, 121, 3, 70, "ExampleDelimiter",
 CellID->23202],
Cell[82814, 2397, 69, 1, 70, "ExampleText",
 CellID->7245],
Cell[CellGroupData[{
Cell[82908, 2402, 358, 13, 70, "Input",
 CellID->6702],
Cell[83269, 2417, 2801, 50, 70, "Output",
 Evaluatable->False,
 CellID->3217358]
}, Open  ]],
Cell[86085, 2470, 121, 3, 70, "ExampleDelimiter",
 CellID->31539],
Cell[86209, 2475, 65, 1, 70, "ExampleText",
 CellID->2572],
Cell[CellGroupData[{
Cell[86299, 2480, 247, 9, 70, "Input",
 CellID->2257],
Cell[86549, 2491, 793, 26, 51, "Output",
 CellID->82895104]
}, Open  ]],
Cell[CellGroupData[{
Cell[87379, 2522, 276, 10, 70, "Input",
 CellID->21920],
Cell[87658, 2534, 872, 28, 63, "Output",
 CellID->814459634]
}, Open  ]],
Cell[88545, 2565, 121, 3, 70, "ExampleDelimiter",
 CellID->19359],
Cell[88669, 2570, 92, 1, 70, "ExampleText",
 CellID->11080],
Cell[CellGroupData[{
Cell[88786, 2575, 425, 15, 70, "Input",
 CellID->7298],
Cell[89214, 2592, 227, 7, 36, "Output",
 CellID->125044678]
}, Open  ]],
Cell[89456, 2602, 121, 3, 70, "ExampleDelimiter",
 CellID->23960],
Cell[89580, 2607, 49, 1, 70, "ExampleText",
 CellID->30510],
Cell[CellGroupData[{
Cell[89654, 2612, 202, 7, 70, "Input",
 CellID->29591],
Cell[89859, 2621, 610, 21, 59, "Output",
 CellID->37978366]
}, Open  ]],
Cell[90484, 2645, 121, 3, 70, "ExampleDelimiter",
 CellID->22033],
Cell[90608, 2650, 56, 1, 70, "ExampleText",
 CellID->1675],
Cell[CellGroupData[{
Cell[90689, 2655, 172, 5, 70, "Input",
 CellID->12136],
Cell[90864, 2662, 299, 11, 60, "Output",
 CellID->229598390]
}, Open  ]],
Cell[91178, 2676, 121, 3, 70, "ExampleDelimiter",
 CellID->17775],
Cell[91302, 2681, 221, 7, 70, "ExampleText",
 CellID->25790],
Cell[CellGroupData[{
Cell[91548, 2692, 1877, 62, 70, "Input",
 CellID->14376],
Cell[93428, 2756, 751, 26, 64, "Output",
 CellID->763240863]
}, Open  ]],
Cell[94194, 2785, 121, 3, 70, "ExampleDelimiter",
 CellID->20272],
Cell[94318, 2790, 87, 1, 70, "ExampleText",
 CellID->20703],
Cell[CellGroupData[{
Cell[94430, 2795, 372, 13, 70, "Input",
 CellID->5086],
Cell[94805, 2810, 272, 9, 36, "Output",
 CellID->320650313]
}, Open  ]],
Cell[CellGroupData[{
Cell[95114, 2824, 735, 25, 70, "Input",
 CellID->9515],
Cell[95852, 2851, 252, 8, 36, "Output",
 CellID->78507738]
}, Open  ]],
Cell[96119, 2862, 121, 3, 70, "ExampleDelimiter",
 CellID->23495],
Cell[96243, 2867, 185, 7, 70, "ExampleText",
 CellID->3566],
Cell[CellGroupData[{
Cell[96453, 2878, 104, 3, 70, "Input",
 CellID->18456],
Cell[96560, 2883, 246, 8, 36, "Output",
 CellID->310331583]
}, Open  ]],
Cell[CellGroupData[{
Cell[96843, 2896, 153, 5, 70, "Input",
 CellID->8437],
Cell[96999, 2903, 160, 5, 36, "Output",
 CellID->37353262]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[97208, 2914, 226, 7, 70, "ExampleSection",
 CellID->12626],
Cell[97437, 2923, 112, 3, 70, "ExampleText",
 CellID->18364],
Cell[CellGroupData[{
Cell[97574, 2930, 120, 4, 70, "Input",
 CellID->1085],
Cell[97697, 2936, 192, 6, 36, "Output",
 CellID->130741105]
}, Open  ]],
Cell[97904, 2945, 79, 1, 70, "ExampleText",
 CellID->18908],
Cell[CellGroupData[{
Cell[98008, 2950, 175, 6, 70, "Input",
 CellID->20340],
Cell[98186, 2958, 202, 5, 36, "Output",
 CellID->247908362]
}, Open  ]],
Cell[98403, 2966, 120, 3, 70, "ExampleDelimiter",
 CellID->2814],
Cell[98526, 2971, 230, 8, 70, "ExampleText",
 CellID->21154],
Cell[CellGroupData[{
Cell[98781, 2983, 176, 6, 70, "Input",
 CellID->18012],
Cell[98960, 2991, 527, 11, 70, "Message",
 CellID->364530609],
Cell[99490, 3004, 173, 5, 36, "Output",
 CellID->132669875]
}, Open  ]],
Cell[CellGroupData[{
Cell[99700, 3014, 307, 11, 70, "Input",
 CellID->8706],
Cell[100010, 3027, 202, 5, 36, "Output",
 CellID->185448913]
}, Open  ]],
Cell[100227, 3035, 121, 3, 70, "ExampleDelimiter",
 CellID->32517],
Cell[100351, 3040, 109, 3, 70, "ExampleText",
 CellID->8421],
Cell[CellGroupData[{
Cell[100485, 3047, 119, 4, 70, "Input",
 CellID->14145],
Cell[100607, 3053, 182, 6, 36, "Output",
 CellID->306906994]
}, Open  ]],
Cell[CellGroupData[{
Cell[100826, 3064, 123, 4, 70, "Input",
 CellID->1969],
Cell[100952, 3070, 186, 6, 36, "Output",
 CellID->20175883]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[101187, 3082, 224, 7, 70, "ExampleSection",
 CellID->16715],
Cell[CellGroupData[{
Cell[101436, 3093, 285, 10, 70, "Input",
 CellID->31066],
Cell[101724, 3105, 543, 19, 51, "Output",
 CellID->331123468]
}, Open  ]],
Cell[102282, 3127, 121, 3, 70, "ExampleDelimiter",
 CellID->14663],
Cell[CellGroupData[{
Cell[102428, 3134, 190, 6, 70, "Input",
 CellID->11771],
Cell[102621, 3142, 186, 6, 36, "Output",
 CellID->87927224]
}, Open  ]],
Cell[102822, 3151, 121, 3, 70, "ExampleDelimiter",
 CellID->16259],
Cell[102946, 3156, 192, 8, 70, "ExampleText",
 CellID->18631],
Cell[CellGroupData[{
Cell[103163, 3168, 467, 15, 70, "Input",
 CellID->23572],
Cell[103633, 3185, 3088, 55, 70, "Output",
 Evaluatable->False,
 CellID->261946701]
}, Open  ]],
Cell[106736, 3243, 121, 3, 70, "ExampleDelimiter",
 CellID->10966],
Cell[CellGroupData[{
Cell[106882, 3250, 185, 6, 70, "Input",
 CellID->25988],
Cell[107070, 3258, 1318, 48, 164, "Output",
 CellID->342698744]
}, Open  ]],
Cell[108403, 3309, 121, 3, 70, "ExampleDelimiter",
 CellID->28168],
Cell[108527, 3314, 80, 1, 70, "ExampleText",
 CellID->22199],
Cell[CellGroupData[{
Cell[108632, 3319, 162, 5, 70, "Input",
 CellID->655],
Cell[108797, 3326, 424, 11, 36, "Output",
 CellID->370914904]
}, Open  ]],
Cell[109236, 3340, 121, 3, 70, "ExampleDelimiter",
 CellID->13444],
Cell[CellGroupData[{
Cell[109382, 3347, 167, 5, 70, "Input",
 CellID->12936],
Cell[109552, 3354, 162, 5, 36, "Output",
 CellID->130304445]
}, Open  ]],
Cell[109729, 3362, 123, 3, 70, "ExampleDelimiter",
 CellID->9279363],
Cell[CellGroupData[{
Cell[109877, 3369, 828, 26, 70, "Input",
 CellID->49949951],
Cell[110708, 3397, 36926, 609, 70, "Output",
 Evaluatable->False,
 CellID->549989523]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[147695, 4013, 311, 9, 70, "SeeAlsoSection",
 CellID->15415],
Cell[148009, 4024, 1411, 53, 70, "SeeAlso",
 CellID->18086]
}, Open  ]],
Cell[CellGroupData[{
Cell[149457, 4082, 314, 9, 70, "TutorialsSection",
 CellID->24870],
Cell[149774, 4093, 163, 3, 70, "Tutorials",
 CellID->31754],
Cell[149940, 4098, 182, 4, 70, "Tutorials",
 CellID->26072]
}, Open  ]],
Cell[CellGroupData[{
Cell[150159, 4107, 321, 9, 70, "RelatedLinksSection",
 CellID->32176],
Cell[150483, 4118, 178, 4, 70, "RelatedLinks"],
Cell[150664, 4124, 195, 4, 70, "RelatedLinks"],
Cell[150862, 4130, 381, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[151280, 4148, 318, 9, 70, "MoreAboutSection",
 CellID->53763465],
Cell[151601, 4159, 151, 3, 70, "MoreAbout",
 CellID->570199783],
Cell[151755, 4164, 154, 3, 70, "MoreAbout",
 CellID->14541730],
Cell[151912, 4169, 151, 3, 70, "MoreAbout",
 CellID->120469067],
Cell[152066, 4174, 157, 3, 70, "MoreAbout",
 CellID->401512698]
}, Open  ]],
Cell[152238, 4180, 27, 0, 70, "History"],
Cell[152268, 4182, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

