(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    120172,       3668]
NotebookOptionsPosition[    102484,       3047]
NotebookOutlinePosition[    104153,       3094]
CellTagsIndexPosition[    104015,       3088]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elementary Transcendental Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ElementaryTranscendentalFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Elementary Transcendental Functions\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ArcTanh" :> Documentation`HelpLookup["paclet:ref/ArcTanh"], 
          "Sinh" :> Documentation`HelpLookup["paclet:ref/Sinh"], "Coth" :> 
          Documentation`HelpLookup["paclet:ref/Coth"], "Tan" :> 
          Documentation`HelpLookup["paclet:ref/Tan"], "TrigToExp" :> 
          Documentation`HelpLookup["paclet:ref/TrigToExp"], "TrigExpand" :> 
          Documentation`HelpLookup["paclet:ref/TrigExpand"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"ArcTanh\"\>", 2->"\<\"Sinh\"\>", 
       3->"\<\"Coth\"\>", 4->"\<\"Tan\"\>", 5->"\<\"TrigToExp\"\>", 
       6->"\<\"TrigExpand\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Elementary Functions" :> 
          Documentation`HelpLookup["paclet:guide/ElementaryFunctions"], 
          "Hyperbolic Functions" :> 
          Documentation`HelpLookup["paclet:guide/HyperbolicFunctions"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Elementary Functions\"\>", 
       2->"\<\"Hyperbolic Functions\"\>", 
       3->"\<\"Mathematical Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Tanh", "ObjectName",
 CellID->1899],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Tanh",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Tanh"], "[", 
       StyleBox["z", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the hyperbolic tangent of ",
     Cell[BoxData[
      FormBox["z", TraditionalForm]], "InlineMath"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4120]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Mathematical function, suitable for both symbolic and numerical manipulation.\
\
\>", "Notes",
 CellID->20640],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["Sinh",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Sinh"], "[", 
    StyleBox["z", "TI"], "]"}], "/", 
   RowBox[{
    ButtonBox["Cosh",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Cosh"], "[", 
    StyleBox["z", "TI"], "]"}]}]], "InlineFormula"],
 " is automatically converted to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tanh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tanh"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TrigFactorList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigFactorList"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " does decomposition. "
}], "Notes",
 CellID->32036],

Cell[TextData[{
 "For certain special arguments, ",
 Cell[BoxData[
  ButtonBox["Tanh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tanh"]], "InlineFormula"],
 " automatically evaluates to exact values."
}], "Notes",
 CellID->9487],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Tanh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tanh"]], "InlineFormula"],
 " can be evaluated to arbitrary numerical precision."
}], "Notes",
 CellID->31226],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Tanh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tanh"]], "InlineFormula"],
 " automatically threads over lists."
}], "Notes",
 CellID->28162]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->473378936],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->37154363],

Cell["Evaluate numerically:", "ExampleText",
 CellID->282989273],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tanh", "[", "2.2", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->360007743],

Cell[BoxData["0.9757431300314515`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->75984302]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27497630],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Tanh", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->522964392],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy1WE1oVUcUntz73kv8TxptrdbkqSBSiqCtv3lJ/EuMf6iL4kJcxLSQLNRi
40Y37aZu7EZBFKQu/AF/FkpBKVgoFUoFURCFUgVREF0ohYqLgHD9zjlz79x7
7tyQPPBxM5l75pvvnJlz5syd2do/PPjt3v7hoYH+6oYD/d8NDg18X+3dfwCi
sMEYcwJ/38w0qEeo8d+JKML/fFlDGQIQ0BtVIv6ZANXtjOhULSEVJfduTFkh
NrC4wrhTJ2/v3/erPM1nfrljwvPn7t27+xyPCbl482bE9mtFQcThmDQSIK3p
6dP/hBePaEp0m5CK0uaNZ7o7T+HpWXc6YAlgYs6jf1+11jnO+VROHhl5J6pB
KXoH9lyBHlTwCjkAU+vU8DmVjaIB5oISI/nxh5u/33xsJtfJuYjKCjhBAqod
287CcLiiCXLyfSX1P997MZXl16/fotPOry+gBJP52PbpY8yXbAko0bp710XY
PsPLtZSlL178L1NlpntRy1mK0R8cvk66PvKiVrD09t/PhgavQrNpyVi0klvh
amii1mYvxyqFmuZFdbD04YOXQJE92reCqrH0xvV/Dh/6japTMvbIyjp+7K/L
l+5zEHk5BAUd0AR9BagulmINIOzInkleVDfphz+KW1kTOMBkJmasXc2tcCPs
oOqEwhEH6TVMQUr5pTCWOnIRK7kI0YXQorHo3KTzg/AsiyR7SMCn6ARfTubZ
SrM5JG+F9EqsSPUayxhKjKN4lt9Yx16KfYA6dBf0i2dZWjEsq6Wc8dj6mAur
myLZb3uPisLSKCjnEz+ql6UI9lt/Pin2lKCwwhBnMcpZ3aT6tFm/zmI5FjYW
AVV1VMyxuLlKHnhZ21PvJmGH2XalavY2hfdrkQHLLzD591mRf4dj7WW4CROc
hEJOR1u6dyYyCD1foT9lZ8KpcK2IAg/nHMXCfjWNFu3lzK2JeR47gxxXNdKx
/hlLjvz0BxKkSNpzmGqGy+dFauVRlFxEuX7aNvHTJsYDjC7inT4np3wNo0i6
MSWVdeSkmyO7buzk9aWkQuuk5LHj3jyg3/U+UjceI/ig/Pa9IdKxSNVq0bvN
RIXtGdYtsVSSk80eW6xnTSjOJmGPw9vowSaFrao3J5cVnpKXRQ7vIqYp4/Yo
LaggjePLI62lnNiKLhQWqbZK0oaf5ML1Ba0SsalWHamhxChV12bskgzi8tVa
L0eoONaMgkoyxagoN09rMvaUFcdqL0dJcQiqM1LfDJHkFcfrGLSebsbWUh6W
zo3e2dQ8zpLx8IQmtfNaO7rqtKOi7CjiiXd2PR/CLxmLqp2j9M97wr1LZnW7
ay3jmTiH+3shuNCRvgpqmZiYyK2yeKja4Y2JCfEM4JCAU0ABSrjc9/YqL0q+
a6HOemVlxp4p3Oq+TlZ4OeT7GlkKY6I87kcJl5xayOrlXtRUhVqWsac5brWa
lno5BIXYAAp+Nl95US3sVMwM4gAPzF/ixbXG8YLZvnb1oZzkcig+g9E+//PR
W8gegNOcL8pY/wljYDfUIXjhZhrDF0ncFN0q6EicyWEMXXAbdMEuOA8eotWw
kNm6VI/8GVfH5WwOGZxhsEDhbyRo0OLkiKMPxoKNAfMzr07udiqawI1jJvgw
ejmQy70C3zSEmDY00SVEwDcRMMPeebTwnYf7zGsYhxUEWMCzntw24CEvllgL
5s3ed7SwFTjX16Gl6Gw5/n5x9ojvEraxNH8HZRreA10sTh4=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->575782128]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->227499484],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Tanh", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->279778031],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "-", 
   FractionBox[
    SuperscriptBox["x", "3"], "3"], "+", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "5"]}], "15"], "-", 
   FractionBox[
    RowBox[{"17", " ", 
     SuperscriptBox["x", "7"]}], "315"], "+", 
   FractionBox[
    RowBox[{"62", " ", 
     SuperscriptBox["x", "9"]}], "2835"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, 1, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-1, 3], 0, 
    Rational[2, 15], 0, 
    Rational[-17, 315], 0, 
    Rational[62, 2835]}, 1, 11, 1],
  Editable->False]], "Output",
 ImageSize->{224, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->584202326]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(11)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->351148872],

Cell["Evaluate to high precision:", "ExampleText",
 CellID->12609207],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Tanh", "[", 
    RowBox[{"22", "/", "10"}], "]"}], ",", "50"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->48676102],

Cell[BoxData["0.\
9757431300314515204143066680301146527813050340579887493150816337401`50."], \
"Output",
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->544643094]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->310991724],

Cell["\<\
The precision of the output tracks the precision of the input:\
\>", "ExampleText",
 CellID->354882526],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tanh", "[", "2.20000000000000000000000", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->48899084],

Cell[BoxData["0.97574313003145152041430666803011465279`24.298105763772316"], \
"Output",
 ImageSize->{186, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->43095682]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->202333588],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Tanh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tanh"]], "InlineFormula"],
 " threads element-wise over lists and matrices:"
}], "ExampleText",
 CellID->83756002],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tanh", "[", 
  RowBox[{"{", 
   RowBox[{"1.2", ",", "1.5", ",", "1.8"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->628783698],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.8336546070121552`", ",", "0.9051482536448664`", ",", 
   "0.9468060128462683`"}], "}"}]], "Output",
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->76503126]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->10691152],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Tanh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tanh"]], "InlineFormula"],
 " can take complex number inputs:"
}], "ExampleText",
 CellID->404549087],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tanh", "[", 
  RowBox[{"2.5", "+", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->335508864],

Cell[BoxData[
 RowBox[{"1.00554801189506`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.012322138255828353`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->236426686]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->376823989],

Cell["\<\
Simple exact purely imaginary values are generated automatically:\
\>", "ExampleText",
 CellID->107944194],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tanh", "[", 
  RowBox[{"I", " ", 
   RowBox[{"Pi", "/", "5"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->173475644],

Cell[BoxData[
 RowBox[{"\[ImaginaryI]", " ", 
  SqrtBox[
   RowBox[{"5", "-", 
    RowBox[{"2", " ", 
     SqrtBox["5"]}]}]]}]], "Output",
 ImageSize->{88, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->112201690]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->55417354],

Cell["\<\
Convert multiple\[Hyphen]angle expressions:\
\>", "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->169634461],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigExpand", "[", 
  RowBox[{"Tanh", "[", 
   RowBox[{"4", "x"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->640204327],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"4", " ", 
    SuperscriptBox[
     RowBox[{"Cosh", "[", "x", "]"}], "3"], " ", 
    RowBox[{"Sinh", "[", "x", "]"}]}], 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Cosh", "[", "x", "]"}], "4"], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox[
      RowBox[{"Cosh", "[", "x", "]"}], "2"], " ", 
     SuperscriptBox[
      RowBox[{"Sinh", "[", "x", "]"}], "2"]}], "+", 
    SuperscriptBox[
     RowBox[{"Sinh", "[", "x", "]"}], "4"]}]], "+", 
  FractionBox[
   RowBox[{"4", " ", 
    RowBox[{"Cosh", "[", "x", "]"}], " ", 
    SuperscriptBox[
     RowBox[{"Sinh", "[", "x", "]"}], "3"]}], 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Cosh", "[", "x", "]"}], "4"], "+", 
    RowBox[{"6", " ", 
     SuperscriptBox[
      RowBox[{"Cosh", "[", "x", "]"}], "2"], " ", 
     SuperscriptBox[
      RowBox[{"Sinh", "[", "x", "]"}], "2"]}], "+", 
    SuperscriptBox[
     RowBox[{"Sinh", "[", "x", "]"}], "4"]}]]}]], "Output",
 ImageSize->{538, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5821567]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigReduce", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->21738186],

Cell[BoxData[
 RowBox[{"Tanh", "[", 
  RowBox[{"4", " ", "x"}], "]"}]], "Output",
 ImageSize->{63, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->8582653]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->551531798],

Cell["Find factors of decomposition:", "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->772545502],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigFactorList", "[", 
  RowBox[{"Tanh", "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->135832970],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Sinh", "[", "x", "]"}], ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Cosh", "[", "x", "]"}], ",", 
     RowBox[{"-", "1"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{250, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->20195275]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->79924022],

Cell["Convert sums of hyperbolic functions to products:", "ExampleText",
 CellID->98010818],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigFactor", "[", 
  RowBox[{
   RowBox[{"Tanh", "[", "x", "]"}], "+", 
   RowBox[{"Tanh", "[", "y", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22866542],

Cell[BoxData[
 RowBox[{
  RowBox[{"Sech", "[", "x", "]"}], " ", 
  RowBox[{"Sech", "[", "y", "]"}], " ", 
  RowBox[{"Sinh", "[", 
   RowBox[{"x", "+", "y"}], "]"}]}]], "Output",
 ImageSize->{177, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->585153939]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->609134749],

Cell[BoxData[
 RowBox[{
  RowBox[{"Tanh", "[", "x", "]"}], "+", 
  RowBox[{"Tanh", "[", "y", "]"}]}]], "Output",
 ImageSize->{115, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->7495777]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11713121],

Cell["Expand assuming real variables:", "ExampleText",
 CellID->714224568],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{"Tanh", "[", 
   RowBox[{"x", "+", 
    RowBox[{"I", " ", "y"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15925042],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"2", " ", "y"}], "]"}]}], 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "y"}], "]"}], "+", 
    RowBox[{"Cosh", "[", 
     RowBox[{"2", " ", "x"}], "]"}]}]], "+", 
  FractionBox[
   RowBox[{"Sinh", "[", 
    RowBox[{"2", " ", "x"}], "]"}], 
   RowBox[{
    RowBox[{"Cos", "[", 
     RowBox[{"2", " ", "y"}], "]"}], "+", 
    RowBox[{"Cosh", "[", 
     RowBox[{"2", " ", "x"}], "]"}]}]]}]], "Output",
 ImageSize->{273, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5584498]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->37363620],

Cell["Convert to exponentials:", "ExampleText",
 CellID->238310314],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TrigToExp", "[", 
  RowBox[{"Tanh", "[", "z", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->217258805],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", 
    SuperscriptBox["\[ExponentialE]", 
     RowBox[{"-", "z"}]]}], "+", 
   SuperscriptBox["\[ExponentialE]", "z"]}], 
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{"-", "z"}]], "+", 
   SuperscriptBox["\[ExponentialE]", "z"]}]]], "Output",
 ImageSize->{59, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->130524036]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->475958798],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->361093387],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Tanh", "[", "x", "]"}], "//", "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->315639521],

Cell[BoxData[
 FormBox[
  RowBox[{"tanh", "(", "x", ")"}], TraditionalForm]], "Output",
 ImageSize->{38, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->41723067]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->174118993],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Tanh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tanh"]], "InlineFormula"],
 " can deal with real\[Hyphen]valued intervals:"
}], "ExampleText",
 CellID->794350743],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tanh", "[", 
  RowBox[{"Interval", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "2"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->776467229],

Cell[BoxData[
 RowBox[{"Interval", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Tanh", "[", "1", "]"}]}], ",", 
    RowBox[{"Tanh", "[", "2", "]"}]}], "}"}], "]"}]], "Output",
 ImageSize->{205, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->35272939]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->88691558],

Cell["Infinite arguments give symbolic results:", "ExampleText",
 CellID->568152293],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tanh", "[", "Infinity", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->109817067],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->254078800]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tanh", "[", "ComplexInfinity", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->683810041],

Cell[BoxData["Indeterminate"], "Output",
 ImageSize->{95, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->201278655]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->129975646],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Tanh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tanh"]], "InlineFormula"],
 " can be applied to power series:"
}], "ExampleText",
 CellID->19272928],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tanh", "[", 
  RowBox[{"x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "+", 
   FractionBox[
    SuperscriptBox["x", "3"], "9"], "+", 
   SuperscriptBox[
    RowBox[{"O", "[", "x", "]"}], "4"]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->63388281],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   FractionBox[
    SuperscriptBox["x", "2"], "2"], "-", 
   FractionBox[
    RowBox[{"2", " ", 
     SuperscriptBox["x", "3"]}], "9"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "4"],
    SeriesData[$CellContext`x, 0, {}, 1, 4, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 
    Rational[1, 2], 
    Rational[-2, 9]}, 1, 4, 1],
  Editable->False]], "Output",
 ImageSize->{126, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->540930696]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->595213056],

Cell["Plot a tractrix pursuit curve:", "ExampleText",
 CellID->303471720],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "-", 
      RowBox[{"Tanh", "[", "t", "]"}]}], ",", 
     RowBox[{"Sech", "[", "t", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", " ", "0", ",", " ", "4"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->863250612],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmFtoXFUUhnfnzMXUeEObRLxVERG8IIIPIl6g1FKkioKUooIxiMlDjbQR
RRHtg0qhglgUA6VFaovWIinFaDGltdHY0JqCGhEVJILUB4tg8SEgxG+tdfbk
nH32ZDIjig8OM3v2Za1//euy99kza3qH+h9d3zs00Ne7fNWG3if6B/o2Lr9z
cANTyRLn3AyfdT2O/hw9/czMzfGdba+lLbGUyCgRGZl1Tua66ctUKbMmXVnr
iax5vS765QZ63ZG10F4S0dM5d4205fkV52qB7LJgnBQ0egKJajC+IGBWLiB0
BxIhh+5gXCoglP41b/4+wn/Jm66mXC4MJCoRDlJPlUV7UUk1Qm7N2ZdTzZBT
c9ZJA82izYVYL5TFxbEvZC+nUdwZXU15NI+FeeTPpVr63ZV+VzPZaHU9yazb
eVI8D88N+E0tMNtJ+1WdcSgTxi881cL1ZuNW9f+398/a08ouZP2OYHxZk/Wz
dfz9d7+emPqZtytJk0we/WnH9uO8XaLNk0Ojg4/v5+0SbVjPslQWUtW7+C6D
YFpbX5vIaFVuv3XYJX2P7E3nSroAcs4SyCmTRJvZ2T8LlrL8X9elkyd/N63x
Iz8qTrnOeKB/pIzlMl2z8N6eLzMWLomiblbUmZnfTBKVkqK+/NJhQ117/+6S
+FOmYzPPPnPALNc9mP76l+uj6M/r2Dgj7RQ7AQAY4uMM+aEH3jVkwmjWPxz9
1pBRvSUX96cUkVhlEDW+lbtW7wDNWBKT1BZhQpKsu1VRhoPSLLWq2PX2ieE3
J40aUCtXbDMotaFhPH16NtW7O4rWL81ZoFlZWRDvvWcnaFYO4GMlZbQu51mf
jDoJJc6jizBxMUUrHQvKqVN/PKx66cGqr/BOmfhnRobbg9Kcid2DYz+ABqbh
UzbwZAZw6sA9ZhgNny0ugr1Wo2j1A5jFj3bTC2MAEwyA10dww1uH+CHD+2TQ
Add9I9N1PCsQoiCx2xhBC29B4a14jaKSQwhZoo3lK1vGU9Sn20BdLc0ZpIW4
ggQelUh0Lc/PRRCLT/MwnisVE6aULz6TKIqIYBIOaG4q5N8/a/0NaoUs1TCP
m0aIPUduJL8vRiv3NtXACyKBrNU+LkhUNkc1dF/WQEQKGxAkU/Blb7otucq+
WUZVJKkFXOENLYBfjeLeVJCmw3BrVPpGleaYgEVW+o0cgxtUCmZ4R71zSMAA
qeH4TqrU8dOF8G51nUoBQMLNcfat27bICs+O9T5ZoXSgBXkSTNbd9gZVU47U
ytWKQOZw3KpEuLzVqO4yu1i8kuFV3hv8AAEc0NzOCIKvrzAeV2pFU2+UDl4Q
5d0taF/hte0pQA29U8hLuAv9vf3yvC6dPdE6uVTlKLq63N6o3MUqh/+2lZF7
P1dJF+k6lWTVSb5Gojh6+5YnJCCIktR9Ublub4/IcWiQhP1ROfs9RmCpXQLk
PsixWuZRgCCJ0BuNV3bwWz/MxPk6hjWuydP1o0ZVtODpdZ6PETGEEL4fWDSO
wJjvhII9QYDdx22xOEfHtrPkFBtrgJJE4mB3RfLGbpL9eDCiG+qE9jt1TBTs
IegOFTLifzH5X6+mgT0Yw9sdjlbCUh1z4lHG4tcnUakOH8NU6kiuXjo8BpZo
3XgUo5axJFKfRqWqgdRnOUtVH4U0CxNt1aWN2SKUvnQn2qoIG9sVTLqft4Vi
fCECHekebVAb3g9RLfkYcRpIPU22ZdlQ7PSSbgso1foML/YUO/NYIRPhLUJV
Ic1hQAKPzWd//vloKXHH59dS25webP0vcrWgv4koApnMaIiHPLIokPA/gBQ9
mOURJXeMqYx7/hX7H9R7oykvSBT/nalHnS0o3alW9dh0reqJQMt20pnF6k03
zPc3OlX8h8Yt+QtzkEl3\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{225, 89},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->756399798]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->149200831],

Cell["Plot a pseudosphere:", "ExampleText",
 CellID->233352563],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"t", "-", 
      RowBox[{"Tanh", "[", "t", "]"}]}], ",", 
     RowBox[{
      RowBox[{"Cos", "[", "p", "]"}], " ", 
      RowBox[{"Sech", "[", "t", "]"}]}], ",", 
     RowBox[{
      RowBox[{"-", 
       RowBox[{"Sech", "[", "t", "]"}]}], " ", 
      RowBox[{"Sin", "[", "p", "]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", "0", ",", 
     RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->466400879],

Cell[GraphicsData["CompressedBitmap", "\<\
eJysfQdYG1faLtcldTeb3exm9+6/+Xfvv3+/O+52bMeO7cSOHTt2EseJ7RSX
ZOi9dzC99947CBAICYQQIBC9g+hCFNF770Xfc++cmRF2JiTx3b08QujM+c6Z
c973O185MxpuPjbRUNV9bKL53eO/XDV6bKCh+Z3xXz7QNyIO7f8fKir/42/E
77/8QYX4/H9UVKjf/wMAGPFLfPzJT1LifT/R4FOy1IveURHIH5VbP3G0h3jf
t9tSxpD5+Cdafv+cPz2+YbIHVVVVuoer5NFB+tz7iIpr5JF+us99qGb3qIw+
qrKfLKJhkBLKHol3ukcp3eNBVDqwO2JCYB9jBJdJ+U6651cZvX1A1rbTvb1G
9rbblvhwhayX0K1f/5H6JuIdDeI3qHRwt54+BzWCBvocbzLGxxzvJVK6lj7j
H55Lupru+58YtfsZ5YukdAXd91uM2gOM8gVSuoyW/vNzSZc8w+uzmsQ810FG
+V2ydRHd+t8YtS8wyudJ6WAa9f9Fz/4/n6tVyDMjQ6r2z/Q5/5sh/SKjfI6U
D2XM65/ocx/6mXNTrcMYrX//I2j9758Zyzt79vZburfjDOmXGOWzu+g9s3KI
D7+l53LqudqH0NK/oc96miH1MqN8hmyVRrd6h1H7CqNM9qaS/CP4MM+1d+sE
uvVFRu2rjPLbpHQcPbL3n0s6mu77CqP2F4wyiaVKJN33NUbtLxnlk7u87jVr
5rn2bh1Mt36B0foyQ/o1RvkE2TqQHuknjNpfMcqkjqn40ef67Gf6pqR96L6/
+Jm+j5HSnj+CAvNcrzPKR8nWbnTrr55L2oUe2bM1zJa/ZpSPkC0d6fM8ei7p
J7T0t4za3zDKh0lpW1palVH7BqNM2h6Vu7S00hpqPFerewx036J70WJI/5ZR
xvZs/Ue6tS5D+neM8t/2bP2HXRbIatJA/309/Y4ehxFDmul7//eerd+gx2H2
M63/exf3Z+2gxXO10qClrRm1v2eU/4uUVqPPwVwLls/V+jv6XE8YtczYgvSf
Ko/pczkxav8no/wfpPQDum+X55L+ipZ2Z9T+kVH+d1L6Pj2S/YxZM8/FjHrI
6IG0MnvZQefnan2HPrc/o/ZPjPK/ktKf0ucKZNS+xSj/lZS+BT+Mcp+v5Uf0
qCJ+RvpfSOkP6fNEPZf0VbrvWEbtPzPK/4uUvkz3Hc+oZUaJfyGl36L7/iv9
N+m5WpFYfy9C+TN91pS95Jn97dH+T3R71l5zYs55j/Z/pMef+Xe2V8Z7zzKf
sRcbTLb26Ot39FhyGPJ/ZZT/9D0G3qBHwHuuVodpaT6j9l8ZZXINkT4BSQue
S/q/aemin5EmbQNpm9D4Sxi1zEyBtDvkUdS3+Lmk/4WWrmDU/jujTNpLUtf2
ssVlDOn/YJR/v9uabEVV/KAX5oh/vBfUqIpRy8yASN9Dxld7RVL7lNbx4O4x
oDLWSkY//8Uok16YjqWe9kcq9fd09CDzjIx+mJjtfR6USRzYww/8/PmY+S8T
XWbO99u/c17MXLj0/+N5dll6pj1zFTDzxTf+znkwzyNilP/GKJNxK6lfylE+
He3TXpnZa/Fz9fpnRi/MLPTneiEjcNp7Pe2FmSkyrQ/GKL++Zy/MnLDwuXtB
+DDzNiGjzNxL+NWeY2D2UvB39cLM1Ji2+zCj/NqevTAzuPw9uEHbZnujyczJ
mN4GWQVUZK4yEoHdjIWZQ+Uxyv9O98LUxqe9MHOAZ6VyGeW/0r0x9Wnv3pjZ
E9P7/oXujcnp3r0xcyAuo/wW3RsT1717Y+YnzHjij3RvTESe9oZ0mplLMHt5
k+6Feba9x8TsjcMov0H3xswy9u6NKZXNKL9O9/YW4zi5l0NH/E97Y+YLWXuM
ARWZMenevTHzCTaj/ArdGzM+e6Y32qKrkD/M/piRKrLNaCUyY5un/SmjRJUX
tlzwDUd83QHfcMI3XfFtD5zpH5ix6356tEx/R/X+C/hhPofGvJfPIC3KwR0P
nDi0SQzCHl+1wcmpqry05oCvO+EbLvimO77liW/74ECGLcy5KtfAfjpy/+GI
Xn0GP2owLzLGwYw5qBWq8FMlhkbgQ43owKIJvmBMvw6SR1bs0cg33HHilBnw
dD2+8KNjQb74gDJK+38aE7XnqPDBt91wMrmgxmSEz+vjc7r4jDa+b0qT+NUi
frVxlRemdHAV5c+KA77mgqfSWoGs+8tkF3ExQPfOXIvPi9xutElHumSL1yBA
Q+GNb7uiEaxZ4itm+BIxTj1UnNHEp9TxCRwfe4yPPsL3jzzCVQ4OP8ZHiNd3
SGCSGDe1P7Rki9NniaexZUZ6KGZ8bQ+sX/2R0SsjrYO0vpB2/X+Cv7rCC99x
o0e7bIIvGuDzuvgsMVRVdHDsET7yAB/6Cpffxwfu4f138f4v0Hsf8SKKXyKZ
EVV8YnfkizbKkUfRI2euKTSCV0nZWN1xmiWqLacAjLEI2MOi/dSsfhinPi2/
THHiq6bwVFWQs1y3wldM0SzntPEZdXwKx8cf4aPfoKrBu/hL5Prr+hjvvo2O
DDzAh1XxcVKdFqzxCHpGZK9Pr5IRP2S7g64nU3f1Ls5gSuXlH+VHaSlepP8y
x03Ggr9UeKspPFSp/jas8VVClwzxeR007slv8fGH+MhX+NA9GvmXZB/j0o/w
rut45zW84yrefhVv+wBv/QCnVkvnJ3gPQR7BpSqO5EPoufziGS1Ggi+QM/E4
l7k7k3iTWWrF7c/OoI0wmVAx/QQ1s39izORFakkRM3FH/W874Js2+Jo5vmyE
L5B6No3jEw/x0a/IUan8sv9TXHYL4d1FzOIK3vo+LnkPb7mEN1/Emy7ijRfw
BuJ1EadGdFBKqOEDfFyXZNYdJ3ezlLMiLddBelrkj/M7cZQ9O5hoPr97FM3q
RRWVH+wD/cR8XgFPtR1ndNItO3zdAl8h1o0+Pk9olBo+9ZiayWuDd3BiMr23
cOl1nJgMcaiNmAkxjfN4wzt43Tm89hxe8w5ecxbfV30WV0EqVH+JFCOI/BIf
0SIXpSvuTc/pVaWeoYLbhRTyIzUbi9nd2XAygeyK6Z33ng25Nv+EyhQ79viG
FdKzZUPEzpwGYoc4TrAzdBcfuI333cJ7buDd1/DOKzgxG6Kq+RzecBavexuv
PolXncQrTuHlp/CyU/g+8UlqTlXv0Ma483N8UA19XnXB3eFpdEna4xedT0V7
Xcja1cM43eEkK6XeoTlRP0g7mZHC05kpV5TKf4K3BvF5xxHfsqX5WSL5mSUH
MP4NPnIfH/wcHyD4uYlLP8Q7P8Db38dbL+LN55EAMZ2aE3jlUbzsEC4+jJce
xkVH8OIjeNERvPAIEiAmV3EWfWj9BO8nbfeyE3p3esZCvEKO3f1UMj12ysbF
G4zTKrlvj7kxoxZqbn/ci7U3wV8LvNSptsSaWjfHV4zwRYI1TdKXPMLHvsZH
7uFIDT/BZR8pWbuEt7yLN72D179N6en+8kNKb/kiqU2Fx3DRKfqQ7CFlXeyB
8p/ILpEW4gVtTHNX51yOxXidyaS4ilWXJxhNP50f0YhDmQ3UOzNueuWn5uen
RRxSOKtuk6HGmim+bIAvaKPP098imzH2FT58F5d/hvd9TGrlVbzjMsnhObzx
NF53krJ8L5UewosxvBDDBRiej+F5GM7DcC5G1b4gOIaXn0N9dn+N3ldccGua
w9257tfADOmZUm18LuTszj1OazjJdI46np0AOeRcKYZzmgHZSWbevvecSU/2
RwjWBV9y2k5q23aqG5ZoTITqLpDGgDAtE9/go/fxoc/RYiRMSw9hWijVvYCm
3XAaiVUfxysI1T1M8fuSkJx2LjnnHAzPxnA2hmfQ8z9YcuaZWImI98zhaRap
nL3O9zTY5VyU53ssv6t8enUm6I4mWyw8o9FKFOgytwlojUfyzHz7J9B4EQJ1
ERSuGjuOatu2qhsW+Kox7e3emMHxqUf4OKniQ9RK/gEchFzdKZyCg1jGJRhe
hCm9ZS4JRhaGZ2J4OoanYXgKhidjFGYHC04+gwoRyxnTqKBxkatkvyampo/p
PZ2l88kQj3OJPpezKQ+zP9FgLMVq9nuocJ9B5QVeI+yegYLn2I8is3sf0MsQ
pg8BJCgumjsO6ls2auvmqiuG+KIy/vrzJAXK/b1BISQaz5DW+gRecQyBIiJB
KSB1hKjlkgpCYMIiAUnC8AQMjyOrEpXY7e+ilgqBiz483bmgfJP+rl2gZN1O
xXifTw+4rNSWOI3+RMPRVOsZ2hNzM57iwGsAKv54BoWjz6UvByhjGaqPDnlo
K5w1d55obFmrr5uprhigwRKujNAYWndGf4BOx/tIqOU83qj0ZZXH8bIjeMlh
vOgQLlQaDlp3duEhIInH8BgMj8LwCHpF7Zc+wqmBqWjT6OzbRUcT09DDtJRr
gUDneITX6WT/8zm01iRoDSYbT6TZztP1OYnAywBeLtBo5tYDV0IC9nS/+O/C
6pcQbIDUyE17x0lr215j00p9zVRtWR8p4ryGKlpdhLF5oESMdv0EVldJr7fr
RE7jNadIrI7hJUeRixQexvMPIawITeIQiJHZ4v4YTLmeqHnKcCVG6jRGyitG
5OKgsdLTw4yMMVM633M7EuZ5PJ74FPgenzoSpypL1B1JMZ1h2S9ReHFJvHJ5
QOPHa4Fnznvw78KLHNjrEGEEQSRkrjo7jtrbdpqblhprJsj/LuqoIchUVae+
RZCNkm6JxO23hFsi/hBu6anbPYMQqzqBl5/AS4/jxcfwwqO44AiedxjnHSIR
U1HJIO0R2cMrxNqLJpUrFMODMTwAw31ImX4N9I5yLXR3IZXT6mDaBpiBKYEY
lbV7nI3yOZ/ifyk7+IMCCrEEjf5kg7FUi7l0h7WniKVDLleJWG7zs4gx96SZ
NorMhOhsjaFhv4FwI3TIS1/hqrvjoL1tq7VhofkUMU3VWVVV2pF/jQ/fw+Vk
oELhRsRjRHgpuYA3EU7tDF77Nl51CsWWRNwlOoEXHcMLjuL8I3guGbrsGqxU
0mBRvjhMCZcvhnthuDuFJ7qLhdLAO7saSc1bH1MzxnTMMWMaO/cz4d4X4v2u
pAddz6WOJGkPphhPInqcNmjtSoRcArscJXZ5TcBr212dzDulmNr2E9j9FsIQ
dgov/R1XvW0HnW0b7U0LZFdXDNWXdNXnNdVm1VSnv1OlgrxhMpYlcg1CgMg1
SAR/JyFjWRSan8ar38YrT+JlhMIdw4uPohBWQALHe8YH7hq0ONKg0ZnFLn5u
GO5M2z90NwmZvx/QwdQNME0TBJsRZc09ToZ6n431u5gWeCUn9IZQmZ+o9Sbr
DaWaTqTbzGU6r6g8i17eU/QaILeVRA/ZDOa+/Y+jh1qTqL0JocYkagYkarrb
tjqbltokahoEagtaarPqatO46uRjnM4AvkAo9BLR40c4lW6S2L1JKF09pXSE
lzyOi4/iJUeQHyDqdgNIDgkctVKTlV6SAC4Sw8MxHMX+6A4zyvp99n1dO6iF
aethukaYvilmaEloHLWj5n06xu+dlKCL2aEfCCg0kzR6U/QH08zG0+1m2S5L
tB3MTUQg8XMgX0DfTcSvhzzJLnLMO7P+H/TuDxBighD0NNxx1d920Nu209uy
QuHGqpHWkp7GgrbanIYSwQf4yJcoKyRq+z7Be27i3dfxzqt4+2Vccolag7+l
XEP5UZRAEeVCZZyx6x3YZOyVuheCpA84QOicA4bbYLgFtX6vPovpXQpWEisi
H8H1ME1DTNcEMzLHzKwxC+q418lQ39Ox/gSw77KJcvj1Iso+JOLSZK2BVMMR
lsVkhv0c23V5F928dEDo5lN3Mhzkt0BuO20UWf0UaL+h7S7zTtS9sSU9yJ8g
HGELfsYKT6MdF4NtR4NtO+RQ1s10V411lvW1FnQ05jTVZ1TVpr5VHSe3RNDm
DmHqb+P03s6HeAdhGC+j/ZCmd9EuAjnHN3czHAJevjLUz1aGtgx4EQikNwnC
cH/l8qYsnC2GW2G4GYYbUGije3qpaPcehn/1LNq6pAzxyQxTtcS0bDD9gxTa
p4N93onyfzcx6FJ6yJWc8GuUJr+QrC5L1R1MMx7PsJplOyxlu69TaOclAp9A
mwP5fPq+kfymZ/eYfvNsdEDvsz6fDyIx/zOEmSJ99jNBmLsa7jgabtsjy7ph
rr9mordsoLOoqz2vpTmjpjH1ndrEI9XdjcCBO3jvp3jPLbz7BtpPa/8AbyVh
b3wXr38HrzmN9jooLH5PZZYU7jnP4J6mtKiEUKwyRCTcUgiGB5LQ+yg9kysh
gyzqYSXeB74gW32N4Q/olfCiAaZmhKmbYOpmmIYlpmON6dsRWSl1vcDzqK/3
ySDfsxH+F+ICL6eGXMsKu5EXeYvS9BeT8K4Urb40gxGikGmzkOW0yvHcom0J
Pwn4LMjPBkEejb+gAfJbIa+TisR/DU/znmcxP/L8HPwVwsxIDkx3PI13XI13
nIx3niA7vWFhuGZqsGKot6inO6+tPauhNY1rTDxWH3+IQoSh+7j8C7z/M1z2
CS69iXfdwDuuoQ1Nyft48yW84V28jtxXqjyFAikxGX1Sc/rDsyuAynSp0ICo
210Eu2QEk2T4KcnwID2dC4Y7UTYcZb/4Y0rz0YpA14/I4y8Qxuc+uSi+wfCH
GP4tzdPL+sgIaRtjuqaYrjmmZ4np22AGdpiRA2ZG2fkXfY+H+J+MCjybEHwh
LfRyVviHuZG3hPS6SlHvSdOVpxuPZVrOZNkvZTuvU56A4CmfBYIsEORCQaEy
GyioB4EE+B0UV+jqywHl7vRPXOGmuCKvenxvL51k698h1Byx5UuwZbrjZrrj
bLrzBK2hTUvjdTOjFSODJX39BR3dWU2daTXtye+0Jh6jdGb4K/XBe2oDn6v2
3sZ7Psa7b+KdN/D2a2j7ueV9tHFbT+6rVZ/BK99Gu4OlJ3DRMbSdRqQLJCpv
UVEI8Ynyp1Rm9WNkEUbLm+SLkHclIxNHDH+C4XYYTtgwawy3xHBzDDclBP5C
4vc1ydM35HoiuXyEQhyCNBzD1YiP5Kp7xQjDTZD9Q0mQBaZphelZY8a2mJk9
Zu6AWZDjfNn3RIDf26EBZ6KCziYgU3opK/KD3OgbwthPSin9eykF70zTkrH0
5Rmmo2zrqawn8xzXFa7XJuVN8pNAQDJZQDApVMY+Bc2Q3wZ5XTSzBzIGnmbF
v6LXIDMiYvJKxuoku3vdU/rstR+y7m8Qbg6hFiTZZgovsx138x1nxP2Onfmm
tem6ucmqidGSgeGCrv6clt6Mht6UKooExh/pjHyjPfSlpvyuRv/n6rLbatKP
Vbtu4h3X8bZruOQDvJlMpevfxWvO4VXv4BVn8LK38VIibj+OFx3FhUfxAmWG
yKPXzF93+Y59hu9Q0lIGkTE8IeSrXJ+UvaSWqCMZHth/n3UzingVFWMMJxg1
JF2VPgoPiPhVF/Gug+FaGK6JyhqorE6KIz04QHzcTx7TJGW0kQwhTmbvvzQl
+7cgT2RFntEWU7PD1J9gaLfZCdN1xgxdiXV+gNKU477+p4ICT4cHn40JOZ8Y
diEt4hI78gov+rqAsgQvpalLWTp9GYaDmWYjWTYT2Q6zOW6LXG8qMzsoIDWl
IAtpgrBAqSnCJihohfxO6prFa7RuMGO+vXXjpR+s+QN7H2HYcFInj0CQpcLP
QuFtoXC3ULggxdmxt9iyMd+wMFs1NVk2NF7UM5rXMZzVNJhWR3HNxLf6o4/0
hr/RHfxSZ+CuVt8dTdltDenH6p031duvq7VeU225gmBvuITXXcBrziNlqTyD
l7+NkrySE3jxcZQZE8pC5CqUSSeEOc9s2ZGcvElFi6FkLaUs/s/YB0+lSd9V
GQfSUNiT8pTW7LNCxFuSxJqTr/2ECu1DOnSAMAfGSl3aZ0L7hNfNaQuhZYlp
W2Ha1pi2DaZti2nbYdpPMG0HTNsR03PCDFwwY1fMxB0zJdl+1f+Eb8DpwKBz
YcHvRodeSgh/PzXiSmbUtZyY6/y4W0Xxn4lpb56uJcvQl2caj2ZZTGTbTec4
zXPdl3J9nmpFAQuEWSDMhUKlVhwQNoBQAoIO4HdTbB3IlD+1IEotYd5Xw7yD
6h/TEpWzEGGxe06Ft5XCw0rhaoX05InVlq3lhqXFmpnZirHpkoHJgp7JnLbx
jCaKAyZxo/FvDUceGgx9rS+/r9d/V7f3jk7Pbe3uj7U6b2q2X9dovYYCgqbL
ag3vqdZfVK09j1fvqsopWlWQaVGmtT/c6kbR2CE85bBa8hG1xMNqCYdU4w/h
/4EcLuExVH5ljxRC9QlayJoEe8RxB8zQETN2woydMWOSRmN3zMQDM/fELKm1
+4uAEz7En5BjoaFvR4adiw2/mBhxJSXyw4zojzixt/LiPhEmfFZC2YF0je4M
3b5Mw0Gkv9YzOU/muS7LuZ5reX6b9PWEgiQQkpwW8qBQAEXFNIeF9VBIbmAJ
uqjo7EDGM6wq78NhXitn3pv3D7J6gGIVgq0hwJoc11WFmw1i1cFm285608pq
zdxi1dRi2ch80cB8XtdsVhvFe1NqphO4ydhj4+GHRoNfGw7cN+i7qy+7oye9
rdv1sU7HTZ22GwjolmtaTR9oNV7WrL+kUXtBvfq8WuVZ1fLTqgSxtM84Rl9y
2/UZKHU8hGcdVmUfUc84qpF+VDPtmFbKMa3kIxpJh9QSD6kS9KqQIXe00peE
k+HDrkcJPIQHHFLzP6Tmd0jNF1PzwdTQtPZ5I7u/azRU9qE9I8J07EPh+Ysu
mJoLpuGMaTmT+7fEuwumqbKPOKbyKxdM3RW91FwxVTdM3Q3TcMc03TFtD0zX
A9P3JK8eeWIWXpiVN2ZN7W7+MviET8gp/9DTwWFnw8LPRkWejY86j64Uxlxm
x13jxt/kJ3xakPi5iLIJr2Sod2Zqy9gGA1kmI9kWEzk2s1yHJaIiz2uT779D
aZEwCQpZUMiGQi4U5UNREa0zRU1Q2AoFnZAvpfUqaw8teouhNcyrVv+gFr0A
kZboUIgNBNqCry142ZKju7Ztb7tpY7Nuab1qZr1iYrVkaLWgbzmni4SnNSwm
1czHcfORx6ZDD0zkXxv33zfqvWvUc8ew+7ZB1yfIybTd1G+9oddyXa/5mm7j
FZ3693VqL2lXv6tVeU6z/KxG2RmN0rfVRSfVio8jiikLwT+smndYjXdEg3tU
k3NMK+u4NvuEbsZJvfQTuqxj2mmHNVMPqScfQiYH6RIZhO7GJZGH8IhDauGH
1MMOa4Ye1go5oh1MvDDNIPKqRwCmEYCp+2OqhAvaR4Sp+wg/pPKKD9IwDW9M
yxvT8cb0vDB9LwwNnXgnPhNap0f86qq85IPp+WAGvpiRL2bsh5n4Y2b+mHkA
HXe+HnLcM/SEb9ipgPDTIRFnwyPPRUW9Gxd9MTHmUkrs+xlxH2QlfMhN/IhP
iCbfKUm9W06i+2qGWjtbS5ql15dtPMQxH8uxnubZz+c6L+e5r/O9N/MDtmkL
VEjqThEbinKgmA/FhbTuFDdAkQQKO6Cgmz7CHnyqO+jq9IE97gT8x3Rn936Y
l5U6YwtBduBnB9524GGPLI+TPTXuc2sWdqtmtsvGtouGyCTN6lhPa1lPaVhN
qFmNfWc5/Nhi8IH5wNdm/fdNe++a9Hxu0n0H7cF0fGLcfsuo9aaR5IZR84eG
jVcN6q/o176nV31Rt/Jd3YrzOmXvaIvPaJe8jcK6ohMahcc1C45pCo5p8Y9r
553Q4Z3U457S55wyyHrbkP22YeYJvYyjOumHkVlIO6RBao9a0iE88RCecEgt
/pB63GHN2MNaMUd0oo/oRh3V3xdx1EDljfBD6OJhGKYThmmHYlqhmGYIphFy
SD34kEbwIc1gTCsY0wnC9IIw/SDMMBAzDsRMSQ0zU9mHPr4QiJkEYaZBmFkQ
ZhGMWQVj1qRd+XX4EU/iT8QJ/4gzgZHnQqLejYi+EB1zKT72/aS4K2nxH2Qm
XMtOvM5LupWf8mlh6p2StHvllI15la3ZlaXbk23QyzGR51iOcG0nch1m8lwW
+B4r+T4bAqWuvFiUhJgqZkNxDojyQCQEUQmdtxwUNUBxMxS1Q2EXFPQo89Qc
OWQO7V77VN7x+W8MLWHe4//9fEZ57z3zji/SuvwCokhNCbWD4Cfg/wR8noDn
E6Qpzk92HBy27R02bR3IdXRxTs9uRsduWst2UsN2XM1m9Dvr4UdWgw8sB762
7PvKove+Rc9dlAR1fWbecdus/ROz1o/NJDdNm2+YNF4zrv/AuPayUc17hlUX
DSsuGJSfRxfGS9/REZ3RLz6tV/S2XuEpPeFJfcEpA/7bhnmnjXhnTLhnTTln
TDinDLOP62cdQfIZh7XSD2uyjmimHdVKPaqdcoR46SQf0U06qp9w1CD+qFHc
MePYYyYxxOsw2qqKxgyiMf0oTDfqsG7kEf19kYcNVF6NPGQYecg44pBJxCHT
iENmEZh5BGYZTjgXtLlngz6QGe0bUcc9ok56R5/yjT7tH3MmKPbt0NgzEURF
3IXYuMvx8VeTEj5MS7yemfRRdvItXson/NTbwrTPRax7ZZRO/CJLs4P4w9Hv
yzGWc82HeFajuXbjeY5TfNe5fM9Fge9KQSB1LeTF4iQoZgGhFaIcxHSJEEpE
yuhU1ASiVijqhEIpvcvE2bUiiNOXaY1gfjuGebcIpRG/Z2gAaSteh2gUaUKY
PYQ4QIAD+DqAlyPSABfHHSenHQfnLXunDRunNSvHFXPHZVNHUhv+NqFhP6Zq
N4LbDX9rO/jIduCBTd/XNr1fIhyld627PrfqvGPVftuq7RNLyceWzR9ZNF43
r79mVveBWc0Vk+r3jareQ669/IKx+F2T0vMmJedMRO+YFJ01LjxjLDxrKnjH
jH/OPO+cRe475rzTJtyTRjlH0QXq7GN6WScMMk8SlsMw44ThvvTjRiq/ZR0z
TjtmnHrMNOW4WfJx86QTlonHLBIPo1AqATNOOGwSf8ws/qhZ3FHzuCMWcUcs
4w5bxR22jjtsE3fYluT6zbjjHnEnvOJO+sS/7Rd/OiD+bFD8OyEJ58MS3o1I
uBiVeCE26VJC0vvJyVfQTYop19kptzipn/LS7vBZnwvT74oy7otJzn/J0Wjn
6HTl6Pdwjfp5poMoyrCd5D+ZzneeFbjPC7yWCvxWhEEb9G4HwbuIBSI2lORA
SR6UFEBpMZSKqUjjYEkjlEhA1A7FXVC4aw94g5D91B4o2WfGrXs+r2Jv9n+n
ZP8JhDpCoBP4OYG3E2Lf1XnH2WXHyWXbwXXTzmXdxmXV0mXF3JmoWjB2njNw
mtVzmtZxpGKyfx14+KTvG+Rger60l96z67pr1/m5Xfsd27bbtpJPbJpvWTd+
ZN1ww6L+Q4vaaxY1V1FYXHnZsuJ9y7L3LMWXLEsvWpZcsBS9a1l83rLwvKXw
XWvBBZv881b8s+b8U6Z5J5Hr4Z42yzljzjltvi/7bQuVX2adsmCfsmSftMw8
aZVxgnhZp5+wYZ20TTtuk3YETSn1uE3KcVvyTlKVPyadcE864ZF00jPplDdR
Tjrjn3w2MPlcSPL5sJQLkSkXo1Pei019Pz71SmLqB8lpV9PSPkxn3WCzbnLS
P+amf5qHjM8XhZn3ReyvxVkPKkn+XsvRbOPqdPL0pTyjvlxTeZ7FcJ71GN9u
SuA4J3BBN0kKfVYKA9aLQqj9q5dESVCSBiVsKM2B0jwoLQBxMYhLqauqB0ra
QNQJxVIo7KWvTXGHIHt4l+uXaK6Z16SYK/8nuP4niEHLE8IdINQJgpzBH7Gp
8HTZcXfZcXXbcXHbcXLfeuK+Yee2Zu22aulG1C6aus4bu84ZuMzouUzpukzq
uI5ruYxpuIyouQzhzipkVv9PkttPWj61b/rYvvGWXcNNu7obdsTRmg/tqq7a
VX5gV/GBXfkVu7LLduL37UresxNdsiu+ZFd4yb7wgq3wvHXBORR+5J+z5Z+z
zTtnl/uOHe8dO5V93LP2v0B9/3PG227pb7unn/ZMP+3FOuPNOuPDOuvLeseP
dS4g7Vxg2vmgtHdD0i6GEaKs96JYl2NYV+LTryamX0vJuJ6WcSMj4yN25q3s
zE+47Nt57DuCrLuFWfeLs78qzf6mjLRjv+TpdOTqd+cZ9fJNB/gWQ/nWowK7
CYHDTIHzvNBtudBrpdB3rShwnd6ZKk2GUhaUZoKYA+JcEAtAXATiEigrV+4/
ipugVAKlHSDqpq+Xc4ch6ymPym9ZnPj7efw3mscIRwhzhmBXCHBFPHq57Xi4
7bh77Lh67Lh4bjt6bj7xXLf1WLX2IGqXzD0WTN3njd1nDd1n9N2n9DwmdT3G
tT3GNN1H1N2HVBHXA9+69T1y7X3o2vONq/Rrl64vXTrvu3TcdVZ5C4099103
lX/jnXfnopdHDnp5ct714ryLsnnOBb/sC/7ZFwOyLwZmXQzOuhTCvhTKfi+M
/X44+/0I9uUo9pVo9tVY9rV49oeJhDz7oxT2TVbWxxlZn2Rlf8rJ/oyXfSeP
84WAc68w58vinG9KuQ/LeY+rKNR/lafbztfv4htK8016880HBFbDBbZjwieT
QqfZQteFIo/lIu+1Yr9NUdCWKJSOtV4WJ4OYBWWZUMaBMh6U5UOZEMpEUF5G
+9aDZS0gboPSLhBJobhXuUvIHX7Wvx6kV90ZBjvMb9M+ZWs30lKFWJKlSCcI
d4EQNwhEGCt8PBReHgoPT4W7l8LVe8fZZ8vRe8Pee80W2aVlS69Fc68FU685
Y69ZI+8ZQ+8pA+9JPe9xHe9Rbe8RTS9CRq7qOYB79n3r2fvIQ/bQQ/qNR/fX
7p1feXR86dH+pWfbPc/Wux4tX3g030G0N9z2qP/Uve4T99qP3WtuuVfddK/8
yL3ihnv5dfey6+7iDz3EH3qWfuhVcg31XHzVq+gDr8IPvAuveAuv+BRc8RFc
8RVc9s2/7Mu/7Jf3vl/eZf/cywG5lwNzrwTlXgkhmvCuhvOuRvKuRfGuxXA/
jOV+GMe9Hp9zPSHnRmLOR8k5N1NzPk7L+SQ959PMnNvoInLO5zncL3K59/i8
+wW8rwp5X4tyH5TmPirP+47m+vV83XaBQafASEoUCsz7CyzlQptBof1IoeNY
kctkkftssdeCyHdZFLBWErxVGrZNsvZKWTKUsaCcvCO4nAflfKgQQkUxVIih
opKypy+UN0NZK5R1QGk3lMiguJ+2s3nDwB0hSVfeD4GIPc9gmPlt659Ynycg
1oZk3hkiXCHUHYIQFQpfT4W3l8LLW+Hho3D3Vbj6bTv7bTr4rtv7ErUr1r7L
lr6L5r7zZr5zpn6zJn7TRv5Thv6TBv7jen6jOn6EzJCGr1zdd0DVpx/36f3W
R/bYR/rIp/uhT9cD385vfDu+8Wv/2q/tS1/JfdRh8xe+jZ/7Ntzxrb/jW/eZ
b+1t35pPfas+8d1X+bGvyqsVt/zKb/mX3woouxVICJfeDCy5GVTyUZDoo+Di
G8FFN4JV9hXeCFF5S3g9tAC9wgQ3wgU3IvJvROZ/FJV/MwaZ7Fvx+R8n8j9O
5n+Swv80jX87nX87g/9ZJv9OFv8LDv9uDv8ej38/j/9lPv8rASHPf1DEf1TC
fyzO/66c2gn8dYFem9CgU2jcLTTtEZr3FVoOFFkPFdmhy63FzhPFrpMij2mR
91yJ32Jp4HJpyLo4nL76+kp5CpSzoCITKrKhggsVfMRfZTFUiqGygoqUX6iQ
QHk7lHWBuAdKekE0oLznY5fvfc/wfYnBL/N+8p/g+x2II/mOcoEIdwjzhGCU
SCr8vRW+PgpvX4WXn8LDX+EesOMasOUUsOHgT9Su2vqvWPsvWQUsWgbMmwfO
mQXOmgZNmwRNGQdPGAaN6wcRMiPagUNagYMaAQPqAf2qAb14gAwP7PkuUPpt
YPfjoK7HQZ2PgjseBrd9E0wIS74Kav4yqOl+UOO9oIa7QfVfBNV9HlT7eVDN
58HVd4Kr7oRU3gmtvBNW+Vk4OfPyzyJV/lx2O0p8O6r0dlTJp9Ei9Iop/jS2
+NO4otvEK77wdkLh7UThZ8nCO+gbE8LPWcIvMoR32cK7WQX3OAX3uQVf5hZ8
zRd+IxA+EAofFQkfi4Tflgq/EwtVy4VqldR6fqNQT1Jk0FZk1FFk0l1k1lNk
0VtsNVBsM1hsNyx6MiZymixxmSpxn0FK6Lsg9l8UBy2Xha6VRdA7vK9UpEAl
CyozoTIbKrlQmQeVAqgqgqoSqCqnma5sgYo2qOiEMimIZVDaT+dK/BHgje4y
rfwGIvNpV3sz/SaDadKmX4F4W3Qo2hUiPSDcC0KQ1VYE+Cr8/RS+/grvAIVX
oMIjSOEevO0StOmEWFyzD1q1C1q2CV6yDl60Cpm3DJmzCJ01D502DZsyCZsw
CiVkRvVDR3RDhnRCBrVCBjRD+jVC+9RDe9VDZWphPaphUjy8Gw/v+i6i81uU
gbY9imh9GNHyIKL5m/Cmr8Mbv4po+Cqi/suIui8j6+5H1t6PqrkfXX0/pvp+
LCFcdT++8n5C5f3EinuJ5feSyu4lie8li++llN5LLb2XprKv5D5L5dei++mi
LzNEX7KLv0LfIyn+Oqf4G17xg7zih/ziR4Lix8Lib4uKvxMVq5YWq5UVq1cU
a1ZRK/gNkWGbyLhDZNpVYt5TYtlbYt1fYjtYaj9c6jBa6jRR6jIldpsRe86X
eS+U+S2VBy4TbSrC1isiaXZfrUyBKhZUZUJVNlRxoSoPqgVQXQjVIqgug+pK
2iu/UNUKle1Q0QXlPVDWC6XKtSwcgXyKZIpxIO91Qbe97D458hlmmfsmP8H0
BxBvRzLtBlGeEOENoSjMUQT5KwICFP6BCt8ghU+wwitE4Rm64xa65YJYXHcM
XXsSumoftmwXtmQTvmgdPm8VMWcZMWsROW0eOWUaSciMG0WMGkSM6EcM6UUM
6kbKdSIHtKP6taL6tKJ6NaNlGtE96jFS9ZhuNUReBx7b/l1s27exrY9jW4jX
o9jmR3FND+MaH8Y3PIyvf5BQ9yCx7kFS7QO0/V3zILXmQVr1A1b1g/SqBxmV
DzIrH7IrHmZVPMwuf8Qpf5Szr+wRV+VV8WOe+HGe+Fu03yn+rqAULyxVLS5V
KylVF5dqlpdqVVLM/k5sJBEbt4lNO8RmnUjUqkds01dmJy97MlzmOFrmPF7u
OlnuPlPuOVfuvVDhu1wRsFoZtFYZul4ZsVkVRdvpX1SnQjULqjOhJhtquFCT
BzUCqCmEGhHUiKGmAmqqKSZfrG6Bqjao6kTLtUIG5f0gliuzXsTy6C7LiMCb
P8PsCz/O7ElIIJmNcUfMRvpAOPKtiuBARVCQIiBY4R+i8A1V+IQpvMIVHuHb
bshebjpHrDtFrDlGrjyJWraPWrKLXrCNnreJnrOOmbWMmbZAZE2Yxowbx4wa
x4wYxQ4bxg4ZxA3qx8n14gd04/t14/t0Enq1E3q0E6VaKP7t0kzq1EjqUE9q
V0tuU0tuVU2WqKa0qKY046kq+5qItz80fpfW8B2r4bv0+u/QFwrr8Kw6PLsW
59Tg3BpVXo1qbo0av1otv1pdUKVeUKUurNQgXoUVGsUVmiIEoXZZhXZ5hW4l
dadVuXFzuYmk3LSt3Ly93KKz3LK73Kqn3EZWbtuHhB3lFc5DFa6jFe4TlZ7T
ld6zlb4LVf7LVYGrVcEb1WGb1ZFb1dF0ZP2LmlTEUS0barOhlgu1eVArgNpC
qBVBrRhqy6G2irK/L9a0QnU7VHdBVQ9U9KJWZYO7nI5C/hjwxqgyou5TBofM
p/085XT3W+FHIBFtOkCsO0R7QZQvRAagYmgwBIdAUCgEhIF/OPhGKHwiFV6R
O55RRO2WW/SGa8y6c8yaU+yKY+yyQ9ySfdyCXfy8bfycTfysNbo3ZcoiYcI8
Ydwsccw0cdQ0acQkadg4edAoWW6YMmCY0m+Q2qef2qufJtNLI4SluqxunfQu
nfRO7fR9HdoZKn9o18ps08ps1WJLNNktmuxmzaxmzewmTU6TJpeQb9TMbdDM
a9DKr9cS1GsV1GkX1ukU1ekU1+qW1OqV1uqV1eqX16BXJbkS/1Bt2lxtJqky
b6uyaK+y6qyy7q6ykVbZyqrs+6qeDFQ5yKuchqpchpGx9xir9pqo9pmq9p+t
DlyoCV6qCV2tCd+ojdyqjaEi5V/WpUFdOtSxoS4bEVKfB3X5UCeEumKoK4G6
MqirhLoamqWXalugtg1qOqFaClUyqOyDigEoH6KvhhWNgWAccseAZvDOczO4
x6qkmIzzgBiSyahAiAgmyQyF4HAIioCACPCPBN8o8IlWeKMVt+0Rt+Uet+EW
v+4av+acsOKUuOyYuOSQuPAkad4+ac4OWcVpm5Qp69RJq9QJy9Rxi7Qx87QR
c9awGWvINH3QJF1ukjFgnNFvlNlnhBaZzJDdY5AlNciWGnK6DXK6DHI6Dbgd
+tx2fa7KvjY9nsprrXq5Er08iR6/RQ/FtM36wmb9oib94iYDUaNBSaOhuNGw
rMGoosGY4u6PdeaNaPFaSuqs2mqt22ttOmttu2rtpLX2stonfbWO/TVO8hrn
oRqX4Rq30RqPsVqviVqfyVo/9DXA2qC52pCFurDluojVuqiN+tgtat+pPg3q
M6CBDQ0caOBCQy408KFBiEhoKIGGMmiogIZqaKijLWtdK9S1Q20X1PRAdS9U
9UOFXOkvi8ahYJzKfQia7jH4Yn5f9Cf4uwiJT9CheA+I9YZoP4gOhCiUIUJ4
OIRGQEgkBEVBYDT4x4BfLPjGE1U73gnbXombHkkb7knrbsmrrskrLinLzilL
jqkLDqnzT9DimrVnzdinT9tlTNlmTNhkjltnjlmxRy3ZI5ZZwxZZQ+bZg+bZ
cjPOgBmHEO4z5faa8mSmuTLTvB5TvtQ0X2oq6DYRdJkIOk0KOowL2o2F7caF
bcZFbSbISLaaiiWmZRLT8hbTCpKvPzVZNjZZNTVatzRaSxpt2hpt2xGq9l0N
T6QNDrIGp94G5/56F3m961C923C9x2i953i910S9z1S933R9wGx90Fx98EJD
6CJqFbXSELPeEEft/r3WyILGDGhkQyMHGrnQmAuNfGgsgMZCaBRBoxiR0FgF
jbW07axvg/oOqOuGWhnU9EHVAFTu2s6SMSgeB+EERQ469iWDKeaT4n5y5SWR
zCV4QpwPxPhBTBDEoP00iIiA8CgIjYaQGAiKhcBYCIgHf+S+FL7JOz4p294p
m16pGx6p6+5pq25pK66sZRfWonP6glP6vGMGIs8xa8Yha9ohe+oJZ9KeM2HH
GbfNGbXJGbHhDlvzhqx5g1bEK5eQHLDM77fM77MU9FkW9FoKZZaFMsuiHsti
qaVIZV+3ZYnKgS6L0k4LcYdlWYclxdVbrTb1rTaNEtsmiW2LxE7SYt/aYt/e
/KSj2aGz2bG72Una7CxDa9RN3uw+2OQx3OQ12uQ93uQz0eQ71eg30xgw2xg4
3xS80BS61BS+3BS50hS91hRL7/T9qpkFzRnQnAXNHGjmQnMuNOdDUwE0FUJT
MTSVQlMZNFVCUw001SutZWMrNHRAQxfUS6GuF2r7oVoOVbS13C8eezY2JXmI
7l5BVd8w2GI+M/Cn2XNAhxI9Id4H4vwhNhhiSfaioiAiGsJjIDQWQuIgOB6C
EiEQ2URFQKrCP23Hj7Xlw9r0Tt/wylj3zFj1yFhxz1x2zVxyZS+6ZBNi8y45
c87cWWfejBNv2jF30jF3wiFv/Ene2BP+qH3+iF3+sJ1gyK6AkBy0K5TbFg3Y
FvfbivptS/psS3ttxb22ZTK7cupq2l867Rs67Rs7njR1PGlpd5C0O7S2Oba3
OXW0OXW2One1ukglLj0SV5nEvU/i0S/xlBNtJD4jEt8xif+kJGC6JWi2JXi+
JWSxJXSpJXylJXK1JXpdErshid+UJG5Lkqn7OH4lyYSWLGjhQAsXWvKgJR9a
CqClEFqKoaUUWsqguQJaqqG5DpoblJw1kV9QaOyGBhnU90HdANQMQvUwKKMS
lYOCCXpHMK5nFf15+Fxs/Y7BFnn0MCQ7QLIrudx8IT4A4kIgLpyMRqMhKhYi
4yA8HsISIDQRQpIhGF1vgiCWIjBdEZCx45+55Zu56cPe8M5a88pa9cxe8che
9uAsuaOoYsE9d94tb86NP+uWP+MqmHYRTDkXTDoXTDgJx52EY46Fo45FI47F
hOSwY8mQY+mgg5i+dtPrWNvrWCdzrO9xbOhxapQ6NRFHu50l3c6tXS5tXS4d
na6dnW5dHW7SDveeDndZu0dvu2d/m9dAm7e8zWewzW+4zX+UaNIWNNkWPN0W
OtsWNt8avtgaudIatdYas94at9GasNmauN2q5KmVDa1k9NHKhdY8aM2H1gJo
LQSJCCSlICkDSQVIqkFSC5J62lO93NwBTV3QJCXdXD/Uy6FuEGqGd32XygvF
kyCcpKlK6ltX+eGzlJl3WzxlSnmFReU/IYWkJ9EXEgIhPgTiI8gAMxZi4iAq
HiITIDwRwpMhLBVCWagqJAOC2YqgLEVg1nZA9pY/Z9OPs+Gbs+aTs+rNXfHO
XfZCl48WvfIXPAULngXznsI5j8JZj6IZ96Ipt+JJN9Gkq2jCtYTk4j+GXKsH
XWsGXWvlrnUDrvUDrg39ro19rk19bi29bpJe91aZe5vMA11Z7vHoknp2S716
ur1k3d69Xd59XT4Dnb7yTt/BTr/hTv+RjsDRjqCxjuCJjtDJjjAUUHREzndE
LXbELLfHrrXHb7QnbLYnbbWn7FAIv97OhvZsaM+Bdh605yEg2wqgrRDaiqGt
BNrKoLUCWqugtQZa66G1kbJqL0vaoaUTmruhuQeaeqGxHxrIe6TqRiioVV4U
T4JoEgqngE8upNSBDdRQ9We4ObjnKnqREk1BW+mQ5AeJgZAYCgmRZOgRB7EJ
EJMIUUkQmQyRqRDBgnDkhyCMDaHZEMpRhOQogrnbgdytQN5mAG/DP3fdL2/N
L3/VF0Vzy77CJZ/CRZ8i8v7Y/57wrJjwrBz3rCIKox61Ix51I571w54NQ56N
Q55Ng57Ncs+WAU/JgGdrv1dbv3dHv09Xn093ny/aue717ZX59cn8+3v85T0B
g9KAIWngSHfQaHfwWHfIeHfoZHf4VFfEdFfkbFfUXFcMegZAV/xKV8JqZ9JG
Z/JWZyoVrf+6Mws6OdCZA5086MyDjnzoEECHEDqKEJTtYmgvh/ZKaK+Gtjpo
a4C2JqVda+0ASRe0SKFFBs190DQAjXJoGKK+E3SwchLKJqFkCoqnQDBJQcx8
Kjjzybs/wcjvlYz4Q1IQJIVBIslIQgLEJ0JsEsSkQHQqRLMgKgMiMyEyiwwv
ciCcC2E8CM3dCcnbDuZT12oPL/qXLviJ5/3K5vzKZ30rZnwrZ3yrpn2rp3xq
Jn1qJ3zqCKFxn4Yxn8ZRn+ZRn5YRX8mwb+uQb9uQb/ugb4fcr1Pu1yX3lw4E
yAYCewcC+wn5/uDBvuChvpDh3pBRWeiYLGxcFjbZEz7VEzHdEzXTEz3XEzMv
jVuQxi9JE5alScjOS1M3pGn0PsZvurOgmwPdXOjiQVcedOVDVwF0CaGzCDpF
0FkKnWWIkI4q6KiFjnroaISOZvq6Q1sHtHZDaw9IeqGlH5rl5PU/0vhWTULF
FGoomgbhFB0nxEuXKHj/TkaQVfsD6unkdmjBVqhwM6RwI6R4PRhFvKvBpStB
4uWgsuWg8qXAisXAyoXAqvmA6rmAmtmAupmA+umAhumAxqkA5AMmAlrGAyTj
Aa1jAW2jAe2jAR0jgZ3DgV3Dgd1DQT1DwbLB4L7BkH55qFweNkTIy8NHByLG
ByIn+iOn+qKm+6Jn+mJm+2Lne+MWeuMXexOXe5NWepNXZanrsrQNGUuJbU82
9ORADxekuSDlgzQfpAXQXQjdRdAtgu4S6BJDVzl0VUJXDXTVIbg6m+hvGLZ3
Qns3tPVAay9IBmiL81LDKNSTWU3NFFROQfk0lE5D0TR5PVaHgSHz2UU/oeXX
IdUdHUrxh5RgSAmHlGhUTE6EpBRITIUEFsRnQBwb4rIglgOxXNKx50E0H6Ly
IapAESnciSBeRdvhxVvhos3wko0wMSGzFlq+FlqxGlq5ElK1HFK9FFKzGFK7
EFw3H9IwH9I4F9I0G9I8E9IyHSIhhKdC2iZD2idCOsdDusZDusdCpKMhPaOh
spHQ3pGw/uHwgeEI+VDE0FDkyFDU2GA0ekzYYOy0PHZGHjc3EL8wkLA4kLg0
kLzSn7Lan7rWn7bRn77Zn7HVn7lDPa+gj4OA6+WBLBdkfJAJQFYAskLoKYIe
EUhLQSoGaTlIK6G7Grprobseuhuhu0V5H1tXJ3R2QYcU2mXQ1kczsr95BJrG
oGFceZW8ahoqpqFsBgjFp7Q+Y3CL1no9BiNvPT9DV2mGUgMgNRhSwyE1GlLi
SZJSIYkFiemQmAkJWZDAgXguxPNQVRwfYgUQUwAxhRBdpIgu3okSbUeVbEWJ
tyLLNiPLNyIqEEkRVavh1SvhNcvhtUvhdUth9YthjQvhTQvhLfMRkvmItrmI
9tmIjpkItFs6HdE9FSGdjOiZiJBNRPSOR/SNRfaPRclHowZHo4dHYkZGYsdG
4iaG4yeH45FnHkqcH0paGExeGkxZGUxdlaetyVkb8oxNeeaWnE3vu70xwIX+
XOgnPXOfAPoKoK8QeouhVwS9pSArA1k59FRCTxX01EBPHfQ0gLQZpBIl5t1d
5NLpgY5eygsckAxDyyg0j0HTBO3Na6ahchrKZ6B0Bi0Y4lD2yE6SDO3bqxgy
eGA+T/IpL2idkbHVZUgj+UgLgLQQSIuAtBhIJflITYWUdEjOhOQsSOJAEhcS
eZCQR/pxAcQLIa4Q4oogVqSILVHEindiy7ZjyrdiKrZiKjejqwmx9ejatai6
1aj6laiG5cjGpcimpcjmpSjJYlTbYnT7QnTnfHTXfHT3XDRyxzPRvdMxfVMx
/VMxA5Mx8omYwYnYoYm4kfH40fH48bGEibHEqdGk6dHk2ZEUdOfOSOrScNrK
MGttOH19KGNziL01lEV55N8O8kCeC3I+yPNhQAADQhgoRDj1i6C/FPrKoK8c
+iqhtxp6a0BWB7IGkDWBrAVkrbSmS7uhWwrdMnptHGwfgrYRaB2FlnFonlCu
o7ppqJ6Byhkom0WLhM78WQOr9CoxZqDPfKYcxcZB+PHnairryG81XoI0N2Ch
axzACgFWBLBiIC2B5C4NUjMglQ0p2ZCSA8k8SM6DpHxUlSiExEJIKIIEEcSX
QIJYkVCuiK/Yia/cjq/ejqvZiqslxDZi69djG9ZiG1djmlZimpdjWpZjWpdj
25diO5fiuhbjpIvxPQvxvfPxaCt6Ln5gNl4+Ez84nTA0nTA8lTg6lTg2mTQx
mTw5kTI1kTIznjo7njY/xlocS0daOZq5Npq5MZq1OZJNr5PfDefCcB4M5cOQ
AAYLYFAIg0UgLwa5COSlaPYDFTBQCQPV0F8D/XXQ1wB9jdDXDL0S6G1TIt3T
/b1s/YWuQegk77xrG4PWcZBM0vfpNcxA7QxUz0LFLFo0dOusoQ0abNPn4umH
93P/6DMz6TLJ2jlgoRs3ID0E0iMgPQbSScpYLEjLAFYWpHEgjQupuZDKhxQB
pAhJU1gMSSJIKoEkMSSVQ1KlIqlKkVSzk1i7nVi3nVhPyGwmNG0kNK/Ht6zF
S1bjW1fj21YSOlYSulYSupcTe5YSZUtJfYtJ/YvJKFGfTx6eSx6ZTR6dTR6b
SRmfSZ2cTpuaTpueYs1Opc9NZixMZixOZi5PsFcnstbGszeob96P5sIoH0by
YUQAIwUwXAjDRTBcDEMiGCqBQTEMlsNgBcirEBjyWhioh4FGGGiG/hbob4W+
9qcZ+kvSfpDKoXsQuoahcwQ6yA3pNpqhV5pmoJ4gaRaqZqF8FkpmUG3u2Dar
HykQ83+yMPk58I/w8w6w0K0AkBECGRGQEQMZJD/pLEjPhPRsSOdCOg9YecDK
h7QCSCskTaMIUkogRQwp5ZBSCSlVkFIDqXWKlPqdlIbt5Kbt5GZEUZJkI6l1
PaltLal9LalzLbl7NVm6miJbSelbSelfTpUvpw4upQ0vpqG7KRZY4/Osibn0
qbn06dmMmdnMuVn2/Ax7cSZraTp7ZZqzOsVZn8rZmORuUfr7h4k8xThfMZ6v
GBPAmBDGCmG0CEZFMFICI6UwLIbhMhguh6FKGKqGoVoYJMOywSaQN4NcAgNt
MNChvCqg8uvePpANQI8cpEPQPQxdI9A5Bh3j0D4JbaSTaZ6Fxlmon4WaOaia
A/Gsch1xhtfpdWTF4IX5dNB/iKfTwCL9VEYwZEZAZgxkJkBGCnkkEzI4kMmF
zDzIyIeMAkgXAquIXGWlkCaGtDJIq4C0KkirgbQ6YDUAq0nBat5Ja9lOQ/Ha
VmrbZmr7RmrHemrXeqp0Pa1nLa13jdW/Rpjy9MGV9KGV9JHljLGlDBSpLWZO
LbCnF7Jm57Pm57MX5jlLcznLc9yVWe7aLG99JpfaS/79VL5iUqAgPk0IFROF
MFEM4yIYL4GxUhgTw2g5jFbASCWMVMFIDQzXwnA9DDfCUDMMkd+JG2yHwQ7a
+7za3wt9fdA7AL2DIBuCnhGQjkL3GHSOQ8cktCs9zyvNc/TWSs08VMxB6Sy5
ikY3MvpRtmLLYIP5zbofY0fpg5jfTSBZOQksci8mMwjYEcCOAXYCsElWMtmQ
yQE2D9h8YAsgUwiZRZAhIgkTQ3oZpFdAehWk10B6HWQ0QEYTZDRDhkSR0bqT
gbb0t9M7t9K7NtO7N9J7NtJlGxl9GxkD65mD65lDa+yRNfboatb4StbEStYU
IbyUPbvEmVvMWVjkLi7wlhd4K/O5a/N565S/+f2sYGemYGdGqJguVEwXIVqm
RDBZApNimCiDiXIYr4DxShirgrEaGK2F0ToYbYCRJhhphhEJDLfBsJKNX8hl
MNALA/3QPwB9g9A7DLIR6BkF6Th0T0DXJHTS8fJByRw0zUHDPNTOQ/U89Y86
7P8BFn7qWcDk072OQjrpawgqsmIgKwGySCrYbMjiQFYuZPEhuwCyCiGrGNgl
wBaTRFVAZiVkVkNmHbAbgN0I7GZgS4DdBlkdCjaKlbfZ3VuZ0i22bIvdt5nV
v5kl3yS8Z/bwRvboOmd8nTOxljO5mjO9ykX3CK3w5pd5i0u5S0t5K4v8Nfpb
EvMFW/PC7bnCnbminX2zxQqV12dKFDOliIrpMpgqh6kKmKyCyWqYqIGJWhiv
g/F6GGuEsSYYa4HRVjIjpyzfYB/I+0Euh4FB6B+GvlHoHQPZOEgnoHsSuqah
k/QfrXPQMg9N8yQDC1A1D+XkAskbXWMPoMs/Dgzsmc/KprhQ6v+zTzNGf8mn
lx6GdHTjIGSFQ3YsZCdCNrkfnJ0F2TmQnQucfOAIgVMEHBFkl0J2GSlcCVnV
kFULWfWQ3QjZzZAtgew2yO4ATidwuhUcFBBvZ/duc/q3OQPbOYNbOcNbOSNb
3LFN7vgmb3KDN7WeO7OeO7uWN7+ah3amVvKXVwSrlB14c0m4uVS4uVi0tVC8
vSDani/ZmS9RzJUq5sSK2TKYrYCZSoTDdDVM18BULUzVw2QDTDTCRBOMN8O4
hMo9Xh/rpu3JSC8M96PPQ4MgHwL5MAyMQv8Y9E2AbBJ6pkA6DV0z9F5K6zwJ
+wI0LCDYK+fpmJo3rIyLmf+bjPl/zyjc32BoOIn33yCd9AJZYcCJAU4icEi8
OVnAyYGcPMgRQE4hcIuBWwo5YuCUk7XVwKkFTj1wGiGnGXIkkNMGOe3A7QRu
N3B7gNtLiCm4Azs8+Q5vaCd3eDt3dJsIP/ImtvKmtvjTm/zZzfy5jfyFdcHi
uoB6ltLvVoo2Voo2l4s3l0VbSyXbi6Xbi+KdhTLFQrlivgLmK2GuCuaqYbYG
ATdTDzMNMN0IU00w1QKTEtqa/HqiC8alNMxjfTDaDyNyGB6EITKQlY+CfBwG
JqBvEnqnQDYDUqXffbV9HloXoGWBhHoRakioiQrB+EbOIDL4Kq4MXJn/veEn
cP4vYLmQOIcCJxpyEiEnFXLIfdocLnDzgCsAXiHwRMATA68cuJWoilsD3Drg
NgCvGXgS9LQ4XjvkdkJuN+T2QG4v5KL0QZE3qOAPKfgjivzRnfzxnfzJHcHU
tmBmu2B2q2B+S7hA5wjrRWvEnzXR5mrJ1mrp1krp9rJ4Z7lsZ6lcsVShWKyE
hSpYqIb5Gpivhfl6mGuAOfKxo7MtMKPEd/9UJ0x2w6SURu3N8T4YG4BROYwO
wsgwDI/A0BgMkjtRA1PQPw19MyCbhR7SUnQtQMcCifIiNC1CPYkypc35Y2u0
Nrv9XSiTz8/7d8ggY08CYm4icFOBS0LM5QKPD7kFkFsEuSWQJ4a8Csitgtwa
VJvbALlNkNcCea2Q1w78TvRYBH4P8GXA74P8AchHET8IRhQFY4qCcYVwUiGc
VhTO7BTO7RTOU8/P2ype2RStborWNkpQErQu3lor214r31kt31mpUKxUwnIV
LFfDUg0sEq86WKiHhQaYb4L5ZphrobE9MNMBM10w3Q1T9HevX5vsh4kBGJfD
2BCMDsPoCIyMwfA4DE3A4CTIyUCyfxZ65yj5V7sWoWMR2hahZQmalhDA1Qvk
9y+ntvNGyB0Nz59Bd/+Po/tXyCBtMycKuAnASwUeiW4uD3L5kCeEvGLIKwF+
GfArgV8NfJQIA78R8lvQQ6Ly29FzSATdIJCCQAaCPhD0Q4EcCtA2KhSOQeGE
omhSUTStKKaf5P3aTsnydsn/re5LYyS7rvNaTYqiSFEUJS/aLNhW5MA/jBhQ
ECeQYSdyFsABjMSJjSCADMQIA/iHEciAABmwBBpWokiyRFmLRYpaSFFDcval
e3rfu6u7q7qru7r2fd+3V2+t9+q9D8k9572a6XkzpCZE/qRRM6jqun3fOd89
99xzzz3nXNXa1K1Nw9wam9um+O141zb2HCPg6AFo+9AOoB5iVhHG+KNyCPIx
RmGMTjyf/5At8kES/TR604yy93YKaBfRLqNVQbOKRh2NBupN1FqotlHpotRD
sY+Ch+q7MiOkBLAyojIiDGxwNLXWV1rjWxWuZ/y3PiT99TPeAtlfwSU+S7jx
fdx8GXOvYe4S5ii6A/MLuL2M22tY2MTCDhb2sHiAxRAL5AmWIliKYimOpSSW
01jOYjmH5QJWSlgpY5W2QRQ1sd7GeterzepsSs6m7GwpzpZmb+uT7fFkx7R2
LWtvYgZswvcAhngdQg9CC0E7gnoE5di9wmDmF0cxSHFICQx5MRtkMOAot14B
3SI6ZXQqaFfRqqPZQLOJegu1NqodVHoo91EaoCh555tPpGQkFAZVmYI6M7Pd
t5ebtLI978PPf2vQXTyJM76J5GO4+CXG8UXc+jHmLmD+EuYZx4UFLKxgcR2L
W1jcwVIAS4dYPqKvlk+p4sFKDCsJrKSwmsFqDqsFrBWxVsZaFet1bDRdvz22
BtiWsC07O6qzozm7hr07tvfMSWAy2betA8c6JAvMDGIcgnEE4xh62JXFd6sR
KFEoMcgJyEmMUhhlIGUh5TxZ+mi/hF4Z3Qq6NXTqaDfQaqLZRqODege1Lqp9
VAYoD1FiqPIyMgpSCp+LKR6KIf5qq2stNWjC+2/sfHMU77vX5cO4QqHeuPUj
gvL2ZdxmKBcXqajY0gaWtrC8i+UAlg+xcoRV2qJjNYq1OCVwrqWxnsV6npIQ
NsrYqLo5wuQAF2bjjoRdGXsK9jQEDGffdPYt+2BiH9p20J6dhJyZR6wjhjLs
accn9Aj0M2hRaDGoCahJKGkoGchZyHl3pj495HPYfgX9Gnp1dBvotNBuo9VB
s4tGD/U+agNUh6hIU69jXkGWUUyoiKlupST//aP+257eArUP4vJXPNTmf4rb
l7DAqC0tYnkFyxtY2cbKLlb2sXKIVUqAp2/XY9hIYCOFjQw2cxTNv1madSVu
u4HtFnZoU0abUGGTBEYIKNjXcGDgYIxDC0HbCdnOkW2L17Fjhx13n2tGMD7D
OAojBiMOPQE9BS0NLQM1BzXvIfAxuYxRBRIHFgzq6DfQa6HbRqeDdhetHpp9
NAaoDVGVUGH5KipwcUurSDJuQvpOZPoq0Lc22vpidTDj3ap+Djf/rWQuju/3
4fheV326OvHWDzH/KtV9XLyOpTleK1awsoHVbazuYXUfa0GsHWP9lL7ajFNy
2xalRLg65hlsV7FTx24Tu23y8weoyjr2heWh4EDFoY7gGEEToQmObOfYdsK2
K28fs8+cSZRE0IrBjMNMYJyEkYKRhp6FnoOeh8aV19QylArkKkY1SHUM2RfX
b6PXQbeLTg/tPpoDNIaoS6iNXFl9D0GoIqsyhBriKs5UnPBk3usZ600yOb/n
w8tfuest8PsALv4N4/cS5l/BwutURW6ZD39WV7C6gbVtrO1hfR/rQWwcY5My
A+nb7ZQrFe+jePTdMnYr2K1hr4G9FgIdctAf0MjiUChsFUEdIQNHJo4sXh8e
dyK2c+Y4UceOOXac4JskYaUwawqT8dFxFuMcjAIML5vhQ2oFahVKDXIdowak
FoZtDPiAuNdDt4/OAO0hmhIaI9RZwCoqSioKKnIqMhpSAjsNUXW6Iu929fUm
bUdnXnhb6D3t/neVdd/8y1h4DYtXsMLQra1gbQPr21jfw8YBNoLYPMZWxJW1
p7HL4cJ7HLcYqCJQx34T+20cdMkXG5QQ4mPuIw1Huitl78OJjVMbhJotUHNi
jhN3nIRjJx07zfBlYYlXHmYBYw+19+kVaFVoNagNKE3ILYzakDoYdjHooc+O
qu4QHQmtEZqy+1dPecBpyGvIakjrSLjAzcyEhtZeV9tosiXz/Z+B2+wd3GZn
vHs1n8JVtrznf4SFC1i6jJUbWOMDk/V1bGxjcw+bB9gKuWP0NGWp7Sbp60CW
onP3S9iv4KCGgwYOWzjsINhDaED7sCPZReqTOBnj1MTpRICFMxtRG1OwnJTj
pB0749hZYsbOY1KAVYTFy8G4AqMKvQ6tAa0JtQWlDbmDURdSD8M+BgP0eavX
HaEjo8VzsK6iqqGsoSjw0pHTPbxiHl5moKtvNvlioB/48PHfNDj75nL2JC6z
lpv/ARZexdJFrFzHGuWpUEGMzW1s7Xk2K3bC2I1QRtAe47afw0GB4vYOqzis
I9hEsI1QF0d9RusDOKEwS5waiJiIWDibuIAh7mAKmJNxnKzj5ODkYbM/wp7m
n/yyWcW4BqMBowm9Ba0NtQOlC7mHUR/SAMMhBhL6I/R4UnYYloaGmoaKhpKO
AoOW0Um5uaAdSVagq202SH/479X235n5YMwY2cdw/Rts0/2EitutXMOaW3P9
KWwfYCeE3TD2IghQFgY1O8jhsEiRc8EaQg0ctVx5+jmcDHEidkrCcGJHytkY
URNRCzHbBQlJBykHHkiOAMkpwCnCKbnz6ZlJFVYNVh1mA+MmjDb0DrQu1B6U
PuQ+RgNIEoYjDGT0FfRUz/J9qqGjqqOso2ggbyCrsxZjkI4la7+rbDXI9Tfz
47eP0jtxnY82F17G0utYueJln2F7Czt72DnAbgh7YQQilK9ykMJhhloHi66d
/0mEOzjp4XRAHpHICGfCUBfKgo8m4hbiEyRsD6C0g6wDAsi5A5DDJVscNins
OiYNWE2YLYzbMDrQe9D7UPtQBpCHGEmQRhjKGCjoMwgdHW0dTYPeVw2UDBQY
JTEFvZP9sGQddOXtBoUSvOJDxV/71EXpGR9K7mdc+xpuUc6i5wXC2k1ssOLa
4Tzq3QPshRAIYz+CgxgOU670fJDiyo45wiPcxmkXkT7OBuTaENsZYYuLFSnO
WCUtJCceShkGKu+g4GCKkuuBdWpw6rDZcJi0YLVhdmB2Me7B6EMfQB1CkSBL
GMmQFAxVDDTWWDo6BloGGgZqY7e3x4VEiWk3Q5sC52Q0OezKO02yH/33zPvv
V30wTlM9P/MEll7FykWsXcfGbWzxwd3eLvYOEAhhP8y4fBShLI4o/AzHFYRr
FGlx2kaki7M+okPEJNpHC0tbaNKkgRTt6JG2PWhyjE4RKAFlOOyyE9DMCmxm
PuQ04LRgc7jrpAurB7OP8QDGEPoQqgRlBFnGSIGkYsjo9AxCp22gOUZ9jOoY
pTFJEtv4F3zc+29guB8NAoHn2rtxgxKasfgyVl7H2lVszGGLD5r3dlz5+AgO
I5SCEuIg62Py0+GkgpMaTht0kH7WRXSA2JDcNQmZTOiUkG4xbgxI1vagYEER
UKDiyj0j8T5CoklgOG3Y7AOa9GENYA4xHsKQoI+gylBkyCpGmrc36hvoMhit
MRpjkpbymPRPjkUlodhnI+u4rwWadGvFzOs+NPx3PN9Fh3r/OVfjzHH2y/IF
rF3Gxk0XiU9jfx8HIRyGEYwgFKNcgeMMwnmcsF8tUkOkgTM+Fo0NyD+YGNFu
LK2REGfHyJnITahl4a5ogEUDNaAOnEPD6cDpwu7BZhPIGsKUMB7BkKHL0BQo
KmQWDcnAwAAJyNgDpG6iMvZUjWiQFIBIRrg3OmgRIG/8DGl5xwPnjrtDxBwp
mDtxFR/D1m3s8nnqfgCHQQSPETrFUQzHSYQzFLp6WuQVqYazBqJ8JJkYICkh
JSOtkNGbFeM2Rt5CgXw2d0Bxd7QuKGgCDIqQGmFP/5LTg9OHPYA9xIS9gqaM
sQxDga5C06CyIIwMDA30x+iO0RbYmGiYd4VFNEgp4+hQCfcGQQbmvltv/ZLy
YGToM680H8fyy1h9HetXqbrMDs+i/T0cHhIsR6c4jiKcwEkapxzueMbuwliD
DtLjXSQHSElIy8iotD7kxHJqomChaKNE1jN4BXIBETLbJF9bC2gDLCk+TCYj
WGzNjFUYGnQNGmMiG5DGGIzRE7CYaJtomiQvVZYX0SCtmHFJOe0NjtqMyYPu
Lf7ZmEwr73q3EcxTgjVWL2D9MrZuYmcRAT7uPTxAKISjE4TPcJKgeOdIDmdF
RMu8ODfoEDvRRWqAtEQOIrHFFHM8LzSfidIEZXuqTcQDz0mKCwq6QA/owxnA
GcKWYI8wETsIS1jFP2/y6mzo0JltZYzRGEMXGhMdhsYVlwo3yCpmQlLO+lK4
w7j475r2V59/MC5P4tzdsL+JOc6RXHkV6xexeZ0Kn+zxZDoMIBTEcZhwOY0j
ksJZFtECYmXE2RWabCPVRXqAjIScQrsgMdWLYgwtlCeo2K5Kof/fBBMwJg5j
YsuYKJioAhmhUD5g6t6hkzqG7MJiom8yLBbNInf9EQ1yqpkaabHB6LTLmPhv
834wJmzT3XOCPa2OxbL1aSxw+Pnaa9i8QsV/9pawv0G/CR3i+BjhCE5jOEsi
mkWsgHgZCcqepfPddJdOZ7ISOXTE3lBMcrFIli1UWOnWHG/yiPcPwgOMhzOC
I8NWYKuYaJjosBgPgzlWTcgmJJMhsdC1vBlU428LqpWRjcRwdNbtkFT670r3
3yrl4uEdA3k//giX8/XrH8O52+Q/jNs8q9Z+is1L2L6B3QXsrzFOBzgO4eQU
p1GcJSi+Op5HokTxVakGNch06SArL6Gg0J5QTPzy2I0gRc1G3UHDQdMBJ3wQ
SIyQoGxAhtYQmKLkKHBU2BpsHROeJeMxBFC66c3KpwRSA4uQEhOK9C/DVNLt
nGKmpFGs1zlpkoU1c8uHzLseiJQfm0fuk6TzsQ9TNEk38zz8B1jgdKCNN7B9
DbvzVKricIsNvCBOwoicEVyxNIXYJksU65Susw3TRa6PgoSijJLYSLM1XLVQ
m6BuT7Fy0GEtPZWmWQGUsJ0k4BxUjgZHh81QWWPcQYvEymKfpYUeg9VkpCpi
76maGUlO9DtnLVKKM/MPQOod4iMh9LZRetarkf5xzLPds/5TbF3B7i0EFnHI
mvr4ECfHiEQQjVPMfiKLZJECwjJ1ZFvUIN9HcYiSjDLv1oWCqAlNMUHD9uBp
E0LoMUgDkqYhLZ2MD+7Fx2F8JmN4EJnQBEQWQSRZ8G7SqxlOWbPyI4U//z9F
5Vn31k6O+fgEFjgfc/MN7FxH4DYOVhHiUI2TECKniMYQSyKRQbKAdBnZOnIM
R4HhKI8YC430g1hkGxaa9l0sug76DgaMCM8q0FmcAEPYxefgEF/bYwg4TBNj
k8RFs6BYGFkYWqSYxTru3g2V6tHiEAhfmVnw4fHY28BjGt3COLwf899mybiA
7SsIzOFgGaFNxiGISBjRKOIJJNJI5SmaM1tDrolC2z0dQ1UmZ0rdoBW1KdaQ
yV0Ees4sQfAohowDC8MsxAr9C/cDYJlTDKxzGNDK5HTG9Od13aooakEaZPqN
eDND1C/6kHjn20DisfNIPOPp3a2L2LtBBVGC6zimHANEjhGNIB5HUsCQQ6ZI
IXn5OgqtqR+6MmQoVDR0muEtsXxM0LFdHFxhEDhAcjByWHsRDrgfhztQWB4U
NDVMZ2A6PcahqVs1RS2N+vlBM9XOE3NLPhwevQ+He26ixLno8nuw4P3Rb2OO
S3VsXMDOFezPI7iCI9akkRCip4jHkExRkHymgGwZebZZSnzwUx3SuUFdQUMj
r4hYPjsTdG30bB//kB0oLBMqMOVfqAafKBgMgWo5suUQBMx/2zAbqlodDYqD
Zq7L+cjZrdmHQuF8ZgohwZ//GW6zpbZ9EYEbCC7haAMnHNgSDSMeRTKBdAaZ
PHK8ESw2UKLTd7Y6JDRkNFW0dNqEuMz2bQzs+5mFyvy+CadisJlZR7Vs2bQl
k6y8rmG2NLUuD8rDZqFXzjSTPFzLPj4fuY/PaSUW5u8fYu551nIXsHuV6vwc
rSG8gwhHlcQjSMaRTiGTZUVfRrFGsUeVDqrk2qPjjKaClkYeCmER9ab8DW0f
c9Ac6M4d5mZmBXuzgr+ZpwSHpiU4dHTLVs2JbJLF1jfMjqY1lUFNapX7lUIn
49W9GF3+794A+fmcvY/PD/pmN+9jfw3zVDgPOxexf5PGM7yJ0wAze4JkFGl2
t+byyJdQrKBUpzCVWhd1Pi9qyWir6Oi0rxSrdX8yZdbGyD7PLDU2mF/Bp2B4
diJ4fb9lCV6dsWnrpqWaljym1Km+rnWUYWPUrg6q5R45WVKFnejRq+KNcpmq
5q++Baf33kBGELFv55dxk09+ti5g7yoOb+N4Dac7OONRTVJ4MzIp5LLIF1Ao
o1RDpYlaB3Ue1dYIbQUdjVwtYrMobLjhZMqiDcWGas8Sj/xUwxYv70TEMWHz
ayIYNe2xOdFNUx1TNNFQ13qq1B61G8NatVcoteLePbl47bMeX281ot6NLjMP
tpJnPYnmEX4X5tmvtXOJRji0hJNNnHknEB9C6gyZBHJp5HMUq1uqoFKnmJl6
F00e4o6Mroqehj47EMQ6K03Ocw6Nt1i64BnGRGj2sQ3WPC7zE9MxzcnYtHRm
e2RoQ03qyp22VG/0i9VO2vVupE4uzEx/cOGzM2u8QN3hHVwOzbN9n/6Zq9SU
//e7/N/4CpbYdAlcRXCexj6y7fL/i5Twl4khl0Q+g0Ke4mUrVYrHqrfR7KFF
R0HoyuTl72vkXBL7YmF5jSZ3+J/h5+kTsZzqrJaMCUFgetno7zbH1phZVw11
pI0GSrcr1duDUqOX9c42c6nbmeAPKsvPeZ9x4S88TljSH72Dwp2xJ5uOGH7w
bS3nkbg/RprR+3XMs5bbvYiDGzii2heUFR/n6K50BNk48mkUcigVKciyVqeQ
n2YXLTq6pTY9mZz6Aw1DnbwoIxPKBCpvLrUJLcMCC2GeGbwqCXU9njimbY8t
IQlureV3lQob+QhVxmksfVG6RQX38dO/mNk4J/P/NyN+PvJ7Zsrlr+La/8QS
m/EBKtpKNWpONxELIMnBVtko8gkUMijlUSmhWkW9gWaLAkvafXSZ0b6MAXue
JZ32/wq7clVmUWMLVB8LuR8LW4jXJZrjY8My9LFBxr+uS4raH8nNgVTpDfLt
bqrRpIzkcmahGH7FG2/Z5V4QvAn3TtGH5Xpqm7Af4SOY/4Y3gfavIXQb4VWc
bSO+z9otglwMhRRKWZQLFDtbr1KAXKuFdgedPnrM7UDGUIGkYaS7cq2aQoQE
o5rYnImXIXg1aI6PnfF4YuiWoZmGYupk3OtaX1Vao1F1OCj0eul2+0z8slZY
r8SvuGuVeuvzb5PPx30t3uvxLfTX3kUcCglepNoo0R0kWKPnzlBIoJRGOYdq
EbUyGlUKXWu3KPyl10OfuR3yscuIDwoVnbg1hDGgGeQI03V6Gbpj6LahTQzF
0mVLp5P0sdbTlbY6qsnD4rCf6XfjnQbFnNVzi9Wz1+qH33NH1bg55XbrPr09
e27snvBJruvRoM8rrs66jOAtKtgT2UBsFymqGoB8FMUkyhlUcqgVKUy3WUWL
A6O6HfR7GDCDEm+6ZFVYz6qAVdXII6xppK80wamh2YZq67KtjyY6aTpT647V
ti7XVKkkD7JSL9FvUShTq7jWTFMWeOuAjD9l8QvU76XP0Tg+coezj+PczS3+
jOaPYPFbWKO6dTi4itA8TpZxtolEAGmei4UYSklUMqjmUC+iUUarinYd3RZF
3Ax6GDJHoxFkPhFSZBovWUiApkCnl0OvkaNLjjawNYoIstSWKdcMqaQOsnIv
KXXOBg2Cr5OjKhnt4x92A2T7aLe56u0bn2N9S+rWdUN9gtegO3x448Pj9QtY
ZrWy9wYOr1MBrNNVxLaQ5LmWj6DI3FQzqOXQKKBZpvDJTp1CsPps+0t9T9fL
fAaoSMSNJKyIkTBDNQnaAFrf0chuttXWRK6bo5IxzGn9pNyNjlpUjK1fIhdX
9+xC7+j7gz1S52NmhC174sK9K+PXfPLFZxwfwir7f/YvIXQT4QVE1hDfQYpn
T4HpLzP9daa/xfR3iX6eN11IXYzYNpL7tDcbCOEaiK7VPtQuBRWo5AV1lNpk
VDaHOaOf0rpRpX0iNw5dvvupq4PIT4bB703rnV77Sw/iWx71TCdXq56dUv1B
LH4bG1yr4OAKjm7hZAnRdSR2kJ4SXoqhkkQtg0YOzQKFA3fYJdpvYNDCsAWp
jVHHje+myAelxwf74k0HSgsKJa85ctUZlSfDvNlPGb2Y3jnVWiGlRhtbKTs3
jF+UTn40EhPBo/zq5z3Kr3mUszb26uDfnQVPuLivfA9bL9Nvg9eodtrplIMM
c1CMoBxFNYk6c9DiM9duBb0qBT/2OQxNamJEoUHu6vEeIltu8qsBmbaXzqjk
SPnJIG32YuPOqdE6dnNOlMLiKH1djl6Qj8itrG991R2LuxbmJY8D3tm6t2/c
o4d5D/xhrLNX+uAiQtcQnkNkCbF1qmzh8lBiHmoJNNJoUs4IOkV0SuiW0aug
X8WghmEdUgMjotmti4tRhSkvCsqdQXrSi/PvHzeqlJyiZueU5BU18ooaoiJT
442v+Cl/zaOc9zjePUJ3ZZ6x/yg2f+jRfXQdJ/M4W0Z8A6ldZNnsKZ2iQnTT
+1YWrRzaeXQ4ArpXQr+MQQXDKqQaBVVKFUhlSCWudvTkpB22mkGzvmeUyT2v
pa9r8Yv6CdV2HO8+b61/ecZP76ue5uTaA3xb1p214AmsvYCtH99DanQZiQ2k
d5E79Ea9ynF9jRQlxrQyaGfRyaGbR6+AfhGDEoalWQyLQlMNCxjyUfUwi0HK
6cXtTsRuH0+awUk9YFa3xkU6njNSV4wo2eDmwXes7a/bq5yxeOOvBI2veNhy
1Rbvxsi7UvG4qw8FzR68b+DoGlUtEzQnN5DZRf4QRVJYqJ6hHkMjjmYSLc43
6WTQzaKXQz8/i35O2OP9LPoZ9NM8aZPoxZ1OxGmH7WbQrgcmtR2LtZ6VuW4m
LpoRquE3CXzL2eSMvnnKGySr8YcexVz30bsJ9a40PO6ivPJdbLx0D8WxuxS7
OQKonqImiI6iGUcrgXYSnZSY8t200EXdFCV29Hh/3IujG0Ungtax0ww69X27
tmNXNiYFsqzt1BUrRhlYk8O/d3aexxoHh815xL7o0cp1+flW7Tvepiex/G2s
v+jReCxonCMaU3wElN9HMehFO6N2inoEDUFnDO240MidhBiTThydGL9YWAR5
7VPKYGscoh5wqjtOZdMurjg5qlYxSVwkUo9fcva/g03eLN9+zt1b3pXab3u0
8vziqqhvVpPhgTbA+7H4TayxVXP4OvETIX7oY2YbuT0U9lFi86YWRv2EMhqb
Z2hFZ9E6E2ZRK0IZYW0OCaYcvCNKQ63tUQZ3ecMprTqFBSd700XkMefkZQRf
wK54Hgdu3/yin5fnPV7+0R3b5eHzre9I0ZNY/e6UHa4FFVukUkrpDSpjkt9F
cd+l5xnUjlAPo3HCL0G9ePGcEGw0Q6gLTnZR2UJ5ncpwFBaRnfM4QeQnOPoB
9r+LLQ79mnvuER8nX/M4+SRTRnWA3BvDXULvWi5+jqb3+rKsvQcrHDDFP1R3
8Gwe8SUkBTPryG4xMwHX31ALzaIenHmGGhLhAVSZ9hLTnmfayX9EAoXjH+FQ
jAP7SOf/2pOLu7R/2aP9tx5yFPwZvvz9e7H8LWyzXXB0CWEhVzcRvY0EV1/K
cFWZwjaKuyjteatNlT1cFUE2CQ+Ka+69u4hfQoSzgYMvIsB+zsUv4cYX/VR/
ydPen3oTqu+pSHJOZpja99HnTZ7VQSE2l3FyDWe3EBMELzLBa8gKmjeoDEtR
oLrtrjFUxCh9E8lrLpEIv0w9BL6Lbfbu3HruPmz/2sP2d96CSn+u+p25+9j5
llj4Ota+w/L4EYTeQPgyFaeM3kJ8HokFpBap0lVmmcor5fjUPr/KNX0WkRFE
30LyOuJXEL1IdB+/jBCr3R1XJv7Go+Mu3V/w6P70PVpmmln85JvwgfmvYuVb
2HxhxrPujt7AyRVEriF6A7GbiN9CYo5qnqU4EjezQLSlblFZuvhVRAWmr+Pk
p0Re8CXsf2/qi7n9P3DtC/xIH5V/6VH5r5mITz1opJ/C8jex8ffYZdEMCd4v
Ui3W08uICDSuISYefYM1JuLXhfRFr+DMpUM0FbP+xzh8CQFvP4mlL+PGc3fn
wF1KPudR8vv87N++R/aw/l3sfH+qlcVMORJdv4aweMYbOOUZGrmIUwHVazh+
FUevICgmrFA3L3pPXf+Gx5T/HPqz3lP/gJ/6Ow+al49i9VvYehF7P0Lgx4+6
My/0Kk9T8aifICgY/KF7hokdsdJ9A8tfvS9S4s+95/whP+d3fTizFn4Mm8Kq
fsF7bb+AnRceY1Q3/k78+yZx8fw5GT/f+595vf8x9/fPz8vY41j5Jlb/Dmss
p6vi/fNY+TqW/3YWy1+j8fiq14c/auy/edqBaxnP/AuvT9fLgVtf8lr54+//
1KPkM/xXv+fj019V8k+81v+Fv/+X3jP8rf6z1+pZbvWvvFb+6nt/7LX6M271
W7h/Vae3U5/Fear8lbP+0Ovpz/n7fwL/TL3fGzn1gvh7+gOvp88+dE9T/eCv
e/NvvdH43EP35Nfa/ooH/8aj7fMP3eMTOHdqeq6n3/N6+quH7ulJrye/19+f
g/W7Xs/P3TOmU7Tf6+PQnz/4Ke+vv8Tf/zucO0041+qfeq3+F7f69zjncz/X
6h97rTiTduY/+J7sj33/Ta81ZzjO/Eecnzt3W/2GN6aciTbzRz4s/BHQv+71
yXlXLO3U2D9rP+G1eolb/Sdfn/5Yv1/xWnMsP8vYw1rCfg30S15PHMc98/v3
jfiD7NBHpprvXD8f8vp5/SH78dP1mK+/n/f6u/yQ/b3zvhb+FXMaHXr9TXo8
bzX5T7ae5bQqd9Tn3uLv7xuze+0Y7ug9Hh0L94zdPfbFO++Moffsx72/WeHf
/qnXdnpPDz/Ya8EnGDP/dUrLs/zDMOzwN8/6UNnj3/5v8f9vPMS7zzwAG5YK
8TbALf7E98393vS9/y/afQb36qzAQ6Az847/A8Tjhvk=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{300, 290},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->126455624]
}, Open  ]],

Cell["\<\
Calculate the finite area of the surface extending to infinity:\
\>", "ExampleText",
 CellID->293240194],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", "Pi", " ", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sech", "[", "u", "]"}], " ", 
     RowBox[{"Tanh", "[", "u", "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"u", ",", "0", ",", "Infinity"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->43158741],

Cell[BoxData[
 RowBox[{"2", " ", "\[Pi]"}]], "Output",
 ImageSize->{22, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->128348930]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->686424782],

Cell["Velocity of a relativistic body in a constant force field:", \
"ExampleText",
 CellID->380165056],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"D", "[", 
     RowBox[{
      FractionBox[
       RowBox[{"v", "[", "t", "]"}], 
       SqrtBox[
        RowBox[{"1", "-", 
         FractionBox[
          SuperscriptBox[
           RowBox[{"v", "[", "t", "]"}], "2"], 
          SuperscriptBox["c", "2"]]}]]], ",", "t"}], "]"}], "\[Equal]", 
    FractionBox[
     RowBox[{" ", "g"}], 
     SqrtBox[
      RowBox[{"1", "-", 
       FractionBox[
        SuperscriptBox[
         RowBox[{"v", "[", "t", "]"}], "2"], 
        SuperscriptBox["c", "2"]]}]]]}], ",", 
   RowBox[{"v", "[", "t", "]"}], ",", "t"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->92031443],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"v", "[", "t", "]"}], "\[Rule]", 
    RowBox[{"c", " ", 
     RowBox[{"Tanh", "[", 
      RowBox[{
       FractionBox[
        RowBox[{"g", " ", "t"}], "c"], "+", 
       RowBox[{"c", " ", 
        RowBox[{"C", "[", "1", "]"}]}]}], "]"}]}]}], "}"}], "}"}]], "Output",
 ImageSize->{200, 29},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->95307473]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->287066003],

Cell["\<\
Solution of the Burgers\[CloseCurlyQuote] equation using the tanh method:\
\>", "ExampleText",
 CellID->170966243],

Cell[BoxData[
 RowBox[{
  RowBox[{"u", "[", 
   RowBox[{"x_", ",", "t_"}], "]"}], ":=", 
  RowBox[{"v", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"Tanh", "[", 
      RowBox[{
       RowBox[{"v", "/", "2"}], 
       RowBox[{"(", 
        RowBox[{"x", "-", 
         RowBox[{"v", " ", "t"}]}], ")"}]}], "]"}]}], ")"}]}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->75279197],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"x", ",", "t"}], "]"}], ",", "t"}], "]"}], "+", 
   RowBox[{
    RowBox[{"u", "[", 
     RowBox[{"x", ",", "t"}], "]"}], " ", 
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"u", "[", 
       RowBox[{"x", ",", "t"}], "]"}], ",", "x"}], "]"}]}], "-", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"x", ",", "t"}], "]"}], ",", "x", ",", "x"}], "]"}]}], "//", 
  "Simplify"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->594217891],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->503266249]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(13)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->171920494],

Cell[TextData[{
 "Basic parity and periodicity properties of ",
 Cell[BoxData[
  ButtonBox["Tanh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tanh"]], "InlineFormula"],
 " are automatically applied:"
}], "ExampleText",
 CellID->5053],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tanh", "[", 
  RowBox[{"x", "+", 
   RowBox[{"Pi", " ", "I"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->628282426],

Cell[BoxData[
 RowBox[{"Tanh", "[", "x", "]"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->434235937]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tanh", "[", 
  RowBox[{"-", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6775414],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{"Tanh", "[", "x", "]"}]}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->306195501]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tanh", "[", 
  RowBox[{"I", " ", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->87508671],

Cell[BoxData[
 RowBox[{"\[ImaginaryI]", " ", 
  RowBox[{"Tan", "[", "x", "]"}]}]], "Output",
 ImageSize->{57, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->237932815]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->209691398],

Cell["\<\
Expressions containing hyperbolic functions do not automatically simplify:\
\>", "ExampleText",
 CellID->918027988],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Cosh", "[", "x", "]"}], "^", "2"}], "-", 
  RowBox[{
   RowBox[{"Sinh", "[", "x", "]"}], "^", "2"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->15336178],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"Cosh", "[", "x", "]"}], "2"], "-", 
  SuperscriptBox[
   RowBox[{"Sinh", "[", "x", "]"}], "2"]}]], "Output",
 ImageSize->{126, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->194383011]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->407988126],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->45416170]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->59205322],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Refine",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refine"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 " to simplify expressions containing ",
 Cell[BoxData[
  ButtonBox["Tanh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tanh"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->181261294],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Refine", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Abs", "[", 
     RowBox[{"Tanh", "[", "x", "]"}], "]"}], "<", "1"}], ",", 
   RowBox[{"x", "\[Element]", "Reals"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->668441011],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->147625029]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{"Tanh", "[", 
    RowBox[{"3", "x"}], "]"}], "-", 
   RowBox[{"Tanh", "[", 
    RowBox[{"2", "x"}], "]"}], "-", 
   RowBox[{"2", 
    RowBox[{"Tanh", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->371465628],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Sech", "[", 
    RowBox[{"2", " ", "x"}], "]"}], " ", 
   RowBox[{"Sech", "[", 
    RowBox[{"3", " ", "x"}], "]"}], " ", 
   RowBox[{"Sinh", "[", "x", "]"}]}], "-", 
  RowBox[{"2", " ", 
   RowBox[{"Tanh", "[", "x", "]"}]}]}]], "Output",
 ImageSize->{249, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->270263776]
}, Open  ]],

Cell[CellGroupData[{

Cell["FullSimplify[Tanh[Log[GoldenRatio]]]", "Input",
 CellLabel->"In[3]:=",
 CellID->245073739],

Cell[BoxData[
 FractionBox["1", 
  SqrtBox["5"]]], "Output",
 ImageSize->{32, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->37818659]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->356071867],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["FunctionExpand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FunctionExpand"]], "InlineFormula"],
 " to express special values in radicals:"
}], "ExampleText",
 CellID->170415022],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", 
  RowBox[{"Tanh", "[", 
   RowBox[{"I", " ", 
    RowBox[{"Pi", "/", "16"}]}], "]"}], " ", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->119229365],

Cell[BoxData[
 RowBox[{"\[ImaginaryI]", " ", 
  SqrtBox[
   FractionBox[
    RowBox[{"2", "-", 
     SqrtBox[
      RowBox[{"2", "+", 
       SqrtBox["2"]}]]}], 
    RowBox[{"2", "+", 
     SqrtBox[
      RowBox[{"2", "+", 
       SqrtBox["2"]}]]}]]]}]], "Output",
 ImageSize->{119, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->93768047]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->40808168],

Cell["Compose with inverse functions:", "ExampleText",
 CellID->376329807],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Tanh", "[", 
    RowBox[{"ArcTanh", "[", "z", "]"}], "]"}], ",", " ", 
   RowBox[{"Tanh", "[", 
    RowBox[{"2", 
     RowBox[{"ArcTanh", "[", "z", "]"}]}], "]"}], ",", " ", 
   RowBox[{"Tanh", "[", 
    RowBox[{"3", 
     RowBox[{"ArcTanh", "[", "z", "]"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->337671475],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", ",", 
   RowBox[{"Tanh", "[", 
    RowBox[{"2", " ", 
     RowBox[{"ArcTanh", "[", "z", "]"}]}], "]"}], ",", 
   RowBox[{"Tanh", "[", 
    RowBox[{"3", " ", 
     RowBox[{"ArcTanh", "[", "z", "]"}]}], "]"}]}], "}"}]], "Output",
 ImageSize->{292, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->252377207]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FunctionExpand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->184083816],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVmktvFEcQgGd31msD5hEIgdjYXkPCI+CEA3CLwgmkICRLCRFOIiQLRYID
jxBEfkCQiHKGP2ERWZxIQAjBH3Bu/gtRLj76uJnunvaOv6mZ6h2PzTLSzkx1
V9erq6ura/by/P0bP92av3/z+nzn4r35uzduXv+lc+HOvaQpbkRR41EURV8e
jJL3bvJmf+b6Pfm5V/f20txj39uNdgPer/R/usHxJ6wUL9D6AeB9gIcV+EjN
9I5bKf8299Zaa3INJUA7eZrGWOKZw27mWqWx01vG6VhPs0xrLI5tZrCiIjlI
JQMPBdCYHhhJSiyTgdug0iInwNsUelaq4ay+4bQ/fo9knQq2ruS1TaktucUC
Z1FqdV2UcfjwvZR6zFqckbYJeFSSYwhznF9Pm0KVe8cgy+qsy93UzMdOiV4J
f8I5eWugmbPsgMppI1p0Gq0dwDuU/stdaQa54iaDsD6vkZbT7gu0HgbMKMz+
rzPwGpd2r993TATizdRMb6wWLS8BllflVBAW/UXMOSrSHq9FW+fxq6urr+0V
zZpbvLKykvZzrbUVfLvene9mRn0CmFkv+51Wy8vL5+0VzZpbnLDKWMTnqWV4
sjTNdPSu9Lldkc7js30obaeN/wD8sygF1+gucZY12UhFkjFPtR6Jvf70EXq9
JrOn00Y7df8uxZtLns2Ur8lNvgqSdo9CvV/LEqZNrwL+AXB2h4qCtbBe0svO
hBhTyUPWUaRlqMn3iibn7bOVztLxAI38KSkWvEnTZzfGs1+bBzOutbat+OtM
t+dj+RxM04lZT786faT0U6c5zAB98Zygc16rEwKWscFBtHMcuflxPCUy57qa
4v2o0DtbSfpDfUo9IXHJwG9rkWocM8WZpVSHgE/6b9AfNtNc4dR9XKJSEuGt
lLldhrWRZ5UsaGQ1XvIwff4XNMrv2bTvb4D/FalRXzkD8xGuSLKGw4vdw9y5
w/nY56Q3qZS7btmp7uUxowV4/1i8kZGRJAXqpnGmkTQZzg1RE0Yic/tVlFup
C6QvHFs+GwZ4EDSC1QNWcxkh2c+Mst/xk0FSngTMajD3gTHAPG9yxbD+o+Ug
zO43Sk+MiTkrfAaYlXrWwBmZpX0nvCa9V8QOq2J1towTZ2IkyLITXfnksb2g
3WfSRRl26MmmVUDnGGDKW62GvlehGlJD7wyMJKQh2Vye6fwOw7GsGIad9sQK
ucpLOze0gngFeUwG1r4caDPUz5cC0WfekSzVvIa7lBRVpBN60YlbrvYU0w+t
CBCu4hVSVCVd5rXVvm2Qqnb+ebfShVSvernqlIKtRZiNVkk0fHoc8Y8q1hC/
sayzadmXK3LfGDVmW4Mkm2TnXr2DViZ20D607qwgRoR1GFpsET2plIemhfTd
SN7VaMXcGqtMKeT72FbLRDvZ034uZtPa9AlflwvNRYvqgloEEE9qJXC/+Kc2
mb5YPXcnydxMcY2wDnMAME9enGmegjnHU6IUnJEwrJkaack2M2d+08gd0dTU
pDqmXXu5iEkbstYb+jVyMhDvVM305NW7kNyHhV56q1zp6gRh0e5hXzvDaDNa
OK2ewiZcH87fl5aWInfN2nC3uLiY9sv5bjG+WAdVpTD1baPQtUqjOWozqSyk
knK0WVk+O4hT3zML5xvArIc5qs/RygjOqJRd7UaXb5V+meufaKUHsUpV9r8o
w+WK0s99oprucWpJ6uzbfTXZXIxMMsdsJdTHDf/VxTy5b9MuMlVi3Vb0lKnQ
Zvw2x4giy/YXWh9DY8oyKo56ovCSR70SsfhvQ/5by+ZlFnD/jY4a/wM5Smnx
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{391, 61},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->461769073]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->699321042],

Cell["Solve a hyperbolic equation:", "ExampleText",
 CellID->350154092],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"Tanh", "[", "z", "]"}], "2"], "+", " ", 
     RowBox[{"Tanh", "[", 
      RowBox[{"z", "+", "1"}], "]"}]}], "\[Equal]", "1"}], ",", "z"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->114845254],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{524, 178},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->752470527]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->115139483],

Cell["Numerically find a root of a transcendental equation:", "ExampleText",
 CellID->73680],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FindRoot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     SuperscriptBox[
      RowBox[{"Tanh", "[", "z", "]"}], "3"], "-", 
     RowBox[{"3", " ", 
      RowBox[{"Tanh", "[", 
       RowBox[{"z", "+", "1"}], "]"}]}], "+", "z"}], "\[Equal]", "2"}], ",", 
   RowBox[{"{", 
    RowBox[{"z", ",", " ", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->30716122],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"z", "\[Rule]", "4.001732358765553`"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->385887]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->150828770],

Cell["Reduce a hyperbolic equation: ", "ExampleText",
 CellID->222216899],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Tanh", "[", 
     RowBox[{
      RowBox[{"a", " ", "x"}], "+", "b"}], "]"}], "==", "0"}], ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->69415589],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"C", "[", "1", "]"}], "\[Element]", "Integers"}], "&&", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", "\[Equal]", "0"}], "&&", 
      RowBox[{"b", "\[Equal]", 
       RowBox[{"\[ImaginaryI]", " ", "\[Pi]", " ", 
        RowBox[{"C", "[", "1", "]"}]}]}]}], ")"}], "||", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"a", "\[NotEqual]", "0"}], "&&", 
      RowBox[{"x", "\[Equal]", 
       FractionBox[
        RowBox[{
         RowBox[{"-", "b"}], "+", 
         RowBox[{"\[ImaginaryI]", " ", "\[Pi]", " ", 
          RowBox[{"C", "[", "1", "]"}]}]}], "a"]}]}], ")"}]}], 
   ")"}]}]], "Output",
 ImageSize->{461, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->665329089]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4885055],

Cell["Integrals:", "ExampleText",
 CellID->57333213],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"x", "^", "n"}], " ", 
      RowBox[{"Tanh", "[", "x", "]"}]}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->98699071],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"\[ImaginaryI]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{"\[ImaginaryI]", " ", 
         SuperscriptBox["x", "2"]}], "2"]}], "-", 
      RowBox[{"\[ImaginaryI]", " ", "x", " ", 
       RowBox[{"Log", "[", 
        RowBox[{"1", "+", 
         SuperscriptBox["\[ExponentialE]", 
          RowBox[{
           RowBox[{"-", "2"}], " ", "x"}]]}], "]"}]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       RowBox[{"PolyLog", "[", 
        RowBox[{"2", ",", 
         RowBox[{"-", 
          SuperscriptBox["\[ExponentialE]", 
           RowBox[{
            RowBox[{"-", "2"}], " ", "x"}]]}]}], "]"}]}]}], ")"}]}], ",", 
   RowBox[{
    FractionBox[
     SuperscriptBox["x", "3"], "3"], "+", 
    RowBox[{
     SuperscriptBox["x", "2"], " ", 
     RowBox[{"Log", "[", 
      RowBox[{"1", "+", 
       SuperscriptBox["\[ExponentialE]", 
        RowBox[{
         RowBox[{"-", "2"}], " ", "x"}]]}], "]"}]}], "-", 
    RowBox[{"x", " ", 
     RowBox[{"PolyLog", "[", 
      RowBox[{"2", ",", 
       RowBox[{"-", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "2"}], " ", "x"}]]}]}], "]"}]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"PolyLog", "[", 
      RowBox[{"3", ",", 
       RowBox[{"-", 
        SuperscriptBox["\[ExponentialE]", 
         RowBox[{
          RowBox[{"-", "2"}], " ", "x"}]]}]}], "]"}]}]}]}], "}"}]], "Output",
 ImageSize->{418, 66},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->230701068]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Tanh", "[", "z", "]"}], "^", "a"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->304501825],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"Hypergeometric2F1", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"1", "+", "a"}], "2"], ",", "1", ",", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"1", "+", "a"}], "2"]}], ",", 
     SuperscriptBox[
      RowBox[{"Tanh", "[", "z", "]"}], "2"]}], "]"}], " ", 
   SuperscriptBox[
    RowBox[{"Tanh", "[", "z", "]"}], 
    RowBox[{"1", "+", "a"}]]}], 
  RowBox[{"1", "+", "a"}]]], "Output",
 ImageSize->{362, 38},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->773504977]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->95853083],

Cell["Integral transforms:", "ExampleText",
 CellID->272581791],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FourierTransform", "[", 
  RowBox[{
   RowBox[{"Tanh", "[", "t", "]"}], ",", "t", ",", "s"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->323216880],

Cell[BoxData[
 RowBox[{"\[ImaginaryI]", " ", 
  SqrtBox[
   FractionBox["\[Pi]", "2"]], " ", 
  RowBox[{"Csch", "[", 
   FractionBox[
    RowBox[{"\[Pi]", " ", "s"}], "2"], "]"}]}]], "Output",
 ImageSize->{115, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->143785977]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->357712387],

Cell[TextData[{
 "Obtain ",
 Cell[BoxData[
  ButtonBox["Tanh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tanh"]], "InlineFormula"],
 " from sums and integrals:"
}], "ExampleText",
 CellID->174646226],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "k"}], "-", "1"}], ")"}], "^", "2"}], 
       RowBox[{"Pi", "^", "2"}]}], "+", 
      RowBox[{"4", 
       RowBox[{"z", "^", "2"}]}]}], ")"}]}], ",", " ", 
   RowBox[{"{", 
    RowBox[{"k", ",", "1", ",", "Infinity"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4820861],

Cell[BoxData[
 FractionBox[
  RowBox[{"Tanh", "[", "z", "]"}], 
  RowBox[{"8", " ", "z"}]]], "Output",
 ImageSize->{58, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->235858894]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Sech", "[", "t", "]"}], "^", "2"}], ",", " ", "t"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->103698364],

Cell[BoxData[
 RowBox[{"Tanh", "[", "t", "]"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->866871980]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"t", "^", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"2", " ", "I", " ", "z"}], ")"}], "/", "Pi"}], ")"}]}], "-",
       "1"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"t", "^", "2"}], "-", "1"}], ")"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "Infinity"}], "}"}], ",", 
   RowBox[{"Assumptions", "->", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "Pi"}], "/", "2"}], "<", 
     RowBox[{"Im", "[", "z", "]"}], "<", 
     RowBox[{"Pi", "/", "2"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->835284590],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
  RowBox[{"Tanh", "[", "z", "]"}]}]], "Output",
 ImageSize->{90, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->102259523]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->776123091],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Tanh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tanh"]], "InlineFormula"],
 " appears in special cases of special functions: "
}], "ExampleText",
 CellID->339811764],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"JacobiSN", "[", 
  RowBox[{"z", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32865551],

Cell[BoxData[
 RowBox[{"Tanh", "[", "z", "]"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->114022547]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1023561203],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Tanh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tanh"]], "InlineFormula"],
 " is a numeric function:"
}], "ExampleText",
 CellID->354197540],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", "Tanh", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->692579997],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"Listable", ",", "NumericFunction", ",", "Protected"}], 
  "}"}]], "Output",
 ImageSize->{265, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->104390429]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NumericQ", "[", 
  RowBox[{"Tanh", "[", 
   RowBox[{"2", "+", "E"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2173438],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->277162901]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->276477871],

Cell["\<\
Machine-precision input is insufficient to give a correct answer:\
\>", "ExampleText",
 CellID->439078054],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tanh", "[", 
  RowBox[{
   RowBox[{"10.", "^", "30"}], " ", "I"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->517399705],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "1.155891272768109`"}], " ", "\[ImaginaryI]"}]], "Output",
 ImageSize->{72, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->139105583]
}, Open  ]],

Cell["With exact input, the answer is correct:", "ExampleText",
 CellID->84090346],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Tanh", "[", 
    RowBox[{
     RowBox[{"10", "^", "30"}], " ", "I"}], "]"}], ",", "20"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->112567704],

Cell[BoxData[
 RowBox[{"0.09048506806330217256622313805004127349`20.", " ", 
  "\[ImaginaryI]"}]], "Output",
 ImageSize->{176, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->358455784]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->569655838],

Cell[TextData[{
 "A larger setting for ",
 Cell[BoxData[
  ButtonBox["$MaxExtraPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$MaxExtraPrecision"]], "InlineFormula"],
 " can be needed:"
}], "ExampleText",
 CellID->70168492],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{
   RowBox[{"Tanh", "[", 
    RowBox[{
     RowBox[{"10", "^", "100"}], " ", "I"}], "]"}], ",", "20"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->45171604],

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "::", "\<\"meprec\"\>"}], ":", 
  " ", "\<\"Internal precision limit $MaxExtraPrecision = \\!\\(50.`\\) \
reached while evaluating \\!\\(\[ImaginaryI]\\\\ \
\\(\\(Tan[\
100000000000000000000000000000000000000000000000000000000000000000000000000000\
00000000000000000000000]\\)\\)\\). \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/meprec\\\", \
ButtonNote -> \\\"N::meprec\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->4055953],

Cell[BoxData["ComplexInfinity"], "Output",
 ImageSize->{109, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->390700654]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"$MaxExtraPrecision", "=", "200"}], "}"}], ",", 
   RowBox[{"N", "[", 
    RowBox[{
     RowBox[{"Tanh", "[", 
      RowBox[{
       RowBox[{"10", "^", "100"}], " ", "I"}], "]"}], ",", "20"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->412881078],

Cell[BoxData[
 RowBox[{"0.40123196199081435418575434365329495832`20.", " ", 
  "\[ImaginaryI]"}]], "Output",
 ImageSize->{169, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->148817367]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20046782],

Cell[TextData[{
 "No power series exists at infinity, where ",
 Cell[BoxData[
  ButtonBox["Tanh",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tanh"]], "InlineFormula"],
 " has an essential singularity:"
}], "ExampleText",
 CellID->194590801],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Tanh", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "Infinity", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->158266736],

Cell[BoxData[
 RowBox[{"Tanh", "[", "x", "]"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->542087677]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->83049014],

Cell["\<\
In traditional form parentheses are needed around the argument:\
\>", "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->783338730],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"tanh", " ", "x"}], TraditionalForm]], "Input",
 CellLabel->"In[1]:=",
 CellID->121794573],

Cell[BoxData[
 RowBox[{"tanh", " ", "x"}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->663985374]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox[
  RowBox[{"tanh", "(", "x", ")"}], TraditionalForm]], "Input",
 CellLabel->"In[2]:=",
 CellID->298102691],

Cell[BoxData[
 RowBox[{"Tanh", "[", "x", "]"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->294185809]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->90649171],

Cell["Continued fraction expansion:", "ExampleText",
 CellID->230991232],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContinuedFraction", "[", 
  RowBox[{
   RowBox[{"Tanh", "[", "1", "]"}], ",", " ", "20"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->109238381],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "1", ",", "3", ",", "5", ",", "7", ",", "9", ",", "11", ",", "13",
    ",", "15", ",", "17", ",", "19", ",", "21", ",", "23", ",", "25", ",", 
   "27", ",", "29", ",", "31", ",", "33", ",", "35", ",", "37"}], 
  "}"}]], "Output",
 ImageSize->{469, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21038295]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19485],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ArcTanh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ArcTanh"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Sinh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Sinh"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Coth",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Coth"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Tan",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tan"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigToExp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigToExp"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TrigExpand",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TrigExpand"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20741]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16984],

Cell[TextData[ButtonBox["Elementary Transcendental Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ElementaryTranscendentalFunctions"]], "Tutorials",
 CellID->4912]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->1915],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/HyperbolicTangent.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/ElementaryFunctions/Tanh/"], 
   None}]], "RelatedLinks"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Tanh"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->1676530],

Cell[TextData[ButtonBox["Elementary Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ElementaryFunctions"]], "MoreAbout",
 CellID->441609430],

Cell[TextData[ButtonBox["Hyperbolic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/HyperbolicFunctions"]], "MoreAbout",
 CellID->629130428],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->69839349]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Tanh - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 26, 15.2848808}", "context" -> "System`", 
    "keywords" -> {
     "hyperbolic tan", "hyperbolic tangent", "hyptan", "tanh", "tgh", "th"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Tanh[z] gives the hyperbolic tangent of z. ", "synonyms" -> {}, "title" -> 
    "Tanh", "type" -> "Symbol", "uri" -> "ref/Tanh"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5867, 196, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->473378936]},
 "XRef-2005-4-26-23-37-1.8558342"->{
  Cell[14269, 505, 139, 4, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342",
   CellID->169634461],
  Cell[16190, 581, 118, 2, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342",
   CellID->772545502],
  Cell[96327, 2804, 159, 4, 70, "ExampleText",
   CellTags->"XRef-2005-4-26-23-37-1.8558342",
   CellID->783338730]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 103485, 3071},
 {"XRef-2005-4-26-23-37-1.8558342", 103642, 3075}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2552, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3175, 85, 41, 1, 70, "ObjectName",
 CellID->1899],
Cell[3219, 88, 548, 18, 70, "Usage",
 CellID->4120]
}, Open  ]],
Cell[CellGroupData[{
Cell[3804, 111, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4282, 128, 120, 4, 70, "Notes",
 CellID->20640],
Cell[4405, 134, 778, 29, 70, "Notes",
 CellID->32036],
Cell[5186, 165, 235, 8, 70, "Notes",
 CellID->9487],
Cell[5424, 175, 210, 7, 70, "Notes",
 CellID->31226],
Cell[5637, 184, 193, 7, 70, "Notes",
 CellID->28162]
}, Closed]],
Cell[CellGroupData[{
Cell[5867, 196, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->473378936],
Cell[CellGroupData[{
Cell[6252, 210, 147, 5, 70, "ExampleSection",
 CellID->37154363],
Cell[6402, 217, 64, 1, 70, "ExampleText",
 CellID->282989273],
Cell[CellGroupData[{
Cell[6491, 222, 102, 3, 28, "Input",
 CellID->360007743],
Cell[6596, 227, 175, 5, 36, "Output",
 CellID->75984302]
}, Open  ]],
Cell[6786, 235, 124, 3, 70, "ExampleDelimiter",
 CellID->27497630],
Cell[CellGroupData[{
Cell[6935, 242, 235, 8, 28, "Input",
 CellID->522964392],
Cell[7173, 252, 2021, 37, 121, "Output",
 Evaluatable->False,
 CellID->575782128]
}, Open  ]],
Cell[9209, 292, 125, 3, 70, "ExampleDelimiter",
 CellID->227499484],
Cell[CellGroupData[{
Cell[9359, 299, 217, 7, 70, "Input",
 CellID->279778031],
Cell[9579, 308, 845, 29, 54, "Output",
 CellID->584202326]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10473, 343, 221, 7, 70, "ExampleSection",
 CellID->351148872],
Cell[10697, 352, 69, 1, 70, "ExampleText",
 CellID->12609207],
Cell[CellGroupData[{
Cell[10791, 357, 179, 6, 70, "Input",
 CellID->48676102],
Cell[10973, 365, 235, 7, 36, "Output",
 CellID->544643094]
}, Open  ]],
Cell[11223, 375, 125, 3, 70, "ExampleDelimiter",
 CellID->310991724],
Cell[11351, 380, 113, 3, 70, "ExampleText",
 CellID->354882526],
Cell[CellGroupData[{
Cell[11489, 387, 123, 3, 70, "Input",
 CellID->48899084],
Cell[11615, 392, 218, 6, 36, "Output",
 CellID->43095682]
}, Open  ]],
Cell[11848, 401, 125, 3, 70, "ExampleDelimiter",
 CellID->202333588],
Cell[11976, 406, 214, 7, 70, "ExampleText",
 CellID->83756002],
Cell[CellGroupData[{
Cell[12215, 417, 163, 5, 70, "Input",
 CellID->628783698],
Cell[12381, 424, 274, 9, 36, "Output",
 CellID->76503126]
}, Open  ]],
Cell[12670, 436, 124, 3, 70, "ExampleDelimiter",
 CellID->10691152],
Cell[12797, 441, 201, 7, 70, "ExampleText",
 CellID->404549087],
Cell[CellGroupData[{
Cell[13023, 452, 125, 4, 70, "Input",
 CellID->335508864],
Cell[13151, 458, 273, 7, 36, "Output",
 CellID->236426686]
}, Open  ]],
Cell[13439, 468, 125, 3, 70, "ExampleDelimiter",
 CellID->376823989],
Cell[13567, 473, 116, 3, 70, "ExampleText",
 CellID->107944194],
Cell[CellGroupData[{
Cell[13708, 480, 148, 5, 70, "Input",
 CellID->173475644],
Cell[13859, 487, 268, 10, 44, "Output",
 CellID->112201690]
}, Open  ]],
Cell[14142, 500, 124, 3, 70, "ExampleDelimiter",
 CellID->55417354],
Cell[14269, 505, 139, 4, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->169634461],
Cell[CellGroupData[{
Cell[14433, 513, 156, 5, 70, "Input",
 CellID->640204327],
Cell[14592, 520, 1101, 36, 57, "Output",
 CellID->5821567]
}, Open  ]],
Cell[CellGroupData[{
Cell[15730, 561, 105, 3, 70, "Input",
 CellID->21738186],
Cell[15838, 566, 209, 7, 36, "Output",
 CellID->8582653]
}, Open  ]],
Cell[16062, 576, 125, 3, 70, "ExampleDelimiter",
 CellID->551531798],
Cell[16190, 581, 118, 2, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->772545502],
Cell[CellGroupData[{
Cell[16333, 587, 141, 4, 70, "Input",
 CellID->135832970],
Cell[16477, 593, 449, 16, 36, "Output",
 CellID->20195275]
}, Open  ]],
Cell[16941, 612, 124, 3, 70, "ExampleDelimiter",
 CellID->79924022],
Cell[17068, 617, 91, 1, 70, "ExampleText",
 CellID->98010818],
Cell[CellGroupData[{
Cell[17184, 622, 192, 6, 70, "Input",
 CellID->22866542],
Cell[17379, 630, 308, 10, 36, "Output",
 CellID->585153939]
}, Open  ]],
Cell[CellGroupData[{
Cell[17724, 645, 106, 3, 70, "Input",
 CellID->609134749],
Cell[17833, 650, 241, 8, 36, "Output",
 CellID->7495777]
}, Open  ]],
Cell[18089, 661, 124, 3, 70, "ExampleDelimiter",
 CellID->11713121],
Cell[18216, 666, 74, 1, 70, "ExampleText",
 CellID->714224568],
Cell[CellGroupData[{
Cell[18315, 671, 188, 6, 70, "Input",
 CellID->15925042],
Cell[18506, 679, 654, 23, 53, "Output",
 CellID->5584498]
}, Open  ]],
Cell[19175, 705, 124, 3, 70, "ExampleDelimiter",
 CellID->37363620],
Cell[19302, 710, 67, 1, 70, "ExampleText",
 CellID->238310314],
Cell[CellGroupData[{
Cell[19394, 715, 136, 4, 70, "Input",
 CellID->217258805],
Cell[19533, 721, 441, 15, 52, "Output",
 CellID->130524036]
}, Open  ]],
Cell[19989, 739, 125, 3, 70, "ExampleDelimiter",
 CellID->475958798],
Cell[20117, 744, 203, 7, 70, "ExampleText",
 CellID->361093387],
Cell[CellGroupData[{
Cell[20345, 755, 138, 4, 70, "Input",
 CellID->315639521],
Cell[20486, 761, 233, 7, 50, "Output",
 CellID->41723067]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20768, 774, 243, 7, 70, "ExampleSection",
 CellID->174118993],
Cell[21014, 783, 214, 7, 70, "ExampleText",
 CellID->794350743],
Cell[CellGroupData[{
Cell[21253, 794, 205, 7, 70, "Input",
 CellID->776467229],
Cell[21461, 803, 326, 11, 36, "Output",
 CellID->35272939]
}, Open  ]],
Cell[21802, 817, 124, 3, 70, "ExampleDelimiter",
 CellID->88691558],
Cell[21929, 822, 84, 1, 70, "ExampleText",
 CellID->568152293],
Cell[CellGroupData[{
Cell[22038, 827, 107, 3, 70, "Input",
 CellID->109817067],
Cell[22148, 832, 158, 5, 36, "Output",
 CellID->254078800]
}, Open  ]],
Cell[CellGroupData[{
Cell[22343, 842, 114, 3, 70, "Input",
 CellID->683810041],
Cell[22460, 847, 170, 5, 36, "Output",
 CellID->201278655]
}, Open  ]],
Cell[22645, 855, 125, 3, 70, "ExampleDelimiter",
 CellID->129975646],
Cell[22773, 860, 200, 7, 70, "ExampleText",
 CellID->19272928],
Cell[CellGroupData[{
Cell[22998, 871, 293, 10, 70, "Input",
 CellID->63388281],
Cell[23294, 883, 603, 21, 54, "Output",
 CellID->540930696]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23946, 910, 227, 7, 70, "ExampleSection",
 CellID->595213056],
Cell[24176, 919, 73, 1, 70, "ExampleText",
 CellID->303471720],
Cell[CellGroupData[{
Cell[24274, 924, 346, 11, 70, "Input",
 CellID->863250612],
Cell[24623, 937, 2123, 39, 70, "Output",
 Evaluatable->False,
 CellID->756399798]
}, Open  ]],
Cell[26761, 979, 125, 3, 70, "ExampleDelimiter",
 CellID->149200831],
Cell[26889, 984, 63, 1, 70, "ExampleText",
 CellID->233352563],
Cell[CellGroupData[{
Cell[26977, 989, 618, 20, 70, "Input",
 CellID->466400879],
Cell[27598, 1011, 36491, 602, 70, "Output",
 Evaluatable->False,
 CellID->126455624]
}, Open  ]],
Cell[64104, 1616, 114, 3, 70, "ExampleText",
 CellID->293240194],
Cell[CellGroupData[{
Cell[64243, 1623, 318, 10, 70, "Input",
 CellID->43158741],
Cell[64564, 1635, 184, 6, 36, "Output",
 CellID->128348930]
}, Open  ]],
Cell[64763, 1644, 125, 3, 70, "ExampleDelimiter",
 CellID->686424782],
Cell[64891, 1649, 103, 2, 70, "ExampleText",
 CellID->380165056],
Cell[CellGroupData[{
Cell[65019, 1655, 690, 24, 70, "Input",
 CellID->92031443],
Cell[65712, 1681, 466, 16, 50, "Output",
 CellID->95307473]
}, Open  ]],
Cell[66193, 1700, 125, 3, 70, "ExampleDelimiter",
 CellID->287066003],
Cell[66321, 1705, 124, 3, 70, "ExampleText",
 CellID->170966243],
Cell[66448, 1710, 384, 14, 70, "Input",
 CellID->75279197],
Cell[CellGroupData[{
Cell[66857, 1728, 566, 20, 70, "Input",
 CellID->594217891],
Cell[67426, 1750, 158, 5, 36, "Output",
 CellID->503266249]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[67633, 1761, 238, 7, 70, "ExampleSection",
 CellID->171920494],
Cell[67874, 1770, 239, 8, 70, "ExampleText",
 CellID->5053],
Cell[CellGroupData[{
Cell[68138, 1782, 148, 5, 70, "Input",
 CellID->628282426],
Cell[68289, 1789, 188, 6, 36, "Output",
 CellID->434235937]
}, Open  ]],
Cell[CellGroupData[{
Cell[68514, 1800, 116, 4, 70, "Input",
 CellID->6775414],
Cell[68633, 1806, 206, 7, 36, "Output",
 CellID->306195501]
}, Open  ]],
Cell[CellGroupData[{
Cell[68876, 1818, 122, 4, 70, "Input",
 CellID->87508671],
Cell[69001, 1824, 222, 7, 36, "Output",
 CellID->237932815]
}, Open  ]],
Cell[69238, 1834, 125, 3, 70, "ExampleDelimiter",
 CellID->209691398],
Cell[69366, 1839, 125, 3, 70, "ExampleText",
 CellID->918027988],
Cell[CellGroupData[{
Cell[69516, 1846, 201, 7, 70, "Input",
 CellID->15336178],
Cell[69720, 1855, 293, 10, 36, "Output",
 CellID->194383011]
}, Open  ]],
Cell[CellGroupData[{
Cell[70050, 1870, 104, 3, 70, "Input",
 CellID->407988126],
Cell[70157, 1875, 157, 5, 36, "Output",
 CellID->45416170]
}, Open  ]],
Cell[70329, 1883, 124, 3, 70, "ExampleDelimiter",
 CellID->59205322],
Cell[70456, 1888, 599, 23, 70, "ExampleText",
 CellID->181261294],
Cell[CellGroupData[{
Cell[71080, 1915, 252, 8, 70, "Input",
 CellID->668441011],
Cell[71335, 1925, 161, 5, 36, "Output",
 CellID->147625029]
}, Open  ]],
Cell[CellGroupData[{
Cell[71533, 1935, 293, 10, 70, "Input",
 CellID->371465628],
Cell[71829, 1947, 415, 14, 36, "Output",
 CellID->270263776]
}, Open  ]],
Cell[CellGroupData[{
Cell[72281, 1966, 96, 2, 70, "Input",
 CellID->245073739],
Cell[72380, 1970, 189, 7, 55, "Output",
 CellID->37818659]
}, Open  ]],
Cell[72584, 1980, 125, 3, 70, "ExampleDelimiter",
 CellID->356071867],
Cell[72712, 1985, 237, 8, 70, "ExampleText",
 CellID->170415022],
Cell[CellGroupData[{
Cell[72974, 1997, 197, 6, 70, "Input",
 CellID->119229365],
Cell[73174, 2005, 394, 16, 77, "Output",
 CellID->93768047]
}, Open  ]],
Cell[73583, 2024, 124, 3, 70, "ExampleDelimiter",
 CellID->40808168],
Cell[73710, 2029, 74, 1, 70, "ExampleText",
 CellID->376329807],
Cell[CellGroupData[{
Cell[73809, 2034, 381, 12, 70, "Input",
 CellID->337671475],
Cell[74193, 2048, 402, 13, 36, "Output",
 CellID->252377207]
}, Open  ]],
Cell[CellGroupData[{
Cell[74632, 2066, 110, 3, 70, "Input",
 CellID->184083816],
Cell[74745, 2071, 2042, 38, 70, "Output",
 Evaluatable->False,
 CellID->461769073]
}, Open  ]],
Cell[76802, 2112, 125, 3, 70, "ExampleDelimiter",
 CellID->699321042],
Cell[76930, 2117, 71, 1, 70, "ExampleText",
 CellID->350154092],
Cell[CellGroupData[{
Cell[77026, 2122, 312, 11, 70, "Input",
 CellID->114845254],
Cell[77341, 2135, 4454, 77, 70, "Output",
 Evaluatable->False,
 CellID->752470527]
}, Open  ]],
Cell[81810, 2215, 125, 3, 70, "ExampleDelimiter",
 CellID->115139483],
Cell[81938, 2220, 92, 1, 70, "ExampleText",
 CellID->73680],
Cell[CellGroupData[{
Cell[82055, 2225, 397, 13, 70, "Input",
 CellID->30716122],
Cell[82455, 2240, 223, 7, 36, "Output",
 CellID->385887]
}, Open  ]],
Cell[82693, 2250, 125, 3, 70, "ExampleDelimiter",
 CellID->150828770],
Cell[82821, 2255, 73, 1, 70, "ExampleText",
 CellID->222216899],
Cell[CellGroupData[{
Cell[82919, 2260, 238, 9, 70, "Input",
 CellID->69415589],
Cell[83160, 2271, 805, 26, 51, "Output",
 CellID->665329089]
}, Open  ]],
Cell[83980, 2300, 123, 3, 70, "ExampleDelimiter",
 CellID->4885055],
Cell[84106, 2305, 52, 1, 70, "ExampleText",
 CellID->57333213],
Cell[CellGroupData[{
Cell[84183, 2310, 322, 11, 70, "Input",
 CellID->98699071],
Cell[84508, 2323, 1662, 53, 87, "Output",
 CellID->230701068]
}, Open  ]],
Cell[CellGroupData[{
Cell[86207, 2381, 185, 6, 70, "Input",
 CellID->304501825],
Cell[86395, 2389, 590, 20, 59, "Output",
 CellID->773504977]
}, Open  ]],
Cell[87000, 2412, 124, 3, 70, "ExampleDelimiter",
 CellID->95853083],
Cell[87127, 2417, 63, 1, 70, "ExampleText",
 CellID->272581791],
Cell[CellGroupData[{
Cell[87215, 2422, 177, 5, 70, "Input",
 CellID->323216880],
Cell[87395, 2429, 323, 11, 60, "Output",
 CellID->143785977]
}, Open  ]],
Cell[87733, 2443, 125, 3, 70, "ExampleDelimiter",
 CellID->357712387],
Cell[87861, 2448, 206, 8, 70, "ExampleText",
 CellID->174646226],
Cell[CellGroupData[{
Cell[88092, 2460, 480, 17, 70, "Input",
 CellID->4820861],
Cell[88575, 2479, 232, 8, 52, "Output",
 CellID->235858894]
}, Open  ]],
Cell[CellGroupData[{
Cell[88844, 2492, 193, 7, 70, "Input",
 CellID->103698364],
Cell[89040, 2501, 188, 6, 36, "Output",
 CellID->866871980]
}, Open  ]],
Cell[CellGroupData[{
Cell[89265, 2512, 698, 24, 70, "Input",
 CellID->835284590],
Cell[89966, 2538, 268, 8, 51, "Output",
 CellID->102259523]
}, Open  ]],
Cell[90249, 2549, 125, 3, 70, "ExampleDelimiter",
 CellID->776123091],
Cell[90377, 2554, 217, 7, 70, "ExampleText",
 CellID->339811764],
Cell[CellGroupData[{
Cell[90619, 2565, 126, 4, 70, "Input",
 CellID->32865551],
Cell[90748, 2571, 188, 6, 36, "Output",
 CellID->114022547]
}, Open  ]],
Cell[90951, 2580, 126, 3, 70, "ExampleDelimiter",
 CellID->1023561203],
Cell[91080, 2585, 192, 7, 70, "ExampleText",
 CellID->354197540],
Cell[CellGroupData[{
Cell[91297, 2596, 109, 3, 70, "Input",
 CellID->692579997],
Cell[91409, 2601, 246, 8, 36, "Output",
 CellID->104390429]
}, Open  ]],
Cell[CellGroupData[{
Cell[91692, 2614, 157, 5, 70, "Input",
 CellID->2173438],
Cell[91852, 2621, 161, 5, 36, "Output",
 CellID->277162901]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[92062, 2632, 230, 7, 70, "ExampleSection",
 CellID->276477871],
Cell[92295, 2641, 116, 3, 70, "ExampleText",
 CellID->439078054],
Cell[CellGroupData[{
Cell[92436, 2648, 150, 5, 70, "Input",
 CellID->517399705],
Cell[92589, 2655, 227, 7, 36, "Output",
 CellID->139105583]
}, Open  ]],
Cell[92831, 2665, 82, 1, 70, "ExampleText",
 CellID->84090346],
Cell[CellGroupData[{
Cell[92938, 2670, 209, 8, 70, "Input",
 CellID->112567704],
Cell[93150, 2680, 239, 7, 36, "Output",
 CellID->358455784]
}, Open  ]],
Cell[93404, 2690, 125, 3, 70, "ExampleDelimiter",
 CellID->569655838],
Cell[93532, 2695, 237, 8, 70, "ExampleText",
 CellID->70168492],
Cell[CellGroupData[{
Cell[93794, 2707, 209, 8, 70, "Input",
 CellID->45171604],
Cell[94006, 2717, 555, 11, 70, "Message",
 CellID->4055953],
Cell[94564, 2730, 173, 5, 36, "Output",
 CellID->390700654]
}, Open  ]],
Cell[CellGroupData[{
Cell[94774, 2740, 342, 12, 70, "Input",
 CellID->412881078],
Cell[95119, 2754, 239, 7, 36, "Output",
 CellID->148817367]
}, Open  ]],
Cell[95373, 2764, 124, 3, 70, "ExampleDelimiter",
 CellID->20046782],
Cell[95500, 2769, 246, 8, 70, "ExampleText",
 CellID->194590801],
Cell[CellGroupData[{
Cell[95771, 2781, 223, 7, 70, "Input",
 CellID->158266736],
Cell[95997, 2790, 188, 6, 36, "Output",
 CellID->542087677]
}, Open  ]],
Cell[96200, 2799, 124, 3, 70, "ExampleDelimiter",
 CellID->83049014],
Cell[96327, 2804, 159, 4, 70, "ExampleText",
 CellTags->"XRef-2005-4-26-23-37-1.8558342",
 CellID->783338730],
Cell[CellGroupData[{
Cell[96511, 2812, 124, 4, 70, "Input",
 CellID->121794573],
Cell[96638, 2818, 183, 6, 36, "Output",
 CellID->663985374]
}, Open  ]],
Cell[CellGroupData[{
Cell[96858, 2829, 129, 4, 70, "Input",
 CellID->298102691],
Cell[96990, 2835, 188, 6, 36, "Output",
 CellID->294185809]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[97227, 2847, 227, 7, 70, "ExampleSection",
 CellID->90649171],
Cell[97457, 2856, 72, 1, 70, "ExampleText",
 CellID->230991232],
Cell[CellGroupData[{
Cell[97554, 2861, 174, 5, 70, "Input",
 CellID->109238381],
Cell[97731, 2868, 411, 11, 36, "Output",
 CellID->21038295]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[98203, 2886, 311, 9, 70, "SeeAlsoSection",
 CellID->19485],
Cell[98517, 2897, 1409, 53, 70, "SeeAlso",
 CellID->20741]
}, Open  ]],
Cell[CellGroupData[{
Cell[99963, 2955, 314, 9, 70, "TutorialsSection",
 CellID->16984],
Cell[100280, 2966, 181, 4, 70, "Tutorials",
 CellID->4912]
}, Open  ]],
Cell[CellGroupData[{
Cell[100498, 2975, 320, 9, 70, "RelatedLinksSection",
 CellID->1915],
Cell[100821, 2986, 188, 4, 70, "RelatedLinks"],
Cell[101012, 2992, 196, 4, 70, "RelatedLinks"],
Cell[101211, 2998, 382, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[101630, 3016, 317, 9, 70, "MoreAboutSection",
 CellID->1676530],
Cell[101950, 3027, 151, 3, 70, "MoreAbout",
 CellID->441609430],
Cell[102104, 3032, 151, 3, 70, "MoreAbout",
 CellID->629130428],
Cell[102258, 3037, 154, 3, 70, "MoreAbout",
 CellID->69839349]
}, Open  ]],
Cell[102427, 3043, 27, 0, 70, "History"],
Cell[102457, 3045, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

