(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8905,        332]
NotebookOptionsPosition[      6229,        248]
NotebookOutlinePosition[      7708,        288]
CellTagsIndexPosition[      7624,        283]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], " "}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TargetFunctions", "ObjectName",
 CellID->30519],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["TargetFunctions",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/TargetFunctions"]], "InlineFormula"],
     " \[LineSeparator]is an option for functions such as ",
     Cell[BoxData[
      ButtonBox["ComplexExpand",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/ComplexExpand"]], "InlineFormula"],
     " that specifies what functions to attempt to generate in the output."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->6126]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->159340850],

Cell[TextData[{
 "This gives an answer in terms of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Re",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Re"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Im",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Im"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->232849444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"Tan", "[", "z", "]"}], "]"}], ",", "z"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->259679931],

Cell[BoxData[
 FractionBox[
  RowBox[{"Sin", "[", 
   RowBox[{"2", " ", 
    RowBox[{"Re", "[", "z", "]"}]}], "]"}], 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"2", " ", 
     RowBox[{"Re", "[", "z", "]"}]}], "]"}], "+", 
   RowBox[{"Cosh", "[", 
    RowBox[{"2", " ", 
     RowBox[{"Im", "[", "z", "]"}]}], "]"}]}]]], "Output",
 ImageSize->{188, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->71617258]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23166888],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"TargetFunctions", "->", 
   RowBox[{"{", 
    RowBox[{
     ButtonBox["Abs",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Abs"], ",", " ", 
     ButtonBox["Arg",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Arg"]}], "}"}]}]], "InlineFormula"],
 ", the answer is given in terms of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Abs",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Abs"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Arg",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Arg"], "[", 
   StyleBox["z", "TI"], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->928234448],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"Tan", "[", "z", "]"}], "]"}], ",", "z", ",", 
   RowBox[{"TargetFunctions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Abs", ",", "Arg"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->537888765],

Cell[BoxData[
 FractionBox[
  RowBox[{"Sin", "[", 
   RowBox[{"2", " ", 
    RowBox[{"Abs", "[", "z", "]"}], " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"Arg", "[", "z", "]"}], "]"}]}], "]"}], 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"2", " ", 
     RowBox[{"Abs", "[", "z", "]"}], " ", 
     RowBox[{"Cos", "[", 
      RowBox[{"Arg", "[", "z", "]"}], "]"}]}], "]"}], "+", 
   RowBox[{"Cosh", "[", 
    RowBox[{"2", " ", 
     RowBox[{"Abs", "[", "z", "]"}], " ", 
     RowBox[{"Sin", "[", 
      RowBox[{"Arg", "[", "z", "]"}], "]"}]}], "]"}]}]]], "Output",
 ImageSize->{362, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->686626180]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->40937827],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Conjugate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Conjugate"]], "InlineFormula"],
 " as a target function:"
}], "ExampleText",
 CellID->146983311],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComplexExpand", "[", 
  RowBox[{
   RowBox[{"Re", "[", 
    RowBox[{"Tan", "[", "z", "]"}], "]"}], ",", "z", ",", 
   RowBox[{"TargetFunctions", "\[Rule]", "Conjugate"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->259975017],

Cell[BoxData[
 FractionBox[
  RowBox[{"Sin", "[", 
   RowBox[{"z", "+", 
    RowBox[{"Conjugate", "[", "z", "]"}]}], "]"}], 
  RowBox[{
   RowBox[{"Cos", "[", 
    RowBox[{"z", "-", 
     RowBox[{"Conjugate", "[", "z", "]"}]}], "]"}], "+", 
   RowBox[{"Cos", "[", 
    RowBox[{"z", "+", 
     RowBox[{"Conjugate", "[", "z", "]"}]}], "]"}]}]]], "Output",
 ImageSize->{298, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->902919024]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TargetFunctions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 26, 18.2380814}", "context" -> "System`", 
    "keywords" -> {
     "real and imaginary parts", "rectangular form", "polar form", 
      "expanding complex expressions", "complex part expansion", 
      "expanding into complex parts", "complex parts"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "TargetFunctions is an option for functions such as ComplexExpand that \
specifies what functions to attempt to generate in the output.", 
    "synonyms" -> {"target functions"}, "title" -> "TargetFunctions", "type" -> 
    "Symbol", "uri" -> "ref/TargetFunctions"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[1480, 55, 352, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->1]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 7490, 276}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 110, 2, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[733, 29, 53, 1, 70, "ObjectName",
 CellID->30519],
Cell[789, 32, 654, 18, 70, "Usage",
 CellID->6126]
}, Open  ]],
Cell[CellGroupData[{
Cell[1480, 55, 352, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->1],
Cell[CellGroupData[{
Cell[1857, 69, 148, 5, 70, "ExampleSection",
 CellID->159340850],
Cell[2008, 76, 423, 17, 70, "ExampleText",
 CellID->232849444],
Cell[CellGroupData[{
Cell[2456, 97, 194, 6, 28, "Input",
 CellID->259679931],
Cell[2653, 105, 463, 16, 53, "Output",
 CellID->71617258]
}, Open  ]],
Cell[3131, 124, 124, 3, 70, "ExampleDelimiter",
 CellID->23166888],
Cell[3258, 129, 728, 28, 70, "ExampleText",
 CellID->928234448],
Cell[CellGroupData[{
Cell[4011, 161, 303, 9, 28, "Input",
 CellID->537888765],
Cell[4317, 172, 696, 22, 53, "Output",
 CellID->686626180]
}, Open  ]],
Cell[5028, 197, 124, 3, 70, "ExampleDelimiter",
 CellID->40937827],
Cell[5155, 202, 210, 8, 70, "ExampleText",
 CellID->146983311],
Cell[CellGroupData[{
Cell[5390, 214, 256, 7, 70, "Input",
 CellID->259975017],
Cell[5649, 223, 484, 16, 53, "Output",
 CellID->902919024]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[6172, 244, 27, 0, 70, "History"],
Cell[6202, 246, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

