(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13059,        480]
NotebookOptionsPosition[      9605,        362]
NotebookOutlinePosition[     10936,        400]
CellTagsIndexPosition[     10851,        395]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:tutorial/Attributes"], 
          "How Modules Work" :> 
          Documentation`HelpLookup["paclet:tutorial/HowModulesWork"], 
          "Basic Internal Architecture" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/BasicInternalArchitecture"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Attributes\"\>", 2->"\<\"How Modules Work\"\>", 
       3->"\<\"Basic Internal Architecture\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Module" :> Documentation`HelpLookup["paclet:ref/Module"], 
          "Unique" :> Documentation`HelpLookup["paclet:ref/Unique"], 
          "$ModuleNumber" :> 
          Documentation`HelpLookup["paclet:ref/$ModuleNumber"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Module\"\>", 2->"\<\"Unique\"\>", 
       3->"\<\"$ModuleNumber\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Attributes" :> 
          Documentation`HelpLookup["paclet:guide/Attributes"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Attributes\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Temporary", "ObjectName",
 CellID->17295],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Temporary",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Temporary"]], "InlineFormula"],
     "\[LineSeparator]is an attribute assigned to symbols which are created \
as local variables by ",
     Cell[BoxData[
      ButtonBox["Module",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Module"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->25722]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Symbols with attribute ",
 Cell[BoxData[
  ButtonBox["Temporary",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Temporary"]], "InlineFormula"],
 " are automatically removed when they are no longer needed. "
}], "Notes",
 CellID->16983],

Cell[TextData[{
 "Symbols with attribute ",
 Cell[BoxData[
  ButtonBox["Temporary",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Temporary"]], "InlineFormula"],
 " conventionally have names of the form ",
 Cell[BoxData[
  StyleBox[
   RowBox[{
    StyleBox["aaa", "TI"], "$", 
    StyleBox["nnn", "TI"]}]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->6231]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->780170913],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->152534556],

Cell["\<\
Temporary symbols are removed if they are no longer referenced:\
\>", "ExampleText",
 CellID->16188905],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Module", "[", 
  RowBox[{
   RowBox[{"{", "x", "}"}], ",", 
   RowBox[{
    RowBox[{"Print", "[", "x", "]"}], ";", 
    RowBox[{"Attributes", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->409793869],

Cell[BoxData["x$106"], "Print",
 CellLabel->"During evaluation of In[1]:=",
 CellID->53680255],

Cell[BoxData[
 RowBox[{"{", "Temporary", "}"}]], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->162729894]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Names", "[", "\"\<x$*\>\"", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->34703542],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->459958815]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25713],

Cell["Unique new symbols are not temporary:", "ExampleText",
 CellID->356747808],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Unique", "[", "\"\<xx\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->296639682],

Cell[BoxData["xx1"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->793796363]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Attributes", "[", 
  RowBox[{"Evaluate", "[", "%", "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25930788],

Cell[BoxData[
 RowBox[{"{", "}"}]], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->379193891]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17408],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Module",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Module"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Unique",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Unique"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$ModuleNumber",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$ModuleNumber"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15505]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29503],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Attributes"]], "Tutorials",
 CellID->2232],

Cell[TextData[ButtonBox["How Modules Work",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/HowModulesWork"]], "Tutorials",
 CellID->24300],

Cell[TextData[ButtonBox["Basic Internal Architecture",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BasicInternalArchitecture"]], "Tutorials",
 CellID->296377985]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Attributes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Attributes"]], "MoreAbout",
 CellID->88964972]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Temporary - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 26, 18.5037132}", "context" -> "System`", 
    "keywords" -> {
     "garbage collection", "localized variables", "local variables", 
      "temporary symbols", "attribute"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Temporary is an attribute assigned to symbols which are created as local \
variables by Module. ", "synonyms" -> {}, "title" -> "Temporary", "type" -> 
    "Symbol", "uri" -> "ref/Temporary"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4640, 153, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->780170913]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10708, 388}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2188, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2811, 80, 47, 1, 70, "ObjectName",
 CellID->17295],
Cell[2861, 83, 605, 19, 70, "Usage",
 CellID->25722]
}, Open  ]],
Cell[CellGroupData[{
Cell[3503, 107, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3981, 124, 256, 8, 70, "Notes",
 CellID->16983],
Cell[4240, 134, 363, 14, 70, "Notes",
 CellID->6231]
}, Closed]],
Cell[CellGroupData[{
Cell[4640, 153, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->780170913],
Cell[CellGroupData[{
Cell[5025, 167, 148, 5, 70, "ExampleSection",
 CellID->152534556],
Cell[5176, 174, 113, 3, 70, "ExampleText",
 CellID->16188905],
Cell[CellGroupData[{
Cell[5314, 181, 246, 8, 70, "Input",
 CellID->409793869],
Cell[5563, 191, 94, 2, 23, "Print",
 CellID->53680255],
Cell[5660, 195, 188, 6, 36, "Output",
 CellID->162729894]
}, Open  ]],
Cell[CellGroupData[{
Cell[5885, 206, 110, 3, 28, "Input",
 CellID->34703542],
Cell[5998, 211, 175, 6, 36, "Output",
 CellID->459958815]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6222, 223, 233, 7, 70, "ExampleSection",
 CellID->25713],
Cell[6458, 232, 80, 1, 70, "ExampleText",
 CellID->356747808],
Cell[CellGroupData[{
Cell[6563, 237, 111, 3, 70, "Input",
 CellID->296639682],
Cell[6677, 242, 160, 5, 36, "Output",
 CellID->793796363]
}, Open  ]],
Cell[CellGroupData[{
Cell[6874, 252, 140, 4, 70, "Input",
 CellID->25930788],
Cell[7017, 258, 175, 6, 36, "Output",
 CellID->379193891]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7253, 271, 311, 9, 70, "SeeAlsoSection",
 CellID->17408],
Cell[7567, 282, 698, 26, 70, "SeeAlso",
 CellID->15505]
}, Open  ]],
Cell[CellGroupData[{
Cell[8302, 313, 314, 9, 70, "TutorialsSection",
 CellID->29503],
Cell[8619, 324, 130, 3, 70, "Tutorials",
 CellID->2232],
Cell[8752, 329, 141, 3, 70, "Tutorials",
 CellID->24300],
Cell[8896, 334, 167, 3, 70, "Tutorials",
 CellID->296377985]
}, Open  ]],
Cell[CellGroupData[{
Cell[9100, 342, 299, 8, 70, "MoreAboutSection"],
Cell[9402, 352, 131, 3, 70, "MoreAbout",
 CellID->88964972]
}, Open  ]],
Cell[9548, 358, 27, 0, 70, "History"],
Cell[9578, 360, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

