(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    190028,       4598]
NotebookOptionsPosition[    178248,       4198]
NotebookOutlinePosition[    179794,       4239]
CellTagsIndexPosition[    179707,       4234]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Three\[Hyphen]Dimensional Graphics Primitives" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/ThreeDimensionalGraphicsPrimitives"], 
          "Formatted Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormattedOutput"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Three\[Hyphen]Dimensional Graphics Primitives\"\>", 
       2->"\<\"Formatted Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Inset" :> Documentation`HelpLookup["paclet:ref/Inset"], 
          "TextCell" :> Documentation`HelpLookup["paclet:ref/TextCell"], 
          "Row" :> Documentation`HelpLookup["paclet:ref/Row"], "PlotLabel" :> 
          Documentation`HelpLookup["paclet:ref/PlotLabel"], "AxesLabel" :> 
          Documentation`HelpLookup["paclet:ref/AxesLabel"], "Cell" :> 
          Documentation`HelpLookup["paclet:ref/Cell"], "Rotate" :> 
          Documentation`HelpLookup["paclet:ref/Rotate"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Inset\"\>", 2->"\<\"TextCell\"\>", 
       3->"\<\"Row\"\>", 4->"\<\"PlotLabel\"\>", 5->"\<\"AxesLabel\"\>", 
       6->"\<\"Cell\"\>", 7->"\<\"Rotate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "Document Generation" :> 
          Documentation`HelpLookup["paclet:guide/DocumentGeneration"], 
          "Graphics Annotation & Appearance" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsAnnotationAndAppearance"], 
          "Graphics Objects" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsObjects"], 
          "Layout & Tables" :> 
          Documentation`HelpLookup["paclet:guide/LayoutAndTables"], 
          "Mathematical Typesetting" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalTypesetting"], 
          "Options & Styling for Interactive Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:guide/OptionsAndStylingForInteractiveManipulation"], 
          "Stand-Alone Interfaces" :> 
          Documentation`HelpLookup["paclet:guide/StandAloneInterfaces"], 
          "Symbolic Graphics Language" :> 
          Documentation`HelpLookup["paclet:guide/SymbolicGraphicsLanguage"], 
          "Textual Elements in Notebooks" :> 
          Documentation`HelpLookup["paclet:guide/TextualElementsInNotebooks"],
           "New in 6.0: Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60FormattingAndStyling"], 
          "New in 6.0: Notebooks & Documents" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NotebooksAndDocuments"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Document Generation\"\>", 
       2->"\<\"Graphics Annotation & Appearance\"\>", 
       3->"\<\"Graphics Objects\"\>", 4->"\<\"Layout & Tables\"\>", 
       5->"\<\"Mathematical Typesetting\"\>", 
       6->"\<\"Options & Styling for Interactive Manipulation\"\>", 
       7->"\<\"Stand-Alone Interfaces\"\>", 
       8->"\<\"Symbolic Graphics Language\"\>", 
       9->"\<\"Textual Elements in Notebooks\"\>", 
       10->"\<\"New in 6.0: Formatting & Styling\"\>", 
       11->"\<\"New in 6.0: Notebooks & Documents\"\>"}, "\<\"more about\"\>",
        
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Text", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Text",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Text"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]displays with ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " in plain text format. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Text",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Text"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["coords", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]is a graphics primitive that displays the textual form \
of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " centered at the point specified by ",
     Cell[BoxData[
      StyleBox["coords", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->7534]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The text is displayed by default in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", but in a typical textual font such as Times. "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->27770],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Text",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Text"]], "InlineFormula"],
 " can be used in both two\[Hyphen] and three\[Hyphen]dimensional graphics. "
}], "Notes",
 CellID->2851],

Cell[TextData[{
 "In graphics, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Text",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Text"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Text",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Text"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}]}], "]"}]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Text",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Text"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->13997],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Text",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Text"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["coords", "TI"]}], "]"}]], "InlineFormula"],
 " works like ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Inset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inset"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["coords", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->23724],

Cell[TextData[{
 "The coordinates can be specified either as ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 " or as ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Scaled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Scaled"], "[", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->29511],

Cell[TextData[{
 "In two dimensions, coordinates can also be specified using ",
 Cell[BoxData[
  ButtonBox["Offset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Offset"]], "InlineFormula"],
 ". "
}], "Notes",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->20067],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Text",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Text"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["coords", "TI"], ",", 
    StyleBox["offset", "TI"]}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " specifies an offset for the block of text relative to the coordinates \
given. Giving an offset ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["sdx", "TI"], ",", 
    StyleBox["sdy", "TI"]}], "}"}]], "InlineFormula"],
 " specifies that the point ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"]}], "}"}]], "InlineFormula"],
 " should lie at relative coordinates ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["sdx", "TI"], ",", 
    StyleBox["sdy", "TI"]}], "}"}]], "InlineFormula"],
 " within the bounding rectangle that encloses the text. Each relative \
coordinate runs from ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  RowBox[{"+", "1"}]], "InlineFormula"],
 " across the bounding rectangle. "
}], "Notes",
 CellID->30265],

Cell[TextData[{
 "The offsets specified need not be in the range ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  RowBox[{"+", "1"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20840],

Cell["\<\
Sample offsets to use in two\[Hyphen]dimensional graphics include: \
\>", "Notes",
 CellID->3379],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], Cell[TextData[{
     "text centered at ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"]}], "}"}]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "0"}], "}"}], Cell[TextData[{
     "left\[Hyphen]hand end at ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"]}], "}"}]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}], Cell[TextData[{
     "right\[Hyphen]hand end at ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"]}], "}"}]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"-", "1"}]}], "}"}], Cell[TextData[{
     "centered above ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"]}], "}"}]], "InlineFormula"]
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}], Cell[TextData[{
     "centered below ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        StyleBox["y", "TI"]}], "}"}]], "InlineFormula"]
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True, True}}}},
 CellID->24955],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Text",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Text"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["coords", "TI"], ",", 
    StyleBox["offset", "TI"], ",", 
    StyleBox["dir", "TI"]}], "]"}]], "InlineFormula", "TemplateInclusion"],
 " specifies the orientation of the text is given by the direction vector ",
 Cell[BoxData[
  StyleBox["dir", "TI"]], "InlineFormula"],
 ". Possible values of ",
 Cell[BoxData[
  StyleBox["dir", "TI"]], "InlineFormula"],
 " are: "
}], "Notes",
 CellID->16028],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"1", ",", "0"}], "}"}], Cell[
    "ordinary horizontal text ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"0", ",", "1"}], "}"}], Cell[
    "vertical text reading from bottom to top ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{"0", ",", 
      RowBox[{"-", "1"}]}], "}"}], Cell[
    "vertical text reading from top to bottom ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "1"}], ",", "0"}], "}"}], Cell[
    "horizontal upside\[Hyphen]down text ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->1661],

Cell[TextData[{
 "Text in three\[Hyphen]dimensional graphics is placed at a position that \
corresponds to the projection of the point ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["x", "TI"], ",", 
    StyleBox["y", "TI"], ",", 
    StyleBox["z", "TI"]}], "}"}]], "InlineFormula"],
 " specified. Text is drawn in front of all other objects. "
}], "Notes",
 CellID->2432],

Cell["The following options can be given: ", "Notes",
 CellID->18227],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell["background color ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ContentSelectable",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ContentSelectable"], "Automatic", Cell[
    "whether to allow selection of contents", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["FormatType",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/FormatType"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell["format type ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->30160],

Cell[TextData[{
 "Outside of graphics, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Text",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Text"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " effectively generates a ",
 Cell[BoxData[
  ButtonBox["TextCell",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TextCell"]], "InlineFormula"],
 "."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->16139]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->9075239],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->555279681],

Cell["Display an expression in plain text format:", "ExampleText",
 CellID->216767112],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Text", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "+", 
    RowBox[{"2", "x"}], "+", "1"}], "\[Equal]", "0"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->184308727],

Cell[BoxData[
 InterpretationBox[Cell[BoxData[
   RowBox[{
    RowBox[{"1", "+", 
     RowBox[{"2", " ", "x"}], "+", 
     SuperscriptBox["x", "2"]}], "\[Equal]", "0"}]], "Text", "TR"],
  Text[1 + 2 $CellContext`x + $CellContext`x^2 == 0]]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->262892297]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->22555997],

Cell["Display a text in 2D graphics:", "ExampleText",
 CellID->148926],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Circle", "[", "]"}], ",", 
    RowBox[{"Text", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->81498696],

Cell[BoxData[
 GraphicsBox[{CircleBox[{0, 0}], InsetBox[
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], "<", "1"}], {0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->537062667]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->184179247],

Cell["Display a text in 3D graphics:", "ExampleText",
 CellID->414353410],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Sphere", "[", "]"}], ",", 
    RowBox[{"Text", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}], "+", 
        RowBox[{"z", "^", "2"}]}], "<", "1"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0", ",", "0"}], "}"}]}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->68074032],

Cell[BoxData[
 Graphics3DBox[{SphereBox[{0, 0, 0}], Text3DBox[
    FormBox[
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"], "+", 
       SuperscriptBox["z", "2"]}], "<", "1"}], TraditionalForm], {0, 0, 
    0}]}]], "Output",
 ImageSize->{154, 163},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->545087293,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(9)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32514],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Positions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->344564025],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Center",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Center"]], "InlineFormula"],
 " is used for the position in 2D:"
}], "ExampleText",
 CellID->213687093],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Text", "[", "\"\<ABCDEF\>\"", "]"}], ",", 
       RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Text", "[", 
        RowBox[{"\"\<ABCDEF\>\"", ",", "Center"}], "]"}], ",", 
       RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->558256531],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{InsetBox["\<\"ABCDEF\"\>", {0, 0}], CircleBox[{0, 0}]},
    Axes->True,
    Ticks->None], ",", 
   GraphicsBox[{InsetBox["\<\"ABCDEF\"\>", ImageScaled[{0.5, 0.5}]], 
     CircleBox[{0, 0}]},
    Axes->True,
    Ticks->None]}], "}"}]], "Output",
 ImageSize->{230, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->368311552]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  ButtonBox["Center",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Center"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->118282339],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Text", "[", 
      RowBox[{"\"\<ABCDEF\>\"", ",", "Automatic"}], "]"}], ",", 
     RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->124639199],

Cell[BoxData[
 GraphicsBox[{InsetBox["\<\"ABCDEF\"\>", ImageScaled[{0.5, 0.5}]], 
   CircleBox[{0, 0}]},
  Axes->True,
  Ticks->None]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->157930662]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->118917996],

Cell["Specify ordinary coordinates in a graphic:", "ExampleText",
 CellID->24874326],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"2", "Pi", " ", "r"}], ",", 
       RowBox[{"{", 
        RowBox[{".5", ",", ".5"}], "}"}]}], "]"}], ",", 
     RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32481493],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    RowBox[{"2", " ", "\[Pi]", " ", "r"}], {0.5, 0.5}], CircleBox[{0, 0}]},
  Frame->True]], "Output",
 ImageSize->{154, 141},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->23814706]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"4", "Pi", " ", 
        RowBox[{"r", "^", "2"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", ".5", ",", ".5"}], "}"}]}], "]"}], ",", 
     RowBox[{"Sphere", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->267452987],

Cell[BoxData[
 Graphics3DBox[{Text3DBox[
    RowBox[{"4", " ", "\[Pi]", " ", 
     SuperscriptBox["r", "2"]}], {0, 0.5, 0.5}], SphereBox[{0, 0, 0}]},
  Axes->True]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->532993339,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->38706319],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Scaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Scaled"]], "InlineFormula"],
 " coordinates: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->29511]
}], "ExampleText",
 CellID->495232686],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Text", "[", 
     RowBox[{
      RowBox[{"Pi", " ", 
       RowBox[{"r", "^", "2"}]}], ",", 
      RowBox[{"Scaled", "[", 
       RowBox[{"{", 
        RowBox[{".5", ",", ".5"}], "}"}], "]"}]}], "]"}], ",", 
    RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->200217803],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    RowBox[{"\[Pi]", " ", 
     SuperscriptBox["r", "2"]}], Scaled[{0.5, 0.5}]], 
   CircleBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->124218957]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Text", "[", 
     RowBox[{
      RowBox[{"a", "^", "3"}], ",", 
      RowBox[{"Scaled", "[", 
       RowBox[{"{", 
        RowBox[{".5", ",", ".5", ",", "1"}], "}"}], "]"}]}], "]"}], ",", 
    RowBox[{"Cuboid", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4729158],

Cell[BoxData[
 Graphics3DBox[{Text3DBox[
    SuperscriptBox["a", "3"], Scaled[{0.5, 0.5, 1}]], 
   CuboidBox[{0, 0, 0}]}]], "Output",
 ImageSize->{104, 108},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->112595944,
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJzNmPtO2zAUxk3SK73RQqGllEJLC4wBqmCMsbHbH0yatOsbVKwSSJuYGP/v
WbZH2vtUm33sxO5nh6VjaItat0nP7/uOjxPXyavB1dnw0+Dq/HSw8uJy8Pns
/PTLysnFJT/kTzHGPvD3xxrj33/yb/R+PhqNmD8cDke0sZZo2BPeJvnBFdo7
5q3H93z1KY8e8dYPjnKpQIW3SuXQ4Hwe4F1sf7WjDkx1HpUUUQnxO2MycJni
9pSfp9TSIk4kOfp2GYayJsX2QXPaiBUvM3YXYvMiNsW/gPQSRd+FLIqUbRjN
Xx5UtE7cHXApCy5tcroPDSLWwWmWqqfz8kTja2qRqC74zAPly4YQnV0HqJqT
0l6SWoEMF4FKAFUjahm8mkAlIcMFohrg1XJS2ktSdfBqA5UCr3miFoBac1La
S1JzkGEPqDRQVaIq4LUJVAYynCNqRlGB15aT0l6SKhgZCq/d8HqUJyBSs0Tl
IMN+LCoLGe4BlQWqQlRGUdRjJrcD6Ns0VKQcksFVJ6hDJ6X94lE5oGZiUXnI
sDRO8UABuCntJak0eD0AqhBQKqQ4GaW84lFFoAqxqBJUIz8Bpb3iUTNA5Sgu
BdQRUGXIcHoCSnvFoyowXtnJKOXlph7CNYZUJhY1C9WgmvP5dZx6BBnOQr8m
pFSGt0nNQb9St07patyESgB1/HcpVcP/j6pC5ZM3oHygHjspXcN/T5n9kmuM
8Rq6qSNjVSm37z9Gclf7Xqtw31jPyi0pJK65ImhEGK16E8Nw1cvYvqWUBSWc
aQwlI6M+VEKsDwqghLOqW2nHyqhCOnruK8fS2bJ0qpBPPJ0NS6cOOvh/5tZZ
c1SoCUr4f+pWWrUyaoMOrgGkDp1M5uCzZUup51TSo6+WfAl9hLElS2XzD1Tq
lso2qOAqyqVSdVS5Dzr5GDoVK5sDUMFVp0ulZKkcgQqueAMVc5jylspjuCJw
na5UjHMm66jLM2cuOn/PUklZmZyARva3Gr6l8RI0MjA+3lhNGG1C8DVwaScn
sPdQr5TbIRlWXfm8Awe8pwx6J3fDIyKCkwJ+Awp4B+xZ8zvlwwPeAon36ap3
I30HZ/pibRIwLlNEp6z/gy7nkvyzBxXDJxKSpzWdVbUOZ8UAb4CGB1WXGpmI
HnSCHqh9nJncatOOSq5yUgTSrBTxNEfSuWty8YKqOJ46SbpgVbMHfVgTTVLy
6F2MrKVVhYTqgOFdish8Ffgu8WHVQr7sqFvLYFk4nnoOkWQlwrnp6LswFtRU
6Dtn1eypihNnth/GVSNcDo1oISP/6RYs1XsQJ++yao5e7xiRYjjkPW09wn8d
dOUTi4blH/TeV6ryudJShGpDXYW+UpVPDZct1Rq4y2ewrZH9fKYC/m36adVS
zIPzOh1uW3FpcN6iwx1Hf2i2Npx3KbJrKMqLIXDcp997vE3xvUNpN/ULGR3G
HA==\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->183900870],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ImageScaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageScaled"]], "InlineFormula"],
 " specify coordinates in a whole image including padding:"
}], "ExampleText",
 CellID->204734463],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "@", 
  RowBox[{"Graphics", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "2"}], "+", 
          RowBox[{"y", "^", "2"}]}], "\[Equal]", "1"}], ",", 
        RowBox[{"ImageScaled", "[", 
         RowBox[{"{", 
          RowBox[{".5", ",", ".5"}], "}"}], "]"}]}], "]"}], ",", 
      RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
    RowBox[{"ImagePadding", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "50"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31285653],

Cell[BoxData[
 FrameBox[
  GraphicsBox[{InsetBox[
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}], "\[LongEqual]", "1"}], 
     ImageScaled[{0.5, 0.5}]], CircleBox[{0, 0}]},
   ImagePadding->{{0, 50}, {0, 0}}],
  StripOnInput->False]], "Output",
 ImageSize->{164, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->130714573]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->177144847],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Offset",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Offset"]], "InlineFormula"],
 " coordinates in 2D: ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->20067]
}], "ExampleText",
 CellID->295814833],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Text", "[", 
     RowBox[{
      RowBox[{"Pi", " ", 
       RowBox[{"r", "^", "2"}]}], ",", 
      RowBox[{"Offset", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"10", ",", "20"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}]}], "]"}]}], "]"}], ",", 
    RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->567715396],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    RowBox[{"\[Pi]", " ", 
     SuperscriptBox["r", "2"]}], Offset[{10, 20}, {0, 0}]], 
   CircleBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->941670359]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26503835],

Cell["Symbolic positions can be specified:", "ExampleText",
 CellID->127055650],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Text", "[", 
       RowBox[{"\"\<ABCDEF\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"s", ",", "Center"}], "}"}]}], "]"}], ",", 
      RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"Left", ",", "Center", ",", "Right"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->33958350],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{InsetBox["\<\"ABCDEF\"\>", ImageScaled[{0., 0.5}]], 
     CircleBox[{0, 0}]}], ",", 
   GraphicsBox[{InsetBox["\<\"ABCDEF\"\>", ImageScaled[{0.5, 0.5}]], 
     CircleBox[{0, 0}]}], ",", 
   GraphicsBox[{InsetBox["\<\"ABCDEF\"\>", ImageScaled[{1., 0.5}]], 
     CircleBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{341, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->104059849]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Text", "[", 
       RowBox[{"\"\<ABCDEF\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"Center", ",", "s"}], "}"}]}], "]"}], ",", 
      RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"Top", ",", "Center", ",", "Bottom"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->270810687],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{InsetBox["\<\"ABCDEF\"\>", ImageScaled[{0.5, 1.}]], 
     CircleBox[{0, 0}]}], ",", 
   GraphicsBox[{InsetBox["\<\"ABCDEF\"\>", ImageScaled[{0.5, 0.5}]], 
     CircleBox[{0, 0}]}], ",", 
   GraphicsBox[{InsetBox["\<\"ABCDEF\"\>", ImageScaled[{0.5, 0.}]], 
     CircleBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{341, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->238480012]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Offsets and Directions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->54839784],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Center",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Center"]], "InlineFormula"],
 " is used for the alignment position:"
}], "ExampleText",
 CellID->58274548],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Text", "[", 
        RowBox[{"\"\<ABCDEF\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", ".5"}], "}"}]}], "]"}], ",", 
       RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Text", "[", 
        RowBox[{"\"\<ABCDEF\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", ".5"}], "}"}], ",", "Center"}], "]"}], ",", 
       RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->115309776],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{InsetBox["\<\"ABCDEF\"\>", {0, 0.5}], CircleBox[{0, 0}]},
    Axes->True,
    Ticks->None], ",", 
   GraphicsBox[{InsetBox["\<\"ABCDEF\"\>", {0, 0.5}, Center], 
     CircleBox[{0, 0}]},
    Axes->True,
    Ticks->None]}], "}"}]], "Output",
 ImageSize->{230, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->56263953]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  ButtonBox["Center",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Center"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->396420914],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Text", "[", 
      RowBox[{"\"\<ABCDEF\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", ".5"}], "}"}], ",", "Automatic"}], "]"}], ",", 
     RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14736714],

Cell[BoxData[
 GraphicsBox[{InsetBox["\<\"ABCDEF\"\>", {0, 0.5}, Automatic], 
   CircleBox[{0, 0}]},
  Axes->True,
  Ticks->None]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->60503233]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->825626442],

Cell["\<\
Specify an alignment position within the text, using symbolic positions:\
\>", "ExampleText",
 CellID->841860508],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Text", "[", 
        RowBox[{"\"\<ABCDEF\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"p", ",", "Center"}], "}"}]}], "]"}], ",", 
       RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"False", ",", "True"}], "}"}]}], ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"{", 
      RowBox[{"Right", ",", "Center", ",", "Left"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->166865608],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{InsetBox["\<\"ABCDEF\"\>", {0, 0}, {Right, Center}], 
     CircleBox[{0, 0}]},
    Axes->{False, True},
    Ticks->None], ",", 
   GraphicsBox[{InsetBox["\<\"ABCDEF\"\>", {0, 0}, {Center, Center}], 
     CircleBox[{0, 0}]},
    Axes->{False, True},
    Ticks->None], ",", 
   GraphicsBox[{InsetBox["\<\"ABCDEF\"\>", {0, 0}, {Left, Center}], 
     CircleBox[{0, 0}]},
    Axes->{False, True},
    Ticks->None]}], "}"}]], "Output",
 ImageSize->{341, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->687503735]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Text", "[", 
        RowBox[{"\"\<ABCDEF\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"Center", ",", "p"}], "}"}]}], "]"}], ",", 
       RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"True", ",", "False"}], "}"}]}], ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"p", ",", 
     RowBox[{"{", 
      RowBox[{"Top", ",", "Center", ",", "Bottom"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->57894440],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{InsetBox["\<\"ABCDEF\"\>", {0, 0}, {Center, Top}], 
     CircleBox[{0, 0}]},
    Axes->{True, False},
    Ticks->None], ",", 
   GraphicsBox[{InsetBox["\<\"ABCDEF\"\>", {0, 0}, {Center, Center}], 
     CircleBox[{0, 0}]},
    Axes->{True, False},
    Ticks->None], ",", 
   GraphicsBox[{InsetBox["\<\"ABCDEF\"\>", {0, 0}, {Center, Bottom}], 
     CircleBox[{0, 0}]},
    Axes->{True, False},
    Ticks->None]}], "}"}]], "Output",
 ImageSize->{341, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->49121397]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->35811861],

Cell[TextData[{
 "Specify the offsets using ",
 Cell[BoxData[
  FormBox[
   RowBox[{"-", "1"}], TraditionalForm]], "InlineMath"],
 ",",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineMath"],
 " coordinates within the text:"
}], "ExampleText",
 CellID->203416347],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Text", "[", 
        RowBox[{"\"\<ABCDEF\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", "a"}], "]"}], ",", 
       RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", "True"}], ",", 
     RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->293524852],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{InsetBox["\<\"ABCDEF\"\>", {0, 0}, {1, 1}], 
     CircleBox[{0, 0}]},
    Axes->True,
    Ticks->None], ",", 
   GraphicsBox[{InsetBox["\<\"ABCDEF\"\>", {0, 0}, {-1, 1}], 
     CircleBox[{0, 0}]},
    Axes->True,
    Ticks->None], ",", 
   GraphicsBox[{InsetBox["\<\"ABCDEF\"\>", {0, 0}, {-1, -1}], 
     CircleBox[{0, 0}]},
    Axes->True,
    Ticks->None], ",", 
   GraphicsBox[{InsetBox["\<\"ABCDEF\"\>", {0, 0}, {1, -1}], 
     CircleBox[{0, 0}]},
    Axes->True,
    Ticks->None]}], "}"}]], "Output",
 ImageSize->{452, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->29788905]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics3D", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Text", "[", 
       RowBox[{"\"\<ABCDEF\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", "a"}], "]"}], ",", 
      RowBox[{"Sphere", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->4515032],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   Graphics3DBox[{Text3DBox["\<\"ABCDEF\"\>", {0, 0, 0}, {1, 1}], 
     SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[{Text3DBox["\<\"ABCDEF\"\>", {0, 0, 0}, {-1, 1}], 
     SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[{Text3DBox["\<\"ABCDEF\"\>", {0, 0, 0}, {-1, -1}], 
     SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]], ",", 
   Graphics3DBox[{Text3DBox["\<\"ABCDEF\"\>", {0, 0, 0}, {1, -1}], 
     SphereBox[{0, 0, 0}]},
    ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]}], "}"}]], "Output",
 ImageSize->{452, 110},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->444331384]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->55762311],

Cell["Specify the orientation of text, using a vector:", "ExampleText",
 CellID->497699777],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"x", "^", "2"}], "+", 
            RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", "Medium"}], "]"}], 
        ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "0"}], "}"}], ",", "Automatic", ",", "d"}], "]"}], 
      ",", 
      RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"d", ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->285128682],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[{InsetBox[
      StyleBox[
       RowBox[{
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["y", "2"]}], "<", "1"}],
       StripOnInput->False,
       FontSize->Medium], {0, 0}, Automatic, Automatic, {1, 0}], 
     CircleBox[{0, 0}]}], ",", 
   GraphicsBox[{InsetBox[
      StyleBox[
       RowBox[{
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["y", "2"]}], "<", "1"}],
       StripOnInput->False,
       FontSize->Medium], {0, 0}, Automatic, Automatic, {1, 1}], 
     CircleBox[{0, 0}]}], ",", 
   GraphicsBox[{InsetBox[
      StyleBox[
       RowBox[{
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["y", "2"]}], "<", "1"}],
       StripOnInput->False,
       FontSize->Medium], {0, 0}, Automatic, Automatic, {0, 1}], 
     CircleBox[{0, 0}]}], ",", 
   GraphicsBox[{InsetBox[
      StyleBox[
       RowBox[{
        RowBox[{
         SuperscriptBox["x", "2"], "+", 
         SuperscriptBox["y", "2"]}], "<", "1"}],
       StripOnInput->False,
       FontSize->Medium], {0, 0}, Automatic, Automatic, {-1, -1}], 
     CircleBox[{0, 0}]}]}], "}"}]], "Output",
 ImageSize->{452, 102},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->16218407]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17362],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->338732102],

Cell["Specify the background color:", "ExampleText",
 CellID->102474199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Text", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"x", "^", "2"}], "+", 
        RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", 
      RowBox[{"Background", "\[Rule]", "LightRed"}]}], "]"}], ",", 
    RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->488441834],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    RowBox[{
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}], "<", "1"}], {0, 0},
    Background->RGBColor[1, 0.85, 0.85]], CircleBox[{0, 0}]}]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->16640689]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "FormatType",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->261032255],

Cell[TextData[{
 "By default, expressions are displayed using ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->130415530],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Text", "[", 
     RowBox[{"Style", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"x", "^", "2"}], "+", 
         RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", "Medium"}], "]"}], "]"}],
     ",", 
    RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->140419832],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    StyleBox[
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}], "<", "1"}],
     StripOnInput->False,
     FontSize->Medium], {0, 0}], CircleBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->860250519]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->127269120],

Cell[TextData[{
 "Display expressions using ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->260195582],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Text", "[", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"x", "^", "2"}], "+", 
          RowBox[{"y", "^", "2"}]}], "<", "1"}], ",", "Medium"}], "]"}], ",", 
      
      RowBox[{"FormatType", "\[Rule]", "StandardForm"}]}], "]"}], ",", 
    RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->225311832],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    StyleBox[
     RowBox[{
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}], "<", "1"}],
     StripOnInput->False,
     FontSize->Medium], {0, 0},
    FormatType->StandardForm], CircleBox[{0, 0}]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->83861408]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->789048793],

Cell[TextData[{
 "The symbolic positions are relative to ",
 Cell[BoxData[
  ButtonBox["ImageScaled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ImageScaled"]], "InlineFormula"],
 " coordinates:"
}], "ExampleText",
 CellID->42742432],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "@", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Text", "[", 
         RowBox[{"\"\<ABCDEF\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"s", ",", "Center"}], "}"}]}], "]"}], ",", 
        RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
      RowBox[{"ImagePadding", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"10", ",", "40"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}]}], "}"}]}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"Left", ",", "Center", ",", "Right"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->365834959],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    GraphicsBox[{
      TagBox[InsetBox["ABCDEF", ImageScaled[{0., 0.5}]],
       "InsetString"], CircleBox[{0, 0}]},
     ImagePadding->{{10, 40}, {0, 0}}],
    StripOnInput->False], ",", 
   FrameBox[
    GraphicsBox[{
      TagBox[InsetBox["ABCDEF", ImageScaled[{0.5, 0.5}]],
       "InsetString"], CircleBox[{0, 0}]},
     ImagePadding->{{10, 40}, {0, 0}}],
    StripOnInput->False], ",", 
   FrameBox[
    GraphicsBox[{
      TagBox[InsetBox["ABCDEF", ImageScaled[{1., 0.5}]],
       "InsetString"], CircleBox[{0, 0}]},
     ImagePadding->{{10, 40}, {0, 0}}],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{371, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->223973667]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Framed", "@", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Text", "[", 
         RowBox[{"\"\<ABCDEF\>\"", ",", 
          RowBox[{"{", 
           RowBox[{"Center", ",", "s"}], "}"}]}], "]"}], ",", 
        RowBox[{"Circle", "[", "]"}]}], "}"}], ",", 
      RowBox[{"ImagePadding", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"10", ",", "20"}], "}"}]}], "}"}]}]}], "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", 
     RowBox[{"{", 
      RowBox[{"Top", ",", "Center", ",", "Bottom"}], "}"}]}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->806731238],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FrameBox[
    GraphicsBox[{InsetBox["\<\"ABCDEF\"\>", ImageScaled[{0.5, 1.}]], 
      CircleBox[{0, 0}]},
     ImagePadding->{{0, 0}, {10, 20}}],
    StripOnInput->False], ",", 
   FrameBox[
    GraphicsBox[{InsetBox["\<\"ABCDEF\"\>", ImageScaled[{0.5, 0.5}]], 
      CircleBox[{0, 0}]},
     ImagePadding->{{0, 0}, {10, 20}}],
    StripOnInput->False], ",", 
   FrameBox[
    GraphicsBox[{InsetBox["\<\"ABCDEF\"\>", ImageScaled[{0.5, 0.}]], 
      CircleBox[{0, 0}]},
     ImagePadding->{{0, 0}, {10, 20}}],
    StripOnInput->False]}], "}"}]], "Output",
 ImageSize->{371, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[2]=",
 CellID->8731932]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->633180284],

Cell[TextData[{
 "Text styles can be specified by using ",
 Cell[BoxData[
  ButtonBox["Style",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Style"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->282595580],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Text", "[", 
     RowBox[{
      RowBox[{"Style", "[", 
       RowBox[{"\"\<ABCDEF\>\"", ",", "Large", ",", "Bold", ",", "Red"}], 
       "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "0"}], "}"}], ",", "Automatic", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "1"}], "}"}]}], "]"}], ",", 
    RowBox[{"Circle", "[", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->463815318],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    StyleBox["\<\"ABCDEF\"\>",
     StripOnInput->False,
     FrontFaceColor->RGBColor[1, 0, 0],
     BackFaceColor->RGBColor[1, 0, 0],
     GraphicsColor->RGBColor[1, 0, 0],
     FontSize->Large,
     FontWeight->Bold,
     FontColor->RGBColor[1, 0, 0]], {0, 0}, Automatic, Automatic, {2, 1}], 
   CircleBox[{0, 0}]}]], "Output",
 ImageSize->{154, 150},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->275750630]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10466],

Cell["Random collage of text:", "ExampleText",
 CellID->25885965],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Text", "[", 
      RowBox[{
       RowBox[{"Style", "[", 
        RowBox[{"\"\<Mathematica\>\"", ",", 
         RowBox[{"Hue", "[", 
          RowBox[{"RandomReal", "[", "]"}], "]"}], ",", "Italic", ",", 
         RowBox[{"RandomInteger", "[", 
          RowBox[{"{", 
           RowBox[{"10", ",", "30"}], "}"}], "]"}]}], "]"}], ",", 
       RowBox[{"RandomReal", "[", 
        RowBox[{"1", ",", 
         RowBox[{"{", "2", "}"}]}], "]"}], ",", "Automatic", ",", 
       RowBox[{"RandomReal", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
         RowBox[{"{", "2", "}"}]}], "]"}]}], "]"}], ",", 
     RowBox[{"{", "20", "}"}]}], "]"}], ",", 
   RowBox[{"AspectRatio", "\[Rule]", 
    RowBox[{"1", "/", "GoldenRatio"}]}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "300"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->341600935],

Cell[BoxData[
 GraphicsBox[{InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.5314217035339781],
     BackFaceColor->Hue[0.5314217035339781],
     GraphicsColor->Hue[0.5314217035339781],
     FontSize->18,
     FontSlant->Italic,
     FontColor->Hue[0.5314217035339781]], {0.7129526413314027, 0.526455302954075},
     Automatic, Automatic, {0.18850786088976612`, -0.8148363451262317}], 
   InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.7872346433266619],
     BackFaceColor->Hue[0.7872346433266619],
     GraphicsColor->Hue[0.7872346433266619],
     FontSize->23,
     FontSlant->Italic,
     FontColor->Hue[0.7872346433266619]], {0.8938516158443051, 0.6125143796337156},
     Automatic, Automatic, {0.8209769140969048, 0.5806822446880151}], 
   InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.4704146560736453],
     BackFaceColor->Hue[0.4704146560736453],
     GraphicsColor->Hue[0.4704146560736453],
     FontSize->20,
     FontSlant->Italic,
     FontColor->Hue[0.4704146560736453]], {0.41371197954517, 0.41706102899415765`},
     Automatic, Automatic, {-0.516369185949602, -0.3688857954522793}], 
   InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.7286472717440724],
     BackFaceColor->Hue[0.7286472717440724],
     GraphicsColor->Hue[0.7286472717440724],
     FontSize->17,
     FontSlant->Italic,
     FontColor->Hue[0.7286472717440724]], {0.7390744368711604, 0.29681307725690953`},
     Automatic, Automatic, {-0.01200272532076907, 0.4512548755771819}], 
   InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.2556552136900443],
     BackFaceColor->Hue[0.2556552136900443],
     GraphicsColor->Hue[0.2556552136900443],
     FontSize->13,
     FontSlant->Italic,
     FontColor->Hue[0.2556552136900443]], {0.37846930281484736`, 0.5833916641036747},
     Automatic, Automatic, {-0.5170161312715416, -0.0047346280059286094`}], 
   InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.6611651952050253],
     BackFaceColor->Hue[0.6611651952050253],
     GraphicsColor->Hue[0.6611651952050253],
     FontSize->29,
     FontSlant->Italic,
     FontColor->Hue[0.6611651952050253]], {0.16736462248077077`, 0.39931760099198566`},
     Automatic, Automatic, {-0.5108973013652469, 0.4117910312114903}], 
   InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.4251951313502256],
     BackFaceColor->Hue[0.4251951313502256],
     GraphicsColor->Hue[0.4251951313502256],
     FontSize->27,
     FontSlant->Italic,
     FontColor->Hue[0.4251951313502256]], {0.25919026499808284`, 0.7950053991175605},
     Automatic, Automatic, {-0.7474994200321352, -0.30865886946922183`}], 
   InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.25828615883467587`],
     BackFaceColor->Hue[0.25828615883467587`],
     GraphicsColor->Hue[0.25828615883467587`],
     FontSize->14,
     FontSlant->Italic,
     FontColor->Hue[0.25828615883467587`]], {0.8245872750859164, 0.8260272993854163},
     Automatic, Automatic, {0.6714085035398121, -0.18448748136673654`}], 
   InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.655625511315836],
     BackFaceColor->Hue[0.655625511315836],
     GraphicsColor->Hue[0.655625511315836],
     FontSize->28,
     FontSlant->Italic,
     FontColor->Hue[0.655625511315836]], {0.38207658364432184`, 0.29424810503853416`},
     Automatic, Automatic, {-0.2060142671982197, -0.5049425651957886}], 
   InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.4862691961224219],
     BackFaceColor->Hue[0.4862691961224219],
     GraphicsColor->Hue[0.4862691961224219],
     FontSize->11,
     FontSlant->Italic,
     FontColor->Hue[0.4862691961224219]], {0.6323217679816122, 0.8738007491961473},
     Automatic, Automatic, {0.0044047713660693155`, 0.5718618258483468}], 
   InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.7647008041200978],
     BackFaceColor->Hue[0.7647008041200978],
     GraphicsColor->Hue[0.7647008041200978],
     FontSize->23,
     FontSlant->Italic,
     FontColor->Hue[0.7647008041200978]], {0.015129479173138227`, 0.3729139758861948},
     Automatic, Automatic, {0.24604976810888424`, -0.6134204548800768}], 
   InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.05408219302573247],
     BackFaceColor->Hue[0.05408219302573247],
     GraphicsColor->Hue[0.05408219302573247],
     FontSize->28,
     FontSlant->Italic,
     FontColor->Hue[0.05408219302573247]], {0.686554507544646, 0.15019094224518148`},
     Automatic, Automatic, {0.5302619270258027, -0.08920522328678882}], 
   InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.7620445248741843],
     BackFaceColor->Hue[0.7620445248741843],
     GraphicsColor->Hue[0.7620445248741843],
     FontSize->21,
     FontSlant->Italic,
     FontColor->Hue[0.7620445248741843]], {0.7808995115123201, 0.11744846959270072`},
     Automatic, Automatic, {0.5398324807049706, 0.99116055951378}], InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.11049393367032101`],
     BackFaceColor->Hue[0.11049393367032101`],
     GraphicsColor->Hue[0.11049393367032101`],
     FontSize->24,
     FontSlant->Italic,
     FontColor->Hue[0.11049393367032101`]], {0.5077021423225154, 0.16502811185447674`},
     Automatic, Automatic, {0.6477396076608444, -0.9848476022396961}], 
   InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.6328429339319741],
     BackFaceColor->Hue[0.6328429339319741],
     GraphicsColor->Hue[0.6328429339319741],
     FontSize->25,
     FontSlant->Italic,
     FontColor->Hue[0.6328429339319741]], {0.9953367531580086, 0.634991162232259},
     Automatic, Automatic, {0.5042212871410978, -0.4491737586466882}], 
   InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.3985197221950334],
     BackFaceColor->Hue[0.3985197221950334],
     GraphicsColor->Hue[0.3985197221950334],
     FontSize->19,
     FontSlant->Italic,
     FontColor->Hue[0.3985197221950334]], {0.7191132795550437, 0.030933713978504196`},
     Automatic, Automatic, {-0.3832119833453951, 0.5239795777165814}], 
   InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.016709802836285315`],
     BackFaceColor->Hue[0.016709802836285315`],
     GraphicsColor->Hue[0.016709802836285315`],
     FontSize->25,
     FontSlant->Italic,
     FontColor->Hue[0.016709802836285315`]], {0.14214006786020672`, 0.17407606987353463`},
     Automatic, Automatic, {-0.7418786150380616, 0.16594930609485425`}], 
   InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.8594297045843697],
     BackFaceColor->Hue[0.8594297045843697],
     GraphicsColor->Hue[0.8594297045843697],
     FontSize->13,
     FontSlant->Italic,
     FontColor->Hue[0.8594297045843697]], {0.19205539474026634`, 0.4655835833898412},
     Automatic, Automatic, {-0.7544407419656407, -0.41513729233479335`}], 
   InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.1759401989530176],
     BackFaceColor->Hue[0.1759401989530176],
     GraphicsColor->Hue[0.1759401989530176],
     FontSize->14,
     FontSlant->Italic,
     FontColor->Hue[0.1759401989530176]], {0.22634399113381942`, 0.41878982554545985`},
     Automatic, Automatic, {0.5451409897989912, 0.5791605763000756}], 
   InsetBox[
    StyleBox["\<\"Mathematica\"\>",
     StripOnInput->False,
     FrontFaceColor->Hue[0.8302773423546661],
     BackFaceColor->Hue[0.8302773423546661],
     GraphicsColor->Hue[0.8302773423546661],
     FontSize->19,
     FontSlant->Italic,
     FontColor->Hue[0.8302773423546661]], {0.032005153936866426`, 0.8995125133051116},
     Automatic, Automatic, {0.2997098632948809, 0.5816150880461648}]},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  ImageSize->300]], "Output",
 ImageSize->{304, 214},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->417701376]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->7048],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Inset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inset"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TextCell",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TextCell"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Row",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Row"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PlotLabel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PlotLabel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AxesLabel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AxesLabel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cell",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cell"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Rotate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Rotate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25565]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32666],

Cell[TextData[ButtonBox["Three\[Hyphen]Dimensional Graphics Primitives",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/ThreeDimensionalGraphicsPrimitives"]], "Tutorials",
 CellID->595610080],

Cell[TextData[ButtonBox["Formatted Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormattedOutput"]], "Tutorials",
 CellID->175077611]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Text",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Text"], None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->676276535],

Cell[TextData[ButtonBox["Document Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DocumentGeneration"]], "MoreAbout",
 CellID->48151217],

Cell[TextData[ButtonBox["Graphics Annotation & Appearance",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsAnnotationAndAppearance"]], "MoreAbout",
 CellID->356887431],

Cell[TextData[ButtonBox["Graphics Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsObjects"]], "MoreAbout",
 CellID->734938253],

Cell[TextData[ButtonBox["Layout & Tables",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LayoutAndTables"]], "MoreAbout",
 CellID->144176792],

Cell[TextData[ButtonBox["Mathematical Typesetting",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalTypesetting"]], "MoreAbout",
 CellID->319467663],

Cell[TextData[ButtonBox["Options & Styling for Interactive Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/OptionsAndStylingForInteractiveManipulation"]], "MoreAbout",
 CellID->33272940],

Cell[TextData[ButtonBox["Stand-Alone Interfaces",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StandAloneInterfaces"]], "MoreAbout",
 CellID->360925198],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "MoreAbout",
 CellID->169874837],

Cell[TextData[ButtonBox["Textual Elements in Notebooks",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TextualElementsInNotebooks"]], "MoreAbout",
 CellID->231260894],

Cell[TextData[ButtonBox["New in 6.0: Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60FormattingAndStyling"]], "MoreAbout",
 CellID->496320376],

Cell[TextData[ButtonBox["New in 6.0: Notebooks & Documents",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NotebooksAndDocuments"]], "MoreAbout",
 CellID->270358377]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Text - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 26, 28.7070994}", "context" -> "System`", 
    "keywords" -> {
     "text in graphics", "text in 3D graphics", "text in notebooks", 
      "formulae in graphics", "formulae in 3D graphics", 
      "formulae in notebooks", "textual form in graphics", 
      "textual form in 3D graphics", "textual form in notebooks"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Text[expr] displays with expr in plain text format. Text[expr, coords] \
is a graphics primitive that displays the textual form of expr centered at \
the point specified by coords. ", "synonyms" -> {}, "title" -> "Text", "type" -> 
    "Symbol", "uri" -> "ref/Text"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[21089, 619, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->9075239]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 179565, 4227}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 4290, 90, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[4913, 117, 4188, 83, 70, "ObjectNameGrid"],
Cell[9104, 202, 1116, 36, 70, "Usage",
 CellID->7534]
}, Open  ]],
Cell[CellGroupData[{
Cell[10257, 243, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[10735, 260, 393, 11, 70, "Notes",
 CellID->27770],
Cell[11131, 273, 232, 7, 70, "Notes",
 CellID->2851],
Cell[11366, 282, 886, 33, 70, "Notes",
 CellID->13997],
Cell[12255, 317, 631, 23, 70, "Notes",
 CellID->23724],
Cell[12889, 342, 607, 22, 70, "Notes",
 CellID->29511],
Cell[13499, 366, 277, 9, 70, "Notes",
 CellID->20067],
Cell[13779, 377, 1137, 39, 70, "Notes",
 CellID->30265],
Cell[14919, 418, 223, 9, 70, "Notes",
 CellID->20840],
Cell[15145, 429, 107, 3, 70, "Notes",
 CellID->3379],
Cell[15255, 434, 1995, 62, 70, "2ColumnTableMod",
 CellID->24955],
Cell[17253, 498, 581, 19, 70, "Notes",
 CellID->16028],
Cell[17837, 519, 1081, 28, 70, "2ColumnTableMod",
 CellID->1661],
Cell[18921, 549, 384, 11, 70, "Notes",
 CellID->2432],
Cell[19308, 562, 69, 1, 70, "Notes",
 CellID->18227],
Cell[19380, 565, 1150, 29, 70, "3ColumnTableMod",
 CellID->30160],
Cell[20533, 596, 519, 18, 70, "Notes",
 CellID->16139]
}, Closed]],
Cell[CellGroupData[{
Cell[21089, 619, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->9075239],
Cell[CellGroupData[{
Cell[21472, 633, 148, 5, 70, "ExampleSection",
 CellID->555279681],
Cell[21623, 640, 86, 1, 70, "ExampleText",
 CellID->216767112],
Cell[CellGroupData[{
Cell[21734, 645, 209, 7, 28, "Input",
 CellID->184308727],
Cell[21946, 654, 381, 11, 36, "Output",
 CellID->262892297]
}, Open  ]],
Cell[22342, 668, 124, 3, 70, "ExampleDelimiter",
 CellID->22555997],
Cell[22469, 673, 70, 1, 70, "ExampleText",
 CellID->148926],
Cell[CellGroupData[{
Cell[22564, 678, 407, 14, 70, "Input",
 CellID->81498696],
Cell[22974, 694, 373, 11, 121, "Output",
 CellID->537062667]
}, Open  ]],
Cell[23362, 708, 125, 3, 70, "ExampleDelimiter",
 CellID->184179247],
Cell[23490, 713, 73, 1, 70, "ExampleText",
 CellID->414353410],
Cell[CellGroupData[{
Cell[23588, 718, 461, 16, 70, "Input",
 CellID->68074032],
Cell[24052, 736, 27748, 463, 184, 277, 8, "CachedBoxData", "BoxData", \
"Output",
 CellID->545087293]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[51849, 1205, 216, 7, 70, "ExampleSection",
 CellID->32514],
Cell[CellGroupData[{
Cell[52090, 1216, 230, 7, 70, "ExampleSubsection",
 CellID->344564025],
Cell[52323, 1225, 222, 8, 70, "ExampleText",
 CellID->213687093],
Cell[CellGroupData[{
Cell[52570, 1237, 742, 22, 70, "Input",
 CellID->558256531],
Cell[53315, 1261, 484, 15, 123, "Output",
 CellID->368311552]
}, Open  ]],
Cell[53814, 1279, 318, 12, 70, "ExampleText",
 CellID->118282339],
Cell[CellGroupData[{
Cell[54157, 1295, 372, 11, 70, "Input",
 CellID->124639199],
Cell[54532, 1308, 329, 10, 121, "Output",
 CellID->157930662]
}, Open  ]],
Cell[54876, 1321, 125, 3, 70, "ExampleDelimiter",
 CellID->118917996],
Cell[55004, 1326, 84, 1, 70, "ExampleText",
 CellID->24874326],
Cell[CellGroupData[{
Cell[55113, 1331, 397, 13, 70, "Input",
 CellID->32481493],
Cell[55513, 1346, 323, 9, 162, "Output",
 CellID->23814706]
}, Open  ]],
Cell[CellGroupData[{
Cell[55873, 1360, 438, 14, 70, "Input",
 CellID->267452987],
Cell[56314, 1376, 23864, 397, 194, 175, 4, "CachedBoxData", "BoxData", \
"Output",
 CellID->532993339]
}, Open  ]],
Cell[80193, 1776, 124, 3, 70, "ExampleDelimiter",
 CellID->38706319],
Cell[80320, 1781, 279, 11, 70, "ExampleText",
 CellID->495232686],
Cell[CellGroupData[{
Cell[80624, 1796, 392, 13, 70, "Input",
 CellID->200217803],
Cell[81019, 1811, 338, 10, 121, "Output",
 CellID->124218957]
}, Open  ]],
Cell[CellGroupData[{
Cell[81394, 1826, 373, 12, 70, "Input",
 CellID->4729158],
Cell[81770, 1840, 1846, 36, 129, 133, 3, "CachedBoxData", "BoxData", "Output",
 
 CellID->112595944]
}, Open  ]],
Cell[83631, 1879, 125, 3, 70, "ExampleDelimiter",
 CellID->183900870],
Cell[83759, 1884, 239, 7, 70, "ExampleText",
 CellID->204734463],
Cell[CellGroupData[{
Cell[84023, 1895, 746, 24, 70, "Input",
 CellID->31285653],
Cell[84772, 1921, 483, 15, 133, "Output",
 CellID->130714573]
}, Open  ]],
Cell[85270, 1939, 125, 3, 70, "ExampleDelimiter",
 CellID->177144847],
Cell[85398, 1944, 285, 11, 70, "ExampleText",
 CellID->295814833],
Cell[CellGroupData[{
Cell[85708, 1959, 481, 16, 70, "Input",
 CellID->567715396],
Cell[86192, 1977, 344, 10, 121, "Output",
 CellID->941670359]
}, Open  ]],
Cell[86551, 1990, 124, 3, 70, "ExampleDelimiter",
 CellID->26503835],
Cell[86678, 1995, 79, 1, 70, "ExampleText",
 CellID->127055650],
Cell[CellGroupData[{
Cell[86782, 2000, 509, 17, 70, "Input",
 CellID->33958350],
Cell[87294, 2019, 541, 14, 123, "Output",
 CellID->104059849]
}, Open  ]],
Cell[CellGroupData[{
Cell[87872, 2038, 510, 17, 70, "Input",
 CellID->270810687],
Cell[88385, 2057, 541, 14, 123, "Output",
 CellID->238480012]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[88975, 2077, 242, 7, 70, "ExampleSubsection",
 CellID->54839784],
Cell[89220, 2086, 225, 8, 70, "ExampleText",
 CellID->58274548],
Cell[CellGroupData[{
Cell[89470, 2098, 905, 27, 70, "Input",
 CellID->115309776],
Cell[90378, 2127, 478, 15, 123, "Output",
 CellID->56263953]
}, Open  ]],
Cell[90871, 2145, 318, 12, 70, "ExampleText",
 CellID->396420914],
Cell[CellGroupData[{
Cell[91214, 2161, 439, 13, 70, "Input",
 CellID->14736714],
Cell[91656, 2176, 324, 10, 121, "Output",
 CellID->60503233]
}, Open  ]],
Cell[91995, 2189, 125, 3, 70, "ExampleDelimiter",
 CellID->825626442],
Cell[92123, 2194, 123, 3, 70, "ExampleText",
 CellID->841860508],
Cell[CellGroupData[{
Cell[92271, 2201, 759, 24, 70, "Input",
 CellID->166865608],
Cell[93033, 2227, 669, 20, 123, "Output",
 CellID->687503735]
}, Open  ]],
Cell[CellGroupData[{
Cell[93739, 2252, 758, 24, 70, "Input",
 CellID->57894440],
Cell[94500, 2278, 668, 20, 123, "Output",
 CellID->49121397]
}, Open  ]],
Cell[95183, 2301, 124, 3, 70, "ExampleDelimiter",
 CellID->35811861],
Cell[95310, 2306, 271, 10, 70, "ExampleText",
 CellID->203416347],
Cell[CellGroupData[{
Cell[95606, 2320, 957, 31, 70, "Input",
 CellID->293524852],
Cell[96566, 2353, 798, 25, 123, "Output",
 CellID->29788905]
}, Open  ]],
Cell[CellGroupData[{
Cell[97401, 2383, 848, 28, 70, "Input",
 CellID->4515032],
Cell[98252, 2413, 52243, 868, 131, "Output",
 CellID->444331384]
}, Open  ]],
Cell[150510, 3284, 124, 3, 70, "ExampleDelimiter",
 CellID->55762311],
Cell[150637, 3289, 91, 1, 70, "ExampleText",
 CellID->497699777],
Cell[CellGroupData[{
Cell[150753, 3294, 1011, 34, 70, "Input",
 CellID->285128682],
Cell[151767, 3330, 1402, 44, 123, "Output",
 CellID->16218407]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[153230, 3381, 218, 7, 70, "ExampleSection",
 CellID->17362],
Cell[CellGroupData[{
Cell[153473, 3392, 231, 7, 70, "ExampleSubsection",
 CellID->338732102],
Cell[153707, 3401, 72, 1, 70, "ExampleText",
 CellID->102474199],
Cell[CellGroupData[{
Cell[153804, 3406, 402, 13, 70, "Input",
 CellID->488441834],
Cell[154209, 3421, 413, 12, 171, "Output",
 CellID->16640689]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[154671, 3439, 231, 7, 70, "ExampleSubsection",
 CellID->261032255],
Cell[154905, 3448, 241, 8, 70, "ExampleText",
 CellID->130415530],
Cell[CellGroupData[{
Cell[155171, 3460, 403, 14, 70, "Input",
 CellID->140419832],
Cell[155577, 3476, 441, 14, 121, "Output",
 CellID->860250519]
}, Open  ]],
Cell[156033, 3493, 125, 3, 70, "ExampleDelimiter",
 CellID->127269120],
Cell[156161, 3498, 217, 8, 70, "ExampleText",
 CellID->260195582],
Cell[CellGroupData[{
Cell[156403, 3510, 490, 16, 70, "Input",
 CellID->225311832],
Cell[156896, 3528, 470, 15, 121, "Output",
 CellID->83861408]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[157427, 3550, 237, 7, 70, "ExampleSection",
 CellID->789048793],
Cell[157667, 3559, 239, 8, 70, "ExampleText",
 CellID->42742432],
Cell[CellGroupData[{
Cell[157931, 3571, 805, 26, 70, "Input",
 CellID->365834959],
Cell[158739, 3599, 846, 26, 83, "Output",
 CellID->223973667]
}, Open  ]],
Cell[CellGroupData[{
Cell[159622, 3630, 805, 26, 70, "Input",
 CellID->806731238],
Cell[160430, 3658, 779, 23, 163, "Output",
 CellID->8731932]
}, Open  ]],
Cell[161224, 3684, 125, 3, 70, "ExampleDelimiter",
 CellID->633180284],
Cell[161352, 3689, 215, 8, 70, "ExampleText",
 CellID->282595580],
Cell[CellGroupData[{
Cell[161592, 3701, 492, 15, 70, "Input",
 CellID->463815318],
Cell[162087, 3718, 552, 16, 171, "Output",
 CellID->275750630]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[162688, 3740, 224, 7, 70, "ExampleSection",
 CellID->10466],
Cell[162915, 3749, 65, 1, 70, "ExampleText",
 CellID->25885965],
Cell[CellGroupData[{
Cell[163005, 3754, 1014, 28, 70, "Input",
 CellID->341600935],
Cell[164022, 3784, 8526, 206, 235, "Output",
 CellID->417701376]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[172609, 3997, 310, 9, 70, "SeeAlsoSection",
 CellID->7048],
Cell[172922, 4008, 1652, 62, 70, "SeeAlso",
 CellID->25565]
}, Open  ]],
Cell[CellGroupData[{
Cell[174611, 4075, 314, 9, 70, "TutorialsSection",
 CellID->32666],
Cell[174928, 4086, 197, 4, 70, "Tutorials",
 CellID->595610080],
Cell[175128, 4092, 146, 3, 70, "Tutorials",
 CellID->175077611]
}, Open  ]],
Cell[CellGroupData[{
Cell[175311, 4100, 305, 8, 70, "RelatedLinksSection"],
Cell[175619, 4110, 348, 11, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[176004, 4126, 319, 9, 70, "MoreAboutSection",
 CellID->676276535],
Cell[176326, 4137, 148, 3, 70, "MoreAbout",
 CellID->48151217],
Cell[176477, 4142, 175, 3, 70, "MoreAbout",
 CellID->356887431],
Cell[176655, 4147, 143, 3, 70, "MoreAbout",
 CellID->734938253],
Cell[176801, 4152, 142, 3, 70, "MoreAbout",
 CellID->144176792],
Cell[176946, 4157, 159, 3, 70, "MoreAbout",
 CellID->319467663],
Cell[177108, 4162, 203, 4, 70, "MoreAbout",
 CellID->33272940],
Cell[177314, 4168, 154, 3, 70, "MoreAbout",
 CellID->360925198],
Cell[177471, 4173, 162, 3, 70, "MoreAbout",
 CellID->169874837],
Cell[177636, 4178, 167, 3, 70, "MoreAbout",
 CellID->231260894],
Cell[177806, 4183, 171, 3, 70, "MoreAbout",
 CellID->496320376],
Cell[177980, 4188, 173, 3, 70, "MoreAbout",
 CellID->270358377]
}, Open  ]],
Cell[178168, 4194, 50, 0, 70, "History"],
Cell[178221, 4196, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

