(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19810,        675]
NotebookOptionsPosition[     15648,        534]
NotebookOutlinePosition[     17070,        573]
CellTagsIndexPosition[     16985,        568]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Cells as Mathematica Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/CellsAsMathematicaExpressions"], 
          "Text and Font Options" :> 
          Documentation`HelpLookup["paclet:tutorial/TextAndFontOptions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Cells as Mathematica Expressions\"\>", 
       2->"\<\"Text and Font Options\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TextJustification" :> 
          Documentation`HelpLookup["paclet:ref/TextJustification"], 
          "Alignment" :> Documentation`HelpLookup["paclet:ref/Alignment"], 
          "ColumnAlignments" :> 
          Documentation`HelpLookup["paclet:ref/ColumnAlignments"], 
          "PageWidth" :> Documentation`HelpLookup["paclet:ref/PageWidth"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"TextJustification\"\>", 
       2->"\<\"Alignment\"\>", 3->"\<\"ColumnAlignments\"\>", 
       4->"\<\"PageWidth\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Stylesheets" :> 
          Documentation`HelpLookup["paclet:guide/Stylesheets"], 
          "Text Layout Options" :> 
          Documentation`HelpLookup["paclet:guide/TextLayoutOptions"], 
          "Text Styling" :> 
          Documentation`HelpLookup["paclet:guide/TextStyling"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Stylesheets\"\>", 
       2->"\<\"Text Layout Options\"\>", 
       3->"\<\"Text Styling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TextAlignment", "ObjectName",
 CellID->2885],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["TextAlignment",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/TextAlignment"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Cell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Pane",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Pane"]], "InlineFormula"],
     " and related constructs which specifies how successive lines of text \
should be aligned. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14439]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["Possible settings are: ", "Notes",
 CellID->2718],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Left",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Left"]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      RowBox[{"-", "1"}]], "InlineFormula"],
     " "
    }], "TableText"], Cell["aligned on the left ", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Right",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Right"]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      RowBox[{"+", "1"}]], "InlineFormula"],
     " "
    }], "TableText"], Cell["aligned on the right ", "TableText"]},
   {Cell["      ", "TableRowIcon"], Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Center",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Center"]], "InlineFormula"],
     " or ",
     Cell[BoxData["0"], "InlineFormula"],
     " "
    }], "TableText"], Cell["centered ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["x", "TI"], Cell[TextData[{
     "lined up at position ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " across the page "
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->9107],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TextAlignment",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TextAlignment"]], "InlineFormula"],
 " can be used both for ordinary text and for ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. "
}], "Notes",
 CellID->5268]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->18404503],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->173469784],

Cell["Align on the left:", "ExampleText",
 CellID->827890818],

Cell[BoxData[
 RowBox[{
  RowBox[{"t", "=", 
   RowBox[{"StringJoin", "@@", 
    RowBox[{"Table", "[", 
     RowBox[{"\"\<abcd \>\"", ",", 
      RowBox[{"{", "60", "}"}]}], "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->367642920],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "@", 
  RowBox[{"Text", "[", 
   RowBox[{"Style", "[", 
    RowBox[{"t", ",", 
     RowBox[{"TextAlignment", "\[Rule]", "Left"}]}], "]"}], "]"}]}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->341845274],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnd1OwjAYQLsfYBd6h8m84wmI8QEEb/TKh1iICVwYDfL+tV3bMUYxMRvS
jbNk0Pb7ztGYWgr9Et6K3fr9o9htVsXsdVt8rTer79nL51YNJZEQ8YMQ4ikX
qi1Vq7zd9ahu1U+yLBPmcilzdUdmOKmICpyrOzLAoKN36iHVY6n5Q9kE1Ynt
88gGySKrD1lL7zyf6ofxvl82LOXyNBI3+vW4bsZ48ODBg6fkFrLNalsu5KMq
rz4KDQ0N3TH9LE+9C0qEkxhFc+Xz+0aQkJCQNdK/xkwPc51RHO+xfP34+Kdh
wIABQ1CG0/urypLuKbO4JjW+vtqmUFBQg6CW0rcu3Mv9KqKbN43+hDjxFvGF
ZNYRD2PW5dKsirf2OaP/a9+/k5T2CquK4nxR6jPIGlaWfydIfQYePHjwdOtZ
SOozoKGh+0FTnwEJCXlOkvoMDBgwXKOB+gwoKKgmtZSclBMP46ScWUf8/2cd
9RnUZ/w9ql9CQzxlJ4usvmRNvP9ZoZ2k4sGDBw+eMD1j2eZVJLyTcGhoaOjw
aP1JgP+dcCKcxCiaa3Y4NQCQkJCQ3ZD+FTE+zHVG0a+KAQwYMGAYtuH0njbs
ug0oKKhrpvynZ5eusSBOvE3c/2n+pX8r4sS7n9V6NKTKriH2w6kY6zqa57lp
HX6zVTns8u23YEU/ZUs/IQ==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{560, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->321223842]
}, Open  ]],

Cell["Centered:", "ExampleText",
 CellID->90237254],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "@", 
  RowBox[{"Text", "[", 
   RowBox[{"Style", "[", 
    RowBox[{"t", ",", 
     RowBox[{"TextAlignment", "\[Rule]", "Center"}]}], "]"}], 
   "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->449003041],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnctOwkAUQKcv6EL3XbLEqMT4AS515Uc0xAQWRoP8f53pzJS2DCampUzL
aVLozL3nYMxwKe1NeM/3m4/PfL9d54u3Xf692a5/Fq9fOzkVBUKET0KIl0zI
40IelbvdnuUux1GapkJvNmUl90BPRxVRgSu5BxqYdPROPsRqLtb/KJMgB6F5
TkyQLLLGkPXgXOdL9TA7jMsDQ9k8hYStcT2uDkM8ePDgwVNy90WXalsW8qTK
q89CQ0ND90w/Fqe+BUXCSrSiXfncvgQSEhKyRrprzLKZa43i+BzLNQ6PXw0D
BgwYvDKcPr+qLPGB0sU1qvH1ahtDQUFNgnJflVfVoj6+aY3nxIl3iLuvTrLq
iA+/6lQFVFXx1jynjP8cu88kC7P51UVxvij9GWRNK4v+DDx48OAZwkN/BjQ0
9Fho+jMgISHPSdKfgQEDhms00J8BBQXVpujPIO7LnXJWHfHhVx39GfRn/D+q
PkJ9vMtOFlljyZo731m+3UnFgwcPHjx+emZFl08R/+6EQ0NDQ/tHqysB7m/C
kbASrWjXbH96ACAhISH7Id0VMWzmWqMYV8cABgwYMEzbcPqc1u++DSgoqGum
3HfPLt1jQZx4l7j7av6l/yrixPtf1WrWp86uKY796RjrO5plmT5q/rJVOW3z
za9gBb9iJj8h\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{560, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->104612751]
}, Open  ]],

Cell["Align on the right:", "ExampleText",
 CellID->857286111],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Framed", "@", 
  RowBox[{"Text", "[", 
   RowBox[{"Style", "[", 
    RowBox[{"t", ",", 
     RowBox[{"TextAlignment", "\[Rule]", "Right"}]}], "]"}], "]"}]}]], "Input",\

 CellLabel->"In[4]:=",
 CellID->539273144],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnd1KwzAYQNO/rRd638s9wRAfwEu9qqBvUIawXYgy9/41aZr+LRVltU27
M+iW5PvOmUjIsvSDpdlp//aenQ67bPN0zD73h93X5vHjKIcCTwj/TgjxkAjZ
zmWruMzjXl6yH8RxLPTDpGzl5enhoCIqcCsvTwOLjj7Lp1CNhfofVSbIjl++
RmWQLLLmkLW2zvNUPa3qftEoKZOnEL/Tb8ZV08eDBw8ePAW3yi9ZbYuFPKry
mqPQ0NDQA9Nx3vctKBBGohXdlc/uiyAhISEbpH2NSdu5xijO91i2vn/+bhgw
YMDglKF/f1VZwprSi2vQ4JurbQgFBbUIyn4q/5rXq4hq3nT6a+LEL4jbTyeZ
dcTHn3UvuV4Vb/N6p0T/5747dRJTRanPIGtZWdRn4MGDB88YHuozoKGh50JT
nwEJCfmfJPUZGDBguEYD9RlQUFBdivoM4q7cKWfWER9/1lGfQX3G36PqI9TF
u+xkkTWXLPve07U7qXjw4MGDx02PfVf/W7t7d8KhoaGh3aPt3/zN6XLzVLm7
ZrtTAwAJCQk5DGlfEf12rjGKeVUMYMCAAcOyDf17WrfrNqCgoK6Zst89m7rG
gjjxS+L20/yp/yrixIef1Wp06kqupffdqRgbOpokiW61f9mqGDb55a9ged+c
UT8h\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{560, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->81580819]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25316],

Cell["Line up at the position across the page:", "ExampleText",
 CellID->336624063],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Do", "[", 
  RowBox[{
   RowBox[{"Print", "[", 
    RowBox[{"Style", "[", 
     RowBox[{"a", ",", 
      RowBox[{"TextAlignment", "\[Rule]", "a"}]}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"-", "1"}], ",", "1", ",", ".5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->109426484],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox[
  RowBox[{"-", "1.`"}],
  StripOnInput->False,
  TextAlignment->-1.]], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->901206414],

Cell[BoxData[
 StyleBox[
  RowBox[{"-", "0.5`"}],
  StripOnInput->False,
  TextAlignment->-0.5]], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->5103237],

Cell[BoxData[
 StyleBox["0.`",
  StripOnInput->False,
  TextAlignment->0.]], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->18574379],

Cell[BoxData[
 StyleBox["0.5`",
  StripOnInput->False,
  TextAlignment->0.5]], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->404887243],

Cell[BoxData[
 StyleBox["1.`",
  StripOnInput->False,
  TextAlignment->1.]], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->67032806]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16735],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TextJustification",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TextJustification"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Alignment",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Alignment"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ColumnAlignments",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ColumnAlignments"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PageWidth",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PageWidth"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31098]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3554],

Cell[TextData[{
 ButtonBox["Cells as ",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/CellsAsMathematicaExpressions"],
 StyleBox[ButtonBox["Mathematica",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/CellsAsMathematicaExpressions"],
  FontSlant->"Italic"],
 ButtonBox[" Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/CellsAsMathematicaExpressions"]
}], "Tutorials",
 CellID->32050],

Cell[TextData[ButtonBox["Text and Font Options",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TextAndFontOptions"]], "Tutorials",
 CellID->7432]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->94774183],

Cell[TextData[ButtonBox["Stylesheets",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Stylesheets"]], "MoreAbout",
 CellID->222841568],

Cell[TextData[ButtonBox["Text Layout Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TextLayoutOptions"]], "MoreAbout",
 CellID->15855681],

Cell[TextData[ButtonBox["Text Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TextStyling"]], "MoreAbout",
 CellID->399536126]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TextAlignment - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 26, 24.1132318}", "context" -> "System`", 
    "keywords" -> {
     "flush left", "flush right", "left aligned", "right aligned", 
      "centered text", "left aligned text", "right aligned text"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "TextAlignment is an option for Cell, Pane and related constructs which \
specifies how successive lines of text should be aligned. ", 
    "synonyms" -> {"text alignment"}, "title" -> "TextAlignment", "type" -> 
    "Symbol", "uri" -> "ref/TextAlignment"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6499, 202, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->18404503]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 16843, 561}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2550, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3173, 87, 50, 1, 70, "ObjectName",
 CellID->2885],
Cell[3226, 90, 774, 24, 70, "Usage",
 CellID->14439]
}, Open  ]],
Cell[CellGroupData[{
Cell[4037, 119, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4515, 136, 55, 1, 70, "Notes",
 CellID->2718],
Cell[4573, 139, 1598, 46, 70, "2ColumnTableMod",
 CellID->9107],
Cell[6174, 187, 288, 10, 70, "Notes",
 CellID->5268]
}, Closed]],
Cell[CellGroupData[{
Cell[6499, 202, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->18404503],
Cell[CellGroupData[{
Cell[6883, 216, 148, 5, 70, "ExampleSection",
 CellID->173469784],
Cell[7034, 223, 61, 1, 70, "ExampleText",
 CellID->827890818],
Cell[7098, 226, 244, 8, 70, "Input",
 CellID->367642920],
Cell[CellGroupData[{
Cell[7367, 238, 235, 8, 28, "Input",
 CellID->341845274],
Cell[7605, 248, 907, 19, 83, "Output",
 Evaluatable->False,
 CellID->321223842]
}, Open  ]],
Cell[8527, 270, 51, 1, 70, "ExampleText",
 CellID->90237254],
Cell[CellGroupData[{
Cell[8603, 275, 239, 8, 28, "Input",
 CellID->449003041],
Cell[8845, 285, 895, 19, 83, "Output",
 Evaluatable->False,
 CellID->104612751]
}, Open  ]],
Cell[9755, 307, 62, 1, 70, "ExampleText",
 CellID->857286111],
Cell[CellGroupData[{
Cell[9842, 312, 236, 8, 28, "Input",
 CellID->539273144],
Cell[10081, 322, 886, 19, 83, "Output",
 Evaluatable->False,
 CellID->81580819]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11016, 347, 216, 7, 70, "ExampleSection",
 CellID->25316],
Cell[11235, 356, 83, 1, 70, "ExampleText",
 CellID->336624063],
Cell[CellGroupData[{
Cell[11343, 361, 350, 11, 70, "Input",
 CellID->109426484],
Cell[CellGroupData[{
Cell[11718, 376, 168, 6, 70, "Print",
 CellID->901206414],
Cell[11889, 384, 168, 6, 70, "Print",
 CellID->5103237],
Cell[12060, 392, 148, 5, 70, "Print",
 CellID->18574379],
Cell[12211, 399, 151, 5, 70, "Print",
 CellID->404887243],
Cell[12365, 406, 148, 5, 70, "Print",
 CellID->67032806]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12586, 419, 311, 9, 70, "SeeAlsoSection",
 CellID->16735],
Cell[12900, 430, 979, 35, 70, "SeeAlso",
 CellID->31098]
}, Open  ]],
Cell[CellGroupData[{
Cell[13916, 470, 313, 9, 70, "TutorialsSection",
 CellID->3554],
Cell[14232, 481, 412, 12, 70, "Tutorials",
 CellID->32050],
Cell[14647, 495, 149, 3, 70, "Tutorials",
 CellID->7432]
}, Open  ]],
Cell[CellGroupData[{
Cell[14833, 503, 318, 9, 70, "MoreAboutSection",
 CellID->94774183],
Cell[15154, 514, 134, 3, 70, "MoreAbout",
 CellID->222841568],
Cell[15291, 519, 147, 3, 70, "MoreAbout",
 CellID->15855681],
Cell[15441, 524, 135, 3, 70, "MoreAbout",
 CellID->399536126]
}, Open  ]],
Cell[15591, 530, 27, 0, 70, "History"],
Cell[15621, 532, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

