(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20250,        624]
NotebookOptionsPosition[     16814,        516]
NotebookOutlinePosition[     18341,        556]
CellTagsIndexPosition[     18256,        551]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Text and Font Options" :> 
          Documentation`HelpLookup["paclet:tutorial/TextAndFontOptions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Text and Font Options\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TextAlignment" :> 
          Documentation`HelpLookup["paclet:ref/TextAlignment"], "Hyphenation" :> 
          Documentation`HelpLookup["paclet:ref/Hyphenation"], "PageWidth" :> 
          Documentation`HelpLookup["paclet:ref/PageWidth"], "AutoSpacing" :> 
          Documentation`HelpLookup["paclet:ref/AutoSpacing"], "Alignment" :> 
          Documentation`HelpLookup["paclet:ref/Alignment"], "Inset" :> 
          Documentation`HelpLookup["paclet:ref/Inset"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"TextAlignment\"\>", 2->"\<\"Hyphenation\"\>", 
       3->"\<\"PageWidth\"\>", 4->"\<\"AutoSpacing\"\>", 
       5->"\<\"Alignment\"\>", 6->"\<\"Inset\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Font Options" :> 
          Documentation`HelpLookup["paclet:guide/FontOptions"], 
          "Text Layout Options" :> 
          Documentation`HelpLookup["paclet:guide/TextLayoutOptions"], 
          "Text Styling" :> 
          Documentation`HelpLookup["paclet:guide/TextStyling"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Font Options\"\>", 
       2->"\<\"Text Layout Options\"\>", 
       3->"\<\"Text Styling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["TextJustification", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["TextJustification",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/TextJustification"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Cell",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Cell"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["Inset",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Inset"]], "InlineFormula"],
     " which specifies how much lines of text can be stretched in order to \
make them be the same length. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15822]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"TextJustification", "->", "0"}]], "InlineFormula"],
 " does no stretching, and leads to ragged text boundaries. "
}], "Notes",
 CellID->20003],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"TextJustification", "->", "1"}]], "InlineFormula"],
 " does full justification, and forces all complete lines to be the same \
length. "
}], "Notes",
 CellID->5161],

Cell[TextData[{
 "No stretching is done on lines that end with explicit ",
 StyleBox["Enter", "KeyEvent"],
 " characters. "
}], "Notes",
 CellID->11896],

Cell[TextData[{
 "With settings for ",
 Cell[BoxData[
  ButtonBox["TextJustification",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TextJustification"]], "InlineFormula"],
 " between 0 and 1, partial justification is done. "
}], "Notes",
 CellID->26141],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"TextJustification", "->", 
   StyleBox["s", "TI"]}]], "InlineFormula"],
 ", ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " will take the amount by which each broken line is shorter than ",
 Cell[BoxData[
  ButtonBox["PageWidth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PageWidth"]], "InlineFormula"],
 ", and then insert within the line a total amount of space equal to ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " times this. "
}], "Notes",
 CellID->2150],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  ButtonBox["TextJustification",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TextJustification"]], "InlineFormula"],
 " is not ",
 Cell[BoxData["0"], "InlineFormula"],
 ", the standard ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end will dynamically adjust the lengths of lines as you enter text. \
"
}], "Notes",
 CellID->28432]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->89496089],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->378220866],

Cell["Create some random text with irregular word lengths:", "ExampleText",
 CellID->12381754],

Cell[BoxData[
 RowBox[{
  RowBox[{"rtext", "=", 
   RowBox[{"StringJoin", "[", 
    RowBox[{"Riffle", "[", 
     RowBox[{
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"StringTake", "[", 
         RowBox[{"\"\<abcdefghij\>\"", ",", 
          RowBox[{"RandomInteger", "[", 
           RowBox[{"{", 
            RowBox[{"1", ",", "10"}], "}"}], "]"}]}], "]"}], ",", 
        RowBox[{"{", "30", "}"}]}], "]"}], ",", "\"\< \>\""}], "]"}], "]"}]}],
   ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->86493583],

Cell[TextData[{
 "Create text cells with different settings for ",
 Cell[BoxData[
  ButtonBox["TextJustification",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TextJustification"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->101113267],

Cell[BoxData[
 RowBox[{"CellPrint", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"TextCell", "[", 
     RowBox[{"rtext", ",", "\"\<Text\>\"", ",", 
      RowBox[{"CellMargins", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"200", ",", "200"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"10", ",", "10"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"TextJustification", "\[Rule]", "j"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"j", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", ".5", ",", "1"}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->23352997],

Cell["\<\
abcdefgh abcdef abcdefgh abc abcdefghi abcdefghi abcdefghij ab abcdefg abc ab \
abcdefg abcdefghij abcdefghi abcdefgh abcde abc abcde abcdef abcde abc abc \
abcdefg abcdefgh abcdefghij a abcdefgh abcdefgh abcdefghij abcde\
\>", "Text",
 CellMargins->{{200, 200}, {10, 10}},
 GeneratedCell->True,
 CellAutoOverwrite->True,
 TextJustification->0,
 CellID->667597203],

Cell["\<\
abcdefgh abcdef abcdefgh abc abcdefghi abcdefghi abcdefghij ab abcdefg abc ab \
abcdefg abcdefghij abcdefghi abcdefgh abcde abc abcde abcdef abcde abc abc \
abcdefg abcdefgh abcdefghij a abcdefgh abcdefgh abcdefghij abcde\
\>", "Text",
 CellMargins->{{200, 200}, {10, 10}},
 GeneratedCell->True,
 CellAutoOverwrite->True,
 TextJustification->0.5,
 CellID->846631630],

Cell["\<\
abcdefgh abcdef abcdefgh abc abcdefghi abcdefghi abcdefghij ab abcdefg abc ab \
abcdefg abcdefghij abcdefghi abcdefgh abcde abc abcde abcdef abcde abc abc \
abcdefg abcdefgh abcdefghij a abcdefgh abcdefgh abcdefghij abcde\
\>", "Text",
 CellMargins->{{200, 200}, {10, 10}},
 GeneratedCell->True,
 CellAutoOverwrite->True,
 TextJustification->1,
 CellID->2834860]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->27165],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TextAlignment",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TextAlignment"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hyphenation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hyphenation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PageWidth",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PageWidth"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AutoSpacing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AutoSpacing"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Alignment",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Alignment"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Inset",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Inset"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25645]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5872],

Cell[TextData[ButtonBox["Text and Font Options",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TextAndFontOptions"]], "Tutorials",
 CellID->32361]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->95498952],

Cell[TextData[ButtonBox["Font Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FontOptions"]], "MoreAbout",
 CellID->17198931],

Cell[TextData[ButtonBox["Text Layout Options",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TextLayoutOptions"]], "MoreAbout",
 CellID->183339221],

Cell[TextData[ButtonBox["Text Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TextStyling"]], "MoreAbout",
 CellID->224392758]
}, Open  ]],

Cell["New in 3  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TextJustification - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 26, 26.8945530}", "context" -> "System`", 
    "keywords" -> {
     "centering", "full justification", "justification", "left justification",
       "right justification", "ragged right", "ragged left", "spacing", 
      "automatic spacing", "word spacing", "stretch"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "TextJustification is an option for Cell and Inset which specifies how \
much lines of text can be stretched in order to make them be the same length. \
", "synonyms" -> {"text justification"}, "title" -> "TextJustification", 
    "type" -> "Symbol", "uri" -> "ref/TextJustification"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10429, 286, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->89496089]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18113, 544}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2505, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3128, 84, 4201, 83, 70, "ObjectNameGrid"],
Cell[7332, 169, 798, 24, 70, "Usage",
 CellID->15822]
}, Open  ]],
Cell[CellGroupData[{
Cell[8167, 198, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8645, 215, 184, 5, 70, "Notes",
 CellID->20003],
Cell[8832, 222, 206, 6, 70, "Notes",
 CellID->5161],
Cell[9041, 230, 152, 5, 70, "Notes",
 CellID->11896],
Cell[9196, 237, 257, 8, 70, "Notes",
 CellID->26141],
Cell[9456, 247, 543, 18, 70, "Notes",
 CellID->2150],
Cell[10002, 267, 390, 14, 70, "Notes",
 CellID->28432]
}, Closed]],
Cell[CellGroupData[{
Cell[10429, 286, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->89496089],
Cell[CellGroupData[{
Cell[10813, 300, 148, 5, 70, "ExampleSection",
 CellID->378220866],
Cell[10964, 307, 94, 1, 70, "ExampleText",
 CellID->12381754],
Cell[11061, 310, 521, 16, 70, "Input",
 CellID->86493583],
Cell[11585, 328, 247, 8, 70, "ExampleText",
 CellID->101113267],
Cell[11835, 338, 655, 20, 70, "Input",
 CellID->23352997],
Cell[12493, 360, 374, 9, 70, "Text",
 CellID->667597203],
Cell[12870, 371, 376, 9, 70, "Text",
 CellID->846631630],
Cell[13249, 382, 372, 9, 70, "Text",
 CellID->2834860]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13670, 397, 311, 9, 70, "SeeAlsoSection",
 CellID->27165],
Cell[13984, 408, 1451, 53, 70, "SeeAlso",
 CellID->25645]
}, Open  ]],
Cell[CellGroupData[{
Cell[15472, 466, 313, 9, 70, "TutorialsSection",
 CellID->5872],
Cell[15788, 477, 150, 3, 70, "Tutorials",
 CellID->32361]
}, Open  ]],
Cell[CellGroupData[{
Cell[15975, 485, 318, 9, 70, "MoreAboutSection",
 CellID->95498952],
Cell[16296, 496, 134, 3, 70, "MoreAbout",
 CellID->17198931],
Cell[16433, 501, 148, 3, 70, "MoreAbout",
 CellID->183339221],
Cell[16584, 506, 135, 3, 70, "MoreAbout",
 CellID->224392758]
}, Open  ]],
Cell[16734, 512, 50, 0, 70, "History"],
Cell[16787, 514, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

