(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     81110,       2264]
NotebookOptionsPosition[     73781,       2011]
NotebookOutlinePosition[     75120,       2049]
CellTagsIndexPosition[     75034,       2044]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Combinatorial Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/CombinatorialFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Combinatorial Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ClebschGordan" :> 
          Documentation`HelpLookup["paclet:ref/ClebschGordan"], "SixJSymbol" :> 
          Documentation`HelpLookup["paclet:ref/SixJSymbol"], 
          "SphericalHarmonicY" :> 
          Documentation`HelpLookup["paclet:ref/SphericalHarmonicY"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"ClebschGordan\"\>", 
       2->"\<\"SixJSymbol\"\>", 
       3->"\<\"SphericalHarmonicY\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functions Used in Quantum Mechanics" :> 
          Documentation`HelpLookup[
           "paclet:guide/FunctionsUsedInQuantumMechanics"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Functions Used in Quantum Mechanics\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ThreeJSymbol", "ObjectName",
 CellID->28048],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ThreeJSymbol",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ThreeJSymbol"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["j", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["m", "TI"], 
           StyleBox["1", "TR"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["j", "TI"], 
           StyleBox["2", "TR"]], ",", 
          SubscriptBox[
           StyleBox["m", "TI"], 
           StyleBox["2", "TR"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["j", "TI"], 
           StyleBox["3", "TR"]], ",", 
          SubscriptBox[
           StyleBox["m", "TI"], 
           StyleBox["3", "TR"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the values of the Wigner 3\[Hyphen]j symbol. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23930]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The 3\[Hyphen]j symbols vanish except when ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["m", "1"], "+", 
     SubscriptBox["m", "2"], "+", 
     SubscriptBox["m", "3"]}], "=", "0"}], TraditionalForm]], "InlineMath"],
 " and the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["j", "i"], TraditionalForm]], "InlineMath"],
 " satisfy a triangle inequality. "
}], "Notes",
 CellID->573],

Cell[TextData[{
 "The parameters of ",
 Cell[BoxData[
  ButtonBox["ThreeJSymbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ThreeJSymbol"]], "InlineFormula"],
 " can be integers, half\[Hyphen]integers or symbolic expressions. "
}], "Notes",
 CellID->26658],

Cell[TextData[{
 "The Clebsch\[Hyphen]Gordan coefficients and 3\[Hyphen]j symbols in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " satisfy the relation ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubsuperscriptBox["C", 
     RowBox[{
      SubscriptBox["m", "1"], 
      SubscriptBox["m", "2"], 
      SubscriptBox["m", "3"]}], 
     RowBox[{
      SubscriptBox["j", "1"], 
      SubscriptBox["j", "2"], 
      SubscriptBox["j", "3"]}]], " ", "=", " ", 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{
       SubscriptBox["m", "3"], "+", 
       SubscriptBox["j", "1"], "-", 
       SubscriptBox["j", "2"]}]], 
     SqrtBox[
      RowBox[{"2", 
       SubscriptBox["j", "3"], "+", "1"}]], 
     RowBox[{"(", GridBox[{
        {
         SubscriptBox["j", "1"], 
         SubscriptBox["j", "2"], 
         SubscriptBox["j", "3"]},
        {
         SubscriptBox["m", "1"], 
         SubscriptBox["m", "2"], 
         RowBox[{"-", 
          SubscriptBox["m", "3"]}]}
       }], ")"}]}]}], TraditionalForm]], "InlineMath"],
 ". "
}], "Notes",
 CellID->25816]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->146518895],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->421944260],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ThreeJSymbol", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"6", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "0"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->274893691],

Cell[BoxData[
 SqrtBox[
  FractionBox["5", "143"]]], "Output",
 ImageSize->{49, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->352004130]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->651255031],

Cell["Use symbolic arguments to obtain exact symbolic answers:", "ExampleText",
 CellID->28221401],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ThreeJSymbol", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"6", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "m"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->514782110],

Cell[BoxData[
 RowBox[{"24", " ", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"-", "1"}], ")"}], "m"], " ", 
  SqrtBox[
   FractionBox["5", "143"]], " ", 
  SqrtBox[
   FractionBox["1", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"12", "-", 
       RowBox[{"7", " ", "m"}], "+", 
       SuperscriptBox["m", "2"]}], ")"}], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"4", "-", "m"}], ")"}], "!"}], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", "+", "m"}], ")"}], "!"}]}]]]}]], "Output",
 ImageSize->{317, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->37441429]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->568],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ThreeJSymbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ThreeJSymbol"]], "InlineFormula"],
 " works with integer and half\[Hyphen]integer arguments:"
}], "ExampleText",
 CellID->223294470],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ThreeJSymbol", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "/", "2"}], ",", 
     RowBox[{
      RowBox[{"-", "1"}], "/", "2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36004678],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["1", 
   SqrtBox["3"]]}]], "Output",
 ImageSize->{40, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->115453919]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->259336475],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " formatting:"
}], "ExampleText",
 CellID->165524542],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ThreeJSymbol", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"j", ",", "m"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["j", "1"], ",", 
      SubscriptBox["m", "1"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["j", "2"], ",", 
      SubscriptBox["m", "2"]}], "}"}]}], "]"}], "//", 
  "TraditionalForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->64356013],

Cell[BoxData[
 FormBox[
  RowBox[{
   TagBox[
    StyleBox["(",
     SpanMaxSize->DirectedInfinity[1]],
    ThreeJSymbol], "\[MediumSpace]", GridBox[{
     {"j", 
      SubscriptBox["j", "1"], 
      SubscriptBox["j", "2"]},
     {"m", 
      SubscriptBox["m", "1"], 
      SubscriptBox["m", "2"]}
    }], "\[MediumSpace]", 
   TagBox[
    StyleBox[")",
     SpanMaxSize->DirectedInfinity[1]],
    ThreeJSymbol]}], TraditionalForm]], "Output",
 ImageSize->{80, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TraditionalForm=",
 CellID->43270285]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24023],

Cell[TextData[{
 "Plot 3\[Hyphen]j symbol coefficients as a function of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["m", "1"], TraditionalForm]], "InlineMath"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["m", "2"], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->549401002],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"ThreeJSymbol", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"10", ",", "m1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"20", ",", "m2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"30", ",", 
         RowBox[{
          RowBox[{"-", "m1"}], "-", "m2"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"m1", ",", 
       RowBox[{"-", "10"}], ",", "10"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"m2", ",", 
       RowBox[{"-", "20"}], ",", "20"}], "}"}]}], "]"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->793584162],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 GeneratedCell->False,
 ImageSize->{253, 197},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->414433786]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4691417],

Cell["Apply angular momentum operators to spherical harmonics:", "ExampleText",
 CellID->56931266],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"\[ScriptCapitalL]", "[", 
    RowBox[{"-", "1"}], "]"}], "[", 
   RowBox[{"\[Theta]_", ",", "\[Phi]_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "/", 
     RowBox[{"Sqrt", "[", "2", "]"}]}], 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", "I"}], " ", "\[Phi]"}], "]"}], 
    RowBox[{"(", " ", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"#", ",", " ", "\[Theta]"}], "]"}], "-", 
      RowBox[{"I", " ", 
       RowBox[{"Cot", "[", "\[Theta]", "]"}], 
       RowBox[{"D", "[", 
        RowBox[{"#", ",", " ", "\[Phi]"}], "]"}]}]}], ")"}]}], 
   "&"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[ScriptCapitalL]", "[", "0", "]"}], "[", 
   RowBox[{"\[Theta]_", ",", "\[Phi]_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"-", "I"}], " ", 
    RowBox[{"D", "[", 
     RowBox[{"#", ",", " ", "\[Phi]"}], "]"}]}], 
   "&"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[ScriptCapitalL]", "[", 
    RowBox[{"+", "1"}], "]"}], "[", 
   RowBox[{"\[Theta]_", ",", "\[Phi]_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"-", "1"}], "/", 
     RowBox[{"Sqrt", "[", "2", "]"}]}], 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"+", "I"}], " ", "\[Phi]"}], "]"}], 
    RowBox[{"(", " ", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"#", ",", " ", "\[Theta]"}], "]"}], "+", 
      RowBox[{"I", " ", 
       RowBox[{"Cot", "[", "\[Theta]", "]"}], 
       RowBox[{"D", "[", 
        RowBox[{"#", ",", " ", "\[Phi]"}], "]"}]}]}], ")"}]}], 
   "&"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->30051366],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"j", ",", "m"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"5", ",", "3"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Table", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"\[ScriptCapitalL]", "[", "\[Mu]", "]"}], "[", 
       RowBox[{"\[Theta]", ",", "\[Phi]"}], "]"}], " ", "@", " ", 
      RowBox[{"SphericalHarmonicY", "[", 
       RowBox[{"j", ",", "m", ",", "\[Theta]", ",", "\[Phi]"}], "]"}]}], "-", 
     
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"-", "1"}], ")"}], "^", 
       RowBox[{"(", 
        RowBox[{"j", "-", "1", "+", "m", "+", "\[Mu]"}], ")"}]}], 
      RowBox[{"Sqrt", "[", 
       RowBox[{"j", 
        RowBox[{"(", 
         RowBox[{"j", "+", "1"}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "j"}], "+", "1"}], ")"}]}], "]"}], 
      RowBox[{"ThreeJSymbol", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"j", ",", "m"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "\[Mu]"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"j", ",", 
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"m", "+", "\[Mu]"}], ")"}]}]}], "}"}]}], "]"}], 
      RowBox[{"SphericalHarmonicY", "[", 
       RowBox[{"j", ",", 
        RowBox[{"m", "+", "\[Mu]"}], ",", "\[Theta]", ",", "\[Phi]"}], 
       "]"}]}]}], ",", 
    RowBox[{"{", 
     RowBox[{"\[Mu]", ",", 
      RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}], "//", 
  "Simplify"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->59577246],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->267037195]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->12577374],

Cell["Evaluate Gaunt coefficients:", "ExampleText",
 CellID->539791084],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"l1", "=", "4"}], ",", 
     RowBox[{"m1", "=", "0"}], ",", 
     RowBox[{"l2", "=", "3"}], ",", 
     RowBox[{"m2", "=", "2"}], ",", 
     RowBox[{"l3", "=", "3"}], ",", 
     RowBox[{"m3", "=", "2"}]}], "}"}], ",", 
   RowBox[{
    SqrtBox[
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "l1"}], "+", "1"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "l2"}], "+", "1"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "l3"}], "+", "1"}], ")"}]}], 
      RowBox[{"4", " ", "\[Pi]"}]]], " ", 
    RowBox[{"ThreeJSymbol", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"l1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"l2", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"l3", ",", "0"}], "}"}]}], "]"}], " ", 
    RowBox[{"ThreeJSymbol", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"l1", ",", "m1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"l2", ",", "m2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"l3", ",", 
        RowBox[{"-", "m3"}]}], "}"}]}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->59369855],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["7", 
   RowBox[{"22", " ", 
    SqrtBox["\[Pi]"]}]]}]], "Output",
 ImageSize->{58, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->199586827]
}, Open  ]],

Cell["Evaluate an explicit triple integral of spherical harmonics:", \
"ExampleText",
 CellID->157769006],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"l1", "=", "4"}], ",", 
     RowBox[{"m1", "=", "0"}], ",", 
     RowBox[{"l2", "=", "3"}], ",", 
     RowBox[{"m2", "=", "2"}], ",", 
     RowBox[{"l3", "=", "3"}], ",", 
     RowBox[{"m3", "=", "2"}]}], "}"}], ",", "\[IndentingNewLine]", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"SphericalHarmonicY", "[", 
       RowBox[{"l1", ",", "m1", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], 
      RowBox[{"SphericalHarmonicY", "[", 
       RowBox[{"l2", ",", "m2", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], 
      RowBox[{"Conjugate", "[", 
       RowBox[{"SphericalHarmonicY", "[", 
        RowBox[{"l3", ",", "m3", ",", "\[Theta]", ",", "\[Phi]"}], "]"}], 
       "]"}], 
      RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Theta]", ",", "0", ",", "Pi"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", "0", ",", 
       RowBox[{"2", "Pi"}]}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->294235474],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["7", 
   RowBox[{"22", " ", 
    SqrtBox["\[Pi]"]}]]}]], "Output",
 ImageSize->{58, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2533673]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25709],

Cell[TextData[{
 "Evaluate the completely symbolic case of ",
 Cell[BoxData[
  ButtonBox["ThreeJSymbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ThreeJSymbol"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->392837679],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ThreeJSymbol", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"j1", ",", "m1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"j2", ",", "m2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"j1", "+", "j2"}], ",", 
     RowBox[{
      RowBox[{"-", "m1"}], "-", "m2"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->13173462],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"-", "1"}], ")"}], 
   RowBox[{"j1", "-", "j2", "+", "m1", "+", "m2"}]], " ", 
  SqrtBox[
   FractionBox[
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", " ", "j1"}], ")"}], "!"}], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"2", " ", "j2"}], ")"}], "!"}], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"j1", "+", "j2", "-", "m1", "-", "m2"}], ")"}], "!"}], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"j1", "+", "j2", "+", "m1", "+", "m2"}], ")"}], "!"}]}], 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", 
        RowBox[{"2", " ", "j1"}], "+", 
        RowBox[{"2", " ", "j2"}]}], ")"}], "!"}], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"j1", "-", "m1"}], ")"}], "!"}], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"j1", "+", "m1"}], ")"}], "!"}], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"j2", "-", "m2"}], ")"}], "!"}], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"j2", "+", "m2"}], ")"}], "!"}]}]]]}]], "Output",
 ImageSize->{484, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->367032819]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->77218932],

Cell[TextData[{
 "Demonstrate ",
 Cell[BoxData[
  FormBox["m", TraditionalForm]], "InlineMath"],
 "\[Hyphen]sum orthogonality:"
}], "ExampleText",
 CellID->885892004],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"j1", ",", "j2"}], "}"}], "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", "2"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Sum", "[", 
    RowBox[{
     RowBox[{"If", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{"m1", "+", "m2"}], "]"}], ">", "j"}], "||", 
        RowBox[{
         RowBox[{"Abs", "[", 
          RowBox[{"m1", "+", "m2"}], "]"}], ">", "ji"}]}], ",", "0", ",", 
       RowBox[{
        RowBox[{"Sqrt", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", "j"}], "+", "1"}], ")"}], 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", "ji"}], "+", "1"}], ")"}]}], "]"}], 
        RowBox[{"ThreeJSymbol", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"j1", ",", "m1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"j2", ",", "m2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"j", ",", 
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{"m1", "+", "m2"}], ")"}]}]}], "}"}]}], "]"}], 
        RowBox[{"ThreeJSymbol", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"j1", ",", "m1"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"j2", ",", "m2"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"ji", ",", 
            RowBox[{"-", 
             RowBox[{"(", 
              RowBox[{"m1", "+", "m2"}], ")"}]}]}], "}"}]}], "]"}]}]}], "]"}],
      ",", 
     RowBox[{"{", 
      RowBox[{"m1", ",", 
       RowBox[{"-", "j1"}], ",", "j1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"m2", ",", 
       RowBox[{"-", "j2"}], ",", "j2"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"j", ",", 
     RowBox[{"Abs", "[", 
      RowBox[{"j1", "-", "j2"}], "]"}], ",", 
     RowBox[{"j1", "+", "j2"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"ji", ",", 
     RowBox[{"Abs", "[", 
      RowBox[{"j1", "-", "j2"}], "]"}], ",", 
     RowBox[{"j1", "+", "j2"}]}], "}"}]}], "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->27091520],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"3", ",", "0", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "5", ",", "0", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "7", ",", "0", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "9", ",", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0", ",", "11"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{539, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->46604999]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->48984343],

Cell["Convert to a Regge R symbol:", "ExampleText",
 CellID->519084146],

Cell[BoxData[
 RowBox[{
  RowBox[{"ToReggeR", "[", 
   RowBox[{"ThreeJSymbol", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"j1_", ",", " ", "m1_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j2_", ",", "m2_"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"j3_", ",", "m3_"}], "}"}]}], "]"}], "]"}], " ", ":=", 
  "\[IndentingNewLine]", 
  RowBox[{"ReggeR", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "j1"}], "+", "j2", "+", "j3"}], ",", 
       RowBox[{"j1", "-", "j2", "+", "j3"}], ",", 
       RowBox[{"j1", "+", "j2", "-", "j3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"j1", "+", "m1"}], ",", 
       RowBox[{"j2", "+", "m2"}], ",", 
       RowBox[{"j3", "+", "m3"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"j1", "-", "m1"}], ",", 
       RowBox[{"j2", "-", "m2"}], ",", 
       RowBox[{"j3", "-", "m3"}]}], "}"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->61660678],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToReggeR", "[", 
  RowBox[{"ThreeJSymbol", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"j1", ",", " ", "m1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j2", ",", "m2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"j3", ",", 
      RowBox[{
       RowBox[{"-", "m1"}], "-", "m2"}]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->96961787],

Cell[BoxData[
 RowBox[{"ReggeR", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "j1"}], "+", "j2", "+", "j3"}], ",", 
      RowBox[{"j1", "-", "j2", "+", "j3"}], ",", 
      RowBox[{"j1", "+", "j2", "-", "j3"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"j1", "+", "m1"}], ",", 
      RowBox[{"j2", "+", "m2"}], ",", 
      RowBox[{"j3", "-", "m1", "-", "m2"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"j1", "-", "m1"}], ",", 
      RowBox[{"j2", "-", "m2"}], ",", 
      RowBox[{"j3", "+", "m1", "+", "m2"}]}], "}"}]}], "}"}], "]"}]], "Output",\

 ImageSize->{413, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->258708550]
}, Open  ]],

Cell["Check the symmetry of the Regge R symbol:", "ExampleText",
 CellID->130672253],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Total", "[", 
    RowBox[{
     RowBox[{"%", "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", 
     RowBox[{"{", "2", "}"}]}], "]"}], ",", 
   RowBox[{"Total", "[", 
    RowBox[{
     RowBox[{"Transpose", "[", 
      RowBox[{"%", "[", 
       RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", 
     RowBox[{"{", "2", "}"}]}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->523936525],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"j1", "+", "j2", "+", "j3"}], ",", 
     RowBox[{"j1", "+", "j2", "+", "j3"}], ",", 
     RowBox[{"j1", "+", "j2", "+", "j3"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"j1", "+", "j2", "+", "j3"}], ",", 
     RowBox[{"j1", "+", "j2", "+", "j3"}], ",", 
     RowBox[{"j1", "+", "j2", "+", "j3"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{506, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->525671115]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->63781873],

Cell["Compare with sum definition:", "ExampleText",
 CellID->178845503],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ThreeJSymbol", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", 
     RowBox[{"-", "3"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->418586823],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["1", 
   RowBox[{"3", " ", 
    SqrtBox["2"]}]]}]], "Output",
 ImageSize->{50, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->283589405]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"With", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"j1", "=", "2"}], ",", 
     RowBox[{"m1", "=", "1"}], ",", 
     RowBox[{"j2", "=", "2"}], ",", 
     RowBox[{"m2", "=", "2"}], ",", 
     RowBox[{"j3", "=", "4"}], ",", 
     RowBox[{"m3", "=", 
      RowBox[{
       RowBox[{"-", "1"}], "-", "2"}]}]}], "}"}], ",", 
   RowBox[{
    FractionBox["1", 
     SqrtBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", "j1", "+", "j2", "+", "j3"}], ")"}], "!"}]]], 
    RowBox[{
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{
       RowBox[{"-", "j1"}], "+", "j2", "+", "m3"}]], " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"j1", "+", "j2", "-", "j3"}], ")"}], "!"}]], " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"j1", "-", "j2", "+", "j3"}], ")"}], "!"}]], " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "j1"}], "+", "j2", "+", "j3"}], ")"}], "!"}]], " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"j1", "-", "m1"}], ")"}], "!"}]], " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"j1", "+", "m1"}], ")"}], "!"}]], " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"j2", "-", "m2"}], ")"}], "!"}]], " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"j2", "+", "m2"}], ")"}], "!"}]], " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"j3", "-", "m3"}], ")"}], "!"}]], " ", 
     SqrtBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"j3", "+", "m3"}], ")"}], "!"}]], " ", 
     RowBox[{"KroneckerDelta", "[", 
      RowBox[{
       RowBox[{"m1", "+", "m2"}], ",", 
       RowBox[{"-", "m3"}]}], "]"}], " ", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"k", "=", 
        RowBox[{"Max", "[", 
         RowBox[{"0", ",", 
          RowBox[{"j2", "-", "j3", "-", "m1"}], ",", 
          RowBox[{"j1", "-", "j3", "+", "m2"}]}], "]"}]}], 
       RowBox[{"Min", "[", 
        RowBox[{
         RowBox[{"j1", "-", "m1"}], ",", 
         RowBox[{"j2", "+", "m2"}]}], "]"}]], 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"-", "1"}], ")"}], "k"], "/", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{"j1", "+", "j2", "-", "j3", "-", "k"}], ")"}], "!"}], " ", 
         
         RowBox[{"k", "!"}], " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"j1", "-", "k", "-", "m1"}], ")"}], "!"}], " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "j2"}], "+", "j3", "+", "k", "+", "m1"}], ")"}], 
          "!"}], " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "j1"}], "+", "j3", "+", "k", "-", "m2"}], ")"}], 
          "!"}], " ", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"j2", "-", "k", "+", "m2"}], ")"}], "!"}]}], 
        ")"}]}]}]}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->79880886],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox["1", 
   RowBox[{"3", " ", 
    SqrtBox["2"]}]]}]], "Output",
 ImageSize->{50, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->63526566]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31657],

Cell[TextData[{
 "A message is issued and the result 0 returned in the case ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["m", "1"], "+", 
     SubscriptBox["m", "2"]}], "\[NotEqual]", 
    RowBox[{"-", 
     SubscriptBox["m", "3"]}]}], TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->22386640],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ThreeJSymbol", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->748429791],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClebschGordan", "::", "\<\"phy\"\>"}], ":", 
  " ", "\<\"\\!\\(ThreeJSymbol[\\(\\(\\(\\({2, 1}\\)\\), \\(\\({2, 4}\\)\\), \
\\(\\({4, 2}\\)\\)\\)\\)]\\) is not physical. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/ClebschGordan/phy\\\", ButtonNote -> \
\\\"ClebschGordan::phy\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->458437376],

Cell[BoxData["0"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->767656662]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->296072276],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ThreeJSymbol",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ThreeJSymbol"]], "InlineFormula"],
 " always returns exact results, even for inexact arguments:"
}], "ExampleText",
 CellID->69617962],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ThreeJSymbol", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"20.", ",", "1."}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"30.", ",", "4."}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"50.", ",", 
     RowBox[{"-", "5."}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->421045641],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "555"}], " ", 
  SqrtBox[
   FractionBox["1162474599", "242216732147426402"]]}]], "Output",
 ImageSize->{197, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->106645210]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9783],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ClebschGordan",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ClebschGordan"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SixJSymbol",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SixJSymbol"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SphericalHarmonicY",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SphericalHarmonicY"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15791]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8884],

Cell[TextData[ButtonBox["Combinatorial Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CombinatorialFunctions"]], "Tutorials",
 CellID->20373]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection",
 CellID->20031],

Cell[TextData[{
 ButtonBox["Demonstrations with ThreeJSymbol",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=ThreeJSymbol"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"],

Cell[TextData[StyleBox[ButtonBox["MathWorld",
 BaseStyle->"MathWorldLink",
 ButtonData->{
   URL["http://mathworld.wolfram.com/Wigner3j-Symbol.html"], 
   None}], "IT"]], "RelatedLinks"],

Cell[TextData[ButtonBox["The Wolfram Functions Site",
 BaseStyle->"FunctionsSiteLink",
 ButtonData->{
   URL["http://functions.wolfram.com/HypergeometricFunctions/ThreeJSymbol/"], 
   None}]], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->429333367],

Cell[TextData[ButtonBox["Functions Used in Quantum Mechanics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionsUsedInQuantumMechanics"]], "MoreAbout",
 CellID->306726950]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ThreeJSymbol - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 26, 39.1292412}", "context" -> "System`", 
    "keywords" -> {
     "3j", "3-j symbols", "three-j symbol", "Wigner 3j-symbol", 
      "Wigner coefficients"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ThreeJSymbol[{j_1, m_1}, {j_2, m_2}, {j_3, m_3}] gives the values of the \
Wigner 3-j symbol. ", "synonyms" -> {"three j symbol"}, "title" -> 
    "ThreeJSymbol", "type" -> "Symbol", "uri" -> "ref/ThreeJSymbol"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6328, 217, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->146518895]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 74891, 2037}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2075, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2698, 80, 50, 1, 70, "ObjectName",
 CellID->28048],
Cell[2751, 83, 1208, 39, 70, "Usage",
 CellID->23930]
}, Open  ]],
Cell[CellGroupData[{
Cell[3996, 127, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4474, 144, 425, 15, 70, "Notes",
 CellID->573],
Cell[4902, 161, 263, 8, 70, "Notes",
 CellID->26658],
Cell[5168, 171, 1123, 41, 70, "Notes",
 CellID->25816]
}, Closed]],
Cell[CellGroupData[{
Cell[6328, 217, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->146518895],
Cell[CellGroupData[{
Cell[6713, 231, 148, 5, 70, "ExampleSection",
 CellID->421944260],
Cell[CellGroupData[{
Cell[6886, 240, 288, 10, 28, "Input",
 CellID->274893691],
Cell[7177, 252, 192, 7, 60, "Output",
 CellID->352004130]
}, Open  ]],
Cell[7384, 262, 125, 3, 70, "ExampleDelimiter",
 CellID->651255031],
Cell[7512, 267, 98, 1, 70, "ExampleText",
 CellID->28221401],
Cell[CellGroupData[{
Cell[7635, 272, 288, 10, 28, "Input",
 CellID->514782110],
Cell[7926, 284, 647, 24, 71, "Output",
 CellID->37441429]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8622, 314, 214, 7, 70, "ExampleSection",
 CellID->568],
Cell[8839, 323, 240, 7, 70, "ExampleText",
 CellID->223294470],
Cell[CellGroupData[{
Cell[9104, 334, 435, 16, 70, "Input",
 CellID->36004678],
Cell[9542, 352, 209, 8, 55, "Output",
 CellID->115453919]
}, Open  ]],
Cell[9766, 363, 125, 3, 70, "ExampleDelimiter",
 CellID->259336475],
Cell[9894, 368, 203, 7, 70, "ExampleText",
 CellID->165524542],
Cell[CellGroupData[{
Cell[10122, 379, 439, 16, 70, "Input",
 CellID->64356013],
Cell[10564, 397, 589, 22, 66, "Output",
 CellID->43270285]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11202, 425, 223, 7, 70, "ExampleSection",
 CellID->24023],
Cell[11428, 434, 302, 11, 70, "ExampleText",
 CellID->549401002],
Cell[CellGroupData[{
Cell[11755, 449, 724, 23, 70, "Input",
 CellID->793584162],
Cell[12482, 474, 35323, 584, 70, "Output",
 Evaluatable->False,
 CellID->414433786]
}, Open  ]],
Cell[47820, 1061, 123, 3, 70, "ExampleDelimiter",
 CellID->4691417],
Cell[47946, 1066, 98, 1, 70, "ExampleText",
 CellID->56931266],
Cell[48047, 1069, 1671, 56, 70, "Input",
 CellID->30051366],
Cell[CellGroupData[{
Cell[49743, 1129, 1642, 51, 70, "Input",
 CellID->59577246],
Cell[51388, 1182, 213, 7, 36, "Output",
 CellID->267037195]
}, Open  ]],
Cell[51616, 1192, 124, 3, 70, "ExampleDelimiter",
 CellID->12577374],
Cell[51743, 1197, 71, 1, 70, "ExampleText",
 CellID->539791084],
Cell[CellGroupData[{
Cell[51839, 1202, 1294, 43, 70, "Input",
 CellID->59369855],
Cell[53136, 1247, 239, 9, 55, "Output",
 CellID->199586827]
}, Open  ]],
Cell[53390, 1259, 105, 2, 70, "ExampleText",
 CellID->157769006],
Cell[CellGroupData[{
Cell[53520, 1265, 1087, 29, 70, "Input",
 CellID->294235474],
Cell[54610, 1296, 237, 9, 55, "Output",
 CellID->2533673]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[54896, 1311, 233, 7, 70, "ExampleSection",
 CellID->25709],
Cell[55132, 1320, 232, 8, 70, "ExampleText",
 CellID->392837679],
Cell[CellGroupData[{
Cell[55389, 1332, 369, 13, 70, "Input",
 CellID->13173462],
Cell[55761, 1347, 1243, 43, 60, "Output",
 CellID->367032819]
}, Open  ]],
Cell[57019, 1393, 124, 3, 70, "ExampleDelimiter",
 CellID->77218932],
Cell[57146, 1398, 166, 6, 70, "ExampleText",
 CellID->885892004],
Cell[CellGroupData[{
Cell[57337, 1408, 2177, 69, 70, "Input",
 CellID->27091520],
Cell[59517, 1479, 632, 18, 36, "Output",
 CellID->46604999]
}, Open  ]],
Cell[60164, 1500, 124, 3, 70, "ExampleDelimiter",
 CellID->48984343],
Cell[60291, 1505, 71, 1, 70, "ExampleText",
 CellID->519084146],
Cell[60365, 1508, 1017, 32, 70, "Input",
 CellID->61660678],
Cell[CellGroupData[{
Cell[61407, 1544, 391, 13, 70, "Input",
 CellID->96961787],
Cell[61801, 1559, 772, 25, 54, "Output",
 CellID->258708550]
}, Open  ]],
Cell[62588, 1587, 84, 1, 70, "ExampleText",
 CellID->130672253],
Cell[CellGroupData[{
Cell[62697, 1592, 440, 15, 70, "Input",
 CellID->523936525],
Cell[63140, 1609, 556, 17, 36, "Output",
 CellID->525671115]
}, Open  ]],
Cell[63711, 1629, 124, 3, 70, "ExampleDelimiter",
 CellID->63781873],
Cell[63838, 1634, 71, 1, 70, "ExampleText",
 CellID->178845503],
Cell[CellGroupData[{
Cell[63934, 1639, 309, 11, 70, "Input",
 CellID->418586823],
Cell[64246, 1652, 234, 9, 55, "Output",
 CellID->283589405]
}, Open  ]],
Cell[CellGroupData[{
Cell[64517, 1666, 3139, 106, 70, "Input",
 CellID->79880886],
Cell[67659, 1774, 233, 9, 55, "Output",
 CellID->63526566]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[67941, 1789, 226, 7, 70, "ExampleSection",
 CellID->31657],
Cell[68170, 1798, 339, 12, 70, "ExampleText",
 CellID->22386640],
Cell[CellGroupData[{
Cell[68534, 1814, 288, 10, 70, "Input",
 CellID->748429791],
Cell[68825, 1826, 451, 8, 70, "Message",
 CellID->458437376],
Cell[69279, 1836, 158, 5, 36, "Output",
 CellID->767656662]
}, Open  ]],
Cell[69452, 1844, 125, 3, 70, "ExampleDelimiter",
 CellID->296072276],
Cell[69580, 1849, 242, 7, 70, "ExampleText",
 CellID->69617962],
Cell[CellGroupData[{
Cell[69847, 1860, 318, 11, 70, "Input",
 CellID->421045641],
Cell[70168, 1873, 261, 9, 60, "Output",
 CellID->106645210]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[70490, 1889, 310, 9, 70, "SeeAlsoSection",
 CellID->9783],
Cell[70803, 1900, 730, 26, 70, "SeeAlso",
 CellID->15791]
}, Open  ]],
Cell[CellGroupData[{
Cell[71570, 1931, 313, 9, 70, "TutorialsSection",
 CellID->8884],
Cell[71886, 1942, 156, 3, 70, "Tutorials",
 CellID->20373]
}, Open  ]],
Cell[CellGroupData[{
Cell[72079, 1950, 321, 9, 70, "RelatedLinksSection",
 CellID->20031],
Cell[72403, 1961, 369, 12, 70, "RelatedLinks"],
Cell[72775, 1975, 186, 4, 70, "RelatedLinks"],
Cell[72964, 1981, 208, 4, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[73209, 1990, 319, 9, 70, "MoreAboutSection",
 CellID->429333367],
Cell[73531, 2001, 178, 3, 70, "MoreAbout",
 CellID->306726950]
}, Open  ]],
Cell[73724, 2007, 27, 0, 70, "History"],
Cell[73754, 2009, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

