(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21684,        824]
NotebookOptionsPosition[     16815,        653]
NotebookOutlinePosition[     18144,        691]
CellTagsIndexPosition[     18059,        686]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Working with Operators" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/WorkingWithOperators"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Working with Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Operate" :> Documentation`HelpLookup["paclet:ref/Operate"], 
          "MapThread" :> Documentation`HelpLookup["paclet:ref/MapThread"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Operate\"\>", 
       2->"\<\"MapThread\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Functional Programming" :> 
          Documentation`HelpLookup["paclet:guide/FunctionalProgramming"], 
          "Structural Operations on Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/StructuralOperationsOnExpressions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Functional Programming\"\>", 
       2->"\<\"Structural Operations on Expressions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Through", "ObjectName",
 CellID->29494],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Through",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Through"], "[", 
       RowBox[{
        RowBox[{
         StyleBox["p", "TI"], "[", 
         RowBox[{
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["f", "TI"], 
           StyleBox["2", "TR"]]}], "]"}], "[", 
        StyleBox["x", "TI"], "]"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      RowBox[{
       StyleBox["p", "TI"], "[", 
       RowBox[{
        RowBox[{
         SubscriptBox[
          StyleBox["f", "TI"], 
          StyleBox["1", "TR"]], "[", 
         StyleBox["x", "TI"], "]"}], ",", 
        RowBox[{
         SubscriptBox[
          StyleBox["f", "TI"], 
          StyleBox["2", "TR"]], "[", 
         StyleBox["x", "TI"], "]"}]}], "]"}]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Through",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Through"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["h", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]performs the transformation wherever ",
     Cell[BoxData[
      StyleBox["h", "TI"]], "InlineFormula"],
     " occurs in the head of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->22642]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Through",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Through"]], "InlineFormula"],
 " distributes operators that appear inside the heads of expressions. "
}], "Notes",
 CellID->31620]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->818908935],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->683251769],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Through", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"f", "+", "g", "+", "h"}], ")"}], "[", 
   RowBox[{"x", ",", "y"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11788],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x", ",", "y"}], "]"}], "+", 
  RowBox[{"g", "[", 
   RowBox[{"x", ",", "y"}], "]"}], "+", 
  RowBox[{"h", "[", 
   RowBox[{"x", ",", "y"}], "]"}]}]], "Output",
 ImageSize->{168, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->78829615]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->239158714],

Cell["\<\
By default, the operation is performed for any function in the head:\
\>", "ExampleText",
 CellID->711977090],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Through", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"f", "+", "g", "+", "h"}], ")"}], "[", 
   RowBox[{"x", ",", "y"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->551062529],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x", ",", "y"}], "]"}], "+", 
  RowBox[{"g", "[", 
   RowBox[{"x", ",", "y"}], "]"}], "+", 
  RowBox[{"h", "[", 
   RowBox[{"x", ",", "y"}], "]"}]}]], "Output",
 ImageSize->{168, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->19198115]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30640181],

Cell["Perform the operation only if the head is a sum of terms:", \
"ExampleText",
 CellID->953336248],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Through", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"f", "+", "g", "+", "h"}], ")"}], "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", "Plus"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->919954156],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x", ",", "y"}], "]"}], "+", 
  RowBox[{"g", "[", 
   RowBox[{"x", ",", "y"}], "]"}], "+", 
  RowBox[{"h", "[", 
   RowBox[{"x", ",", "y"}], "]"}]}]], "Output",
 ImageSize->{168, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->410900807]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Through", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"f", " ", "g"}], ")"}], "[", 
    RowBox[{"x", ",", "y"}], "]"}], ",", "Plus"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->331825111],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"f", " ", "g"}], ")"}], "[", 
  RowBox[{"x", ",", "y"}], "]"}]], "Output",
 ImageSize->{75, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->445979595]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14246],

Cell["Apply a differential operator:", "ExampleText",
 CellID->23757],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"#", ",", "x"}], "]"}], "&"}], ")"}], "+", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"D", "[", 
       RowBox[{"#", ",", "x", ",", "x"}], "]"}], "&"}], ")"}]}], ")"}], "[", 
  RowBox[{"f", "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->27285],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     RowBox[{
      SubscriptBox["\[PartialD]", "x"], "#1"}], "&"}], "+", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SubscriptBox["\[PartialD]", 
        RowBox[{"x", ",", "x"}]], "#1"}], "&"}], ")"}]}], ")"}], "[", 
  RowBox[{"f", "[", "x", "]"}], "]"}]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->625813013]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Through", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10350],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["f", "\[Prime]",
    MultilineFunction->None], "[", "x", "]"}], "+", 
  RowBox[{
   SuperscriptBox["f", "\[Prime]\[Prime]",
    MultilineFunction->None], "[", "x", "]"}]}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->346008972]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23673],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NestList", "[", 
  RowBox[{"Through", ",", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"f", "[", "a", "]"}], "[", "b", "]"}], "[", "c", "]"}], "[", 
    "d", "]"}], ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14943],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"f", "[", "a", "]"}], "[", "b", "]"}], "[", "c", "]"}], "[", 
    "d", "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"f", "[", "a", "]"}], "[", "b", "]"}], "[", 
    RowBox[{"c", "[", "d", "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{"f", "[", "a", "]"}], "[", 
    RowBox[{"b", "[", 
     RowBox[{"c", "[", "d", "]"}], "]"}], "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"a", "[", 
     RowBox[{"b", "[", 
      RowBox[{"c", "[", "d", "]"}], "]"}], "]"}], "]"}]}], "}"}]], "Output",
 ImageSize->{416, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->470405323]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->279342716],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Framed", "[", "x", "]"}], "[", "y", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14883],

Cell[BoxData[
 RowBox[{
  FrameBox["x",
   StripOnInput->False], "[", "y", "]"}]], "Output",
 ImageSize->{42, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->415248804]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Through", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->7768],

Cell[BoxData[
 FrameBox[
  RowBox[{"x", "[", "y", "]"}],
  StripOnInput->False]], "Output",
 ImageSize->{42, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->141507075]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->68444170],

Cell["\<\
Tabulate square roots of values without using auxiliary variables:\
\>", "ExampleText",
 CellID->228422292],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{
   RowBox[{"Composition", "[", 
    RowBox[{"Through", ",", 
     RowBox[{"{", 
      RowBox[{"Identity", ",", "Sqrt"}], "}"}]}], "]"}], "/@", 
   RowBox[{"{", 
    RowBox[{"0", ",", "1.0", ",", "2.0", ",", "3.0", ",", "4.0"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->398812588],

Cell[BoxData[
 TagBox[GridBox[{
    {"0", "0"},
    {"1.`", "1.`"},
    {"2.`", "1.4142135623730951`"},
    {"3.`", "1.7320508075688772`"},
    {"4.`", "2.`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[0.7]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{75, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//TableForm=",
 CellID->104176564]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1271],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Operate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Operate"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MapThread",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MapThread"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30943]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21486],

Cell[TextData[ButtonBox["Working with Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/WorkingWithOperators"]], "Tutorials",
 CellID->27892]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->263763172],

Cell[TextData[ButtonBox["Functional Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FunctionalProgramming"]], "MoreAbout",
 CellID->209873297],

Cell[TextData[ButtonBox["Structural Operations on Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StructuralOperationsOnExpressions"]], "MoreAbout",
 CellID->73049831]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
Through"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Through - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 26, 39.6605048}", "context" -> "System`", 
    "keywords" -> {
     "implementing linearity of operators", "linearity of operators"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Through[p[f_1, f_2][x]] gives p[f_1[x], f_2[x]]. Through[expr, h] \
performs the transformation wherever h occurs in the head of expr. ", 
    "synonyms" -> {}, "title" -> "Through", "type" -> "Symbol", "uri" -> 
    "ref/Through"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5196, 172, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->818908935]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17916, 679}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2049, 51, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2672, 78, 45, 1, 70, "ObjectName",
 CellID->29494],
Cell[2720, 81, 1691, 57, 70, "Usage",
 CellID->22642]
}, Open  ]],
Cell[CellGroupData[{
Cell[4448, 143, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4926, 160, 233, 7, 70, "Notes",
 CellID->31620]
}, Closed]],
Cell[CellGroupData[{
Cell[5196, 172, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->818908935],
Cell[CellGroupData[{
Cell[5581, 186, 148, 5, 70, "ExampleSection",
 CellID->683251769],
Cell[CellGroupData[{
Cell[5754, 195, 210, 7, 28, "Input",
 CellID->11788],
Cell[5967, 204, 346, 12, 36, "Output",
 CellID->78829615]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6362, 222, 220, 7, 70, "ExampleSection",
 CellID->239158714],
Cell[6585, 231, 119, 3, 70, "ExampleText",
 CellID->711977090],
Cell[CellGroupData[{
Cell[6729, 238, 214, 7, 70, "Input",
 CellID->551062529],
Cell[6946, 247, 346, 12, 36, "Output",
 CellID->19198115]
}, Open  ]],
Cell[7307, 262, 124, 3, 70, "ExampleDelimiter",
 CellID->30640181],
Cell[7434, 267, 102, 2, 70, "ExampleText",
 CellID->953336248],
Cell[CellGroupData[{
Cell[7561, 273, 244, 8, 70, "Input",
 CellID->919954156],
Cell[7808, 283, 347, 12, 36, "Output",
 CellID->410900807]
}, Open  ]],
Cell[CellGroupData[{
Cell[8192, 300, 234, 8, 70, "Input",
 CellID->331825111],
Cell[8429, 310, 255, 9, 36, "Output",
 CellID->445979595]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8733, 325, 223, 7, 70, "ExampleSection",
 CellID->14246],
Cell[8959, 334, 69, 1, 70, "ExampleText",
 CellID->23757],
Cell[CellGroupData[{
Cell[9053, 339, 390, 14, 70, "Input",
 CellID->27285],
Cell[9446, 355, 474, 17, 36, "Output",
 CellID->625813013]
}, Open  ]],
Cell[CellGroupData[{
Cell[9957, 377, 99, 3, 70, "Input",
 CellID->10350],
Cell[10059, 382, 366, 12, 36, "Output",
 CellID->346008972]
}, Open  ]],
Cell[10440, 397, 121, 3, 70, "ExampleDelimiter",
 CellID->23673],
Cell[CellGroupData[{
Cell[10586, 404, 266, 9, 70, "Input",
 CellID->14943],
Cell[10855, 415, 713, 24, 36, "Output",
 CellID->470405323]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11617, 445, 237, 7, 70, "ExampleSection",
 CellID->279342716],
Cell[CellGroupData[{
Cell[11879, 456, 126, 4, 70, "Input",
 CellID->14883],
Cell[12008, 462, 222, 8, 39, "Output",
 CellID->415248804]
}, Open  ]],
Cell[CellGroupData[{
Cell[12267, 475, 98, 3, 70, "Input",
 CellID->7768],
Cell[12368, 480, 221, 8, 43, "Output",
 CellID->141507075]
}, Open  ]],
Cell[12604, 491, 124, 3, 70, "ExampleDelimiter",
 CellID->68444170],
Cell[12731, 496, 117, 3, 70, "ExampleText",
 CellID->228422292],
Cell[CellGroupData[{
Cell[12873, 503, 352, 11, 70, "Input",
 CellID->398812588],
Cell[13228, 516, 756, 24, 108, "Output",
 CellID->104176564]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14045, 547, 310, 9, 70, "SeeAlsoSection",
 CellID->1271],
Cell[14358, 558, 451, 17, 70, "SeeAlso",
 CellID->30943]
}, Open  ]],
Cell[CellGroupData[{
Cell[14846, 580, 314, 9, 70, "TutorialsSection",
 CellID->21486],
Cell[15163, 591, 153, 3, 70, "Tutorials",
 CellID->27892]
}, Open  ]],
Cell[CellGroupData[{
Cell[15353, 599, 319, 9, 70, "MoreAboutSection",
 CellID->263763172],
Cell[15675, 610, 155, 3, 70, "MoreAbout",
 CellID->209873297],
Cell[15833, 615, 180, 3, 70, "MoreAbout",
 CellID->73049831]
}, Open  ]],
Cell[CellGroupData[{
Cell[16050, 623, 305, 8, 70, "RelatedLinksSection"],
Cell[16358, 633, 385, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[16758, 649, 27, 0, 70, "History"],
Cell[16788, 651, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

