(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    196763,       4574]
NotebookOptionsPosition[    184288,       4138]
NotebookOutlinePosition[    185630,       4176]
CellTagsIndexPosition[    185543,       4171]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options for Graphics" :> 
          Documentation`HelpLookup["paclet:tutorial/Options"], 
          "Labeling Three\[Hyphen]Dimensional Graphics" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/LabelingThreeDimensionalGraphics"], 
          "The Structure of Graphics" :> 
          Documentation`HelpLookup["paclet:tutorial/TheStructureOfGraphics"], 
          "Graphics and Sound" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/GraphicsAndSoundOverview"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Options for Graphics\"\>", 
       2->"\<\"Labeling Three\[Hyphen]Dimensional Graphics\"\>", 
       3->"\<\"The Structure of Graphics\"\>", 
       4->"\<\"Graphics and Sound\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Axes" :> Documentation`HelpLookup["paclet:ref/Axes"], 
          "AxesLabel" :> Documentation`HelpLookup["paclet:ref/AxesLabel"], 
          "FrameTicks" :> Documentation`HelpLookup["paclet:ref/FrameTicks"], 
          "GridLines" :> Documentation`HelpLookup["paclet:ref/GridLines"], 
          "DataRange" :> Documentation`HelpLookup["paclet:ref/DataRange"], 
          "Mesh" :> Documentation`HelpLookup["paclet:ref/Mesh"], "FaceGrids" :> 
          Documentation`HelpLookup["paclet:ref/FaceGrids"], "TicksStyle" :> 
          Documentation`HelpLookup["paclet:ref/TicksStyle"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Axes\"\>", 2->"\<\"AxesLabel\"\>", 
       3->"\<\"FrameTicks\"\>", 4->"\<\"GridLines\"\>", 
       5->"\<\"DataRange\"\>", 6->"\<\"Mesh\"\>", 7->"\<\"FaceGrids\"\>", 
       8->"\<\"TicksStyle\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Graphics Annotation & Appearance" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsAnnotationAndAppearance"], 
          "Graphics Options & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsOptionsAndStyling"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Graphics Annotation & Appearance\"\>", 
       2->"\<\"Graphics Options & Styling\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Ticks", "ObjectName",
 CellID->21960],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Ticks",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Ticks"]], "InlineFormula"],
     "\[LineSeparator]is an option for graphics functions that specifies tick \
marks for axes. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21462]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The following settings can be given for ",
 Cell[BoxData[
  ButtonBox["Ticks",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Ticks"]], "InlineFormula"],
 ": "
}], "Notes",
 CellID->8732],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "no tick marks drawn ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "tick marks placed automatically ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["xticks", "TI"], ",", 
      StyleBox["yticks", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[
    "tick mark options specified separately for each axis ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->20392],

Cell[TextData[{
 "With the ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " setting, tick marks are usually placed at points whose coordinates have \
the minimum number of digits in their decimal representation. "
}], "Notes",
 CellID->26843],

Cell["\<\
For each axis, the following tick mark options can be given: \
\>", "Notes",
 CellID->14063],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "no tick marks drawn ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "tick mark positions and labels chosen automatically ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["2", "TR"]], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[
    "tick marks drawn at the specified positions ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["label", "TI"], 
         StyleBox["1", "TR"]]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["2", "TR"]], ",", 
        SubscriptBox[
         StyleBox["label", "TI"], 
         StyleBox["2", "TR"]]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[
    "tick marks drawn with the specified labels ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["label", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["len", "TI"], 
         StyleBox["1", "TR"]]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[
    "tick marks with specified scaled length ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox[
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["label", "TI"], 
          StyleBox["1", "TR"]], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["plen", "TI"], 
            StyleBox["1", "TR"]], ",", 
           SubscriptBox[
            StyleBox["mlen", "TI"], 
            StyleBox["1", "TR"]]}], "}"}]}], "}"}], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], Cell["\<\
tick marks with specified lengths in the positive and negative directions \
\>", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["label", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["len", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["style", "TI"], 
         StyleBox["1", "TR"]]}], "}"}], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[
    "tick marks with specified styles ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    StyleBox["func", "TI"], Cell[TextData[{
     "a function to be applied to ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["min", "TI"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["max", "TI"]]], "InlineFormula"],
     " to get the tick mark specification "
    }], "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{True, True, True, True, True, True, True, True, True}}}},
 CellID->16923],

Cell["\<\
If no explicit labels are given, the tick mark labels are given as the \
numerical values of the tick mark positions. \
\>", "Notes",
 CellID->14611],

Cell["Any expression can be given as a tick mark label. ", "Notes",
 CellID->24740],

Cell["\<\
Tick mark lengths are given as a fraction of the distance across the whole \
plot. \
\>", "Notes",
 CellID->692],

Cell["Tick mark styles can involve any graphics directives. ", "Notes",
 CellID->22443],

Cell[TextData[{
 "The tick mark function ",
 Cell[BoxData[
  RowBox[{
   StyleBox["func", "TI"], "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["min", "TI"]], ",", 
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["max", "TI"]]}], "]"}]], "InlineFormula"],
 " may return any other tick mark option. "
}], "Notes",
 CellID->22270],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Ticks",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Ticks"]], "InlineFormula"],
 " can be used in both two\[Hyphen] and three\[Hyphen]dimensional graphics. "
}], "Notes",
 CellID->3919],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AbsoluteOptions",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteOptions"]], "InlineFormula"],
 " gives the explicit form of ",
 Cell[BoxData[
  ButtonBox["Ticks",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Ticks"]], "InlineFormula"],
 " specifications when ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 " settings are given. "
}], "Notes",
 CellID->28849],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TicksStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TicksStyle"]], "InlineFormula"],
 " gives default styles to use for tick marks and tick-mark labels."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->643683418]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->104114934],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(4)", "ExampleCount"]
}], "ExampleSection",
 CellID->9694538],

Cell["Draw the axes but no tick marks:", "ExampleText",
 CellID->409273366],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Ticks", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->52504916],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->71613993]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26480736],

Cell["Place tick marks automatically:", "ExampleText",
 CellID->467350673],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Ticks", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->268606094],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 88},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->115045537]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogLogPlot", "[", 
  RowBox[{
   RowBox[{"Abs", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"\[Omega]", " ", "I"}], "-", "1"}], ")"}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"\[Omega]", " ", "I"}], "+", "1"}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[Omega]", " ", "I"}], "+", "10"}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"\[Omega]", " ", "I"}], "-", "10"}], ")"}]}], ")"}]}]}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Omega]", ",", "1", ",", 
     RowBox[{"10", "^", "3"}]}], "}"}], ",", 
   RowBox[{"Ticks", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->268705798],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWFuIVVUYXnP2OXNmzMrUyWkynbT7/WZKdCFCw6KnCB9EaBysOZGOjWMX
zZrpMmZpmXabHPLFgi4PimIEI0RCJERCJEQJYRD2kARJDwPB6vv/tc6svdf+
99qnmd1LdDhn7fXv9e1v/eu/rXX2fV39PatWd/XXurs67+7rWttT617XuaS3
D7eiJqXUAfz62hX6Gj3+HdAa13S7AG0EwBR7LeFawrXDypGVm73x+v02D1e/
qjLT24//VPyq1CJqiUTzR7VQU3ayeT6O6IjJShgvBxmkJ9oC45lyc3yG7HnI
JU10/X+1//HV3qxNXJ+Ru8p2iyylkM3/eH0z4lwN6j3x9cVnntLQOlVlXC7M
pzNyeYv17EJr41adrGCzY7av10mp0s3ycON1MrJTCs8kq2S6dsfjmrojgbvT
0e7CzWoSs/u9r/FVc71npnpyZ8543vMtblbr5cGB0UOjx7dn46xvx8b+6l2z
/9h3v6p33Zjz4MmTf9R69p469eewNIrP0W9+wfOx0dhsxusff/Ttzh1fUvdt
EcXWjzZu+OzwFz9R960ACop0r/wEbQaK4zwyOlH3TRFVYRlKQTXqvhFAwT6Y
8cSJ3zNQXE0i2A9mou5OEVX1ZtwRQGHGFcs/hOEzUC3eGl8XUa0sbx76/NOD
31N3ewAFe2LG06fHMlBchaJ9e49t23qYuq8xys+shOdtJtKtijfGtTuCuWA0
6r5qaBLVKV2vymJs+aw//vAbvDU5VhKnev7aVoiOhhV2hrUphhtjrVc0345n
sgz3wsnU3dowWzpjnHyW551XUr6uV+By7JpmcJ4wDH5Mnc0yAgphRd2XAyjY
atkDHyAvMlDTWHZ1Zss4ivQ7R9usAgdZfYvIYVAoQShE1H1JRE33rLM5gHIW
kFG8w8YydCiAchYYSvnDz734vwg/ZmbSfWxIQ0KshM9FWojnmZ5lX5wwK4lm
5S6eXyhEx3NZhiPgDuo+XyDrka9+Xt9/sDjWWSy7nfC5lK/904/vX8PgIs8w
+DHFZ8ZYdRsMoNyOK6PO08ncGwigEClIHWiXgerwrPqsiDrfs9IzARR2UdRa
yhsZNZvl4XeOvL/nKHU3BVAuzjel/BLPQZYDOXiBTsb500Ls8DOVcT7Lmhc/
c1h21WmjwNx4Ps7xYkliq3rrztNwrk5G3obCON2uKnHyHpXzv0Ti7vR89VTK
83kZeSHLOKrhwEbdJ7UUYQaFUyZsTdEqo+ZpU72zR+Pn1SdE1HyW3enxcRF1
Ectud14fQLnzqoy6mGV3Qu4XUZfYtWWP8kz2v8o6EXWptjkPC9Bptk9EXcay
2+kfE1GX62Skrg2gnF4y6gqWEZuwANmpNxVFfv0IRdSV2uYl2ChW1ujJ59BV
nk1WF8B5NcsorCiv1H10gpwkXmOjQ+Ko6Kw3Pf7J9FqdjOpHMtjy36f48nUs
o0jYaKmlPFzVyfcTvlevp/sIt5oYQTewDHJMQT5/WETdyDKqFaKRKsBDIuom
7fLx0OhxtUpELWBrIosGB0YxKR0DRNzC+pyoAdBPrRRRi+psWCGAmPZBEXcL
Wx+6Y1ZstsDRaleI2FsZi3wyWDDTyWK5iL2dmioWARVRHKACogAHDWJfFguW
+ifl70A+3klNC3RGVOHgsviuEZgfsYpsws37mdbn48CYwH60mJpWVG/wI1Wx
jjtuG4YfYQLcgQKqhEGugfaJpYXOfw/7EbEDz2BCGLGExaoy7A9F8L136W7a
7DjL7LuvMjVUW6AZKdfGGsLylnP+pDUkke1cQYSZWfAlazTz3LAUdCK12lg3
uMhoq9qpicxWyG4s1Foj/wJb6Oyxh4fS7zFV099vxTN2\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->147467735]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->37534888],

Cell["Place tick marks at the specific positions:", "ExampleText",
 CellID->675454451],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "Pi", ",", 
        RowBox[{"2", "Pi"}], ",", 
        RowBox[{"3", "Pi"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->108358651],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 94},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->147047150]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "Pi"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "Pi"}], "}"}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"Pi", "/", "2"}], ",", "Pi"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"Pi", "/", "2"}], ",", "Pi"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->90566560],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->150543129]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3532064],

Cell[TextData[{
 "Specify overall ticks style, including the tick labels, using ",
 Cell[BoxData[
  ButtonBox["TicksStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TicksStyle"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->256827188],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"TicksStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Orange", ",", "12"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->120129542],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->191588757]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3005],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Ticks Positions and Labeling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->42004294],

Cell[TextData[{
 "Place ticks on the ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 " axis only:"
}], "ExampleText",
 CellID->145201073],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "None"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->648906278],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 111},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->291856482]
}, Open  ]],

Cell[TextData[{
 "Place ticks on the ",
 Cell[BoxData[
  FormBox["y", TraditionalForm]], "InlineMath"],
 " axis only:"
}], "ExampleText",
 CellID->278000827],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", "Automatic"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->214875249],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->28331926]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->147669509],

Cell["Draw tick marks at the specified positions:", "ExampleText",
 CellID->116441539],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Pi", ",", 
        RowBox[{"2", "Pi"}], ",", 
        RowBox[{"3", "Pi"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->709539987],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->602658270]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->227146176],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True,
  Ticks->{{{-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}}, {{-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}}, {{-1, 
      FormBox[
       RowBox[{"-", "1"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}}}]], "Output",
 ImageSize->{154, 182},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->190925401,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->355108754],

Cell["\<\
Draw tick marks at the specifird positions with the specified labels:\
\>", "ExampleText",
 CellID->58219888],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Pi", ",", 
          RowBox[{"180", "\[Degree]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"2", "Pi"}], ",", 
          RowBox[{"360", "\[Degree]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"3", "Pi"}], ",", 
          RowBox[{"540", "\[Degree]"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->716482942],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 112},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->76757509]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"None", ",", "None", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "1"}], ",", "\"\<bottom\>\""}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "\"\<center\>\""}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "\"\<top\>\""}], "}"}]}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->470900464],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True,
  Ticks->{None, None, {{-1, 
      FormBox["\"bottom\"", TraditionalForm]}, {0, 
      FormBox["\"center\"", TraditionalForm]}, {1, 
      FormBox["\"top\"", TraditionalForm]}}}]], "Output",
 ImageSize->{154, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->219831360,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Ticks Styling",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->545603057],

Cell["Specify tick marks with scaled lengths:", "ExampleText",
 CellID->101010188],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Pi", ",", 
          RowBox[{"180", "\[Degree]"}], ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"2", "Pi"}], ",", 
          RowBox[{"360", "\[Degree]"}], ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"3", "Pi"}], ",", 
          RowBox[{"540", "\[Degree]"}], ",", "1"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->205402728],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->74344655]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6626447],

Cell["\<\
Specify tick marks with scaled lengths in positive and negative directions:\
\>", "ExampleText",
 CellID->343485730],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Pi", ",", 
          RowBox[{"180", "\[Degree]"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", ".5"}], "}"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"2", "Pi"}], ",", 
          RowBox[{"360", "\[Degree]"}], ",", 
          RowBox[{"{", 
           RowBox[{".5", ",", "0"}], "}"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"3", "Pi"}], ",", 
          RowBox[{"540", "\[Degree]"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", ".5"}], "}"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19933071],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WkmMVFUULbp6oOlu6InJgW5RmlGmpimbGWQQG2xRcUIWDTGBhWIQN7LR
jWx0oxvdyMIpoguMBGOCiZHESGIkMZIYNTGYGFxITCQuSEzK8977v86vU7ce
v6Kxk67697/7znn3vPuGev/vnjh26MmnJo4dPjgxuOPoxDOHDh98dnD7kaO4
VZxUKBTO4P/4rAKuy7jy/2fKZXxnP0v4LKKoCd9N+C4m30PJ/aLcn5fcb3a1
mx1m+udKOz3mXdVlCXqhGO4UxHaXQ5Fyy9+1otCSZa94VfF2/J/tyZS7y0JL
MNg+szWJcrVtH8qWtGZLamNQTaSl/4kmag+KXTTZmsVrTrk6n25co7mR9rZJ
TiRlc2tqF+07GbwBI367xVozdHxJIk2/WwxF0hGV4lt+Axmc2vxR76Ba7XgP
n20J5ylvTbbqZuxlYh8QuyMjQ/hrElUs1KX+5uXLf+DWxW9+vXr1r4maOx11
2+fMJc6Y/OMPvx95+uP9+97HHVzsGX/ruWNnAbLfl1746peDBz7Mlr74wrkr
V/5szxX5YvfR8tHpS4cPnUaLytmREZBRVtjnvV579UsQozVVXp+d+wle57/4
OXDdkHGRt0+++fUrL5+/fv1vI6tx98RLn8Oj8Jj3hfHO2xfL6Qit8r127frx
5z/95Oz3vsdDv7u+aRXWhSkrgvCXUl5MmT449a27fNjbcE5s2x9yQCQvjmef
Jl4LUh3haGkRbPRaIv1D3gZl0kr1D6zQB4q7LLJZ53sbyYWkgD72yCmiBOXw
KjzobeAB1fWI7Y9y5IjDa46wiiKZ8hbRYk8aC1CRUzU9FvyRfciTSuw1rENp
DiLp3aWitKb9ihRxl/d7G+n0xusX6vujSZe++62ScTWs89K2P7L3Xadgm4mC
EpQ7RcfFtv0xaJM8qM/ahBTWEdYmWXOftyEIZGG5zmaKfoe00WZhzLu9jZ5D
1rhL9Y+xcFxprckSyy5vY4hjgsnPcrvE0m6yMJYxiUX9YyyMRWu1Syz3Siz5
WOZKLFNMFsays5yMVoxud6n+MRaOC60VbBQmM/E9Ens+ltukrR0mC0qwirnL
HRK7+sdYOCeYtTL9sF1ib4QFCZMsiDYLBjSmd7IgEAzz/CyD0pudUt4prdjq
bQSG8Cz/GAt712bhXLxVFMzHMiC932WyYIVB77vevluyQf1jLFRAawWbs+MW
6f1GWKiAzcLVbov0fj6WOaLAVCkPNgrh4i43latzTv1jLFTAZmF2bBIFG2FB
GiOZ67Mw0zem2TK286TLBsWzWW4VBbQ82FzfN3ibc0UjLBgMGBL1WTheAgv3
RvlYbkkVSMZLt8nC8bJebPWPsTBTtVa39PY6ia0RFu7DbBb2Q2Dhzjgfy82S
Mz0mC8vXehtDEgq7S/WPsbCtWqtHFFtTrh5fjbBwhrFZ2IrAwpUgH8tNkjO9
JgsVGy1Xj1L1j7Gg65EAVq1eUcydhbidbl8D6BxdNjqV8ictmZkoXwyzRSlt
W68oVRKl8sUyW5TSWn2i1OpEqf4G0KmUjU6lVotS+WKYJUpp2/pEqRFRKl8s
s6StWqtflFqVKDW9AXTWttHJvkqUyhfDTFFC29Yv5cOiVL5YZkpbtdZ0iXWl
tzlfNcJCFJuFrQgsXInzscxIFUFuubOIGSYLFVvhbc7w6h9j4ZqotWZIrMtF
MZvF7W/fw81JJmel5UlkAZOjaKbpz73hvAgqIwl6cAaw9ePqHkPl/iegctay
Ubmax1C5m10hCihqf1qOvnaXQyZq8OKOcFjaYo85xhJDpQLDopuNSt1jqFRg
WPpYUftEofkmap8oMCIK2PMzFYihUoERUcBGpQIxVCowIgooaq8osMBE7RUF
SqKAvZZTgRgqFSiJAjYqFYihUoGSKKCoPaLAQhO1RxQYFQXsfR8ViKFSgVFR
wEalAjFUKjAqCihqtyiwyETtFgXWigL2bwUqEEOlAmtFARuVrDZqsLkWrEsV
SM7BFHWaKLQ4gsqTkfB7kb8w7N+XPL+MoRJlvbDYqFz3bdSp0qcbRBFFDf5c
55dEUNk7G6X3LH+3Z7wzgsZIAhoM3KqHlt0j2m3skkg2Sy09N+kSVrutXUkk
W5Jvm5VK1EfJnmJtlrZq2zql15aaqMGLe5Rw7scxYp8TcicZQ2VeBlSOZxuV
rDZqOLXlSNyaRljnTDP4c8e+LILK/eM2b/N03TxfzZTHUNlb26QtijoljSXZ
Oy83UYMXx/cO0dk+0+csEkPlyhBQOVvbqFwjbNTwbITPdcKzEZ6R2M9SGNuK
CCojDqjMRxuVrDZqeCbFsTQmEdrPsNjWlRFUZsqY9IaNyjnNRg3PAjkKdqWZ
g8xCBDWobdIPwxHUE5Uzwt2iq/1EkiPWRm0V7nHpDftZLHVdFUGlTuPCoqgt
qULJk/sREzV4cY7aI4pYz8jdbL7aRGtOewmcbm56wNt87q9owR8BQVLXqzZq
5R0EDFYIn7yzwJGqz/0r/klulCKoXH/2Sp7ab0JwDAZUlyHOSb2bEp0eTVlw
TZRqv6ze/qSwJpt9Lb6vBkFP+NdVHk/RYbrVTt5rg+SQDMhr6qO6t9sgJVYC
jCz3VssT7m47rqAe7qJzggcWCtzBZBl2nCaaM31/J/c8VhuagcrI3IJ/Xwig
lR2m3aaMre9Frf8XtVxfuTd1whtatW9wFSb9A/Ugepw=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 123},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->244083594]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->114741329],

Cell["Specify the style of each tick mark:", "ExampleText",
 CellID->4603537],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"Pi", ",", 
          RowBox[{"180", "\[Degree]"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", ".5"}], "}"}], ",", "Red"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"2", "Pi"}], ",", 
          RowBox[{"360", "\[Degree]"}], ",", 
          RowBox[{"{", 
           RowBox[{".5", ",", "0"}], "}"}], ",", "Thick"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"3", "Pi"}], ",", 
          RowBox[{"540", "\[Degree]"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", ".5"}], "}"}], ",", 
          RowBox[{"Directive", "[", 
           RowBox[{"Red", ",", "Dashed"}], "]"}]}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->278680862],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 105},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->38450584]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->987505375],

Cell[TextData[{
 "Specify overall ticks style, including the tick labels, using ",
 Cell[BoxData[
  ButtonBox["TicksStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TicksStyle"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->64237016],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"TicksStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Orange", ",", "12"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->385529678],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->2346499]
}, Open  ]],

Cell["Specify ticks style for each axis :", "ExampleText",
 CellID->93798502],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"TicksStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Blue"}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->138675862],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylWluIlVUU/udcZpxpTGdGm5vjjDPjOI63dJzG8Zr3W2ZSZiA9TBJoUIbZ
S73US73US71YREJW0OXBSIzAIBIiIRIiISoIg7CHJEh6EILTt9fa+6z/fLPP
b2cUPWev//Kttb512+f/3Td58ujjT06ePHZksm/nicmnjx478kzfjuMncChf
lyTJOfx7oiPBuoSV/DtXKuE7/dmAzzzO5JzkFvonyWF5Rq6YQWfy7qNgclIq
+iv8oeRNOawXJvLXoeVrxlkiV/z8058fffj9J2evXPnhj8NyBIv33r382fkf
r137u7lWG71Fi508A0hHHvsYf19/7etXX7mIxbGjZ3HwkJy99M1vhw6+jyNv
nLr08ktfYn38qU+vXv2raZq8DIsMuwEJr5KCyFAHWBxNDop8+u1vnz15Hq75
85e/+x3Xw5akcZp6FwW9cMIt60W+efNfyE7vgyKDAqi28zdu3Hz+uc+d3hnl
THFxrE99p7UMifzFhV9efOGCW4q1eUBc/OpXt3xAZAQObAq9wQp4Dw4EP0na
U3Fyy4UpjnBt0hTuQqwQimS/yLAS592yKdiO847D+kpUb+tgQHn08AfuKsmi
PPBwl9OyT+Tr1/+BjE9/HpHwWooZqOAR+eqWM8nj+0QGPSDJziPvkNwSxCjq
gMjIF9jilncSA3sDA8gaOw+rva1ZqBadWSJDwCG33CMyVECxW86NRqefdLcQ
6i6RQQdIccu7orb0k64W8nhn8BgV6KLRHkVZQB60kS07yJYsFLOljWxRlAP7
z8CQ6ih9lC9zyZZtZGtHlF1FAbUg2FCM7W1ka0fUll7yoJ3u2kK2dGagWG63
E5tbyMM4yvySr04Q6Oqsg+TNIXchu2VXlBdFQdGgdMq68trM3PJefOTQy7oz
bDD/9W50GHRZt9xE2aYoofulp1iYbNwJe4hxQcij1aBc3XIjMa4aBKWijzek
dMkyqsdionqs32ykmKgensu+mZna5FZ65wWGECXEzssWtQ0kz6vVP2+d4tpE
UX+tHtb7OPdUwS+W4pNKcVGaKFDDNT3rRUb4MRqy7A9zNhzhuavxAAigSuXM
M97WUeb1VGRa+I6jWpR7RbYpslZknMQlhspVoChWBb1ki6JYnyMUXwBSn25u
IrndcgExt0Zk64Pzo7Z0+Tj2++8J8qj6XemqWkC2jBPbvVEUrv4BQr1HZOu5
hOJ56CTOByhGimIdKssWY2+A8mcseLR392nXLfuiKB3kke6gdF/rlqtLldle
HaWA41or5f7gc9x6r5uPOX9dLnQX3eIIprs158/lq9tbcC6GrhrXaf2kVe5I
9yzJhfr0EaWoY8qVzpY6fNfJdyyWIhfK/OGKbs+F9ivrGy1xO4rpI6BC4/p/
rfCXiFwsZ5Te5nO+TJTfQ9sUnmpRdzkutu+siZUKe8q56fUHdLXDMrXFR747
xQfCgYXL2+nwITvHMFMTvSOdI53eEv3VYdneQtd1pXQ7OpKKI7VY4zqVpLQO
Uz9FTJNmi/WAVm+hRUTDEdgNFRKpFB9v5cB6k/yGTXW8FaXKjjcQtX0u3bWE
UJeXKjtedRTHwFL/rbqtw2XpNl1LyJZl5IH8okrm4LPgYg6cUyH2U7CLxH+B
5PJ5H4+q5291f9Z5q30t3Sl5yii3q1XwC+VZGfYpt6Eh3qXnlCrrilG6SdaO
YFOI61B7UHl/UZpaP3E79PeYdRrNO5uZIyLbjmNhBorVpqLY/B4hmVB8PbYR
JyvI5xGyLW5LK3m0UmTbeQ0T6lAGik0CRbE91DB5lIViE24lsTlMHsVRNNY2
r0fJoyHyaFGUXUWxncYoeTREHi3KsMU8GiWPhsijOMps8miMPBokj4YzUMwj
RbHfb4PkEaF4XmaTR2Oke5A8itsyizwap7v6CXVxBop5NE4e9JOchWIejZPu
fmI7jqLPvayOJsgjfiYzEmXXobh5ttZ/668Km2sjGbptrk2QLb0i21yTuSc9
stozBf7VN5M4WUec6W9Le6agGmQPkvmbOxfVY1W2jiKsemwvOV09zYER/5RF
f3Pbk6AekpfWqsc/Q2gmXjaQ/fPIv2p6wrMEjovi2zMWxbfdk+Lb7+ws/LQf
BdJzR8nXK/hyfGwk/nT+2jOnZRUZFp4lxFFtDm4S2TpSF8mKyjWjKFZpimK7
us5gq8/+5ZUo3pYmYk6fBdrTng6KVBaKxWMzxb+D4hFHaSS2t5KHuhO3alyR
gWLsKQo9DU/ZSiie3fJ7Es/eNpJ1T2295u6oLfxLcTvZNofkOEoDZd0O4qmN
5JUZKGbLTtLdSnIcpZ5s2UW6W0heFWW3nipgN+nWaWv9cFXUliLp2kO26YSz
6hzNQLFZs5cyXqeM7TfjKFrjVkf6LsvqqJlQV0d50ZmE/EINOw/uDx5Cdlmn
NW9vzMaituQCD/5Nor4DxMiCOe6uxnDev8uS52SSq9XeSXP/zRFnB0Ju+Xed
DWSB7C28XkOe+g5VWKwv69GXodDxUMDHCHE8FAMP/h3tmlrwi8AHGUg95Ama
QPKwO9qI0QQZOYk4w3Jcoe+m3TvjiVrwC+U5CFMfETqwgDoYu33rW9g9IA1c
HNbWgjrlTf907wvTKbxRfkeOTv0/Ckndf62bpqg=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->105923269]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->537694265],

Cell[TextData[{
 "Individually styled ticks can be used with ",
 Cell[BoxData[
  ButtonBox["TicksStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TicksStyle"]], "InlineFormula"],
 ", and have higher priority:"
}], "ExampleText",
 CellID->232700368],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Cos", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"{", 
         RowBox[{"Pi", ",", "Pi", ",", ".5", ",", 
          RowBox[{"Directive", "[", 
           RowBox[{"Blue", ",", "Dashed"}], "]"}]}], "}"}], ",", 
        RowBox[{"2", "Pi"}], ",", 
        RowBox[{"3", "Pi"}]}], "}"}], ",", "None"}], "}"}]}], ",", 
   RowBox[{"TicksStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Orange", ",", "12"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->80169133],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->147312461]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22411],

Cell[TextData[{
 "Specify a grid function applied to ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["min", "TI"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["max", "TI"]]], "InlineFormula"],
 " values of each direction:"
}], "ExampleText",
 CellID->814353806],

Cell[BoxData[
 RowBox[{
  RowBox[{"ticks", "[", 
   RowBox[{"min_", ",", "max_"}], "]"}], ":=", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"If", "[", 
     RowBox[{
      RowBox[{"EvenQ", "[", "i", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "i", ",", ".06", ",", "Red"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", "i", ",", ".02", ",", "Blue"}], "}"}]}], "]"}], ",", 
    
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"Ceiling", "[", "min", "]"}], ",", 
      RowBox[{"Floor", "[", "max", "]"}], ",", "1"}], "}"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22894193],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", "4"}], "]"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"Ticks", "\[Rule]", "ticks"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->545912847],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}, 4],
  Axes->True,
  Ticks->FrontEndValueCache[$CellContext`ticks, {{{-4., 
       FormBox[
        RowBox[{"-", "4"}], TraditionalForm], 0.06, 
       RGBColor[1., 0., 0.]}, {-3., 
       FormBox[
        RowBox[{"-", "3"}], TraditionalForm], 0.02, 
       RGBColor[0., 0., 1.]}, {-2., 
       FormBox[
        RowBox[{"-", "2"}], TraditionalForm], 0.06, 
       RGBColor[1., 0., 0.]}, {-1., 
       FormBox[
        RowBox[{"-", "1"}], TraditionalForm], 0.02, 
       RGBColor[0., 0., 1.]}, {0., 
       FormBox["0", TraditionalForm], 0.06, 
       RGBColor[1., 0., 0.]}, {1., 
       FormBox["1", TraditionalForm], 0.02, 
       RGBColor[0., 0., 1.]}, {2., 
       FormBox["2", TraditionalForm], 0.06, 
       RGBColor[1., 0., 0.]}, {3., 
       FormBox["3", TraditionalForm], 0.02, 
       RGBColor[0., 0., 1.]}, {4., 
       FormBox["4", TraditionalForm], 0.06, 
       RGBColor[1., 0., 0.]}}, {{-4., 
       FormBox[
        RowBox[{"-", "4"}], TraditionalForm], 0.06, 
       RGBColor[1., 0., 0.]}, {-3., 
       FormBox[
        RowBox[{"-", "3"}], TraditionalForm], 0.02, 
       RGBColor[0., 0., 1.]}, {-2., 
       FormBox[
        RowBox[{"-", "2"}], TraditionalForm], 0.06, 
       RGBColor[1., 0., 0.]}, {-1., 
       FormBox[
        RowBox[{"-", "1"}], TraditionalForm], 0.02, 
       RGBColor[0., 0., 1.]}, {0., 
       FormBox["0", TraditionalForm], 0.06, 
       RGBColor[1., 0., 0.]}, {1., 
       FormBox["1", TraditionalForm], 0.02, 
       RGBColor[0., 0., 1.]}, {2., 
       FormBox["2", TraditionalForm], 0.06, 
       RGBColor[1., 0., 0.]}, {3., 
       FormBox["3", TraditionalForm], 0.02, 
       RGBColor[0., 0., 1.]}, {4., 
       FormBox["4", TraditionalForm], 0.06, 
       RGBColor[1., 0., 0.]}}}]]], "Output",
 ImageSize->{154, 153},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->697466641]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23117],

Cell["\<\
Put a major tick with label at each integer, and a minor tick in between:\
\>", "ExampleText",
 CellID->349111521],

Cell[BoxData[
 RowBox[{
  RowBox[{"ticks", "[", 
   RowBox[{"min_", ",", "max_"}], "]"}], ":=", 
  RowBox[{"Join", "[", 
   RowBox[{
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"Style", "[", 
         RowBox[{"i", ",", "12"}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{".04", ",", "0"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"i", ",", 
        RowBox[{"Ceiling", "[", "min", "]"}], ",", 
        RowBox[{"Floor", "[", "max", "]"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"j", "+", ".5"}], ",", ",", 
        RowBox[{"{", 
         RowBox[{".02", ",", "0"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"j", ",", 
        RowBox[{"Round", "[", "min", "]"}], ",", 
        RowBox[{"Round", "[", 
         RowBox[{"max", "-", "1"}], "]"}], ",", "1"}], "}"}]}], "]"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->540529205],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", " ", "y"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "4"}], "}"}], ",", 
   RowBox[{"Ticks", "\[Rule]", "ticks"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->93362669],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 151},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[2]=",
 CellID->44206900]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(7)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->943],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TicksStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TicksStyle"]], "InlineFormula"],
 " affects ticks and tick labels:"
}], "ExampleText",
 CellID->730034636],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"TicksStyle", "\[Rule]", "Orange"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->178370624],

Cell[GraphicsData["CompressedBitmap", "\<\
eJytWVlonUUU/nPXJE3SLE1yb3qTJuk11qV70tU0tZQ2bapdtFQU0ViE9kEr
tb7oS3xREH1REPtioYvQ6kPFUhEqiAWxIBbEgqggFaQ+WASLDwXh95w5M//5
73fnbtWQ3MyZmfOddc4s96HZY4eefW722OGDs8Pbj86+cOjwwReHtx05Sl3J
piAILtDfG7mA2iG1zN+FMKT/5Z8Z+kyFc0GaqSTPND/BSTOaNb00zH1zQYVZ
NMMM84wEfSTjXNRMRVwyZ7Ohb926/c7bXx3Y/0GQmJo8HiRfefmza9//zkOP
G9QWQEmC7CkDffXb35584uyH5767ceOvhJlx+ctfDh86T9B14mwy9OeXfn7p
2MWbN/82HgmShEgKcfOxyE9BKkLxeGzS0GQCSb99+5+g2dCfXvzh9de+4OaB
yKPsowxwP2BoMuLgMx+RZ4JWnnfi/W+Ea37cg9TcaGiSQrJ++vGPoM3QR57/
hNzBzf3AJTKE6/h7V86cvsrNNpDp59pg6OvX/6RZbFeH8w+5mJuPVuEil175
+lduyjhBkLrcfMRr13oXQev7TkMTBAH5uETWesDuMjRBEBA393m51oGsbkMT
BAHV4lJZPSBrr5drraEpOBQibi4A2cgl3lgL2L0ge49X1hqwo8/l96tzl2px
UUgpsMpF8aYFyqvCzzUR2pW8d/cpzo0coOz22jUBGZRzeUiyfFxxWTSFJnIz
Dxn2sJdrHDJoADwvXLwqk541LdzkOHKfcqtXJp39Fs2sDbvyffVP6NUOZWbH
CfZaISxdl1ILPj5/7a03Lytqo1VWpGj9KUBeiBQqILbqNqK7en0QcjKqFlSV
Q7fua6KuMjR5lPKIm0OGJneQUxwqV8POBtA0v4YAfQNk0vwoB3yVeRX4aRF4
QCqCru1OyEPJ+ZXgl2GIjqBQwCnsPhTRZaX1wwhk0FpHk4VcybsqcsftHoHs
lhqglcKPsgLsHQWuNYCKKOKPFWDvKFg0AXR3FV3IaAouNxeD7HHQzY+yHCwq
AhdWAT8KVzE+IPSAZRnI1rzNs7h1rs9UwhT1yBqm34Qd6fDKzMexCbIHIoyy
c9IZO8WIVSI33t8f94GpODij3RvXAZAoe7GciriZtl7Kl2kisippYr1flyYi
eSFoImcJrbJp8J3RPBvH1fjkbBT6XXyk38bnzrUpjRRLYC2SDjeWc31lcqQn
ytIGdCn3MUbJ1cKFEKUwFHn9FbSJ9G1AG5f73RAfrPIDdp4p91EI+m1vdF6x
EXM7pG/tSKYuhQjcAx5fFpZWgV6v9veD5+4FrmWAWhmF6/p9pl/PU0udVfG6
nlK+IGiqohVtNbThcFNwdc+ScT0Vdcf4gwiV7wcsjH34biA3qSY7CnJtrUtB
zNJA3/E4+YZ+G+ava35LPL8j3zMxF5RV0P9qUSIWUcbPwri595XH1e5MWEXa
Ic7zYByrcQLyoA/GpQ5oXqB2LU6fMJ4nkZa09jhLZQ3oWUfWgJ51ZFx3yP5S
FJpFc80sXhOyO+uaEG7d84Fb9jQ7S09ty8HyJYbWPT+nKJzyUSGReXo3kROH
ns2XgC2AQ/9l7cs8PdEKjp5JZVyrUTmO1JQlYJec6fTmPxaW1qO84qTFO1pN
xsC2VWCbjGtFRizzY6M1BvbhiX4M7PNiSeLZuWrjarCxCDYOKFYmworMLIKV
42BlEaz0okWGFsHOcbCzCHYi2lyJqUWwdAIsHYUsXaho2bhuGtNRWHtrwNpR
yNcYYmz/kDohFnOTbwq8FuWeoWsxuofY+3ChCppWlRHwkaDq2hyG+dVQ1fJh
yAq5UWnVGQabEFVOBUnwzyJD64vGOvDAIqeFPXcMenVNgm7CpTVMXrD0pUdu
rHqKEFQ+EXExxvuu0LoLDIL/NgA9BP4W9FrvpCnI/EHw50awqQArY6iGFHm1
SAFXAfwtrxa6WgugVS0pQqfBA7Kv6ouBSNFVVAAPNyJFoyhS9K1EXo909Q/4
sqROKboOBEXfeeR9WyvAgC/DTW4lPC9gcv7R/M8D9yaITx60MauubJVlQMcc
cG02tJ6ac+BJRBVds+BPuTlqBdgM/s1BPKqh6othP0h5EFD6wLYRL6rcbnS1
9ALXFrBYULVCIKr4tRnyuBe4tjg/23ot49QimqM3WkVXnbUA6K0gdQHkjB+1
BWb1AL0VdO2BTFtcBVV16wZ6Wyg7GUrzo7XCrC6gt4GOXSCt6I1SK3DJW4B+
wzIN/uwEqYgqus4DrvkQ+2knlcoYbbx2nFpEs9S7vKhtkN1y49ATyU5D697S
AVKroepKbAPddoWl61/GdSWPeVHbbWzbwF+7XOYQOvt7nosS0Vxt7vZGSSzR
s5hkFnxzwDbQFPZfi7OBPEEscqIv07HD6UIuZUubY/5jlD1gaTN4QlC5JqU8
J4EopoTOOmQcGvmZLd3naLKB6bTThqS7Oxe8r0d7skox+ZgiLrKcNCNB8tZD
viEcUpwMMd8KtpDS0bez1EGftFNTD9krbxI1zwNm/WZIN5I1NXmcfiW3zPei
WYqhfIdM/fRJbY6ved2wqwzvvvjddX2zzB5Q8pZ1NvIU75rnDFXpO/Y2wDwT
9fJN31xKbF7onFNRL885XTaHb9+nqvS2W05xqAyerKplPZ9Pg5Z4Fpkxs56C
XjxTmJoRbKfPtFUwGci7Ll+RZLr5sQ3JrvirF8rdYbqn/fNKesqxqqMHFaXt
8FiZqFMCrijMOpGw0zMr4bj/FwkmXnr/ruhvJ9nFRuem7IjfRzMeLZKOLYox
5inIryh7xiujE+isV7PtXst7PDEtz9xpa0UrjDYD7V8d5asqaPoX4jNYaQ==
\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->387486027]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->172046868],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["LabelStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LabelStyle"]], "InlineFormula"],
 " offers overall style of all the label-like elements, including tick \
labels:"
}], "ExampleText",
 CellID->287688071],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Blue", ",", 
      RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], "]"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->852841955],

Cell[GraphicsData["CompressedBitmap", "\<\
eJylWVuIVVUY3p5zZs7oOM5NZ85xdJzRdNQszRm1Sc3MHBURNTMpEZok0Icy
zF7qpV4Kol7qJSGSNKPbg5EYgUEkREIkREJUEAZhD0mQ9CAEu/+y1v73/vY6
lyHR4/7XXuv7v/+y/nXZuyZPHHniyckTRw9PDm07Pvn0kaOHnxmaOHacmorT
oig6T/9eqUT0HNOT/Dsfx/R/rd9W+m2hXi0sFbm//Inekbdl1xq71lbotVnk
Gzf+ufLd77du/RsdklFRUf6TvwX6KQIK62KQTSyUP7vw46GDH+zdfebYU59u
3fLW8899fu3aX9FBgZgOI0ugf6M0kmYa9eILF2mg6rr01a+HH/+YkKNHBWcG
4BQBZ4PIivPFxV+cnSS//NKXp97+Nnok8VXUkqA4I9FzivXsiQuXv/mNH9tE
JqBPzl3lxwOJZ5kQY5KPZFSBVM3wmskbV3/4w/XuAh33iEwKSA0/tot8/frf
ZPXNm7eih4Ojxj02+Zv6Rh0iE63XXr3Ej/vrjDr55uWz717hx1kik6Kff/qT
Hx8KjrrbMyJdnBmdItMQGpgdxdaPex9RyPhR0SgYFEh+3BfUsQ4wu0GuN8qw
e0B+MDhqLWD3gmyj2B7VQRlJycSPs0HH3qCONbGbTQf2v8c+mxO7XKaB9Udx
5vRDXPYEe4/5HCAdpCnSUeR2cn6jUWQMmcSP/R6Fpi3nm41i69cAk4rIb7z+
9Ucffs+Pu4M6RsGjVZB1VKOKMAq65op89Mg5mkxxMjs1zfixsynU1eC1AfDa
epFJBSmKff7m6mApoIWVrAbvKjr5lbzLebAebOqaAmerQ/MgJ5Nq4GyS2ZOp
+MwbK/5dkKPzRbZKNA6yorZpZsRhNKtA84HTOHDubspyRaUCSqsSPw6C/9aB
f3sy2aujqXIRB35cALFdB7G30WkOq0SmkkmFkx+HRKZiSGtUnNQT41gPxUYx
Cs/1tcCxNzh6pcg0lAD4cRhGrQGO9VCs/i+MszNqDGRDYW+qBaSQ1Npo0zkK
nGYHOXC94YW3B2KB+xPux6JohLaK1+ySu+DaO4MaK4DcC15AzX380wp7AyIq
lTK3Z9BWMsIAItuV+KaZQWZV6NUDHmYUJtIfYkQGhBn1peIg9SrYa1YmtgPA
pAuiUwpiVEK8SGvFxaPfx4m4NsMk7RtkpLsOi5rs1Uppp7PWkne+JrH6ooaH
NKpT5RX2eTdEzlfHjKfKMMo5JsxRdgwli2IUT4Wlj0A3xNFX72rsZxc9OCV+
dgmfks1r3fXXnl8rYq1ky+Js9bgT5L5kNGfcHXG2Hi51KDrKqkh/UOftcbYe
LgNZ0W01qodili4HTitEtsreFYxAoQ62Wb/c2aeYtCLSihUnc94yRTcavJ8/
GeXXR9DlziG4auI5Bt83kpPxtMrSWtt8/6ngt0UpR9rMiXL7lP+rTWux7p6i
AD6f05KzrfnW7XrmQm89aVlOzID3Urda07bpbqUf+qke27mU4b1EPlPfIPZu
v66Zb/mkmU/kiGKczAzb41SzKHpQy/XSWUiQBBy72ZnegRoKz2V543iOQE9F
omnocnUE7J5rfMjaKDmIYL+VYNcIMAYc+l9Nw36rwLIlwDePoztgtEtx7Jy7
GPgOgIfshIU9dZdq++zFwNiQuPa4hHBxw76KhbqMdRBLVef6rgYLFwHveYaV
yXf1LfYeBSsXAfNaaJo52HsMorgQuBsae78AuYO9xyBHh/2cSp+MchW+AByG
YCbqntzWXkWFE1INVNvnDMEoPS9YvdT3Vo/qoRoXHWWrE6Py6oQ2DGb8WALd
ehqztVrPU7YKLwDug0FuRadbe9tqrPdOdvcwCJbWRktz0lG2piuqLmyJv/CM
2PCWsQRc9ERuNxzjgQxK/NskuvlN0e3Uq3eGdgc1D+JS24ZiEkWoVKmTut5R
2F2VvrfZ05wNukrbeV/XUbsZWQ9aB6C/amlLaYkCN7QqW1VRLTazN4DnqmC7
zElZa3kHEEY3jlXIlY0Q9SrEbbimp3g26YpvM70C8r1xNv/1vc1ZRcf8bwWO
OsqqlKJa/veDDQuDqGXIuD7IkU3eUzt3nGK/KqpV1Hqolll9EL37IHp6i2qz
alEQtQ38Nhss3Ow95O6z54BHDLWQ7MAtpnj/ez/IvZAzt9XhaL16wbItwLkX
OIZRp0OvHvDfA+DfbmCxuA4q3C5ylSduzHUrcO0GFobK/myHt/h9YALkTtC+
JMgx+dZCHPibE36j2Aac9b2tNWHUdshP/V5iM3A7+LcDojgSRJ0Jc0Nl29vs
AIs7wCP1UKmykYX8RQi/I+0EW9pB69JMlNRSMpN6syVJDrhvWbvi9Dcu8+uy
IDdFs9pf9mhqlH4PSFlY9txJG9si53Jp5cM3nu86vSUEwBxavCco0XmPvMdr
I5lc7iok5YZDl5N6ZqXhR1wLxKbpRJCqBqESPDVQeCiHKE5sxT4fV8JlWfZc
JdJDTRoUOfsH77xZkcybMnWjiFAZ3bTxJFVtyk+OnnzPK1P0yEZ6QX8JkYxh
e+XE13A91q/A7dCrEOwl/s/dc7yf+IkBZINX81u0/nZoNsVnRZoFumWD6aJn
rafrtKYRmNGZRq2Z8/PpJhjX/52skSNelnoQPQateL8stUiqpv9aX/S3Dxm+
+ZYCIIVvBJXFRIhr+O6qgdZ8C379El2uxlprW5h/mEMgJ/37sLbt0Fqagh8x
bnhbH9aAvUpT9FRtW3aEPNDYT96jeY15Vg11+jveYla3o17Iv0lblNGn+bc1
2Du5eXdN4bkx4bjMhLdYOcPzLz9vo2n/ARv/QH8=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->107224106]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TicksStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TicksStyle"]], "InlineFormula"],
 " can be used to together with ",
 Cell[BoxData[
  ButtonBox["LabelStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LabelStyle"]], "InlineFormula"],
 " and has higher priority: "
}], "ExampleText",
 CellID->16302533],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"LabelStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Blue", ",", 
      RowBox[{"FontFamily", "\[Rule]", "\"\<Helvetica\>\""}]}], "]"}]}], ",", 
   
   RowBox[{"TicksStyle", "\[Rule]", "Orange"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->610817034],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->17896383]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->657512805],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["AxesStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AxesStyle"]], "InlineFormula"],
 " affects affects the axes, axes labels, ticks and tick labels:"
}], "ExampleText",
 CellID->715340404],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"TicksStyle", "\[Rule]", "Orange"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->423721885],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 138},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->546970220]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TicksStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TicksStyle"]], "InlineFormula"],
 " can be used together with ",
 Cell[BoxData[
  ButtonBox["AxesStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AxesStyle"]], "InlineFormula"],
 ", and has higher priority:"
}], "ExampleText",
 CellID->271652939],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"2", 
    RowBox[{"Sin", "[", "x", "]"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"x", ",", "y"}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", 
    RowBox[{"2", 
     RowBox[{"Sin", "[", "x", "]"}]}]}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Gray", ",", 
      RowBox[{"FontSize", "\[Rule]", "15"}]}], "]"}]}], ",", 
   RowBox[{"TicksStyle", "\[Rule]", "Orange"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->131785817],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 140},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->218929589]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->231209055],

Cell["\<\
Individually styled ticks can be used with other styles, and have higher \
priority:\
\>", "ExampleText",
 CellID->40832033],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", 
        RowBox[{"{", 
         RowBox[{"Pi", ",", "Pi", ",", "1", ",", 
          RowBox[{"Directive", "[", 
           RowBox[{"Blue", ",", "Thick"}], "]"}]}], "}"}], ",", 
        RowBox[{"2", "Pi"}], ",", 
        RowBox[{"3", "Pi"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"AxesStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Gray", ",", "Dashed"}], "]"}]}], ",", 
   RowBox[{"TicksStyle", "\[Rule]", 
    RowBox[{"Directive", "[", 
     RowBox[{"Orange", ",", "12"}], "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->137003631],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 126},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->70373981]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->79769809],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FrameTicks",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FrameTicks"]], "InlineFormula"],
 " controls the ticks and tick labels on the frame edges:"
}], "ExampleText",
 CellID->19748360],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", "]"}], ",", 
   RowBox[{"Frame", "\[Rule]", "True"}], ",", 
   RowBox[{"FrameTicks", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->155246595],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}],
  Frame->True,
  FrameTicks->All]], "Output",
 ImageSize->{154, 134},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->24297983]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->60624786],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["GridLines",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/GridLines"]], "InlineFormula"],
 " puts grids across the image:"
}], "ExampleText",
 CellID->50562259],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Circle", "[", "]"}], ",", 
   RowBox[{"GridLines", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16430822],

Cell[BoxData[
 GraphicsBox[CircleBox[{0, 0}],
  Axes->True,
  GridLines->Automatic]], "Output",
 ImageSize->{154, 146},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->265620263]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->963264167],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["FaceGrids",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FaceGrids"]], "InlineFormula"],
 " puts grids on the faces of the bounding box in 3D:"
}], "ExampleText",
 CellID->545823904],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics3D", "[", 
  RowBox[{
   RowBox[{"Cylinder", "[", "]"}], ",", 
   RowBox[{"FaceGrids", "\[Rule]", "All"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->490910882],

Cell[BoxData[
 Graphics3DBox[CylinderBox[{{0, 0, -1}, {0, 0, 1}}],
  Axes->True,
  FaceGrids->All]], "Output",
 ImageSize->{154, 173},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"Out[1]=",
 CellID->5418666,
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1227],

Cell["Tick label on the axes origin is not displayed:", "ExampleText",
 CellID->511362366],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "Pi"}], ",", "0", ",", "Pi"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "0", ",", "1"}], "}"}]}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31325260],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 119},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->33680518]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1364],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Axes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Axes"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AxesLabel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AxesLabel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FrameTicks",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FrameTicks"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GridLines",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/GridLines"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DataRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DataRange"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mesh",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mesh"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FaceGrids",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FaceGrids"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TicksStyle",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TicksStyle"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7526753]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26112],

Cell[TextData[ButtonBox["Options for Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Options"]], "Tutorials",
 CellID->12933],

Cell[TextData[ButtonBox["Labeling Three\[Hyphen]Dimensional Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/LabelingThreeDimensionalGraphics"]], "Tutorials",\

 CellID->242403382],

Cell[TextData[ButtonBox["The Structure of Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheStructureOfGraphics"]], "Tutorials",
 CellID->659944600],

Cell[TextData[ButtonBox["Graphics and Sound",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GraphicsAndSoundOverview"]], "Tutorials",
 CellID->855055555]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Ticks",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Ticks"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->960595397],

Cell[TextData[ButtonBox["Graphics Annotation & Appearance",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsAnnotationAndAppearance"]], "MoreAbout",
 CellID->367905989],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "MoreAbout",
 CellID->62581353]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Ticks - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 26, 40.8949114}", "context" -> "System`", 
    "keywords" -> {
     "fiducial marks", "markings", "plots", "scales", "tick marks", 
      "tick marks on axes", "coordinate ticks", "axes ticks", "gauge marks"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "Ticks is an option for graphics functions that specifies tick marks for \
axes. ", "synonyms" -> {}, "title" -> "Ticks", "type" -> "Symbol", "uri" -> 
    "ref/Ticks"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12641, 395, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->104114934]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 185399, 4164}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3186, 68, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3809, 95, 43, 1, 70, "ObjectName",
 CellID->21960],
Cell[3855, 98, 451, 14, 70, "Usage",
 CellID->21462]
}, Open  ]],
Cell[CellGroupData[{
Cell[4343, 117, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4821, 134, 207, 8, 70, "Notes",
 CellID->8732],
Cell[5031, 144, 1032, 27, 70, "2ColumnTableMod",
 CellID->20392],
Cell[6066, 173, 320, 9, 70, "Notes",
 CellID->26843],
Cell[6389, 184, 102, 3, 70, "Notes",
 CellID->14063],
Cell[6494, 189, 4167, 127, 70, "2ColumnTableMod",
 CellID->16923],
Cell[10664, 318, 159, 4, 70, "Notes",
 CellID->14611],
Cell[10826, 324, 83, 1, 70, "Notes",
 CellID->24740],
Cell[10912, 327, 122, 4, 70, "Notes",
 CellID->692],
Cell[11037, 333, 87, 1, 70, "Notes",
 CellID->22443],
Cell[11127, 336, 369, 14, 70, "Notes",
 CellID->22270],
Cell[11499, 352, 234, 7, 70, "Notes",
 CellID->3919],
Cell[11736, 361, 495, 17, 70, "Notes",
 CellID->28849],
Cell[12234, 380, 370, 10, 70, "Notes",
 CellID->643683418]
}, Closed]],
Cell[CellGroupData[{
Cell[12641, 395, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->104114934],
Cell[CellGroupData[{
Cell[13026, 409, 146, 5, 70, "ExampleSection",
 CellID->9694538],
Cell[13175, 416, 75, 1, 70, "ExampleText",
 CellID->409273366],
Cell[CellGroupData[{
Cell[13275, 421, 260, 8, 28, "Input",
 CellID->52504916],
Cell[13538, 431, 2308, 42, 114, "Output",
 Evaluatable->False,
 CellID->71613993]
}, Open  ]],
Cell[15861, 476, 124, 3, 70, "ExampleDelimiter",
 CellID->26480736],
Cell[15988, 481, 74, 1, 70, "ExampleText",
 CellID->467350673],
Cell[CellGroupData[{
Cell[16087, 486, 266, 8, 28, "Input",
 CellID->268606094],
Cell[16356, 496, 2403, 44, 109, "Output",
 Evaluatable->False,
 CellID->115045537]
}, Open  ]],
Cell[CellGroupData[{
Cell[18796, 545, 781, 26, 47, "Input",
 CellID->268705798],
Cell[19580, 573, 2087, 38, 135, "Output",
 Evaluatable->False,
 CellID->147467735]
}, Open  ]],
Cell[21682, 614, 124, 3, 70, "ExampleDelimiter",
 CellID->37534888],
Cell[21809, 619, 86, 1, 70, "ExampleText",
 CellID->675454451],
Cell[CellGroupData[{
Cell[21920, 624, 514, 17, 28, "Input",
 CellID->108358651],
Cell[22437, 643, 2419, 44, 115, "Output",
 Evaluatable->False,
 CellID->147047150]
}, Open  ]],
Cell[CellGroupData[{
Cell[24893, 692, 699, 23, 47, "Input",
 CellID->90566560],
Cell[25595, 717, 23689, 392, 172, "Output",
 Evaluatable->False,
 CellID->150543129]
}, Open  ]],
Cell[49299, 1112, 123, 3, 70, "ExampleDelimiter",
 CellID->3532064],
Cell[49425, 1117, 249, 8, 70, "ExampleText",
 CellID->256827188],
Cell[CellGroupData[{
Cell[49699, 1129, 333, 10, 28, "Input",
 CellID->120129542],
Cell[50035, 1141, 2998, 53, 127, "Output",
 Evaluatable->False,
 CellID->191588757]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[53082, 1200, 215, 7, 70, "ExampleSection",
 CellID->3005],
Cell[CellGroupData[{
Cell[53322, 1211, 248, 7, 70, "ExampleSubsection",
 CellID->42004294],
Cell[53573, 1220, 157, 6, 70, "ExampleText",
 CellID->145201073],
Cell[CellGroupData[{
Cell[53755, 1230, 320, 10, 70, "Input",
 CellID->648906278],
Cell[54078, 1242, 2770, 49, 70, "Output",
 Evaluatable->False,
 CellID->291856482]
}, Open  ]],
Cell[56863, 1294, 157, 6, 70, "ExampleText",
 CellID->278000827],
Cell[CellGroupData[{
Cell[57045, 1304, 320, 10, 70, "Input",
 CellID->214875249],
Cell[57368, 1316, 2656, 48, 70, "Output",
 Evaluatable->False,
 CellID->28331926]
}, Open  ]],
Cell[60039, 1367, 125, 3, 70, "ExampleDelimiter",
 CellID->147669509],
Cell[60167, 1372, 86, 1, 70, "ExampleText",
 CellID->116441539],
Cell[CellGroupData[{
Cell[60278, 1377, 504, 17, 70, "Input",
 CellID->709539987],
Cell[60785, 1396, 2722, 49, 70, "Output",
 Evaluatable->False,
 CellID->602658270]
}, Open  ]],
Cell[CellGroupData[{
Cell[63544, 1450, 568, 18, 70, "Input",
 CellID->227146176],
Cell[64115, 1470, 7734, 137, 203, 568, 15, "CachedBoxData", "BoxData", \
"Output",
 CellID->190925401]
}, Open  ]],
Cell[71864, 1610, 125, 3, 70, "ExampleDelimiter",
 CellID->355108754],
Cell[71992, 1615, 119, 3, 70, "ExampleText",
 CellID->58219888],
Cell[CellGroupData[{
Cell[72136, 1622, 793, 26, 70, "Input",
 CellID->716482942],
Cell[72932, 1650, 2798, 50, 70, "Output",
 Evaluatable->False,
 CellID->76757509]
}, Open  ]],
Cell[CellGroupData[{
Cell[75767, 1705, 614, 19, 70, "Input",
 CellID->470900464],
Cell[76384, 1726, 6884, 119, 161, 271, 6, "CachedBoxData", "BoxData", \
"Output",
 CellID->219831360]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[83317, 1851, 234, 7, 70, "ExampleSubsection",
 CellID->545603057],
Cell[83554, 1860, 82, 1, 70, "ExampleText",
 CellID->101010188],
Cell[CellGroupData[{
Cell[83661, 1865, 823, 26, 70, "Input",
 CellID->205402728],
Cell[84487, 1893, 3095, 55, 70, "Output",
 Evaluatable->False,
 CellID->74344655]
}, Open  ]],
Cell[87597, 1951, 123, 3, 70, "ExampleDelimiter",
 CellID->6626447],
Cell[87723, 1956, 126, 3, 70, "ExampleText",
 CellID->343485730],
Cell[CellGroupData[{
Cell[87874, 1963, 1014, 32, 70, "Input",
 CellID->19933071],
Cell[88891, 1997, 2941, 52, 70, "Output",
 Evaluatable->False,
 CellID->244083594]
}, Open  ]],
Cell[91847, 2052, 125, 3, 70, "ExampleDelimiter",
 CellID->114741329],
Cell[91975, 2057, 77, 1, 70, "ExampleText",
 CellID->4603537],
Cell[CellGroupData[{
Cell[92077, 2062, 1134, 34, 70, "Input",
 CellID->278680862],
Cell[93214, 2098, 2655, 48, 70, "Output",
 Evaluatable->False,
 CellID->38450584]
}, Open  ]],
Cell[95884, 2149, 125, 3, 70, "ExampleDelimiter",
 CellID->987505375],
Cell[96012, 2154, 248, 8, 70, "ExampleText",
 CellID->64237016],
Cell[CellGroupData[{
Cell[96285, 2166, 333, 10, 70, "Input",
 CellID->385529678],
Cell[96621, 2178, 2996, 53, 70, "Output",
 Evaluatable->False,
 CellID->2346499]
}, Open  ]],
Cell[99632, 2234, 77, 1, 70, "ExampleText",
 CellID->93798502],
Cell[CellGroupData[{
Cell[99734, 2239, 319, 10, 70, "Input",
 CellID->138675862],
Cell[100056, 2251, 2876, 51, 70, "Output",
 Evaluatable->False,
 CellID->105923269]
}, Open  ]],
Cell[102947, 2305, 125, 3, 70, "ExampleDelimiter",
 CellID->537694265],
Cell[103075, 2310, 256, 8, 70, "ExampleText",
 CellID->232700368],
Cell[CellGroupData[{
Cell[103356, 2322, 721, 21, 70, "Input",
 CellID->80169133],
Cell[104080, 2345, 2484, 45, 70, "Output",
 Evaluatable->False,
 CellID->147312461]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[106625, 2397, 239, 7, 70, "ExampleSection",
 CellID->22411],
Cell[106867, 2406, 338, 13, 70, "ExampleText",
 CellID->814353806],
Cell[107208, 2421, 630, 20, 70, "Input",
 CellID->22894193],
Cell[CellGroupData[{
Cell[107863, 2445, 323, 10, 70, "Input",
 CellID->545912847],
Cell[108189, 2457, 1971, 53, 174, "Output",
 CellID->697466641]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[110209, 2516, 223, 7, 70, "ExampleSection",
 CellID->23117],
Cell[110435, 2525, 124, 3, 70, "ExampleText",
 CellID->349111521],
Cell[110562, 2530, 1012, 32, 70, "Input",
 CellID->540529205],
Cell[CellGroupData[{
Cell[111599, 2566, 402, 12, 70, "Input",
 CellID->93362669],
Cell[112004, 2580, 27018, 447, 70, "Output",
 Evaluatable->False,
 CellID->44206900]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[139071, 3033, 231, 7, 70, "ExampleSection",
 CellID->943],
Cell[139305, 3042, 212, 7, 70, "ExampleText",
 CellID->730034636],
Cell[CellGroupData[{
Cell[139542, 3053, 488, 15, 70, "Input",
 CellID->178370624],
Cell[140033, 3070, 3080, 55, 70, "Output",
 Evaluatable->False,
 CellID->387486027]
}, Open  ]],
Cell[143128, 3128, 125, 3, 70, "ExampleDelimiter",
 CellID->172046868],
Cell[143256, 3133, 259, 8, 70, "ExampleText",
 CellID->287688071],
Cell[CellGroupData[{
Cell[143540, 3145, 611, 19, 70, "Input",
 CellID->852841955],
Cell[144154, 3166, 3059, 54, 70, "Output",
 Evaluatable->False,
 CellID->107224106]
}, Open  ]],
Cell[147228, 3223, 364, 12, 70, "ExampleText",
 CellID->16302533],
Cell[CellGroupData[{
Cell[147617, 3239, 666, 20, 70, "Input",
 CellID->610817034],
Cell[148286, 3261, 3103, 55, 70, "Output",
 Evaluatable->False,
 CellID->17896383]
}, Open  ]],
Cell[151404, 3319, 125, 3, 70, "ExampleDelimiter",
 CellID->657512805],
Cell[151532, 3324, 241, 7, 70, "ExampleText",
 CellID->715340404],
Cell[CellGroupData[{
Cell[151798, 3335, 488, 15, 70, "Input",
 CellID->423721885],
Cell[152289, 3352, 3080, 55, 70, "Output",
 Evaluatable->False,
 CellID->546970220]
}, Open  ]],
Cell[155384, 3410, 360, 12, 70, "ExampleText",
 CellID->271652939],
Cell[CellGroupData[{
Cell[155769, 3426, 644, 19, 70, "Input",
 CellID->131785817],
Cell[156416, 3447, 3027, 54, 70, "Output",
 Evaluatable->False,
 CellID->218929589]
}, Open  ]],
Cell[159458, 3504, 125, 3, 70, "ExampleDelimiter",
 CellID->231209055],
Cell[159586, 3509, 134, 4, 70, "ExampleText",
 CellID->40832033],
Cell[CellGroupData[{
Cell[159745, 3517, 916, 27, 70, "Input",
 CellID->137003631],
Cell[160664, 3546, 2855, 51, 70, "Output",
 Evaluatable->False,
 CellID->70373981]
}, Open  ]],
Cell[163534, 3600, 124, 3, 70, "ExampleDelimiter",
 CellID->79769809],
Cell[163661, 3605, 235, 7, 70, "ExampleText",
 CellID->19748360],
Cell[CellGroupData[{
Cell[163921, 3616, 244, 7, 70, "Input",
 CellID->155246595],
Cell[164168, 3625, 274, 9, 155, "Output",
 CellID->24297983]
}, Open  ]],
Cell[164457, 3637, 124, 3, 70, "ExampleDelimiter",
 CellID->60624786],
Cell[164584, 3642, 207, 7, 70, "ExampleText",
 CellID->50562259],
Cell[CellGroupData[{
Cell[164816, 3653, 247, 7, 70, "Input",
 CellID->16430822],
Cell[165066, 3662, 279, 9, 167, "Output",
 CellID->265620263]
}, Open  ]],
Cell[165360, 3674, 125, 3, 70, "ExampleDelimiter",
 CellID->963264167],
Cell[165488, 3679, 230, 7, 70, "ExampleText",
 CellID->545823904],
Cell[CellGroupData[{
Cell[165743, 3690, 246, 7, 70, "Input",
 CellID->490910882],
Cell[165992, 3699, 9893, 168, 194, 110, 3, "CachedBoxData", "BoxData", \
"Output",
 CellID->5418666]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[175934, 3873, 225, 7, 70, "ExampleSection",
 CellID->1227],
Cell[176162, 3882, 90, 1, 70, "ExampleText",
 CellID->511362366],
Cell[CellGroupData[{
Cell[176277, 3887, 511, 18, 70, "Input",
 CellID->31325260],
Cell[176791, 3907, 2717, 49, 70, "Output",
 Evaluatable->False,
 CellID->33680518]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[179569, 3963, 310, 9, 70, "SeeAlsoSection",
 CellID->1364],
Cell[179882, 3974, 1923, 71, 70, "SeeAlso",
 CellID->7526753]
}, Open  ]],
Cell[CellGroupData[{
Cell[181842, 4050, 314, 9, 70, "TutorialsSection",
 CellID->26112],
Cell[182159, 4061, 138, 3, 70, "Tutorials",
 CellID->12933],
Cell[182300, 4066, 192, 4, 70, "Tutorials",
 CellID->242403382],
Cell[182495, 4072, 162, 3, 70, "Tutorials",
 CellID->659944600],
Cell[182660, 4077, 157, 3, 70, "Tutorials",
 CellID->855055555]
}, Open  ]],
Cell[CellGroupData[{
Cell[182854, 4085, 305, 8, 70, "RelatedLinksSection"],
Cell[183162, 4095, 355, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[183554, 4112, 319, 9, 70, "MoreAboutSection",
 CellID->960595397],
Cell[183876, 4123, 175, 3, 70, "MoreAbout",
 CellID->367905989],
Cell[184054, 4128, 162, 3, 70, "MoreAbout",
 CellID->62581353]
}, Open  ]],
Cell[184231, 4134, 27, 0, 70, "History"],
Cell[184261, 4136, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

