(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     28496,       1002]
NotebookOptionsPosition[     23449,        831]
NotebookOutlinePosition[     24841,        869]
CellTagsIndexPosition[     24756,        864]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Simplification" :> 
          Documentation`HelpLookup["paclet:tutorial/Simplification"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Simplification\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ExcludedForms" :> 
          Documentation`HelpLookup["paclet:ref/ExcludedForms"], 
          "TimeConstrained" :> 
          Documentation`HelpLookup["paclet:ref/TimeConstrained"], 
          "AbsoluteTiming" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteTiming"], 
          "ComplexityFunction" :> 
          Documentation`HelpLookup["paclet:ref/ComplexityFunction"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"ExcludedForms\"\>", 
       2->"\<\"TimeConstrained\"\>", 3->"\<\"AbsoluteTiming\"\>", 
       4->"\<\"ComplexityFunction\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Global Computation Settings & Parameters" :> 
          Documentation`HelpLookup[
           "paclet:guide/GlobalComputationSettingsAndParameters"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Global Computation Settings & Parameters\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TimeConstraint", "ObjectName",
 CellID->9754],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["TimeConstraint",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/TimeConstraint"]], "InlineFormula"],
     "\[LineSeparator]is an option for various algorithmic functions which \
specifies how long to spend trying a particular transformation or part of an \
algorithm. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14722]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"TimeConstraint", "->", 
   StyleBox["t", "TI"]}]], "InlineFormula"],
 " specifies that a maximum of ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " seconds of CPU time should be spent trying a particular transformation or \
part of an algorithm."
}], "Notes",
 CellID->81641972],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"TimeConstraint", "->", 
   ButtonBox["Infinity",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Infinity"]}]], "InlineFormula"],
 " specifies that there should be no limit on the CPU time allowed."
}], "Notes",
 CellID->87905087],

Cell[TextData[{
 "In functions such as ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 ", settings for ",
 Cell[BoxData[
  ButtonBox["TimeConstraint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TimeConstraint"]], "InlineFormula"],
 " give only the maximum time to be spent in doing a particular \
transformation on a particular subpart; the total time spent in processing \
the whole expression may be considerably larger. "
}], "Notes",
 CellID->9880713],

Cell[TextData[{
 "Changing the setting for ",
 Cell[BoxData[
  ButtonBox["TimeConstraint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TimeConstraint"]], "InlineFormula"],
 " will never affect the validity of a result obtained from functions like ",
 Cell[BoxData[
  ButtonBox["Simplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Simplify"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["FullSimplify",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullSimplify"]], "InlineFormula"],
 ", but smaller settings may prevent the simplest possible form from being \
found. "
}], "Notes",
 CellID->6586],

Cell[TextData[{
 "Since different computer systems run at different speeds, the same setting \
for ",
 Cell[BoxData[
  ButtonBox["TimeConstraint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TimeConstraint"]], "InlineFormula"],
 " can lead to different results on different systems. "
}], "Notes",
 CellID->26425]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->641303121],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->9291592],

Cell["\<\
This takes a long time, due to trigonometric expansion, but does not yield a \
simplification:\
\>", "ExampleText",
 CellID->93965326],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"2", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"10", "x"}], "+", 
      RowBox[{"11", "y"}], "+", 
      RowBox[{"12", "z"}]}], "]"}], 
    RowBox[{"Cos", "[", 
     RowBox[{
      RowBox[{"10", "x"}], "+", 
      RowBox[{"10", "y"}], "+", 
      RowBox[{"10", "t"}]}], "]"}]}], "]"}], "//", "Timing"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->95754870],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"40.709`", ",", 
   RowBox[{"2", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"10", " ", 
      RowBox[{"(", 
       RowBox[{"t", "+", "x", "+", "y"}], ")"}]}], "]"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"10", " ", "x"}], "+", 
      RowBox[{"11", " ", "y"}], "+", 
      RowBox[{"12", " ", "z"}]}], "]"}]}]}], "}"}]], "Output",
 ImageSize->{329, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8377049]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TimeConstraint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TimeConstraint"]], "InlineFormula"],
 " limits the spent on any single transformation:"
}], "ExampleText",
 CellID->242385203],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"2", 
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"10", "x"}], "+", 
       RowBox[{"11", "y"}], "+", 
       RowBox[{"12", "z"}]}], "]"}], 
     RowBox[{"Cos", "[", 
      RowBox[{
       RowBox[{"10", "x"}], "+", 
       RowBox[{"10", "y"}], "+", 
       RowBox[{"10", "t"}]}], "]"}]}], ",", 
    RowBox[{"TimeConstraint", "\[Rule]", "1"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20833797],

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "::", "\<\"time\"\>"}], ":", 
  " ", "\<\"Time spent on a transformation exceeded \\!\\(1\\) seconds, and \
the transformation was aborted. Increasing the value of TimeConstraint option \
may improve the result of simplification. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Simplify/time\\\", ButtonNote -> \
\\\"Simplify::time\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->886447970],

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "::", "\<\"time\"\>"}], ":", 
  " ", "\<\"Time spent on a transformation exceeded \\!\\(1\\) seconds, and \
the transformation was aborted. Increasing the value of TimeConstraint option \
may improve the result of simplification. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Simplify/time\\\", ButtonNote -> \
\\\"Simplify::time\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->91152472],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.203000000000001`", ",", 
   RowBox[{"2", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"10", " ", 
      RowBox[{"(", 
       RowBox[{"t", "+", "x", "+", "y"}], ")"}]}], "]"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"10", " ", "x"}], "+", 
      RowBox[{"11", " ", "y"}], "+", 
      RowBox[{"12", " ", "z"}]}], "]"}]}]}], "}"}]], "Output",
 ImageSize->{322, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->94725325]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->408865133],

Cell["\<\
A similar example, where the transformation yields a simplification:\
\>", "ExampleText",
 CellID->150804670],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"2", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"10", "x"}], "+", 
      RowBox[{"11", "y"}], "+", 
      RowBox[{"12", "z"}]}], "]"}], 
    RowBox[{"Cos", "[", 
     RowBox[{
      RowBox[{"10", "x"}], "+", 
      RowBox[{"10", "y"}], "+", 
      RowBox[{"10", "z"}]}], "]"}]}], "]"}], "//", "Timing"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->159405174],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"23.753999999999998`", ",", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"y", "+", 
      RowBox[{"2", " ", "z"}]}], "]"}], "+", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"20", " ", "x"}], "+", 
      RowBox[{"21", " ", "y"}], "+", 
      RowBox[{"22", " ", "z"}]}], "]"}]}]}], "}"}]], "Output",
 ImageSize->{288, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->215563846]
}, Open  ]],

Cell[TextData[{
 "In this case setting ",
 Cell[BoxData[
  ButtonBox["TimeConstraint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TimeConstraint"]], "InlineFormula"],
 " prevents some simplification:"
}], "ExampleText",
 CellID->337898224],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"2", 
     RowBox[{"Sin", "[", 
      RowBox[{
       RowBox[{"10", "x"}], "+", 
       RowBox[{"11", "y"}], "+", 
       RowBox[{"12", "z"}]}], "]"}], 
     RowBox[{"Cos", "[", 
      RowBox[{
       RowBox[{"10", "x"}], "+", 
       RowBox[{"10", "y"}], "+", 
       RowBox[{"10", "z"}]}], "]"}]}], ",", 
    RowBox[{"TimeConstraint", "\[Rule]", "1"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->219335813],

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "::", "\<\"time\"\>"}], ":", 
  " ", "\<\"Time spent on a transformation exceeded \\!\\(1\\) seconds, and \
the transformation was aborted. Increasing the value of TimeConstraint option \
may improve the result of simplification. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Simplify/time\\\", ButtonNote -> \
\\\"Simplify::time\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->25478632],

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "::", "\<\"time\"\>"}], ":", 
  " ", "\<\"Time spent on a transformation exceeded \\!\\(1\\) seconds, and \
the transformation was aborted. Increasing the value of TimeConstraint option \
may improve the result of simplification. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/Simplify/time\\\", ButtonNote -> \
\\\"Simplify::time\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->631653721],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.9249999999999994`", ",", 
   RowBox[{"2", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"10", " ", 
      RowBox[{"(", 
       RowBox[{"x", "+", "y", "+", "z"}], ")"}]}], "]"}], " ", 
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"10", " ", "x"}], "+", 
      RowBox[{"11", " ", "y"}], "+", 
      RowBox[{"12", " ", "z"}]}], "]"}]}]}], "}"}]], "Output",
 ImageSize->{322, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->630943802]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25566],

Cell["\<\
Checking whether a condition follows from assumptions may take a long time:\
\>", "ExampleText",
 CellID->266086219],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Refine", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "6"}], "+", 
        RowBox[{"y", "^", "6"}], "+", 
        RowBox[{"z", "^", "6"}], "-", 
        RowBox[{"x", " ", "y", " ", "z"}]}], ")"}], "^", "2"}], "]"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"y", "-", "1"}], ")"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"z", "-", "1"}], ")"}], "^", "2"}]}], "\[LessEqual]", 
     RowBox[{"1", "/", "4"}]}]}], "]"}], "//", "Timing"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->600850587],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"53.75`", ",", 
   RowBox[{
    SuperscriptBox["x", "6"], "+", 
    SuperscriptBox["y", "6"], "-", 
    RowBox[{"x", " ", "y", " ", "z"}], "+", 
    SuperscriptBox["z", "6"]}]}], "}"}]], "Output",
 ImageSize->{167, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->296197031]
}, Open  ]],

Cell["\<\
If a condition does not follow from assumptions, checking this may still take \
a long time:\
\>", "ExampleText",
 CellID->494098244],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Refine", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "6"}], "+", 
        RowBox[{"y", "^", "6"}], "+", 
        RowBox[{"z", "^", "6"}], "-", 
        RowBox[{"x", " ", "y", " ", "z"}]}], ")"}], "^", "2"}], "]"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"y", "-", "1"}], ")"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"z", "-", "1"}], ")"}], "^", "2"}]}], "\[LessEqual]", 
     RowBox[{"1", "/", "2"}]}]}], "]"}], "//", "Timing"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30216502],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"34.75`", ",", 
   RowBox[{"Abs", "[", 
    RowBox[{
     SuperscriptBox["x", "6"], "+", 
     SuperscriptBox["y", "6"], "-", 
     RowBox[{"x", " ", "y", " ", "z"}], "+", 
     SuperscriptBox["z", "6"]}], "]"}]}], "}"}]], "Output",
 ImageSize->{202, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->562861788]
}, Open  ]],

Cell[TextData[{
 "The time spent on a single condition check is restricted by the value of ",
 Cell[BoxData[
  ButtonBox["TimeConstraint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TimeConstraint"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->420586],

Cell[BoxData[
 RowBox[{"ClearSystemCache", "[", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->136890207],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Refine", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "6"}], "+", 
        RowBox[{"y", "^", "6"}], "+", 
        RowBox[{"z", "^", "6"}], "-", 
        RowBox[{"x", " ", "y", " ", "z"}]}], ")"}], "^", "2"}], "]"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"y", "-", "1"}], ")"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"z", "-", "1"}], ")"}], "^", "2"}]}], "\[LessEqual]", 
     RowBox[{"1", "/", "2"}]}], ",", 
    RowBox[{"TimeConstraint", "\[Rule]", "1"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->22931155],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"6.171999999999988`", ",", 
   RowBox[{"Abs", "[", 
    RowBox[{
     SuperscriptBox["x", "6"], "+", 
     SuperscriptBox["y", "6"], "-", 
     RowBox[{"x", " ", "y", " ", "z"}], "+", 
     SuperscriptBox["z", "6"]}], "]"}]}], "}"}]], "Output",
 ImageSize->{202, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->354181013]
}, Open  ]],

Cell[TextData[{
 "With a time constraint of 1 second ",
 Cell[BoxData[
  ButtonBox["Refine",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Refine"]], "InlineFormula"],
 " cannot prove that ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    SuperscriptBox[
     StyleBox["x", "TI"], "6"], "+", 
    SuperscriptBox[
     StyleBox["y", "TI"], "6"], "+", 
    SuperscriptBox[
     StyleBox["z", "TI"], "6"], "-", 
    RowBox[{
     StyleBox["x", "TI"], " ", 
     StyleBox["y", "TI"], " ", 
     StyleBox["z", "TI"]}]}], "\[GreaterEqual]", "0"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->520300087],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Refine", "[", 
   RowBox[{
    RowBox[{"Sqrt", "[", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"x", "^", "6"}], "+", 
        RowBox[{"y", "^", "6"}], "+", 
        RowBox[{"z", "^", "6"}], "-", 
        RowBox[{"x", " ", "y", " ", "z"}]}], ")"}], "^", "2"}], "]"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "1"}], ")"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"y", "-", "1"}], ")"}], "^", "2"}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"z", "-", "1"}], ")"}], "^", "2"}]}], "\[LessEqual]", 
     RowBox[{"1", "/", "4"}]}], ",", 
    RowBox[{"TimeConstraint", "\[Rule]", "1"}]}], "]"}], "//", 
  "Timing"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->126391231],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7.125000000000008`", ",", 
   RowBox[{"Abs", "[", 
    RowBox[{
     SuperscriptBox["x", "6"], "+", 
     SuperscriptBox["y", "6"], "-", 
     RowBox[{"x", " ", "y", " ", "z"}], "+", 
     SuperscriptBox["z", "6"]}], "]"}]}], "}"}]], "Output",
 ImageSize->{202, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->2976391]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32659],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ExcludedForms",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ExcludedForms"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TimeConstrained",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TimeConstrained"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteTiming",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteTiming"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ComplexityFunction",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ComplexityFunction"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->488]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9524],

Cell[TextData[ButtonBox["Simplification",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Simplification"]], "Tutorials",
 CellID->15818]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->146808724],

Cell[TextData[ButtonBox["Global Computation Settings & Parameters",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/GlobalComputationSettingsAndParameters"]], "MoreAbout",
 CellID->60235112]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
TimeConstraint"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TimeConstraint - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 26, 50.1451482}", "context" -> "System`", 
    "keywords" -> {
     "evaluation with time constraints", "simplify with time constraints"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "TimeConstraint is an option for various algorithmic functions which \
specifies how long to spend trying a particular transformation or part of an \
algorithm. ", "synonyms" -> {"time constraint"}, "title" -> "TimeConstraint", 
    "type" -> "Symbol", "uri" -> "ref/TimeConstraint"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6212, 201, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->641303121]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 24613, 857}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2207, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2830, 82, 51, 1, 70, "ObjectName",
 CellID->9754],
Cell[2884, 85, 540, 15, 70, "Usage",
 CellID->14722]
}, Open  ]],
Cell[CellGroupData[{
Cell[3461, 105, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3939, 122, 335, 10, 70, "Notes",
 CellID->81641972],
Cell[4277, 134, 275, 8, 70, "Notes",
 CellID->87905087],
Cell[4555, 144, 673, 20, 70, "Notes",
 CellID->9880713],
Cell[5231, 166, 623, 19, 70, "Notes",
 CellID->6586],
Cell[5857, 187, 318, 9, 70, "Notes",
 CellID->26425]
}, Closed]],
Cell[CellGroupData[{
Cell[6212, 201, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->641303121],
Cell[CellGroupData[{
Cell[6597, 215, 146, 5, 70, "ExampleSection",
 CellID->9291592],
Cell[6746, 222, 144, 4, 70, "ExampleText",
 CellID->93965326],
Cell[CellGroupData[{
Cell[6915, 230, 430, 15, 28, "Input",
 CellID->95754870],
Cell[7348, 247, 518, 17, 36, "Output",
 CellID->8377049]
}, Open  ]],
Cell[7881, 267, 236, 7, 70, "ExampleText",
 CellID->242385203],
Cell[CellGroupData[{
Cell[8142, 278, 512, 18, 70, "Input",
 CellID->20833797],
Cell[8657, 298, 514, 9, 70, "Message",
 CellID->886447970],
Cell[9174, 309, 513, 9, 70, "Message",
 CellID->91152472],
Cell[9690, 320, 530, 17, 36, "Output",
 CellID->94725325]
}, Open  ]],
Cell[10235, 340, 125, 3, 70, "ExampleDelimiter",
 CellID->408865133],
Cell[10363, 345, 119, 3, 70, "ExampleText",
 CellID->150804670],
Cell[CellGroupData[{
Cell[10507, 352, 431, 15, 70, "Input",
 CellID->159405174],
Cell[10941, 369, 483, 16, 36, "Output",
 CellID->215563846]
}, Open  ]],
Cell[11439, 388, 245, 8, 70, "ExampleText",
 CellID->337898224],
Cell[CellGroupData[{
Cell[11709, 400, 513, 18, 70, "Input",
 CellID->219335813],
Cell[12225, 420, 513, 9, 70, "Message",
 CellID->25478632],
Cell[12741, 431, 514, 9, 70, "Message",
 CellID->631653721],
Cell[13258, 442, 532, 17, 36, "Output",
 CellID->630943802]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13839, 465, 216, 7, 70, "ExampleSection",
 CellID->25566],
Cell[14058, 474, 126, 3, 70, "ExampleText",
 CellID->266086219],
Cell[CellGroupData[{
Cell[14209, 481, 765, 25, 70, "Input",
 CellID->600850587],
Cell[14977, 508, 366, 12, 39, "Output",
 CellID->296197031]
}, Open  ]],
Cell[15358, 523, 143, 4, 70, "ExampleText",
 CellID->494098244],
Cell[CellGroupData[{
Cell[15526, 531, 764, 25, 70, "Input",
 CellID->30216502],
Cell[16293, 558, 402, 13, 39, "Output",
 CellID->562861788]
}, Open  ]],
Cell[16710, 574, 265, 8, 70, "ExampleText",
 CellID->420586],
Cell[16978, 584, 107, 3, 70, "Input",
 CellID->136890207],
Cell[CellGroupData[{
Cell[17110, 591, 821, 27, 70, "Input",
 CellID->22931155],
Cell[17934, 620, 414, 13, 39, "Output",
 CellID->354181013]
}, Open  ]],
Cell[18363, 636, 602, 22, 70, "ExampleText",
 CellID->520300087],
Cell[CellGroupData[{
Cell[18990, 662, 822, 27, 70, "Input",
 CellID->126391231],
Cell[19815, 691, 412, 13, 39, "Output",
 CellID->2976391]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[20288, 711, 311, 9, 70, "SeeAlsoSection",
 CellID->32659],
Cell[20602, 722, 995, 35, 70, "SeeAlso",
 CellID->488]
}, Open  ]],
Cell[CellGroupData[{
Cell[21634, 762, 313, 9, 70, "TutorialsSection",
 CellID->9524],
Cell[21950, 773, 139, 3, 70, "Tutorials",
 CellID->15818]
}, Open  ]],
Cell[CellGroupData[{
Cell[22126, 781, 319, 9, 70, "MoreAboutSection",
 CellID->146808724],
Cell[22448, 792, 192, 4, 70, "MoreAbout",
 CellID->60235112]
}, Open  ]],
Cell[CellGroupData[{
Cell[22677, 801, 305, 8, 70, "RelatedLinksSection"],
Cell[22985, 811, 392, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[23392, 827, 27, 0, 70, "History"],
Cell[23422, 829, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

