(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23138,        779]
NotebookOptionsPosition[     18867,        633]
NotebookOutlinePosition[     20163,        669]
CellTagsIndexPosition[     20078,        664]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Date and Time Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DateAndTimeFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Date and Time Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Timing" :> Documentation`HelpLookup["paclet:ref/Timing"], 
          "SessionTime" :> Documentation`HelpLookup["paclet:ref/SessionTime"],
           "DateList" :> Documentation`HelpLookup["paclet:ref/DateList"], 
          "DateString" :> Documentation`HelpLookup["paclet:ref/DateString"], 
          "AbsoluteTime" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteTime"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Timing\"\>", 
       2->"\<\"SessionTime\"\>", 3->"\<\"DateList\"\>", 
       4->"\<\"DateString\"\>", 
       5->"\<\"AbsoluteTime\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Mathematica Session Information" :> 
          Documentation`HelpLookup[
           "paclet:guide/MathematicaSessionInformation"], 
          "Time Measurement & Optimization" :> 
          Documentation`HelpLookup[
           "paclet:guide/TimeMeasurementAndOptimization"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Mathematica Session Information\"\>", 
       2->"\<\"Time Measurement & Optimization\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TimeUsed", "ObjectName",
 CellID->9847],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["TimeUsed",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TimeUsed"], "[", "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the total number of seconds of CPU time used so \
far in the current ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " session. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32606]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TimeUsed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TimeUsed"]], "InlineFormula"],
 " records only CPU time actually used by the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel. It does not include time used by external processes called by the \
kernel. It also does not include time during pauses produced by ",
 Cell[BoxData[
  ButtonBox["Pause",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Pause"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->3187],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TimeUsed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TimeUsed"]], "InlineFormula"],
 " is accurate only down to a granularity of at least ",
 Cell[BoxData[
  ButtonBox["$TimeUnit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$TimeUnit"]], "InlineFormula"],
 " seconds. "
}], "Notes",
 CellID->14535]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->602650148],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->228597543],

Cell[TextData[{
 "CPU time used by a ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel:"
}], "ExampleText",
 CellID->161936600],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TimeUsed", "[", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->157560409],

Cell[BoxData["0.04999999999999999`"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->229159232]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->61392461],

Cell["Get time between function evaluations:", "ExampleText",
 CellID->81790664],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"res", ",", 
    RowBox[{"{", "times", "}"}]}], "}"}], "=", 
  RowBox[{"Reap", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], "-", "x"}], " ", "/.", 
    RowBox[{"FindRoot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", "2"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", "1."}], "}"}], ",", 
      RowBox[{"WorkingPrecision", "\[Rule]", "1000000"}], ",", 
      RowBox[{"EvaluationMonitor", "\[RuleDelayed]", 
       RowBox[{"Sow", "[", 
        RowBox[{"TimeUsed", "[", "]"}], "]"}]}]}], "]"}]}], "]"}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->253090],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0``999999.8494850022", ",", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
     "139.721`", ",", "139.721`", ",", "139.721`", ",", "139.721`", ",", 
      "139.721`", ",", "139.721`", ",", "139.721`", ",", "139.721`", ",", 
      "139.721`", ",", "139.731`", ",", "139.731`", ",", "139.731`", ",", 
      "139.731`", ",", "139.74099999999999`", ",", "139.771`", ",", 
      "139.831`", ",", "140.022`", ",", "140.482`", ",", "141.594`", ",", 
      "143.867`", ",", "146.40099999999998`", ",", "149.17499999999998`", ",",
       "157.867`"}], "}"}], "}"}]}], "}"}]], "Output",
 ImageSize->{503, 71},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->317765152]
}, Open  ]],

Cell["\<\
Almost all of the time is spent in the last few evaluations because the \
precision is adaptive:\
\>", "ExampleText",
 CellID->44261556],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"times", " ", "-", " ", 
      RowBox[{"times", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ",", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"{", "0", "}"}], ",", 
       RowBox[{"Differences", "[", "times", "]"}]}], "]"}]}], "}"}], ",", " ",
    
   RowBox[{"PlotRange", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->179213873],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVV71PFEEU39u9Pc2hBYkJKOpdZedHYXvBhCiBxJJYWVyIEQoPPU5jgjZc
4Ucw3oXASSRB4kJiqAyIhVbSQEUpNf/I+uZjfXNvZ+d2DzbiJjuzv5nf+5j3
3szu3i3XJh48Ktcmx8vF4Wr58cTk+HTxzlQVhpyMZVlbcD/rt+DZhyd+b/k+
9OH2KrQOEAqyt6G3ob8ksZXlNHkNAMgqrD4+eYO1jOzzi8taWcSCrzIGCHYI
Ps8aV+C/bUjLuZSsX+ioIS3L6nz0iq/J6Bfj2UOGlLsc24o6WohnzVWtMe0X
WZ9T5Uwxva74yHrHx3q0ZTnashLVeVGJoqbPEs1eglGRkZXa56XSk4X786L8
U8Ruh/kejve9n4B35jbkfDQeMayqees5sBZLVSmVHnZj8emqP46+BPxhcDom
jh/lmzwqeWi/QFAy2hhlE+IegvludH6s/oKhjddfJX9v93Cqsvl9+wAxzEdj
Kt8JQ0wBY0yhEgCzSjhD/OvTrvohwfnAyvvRWbSyPlaHSC4PPbWuaLXMcLz6
6lu9NNOseEbWvbH1wdLS7aFlhcV28AttvLCyC1qds8Q/E+tw9/dmZeFgey+C
pT8RhOyatw9ev5vbUWSZ13WyJpP96LX1a6XekLVRqV6DFK6VZpBqyWu1NDpo
0Uu1iBSyWKzWEkS9u1Fm5S3Jlym2mDcTC/MmWOx0YyRX68dpMkrfc0dlMShm
c3LFej9yZJSeX4J1ysf3atJIHz2fDZIrfUU3SK5627xokhzpdRxnlR1PRFb8
9n1oG1i470ws3Hd21161SEbEDm7/Cwi+/mndtUiehCz3xfjdSHGLZLRbPV4C
OdxV6doJy4mPM3EFX7P6HZ32bjwZVv6/FYp0BVdA0eeQ1gD9AzTUVipSkXXv
myqRc0N/evSNE67v4O/t37xtToaVaNuf+CyevaazHk9ZEwvPUD3LWNWZP6tf
oYU=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->102120928]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->26031],

Cell["\<\
Get time used by function evaluations and the rest of a computation:\
\>", "ExampleText",
 CellID->310193140],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"a_", "?", "NumberQ"}], "]"}], " ", ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "t", ",", "r"}], "}"}], ",", 
    RowBox[{
     RowBox[{"Sow", "[", 
      RowBox[{"TimeUsed", "[", "]"}], "]"}], ";", 
     RowBox[{"r", " ", "=", " ", 
      RowBox[{"First", "[", 
       RowBox[{
        RowBox[{"x", "[", "1", "]"}], "/.", " ", 
        RowBox[{"NDSolve", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{"x", "''"}], "[", "t", "]"}], "+", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"a", "/", "1000"}], "+", " ", 
                RowBox[{"Exp", "[", 
                 RowBox[{
                  RowBox[{"-", "1000"}], "  ", 
                  RowBox[{"t", "^", "2"}]}], "]"}]}], ")"}]}], "\[Equal]", 
             RowBox[{"Sin", "[", 
              RowBox[{"a", " ", "t"}], "]"}]}], ",", 
            RowBox[{
             RowBox[{"x", "[", 
              RowBox[{"-", "1"}], "]"}], "\[Equal]", "0"}], ",", 
            RowBox[{
             RowBox[{
              RowBox[{"x", "'"}], "[", 
              RowBox[{"-", "1"}], "]"}], "\[Equal]", "0"}]}], "}"}], ",", "x",
           ",", 
          RowBox[{"{", 
           RowBox[{"t", ",", 
            RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], "]"}]}], ";", 
     RowBox[{"Sow", "[", 
      RowBox[{"TimeUsed", "[", "]"}], "]"}], ";", "r"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->352499599],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Short", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"res", ",", " ", 
     RowBox[{"{", "times", "}"}]}], "}"}], "=", 
   RowBox[{"Reap", "[", 
    RowBox[{"FindRoot", "[", 
     RowBox[{
      RowBox[{"f", "[", "a", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "1000"}], "}"}]}], "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->557507963],

Cell[BoxData[
 TagBox[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", "\[Rule]", 
      RowBox[{"-", "26.701425549748706`"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"0.06999999999999999`", ",", 
       RowBox[{"\[LeftSkeleton]", "720", "\[RightSkeleton]"}], ",", 
       "8.051`"}], "}"}], "}"}]}], "}"}],
  Short]], "Output",
 ImageSize->{286, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//Short=",
 CellID->117273043]
}, Open  ]],

Cell["The total computation time:", "ExampleText",
 CellID->126266563],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"times", "[", 
   RowBox[{"[", 
    RowBox[{"-", "1"}], "]"}], "]"}], "-", 
  RowBox[{"times", "[", 
   RowBox[{"[", "1", "]"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->120144453],

Cell[BoxData["7.981`"], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->709043496]
}, Open  ]],

Cell["Get the evaluation times:", "ExampleText",
 CellID->5045659],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"evals", " ", "=", " ", 
   RowBox[{"Apply", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"#2", "-", "#1"}], ")"}], "&"}], ",", 
     RowBox[{"Partition", "[", 
      RowBox[{"times", ",", "2"}], "]"}], ",", 
     RowBox[{"{", "1", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Total", "[", "evals", "]"}], ",", 
   RowBox[{"Mean", "[", "evals", "]"}]}], "}"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->269516410],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"7.920999999999999`", ",", "0.021941828254847643`"}], 
  "}"}]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->624181976]
}, Open  ]],

Cell["Evaluations were much faster near the root:", "ExampleText",
 CellID->482450489],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", "evals", "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->207639063],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxdlztvVFcUhXcoEKULQBQoDBFCCCEyvEMg8eZp3lyPDQYbw/Hg19gezx0/
KFKdSNBPAVJo0CloEiEy6VxQnJ8wfwDp0CFBMT+BMbmI2d80aPGttfbZ91yP
YW+1UZnZIiK1H0Q2//z/0x38NLzx47NP/w0Wf6Gfjd6m73pqeONtoQc0vNz8
/F3o7bph+C7d9mb3+PSZfwu9W/8y/pK2jf8n9O2D3q8tow+AH9SP5ryHNJr+
w8iXkT+C8xzVkjn/MQ2GH0f/CfSdhD6F/C/gp9H3K/QZ5M8i/xv079CDmvYf
6V3JP4VW2++h5Zz6/rw/p9H0nUf+vPXLBeQvoP8i8heRvwR+CfMvq/Tfj7+s
ydz/kEqlT/sh9F9Rv/3t0Ic/Xhf8CvhVO89fBb+G/DXsdx37X8f5b2C/G3Yf
uYn8TeRvgUPLbfTftueVzPZphr7M+iO0DFut0B46DquafEX9z+/3bf3zRZGv
FP7nRb6i8lU/LfLgMmK1jqjs6PN78DhS9H3Ljxb+b/lRy/0o5sMvd6xf71ju
wWNP7+zrk7vI30UePELLmO3TMZx/zPZFcLmH/e8hDx7B5T7y95EHj+Aybp+v
jmP/cewPLhN4fhPI93T/+xUn7Dx5gPwD5MEjuEzi/JPITyIPLg8x/yHy4BFc
HiEP7R/Z9yOCi7N9JYd9nPU7+D14AI/oS+AyZfOlKbxPUzbv4PfwB/AIntAn
VcyvYj64q9rn6av2/QrwR/SlKuY/xvzHmA/uwD14AI/gCVymMX8a86fx/OH3
8Af4I3hCXmbw/s3gfZ7BfGgPf0BfhD/BL7P2PkuzmD+L+bN4/vAH9EXwhD6Z
w/5z+PmDdtB+Du8feER/Apd53P887n8e88E9eICO6E/z+P1Xs/5SDfPBHbSv
2b5Qs/Mi/An9soD50Lpg+x24X8D9wx/BE7Qs4v1bxPu3iP0X8fzBA3hEX4Jf
ljB/CftDuyXMX8L+6IvgCX1Sx/Ov4/7BXd2+776O+6/j/pFP6JdlzIfWZet3
4H4Z+y9jf/CEvDTw/Bu4/wb2b+D5gwfwCJ7QL7mdP5Dj+yC3+TK05nZeBu7A
c3CPeS2cJ8Dfhj/C3wFPyHdxHmlaPgBdalp/GVybdl7WxPcF/Dn8Hv4WeEC+
3cS/Z5HvIJ+Q72IfWcH+K/h9BF5ewfu5Yudn4A75HP0evAUewNvQEboDndDX
BZdV7L+Kn0fwMrRCZ6v4vgDPoT3mtcBDT/d/2j29Z/P/86+K/cE7yCfoLvyy
hv3XLC+t2fOVwRX5DNrBn4N78BZ4AG/jPBG8g3wC74LLOvZfx/7r2B9+hT8D
d+A5uAdvYV4AbyMfoTvwJ/AuuDzB/k+wP3i5p3f17w9/Br8Dz8E9eOs7/wKF
5e3d
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0., 361.}, {0., 0.07000000000000028}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->340508182]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19140],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Timing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Timing"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SessionTime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SessionTime"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateList",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateList"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DateString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DateString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteTime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteTime"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18625]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10309],

Cell[TextData[ButtonBox["Date and Time Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DateAndTimeFunctions"]], "Tutorials",
 CellID->28364]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->393478500],

Cell[TextData[ButtonBox["Mathematica Session Information",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicaSessionInformation"]], "MoreAbout",
 CellID->1063944040],

Cell[TextData[ButtonBox["Time Measurement & Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TimeMeasurementAndOptimization"]], "MoreAbout",
 CellID->84202851]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TimeUsed - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 26, 51.0670468}", "context" -> "System`", 
    "keywords" -> {"CPU time", "run-time", "cumulative time", "total time"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "TimeUsed[] gives the total number of seconds of CPU time used so far in \
the current Mathematica session. ", "synonyms" -> {"time used"}, "title" -> 
    "TimeUsed", "type" -> "Symbol", "uri" -> "ref/TimeUsed"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5090, 163, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->602650148]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19935, 657}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2420, 58, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3043, 85, 45, 1, 70, "ObjectName",
 CellID->9847],
Cell[3091, 88, 564, 18, 70, "Usage",
 CellID->32606]
}, Open  ]],
Cell[CellGroupData[{
Cell[3692, 111, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4170, 128, 525, 16, 70, "Notes",
 CellID->3187],
Cell[4698, 146, 355, 12, 70, "Notes",
 CellID->14535]
}, Closed]],
Cell[CellGroupData[{
Cell[5090, 163, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->602650148],
Cell[CellGroupData[{
Cell[5475, 177, 148, 5, 70, "ExampleSection",
 CellID->228597543],
Cell[5626, 184, 139, 6, 70, "ExampleText",
 CellID->161936600],
Cell[CellGroupData[{
Cell[5790, 194, 99, 3, 28, "Input",
 CellID->157560409],
Cell[5892, 199, 177, 5, 36, "Output",
 CellID->229159232]
}, Open  ]],
Cell[6084, 207, 124, 3, 70, "ExampleDelimiter",
 CellID->61392461],
Cell[6211, 212, 80, 1, 70, "ExampleText",
 CellID->81790664],
Cell[CellGroupData[{
Cell[6316, 217, 664, 21, 70, "Input",
 CellID->253090],
Cell[6983, 240, 750, 17, 92, "Output",
 CellID->317765152]
}, Open  ]],
Cell[7748, 260, 146, 4, 70, "ExampleText",
 CellID->44261556],
Cell[CellGroupData[{
Cell[7919, 268, 465, 15, 28, "Input",
 CellID->179213873],
Cell[8387, 285, 1193, 24, 139, "Output",
 Evaluatable->False,
 CellID->102120928]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9629, 315, 216, 7, 70, "ExampleSection",
 CellID->26031],
Cell[9848, 324, 119, 3, 70, "ExampleText",
 CellID->310193140],
Cell[9970, 329, 1609, 46, 70, "Input",
 CellID->352499599],
Cell[CellGroupData[{
Cell[11604, 379, 395, 13, 70, "Input",
 CellID->557507963],
Cell[12002, 394, 508, 17, 36, "Output",
 CellID->117273043]
}, Open  ]],
Cell[12525, 414, 70, 1, 70, "ExampleText",
 CellID->126266563],
Cell[CellGroupData[{
Cell[12620, 419, 224, 8, 70, "Input",
 CellID->120144453],
Cell[12847, 429, 163, 5, 36, "Output",
 CellID->709043496]
}, Open  ]],
Cell[13025, 437, 66, 1, 70, "ExampleText",
 CellID->5045659],
Cell[CellGroupData[{
Cell[13116, 442, 514, 16, 70, "Input",
 CellID->269516410],
Cell[13633, 460, 244, 8, 36, "Output",
 CellID->624181976]
}, Open  ]],
Cell[13892, 471, 86, 1, 70, "ExampleText",
 CellID->482450489],
Cell[CellGroupData[{
Cell[14003, 476, 108, 3, 70, "Input",
 CellID->207639063],
Cell[14114, 481, 1891, 40, 139, "Output",
 CellID->340508182]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16066, 528, 311, 9, 70, "SeeAlsoSection",
 CellID->19140],
Cell[16380, 539, 1200, 44, 70, "SeeAlso",
 CellID->18625]
}, Open  ]],
Cell[CellGroupData[{
Cell[17617, 588, 314, 9, 70, "TutorialsSection",
 CellID->10309],
Cell[17934, 599, 154, 3, 70, "Tutorials",
 CellID->28364]
}, Open  ]],
Cell[CellGroupData[{
Cell[18125, 607, 319, 9, 70, "MoreAboutSection",
 CellID->393478500],
Cell[18447, 618, 173, 3, 70, "MoreAbout",
 CellID->1063944040],
Cell[18623, 623, 172, 3, 70, "MoreAbout",
 CellID->84202851]
}, Open  ]],
Cell[18810, 629, 27, 0, 70, "History"],
Cell[18840, 631, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

