(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23846,        930]
NotebookOptionsPosition[     18449,        737]
NotebookOutlinePosition[     19749,        775]
CellTagsIndexPosition[     19664,        770]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Arithmetic" :> 
          Documentation`HelpLookup["paclet:tutorial/Arithmetic"], "Operators" :> 
          Documentation`HelpLookup["paclet:tutorial/Operators"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Arithmetic\"\>", 
       2->"\<\"Operators\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Divide" :> Documentation`HelpLookup["paclet:ref/Divide"], 
          "TimesBy" :> Documentation`HelpLookup["paclet:ref/TimesBy"], 
          "NonCommutativeMultiply" :> 
          Documentation`HelpLookup["paclet:ref/NonCommutativeMultiply"], 
          "Dot" :> Documentation`HelpLookup["paclet:ref/Dot"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Divide\"\>", 2->"\<\"TimesBy\"\>", 
       3->"\<\"NonCommutativeMultiply\"\>", 
       4->"\<\"Dot\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Arithmetic Functions" :> 
          Documentation`HelpLookup["paclet:guide/ArithmeticFunctions"], 
          "Mathematical Functions" :> 
          Documentation`HelpLookup["paclet:guide/MathematicalFunctions"], 
          "Matrices and Linear Algebra" :> 
          Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
          "Matrix Operations" :> 
          Documentation`HelpLookup["paclet:guide/MatrixOperations"], 
          "Operations on Vectors" :> 
          Documentation`HelpLookup["paclet:guide/OperationsOnVectors"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Arithmetic Functions\"\>", 
       2->"\<\"Mathematical Functions\"\>", 
       3->"\<\"Matrices and Linear Algebra\"\>", 
       4->"\<\"Matrix Operations\"\>", 
       5->"\<\"Operations on Vectors\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "Times ",
 StyleBox["(*, \[Times])", "OperatorCharacter"]
}], "ObjectName",
 CellID->22316],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "*", 
       StyleBox["y", "TI"], "*", 
       StyleBox["z", "TI"]}]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "\[Times]", 
       StyleBox["y", "TI"], "\[Times]", 
       StyleBox["z", "TI"]}]], "InlineFormula"],
     " or ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], " ", 
       StyleBox["y", "TI"], " ", 
       StyleBox["z", "TI"]}]], "InlineFormula"],
     " \[LineSeparator]represents a product of terms. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2429]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The character ",
 Cell[BoxData["\[Times]"], "InlineFormula"],
 " is entered as ",
 StyleBox["Esc", "KeyEvent"],
 StyleBox["\[ThinSpace]*\[ThinSpace]", "InlineCode"],
 StyleBox["Esc", "KeyEvent"],
 " or ",
 Cell[TextData[ButtonBox["\\[Times]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Times"]], "InlineCharacterName"],
 ". It is not the same as ",
 Cell[TextData[ButtonBox["\\[Cross]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/Cross"]], "InlineCharacterName"],
 ". "
}], "Notes",
 CellID->7761],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 " has attributes ",
 Cell[BoxData[
  ButtonBox["Flat",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Flat"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Orderless",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Orderless"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["OneIdentity",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/OneIdentity"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9133],

Cell[TextData[{
 "The default value for arguments of ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 ", as used in ",
 Cell[BoxData["x_."], "InlineFormula"],
 " patterns, is ",
 Cell[BoxData["1"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->12930],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Times",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Times"], "[", "]"}]], "InlineFormula"],
 " is taken to be ",
 Cell[BoxData["1"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10746],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Times",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Times"], "[", 
   StyleBox["x", "TI"], "]"}]], "InlineFormula"],
 " is ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5532],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"0", 
   StyleBox["x", "TI"]}]], "InlineFormula"],
 " evaluates to ",
 Cell[BoxData["0"], "InlineFormula"],
 ", but ",
 Cell[BoxData[
  RowBox[{"0.0", 
   StyleBox["x", "TI"]}]], "InlineFormula"],
 " is left unchanged. "
}], "Notes",
 CellID->25283],

Cell[TextData[{
 "Unlike other functions, ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 " applies built\[Hyphen]in rules before user\[Hyphen]defined ones. As a \
result, it is not possible to make definitions such as ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"2", "*", "2"}], "=", "5"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->30873]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->411432099],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->267589551],

Cell[TextData[{
 "Enter ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 " with spaces; \[Times] is added automatically between numbers:"
}], "ExampleText",
 CellID->10597],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", " ", "3", " ", "4"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32189],

Cell[BoxData["24"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13163]
}, Open  ]],

Cell["Alternative form:", "ExampleText",
 CellID->30444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", "*", "3", "*", "4"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18621],

Cell[BoxData["24"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->24705]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2815],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 " threads element-wise over lists:"
}], "ExampleText",
 CellID->10713],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"2", 
  RowBox[{"{", 
   RowBox[{"x", ",", "y", ",", "z"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->22334],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"2", " ", "x"}], ",", 
   RowBox[{"2", " ", "y"}], ",", 
   RowBox[{"2", " ", "z"}]}], "}"}]], "Output",
 ImageSize->{92, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16999]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{" ", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"a", ",", "b"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"c", ",", "d"}], "}"}]}], "}"}], 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13137],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", "x"}], ",", 
     RowBox[{"b", " ", "x"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c", " ", "y"}], ",", 
     RowBox[{"d", " ", "y"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{148, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->25615]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->14164],

Cell[TextData[{
 "Explicit ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->32058],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Times", "[", 
  RowBox[{"1", ",", "2", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->23511],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8383]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12251],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 " threads element-wise:"
}], "ExampleText",
 CellID->24420],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}], 
  RowBox[{"{", 
   RowBox[{"x", ",", "y"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24061],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", " ", "x"}], ",", 
     RowBox[{"b", " ", "x"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"c", " ", "y"}], ",", 
     RowBox[{"d", " ", "y"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{148, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14360]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->29767],

Cell[TextData[{
 "Pattern matching works with ",
 Cell[BoxData[
  ButtonBox["Times",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Times"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->15273],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "b", " ", "c", " ", "d"}], "/.", 
  RowBox[{
   RowBox[{"a", " ", "d"}], "\[Rule]", "x"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8034],

Cell[BoxData[
 RowBox[{"b", " ", "c", " ", "x"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->32133]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", "b", " ", "c", " ", "d"}], "/.", 
  RowBox[{
   RowBox[{"a", " ", "c", " ", "x_"}], "\[Rule]", 
   RowBox[{"f", "[", "x", "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25191],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"b", " ", "d"}], "]"}]], "Output",
 ImageSize->{42, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->9301]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", 
    RowBox[{"a", " ", "b"}], ",", 
    RowBox[{"a", " ", "b", " ", "c"}]}], "}"}], "/.", 
  RowBox[{
   RowBox[{"a", " ", "x_."}], "\[Rule]", 
   RowBox[{"f", "[", "x", "]"}]}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->378],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"f", "[", "1", "]"}], ",", 
   RowBox[{"f", "[", "b", "]"}], ",", 
   RowBox[{"f", "[", 
    RowBox[{"b", " ", "c"}], "]"}]}], "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->25387]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->27879],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Expand",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Expand"]], "InlineFormula"],
 " to expand out products:"
}], "ExampleText",
 CellID->13500],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "+", "x"}], ")"}], 
  RowBox[{"(", 
   RowBox[{"2", "+", "x"}], ")"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6615],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"1", "+", "x"}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"2", "+", "x"}], ")"}]}]], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12709]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24072],

Cell[BoxData[
 RowBox[{"2", "+", 
  RowBox[{"3", " ", "x"}], "+", 
  SuperscriptBox["x", "2"]}]], "Output",
 ImageSize->{66, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->25061]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20570],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Divide",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Divide"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TimesBy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TimesBy"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NonCommutativeMultiply",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NonCommutativeMultiply"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dot",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Dot"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->25589]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30439],

Cell[TextData[ButtonBox["Arithmetic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Arithmetic"]], "Tutorials",
 CellID->21880],

Cell[TextData[ButtonBox["Operators",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Operators"]], "Tutorials",
 CellID->400354195]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->7183148],

Cell[TextData[ButtonBox["Arithmetic Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ArithmeticFunctions"]], "MoreAbout",
 CellID->29206947],

Cell[TextData[ButtonBox["Mathematical Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MathematicalFunctions"]], "MoreAbout",
 CellID->167733],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout",
 CellID->172080906],

Cell[TextData[ButtonBox["Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixOperations"]], "MoreAbout",
 CellID->570873250],

Cell[TextData[ButtonBox["Operations on Vectors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/OperationsOnVectors"]], "MoreAbout",
 CellID->93943345]
}, Open  ]],

Cell["New in 1  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Times (*, \[Times]) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 26, 50.7232880}", "context" -> "System`", 
    "keywords" -> {
     "asterisk", "FFT multiplication", "Karatsuba algorithm", "multiply", 
      "number-theoretic transforms"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "x*y*z, x*y*z or x y z represents a product of terms. ", 
    "synonyms" -> {"*"}, "title" -> "Times", "type" -> "Symbol", "uri" -> 
    "ref/Times"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7469, 258, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->411432099]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 19521, 763}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2750, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3373, 89, 108, 4, 70, "ObjectName",
 CellID->22316],
Cell[3484, 95, 770, 26, 70, "Usage",
 CellID->2429]
}, Open  ]],
Cell[CellGroupData[{
Cell[4291, 126, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4769, 143, 543, 17, 70, "Notes",
 CellID->7761],
Cell[5315, 162, 557, 22, 70, "Notes",
 CellID->9133],
Cell[5875, 186, 318, 12, 70, "Notes",
 CellID->12930],
Cell[6196, 200, 248, 10, 70, "Notes",
 CellID->10746],
Cell[6447, 212, 279, 12, 70, "Notes",
 CellID->5532],
Cell[6729, 226, 290, 12, 70, "Notes",
 CellID->25283],
Cell[7022, 240, 410, 13, 70, "Notes",
 CellID->30873]
}, Closed]],
Cell[CellGroupData[{
Cell[7469, 258, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->411432099],
Cell[CellGroupData[{
Cell[7854, 272, 148, 5, 70, "ExampleSection",
 CellID->267589551],
Cell[8005, 279, 240, 8, 70, "ExampleText",
 CellID->10597],
Cell[CellGroupData[{
Cell[8270, 291, 98, 3, 28, "Input",
 CellID->32189],
Cell[8371, 296, 155, 5, 36, "Output",
 CellID->13163]
}, Open  ]],
Cell[8541, 304, 56, 1, 70, "ExampleText",
 CellID->30444],
Cell[CellGroupData[{
Cell[8622, 309, 98, 3, 28, "Input",
 CellID->18621],
Cell[8723, 314, 155, 5, 36, "Output",
 CellID->24705]
}, Open  ]],
Cell[8893, 322, 120, 3, 70, "ExampleDelimiter",
 CellID->2815],
Cell[9016, 327, 200, 7, 70, "ExampleText",
 CellID->10713],
Cell[CellGroupData[{
Cell[9241, 338, 140, 5, 70, "Input",
 CellID->22334],
Cell[9384, 345, 281, 10, 36, "Output",
 CellID->16999]
}, Open  ]],
Cell[CellGroupData[{
Cell[9702, 360, 305, 12, 70, "Input",
 CellID->13137],
Cell[10010, 374, 402, 15, 36, "Output",
 CellID->25615]
}, Open  ]],
Cell[10427, 392, 121, 3, 70, "ExampleDelimiter",
 CellID->14164],
Cell[10551, 397, 188, 8, 70, "ExampleText",
 CellID->32058],
Cell[CellGroupData[{
Cell[10764, 409, 130, 4, 70, "Input",
 CellID->23511],
Cell[10897, 415, 153, 5, 36, "Output",
 CellID->8383]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11099, 426, 233, 7, 70, "ExampleSection",
 CellID->12251],
Cell[11335, 435, 189, 7, 70, "ExampleText",
 CellID->24420],
Cell[CellGroupData[{
Cell[11549, 446, 279, 11, 70, "Input",
 CellID->24061],
Cell[11831, 459, 402, 15, 36, "Output",
 CellID->14360]
}, Open  ]],
Cell[12248, 477, 121, 3, 70, "ExampleDelimiter",
 CellID->29767],
Cell[12372, 482, 201, 8, 70, "ExampleText",
 CellID->15273],
Cell[CellGroupData[{
Cell[12598, 494, 184, 6, 70, "Input",
 CellID->8034],
Cell[12785, 502, 186, 6, 36, "Output",
 CellID->32133]
}, Open  ]],
Cell[CellGroupData[{
Cell[13008, 513, 225, 7, 70, "Input",
 CellID->25191],
Cell[13236, 522, 203, 7, 36, "Output",
 CellID->9301]
}, Open  ]],
Cell[CellGroupData[{
Cell[13476, 534, 288, 10, 70, "Input",
 CellID->378],
Cell[13767, 546, 322, 11, 36, "Output",
 CellID->25387]
}, Open  ]],
Cell[14104, 560, 121, 3, 70, "ExampleDelimiter",
 CellID->27879],
Cell[14228, 565, 202, 8, 70, "ExampleText",
 CellID->13500],
Cell[CellGroupData[{
Cell[14455, 577, 176, 7, 70, "Input",
 CellID->6615],
Cell[14634, 586, 270, 10, 36, "Output",
 CellID->12709]
}, Open  ]],
Cell[CellGroupData[{
Cell[14941, 601, 98, 3, 70, "Input",
 CellID->24072],
Cell[15042, 606, 233, 8, 36, "Output",
 CellID->25061]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15336, 621, 311, 9, 70, "SeeAlsoSection",
 CellID->20570],
Cell[15650, 632, 953, 35, 70, "SeeAlso",
 CellID->25589]
}, Open  ]],
Cell[CellGroupData[{
Cell[16640, 672, 314, 9, 70, "TutorialsSection",
 CellID->30439],
Cell[16957, 683, 131, 3, 70, "Tutorials",
 CellID->21880],
Cell[17091, 688, 133, 3, 70, "Tutorials",
 CellID->400354195]
}, Open  ]],
Cell[CellGroupData[{
Cell[17261, 696, 317, 9, 70, "MoreAboutSection",
 CellID->7183148],
Cell[17581, 707, 150, 3, 70, "MoreAbout",
 CellID->29206947],
Cell[17734, 712, 152, 3, 70, "MoreAbout",
 CellID->167733],
Cell[17889, 717, 163, 3, 70, "MoreAbout",
 CellID->172080906],
Cell[18055, 722, 145, 3, 70, "MoreAbout",
 CellID->570873250],
Cell[18203, 727, 151, 3, 70, "MoreAbout",
 CellID->93943345]
}, Open  ]],
Cell[18369, 733, 50, 0, 70, "History"],
Cell[18422, 735, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

