(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19996,        785]
NotebookOptionsPosition[     14611,        594]
NotebookOutlinePosition[     15867,        630]
CellTagsIndexPosition[     15782,        625]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Special Forms of Assignment" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/SpecialFormsOfAssignment"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Special Forms of Assignment\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DivideBy" :> Documentation`HelpLookup["paclet:ref/DivideBy"], 
          "AddTo" :> Documentation`HelpLookup["paclet:ref/AddTo"], "Set" :> 
          Documentation`HelpLookup["paclet:ref/Set"], "Times" :> 
          Documentation`HelpLookup["paclet:ref/Times"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"DivideBy\"\>", 2->"\<\"AddTo\"\>", 
       3->"\<\"Set\"\>", 4->"\<\"Times\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Procedural Programming" :> 
          Documentation`HelpLookup["paclet:guide/ProceduralProgramming"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Procedural Programming\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[TextData[{
 "TimesBy ",
 StyleBox["(*=)", "OperatorCharacter"]
}], "ObjectName",
 CellID->13345],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "*=", 
       StyleBox["c", "TI"]}]], "InlineFormula"],
     "\[LineSeparator]multiplies ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " by ",
     Cell[BoxData[
      StyleBox["c", "TI"]], "InlineFormula"],
     " and returns the new value of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->31443]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TimesBy",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TimesBy"]], "InlineFormula"],
 " has the attribute ",
 Cell[BoxData[
  ButtonBox["HoldFirst",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldFirst"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9850],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "*=", 
   StyleBox["c", "TI"]}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "=", 
   RowBox[{
    StyleBox["x", "TI"], "*", 
    StyleBox["c", "TI"]}]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->22593]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->518784990],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->394515552],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"k", "=", "3"}], ";"}], "\n", 
 RowBox[{"k", "*=", "5"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->61208960],

Cell[BoxData["15"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->442516989]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData["k"], "Input",
 CellLabel->"In[2]:=",
 CellID->941284000],

Cell[BoxData["15"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->621512093]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->154007266],

Cell["Multiply by a numerical value:", "ExampleText",
 CellID->1113876286],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "=", "1.5"}], ";", " ", 
  RowBox[{"x", "*=", "2.5"}], ";", "x"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1774324750],

Cell[BoxData["3.75`"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->292812581]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->446544314],

Cell["Multiply by a symbolic value:", "ExampleText",
 CellID->838884225],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"v", "=", "a"}], ";", 
  RowBox[{"v", "*=", "b"}], ";", "v"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1698859122],

Cell[BoxData[
 RowBox[{"a", " ", "b"}]], "Output",
 ImageSize->{21, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->35005282]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->24025955],

Cell["Multiply all values in a list by a scalar:", "ExampleText",
 CellID->822015323],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->2332824],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "2", ",", "3"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->252165324]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "*=", "2"}], ";", "x"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1729906436],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2", ",", "4", ",", "6"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->121879970]
}, Open  ]],

Cell["Multiply all values in a list by another list:", "ExampleText",
 CellID->142182714],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "*=", 
   RowBox[{"{", 
    RowBox[{"10", ",", "20", ",", "30"}], "}"}]}], ";", "x"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->628970065],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"20", ",", "80", ",", "180"}], "}"}]], "Output",
 ImageSize->{90, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->473810397]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->59572647],

Cell["Find the first power of two above one million:", "ExampleText",
 CellID->413532944],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"i", "=", "1"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"While", "[", 
   RowBox[{
    RowBox[{"i", "<", 
     RowBox[{"10", "^", "6"}]}], ",", 
    RowBox[{"i", "*=", "2"}]}], "]"}], ";", "i"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->56038471],

Cell[BoxData["1048576"], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->80886346]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->80278534],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TimesBy",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TimesBy"]], "InlineFormula"],
 " is a short form of this assignment:"
}], "ExampleText",
 CellID->322174398],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"k", "=", "1"}], ";"}], "\n", 
 RowBox[{"k", "=", 
  RowBox[{"k", "*", "2"}]}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->13919786],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->378024572]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25746104],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DivideBy",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DivideBy"]], "InlineFormula"],
 " is closely related:"
}], "ExampleText",
 CellID->311642178],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"k", "=", "2"}], ";"}], "\n", 
 RowBox[{"k", "*=", "2"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->70435602],

Cell[BoxData["4"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->77520261]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"k", "/=", "2"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->427238025],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->251878332]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->47087791],

Cell["A variable to be multiplied must have an initial value:", "ExampleText",
 CellID->992262862],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "*=", "2"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1397421414],

Cell[BoxData[
 RowBox[{
  RowBox[{"TimesBy", "::", "\<\"rvalue\"\>"}], ":", 
  " ", "\<\"\\!\\(x\\) is not a variable with a value, so its value cannot be \
changed. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\
\", ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/rvalue\\\", \
ButtonNote -> \\\"TimesBy::rvalue\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->12613345],

Cell[BoxData[
 RowBox[{"x", "*=", "2"}]], "Output",
 ImageSize->{39, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->5152816]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30736],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DivideBy",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DivideBy"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AddTo",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AddTo"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Set",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Set"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Times",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Times"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6502]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18664],

Cell[TextData[ButtonBox["Special Forms of Assignment",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/SpecialFormsOfAssignment"]], "Tutorials",
 CellID->14442]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->291172363],

Cell[TextData[ButtonBox["Procedural Programming",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ProceduralProgramming"]], "MoreAbout",
 CellID->272273754]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TimesBy (*=) - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 26, 50.4420308}", "context" -> "System`", 
    "keywords" -> {"incremental multiplication", "fused multiply assign"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "x *= c multiplies x by c and returns the new value of x. ", 
    "synonyms" -> {"times by", "*="}, "title" -> "TimesBy", "type" -> 
    "Symbol", "uri" -> "ref/TimesBy"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4569, 159, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->518784990]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15639, 618}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2019, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2642, 76, 101, 4, 70, "ObjectName",
 CellID->13345],
Cell[2746, 82, 635, 22, 70, "Usage",
 CellID->31443]
}, Open  ]],
Cell[CellGroupData[{
Cell[3418, 109, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3896, 126, 311, 12, 70, "Notes",
 CellID->9850],
Cell[4210, 140, 322, 14, 70, "Notes",
 CellID->22593]
}, Closed]],
Cell[CellGroupData[{
Cell[4569, 159, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->518784990],
Cell[CellGroupData[{
Cell[4954, 173, 148, 5, 70, "ExampleSection",
 CellID->394515552],
Cell[CellGroupData[{
Cell[5127, 182, 145, 5, 47, "Input",
 CellID->61208960],
Cell[5275, 189, 159, 5, 36, "Output",
 CellID->442516989]
}, Open  ]],
Cell[CellGroupData[{
Cell[5471, 199, 70, 2, 28, "Input",
 CellID->941284000],
Cell[5544, 203, 159, 5, 36, "Output",
 CellID->621512093]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5752, 214, 220, 7, 70, "ExampleSection",
 CellID->154007266],
Cell[5975, 223, 74, 1, 70, "ExampleText",
 CellID->1113876286],
Cell[CellGroupData[{
Cell[6074, 228, 159, 5, 70, "Input",
 CellID->1774324750],
Cell[6236, 235, 162, 5, 36, "Output",
 CellID->292812581]
}, Open  ]],
Cell[6413, 243, 125, 3, 70, "ExampleDelimiter",
 CellID->446544314],
Cell[6541, 248, 72, 1, 70, "ExampleText",
 CellID->838884225],
Cell[CellGroupData[{
Cell[6638, 253, 150, 5, 70, "Input",
 CellID->1698859122],
Cell[6791, 260, 179, 6, 36, "Output",
 CellID->35005282]
}, Open  ]],
Cell[6985, 269, 124, 3, 70, "ExampleDelimiter",
 CellID->24025955],
Cell[7112, 274, 85, 1, 70, "ExampleText",
 CellID->822015323],
Cell[CellGroupData[{
Cell[7222, 279, 147, 5, 70, "Input",
 CellID->2332824],
Cell[7372, 286, 213, 7, 36, "Output",
 CellID->252165324]
}, Open  ]],
Cell[CellGroupData[{
Cell[7622, 298, 117, 4, 70, "Input",
 CellID->1729906436],
Cell[7742, 304, 213, 7, 36, "Output",
 CellID->121879970]
}, Open  ]],
Cell[7970, 314, 89, 1, 70, "ExampleText",
 CellID->142182714],
Cell[CellGroupData[{
Cell[8084, 319, 178, 6, 70, "Input",
 CellID->628970065],
Cell[8265, 327, 217, 7, 36, "Output",
 CellID->473810397]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8531, 340, 226, 7, 70, "ExampleSection",
 CellID->59572647],
Cell[8760, 349, 89, 1, 70, "ExampleText",
 CellID->413532944],
Cell[CellGroupData[{
Cell[8874, 354, 278, 10, 70, "Input",
 CellID->56038471],
Cell[9155, 366, 163, 5, 36, "Output",
 CellID->80886346]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[9367, 377, 236, 7, 70, "ExampleSection",
 CellID->80278534],
Cell[9606, 386, 211, 7, 70, "ExampleText",
 CellID->322174398],
Cell[CellGroupData[{
Cell[9842, 397, 167, 6, 70, "Input",
 CellID->13919786],
Cell[10012, 405, 158, 5, 36, "Output",
 CellID->378024572]
}, Open  ]],
Cell[10185, 413, 124, 3, 70, "ExampleDelimiter",
 CellID->25746104],
Cell[10312, 418, 197, 7, 70, "ExampleText",
 CellID->311642178],
Cell[CellGroupData[{
Cell[10534, 429, 145, 5, 70, "Input",
 CellID->70435602],
Cell[10682, 436, 157, 5, 36, "Output",
 CellID->77520261]
}, Open  ]],
Cell[CellGroupData[{
Cell[10876, 446, 93, 3, 70, "Input",
 CellID->427238025],
Cell[10972, 451, 158, 5, 36, "Output",
 CellID->251878332]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[11179, 462, 229, 7, 70, "ExampleSection",
 CellID->47087791],
Cell[11411, 471, 98, 1, 70, "ExampleText",
 CellID->992262862],
Cell[CellGroupData[{
Cell[11534, 476, 94, 3, 70, "Input",
 CellID->1397421414],
Cell[11631, 481, 403, 7, 70, "Message",
 CellID->12613345],
Cell[12037, 490, 179, 6, 36, "Output",
 CellID->5152816]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12277, 503, 311, 9, 70, "SeeAlsoSection",
 CellID->30736],
Cell[12591, 514, 918, 35, 70, "SeeAlso",
 CellID->6502]
}, Open  ]],
Cell[CellGroupData[{
Cell[13546, 554, 314, 9, 70, "TutorialsSection",
 CellID->18664],
Cell[13863, 565, 162, 3, 70, "Tutorials",
 CellID->14442]
}, Open  ]],
Cell[CellGroupData[{
Cell[14062, 573, 319, 9, 70, "MoreAboutSection",
 CellID->291172363],
Cell[14384, 584, 155, 3, 70, "MoreAbout",
 CellID->272273754]
}, Open  ]],
Cell[14554, 590, 27, 0, 70, "History"],
Cell[14584, 592, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

