(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21094,        733]
NotebookOptionsPosition[     16909,        593]
NotebookOutlinePosition[     18327,        632]
CellTagsIndexPosition[     18242,        627]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Date and Time Functions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/DateAndTimeFunctions"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Date and Time Functions\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"AbsoluteTiming" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteTiming"], "TimeUsed" :> 
          Documentation`HelpLookup["paclet:ref/TimeUsed"], "TimeConstrained" :> 
          Documentation`HelpLookup["paclet:ref/TimeConstrained"], 
          "SessionTime" :> Documentation`HelpLookup["paclet:ref/SessionTime"],
           "AbsoluteTime" :> 
          Documentation`HelpLookup["paclet:ref/AbsoluteTime"], 
          "ClearSystemCache" :> 
          Documentation`HelpLookup["paclet:ref/ClearSystemCache"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"AbsoluteTiming\"\>", 
       2->"\<\"TimeUsed\"\>", 3->"\<\"TimeConstrained\"\>", 
       4->"\<\"SessionTime\"\>", 5->"\<\"AbsoluteTime\"\>", 
       6->"\<\"ClearSystemCache\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Date & Time" :> 
          Documentation`HelpLookup["paclet:guide/DateAndTime"], 
          "Time Measurement & Optimization" :> 
          Documentation`HelpLookup[
           "paclet:guide/TimeMeasurementAndOptimization"], 
          "Tuning & Debugging" :> 
          Documentation`HelpLookup["paclet:guide/TuningAndDebugging"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Date & Time\"\>", 
       2->"\<\"Time Measurement & Optimization\"\>", 
       3->"\<\"Tuning & Debugging\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Timing", "ObjectName",
 CellID->27110],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Timing",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Timing"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]evaluates ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ", and returns a list of the time in seconds used, together with the \
result obtained. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->24417]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Timing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Timing"]], "InlineFormula"],
 " has attribute ",
 Cell[BoxData[
  ButtonBox["HoldAll",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldAll"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->8125],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Timing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Timing"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ";"}], "]"}]], "InlineFormula"],
 " will give ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["timing", "TI"], ",", 
    ButtonBox["Null",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Null"]}], "}"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->7406],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Timing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Timing"]], "InlineFormula"],
 " is accurate only down to a granularity of at least ",
 Cell[BoxData[
  ButtonBox["$TimeUnit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$TimeUnit"]], "InlineFormula"],
 " seconds. "
}], "Notes",
 CellID->28463],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Timing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Timing"]], "InlineFormula"],
 " includes only CPU time spent in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel. It does not include time spent in external processes connected via \
",
 StyleBox["MathLink",
  FontSlant->"Italic"],
 " or otherwise. Nor does it include time spent in the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " front end. "
}], "Notes",
 CellID->32048],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Timing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Timing"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " includes only time spent in the evaluation of ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ", and not, for example, in the formatting or printing of the result. "
}], "Notes",
 CellID->4690],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Timing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Timing"]], "InlineFormula"],
 " should give accurate results on all operating systems where the running of \
processes is specifically scheduled by the operating system. "
}], "Notes",
 CellID->4969],

Cell[TextData[{
 "On certain computer systems with several CPUs the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " kernel may sometimes spawn additional threads on different CPUs. On some \
operating systems, ",
 Cell[BoxData[
  ButtonBox["Timing",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Timing"]], "InlineFormula"],
 " may ignore these additional threads. On other operating systems, it may \
give the total time spent in all threads, which may exceed the result from ",
 Cell[BoxData[
  ButtonBox["AbsoluteTiming",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AbsoluteTiming"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->5344],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Timing",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Timing"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " may give different results on different occasions within a session. A \
typical reason is the use of internal system caches, which can be cleared \
with ",
 Cell[BoxData[
  ButtonBox["ClearSystemCache",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ClearSystemCache"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->303163042]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->792225946],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->28711111],

Cell["Timing for a computation:", "ExampleText",
 CellID->701561233],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Total", "[", 
   RowBox[{"Range", "[", "123456", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->194309641],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.06999999999999877`", ",", "7620753696"}], "}"}]], "Output",
 ImageSize->{134, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->204462603]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->211193062],

Cell["Compare timings for doing a computation different ways:", "ExampleText",
 CellID->406087762],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", " ", "=", " ", 
      RowBox[{"1", "/", "Pi"}]}], "}"}], ",", 
    RowBox[{
     RowBox[{"Do", "[", 
      RowBox[{
       RowBox[{"x", " ", "=", " ", 
        RowBox[{"3.5", " ", "x", 
         RowBox[{"(", 
          RowBox[{"1", "-", "x"}], ")"}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"10", "^", "6"}], "}"}]}], "]"}], ";", "x"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->394158264],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3.054`", ",", "0.5008842103072177`"}], "}"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->261891435]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{"Nest", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"3.5", " ", "#", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", "#"}], ")"}]}], "&"}], ",", 
    RowBox[{"1.", "/", "Pi"}], ",", 
    RowBox[{"10", "^", "6"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1023423120],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.1599999999999991`", ",", "0.500884210307218`"}], "}"}]], "Output",\

 ImageSize->{114, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->103347407]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->215104445],

Cell["\<\
Suppress output to check the timing when the results are very large:\
\>", "ExampleText",
 CellID->282942221],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Timing", "[", 
  RowBox[{
   RowBox[{"f", " ", "=", " ", 
    RowBox[{"Fourier", "[", 
     RowBox[{"RandomReal", "[", 
      RowBox[{"1", ",", 
       RowBox[{"2", "^", "16"}]}], "]"}], "]"}]}], ";"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->90436708],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0.02999999999999437`", ",", "Null"}], "}"}]], "Output",
 ImageSize->{86, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->196287226]
}, Open  ]],

Cell["\<\
Make a plot comparing times for computing an FFT of length n:\
\>", "ExampleText",
 CellID->224288278],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"n", ",", 
      RowBox[{"First", "[", 
       RowBox[{"Timing", "[", 
        RowBox[{"Fourier", "[", 
         RowBox[{"RandomReal", "[", 
          RowBox[{"1", ",", "n"}], "]"}], "]"}], "]"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", 
      RowBox[{"2", "^", "16"}], ",", 
      RowBox[{
       RowBox[{"2", "^", "16"}], "+", "100"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->496497053],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxV1F9IU3EUB/CruYrIuIFMCLUpIcNIZlFgYLvRH+nBmrMHKxtjaU/Sbj70
ID6MqIx6cFJIacitjJrE2EOEhdVS6ansNoOSXq5JDJTk1x8RibLvvb/BOV4Y
48Nv53fPOb/zW3kkGmzLVxSlDR/7Wz5Cay65PN84Mui3pcKFM51FyfoPjj3w
9zJ7/aVjH9z2I9MQUU3HGjxUnKyf6RxyHIBv6XUbPt2X62H4Y9R22rEOxw5c
b8/+kfvH7PjztB6HL7B4A96TNSu+LMv3p+AOtp6Gu1m8CU859SQdW/DRzZSf
sPNh+St5QlvH6lPhghX7eS/rh9MlrH64PX97t3t6UtYP553uGVv0jsr64dqt
9u/lehiuKqV4HV4YuI0nIeuHb1ZS/+PwqSmk1yz7Y8D3giPI8LWsH/7N64d3
fqP+mPA/tr8Fz7N4Ab9g56vkC+1sI62rcOThoae//sp+eeCuHZSfD55w9pPx
Gty3hZ0/3G/R/mF4tHh6cqlpXNYPPyql84nBm3R2/vAxlp8Bt56g/qbgBTY/
abiDnZ8JX22k/Cw4Nkv9EXCNH6/T38n61wjt2knaX4Xn+PzDRbtDz49sHJP1
w5f2UbwGe9l8B+ArGTq/MLw/RPvrcBfLLwbfYfFxuJL1x7Djm2YfDEzI9RR8
kJ8/POim/pvwK3Y+FvyGnaeAl53Cc/NfILTQXZoXFTbZ/h54qZzNP+z9ye4/
/Lmf4gPwYVZfGH67i/qnw9WsvzF4rpDyj8MJFm/AY+z+puBhb836xyXDsn7Y
HaD5NeEmtr8F97L5EvBedr8Ul9Au9tn5P5P1u1b31+Na3V8fXHFGba59kqsf
rmbvD8DZMnb/4Qxb1+EV/v8Hb2uh+YjDX3upnwbcyu8/XHWD1tNwg4fNP5xg
+1twHbvfws53fNHb0pOR9a8V2vEgzZcKT0ZZ/bCf9c8Hn4uw+m3n3v8frjBA
PA==
     "]]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{65540., 0},
  PlotRange->{{65536., 65636.}, {0., 0.2900000000000088}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->323423263]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14537],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteTiming",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteTiming"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TimeUsed",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TimeUsed"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TimeConstrained",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TimeConstrained"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SessionTime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SessionTime"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["AbsoluteTime",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/AbsoluteTime"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ClearSystemCache",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ClearSystemCache"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5558]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28599],

Cell[TextData[ButtonBox["Date and Time Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/DateAndTimeFunctions"]], "Tutorials",
 CellID->14643]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->95835887],

Cell[TextData[ButtonBox["Date & Time",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DateAndTime"]], "MoreAbout",
 CellID->596066691],

Cell[TextData[ButtonBox["Time Measurement & Optimization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TimeMeasurementAndOptimization"]], "MoreAbout",
 CellID->224880182],

Cell[TextData[ButtonBox["Tuning & Debugging",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TuningAndDebugging"]], "MoreAbout",
 CellID->75761222]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Timing - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 26, 51.9576946}", "context" -> "System`", 
    "keywords" -> {
     "benchmark", "CPU time", "execution time", "measurement of efficiency", 
      "measure of speed", "performance analysis", "process time", "profiling",
       "algorithm complexity"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Timing[expr] evaluates expr, and returns a list of the time in seconds \
used, together with the result obtained. ", "synonyms" -> {}, "title" -> 
    "Timing", "type" -> "Symbol", "uri" -> "ref/Timing"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7997, 265, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->792225946]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 18099, 620}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2673, 62, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3296, 89, 44, 1, 70, "ObjectName",
 CellID->27110],
Cell[3343, 92, 615, 19, 70, "Usage",
 CellID->24417]
}, Open  ]],
Cell[CellGroupData[{
Cell[3995, 116, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4473, 133, 301, 12, 70, "Notes",
 CellID->8125],
Cell[4777, 147, 444, 18, 70, "Notes",
 CellID->7406],
Cell[5224, 167, 351, 12, 70, "Notes",
 CellID->28463],
Cell[5578, 181, 502, 17, 70, "Notes",
 CellID->32048],
Cell[6083, 200, 397, 12, 70, "Notes",
 CellID->4690],
Cell[6483, 214, 301, 8, 70, "Notes",
 CellID->4969],
Cell[6787, 224, 654, 18, 70, "Notes",
 CellID->5344],
Cell[7444, 244, 516, 16, 70, "Notes",
 CellID->303163042]
}, Closed]],
Cell[CellGroupData[{
Cell[7997, 265, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->792225946],
Cell[CellGroupData[{
Cell[8382, 279, 147, 5, 70, "ExampleSection",
 CellID->28711111],
Cell[8532, 286, 68, 1, 70, "ExampleText",
 CellID->701561233],
Cell[CellGroupData[{
Cell[8625, 291, 172, 5, 28, "Input",
 CellID->194309641],
Cell[8800, 298, 232, 7, 36, "Output",
 CellID->204462603]
}, Open  ]],
Cell[9047, 308, 125, 3, 70, "ExampleDelimiter",
 CellID->211193062],
Cell[9175, 313, 98, 1, 70, "ExampleText",
 CellID->406087762],
Cell[CellGroupData[{
Cell[9298, 318, 528, 18, 70, "Input",
 CellID->394158264],
Cell[9829, 338, 227, 7, 36, "Output",
 CellID->261891435]
}, Open  ]],
Cell[CellGroupData[{
Cell[10093, 350, 334, 11, 70, "Input",
 CellID->1023423120],
Cell[10430, 363, 241, 8, 36, "Output",
 CellID->103347407]
}, Open  ]],
Cell[10686, 374, 125, 3, 70, "ExampleDelimiter",
 CellID->215104445],
Cell[10814, 379, 119, 3, 70, "ExampleText",
 CellID->282942221],
Cell[CellGroupData[{
Cell[10958, 386, 285, 9, 70, "Input",
 CellID->90436708],
Cell[11246, 397, 225, 7, 36, "Output",
 CellID->196287226]
}, Open  ]],
Cell[11486, 407, 112, 3, 70, "ExampleText",
 CellID->224288278],
Cell[CellGroupData[{
Cell[11623, 414, 550, 18, 70, "Input",
 CellID->496497053],
Cell[12176, 434, 1474, 33, 139, "Output",
 CellID->323423263]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13711, 474, 311, 9, 70, "SeeAlsoSection",
 CellID->14537],
Cell[14025, 485, 1486, 53, 70, "SeeAlso",
 CellID->5558]
}, Open  ]],
Cell[CellGroupData[{
Cell[15548, 543, 314, 9, 70, "TutorialsSection",
 CellID->28599],
Cell[15865, 554, 154, 3, 70, "Tutorials",
 CellID->14643]
}, Open  ]],
Cell[CellGroupData[{
Cell[16056, 562, 318, 9, 70, "MoreAboutSection",
 CellID->95835887],
Cell[16377, 573, 134, 3, 70, "MoreAbout",
 CellID->596066691],
Cell[16514, 578, 173, 3, 70, "MoreAbout",
 CellID->224880182],
Cell[16690, 583, 147, 3, 70, "MoreAbout",
 CellID->75761222]
}, Open  ]],
Cell[16852, 589, 27, 0, 70, "History"],
Cell[16882, 591, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

