(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     56347,       2055]
NotebookOptionsPosition[     46018,       1690]
NotebookOutlinePosition[     47490,       1730]
CellTagsIndexPosition[     47404,       1725]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Representation of Textual Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheRepresentationOfTextualForms"], 
          "Formatted Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormattedOutput"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"The Representation of Textual Forms\"\>", 
       2->"\<\"Formatted Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ToString" :> Documentation`HelpLookup["paclet:ref/ToString"], 
          "ToExpression" :> 
          Documentation`HelpLookup["paclet:ref/ToExpression"], "MakeBoxes" :> 
          Documentation`HelpLookup["paclet:ref/MakeBoxes"], "HoldForm" :> 
          Documentation`HelpLookup["paclet:ref/HoldForm"], "DisplayForm" :> 
          Documentation`HelpLookup["paclet:ref/DisplayForm"], "StandardForm" :> 
          Documentation`HelpLookup["paclet:ref/StandardForm"], 
          "TraditionalForm" :> 
          Documentation`HelpLookup["paclet:ref/TraditionalForm"], "Format" :> 
          Documentation`HelpLookup["paclet:ref/Format"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ToString\"\>", 2->"\<\"ToExpression\"\>", 
       3->"\<\"MakeBoxes\"\>", 4->"\<\"HoldForm\"\>", 
       5->"\<\"DisplayForm\"\>", 6->"\<\"StandardForm\"\>", 
       7->"\<\"TraditionalForm\"\>", 8->"\<\"Format\"\>"}, "\<\"see also\"\>",
        
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ToBoxes", "ObjectName",
 CellID->25560],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ToBoxes",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ToBoxes"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]generates boxes corresponding to the printed form of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      ButtonBox["StandardForm",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ToBoxes",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ToBoxes"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["form", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the boxes corresponding to output in the \
specified form. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->22133]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToBoxes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToBoxes"]], "InlineFormula"],
 " uses any relevant definitions given for ",
 Cell[BoxData[
  ButtonBox["Format",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Format"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["MakeBoxes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MakeBoxes"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->12212142]
}], "Notes",
 CellID->15452],

Cell[TextData[{
 "You can see how box structures generated by ",
 Cell[BoxData[
  ButtonBox["ToBoxes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToBoxes"]], "InlineFormula"],
 " would be displayed by using ",
 Cell[BoxData[
  ButtonBox["DisplayForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DisplayForm"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->311275606]
}], "Notes",
 CellID->24800]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->282796710],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->56396537],

Cell["Box representation of a polynomial:", "ExampleText",
 CellID->82304522],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToBoxes", "[", 
  RowBox[{"a", "+", 
   RowBox[{"b", "^", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->60899740],

Cell[BoxData[
 RowBox[{"RowBox", "[", 
  RowBox[{"{", 
   RowBox[{"\<\"a\"\>", ",", "\<\"+\"\>", ",", 
    RowBox[{"SuperscriptBox", "[", 
     RowBox[{"\<\"b\"\>", ",", "\<\"2\"\>"}], "]"}]}], "}"}], "]"}]], "Output",\

 ImageSize->{248, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->624695670]
}, Open  ]],

Cell["Display boxes as formatted: ", "ExampleText",
 CellID->95895987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DisplayForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->40815824],

Cell[BoxData[
 TagBox[
  RowBox[{"a", "+", 
   SuperscriptBox["b", "2"]}],
  DisplayForm]], "Output",
 ImageSize->{37, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//DisplayForm=",
 CellID->72619284]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->147778807],

Cell["Box representation of a graphic:", "ExampleText",
 CellID->506613430],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToBoxes", "[", 
  GraphicsBox[{
    {RGBColor[1, 0, 0], DiskBox[{0, 0}]}, 
    {RGBColor[0, 0, 1], 
     RectangleBox[NCache[{Rational[1, 2], Rational[1, 2]}, {0.5, 0.5}], 
      NCache[{Rational[1, 2], Rational[1, 2]}, {0.5, 0.5}]]}}], 
  "]"}]], "Input",
 GraphicsBoxOptions->{ImageSize->{150, Automatic}},
 CellLabel->"In[1]:=",
 CellID->329304623],

Cell[BoxData[
 RowBox[{"GraphicsBox", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"RGBColor", "[", 
       RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", 
      RowBox[{"DiskBox", "[", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"RGBColor", "[", 
       RowBox[{"0", ",", "0", ",", "1"}], "]"}], ",", 
      RowBox[{"RectangleBox", "[", 
       RowBox[{"NCache", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           FractionBox["1", "2"], ",", 
           FractionBox["1", "2"]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0.5`", ",", "0.5`"}], "}"}]}], "]"}], "]"}]}], "}"}]}], 
   "}"}], "]"}]], "Output",
 ImageSize->{451, 52},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->199664772]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->528597179],

Cell[TextData[{
 "A special function in ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->756809942],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToBoxes", "[", 
  RowBox[{"Beta", "[", 
   RowBox[{"a", ",", "b"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->207310738],

Cell[BoxData[
 RowBox[{"RowBox", "[", 
  RowBox[{"{", 
   RowBox[{"\<\"Beta\"\>", ",", "\<\"[\"\>", ",", 
    RowBox[{"RowBox", "[", 
     RowBox[{"{", 
      RowBox[{"\<\"a\"\>", ",", "\<\",\"\>", ",", "\<\"b\"\>"}], "}"}], "]"}],
     ",", "\<\"]\"\>"}], "}"}], "]"}]], "Output",
 ImageSize->{263, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->101138028]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToBoxes", "[", 
  RowBox[{
   RowBox[{"Beta", "[", 
    RowBox[{"a", ",", "b"}], "]"}], ",", "TraditionalForm"}], "]"}]], "Input",\

 CellLabel->"In[2]:=",
 CellID->104170424],

Cell[BoxData[
 RowBox[{"FormBox", "[", 
  RowBox[{
   RowBox[{"RowBox", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"InterpretationBox", "[", 
       RowBox[{"\<\"\[CapitalBeta]\"\>", ",", "Beta", ",", 
        RowBox[{"Editable", "\[Rule]", "False"}], ",", 
        RowBox[{"Selectable", "\[Rule]", "False"}]}], "]"}], ",", "\<\"(\"\>",
       ",", 
      RowBox[{"RowBox", "[", 
       RowBox[{"{", 
        RowBox[{"\<\"a\"\>", ",", "\<\",\"\>", ",", "\<\"b\"\>"}], "}"}], 
       "]"}], ",", "\<\")\"\>"}], "}"}], "]"}], ",", "TraditionalForm"}], 
  "]"}]], "Output",
 ImageSize->{553, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->7586716]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->11319],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Basic Objects",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->37950378],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Integer",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Integer"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Rational",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rational"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Complex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
 " numbers: "
}], "ExampleText",
 CellID->17800827],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Map", "[", 
  RowBox[{"ToBoxes", ",", 
   RowBox[{"{", 
    RowBox[{"123", ",", 
     RowBox[{"1", "/", "23"}], ",", "1.23", ",", 
     RowBox[{"1", "+", 
      RowBox[{"23", "\[ImaginaryI]"}]}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->540624369],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"123\"\>", ",", 
   RowBox[{"FractionBox", "[", 
    RowBox[{"\<\"1\"\>", ",", "\<\"23\"\>"}], "]"}], ",", "\<\"1.23`\"\>", 
   ",", 
   RowBox[{"RowBox", "[", 
    RowBox[{"{", 
     RowBox[{"\<\"1\"\>", ",", "\<\"+\"\>", ",", 
      RowBox[{"RowBox", "[", 
       RowBox[{"{", 
        RowBox[{"\<\"23\"\>", ",", "\<\" \"\>", 
         ",", "\<\"\[ImaginaryI]\"\>"}], "}"}], "]"}]}], "}"}], "]"}]}], 
  "}"}]], "Output",
 ImageSize->{459, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->98969980]
}, Open  ]],

Cell[TextData[{
 "Arbitrary-precision ",
 Cell[BoxData[
  ButtonBox["Real",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Real"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Complex",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Complex"]], "InlineFormula"],
 " numbers:"
}], "ExampleText",
 CellID->738802486],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToBoxes", "/@", 
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"10", "/", "3"}], ",", 
      RowBox[{
       RowBox[{"10", "/", "3"}], "\[ImaginaryI]"}]}], "}"}], ",", "20"}], 
   "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->55230342],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"3.33333333333333333333333333333333333333`20.\"\>", ",", 
   RowBox[{"RowBox", "[", 
    RowBox[{"{", 
     RowBox[{"\<\"3.33333333333333333333333333333333333333`20.\"\>", 
      ",", "\<\" \"\>", ",", "\<\"\[ImaginaryI]\"\>"}], "}"}], "]"}]}], 
  "}"}]], "Output",
 ImageSize->{434, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->519222368]
}, Open  ]],

Cell["Special constants:", "ExampleText",
 CellID->282669548],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToBoxes", "/@", 
  RowBox[{"{", 
   RowBox[{"I", ",", "Pi", ",", "E"}], "}"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->70178760],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"\[ImaginaryI]\"\>", ",", "\<\"\[Pi]\"\>", 
   ",", "\<\"\[ExponentialE]\"\>"}], "}"}]], "Output",
 ImageSize->{64, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->80581591]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->216480456],

Cell["Characters and strings of characters:", "ExampleText",
 CellID->380723012],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToBoxes", "/@", 
  RowBox[{"{", 
   RowBox[{
   "\"\<a\>\"", ",", "\"\<\[Alpha]\>\"", ",", "\"\<\[CirclePlus]\>\""}], 
   "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->48683404],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"\\\"a\\\"\"\>", ",", "\<\"\\\"\[Alpha]\\\"\"\>", 
   ",", "\<\"\\\"\[CirclePlus]\\\"\"\>"}], "}"}]], "Output",
 ImageSize->{104, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->149419629]
}, Open  ]],

Cell["Control characters for strings:", "ExampleText",
 CellID->372453673],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToBoxes", "[", 
  RowBox[{"\"\<A first line\nA second line\>\"", ",", "StandardForm"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->49753538],

Cell[BoxData["\<\"\\\"A first line\\\\nA second line\\\"\"\>"], "Output",
 ImageSize->{207, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->204774103]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Special Input Forms",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->2549874],

Cell[TextData[{
 "Box representations for various ",
 Cell[BoxData[
  ButtonBox["Power",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Power"]], "InlineFormula"],
 " expressions:"
}], "ExampleText",
 CellID->388790367],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToBoxes", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "^", "x"}], ",", 
    SuperscriptBox["a", "x"], ",", 
    RowBox[{"Sqrt", "[", "a", "]"}], ",", 
    SqrtBox["a"], ",", 
    RadicalBox["a", "3"], ",", 
    RowBox[{"Exp", "[", "x", "]"}], ",", 
    RowBox[{"1", "/", "x"}], ",", 
    FractionBox["1", "x"]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->25296522],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"SuperscriptBox", "[", 
    RowBox[{"\<\"a\"\>", ",", "\<\"x\"\>"}], "]"}], ",", 
   RowBox[{"SuperscriptBox", "[", 
    RowBox[{"\<\"a\"\>", ",", "\<\"x\"\>"}], "]"}], ",", 
   RowBox[{"SqrtBox", "[", "\<\"a\"\>", "]"}], ",", 
   RowBox[{"SqrtBox", "[", "\<\"a\"\>", "]"}], ",", 
   RowBox[{"SuperscriptBox", "[", 
    RowBox[{"\<\"a\"\>", ",", 
     RowBox[{"RowBox", "[", 
      RowBox[{"{", 
       RowBox[{"\<\"1\"\>", ",", "\<\"/\"\>", ",", "\<\"3\"\>"}], "}"}], 
      "]"}]}], "]"}], ",", 
   RowBox[{"SuperscriptBox", "[", 
    RowBox[{"\<\"\[ExponentialE]\"\>", ",", "\<\"x\"\>"}], "]"}], ",", 
   RowBox[{"FractionBox", "[", 
    RowBox[{"\<\"1\"\>", ",", "\<\"x\"\>"}], "]"}], ",", 
   RowBox[{"FractionBox", "[", 
    RowBox[{"\<\"1\"\>", ",", "\<\"x\"\>"}], "]"}]}], "}"}]], "Output",
 ImageSize->{424, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->132739346]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->114926028],

Cell["Special typeset expressions:", "ExampleText",
 CellID->47897797],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToBoxes", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     RowBox[{"y", "'"}], "[", "x", "]"}], ",", 
    RowBox[{"\[Integral]", 
     RowBox[{
      RowBox[{"y", "[", "x", "]"}], 
      RowBox[{"\[DifferentialD]", "x"}]}]}], ",", 
    RowBox[{
     SubsuperscriptBox["\[Sum]", 
      RowBox[{"k", "=", "1"}], "n"], 
     RowBox[{"y", "[", "k", "]"}]}], ",", 
    RowBox[{
     SubsuperscriptBox["\[Product]", 
      RowBox[{"k", "=", "1"}], "n"], 
     RowBox[{"y", "[", "k", "]"}]}], ",", 
    RowBox[{"x", "\[Element]", "Reals"}], ",", 
    RowBox[{
     RowBox[{"x", "\[And]", "y"}], "\[Or]", "z"}]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->177296101],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"RowBox", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"SuperscriptBox", "[", 
       RowBox[{"\<\"y\"\>", ",", "\<\"\[Prime]\"\>", ",", 
        RowBox[{"MultilineFunction", "\[Rule]", "None"}]}], "]"}], 
      ",", "\<\"[\"\>", ",", "\<\"x\"\>", ",", "\<\"]\"\>"}], "}"}], "]"}], 
   ",", 
   RowBox[{"RowBox", "[", 
    RowBox[{"{", 
     RowBox[{"\<\"\[Integral]\"\>", ",", 
      RowBox[{"RowBox", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"RowBox", "[", 
          RowBox[{"{", 
           
           RowBox[{"\<\"y\"\>", ",", "\<\"[\"\>", ",", "\<\"x\"\>", 
            ",", "\<\"]\"\>"}], "}"}], "]"}], ",", 
         RowBox[{"RowBox", "[", 
          RowBox[{"{", 
           RowBox[{"\<\"\[DifferentialD]\"\>", ",", "\<\"x\"\>"}], "}"}], 
          "]"}]}], "}"}], "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"RowBox", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"UnderoverscriptBox", "[", 
       RowBox[{"\<\"\[Sum]\"\>", ",", 
        RowBox[{"RowBox", "[", 
         RowBox[{"{", 
          RowBox[{"\<\"k\"\>", ",", "\<\"=\"\>", ",", "\<\"1\"\>"}], "}"}], 
         "]"}], ",", "\<\"n\"\>"}], "]"}], ",", 
      RowBox[{"RowBox", "[", 
       RowBox[{"{", 
        RowBox[{"\<\"y\"\>", ",", "\<\"[\"\>", ",", "\<\"k\"\>", 
         ",", "\<\"]\"\>"}], "}"}], "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"RowBox", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"UnderoverscriptBox", "[", 
       RowBox[{"\<\"\[Product]\"\>", ",", 
        RowBox[{"RowBox", "[", 
         RowBox[{"{", 
          RowBox[{"\<\"k\"\>", ",", "\<\"=\"\>", ",", "\<\"1\"\>"}], "}"}], 
         "]"}], ",", "\<\"n\"\>"}], "]"}], ",", 
      RowBox[{"RowBox", "[", 
       RowBox[{"{", 
        RowBox[{"\<\"y\"\>", ",", "\<\"[\"\>", ",", "\<\"k\"\>", 
         ",", "\<\"]\"\>"}], "}"}], "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"RowBox", "[", 
    RowBox[{"{", 
     RowBox[{"\<\"x\"\>", ",", "\<\"\[Element]\"\>", ",", "\<\"Reals\"\>"}], 
     "}"}], "]"}], ",", 
   RowBox[{"RowBox", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"RowBox", "[", 
       RowBox[{"{", 
        RowBox[{"\<\"(\"\>", ",", 
         RowBox[{"RowBox", "[", 
          RowBox[{"{", 
           RowBox[{"\<\"x\"\>", ",", "\<\"&&\"\>", ",", "\<\"y\"\>"}], "}"}], 
          "]"}], ",", "\<\")\"\>"}], "}"}], "]"}], ",", "\<\"||\"\>", 
      ",", "\<\"z\"\>"}], "}"}], "]"}]}], "}"}]], "Output",
 ImageSize->{522, 90},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->152986765]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->148843607],

Cell["Different list structures:", "ExampleText",
 CellID->59640089],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToBoxes", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->287661578],

Cell[BoxData[
 RowBox[{"RowBox", "[", 
  RowBox[{"{", 
   RowBox[{"\<\"{\"\>", ",", 
    RowBox[{"RowBox", "[", 
     RowBox[{"{", 
      RowBox[{"\<\"1\"\>", ",", "\<\",\"\>", ",", "\<\"2\"\>", 
       ",", "\<\",\"\>", ",", "\<\"3\"\>"}], "}"}], "]"}], ",", "\<\"}\"\>"}],
    "}"}], "]"}]], "Output",
 ImageSize->{261, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->686971953]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToBoxes", "[", 
  RowBox[{"(", GridBox[{
     {"a", "b", "c"},
     {"d", "e", "f"}
    }], ")"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->250695724],

Cell[BoxData[
 RowBox[{"RowBox", "[", 
  RowBox[{"{", 
   RowBox[{"\<\"{\"\>", ",", 
    RowBox[{"RowBox", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"RowBox", "[", 
        RowBox[{"{", 
         RowBox[{"\<\"{\"\>", ",", 
          RowBox[{"RowBox", "[", 
           RowBox[{"{", 
            
            RowBox[{"\<\"a\"\>", ",", "\<\",\"\>", ",", "\<\"b\"\>", 
             ",", "\<\",\"\>", ",", "\<\"c\"\>"}], "}"}], "]"}], 
          ",", "\<\"}\"\>"}], "}"}], "]"}], ",", "\<\",\"\>", ",", 
       RowBox[{"RowBox", "[", 
        RowBox[{"{", 
         RowBox[{"\<\"{\"\>", ",", 
          RowBox[{"RowBox", "[", 
           RowBox[{"{", 
            
            RowBox[{"\<\"d\"\>", ",", "\<\",\"\>", ",", "\<\"e\"\>", 
             ",", "\<\",\"\>", ",", "\<\"f\"\>"}], "}"}], "]"}], 
          ",", "\<\"}\"\>"}], "}"}], "]"}]}], "}"}], "]"}], 
    ",", "\<\"}\"\>"}], "}"}], "]"}]], "Output",
 ImageSize->{398, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->379395325]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToBoxes", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b", ",", "c"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"d", ",", "e", ",", "f"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->201323793],

Cell[BoxData[
 RowBox[{"RowBox", "[", 
  RowBox[{"{", 
   RowBox[{"\<\"{\"\>", ",", 
    RowBox[{"RowBox", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"RowBox", "[", 
        RowBox[{"{", 
         RowBox[{"\<\"{\"\>", ",", 
          RowBox[{"RowBox", "[", 
           RowBox[{"{", 
            
            RowBox[{"\<\"a\"\>", ",", "\<\",\"\>", ",", "\<\"b\"\>", 
             ",", "\<\",\"\>", ",", "\<\"c\"\>"}], "}"}], "]"}], 
          ",", "\<\"}\"\>"}], "}"}], "]"}], ",", "\<\",\"\>", ",", 
       RowBox[{"RowBox", "[", 
        RowBox[{"{", 
         RowBox[{"\<\"{\"\>", ",", 
          RowBox[{"RowBox", "[", 
           RowBox[{"{", 
            
            RowBox[{"\<\"d\"\>", ",", "\<\",\"\>", ",", "\<\"e\"\>", 
             ",", "\<\",\"\>", ",", "\<\"f\"\>"}], "}"}], "]"}], 
          ",", "\<\"}\"\>"}], "}"}], "]"}]}], "}"}], "]"}], 
    ",", "\<\"}\"\>"}], "}"}], "]"}]], "Output",
 ImageSize->{398, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->14327333]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToBoxes", "[", 
  RowBox[{
   RowBox[{"(", GridBox[{
      {"a", "b", "c"},
      {"d", "e", "f"}
     }], ")"}], ",", "TraditionalForm"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->257938037],

Cell[BoxData[
 RowBox[{"FormBox", "[", 
  RowBox[{
   RowBox[{"RowBox", "[", 
    RowBox[{"{", 
     RowBox[{"\<\"(\"\>", ",", "\<\"\[NoBreak]\"\>", ",", 
      RowBox[{"GridBox", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>"}], "}"}], 
          ",", 
          RowBox[{"{", 
           RowBox[{"\<\"d\"\>", ",", "\<\"e\"\>", ",", "\<\"f\"\>"}], "}"}]}],
          "}"}], ",", 
        RowBox[{"RowSpacings", "\[Rule]", "1"}], ",", 
        RowBox[{"ColumnSpacings", "\[Rule]", "1"}], ",", 
        RowBox[{"ColumnAlignments", "\[Rule]", "Left"}]}], "]"}], 
      ",", "\<\"\[NoBreak]\"\>", ",", "\<\")\"\>"}], "}"}], "]"}], ",", 
   "TraditionalForm"}], "]"}]], "Output",
 ImageSize->{543, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->20109983]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->199509942],

Cell["Inputs with subscripts, superscripts, etc.: ", "ExampleText",
 CellID->327998273],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToBoxes", "/@", 
  RowBox[{"{", 
   RowBox[{
    SubscriptBox["x", "a"], ",", 
    SuperscriptBox["x", "a"], ",", 
    OverscriptBox["x", "a"], ",", 
    UnderscriptBox["x", "a"]}], "}"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->106045711],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"SubscriptBox", "[", 
    RowBox[{"\<\"x\"\>", ",", "\<\"a\"\>"}], "]"}], ",", 
   RowBox[{"SuperscriptBox", "[", 
    RowBox[{"\<\"x\"\>", ",", "\<\"a\"\>"}], "]"}], ",", 
   RowBox[{"OverscriptBox", "[", 
    RowBox[{"\<\"x\"\>", ",", "\<\"a\"\>"}], "]"}], ",", 
   RowBox[{"UnderscriptBox", "[", 
    RowBox[{"\<\"x\"\>", ",", "\<\"a\"\>"}], "]"}]}], "}"}]], "Output",
 ImageSize->{297, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->99675561]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Special Output Forms",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->61550611],

Cell["\<\
Some objects use a special output representation with interpretation:\
\>", "ExampleText",
 CellID->24278613],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Sin", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->19030637],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "-", 
   FractionBox[
    SuperscriptBox["x", "3"], "6"], "+", 
   FractionBox[
    SuperscriptBox["x", "5"], "120"], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[$CellContext`x, 0, {}, 1, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1, 0, 
    Rational[-1, 6], 0, 
    Rational[1, 120]}, 1, 6, 1],
  Editable->False]], "Output",
 ImageSize->{125, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->325138639]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToBoxes", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->455863823],

Cell[BoxData[
 RowBox[{"InterpretationBox", "[", 
  RowBox[{
   RowBox[{"RowBox", "[", 
    RowBox[{"{", 
     RowBox[{"\<\"x\"\>", ",", "\<\"-\"\>", ",", 
      RowBox[{"FractionBox", "[", 
       RowBox[{
        RowBox[{"SuperscriptBox", "[", 
         RowBox[{"\<\"x\"\>", ",", "\<\"3\"\>"}], "]"}], ",", "\<\"6\"\>"}], 
       "]"}], ",", "\<\"+\"\>", ",", 
      RowBox[{"FractionBox", "[", 
       RowBox[{
        RowBox[{"SuperscriptBox", "[", 
         RowBox[{"\<\"x\"\>", ",", "\<\"5\"\>"}], "]"}], ",", "\<\"120\"\>"}],
        "]"}], ",", "\<\"+\"\>", ",", 
      RowBox[{"InterpretationBox", "[", 
       RowBox[{
        RowBox[{"SuperscriptBox", "[", 
         RowBox[{
          RowBox[{"RowBox", "[", 
           RowBox[{"{", 
            
            RowBox[{"\<\"O\"\>", ",", "\<\"[\"\>", ",", "\<\"x\"\>", 
             ",", "\<\"]\"\>"}], "}"}], "]"}], ",", "\<\"6\"\>"}], "]"}], ",",
         
        InterpretationBox[
         SuperscriptBox[
          RowBox[{"O", "[", "x", "]"}], "6"],
         SeriesData[$CellContext`x, 0, {}, 1, 6, 1],
         Editable->False], ",", 
        RowBox[{"Editable", "\[Rule]", "False"}]}], "]"}]}], "}"}], "]"}], 
   ",", 
   InterpretationBox[
    RowBox[{"x", "-", 
     FractionBox[
      SuperscriptBox["x", "3"], "6"], "+", 
     FractionBox[
      SuperscriptBox["x", "5"], "120"], "+", 
     InterpretationBox[
      SuperscriptBox[
       RowBox[{"O", "[", "x", "]"}], "6"],
      SeriesData[$CellContext`x, 0, {}, 1, 6, 1],
      Editable->False]}],
    SeriesData[$CellContext`x, 0, {1, 0, 
      Rational[-1, 6], 0, 
      Rational[1, 120]}, 1, 6, 1],
    Editable->False], ",", 
   RowBox[{"Editable", "\[Rule]", "False"}]}], "]"}]], "Output",
 ImageSize->{485, 93},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->191393390]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->436250060],

Cell["Some objects use an elided output representation:", "ExampleText",
 CellID->199584301],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Interpolation", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3", ",", "2", ",", "1"}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->180547125],

Cell[BoxData[
 TagBox[
  RowBox[{"InterpolatingFunction", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"{", 
      RowBox[{"1", ",", "5"}], "}"}], "}"}], ",", "\<\"<>\"\>"}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{244, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->68188223]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToBoxes", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->48339565],

Cell[BoxData[
 RowBox[{"TagBox", "[", 
  RowBox[{
   RowBox[{"RowBox", "[", 
    RowBox[{"{", 
     RowBox[{"\<\"InterpolatingFunction\"\>", ",", "\<\"[\"\>", ",", 
      RowBox[{"RowBox", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"RowBox", "[", 
          RowBox[{"{", 
           RowBox[{"\<\"{\"\>", ",", 
            RowBox[{"RowBox", "[", 
             RowBox[{"{", 
              RowBox[{"\<\"{\"\>", ",", 
               RowBox[{"RowBox", "[", 
                RowBox[{"{", 
                 RowBox[{"\<\"1\"\>", ",", "\<\",\"\>", ",", "\<\"5\"\>"}], 
                 "}"}], "]"}], ",", "\<\"}\"\>"}], "}"}], "]"}], 
            ",", "\<\"}\"\>"}], "}"}], "]"}], ",", "\<\",\"\>", 
         ",", "\<\"\\\"<>\\\"\"\>"}], "}"}], "]"}], ",", "\<\"]\"\>"}], "}"}],
     "]"}], ",", "False", ",", 
   RowBox[{"Editable", "\[Rule]", "False"}]}], "]"}]], "Output",
 ImageSize->{486, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->115743121]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SparseArray", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], "\[Rule]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->204092505],

Cell[BoxData[
 TagBox[
  RowBox[{"SparseArray", "[", 
   RowBox[{
    InterpretationBox[
     RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "1", 
      "\[InvisibleSpace]", "\<\">\"\>"}],
     SequenceForm["<", 1, ">"],
     Editable->False], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "5"}], "}"}]}], "]"}],
  False,
  Editable->False]], "Output",
 ImageSize->{167, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->305674271]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToBoxes", "[", "%", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->23866938],

Cell[BoxData[
 RowBox[{"TagBox", "[", 
  RowBox[{
   RowBox[{"RowBox", "[", 
    RowBox[{"{", 
     RowBox[{"\<\"SparseArray\"\>", ",", "\<\"[\"\>", ",", 
      RowBox[{"RowBox", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"InterpretationBox", "[", 
          RowBox[{
           RowBox[{"RowBox", "[", 
            RowBox[{"{", 
             
             RowBox[{"\<\"\\\"<\\\"\"\>", ",", "\<\"\[InvisibleSpace]\"\>", 
              ",", "\<\"1\"\>", ",", "\<\"\[InvisibleSpace]\"\>", 
              ",", "\<\"\\\">\\\"\"\>"}], "}"}], "]"}], ",", 
           InterpretationBox[
            
            RowBox[{"\<\"<\"\>", "\[InvisibleSpace]", "1", 
             "\[InvisibleSpace]", "\<\">\"\>"}],
            SequenceForm["<", 1, ">"],
            Editable->False], ",", 
           RowBox[{"Editable", "\[Rule]", "False"}]}], "]"}], 
         ",", "\<\",\"\>", ",", 
         RowBox[{"RowBox", "[", 
          RowBox[{"{", 
           RowBox[{"\<\"{\"\>", ",", 
            RowBox[{"RowBox", "[", 
             RowBox[{"{", 
              RowBox[{"\<\"5\"\>", ",", "\<\",\"\>", ",", "\<\"5\"\>"}], 
              "}"}], "]"}], ",", "\<\"}\"\>"}], "}"}], "]"}]}], "}"}], "]"}], 
      ",", "\<\"]\"\>"}], "}"}], "]"}], ",", "False", ",", 
   RowBox[{"Editable", "\[Rule]", "False"}]}], "]"}]], "Output",
 ImageSize->{536, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->325408024]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3946],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToBoxes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToBoxes"]], "InlineFormula"],
 " evaluates ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ", while ",
 Cell[BoxData[
  ButtonBox["MakeBoxes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MakeBoxes"]], "InlineFormula"],
 " does not:"
}], "ExampleText",
 CellID->54109890],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToBoxes", "[", 
  RowBox[{
   RowBox[{"25", "/", "100"}], ",", "StandardForm"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->36805364],

Cell[BoxData[
 RowBox[{"FractionBox", "[", 
  RowBox[{"\<\"1\"\>", ",", "\<\"4\"\>"}], "]"}]], "Output",
 ImageSize->{121, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->197553649]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MakeBoxes", "[", 
  RowBox[{
   RowBox[{"25", "/", "100"}], ",", "StandardForm"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->604123006],

Cell[BoxData[
 RowBox[{"FractionBox", "[", 
  RowBox[{"\<\"25\"\>", ",", "\<\"100\"\>"}], "]"}]], "Output",
 ImageSize->{142, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->533068303]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->45174421],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToExpression"]], "InlineFormula"],
 " to interpret boxes:"
}], "ExampleText",
 CellID->26672036],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToBoxes", "[", 
  RowBox[{"1", "/", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->330471687],

Cell[BoxData[
 RowBox[{"FractionBox", "[", 
  RowBox[{"\<\"1\"\>", ",", "\<\"10\"\>"}], "]"}]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->191047740]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->105709145],

Cell[BoxData[
 FractionBox["1", "10"]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->13001638]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->166748260],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["DisplayForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/DisplayForm"]], "InlineFormula"],
 " to see how the boxes would display:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->311275606],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToBoxes", "[", 
  RowBox[{"1", "/", "10"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->267458893],

Cell[BoxData[
 RowBox[{"FractionBox", "[", 
  RowBox[{"\<\"1\"\>", ",", "\<\"10\"\>"}], "]"}]], "Output",
 ImageSize->{128, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->319789517]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DisplayForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->45897476],

Cell[BoxData[
 TagBox[
  FractionBox["1", "10"],
  DisplayForm]], "Output",
 ImageSize->{23, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//DisplayForm=",
 CellID->819517177]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->233095204],

Cell[TextData[{
 "Use formatting rules added through ",
 Cell[BoxData[
  ButtonBox["Format",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Format"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->465348431],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToBoxes", "[", 
  RowBox[{"bin", "[", 
   RowBox[{"x", ",", "y"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->822108198],

Cell[BoxData[
 RowBox[{"RowBox", "[", 
  RowBox[{"{", 
   RowBox[{"\<\"bin\"\>", ",", "\<\"[\"\>", ",", 
    RowBox[{"RowBox", "[", 
     RowBox[{"{", 
      RowBox[{"\<\"x\"\>", ",", "\<\",\"\>", ",", "\<\"y\"\>"}], "}"}], "]"}],
     ",", "\<\"]\"\>"}], "}"}], "]"}]], "Output",
 ImageSize->{256, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->633252062]
}, Open  ]],

Cell[TextData[{
 "Add formatting for ",
 Cell[BoxData[
  StyleBox["bin", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->615604365],

Cell[BoxData[
 RowBox[{
  RowBox[{"Format", "[", 
   RowBox[{"bin", "[", 
    RowBox[{"x_", ",", "y_"}], "]"}], "]"}], ":=", 
  RowBox[{"MatrixForm", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", "x", "}"}], ",", 
     RowBox[{"{", "y", "}"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->487184184],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToBoxes", "[", 
  RowBox[{
   RowBox[{"bin", "[", 
    RowBox[{"i", ",", "j"}], "]"}], ",", "StandardForm"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->158111159],

Cell[BoxData[
 RowBox[{"TagBox", "[", 
  RowBox[{
   RowBox[{"RowBox", "[", 
    RowBox[{"{", 
     RowBox[{"\<\"(\"\>", ",", "\<\"\[NoBreak]\"\>", ",", 
      RowBox[{"GridBox", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "\<\"i\"\>", "}"}], ",", 
          RowBox[{"{", "\<\"j\"\>", "}"}]}], "}"}], ",", 
        RowBox[{"RowSpacings", "\[Rule]", "1"}], ",", 
        RowBox[{"ColumnSpacings", "\[Rule]", "1"}], ",", 
        RowBox[{"ColumnAlignments", "\[Rule]", "Left"}]}], "]"}], 
      ",", "\<\"\[NoBreak]\"\>", ",", "\<\")\"\>"}], "}"}], "]"}], ",", 
   RowBox[{"Function", "[", 
    RowBox[{"BoxForm`e$", ",", 
     TagBox["BoxForm`e$",
      Function[BoxForm`e$, 
       MatrixForm[BoxForm`e$]]]}], "]"}]}], "]"}]], "Output",
 ImageSize->{512, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->428310582]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->60109159],

Cell[TextData[{
 "Use formatting rules added through ",
 Cell[BoxData[
  ButtonBox["MakeBoxes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MakeBoxes"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->314775954],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToBoxes", "[", 
  RowBox[{"gplus", "[", 
   RowBox[{"a", ",", "b", ",", "c"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->156161647],

Cell[BoxData[
 RowBox[{"RowBox", "[", 
  RowBox[{"{", 
   RowBox[{"\<\"gplus\"\>", ",", "\<\"[\"\>", ",", 
    RowBox[{"RowBox", "[", 
     RowBox[{"{", 
      RowBox[{"\<\"a\"\>", ",", "\<\",\"\>", ",", "\<\"b\"\>", 
       ",", "\<\",\"\>", ",", "\<\"c\"\>"}], "}"}], "]"}], ",", "\<\"]\"\>"}],
    "}"}], "]"}]], "Output",
 ImageSize->{307, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->225054106]
}, Open  ]],

Cell[BoxData[
 RowBox[{"gplus", "/:", 
  RowBox[{"MakeBoxes", "[", 
   RowBox[{
    RowBox[{"gplus", "[", 
     RowBox[{"x_", ",", "y_", ",", "n_"}], "]"}], ",", "StandardForm"}], 
   "]"}], ":=", 
  RowBox[{"RowBox", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"MakeBoxes", "[", 
      RowBox[{"x", ",", "StandardForm"}], "]"}], ",", 
     RowBox[{"SubscriptBox", "[", 
      RowBox[{"\"\<\[CirclePlus]\>\"", ",", 
       RowBox[{"MakeBoxes", "[", 
        RowBox[{"n", ",", "StandardForm"}], "]"}]}], "]"}], ",", 
     RowBox[{"MakeBoxes", "[", 
      RowBox[{"y", ",", "StandardForm"}], "]"}]}], "}"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->41092370],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToBoxes", "[", 
  RowBox[{"gplus", "[", 
   RowBox[{"a", ",", "b", ",", "c"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->403069092],

Cell[BoxData[
 RowBox[{"RowBox", "[", 
  RowBox[{"{", 
   RowBox[{"\<\"a\"\>", ",", 
    RowBox[{"SubscriptBox", "[", 
     RowBox[{"\<\"\[CirclePlus]\"\>", ",", "\<\"c\"\>"}], "]"}], 
    ",", "\<\"b\"\>"}], "}"}], "]"}]], "Output",
 ImageSize->{234, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->91898819]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11569],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MakeBoxes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MakeBoxes"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HoldForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HoldForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DisplayForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DisplayForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StandardForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StandardForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TraditionalForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraditionalForm"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Format",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Format"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->304]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->603],

Cell[TextData[ButtonBox["The Representation of Textual Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheRepresentationOfTextualForms"]], "Tutorials",\

 CellID->31688],

Cell[TextData[ButtonBox["Formatted Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormattedOutput"]], "Tutorials",
 CellID->156890304]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ToBoxes - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 26, 55.0046476}", "context" -> "System`", 
    "keywords" -> {
     "conversion", "expressions", "convert to box representation", 
      "convert to typeset representation", "2D typesetting", 
      "typesetting representation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ToBoxes[expr] generates boxes corresponding to the printed form of expr \
in StandardForm. ToBoxes[expr, form] gives the boxes corresponding to output \
in the specified form. ", "synonyms" -> {"to boxes"}, "title" -> "ToBoxes", 
    "type" -> "Symbol", "uri" -> "ref/ToBoxes"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5469, 176, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->282796710]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 47261, 1718}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2124, 46, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2747, 73, 45, 1, 70, "ObjectName",
 CellID->25560],
Cell[2795, 76, 1112, 35, 70, "Usage",
 CellID->22133]
}, Open  ]],
Cell[CellGroupData[{
Cell[3944, 116, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4422, 133, 545, 20, 70, "Notes",
 CellID->15452],
Cell[4970, 155, 462, 16, 70, "Notes",
 CellID->24800]
}, Closed]],
Cell[CellGroupData[{
Cell[5469, 176, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->282796710],
Cell[CellGroupData[{
Cell[5854, 190, 147, 5, 70, "ExampleSection",
 CellID->56396537],
Cell[6004, 197, 77, 1, 70, "ExampleText",
 CellID->82304522],
Cell[CellGroupData[{
Cell[6106, 202, 149, 5, 28, "Input",
 CellID->60899740],
Cell[6258, 209, 351, 11, 36, "Output",
 CellID->624695670]
}, Open  ]],
Cell[6624, 223, 70, 1, 70, "ExampleText",
 CellID->95895987],
Cell[CellGroupData[{
Cell[6719, 228, 106, 3, 28, "Input",
 CellID->40815824],
Cell[6828, 233, 243, 9, 50, "Output",
 CellID->72619284]
}, Open  ]],
Cell[7086, 245, 125, 3, 70, "ExampleDelimiter",
 CellID->147778807],
Cell[7214, 250, 75, 1, 70, "ExampleText",
 CellID->506613430],
Cell[CellGroupData[{
Cell[7314, 255, 375, 10, 70, "Input",
 CellID->329304623],
Cell[7692, 267, 896, 29, 73, "Output",
 CellID->199664772]
}, Open  ]],
Cell[8603, 299, 125, 3, 70, "ExampleDelimiter",
 CellID->528597179],
Cell[8731, 304, 356, 13, 70, "ExampleText",
 CellID->756809942],
Cell[CellGroupData[{
Cell[9112, 321, 158, 5, 70, "Input",
 CellID->207310738],
Cell[9273, 328, 412, 12, 36, "Output",
 CellID->101138028]
}, Open  ]],
Cell[CellGroupData[{
Cell[9722, 345, 199, 7, 70, "Input",
 CellID->104170424],
Cell[9924, 354, 708, 20, 54, "Output",
 CellID->7586716]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10681, 380, 216, 7, 70, "ExampleSection",
 CellID->11319],
Cell[CellGroupData[{
Cell[10922, 391, 233, 7, 70, "ExampleSubsection",
 CellID->37950378],
Cell[11158, 400, 555, 22, 70, "ExampleText",
 CellID->17800827],
Cell[CellGroupData[{
Cell[11738, 426, 290, 9, 70, "Input",
 CellID->540624369],
Cell[12031, 437, 595, 18, 36, "Output",
 CellID->98969980]
}, Open  ]],
Cell[12641, 458, 330, 13, 70, "ExampleText",
 CellID->738802486],
Cell[CellGroupData[{
Cell[12996, 475, 297, 11, 70, "Input",
 CellID->55230342],
Cell[13296, 488, 439, 12, 54, "Output",
 CellID->519222368]
}, Open  ]],
Cell[13750, 503, 61, 1, 70, "ExampleText",
 CellID->282669548],
Cell[CellGroupData[{
Cell[13836, 508, 156, 5, 70, "Input",
 CellID->70178760],
Cell[13995, 515, 270, 8, 36, "Output",
 CellID->80581591]
}, Open  ]],
Cell[14280, 526, 125, 3, 70, "ExampleDelimiter",
 CellID->216480456],
Cell[14408, 531, 80, 1, 70, "ExampleText",
 CellID->380723012],
Cell[CellGroupData[{
Cell[14513, 536, 206, 7, 70, "Input",
 CellID->48683404],
Cell[14722, 545, 285, 8, 36, "Output",
 CellID->149419629]
}, Open  ]],
Cell[15022, 556, 74, 1, 70, "ExampleText",
 CellID->372453673],
Cell[CellGroupData[{
Cell[15121, 561, 173, 5, 70, "Input",
 CellID->49753538],
Cell[15297, 568, 204, 5, 36, "Output",
 CellID->204774103]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15550, 579, 238, 7, 70, "ExampleSubsection",
 CellID->2549874],
Cell[15791, 588, 221, 8, 70, "ExampleText",
 CellID->388790367],
Cell[CellGroupData[{
Cell[16037, 600, 405, 13, 70, "Input",
 CellID->25296522],
Cell[16445, 615, 980, 25, 71, "Output",
 CellID->132739346]
}, Open  ]],
Cell[17440, 643, 125, 3, 70, "ExampleDelimiter",
 CellID->114926028],
Cell[17568, 648, 70, 1, 70, "ExampleText",
 CellID->47897797],
Cell[CellGroupData[{
Cell[17663, 653, 695, 22, 70, "Input",
 CellID->177296101],
Cell[18361, 677, 2582, 71, 111, "Output",
 CellID->152986765]
}, Open  ]],
Cell[20958, 751, 125, 3, 70, "ExampleDelimiter",
 CellID->148843607],
Cell[21086, 756, 68, 1, 70, "ExampleText",
 CellID->59640089],
Cell[CellGroupData[{
Cell[21179, 761, 160, 5, 70, "Input",
 CellID->287661578],
Cell[21342, 768, 434, 13, 36, "Output",
 CellID->686971953]
}, Open  ]],
Cell[CellGroupData[{
Cell[21813, 786, 182, 7, 70, "Input",
 CellID->250695724],
Cell[21998, 795, 1049, 30, 54, "Output",
 CellID->379395325]
}, Open  ]],
Cell[CellGroupData[{
Cell[23084, 830, 272, 9, 70, "Input",
 CellID->201323793],
Cell[23359, 841, 1048, 30, 54, "Output",
 CellID->14327333]
}, Open  ]],
Cell[CellGroupData[{
Cell[24444, 876, 223, 8, 70, "Input",
 CellID->257938037],
Cell[24670, 886, 910, 25, 71, "Output",
 CellID->20109983]
}, Open  ]],
Cell[25595, 914, 125, 3, 70, "ExampleDelimiter",
 CellID->199509942],
Cell[25723, 919, 87, 1, 70, "ExampleText",
 CellID->327998273],
Cell[CellGroupData[{
Cell[25835, 924, 267, 9, 70, "Input",
 CellID->106045711],
Cell[26105, 935, 552, 15, 54, "Output",
 CellID->99675561]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[26706, 956, 240, 7, 70, "ExampleSubsection",
 CellID->61550611],
Cell[26949, 965, 119, 3, 70, "ExampleText",
 CellID->24278613],
Cell[CellGroupData[{
Cell[27093, 972, 214, 7, 70, "Input",
 CellID->19030637],
Cell[27310, 981, 587, 20, 54, "Output",
 CellID->325138639]
}, Open  ]],
Cell[CellGroupData[{
Cell[27934, 1006, 103, 3, 70, "Input",
 CellID->455863823],
Cell[28040, 1011, 1850, 53, 114, "Output",
 CellID->191393390]
}, Open  ]],
Cell[29905, 1067, 125, 3, 70, "ExampleDelimiter",
 CellID->436250060],
Cell[30033, 1072, 92, 1, 70, "ExampleText",
 CellID->199584301],
Cell[CellGroupData[{
Cell[30150, 1077, 189, 6, 70, "Input",
 CellID->180547125],
Cell[30342, 1085, 355, 13, 36, "Output",
 CellID->68188223]
}, Open  ]],
Cell[CellGroupData[{
Cell[30734, 1103, 102, 3, 70, "Input",
 CellID->48339565],
Cell[30839, 1108, 1015, 27, 71, "Output",
 CellID->115743121]
}, Open  ]],
Cell[CellGroupData[{
Cell[31891, 1140, 287, 10, 70, "Input",
 CellID->204092505],
Cell[32181, 1152, 479, 17, 36, "Output",
 CellID->305674271]
}, Open  ]],
Cell[CellGroupData[{
Cell[32697, 1174, 102, 3, 70, "Input",
 CellID->23866938],
Cell[32802, 1179, 1456, 38, 71, "Output",
 CellID->325408024]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[34319, 1224, 232, 7, 70, "ExampleSection",
 CellID->3946],
Cell[34554, 1233, 394, 15, 70, "ExampleText",
 CellID->54109890],
Cell[CellGroupData[{
Cell[34973, 1252, 163, 5, 70, "Input",
 CellID->36805364],
Cell[35139, 1259, 235, 7, 36, "Output",
 CellID->197553649]
}, Open  ]],
Cell[CellGroupData[{
Cell[35411, 1271, 166, 5, 70, "Input",
 CellID->604123006],
Cell[35580, 1278, 238, 7, 36, "Output",
 CellID->533068303]
}, Open  ]],
Cell[35833, 1288, 124, 3, 70, "ExampleDelimiter",
 CellID->45174421],
Cell[35960, 1293, 213, 8, 70, "ExampleText",
 CellID->26672036],
Cell[CellGroupData[{
Cell[36198, 1305, 127, 4, 70, "Input",
 CellID->330471687],
Cell[36328, 1311, 236, 7, 36, "Output",
 CellID->191047740]
}, Open  ]],
Cell[CellGroupData[{
Cell[36601, 1323, 108, 3, 70, "Input",
 CellID->105709145],
Cell[36712, 1328, 178, 6, 51, "Output",
 CellID->13001638]
}, Open  ]],
Cell[36905, 1337, 125, 3, 70, "ExampleDelimiter",
 CellID->166748260],
Cell[37033, 1342, 276, 9, 70, "ExampleText",
 CellID->311275606],
Cell[CellGroupData[{
Cell[37334, 1355, 127, 4, 70, "Input",
 CellID->267458893],
Cell[37464, 1361, 236, 7, 36, "Output",
 CellID->319789517]
}, Open  ]],
Cell[CellGroupData[{
Cell[37737, 1373, 106, 3, 70, "Input",
 CellID->45897476],
Cell[37846, 1378, 218, 8, 65, "Output",
 CellID->819517177]
}, Open  ]],
Cell[38079, 1389, 125, 3, 70, "ExampleDelimiter",
 CellID->233095204],
Cell[38207, 1394, 262, 9, 70, "ExampleText",
 CellID->465348431],
Cell[CellGroupData[{
Cell[38494, 1407, 157, 5, 70, "Input",
 CellID->822108198],
Cell[38654, 1414, 411, 12, 36, "Output",
 CellID->633252062]
}, Open  ]],
Cell[39080, 1429, 142, 6, 70, "ExampleText",
 CellID->615604365],
Cell[39225, 1437, 322, 11, 70, "Input",
 CellID->487184184],
Cell[CellGroupData[{
Cell[39572, 1452, 193, 6, 70, "Input",
 CellID->158111159],
Cell[39768, 1460, 908, 25, 54, "Output",
 CellID->428310582]
}, Open  ]],
Cell[40691, 1488, 124, 3, 70, "ExampleDelimiter",
 CellID->60109159],
Cell[40818, 1493, 221, 8, 70, "ExampleText",
 CellID->314775954],
Cell[CellGroupData[{
Cell[41064, 1505, 169, 5, 70, "Input",
 CellID->156161647],
Cell[41236, 1512, 456, 13, 36, "Output",
 CellID->225054106]
}, Open  ]],
Cell[41707, 1528, 671, 19, 70, "Input",
 CellID->41092370],
Cell[CellGroupData[{
Cell[42403, 1551, 169, 5, 70, "Input",
 CellID->403069092],
Cell[42575, 1558, 363, 11, 36, "Output",
 CellID->91898819]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[42999, 1576, 311, 9, 70, "SeeAlsoSection",
 CellID->11569],
Cell[43313, 1587, 1953, 71, 70, "SeeAlso",
 CellID->304]
}, Open  ]],
Cell[CellGroupData[{
Cell[45303, 1663, 312, 9, 70, "TutorialsSection",
 CellID->603],
Cell[45618, 1674, 179, 4, 70, "Tutorials",
 CellID->31688],
Cell[45800, 1680, 146, 3, 70, "Tutorials",
 CellID->156890304]
}, Open  ]],
Cell[45961, 1686, 27, 0, 70, "History"],
Cell[45991, 1688, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

