(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20348,        679]
NotebookOptionsPosition[     16296,        543]
NotebookOutlinePosition[     17740,        582]
CellTagsIndexPosition[     17655,        577]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Character Codes" :> 
          Documentation`HelpLookup["paclet:tutorial/CharacterCodes"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Character Codes\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"FromCharacterCode" :> 
          Documentation`HelpLookup["paclet:ref/FromCharacterCode"], 
          "Characters" :> Documentation`HelpLookup["paclet:ref/Characters"], 
          "CharacterRange" :> 
          Documentation`HelpLookup["paclet:ref/CharacterRange"], 
          "CharacterEncoding" :> 
          Documentation`HelpLookup["paclet:ref/CharacterEncoding"], 
          "$CharacterEncoding" :> 
          Documentation`HelpLookup["paclet:ref/$CharacterEncoding"], "DigitQ" :> 
          Documentation`HelpLookup["paclet:ref/DigitQ"], "LetterQ" :> 
          Documentation`HelpLookup["paclet:ref/LetterQ"], "InputForm" :> 
          Documentation`HelpLookup["paclet:ref/InputForm"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"FromCharacterCode\"\>", 
       2->"\<\"Characters\"\>", 3->"\<\"CharacterRange\"\>", 
       4->"\<\"CharacterEncoding\"\>", 5->"\<\"$CharacterEncoding\"\>", 
       6->"\<\"DigitQ\"\>", 7->"\<\"LetterQ\"\>", 
       8->"\<\"InputForm\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Atomic Elements of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AtomicElementsOfExpressions"], "Binary Data" :> 
          Documentation`HelpLookup["paclet:guide/BinaryData"], 
          "Character Operations" :> 
          Documentation`HelpLookup["paclet:guide/CharacterOperations"], 
          "Locale & Internationalization" :> 
          Documentation`HelpLookup[
           "paclet:guide/LocaleAndInternationalization"], 
          "Special Characters" :> 
          Documentation`HelpLookup["paclet:guide/SpecialCharacters"], 
          "String Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/StringManipulation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Atomic Elements of Expressions\"\>", 2->"\<\"Binary Data\"\>", 
       3->"\<\"Character Operations\"\>", 
       4->"\<\"Locale & Internationalization\"\>", 
       5->"\<\"Special Characters\"\>", 
       6->"\<\"String Manipulation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ToCharacterCode", "ObjectName",
 CellID->19696],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ToCharacterCode",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ToCharacterCode"], "[", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the integer codes corresponding to the \
characters in a string. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ToCharacterCode",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ToCharacterCode"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"encoding\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives integer codes according to the specified \
encoding. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->14824]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToCharacterCode",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToCharacterCode"]], "InlineFormula"],
 " handles both ordinary and special characters. "
}], "Notes",
 CellID->19683],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ToCharacterCode",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToCharacterCode"], "[", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " returns standard internal character codes used by ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 ", which are the same on all computer systems. "
}], "Notes",
 CellID->31098],

Cell["\<\
For characters on an ordinary American English keyboard, the character codes \
follow the ASCII standard. \
\>", "Notes",
 CellID->10640],

Cell["\<\
For common European languages, they follow the ISO Latin\[Hyphen]1 standard. \
\
\>", "Notes",
 CellID->1131],

Cell["For other characters, they follow the Unicode standard. ", "Notes",
 CellID->19570],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " defines various additional characters in private Unicode space, with \
character codes between 64256 and 64300. "
}], "Notes",
 CellID->23754],

Cell[TextData[{
 "Character codes returned by ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ToCharacterCode",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToCharacterCode"], "[", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " lie between 0 and 65535. "
}], "Notes",
 CellID->23535],

Cell[TextData[{
 "Encodings supported in ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ToCharacterCode",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToCharacterCode"], "[", 
   RowBox[{"\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"encoding\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
 " are listed in the notes for ",
 Cell[BoxData[
  ButtonBox["$CharacterEncoding",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$CharacterEncoding"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->20903],

Cell[TextData[{
 "If a particular character has no character code in a given encoding, ",
 Cell[BoxData[
  ButtonBox["ToCharacterCode",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToCharacterCode"]], "InlineFormula"],
 " returns ",
 Cell[BoxData[
  ButtonBox["None",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/None"]], "InlineFormula"],
 " in place of a character code. "
}], "Notes",
 CellID->19445],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ToCharacterCode",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToCharacterCode"], "[", 
   RowBox[{"{", 
    RowBox[{"\"\<\!\(\*SubscriptBox[
StyleBox[\"s\", \"TI\"], \"1\"]\)\>\"", ",", "\"\<\!\(\*SubscriptBox[
StyleBox[\"s\", \"TI\"], \"2\"]\)\>\"", ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula", 
  "TemplateInclusion"],
 " gives a list of the lists of integer codes for each of the ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["s", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27609]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->275023891],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->149866303],

Cell["Find ASCII or Unicode character codes:", "ExampleText",
 CellID->132],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToCharacterCode", "[", "\"\<abcABC\[Alpha]\[Beta]\[Gamma]\>\"", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6635],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "97", ",", "98", ",", "99", ",", "65", ",", "66", ",", "67", ",", "945", 
   ",", "946", ",", "947"}], "}"}]], "Output",
 ImageSize->{255, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21517]
}, Open  ]],

Cell["Reassemble a string from character codes:", "ExampleText",
 CellID->26645],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FromCharacterCode", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->9321],

Cell[BoxData["\<\"abcABC\[Alpha]\[Beta]\[Gamma]\"\>"], "Output",
 ImageSize->{68, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1818]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->17227],

Cell["\[OpenCurlyDoubleQuote]Plot\[CloseCurlyDoubleQuote] a string:", \
"ExampleText",
 CellID->8835],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"ToCharacterCode", "[", "\"\<this is a string.\>\"", "]"}], ",", 
   RowBox[{"Filling", "->", "Axis"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20577],

Cell[BoxData[
 GraphicsBox[
  GraphicsComplexBox[{{1., 116.}, {2., 104.}, {3., 105.}, {4., 115.}, {5., 
   32.}, {6., 105.}, {7., 115.}, {8., 32.}, {9., 97.}, {10., 32.}, {11., 
   115.}, {12., 116.}, {13., 114.}, {14., 105.}, {15., 110.}, {16., 103.}, {
   17., 46.}, {1., 40.}, {2., 40.}, {3., 40.}, {4., 40.}, {5., 40.}, {6., 
   40.}, {7., 40.}, {8., 40.}, {9., 40.}, {10., 40.}, {11., 40.}, {12., 
   40.}, {13., 40.}, {14., 40.}, {15., 40.}, {16., 40.}, {17., 40.}}, {{
     {GrayLevel[0.5], LineBox[{22, 5}], LineBox[{25, 8}], 
      LineBox[{27, 10}]}, 
     {GrayLevel[0.5], LineBox[{18, 1}], LineBox[{19, 2}], LineBox[{20, 3}], 
      LineBox[{21, 4}], LineBox[{23, 6}], LineBox[{24, 7}], LineBox[{26, 9}], 
      LineBox[{28, 11}], LineBox[{29, 12}], LineBox[{30, 13}], 
      LineBox[{31, 14}], LineBox[{32, 15}], LineBox[{33, 16}], 
      LineBox[{34, 17}]}}, 
    PointBox[{12, 11, 13, 9, 10, 16, 17, 14, 15, 3, 4, 1, 2, 7, 8, 5, 6}]}],
  AspectRatio->GoldenRatio^(-1),
  Axes->True,
  ImageMargins->0.,
  PlotRange->{Automatic, Automatic},
  PlotRangeClipping->True]], "Output",
 ImageSize->{229, 131},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->5675]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25318],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["FromCharacterCode",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FromCharacterCode"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Characters",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Characters"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CharacterRange",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CharacterRange"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CharacterEncoding",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CharacterEncoding"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$CharacterEncoding",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$CharacterEncoding"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DigitQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DigitQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["LetterQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LetterQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["InputForm",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/InputForm"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12432]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->15414],

Cell[TextData[ButtonBox["Character Codes",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CharacterCodes"]], "Tutorials",
 CellID->26032]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->521674137],

Cell[TextData[ButtonBox["Atomic Elements of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AtomicElementsOfExpressions"]], "MoreAbout",
 CellID->714740442],

Cell[TextData[ButtonBox["Binary Data",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/BinaryData"]], "MoreAbout",
 CellID->152182527],

Cell[TextData[ButtonBox["Character Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CharacterOperations"]], "MoreAbout",
 CellID->76720190],

Cell[TextData[ButtonBox["Locale & Internationalization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/LocaleAndInternationalization"]], "MoreAbout",
 CellID->988393442],

Cell[TextData[ButtonBox["Special Characters",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SpecialCharacters"]], "MoreAbout",
 CellID->22613875],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "MoreAbout",
 CellID->171687923]
}, Open  ]],

Cell["New in 2  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ToCharacterCode - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 26, 55.4109080}", "context" -> "System`", 
    "keywords" -> {
     "atoi", "bytes", "\\catcode (TeX)", "conversion", "ToASCII"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ToCharacterCode[\"string\"] gives a list of the integer codes \
corresponding to the characters in a string. ToCharacterCode[\"string\", \" \
encoding\"] gives integer codes according to the specified encoding. ", 
    "synonyms" -> {"to character code"}, "title" -> "ToCharacterCode", "type" -> 
    "Symbol", "uri" -> "ref/ToCharacterCode"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8658, 270, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->275023891]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17512, 570}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3349, 74, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3972, 101, 53, 1, 70, "ObjectName",
 CellID->19696],
Cell[4028, 104, 982, 28, 70, "Usage",
 CellID->14824]
}, Open  ]],
Cell[CellGroupData[{
Cell[5047, 137, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5525, 154, 228, 7, 70, "Notes",
 CellID->19683],
Cell[5756, 163, 407, 12, 70, "Notes",
 CellID->31098],
Cell[6166, 177, 147, 4, 70, "Notes",
 CellID->10640],
Cell[6316, 183, 119, 4, 70, "Notes",
 CellID->1131],
Cell[6438, 189, 89, 1, 70, "Notes",
 CellID->19570],
Cell[6530, 192, 210, 6, 70, "Notes",
 CellID->23754],
Cell[6743, 200, 315, 10, 70, "Notes",
 CellID->23535],
Cell[7061, 212, 529, 17, 70, "Notes",
 CellID->20903],
Cell[7593, 231, 411, 13, 70, "Notes",
 CellID->19445],
Cell[8007, 246, 614, 19, 70, "Notes",
 CellID->27609]
}, Closed]],
Cell[CellGroupData[{
Cell[8658, 270, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->275023891],
Cell[CellGroupData[{
Cell[9043, 284, 148, 5, 70, "ExampleSection",
 CellID->149866303],
Cell[9194, 291, 75, 1, 70, "ExampleText",
 CellID->132],
Cell[CellGroupData[{
Cell[9294, 296, 145, 4, 28, "Input",
 CellID->6635],
Cell[9442, 302, 289, 9, 36, "Output",
 CellID->21517]
}, Open  ]],
Cell[9746, 314, 80, 1, 70, "ExampleText",
 CellID->26645],
Cell[CellGroupData[{
Cell[9851, 319, 108, 3, 28, "Input",
 CellID->9321],
Cell[9962, 324, 189, 5, 36, "Output",
 CellID->1818]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10200, 335, 224, 7, 70, "ExampleSection",
 CellID->17227],
Cell[10427, 344, 101, 2, 70, "ExampleText",
 CellID->8835],
Cell[CellGroupData[{
Cell[10553, 350, 224, 6, 70, "Input",
 CellID->20577],
Cell[10780, 358, 1272, 26, 152, "Output",
 CellID->5675]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12113, 391, 311, 9, 70, "SeeAlsoSection",
 CellID->25318],
Cell[12427, 402, 1989, 71, 70, "SeeAlso",
 CellID->12432]
}, Open  ]],
Cell[CellGroupData[{
Cell[14453, 478, 314, 9, 70, "TutorialsSection",
 CellID->15414],
Cell[14770, 489, 140, 3, 70, "Tutorials",
 CellID->26032]
}, Open  ]],
Cell[CellGroupData[{
Cell[14947, 497, 319, 9, 70, "MoreAboutSection",
 CellID->521674137],
Cell[15269, 508, 169, 3, 70, "MoreAbout",
 CellID->714740442],
Cell[15441, 513, 133, 3, 70, "MoreAbout",
 CellID->152182527],
Cell[15577, 518, 150, 3, 70, "MoreAbout",
 CellID->76720190],
Cell[15730, 523, 170, 3, 70, "MoreAbout",
 CellID->988393442],
Cell[15903, 528, 146, 3, 70, "MoreAbout",
 CellID->22613875],
Cell[16052, 533, 149, 3, 70, "MoreAbout",
 CellID->171687923]
}, Open  ]],
Cell[16216, 539, 50, 0, 70, "History"],
Cell[16269, 541, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

