(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     23594,        838]
NotebookOptionsPosition[     18619,        681]
NotebookOutlinePosition[     20492,        727]
CellTagsIndexPosition[     20407,        722]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Interpretation of Textual Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheInterpretationOfTextualForms"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"The Interpretation of Textual Forms\"\>"}, "\<\"tutorials\"\>",
        
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Symbol" :> Documentation`HelpLookup["paclet:ref/Symbol"], 
          "MakeExpression" :> 
          Documentation`HelpLookup["paclet:ref/MakeExpression"], "ToString" :> 
          Documentation`HelpLookup["paclet:ref/ToString"], "ToBoxes" :> 
          Documentation`HelpLookup["paclet:ref/ToBoxes"], "SyntaxQ" :> 
          Documentation`HelpLookup["paclet:ref/SyntaxQ"], "SyntaxLength" :> 
          Documentation`HelpLookup["paclet:ref/SyntaxLength"], "Read" :> 
          Documentation`HelpLookup["paclet:ref/Read"], "Get" :> 
          Documentation`HelpLookup["paclet:ref/Get"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Symbol\"\>", 2->"\<\"MakeExpression\"\>", 
       3->"\<\"ToString\"\>", 4->"\<\"ToBoxes\"\>", 5->"\<\"SyntaxQ\"\>", 
       6->"\<\"SyntaxLength\"\>", 7->"\<\"Read\"\>", 
       8->"\<\"Get\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Atomic Elements of Expressions" :> 
          Documentation`HelpLookup[
           "paclet:guide/AtomicElementsOfExpressions"], 
          "Character Operations" :> 
          Documentation`HelpLookup["paclet:guide/CharacterOperations"], 
          "Converting between Expressions & Strings" :> 
          Documentation`HelpLookup[
           "paclet:guide/ConvertingBetweenExpressionsAndStrings"], 
          "String Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/StringManipulation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Atomic Elements of Expressions\"\>", 
       2->"\<\"Character Operations\"\>", 
       3->"\<\"Converting between Expressions & Strings\"\>", 
       4->"\<\"String Manipulation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ToExpression", "ObjectName",
 CellID->13139],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ToExpression",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ToExpression"], "[", 
       StyleBox["input", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the expression obtained by interpreting strings \
or boxes as ",
     StyleBox["Mathematica",
      FontSlant->"Italic"],
     " input. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ToExpression",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ToExpression"], "[", 
       RowBox[{
        StyleBox["input", "TI"], ",", 
        StyleBox["form", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]uses interpretation rules corresponding to the \
specified form. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ToExpression",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ToExpression"], "[", 
       RowBox[{
        StyleBox["input", "TI"], ",", 
        StyleBox["form", "TI"], ",", 
        StyleBox["h", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]wraps the head ",
     Cell[BoxData[
      StyleBox["h", "TI"]], "InlineFormula"],
     " around the expression produced before evaluating it. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->6767]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["form", "TI"]], "InlineFormula"],
 " can be ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["TeXForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TeXForm"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["MathMLForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MathMLForm"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->24370],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ToExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToExpression"], "[", "\"\<\!\(\*
StyleBox[\"string\", \"TI\"]\)\>\"", "]"}]], "InlineFormula"],
 " uses ",
 Cell[BoxData[
  ButtonBox["InputForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InputForm"]], "InlineFormula"],
 " interpretation rules. "
}], "Notes",
 CellID->6676],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ToExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToExpression"], "[", 
   StyleBox["boxes", "TI"], "]"}]], "InlineFormula"],
 " uses ",
 Cell[BoxData[
  ButtonBox["StandardForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StandardForm"]], "InlineFormula"],
 " interpretation rules. "
}], "Notes",
 CellID->10143],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToExpression"]], "InlineFormula"],
 " prints a message and returns ",
 Cell[BoxData[
  ButtonBox["$Failed",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$Failed"]], "InlineFormula"],
 " if it finds a syntax error. ",
 Cell[BoxData[
  ButtonBox["ToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToExpression"]], "InlineFormula"],
 " does not call ",
 Cell[BoxData[
  ButtonBox["$SyntaxHandler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$SyntaxHandler"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->40503288]
}], "Notes",
 CellID->30556],

Cell[TextData[{
 "The input given in ",
 Cell[BoxData[
  ButtonBox["ToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToExpression"]], "InlineFormula"],
 " can correspond to multiple ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " expressions. ",
 Cell[BoxData[
  ButtonBox["ToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToExpression"]], "InlineFormula"],
 " processes each one in turn, just like ",
 Cell[BoxData[
  ButtonBox["Get",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Get"]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->260937732]
}], "Notes",
 CellID->17973],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ToExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToExpression"], "[", 
   RowBox[{
    StyleBox["input", "TI"], ",", 
    StyleBox["form", "TI"], ",", 
    ButtonBox["Hold",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Hold"]}], "]"}]], "InlineFormula"],
 " can be used to convert input to an expression, but with the expression \
wrapped in ",
 Cell[BoxData[
  ButtonBox["Hold",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Hold"]], "InlineFormula"],
 " to prevent evaluation. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->803184677]
}], "Notes",
 CellID->27116],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToExpression"]], "InlineFormula"],
 " uses any relevant definitions given for ",
 Cell[BoxData[
  ButtonBox["MakeExpression",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/MakeExpression"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->11957]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->766061783],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(5)", "ExampleCount"]
}], "ExampleSection",
 CellID->416482800],

Cell["\<\
Convert a string to an expression, and evaluate the expression:\
\>", "ExampleText",
 CellID->11261],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", "\"\<1+1\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->12809],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->302603679]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23586],

Cell[TextData[{
 "Interpret a ",
 Cell[BoxData[
  ButtonBox["TraditionalForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraditionalForm"]], "InlineFormula"],
 " string:"
}], "ExampleText",
 CellID->17327],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", 
  RowBox[{"\"\<sin(x)\>\"", ",", "TraditionalForm"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28441],

Cell[BoxData[
 RowBox[{"Sin", "[", "x", "]"}]], "Output",
 ImageSize->{46, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->233129315]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->199933150],

Cell[TextData[{
 "Convert boxes to ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " input:"
}], "ExampleText",
 CellID->159896553],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", 
  RowBox[{"RowBox", "[", 
   RowBox[{"{", 
    RowBox[{"\"\<{\>\"", ",", 
     RowBox[{"RowBox", "[", 
      RowBox[{"{", 
       RowBox[{"\"\<a\>\"", ",", "\"\<,\>\"", ",", "\"\<b\>\""}], "}"}], 
      "]"}], ",", "\"\<}\>\""}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->465797142],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->127784588]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->370840631],

Cell["Convert MathML strings to expressions: ", "ExampleText",
 CellID->154295312],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", 
  RowBox[{
  "\"\<<math><msup><mi>x</mi><mn>2</mn></msup></math>\>\"", ",", 
   "MathMLForm"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21493828],

Cell[BoxData[
 SuperscriptBox["x", "2"]], "Output",
 ImageSize->{17, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->330198324]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->242922904],

Cell[TextData[{
 "Convert ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{"T", 
     AdjustmentBox["E",
      BoxBaselineShift->0.5,
      BoxMargins->{{-0.3, 0}, {0, 0}}], "X"}], "TR",
    SingleLetterItalics->False], TraditionalForm]], "InlineFormula"],
 " strings to expressions: "
}], "ExampleText",
 CellID->49063069],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToExpression", "[", 
  RowBox[{
   TagBox[
    StyleBox["\"\<\\\\frac{x}{\\\\sqrt{5}}\>\"",
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", "TeXForm"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->706051258],

Cell[BoxData[
 FractionBox["x", 
  SqrtBox["5"]]], "Output",
 ImageSize->{32, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->945507712]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30672],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Symbol",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Symbol"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MakeExpression",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MakeExpression"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToString",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToString"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToBoxes",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToBoxes"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SyntaxQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SyntaxQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SyntaxLength",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SyntaxLength"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Read",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Read"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Get",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Get"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19814]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28286],

Cell[TextData[ButtonBox["The Interpretation of Textual Forms",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TheInterpretationOfTextualForms"]], "Tutorials",\

 CellID->27366]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->185023962],

Cell[TextData[ButtonBox["Atomic Elements of Expressions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AtomicElementsOfExpressions"]], "MoreAbout",
 CellID->293623682],

Cell[TextData[ButtonBox["Character Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CharacterOperations"]], "MoreAbout",
 CellID->427599946],

Cell[TextData[ButtonBox["Converting between Expressions & Strings",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ConvertingBetweenExpressionsAndStrings"]], "MoreAbout",
 CellID->387882931],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "MoreAbout",
 CellID->138105162]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["NKS|Online",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/index/search.cgi?SearchIndex=\
ToExpression"], None}],
 " (",
 StyleBox[ButtonBox["A New Kind of Science",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://www.wolframscience.com/nksonline/"], None}],
  FontSlant->"Italic"],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell["New in 1  |  Last modified in 5.1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ToExpression - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 26, 56.6453146}", "context" -> "System`", 
    "keywords" -> {
     "conversion", "expressions", "held expressions", "input as string", 
      "interpretation of input", "parsing of strings", 
      "using strings as input", "parsing MathML", "parsing TeX", 
      "parsing LaTeX", "parsing boxes", "interpreting MathML", 
      "interpreting TeX", "interpreting LaTeX", "interpreting boxes", 
      "converting MathML", "converting TeX", "converting LaTeX", 
      "converting boxes"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ToExpression[input] gives the expression obtained by interpreting \
strings or boxes as Mathematica input. ToExpression[input, form] uses \
interpretation rules corresponding to the specified form. ToExpression[input, \
form, h] wraps the head h around the expression produced before evaluating \
it. ", "synonyms" -> {"to expression"}, "title" -> "ToExpression", "type" -> 
    "Symbol", "uri" -> "ref/ToExpression"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9787, 325, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->766061783]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20264, 715}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3050, 68, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3673, 95, 50, 1, 70, "ObjectName",
 CellID->13139],
Cell[3726, 98, 1492, 46, 70, "Usage",
 CellID->6767]
}, Open  ]],
Cell[CellGroupData[{
Cell[5255, 149, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5733, 166, 774, 30, 70, "Notes",
 CellID->24370],
Cell[6510, 198, 404, 14, 70, "Notes",
 CellID->6676],
Cell[6917, 214, 391, 14, 70, "Notes",
 CellID->10143],
Cell[7311, 230, 727, 25, 70, "Notes",
 CellID->30556],
Cell[8041, 257, 669, 24, 70, "Notes",
 CellID->17973],
Cell[8713, 283, 680, 23, 70, "Notes",
 CellID->27116],
Cell[9396, 308, 354, 12, 70, "Notes",
 CellID->11957]
}, Closed]],
Cell[CellGroupData[{
Cell[9787, 325, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->766061783],
Cell[CellGroupData[{
Cell[10172, 339, 148, 5, 70, "ExampleSection",
 CellID->416482800],
Cell[10323, 346, 110, 3, 70, "ExampleText",
 CellID->11261],
Cell[CellGroupData[{
Cell[10458, 353, 114, 3, 28, "Input",
 CellID->12809],
Cell[10575, 358, 158, 5, 36, "Output",
 CellID->302603679]
}, Open  ]],
Cell[10748, 366, 121, 3, 70, "ExampleDelimiter",
 CellID->23586],
Cell[10872, 371, 212, 8, 70, "ExampleText",
 CellID->17327],
Cell[CellGroupData[{
Cell[11109, 383, 154, 4, 70, "Input",
 CellID->28441],
Cell[11266, 389, 187, 6, 36, "Output",
 CellID->233129315]
}, Open  ]],
Cell[11468, 398, 125, 3, 70, "ExampleDelimiter",
 CellID->199933150],
Cell[11596, 403, 136, 6, 70, "ExampleText",
 CellID->159896553],
Cell[CellGroupData[{
Cell[11757, 413, 348, 10, 70, "Input",
 CellID->465797142],
Cell[12108, 425, 203, 7, 36, "Output",
 CellID->127784588]
}, Open  ]],
Cell[12326, 435, 125, 3, 70, "ExampleDelimiter",
 CellID->370840631],
Cell[12454, 440, 82, 1, 70, "ExampleText",
 CellID->154295312],
Cell[CellGroupData[{
Cell[12561, 445, 199, 6, 70, "Input",
 CellID->21493828],
Cell[12763, 453, 181, 6, 36, "Output",
 CellID->330198324]
}, Open  ]],
Cell[12959, 462, 125, 3, 70, "ExampleDelimiter",
 CellID->242922904],
Cell[13087, 467, 328, 12, 70, "ExampleText",
 CellID->49063069],
Cell[CellGroupData[{
Cell[13440, 483, 301, 10, 70, "Input",
 CellID->706051258],
Cell[13744, 495, 190, 7, 53, "Output",
 CellID->945507712]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13995, 509, 311, 9, 70, "SeeAlsoSection",
 CellID->30672],
Cell[14309, 520, 1915, 71, 70, "SeeAlso",
 CellID->19814]
}, Open  ]],
Cell[CellGroupData[{
Cell[16261, 596, 314, 9, 70, "TutorialsSection",
 CellID->28286],
Cell[16578, 607, 179, 4, 70, "Tutorials",
 CellID->27366]
}, Open  ]],
Cell[CellGroupData[{
Cell[16794, 616, 319, 9, 70, "MoreAboutSection",
 CellID->185023962],
Cell[17116, 627, 169, 3, 70, "MoreAbout",
 CellID->293623682],
Cell[17288, 632, 151, 3, 70, "MoreAbout",
 CellID->427599946],
Cell[17442, 637, 193, 4, 70, "MoreAbout",
 CellID->387882931],
Cell[17638, 643, 149, 3, 70, "MoreAbout",
 CellID->138105162]
}, Open  ]],
Cell[CellGroupData[{
Cell[17824, 651, 305, 8, 70, "RelatedLinksSection"],
Cell[18132, 661, 390, 13, 70, "RelatedLinks"]
}, Open  ]],
Cell[18537, 677, 52, 0, 70, "History"],
Cell[18592, 679, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

