(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13288,        454]
NotebookOptionsPosition[     10216,        357]
NotebookOutlinePosition[     11748,        397]
CellTagsIndexPosition[     11663,        392]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Naming and Finding Files" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/NamingAndFindingFiles"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Naming and Finding Files\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DirectoryName" :> 
          Documentation`HelpLookup["paclet:ref/DirectoryName"], "Get" :> 
          Documentation`HelpLookup["paclet:ref/Get"], "$Input" :> 
          Documentation`HelpLookup["paclet:ref/$Input"], "$PathnameSeparator" :> 
          Documentation`HelpLookup["paclet:ref/$PathnameSeparator"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"DirectoryName\"\>", 
       2->"\<\"Get\"\>", 3->"\<\"$Input\"\>", 
       4->"\<\"$PathnameSeparator\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Directories & Directory Operations" :> 
          Documentation`HelpLookup[
           "paclet:guide/DirectoriesAndDirectoryOperations"], 
          "File Operations" :> 
          Documentation`HelpLookup["paclet:guide/FileOperations"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Directories & Directory Operations\"\>", 
       2->"\<\"File Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ToFileName", "ObjectName",
 CellID->25465],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ToFileName",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ToFileName"], "[", 
       RowBox[{"\"\<\!\(\*
StyleBox[\"directory\", \"TI\"]\)\>\"", ",", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
     "\[LineSeparator]assembles a full file name from a directory name and a \
file name. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ToFileName",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ToFileName"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["dir", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["dir", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["name", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]assembles a full file name from a hierarchy of \
directory names. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ToFileName",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ToFileName"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["dir", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["dir", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]assembles a single directory name from a hierarchy of \
directory names. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->26605]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToFileName",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToFileName"]], "InlineFormula"],
 " works differently on different computer systems. "
}], "Notes",
 CellID->26806],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToFileName",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToFileName"]], "InlineFormula"],
 " just creates a file name; it does not actually search for the file \
specified. "
}], "Notes",
 CellID->17438],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ToFileName",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToFileName"], "[", 
   RowBox[{"\"\<\>\"", ",", "\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\""}], "]"}]], "InlineFormula"],
 " gives ",
 Cell[BoxData["\"\<\!\(\*
StyleBox[\"name\", \"TI\"]\)\>\""], "InlineFormula"],
 ". "
}], "Notes",
 CellID->16396],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToFileName",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToFileName"]], "InlineFormula"],
 " uses the current setting for ",
 Cell[BoxData[
  ButtonBox["$PathnameSeparator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/$PathnameSeparator"]], "InlineFormula"],
 " to separate elements of the file name."
}], "Notes",
 CellID->180146483]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->345537668],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->839782372],

Cell["Provide operating system dependent file name:", "ExampleText",
 CellID->259372003],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToFileName", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\"\<dir1\>\"", ",", "\"\<dir2\>\""}], "}"}], ",", 
   "\"\<file\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->554812200],

Cell[BoxData["\<\"dir1\\\\dir2\\\\file\"\>"], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->83294487]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17015],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DirectoryName",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DirectoryName"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Get",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Get"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$Input",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$Input"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$PathnameSeparator",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/$PathnameSeparator"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22893]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27518],

Cell[TextData[ButtonBox["Naming and Finding Files",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/NamingAndFindingFiles"]], "Tutorials",
 CellID->28262]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->570623712],

Cell[TextData[ButtonBox["Directories & Directory Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DirectoriesAndDirectoryOperations"]], "MoreAbout",
 CellID->336729540],

Cell[TextData[ButtonBox["File Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FileOperations"]], "MoreAbout",
 CellID->93272081]
}, Open  ]],

Cell["New in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ToFileName - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 26, 56.9890734}", "context" -> "System`", 
    "keywords" -> {
     "convert to file name", "file name", "file name parts", "file path"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ToFileName[\"directory\", \" name\"] assembles a full file name from a \
directory name and a file name. ToFileName[{dir_1, dir_2, ...}, name] \
assembles a full file name from a hierarchy of directory names. \
ToFileName[{dir_1, dir_2, ...}] assembles a single directory name from a \
hierarchy of directory names. ", "synonyms" -> {"to file name"}, "title" -> 
    "ToFileName", "type" -> "Symbol", "uri" -> "ref/ToFileName"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6569, 214, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->345537668]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11520, 385}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2271, 55, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2894, 82, 48, 1, 70, "ObjectName",
 CellID->25465],
Cell[2945, 85, 1833, 56, 70, "Usage",
 CellID->26605]
}, Open  ]],
Cell[CellGroupData[{
Cell[4815, 146, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5293, 163, 221, 7, 70, "Notes",
 CellID->26806],
Cell[5517, 172, 252, 8, 70, "Notes",
 CellID->17438],
Cell[5772, 182, 369, 13, 70, "Notes",
 CellID->16396],
Cell[6144, 197, 388, 12, 70, "Notes",
 CellID->180146483]
}, Closed]],
Cell[CellGroupData[{
Cell[6569, 214, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->345537668],
Cell[CellGroupData[{
Cell[6954, 228, 148, 5, 70, "ExampleSection",
 CellID->839782372],
Cell[7105, 235, 88, 1, 70, "ExampleText",
 CellID->259372003],
Cell[CellGroupData[{
Cell[7218, 240, 215, 7, 28, "Input",
 CellID->554812200],
Cell[7436, 249, 185, 5, 36, "Output",
 CellID->83294487]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7682, 261, 311, 9, 70, "SeeAlsoSection",
 CellID->17015],
Cell[7996, 272, 957, 35, 70, "SeeAlso",
 CellID->22893]
}, Open  ]],
Cell[CellGroupData[{
Cell[8990, 312, 314, 9, 70, "TutorialsSection",
 CellID->27518],
Cell[9307, 323, 156, 3, 70, "Tutorials",
 CellID->28262]
}, Open  ]],
Cell[CellGroupData[{
Cell[9500, 331, 319, 9, 70, "MoreAboutSection",
 CellID->570623712],
Cell[9822, 342, 179, 3, 70, "MoreAbout",
 CellID->336729540],
Cell[10004, 347, 140, 3, 70, "MoreAbout",
 CellID->93272081]
}, Open  ]],
Cell[10159, 353, 27, 0, 70, "History"],
Cell[10189, 355, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

