(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19541,        737]
NotebookOptionsPosition[     14663,        564]
NotebookOutlinePosition[     15958,        600]
CellTagsIndexPosition[     15873,        595]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Characters in Strings" :> 
          Documentation`HelpLookup["paclet:tutorial/CharactersInStrings"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Characters in Strings\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"LowerCaseQ" :> 
          Documentation`HelpLookup["paclet:ref/LowerCaseQ"], "ToUpperCase" :> 
          Documentation`HelpLookup["paclet:ref/ToUpperCase"], "StringReplace" :> 
          Documentation`HelpLookup["paclet:ref/StringReplace"], "IgnoreCase" :> 
          Documentation`HelpLookup["paclet:ref/IgnoreCase"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"LowerCaseQ\"\>", 
       2->"\<\"ToUpperCase\"\>", 3->"\<\"StringReplace\"\>", 
       4->"\<\"IgnoreCase\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Character Operations" :> 
          Documentation`HelpLookup["paclet:guide/CharacterOperations"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Character Operations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ToLowerCase", "ObjectName",
 CellID->18534],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ToLowerCase",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ToLowerCase"], "[", 
       StyleBox["string", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields a string in which all letters have been \
converted to lowercase. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29831]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToLowerCase",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToLowerCase"]], "InlineFormula"],
 " handles both ordinary and special characters. "
}], "Notes",
 CellID->3637],

Cell[TextData[{
 "The variant uppercase character ",
 Cell[TextData[ButtonBox["\\[CurlyCapitalUpsilon]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CurlyCapitalUpsilon"]], 
  "InlineCharacterName"],
 " is converted to its non\[Hyphen]variant lowercase form. "
}], "Notes",
 CellID->14694]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->696789685],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->255696782],

Cell["Convert characters in a string to lowercase:", "ExampleText",
 CellID->31041],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToLowerCase", "[", "\"\<ABCD\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->606],

Cell[BoxData["\<\"abcd\"\>"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10411]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14737],

Cell["Everything other than uppercase letters is left unchanged:", \
"ExampleText",
 CellID->28102],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToLowerCase", "[", "\"\<ABC xyz 123\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->4015],

Cell[BoxData["\<\"abc xyz 123\"\>"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->13063]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8117],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToLowerCase",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToLowerCase"]], "InlineFormula"],
 " threads itself element-wise over lists:"
}], "ExampleText",
 CellID->16317],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToLowerCase", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<A\>\"", ",", "\"\<B\>\"", ",", "\"\<C\>\""}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11999],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"a\"\>", ",", "\<\"b\"\>", ",", "\<\"c\"\>"}], "}"}]], "Output",\

 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->12151]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20643],

Cell["Accented characters:", "ExampleText",
 CellID->7538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToLowerCase", "[", "\"\<\[CapitalADoubleDot]\[CapitalEAcute]\>\"", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->6782],

Cell[BoxData["\<\"\[ADoubleDot]\[EAcute]\"\>"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23454]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1887],

Cell["Greek letters:", "ExampleText",
 CellID->12012],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToLowerCase", "[", 
  "\"\<\[CapitalAlpha]\[CapitalBeta]\[CapitalGamma]\[CapitalDelta]\
\[CapitalEpsilon]\[CapitalZeta]\[CapitalEta]\[CapitalTheta]\>\"", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3912],

Cell[BoxData["\<\"\[Alpha]\[Beta]\[Gamma]\[Delta]\[Epsilon]\[Zeta]\[Eta]\
\[Theta]\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->8922]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->23837],

Cell["Script letters:", "ExampleText",
 CellID->22174],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToLowerCase", "[", 
  "\"\<\[ScriptCapitalA]\[ScriptCapitalB]\[ScriptCapitalC]\[ScriptCapitalD]\>\
\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7091],

Cell[BoxData["\<\"\[ScriptA]\[ScriptB]\[ScriptC]\[ScriptD]\"\>"], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->30808]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->25852],

Cell[TextData[{
 "For the character \[CurlyCapitalUpsilon], ",
 Cell[BoxData[
  ButtonBox["ToUpperCase",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToUpperCase"]], "InlineFormula"],
 " is not the inverse of ",
 Cell[BoxData[
  ButtonBox["ToLowerCase",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToLowerCase"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->11211],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToUpperCase", "[", 
  RowBox[{"ToLowerCase", "[", "\"\<\[CurlyCapitalUpsilon]\>\"", "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->28230],

Cell[BoxData["\<\"\[CapitalUpsilon]\"\>"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16589]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8001],

Cell[BoxData[
 TagBox[
  StyleBox["\"\<\\[CapitalUpsilon]\>\"",
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 ImageSize->{137, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//FullForm=",
 CellID->22015]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->4728],

Cell[TextData[{
 "Check that \[CurlyCapitalUpsilon] is the only character for which ",
 Cell[BoxData[
  ButtonBox["ToUpperCase",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToUpperCase"]], "InlineFormula"],
 " is not the inverse of ",
 Cell[BoxData[
  ButtonBox["ToLowerCase",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToLowerCase"]], "InlineFormula"],
 ": "
}], "ExampleText",
 CellID->3029],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"Characters", "[", 
    RowBox[{"FromCharacterCode", "[", 
     RowBox[{"Range", "[", 
      RowBox[{
       RowBox[{"2", "^", "16"}], "-", "1"}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"UpperCaseQ", "[", "#", "]"}], "&&", 
     RowBox[{
      RowBox[{"ToUpperCase", "[", 
       RowBox[{"ToLowerCase", "[", "#", "]"}], "]"}], "=!=", "#"}]}], "&"}]}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9921],

Cell[BoxData[
 RowBox[{"{", "\<\"\[CurlyCapitalUpsilon]\"\>", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->315895692]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2269],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["LowerCaseQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/LowerCaseQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToUpperCase",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToUpperCase"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringReplace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringReplace"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IgnoreCase",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IgnoreCase"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->3834]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6102],

Cell[TextData[ButtonBox["Characters in Strings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CharactersInStrings"]], "Tutorials",
 CellID->17011]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with ToLowerCase",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=ToLowerCase"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->55246119],

Cell[TextData[ButtonBox["Character Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CharacterOperations"]], "MoreAbout",
 CellID->654352765]
}, Open  ]],

Cell["New in 2  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ToLowerCase - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 6.1455578}", "context" -> "System`", 
    "keywords" -> {"conversion to lower case", "lc", "lowercase", "tolower"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ToLowerCase[string] yields a string in which all letters have been \
converted to lowercase. ", "synonyms" -> {"to lower case"}, "title" -> 
    "ToLowerCase", "type" -> "Symbol", "uri" -> "ref/ToLowerCase"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4350, 140, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->696789685]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 15730, 588}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2073, 50, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2696, 77, 49, 1, 70, "ObjectName",
 CellID->18534],
Cell[2748, 80, 526, 16, 70, "Usage",
 CellID->29831]
}, Open  ]],
Cell[CellGroupData[{
Cell[3311, 101, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3789, 118, 219, 7, 70, "Notes",
 CellID->3637],
Cell[4011, 127, 302, 8, 70, "Notes",
 CellID->14694]
}, Closed]],
Cell[CellGroupData[{
Cell[4350, 140, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->696789685],
Cell[CellGroupData[{
Cell[4735, 154, 148, 5, 70, "ExampleSection",
 CellID->255696782],
Cell[4886, 161, 83, 1, 70, "ExampleText",
 CellID->31041],
Cell[CellGroupData[{
Cell[4994, 166, 112, 3, 28, "Input",
 CellID->606],
Cell[5109, 171, 165, 5, 36, "Output",
 CellID->10411]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5323, 182, 216, 7, 70, "ExampleSection",
 CellID->14737],
Cell[5542, 191, 99, 2, 70, "ExampleText",
 CellID->28102],
Cell[CellGroupData[{
Cell[5666, 197, 120, 3, 70, "Input",
 CellID->4015],
Cell[5789, 202, 172, 5, 36, "Output",
 CellID->13063]
}, Open  ]],
Cell[5976, 210, 120, 3, 70, "ExampleDelimiter",
 CellID->8117],
Cell[6099, 215, 219, 7, 70, "ExampleText",
 CellID->16317],
Cell[CellGroupData[{
Cell[6343, 226, 187, 6, 70, "Input",
 CellID->11999],
Cell[6533, 234, 235, 8, 36, "Output",
 CellID->12151]
}, Open  ]],
Cell[6783, 245, 121, 3, 70, "ExampleDelimiter",
 CellID->20643],
Cell[6907, 250, 58, 1, 70, "ExampleText",
 CellID->7538],
Cell[CellGroupData[{
Cell[6990, 255, 148, 4, 70, "Input",
 CellID->6782],
Cell[7141, 261, 183, 5, 36, "Output",
 CellID->23454]
}, Open  ]],
Cell[7339, 269, 120, 3, 70, "ExampleDelimiter",
 CellID->1887],
Cell[7462, 274, 53, 1, 70, "ExampleText",
 CellID->12012],
Cell[CellGroupData[{
Cell[7540, 279, 235, 6, 70, "Input",
 CellID->3912],
Cell[7778, 287, 224, 6, 36, "Output",
 CellID->8922]
}, Open  ]],
Cell[8017, 296, 121, 3, 70, "ExampleDelimiter",
 CellID->23837],
Cell[8141, 301, 54, 1, 70, "ExampleText",
 CellID->22174],
Cell[CellGroupData[{
Cell[8220, 306, 182, 5, 70, "Input",
 CellID->7091],
Cell[8405, 313, 201, 5, 36, "Output",
 CellID->30808]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8655, 324, 226, 7, 70, "ExampleSection",
 CellID->25852],
Cell[8884, 333, 380, 13, 70, "ExampleText",
 CellID->11211],
Cell[CellGroupData[{
Cell[9289, 350, 173, 5, 70, "Input",
 CellID->28230],
Cell[9465, 357, 178, 5, 36, "Output",
 CellID->16589]
}, Open  ]],
Cell[CellGroupData[{
Cell[9680, 367, 99, 3, 70, "Input",
 CellID->8001],
Cell[9782, 372, 311, 11, 50, "Output",
 CellID->22015]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10142, 389, 223, 7, 70, "ExampleSection",
 CellID->4728],
Cell[10368, 398, 404, 13, 70, "ExampleText",
 CellID->3029],
Cell[CellGroupData[{
Cell[10797, 415, 496, 16, 70, "Input",
 CellID->9921],
Cell[11296, 433, 209, 6, 36, "Output",
 CellID->315895692]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11566, 446, 310, 9, 70, "SeeAlsoSection",
 CellID->2269],
Cell[11879, 457, 964, 35, 70, "SeeAlso",
 CellID->3834]
}, Open  ]],
Cell[CellGroupData[{
Cell[12880, 497, 313, 9, 70, "TutorialsSection",
 CellID->6102],
Cell[13196, 508, 151, 3, 70, "Tutorials",
 CellID->17011]
}, Open  ]],
Cell[CellGroupData[{
Cell[13384, 516, 305, 8, 70, "RelatedLinksSection"],
Cell[13692, 526, 367, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14096, 543, 318, 9, 70, "MoreAboutSection",
 CellID->55246119],
Cell[14417, 554, 151, 3, 70, "MoreAbout",
 CellID->654352765]
}, Open  ]],
Cell[14583, 560, 50, 0, 70, "History"],
Cell[14636, 562, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

