(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     58224,       2114]
NotebookOptionsPosition[     50092,       1831]
NotebookOutlinePosition[     51395,       1868]
CellTagsIndexPosition[     51309,       1863]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Numbers" :> 
          Documentation`HelpLookup["paclet:tutorial/AlgebraicNumbers"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Algebraic Numbers\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Solve" :> Documentation`HelpLookup["paclet:ref/Solve"], 
          "NSolve" :> Documentation`HelpLookup["paclet:ref/NSolve"], "Root" :> 
          Documentation`HelpLookup["paclet:ref/Root"], "RootReduce" :> 
          Documentation`HelpLookup["paclet:ref/RootReduce"], "Roots" :> 
          Documentation`HelpLookup["paclet:ref/Roots"], "ToNumberField" :> 
          Documentation`HelpLookup["paclet:ref/ToNumberField"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Solve\"\>", 2->"\<\"NSolve\"\>", 
       3->"\<\"Root\"\>", 4->"\<\"RootReduce\"\>", 5->"\<\"Roots\"\>", 
       6->"\<\"ToNumberField\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Numbers" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicNumbers"], 
          "Algebraic Number Theory" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicNumberTheory"], 
          "Algebraic Transformations" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicTransformations"], 
          "Number Recognition" :> 
          Documentation`HelpLookup["paclet:guide/NumberRecognition"], 
          "Polynomial Algebra" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialAlgebra"], 
          "Polynomial Equations" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialEquations"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Algebraic Numbers\"\>", 
       2->"\<\"Algebraic Number Theory\"\>", 
       3->"\<\"Algebraic Transformations\"\>", 
       4->"\<\"Number Recognition\"\>", 5->"\<\"Polynomial Algebra\"\>", 
       6->"\<\"Polynomial Equations\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["ToRadicals", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ToRadicals",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ToRadicals"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]attempts to express all ",
     Cell[BoxData[
      ButtonBox["Root",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Root"]], "InlineFormula"],
     " objects in ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " in terms of radicals. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17691]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToRadicals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToRadicals"]], "InlineFormula"],
 " can always give expressions in terms of radicals when the highest degree \
of the polynomial that appears in any ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " object is four. "
}], "Notes",
 CellID->26706],

Cell[TextData[{
 "There are some cases in which expressions involving radicals can in \
principle be given, but ",
 Cell[BoxData[
  ButtonBox["ToRadicals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToRadicals"]], "InlineFormula"],
 " cannot find them. "
}], "Notes",
 CellID->28826],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " contain parameters, ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ToRadicals",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToRadicals"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " may yield a result that is not equal to ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " for all values of the parameters. "
}], "Notes",
 CellID->26216],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToRadicals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToRadicals"]], "InlineFormula"],
 " automatically threads over lists, as well as equations, inequalities and \
logic functions."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->82730543]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->337157260],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->350100512],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToRadicals", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "3"}], "+", "#", "+", "11"}], "&"}], ",", "1"}], 
    "]"}], "+", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "5"}], "-", "2"}], "&"}], ",", "3"}], "]"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->424304078],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", "1"}], ")"}], 
    RowBox[{"4", "/", "5"}]], " ", 
   SuperscriptBox["2", 
    RowBox[{"1", "/", "5"}]]}], "-", 
  SuperscriptBox[
   RowBox[{"(", 
    FractionBox["2", 
     RowBox[{"3", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "99"}], "+", 
        SqrtBox["9813"]}], ")"}]}]], ")"}], 
   RowBox[{"1", "/", "3"}]], "+", 
  FractionBox[
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "99"}], "+", 
        SqrtBox["9813"]}], ")"}]}], ")"}], 
    RowBox[{"1", "/", "3"}]], 
   SuperscriptBox["3", 
    RowBox[{"2", "/", "3"}]]]}]], "Output",
 ImageSize->{376, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->255583061]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->16791],

Cell[TextData[{
 "All cubic ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects can be converted into radicals:"
}], "ExampleText",
 CellID->151149825],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToRadicals", "[", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"#", "^", "3"}], "-", 
      RowBox[{"5", 
       RowBox[{"#", "^", "2"}]}], "-", 
      RowBox[{"7", "#"}], "+", "9"}], "&"}], ",", "1"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->43014127],

Cell[BoxData[
 RowBox[{
  FractionBox["5", "3"], "-", 
  FractionBox[
   RowBox[{
    SuperscriptBox["23", 
     RowBox[{"2", "/", "3"}]], " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["3"]}]}], ")"}]}], 
   RowBox[{"3", " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"7", "+", 
       RowBox[{"3", " ", "\[ImaginaryI]", " ", 
        SqrtBox["15"]}]}], ")"}], 
     RowBox[{"1", "/", "3"}]]}]], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"\[ImaginaryI]", " ", 
      SqrtBox["3"]}]}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"23", " ", 
      RowBox[{"(", 
       RowBox[{"7", "+", 
        RowBox[{"3", " ", "\[ImaginaryI]", " ", 
         SqrtBox["15"]}]}], ")"}]}], ")"}], 
    RowBox[{"1", "/", "3"}]]}]}]], "Output",
 ImageSize->{374, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->102647576]
}, Open  ]],

Cell[TextData[{
 "All quartic ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects can be converted into radicals:"
}], "ExampleText",
 CellID->9517185],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToRadicals", "[", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"#", "^", "4"}], "+", 
      RowBox[{"3", 
       RowBox[{"#", "^", "3"}]}], "-", 
      RowBox[{"5", 
       RowBox[{"#", "^", "2"}]}], "-", 
      RowBox[{"7", "#"}], "+", "9"}], "&"}], ",", "1"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->205945966],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox["3", "4"]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", 
   SqrtBox[
    RowBox[{
     FractionBox["67", "12"], "+", 
     RowBox[{
      FractionBox["1", "3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         FractionBox["5555", "2"], "-", 
         FractionBox[
          RowBox[{"3", " ", 
           SqrtBox["82209"]}], "2"]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}], "+", 
     RowBox[{
      FractionBox["1", "3"], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{"5555", "+", 
           RowBox[{"3", " ", 
            SqrtBox["82209"]}]}], ")"}]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}]}]]}], "-", 
  RowBox[{
   FractionBox["1", "4"], " ", 
   RowBox[{"\[Sqrt]", 
    RowBox[{"(", 
     RowBox[{
      FractionBox["1", "3"], " ", 
      RowBox[{"(", 
       RowBox[{"134", "-", 
        RowBox[{"4", " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            FractionBox["5555", "2"], "-", 
            FractionBox[
             RowBox[{"3", " ", 
              SqrtBox["82209"]}], "2"]}], ")"}], 
          RowBox[{"1", "/", "3"}]]}], "-", 
        RowBox[{"2", " ", 
         SuperscriptBox["2", 
          RowBox[{"2", "/", "3"}]], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"5555", "+", 
            RowBox[{"3", " ", 
             SqrtBox["82209"]}]}], ")"}], 
          RowBox[{"1", "/", "3"}]]}], "+", 
        FractionBox["93", 
         SqrtBox[
          RowBox[{
           FractionBox["67", "12"], "+", 
           RowBox[{
            FractionBox["1", "3"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               FractionBox["5555", "2"], "-", 
               FractionBox[
                RowBox[{"3", " ", 
                 SqrtBox["82209"]}], "2"]}], ")"}], 
             RowBox[{"1", "/", "3"}]]}], "+", 
           RowBox[{
            FractionBox["1", "3"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{
               FractionBox["1", "2"], " ", 
               RowBox[{"(", 
                RowBox[{"5555", "+", 
                 RowBox[{"3", " ", 
                  SqrtBox["82209"]}]}], ")"}]}], ")"}], 
             RowBox[{"1", "/", "3"}]]}]}]]]}], ")"}]}], ")"}]}]}]}]], "Output",\

 ImageSize->{455, 266},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->232668601]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->197357319],

Cell[TextData[{
 "Some higher\[Hyphen]degree ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects can be represented in terms of radicals:"
}], "ExampleText",
 CellID->210840089],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToRadicals", "[", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"#", "^", "8"}], "-", 
      RowBox[{"4", 
       RowBox[{"#", "^", "7"}]}], "+", 
      RowBox[{"14", 
       RowBox[{"#", "^", "6"}]}], "-", 
      RowBox[{"28", 
       RowBox[{"#", "^", "5"}]}], "+", 
      RowBox[{"82", 
       RowBox[{"#", "^", "4"}]}], "-", 
      RowBox[{"122", 
       RowBox[{"#", "^", "3"}]}], "+", 
      RowBox[{"221", 
       RowBox[{"#", "^", "2"}]}], "-", 
      RowBox[{"164", "#"}], "+", "399"}], "&"}], ",", "1"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->536763697],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "2"], " ", 
  RowBox[{"(", 
   RowBox[{"1", "-", 
    SqrtBox[
     RowBox[{
      RowBox[{"-", "7"}], "+", 
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SqrtBox[
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{"33", "+", 
           SqrtBox["85"]}], ")"}]}]]}]}]]}], ")"}]}]], "Output",
 ImageSize->{221, 59},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7339004]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{"Cyclotomic", "[", 
    RowBox[{"102", ",", "x"}], "]"}], ",", "x", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->757170322],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "+", "#1", "-", 
     SuperscriptBox["#1", "3"], "-", 
     SuperscriptBox["#1", "4"], "+", 
     SuperscriptBox["#1", "6"], "+", 
     SuperscriptBox["#1", "7"], "-", 
     SuperscriptBox["#1", "9"], "-", 
     SuperscriptBox["#1", "10"], "+", 
     SuperscriptBox["#1", "12"], "+", 
     SuperscriptBox["#1", "13"], "-", 
     SuperscriptBox["#1", "15"], "-", 
     SuperscriptBox["#1", "16"], "-", 
     SuperscriptBox["#1", "17"], "+", 
     SuperscriptBox["#1", "19"], "+", 
     SuperscriptBox["#1", "20"], "-", 
     SuperscriptBox["#1", "22"], "-", 
     SuperscriptBox["#1", "23"], "+", 
     SuperscriptBox["#1", "25"], "+", 
     SuperscriptBox["#1", "26"], "-", 
     SuperscriptBox["#1", "28"], "-", 
     SuperscriptBox["#1", "29"], "+", 
     SuperscriptBox["#1", "31"], "+", 
     SuperscriptBox["#1", "32"]}], "&"}], ",", "1"}], "]"}]], "Output",
 ImageSize->{494, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->78509262]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToRadicals", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->210068940],

Cell[BoxData[
 RowBox[{"-", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"-", "1"}], ")"}], 
   RowBox[{"2", "/", "51"}]]}]], "Output",
 ImageSize->{61, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->590329781]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->110749414],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToRadicals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToRadicals"]], "InlineFormula"],
 " also works with ",
 Cell[BoxData[
  ButtonBox["AlgebraicNumber",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/AlgebraicNumber"]], "InlineFormula"],
 " objects:"
}], "ExampleText",
 CellID->29342416],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToRadicals", "[", 
  RowBox[{"AlgebraicNumber", "[", 
   RowBox[{
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"#", "^", "3"}], "-", 
        RowBox[{"11", "#"}], "+", "3"}], "&"}], ",", "1"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->330049002],

Cell[BoxData[
 RowBox[{"1", "+", 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox["3"]}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{
           FractionBox["1", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "27"}], "+", 
             RowBox[{"\[ImaginaryI]", " ", 
              SqrtBox["15243"]}]}], ")"}]}], ")"}], 
         RowBox[{"1", "/", "3"}]]}], 
       RowBox[{"2", " ", 
        SuperscriptBox["3", 
         RowBox[{"2", "/", "3"}]]}]]}], "-", 
     FractionBox[
      RowBox[{"11", " ", 
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}]}], 
      RowBox[{
       SuperscriptBox["2", 
        RowBox[{"2", "/", "3"}]], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"3", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "27"}], "+", 
            RowBox[{"\[ImaginaryI]", " ", 
             SqrtBox["15243"]}]}], ")"}]}], ")"}], 
        RowBox[{"1", "/", "3"}]]}]]}], ")"}]}], "+", 
  RowBox[{"3", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"\[ImaginaryI]", " ", 
            SqrtBox["3"]}]}], ")"}], " ", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{
            FractionBox["1", "2"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"-", "27"}], "+", 
              RowBox[{"\[ImaginaryI]", " ", 
               SqrtBox["15243"]}]}], ")"}]}], ")"}], 
          RowBox[{"1", "/", "3"}]]}], 
        RowBox[{"2", " ", 
         SuperscriptBox["3", 
          RowBox[{"2", "/", "3"}]]}]]}], "-", 
      FractionBox[
       RowBox[{"11", " ", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          RowBox[{"\[ImaginaryI]", " ", 
           SqrtBox["3"]}]}], ")"}]}], 
       RowBox[{
        SuperscriptBox["2", 
         RowBox[{"2", "/", "3"}]], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"3", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "27"}], "+", 
             RowBox[{"\[ImaginaryI]", " ", 
              SqrtBox["15243"]}]}], ")"}]}], ")"}], 
         RowBox[{"1", "/", "3"}]]}]]}], ")"}], "2"]}]}]], "Output",
 ImageSize->{492, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->294096313]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->10467],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Cubics",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->6850],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Cubics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cubics"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " the general formulas for solving cubic equations are not used:"
}], "ExampleText",
 CellID->1016387942],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToRadicals", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "3"}], "-", 
       RowBox[{"5", 
        RowBox[{"#", "^", "2"}]}], "-", 
       RowBox[{"7", "#"}], "+", "9"}], "&"}], ",", "1"}], "]"}], ",", 
   RowBox[{"Cubics", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->803365611],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"9", "-", 
     RowBox[{"7", " ", "#1"}], "-", 
     RowBox[{"5", " ", 
      SuperscriptBox["#1", "2"]}], "+", 
     SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]], "Output",
 ImageSize->{193, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->561756452]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->129433265],

Cell[TextData[{
 "Converting some cubic ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects does not require the general formulas:"
}], "ExampleText",
 CellID->168109149],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToRadicals", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "3"}], "-", "3"}], "&"}], ",", "1"}], "]"}], ",", 
   RowBox[{"Cubics", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->688276313],

Cell[BoxData[
 SuperscriptBox["3", 
  RowBox[{"1", "/", "3"}]]], "Output",
 ImageSize->{27, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->243614191]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Quartics",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->29934],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Quartics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Quartics"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " the general formulas for solving quartic equations are not used:"
}], "ExampleText",
 CellID->262079544],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToRadicals", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "4"}], "+", 
       RowBox[{"3", 
        RowBox[{"#", "^", "3"}]}], "-", 
       RowBox[{"5", 
        RowBox[{"#", "^", "2"}]}], "-", 
       RowBox[{"7", "#"}], "+", "9"}], "&"}], ",", "1"}], "]"}], ",", 
   RowBox[{"Quartics", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->580926546],

Cell[BoxData[
 RowBox[{"Root", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"9", "-", 
     RowBox[{"7", " ", "#1"}], "-", 
     RowBox[{"5", " ", 
      SuperscriptBox["#1", "2"]}], "+", 
     RowBox[{"3", " ", 
      SuperscriptBox["#1", "3"]}], "+", 
     SuperscriptBox["#1", "4"]}], "&"}], ",", "1"}], "]"}]], "Output",
 ImageSize->{235, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->128151594]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->46448385],

Cell[TextData[{
 "Converting some quartic ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects does not require the general formulas:"
}], "ExampleText",
 CellID->278117794],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToRadicals", "[", 
  RowBox[{
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "4"}], "-", 
       RowBox[{"7", 
        RowBox[{"#", "^", "2"}]}], "+", "3"}], "&"}], ",", "1"}], "]"}], ",", 
   
   RowBox[{"Quartics", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->73230325],

Cell[BoxData[
 RowBox[{"-", 
  SqrtBox[
   RowBox[{
    FractionBox["7", "2"], "+", 
    FractionBox[
     SqrtBox["37"], "2"]}]]}]], "Output",
 ImageSize->{90, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->14314049]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6975],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   RowBox[{
    ButtonBox["RootReduce",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/RootReduce"], "[", 
    RowBox[{"ToRadicals", "[", 
     StyleBox["r", "TI"], "]"}], "]"}], "==", 
   StyleBox["r", "TI"]}]], "InlineFormula"],
 " for any algebraic number ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 " given as a ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " object:"
}], "ExampleText",
 CellID->187094559],

Cell[BoxData[
 RowBox[{
  RowBox[{"r", "=", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"#", "^", "4"}], "+", 
       RowBox[{"3", 
        RowBox[{"#", "^", "3"}]}], "-", 
       RowBox[{"5", 
        RowBox[{"#", "^", "2"}]}], "-", 
       RowBox[{"7", "#"}], "+", "9"}], "&"}], ",", "1"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->561969033],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RootReduce", "[", 
   RowBox[{"ToRadicals", "[", "r", "]"}], "]"}], "\[Equal]", "r"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->87296241],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->452526827]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->165394112],

Cell[TextData[{
 "By default ",
 Cell[BoxData[
  ButtonBox["Reduce",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
 " will not produce radical solutions for general cubics:"
}], "ExampleText",
 CellID->67862664],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "3"}], "+", "x", "+", "17"}], "\[Equal]", "0"}], ",", 
   "x"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->392105870],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"17", "+", "#1", "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "1"}], "]"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"17", "+", "#1", "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "2"}], "]"}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"17", "+", "#1", "+", 
       SuperscriptBox["#1", "3"]}], "&"}], ",", "3"}], "]"}]}]}]], "Output",
 ImageSize->{546, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->62937955]
}, Open  ]],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["ToRadicals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToRadicals"]], "InlineFormula"],
 " to convert:"
}], "ExampleText",
 CellID->66654400],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToRadicals", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->112027226],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["2", 
        RowBox[{"3", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "153"}], "+", 
           SqrtBox["23421"]}], ")"}]}]], ")"}], 
      RowBox[{"1", "/", "3"}]]}], "+", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "153"}], "+", 
          SqrtBox["23421"]}], ")"}]}], ")"}], 
      RowBox[{"1", "/", "3"}]], 
     SuperscriptBox["3", 
      RowBox[{"2", "/", "3"}]]]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "153"}], "+", 
            SqrtBox["23421"]}], ")"}]}], ")"}], 
        RowBox[{"1", "/", "3"}]]}], 
      RowBox[{"2", " ", 
       SuperscriptBox["3", 
        RowBox[{"2", "/", "3"}]]}]]}], "+", 
    FractionBox[
     RowBox[{"1", "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["3"]}]}], 
     RowBox[{
      SuperscriptBox["2", 
       RowBox[{"2", "/", "3"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"3", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "153"}], "+", 
           SqrtBox["23421"]}], ")"}]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}]]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "153"}], "+", 
            SqrtBox["23421"]}], ")"}]}], ")"}], 
        RowBox[{"1", "/", "3"}]]}], 
      RowBox[{"2", " ", 
       SuperscriptBox["3", 
        RowBox[{"2", "/", "3"}]]}]]}], "+", 
    FractionBox[
     RowBox[{"1", "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["3"]}]}], 
     RowBox[{
      SuperscriptBox["2", 
       RowBox[{"2", "/", "3"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"3", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "153"}], "+", 
           SqrtBox["23421"]}], ")"}]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}]]}]}]}]], "Output",
 ImageSize->{479, 159},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->590116151]
}, Open  ]],

Cell[TextData[{
 "Alternatively set ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Cubics",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cubics"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->94759533],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Reduce", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "3"}], "+", "x", "+", "17"}], "\[Equal]", "0"}], ",", 
   "x", ",", 
   RowBox[{"Cubics", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->682322081],

Cell[BoxData[
 RowBox[{
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    RowBox[{"-", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["2", 
        RowBox[{"3", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "153"}], "+", 
           SqrtBox["23421"]}], ")"}]}]], ")"}], 
      RowBox[{"1", "/", "3"}]]}], "+", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "153"}], "+", 
          SqrtBox["23421"]}], ")"}]}], ")"}], 
      RowBox[{"1", "/", "3"}]], 
     SuperscriptBox["3", 
      RowBox[{"2", "/", "3"}]]]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "+", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "153"}], "+", 
            SqrtBox["23421"]}], ")"}]}], ")"}], 
        RowBox[{"1", "/", "3"}]]}], 
      RowBox[{"2", " ", 
       SuperscriptBox["3", 
        RowBox[{"2", "/", "3"}]]}]]}], "+", 
    FractionBox[
     RowBox[{"1", "-", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["3"]}]}], 
     RowBox[{
      SuperscriptBox["2", 
       RowBox[{"2", "/", "3"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"3", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "153"}], "+", 
           SqrtBox["23421"]}], ")"}]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}]]}]}], "||", 
  RowBox[{"x", "\[Equal]", 
   RowBox[{
    RowBox[{"-", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", 
         RowBox[{"\[ImaginaryI]", " ", 
          SqrtBox["3"]}]}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", "153"}], "+", 
            SqrtBox["23421"]}], ")"}]}], ")"}], 
        RowBox[{"1", "/", "3"}]]}], 
      RowBox[{"2", " ", 
       SuperscriptBox["3", 
        RowBox[{"2", "/", "3"}]]}]]}], "+", 
    FractionBox[
     RowBox[{"1", "+", 
      RowBox[{"\[ImaginaryI]", " ", 
       SqrtBox["3"]}]}], 
     RowBox[{
      SuperscriptBox["2", 
       RowBox[{"2", "/", "3"}]], " ", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"3", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "153"}], "+", 
           SqrtBox["23421"]}], ")"}]}], ")"}], 
       RowBox[{"1", "/", "3"}]]}]]}]}]}]], "Output",
 ImageSize->{479, 159},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->70590773]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29075],

Cell[TextData[{
 "In this case ",
 Cell[BoxData[
  ButtonBox["ToRadicals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToRadicals"]], "InlineFormula"],
 " succeeds on the unreduced expression:"
}], "ExampleText",
 CellID->126612032],

Cell[BoxData[
 RowBox[{
  RowBox[{"e", "=", 
   RowBox[{
    RowBox[{"Sqrt", "[", "2", "]"}], "+", 
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"#", "^", "3"}], "+", 
        RowBox[{"11", "#"}], "+", "3"}], "&"}], ",", "1"}], "]"}]}]}], 
  ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->32044389],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToRadicals", "[", 
  RowBox[{"{", 
   RowBox[{"e", ",", 
    RowBox[{"RootReduce", "[", "e", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->621408264],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SqrtBox["2"], "-", 
    RowBox[{"11", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["2", 
        RowBox[{"3", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "27"}], "+", 
           SqrtBox["16701"]}], ")"}]}]], ")"}], 
      RowBox[{"1", "/", "3"}]]}], "+", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "27"}], "+", 
          SqrtBox["16701"]}], ")"}]}], ")"}], 
      RowBox[{"1", "/", "3"}]], 
     SuperscriptBox["3", 
      RowBox[{"2", "/", "3"}]]]}], ",", 
   RowBox[{"Root", "[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"-", "329"}], "+", 
       RowBox[{"102", " ", "#1"}], "+", 
       RowBox[{"133", " ", 
        SuperscriptBox["#1", "2"]}], "+", 
       RowBox[{"6", " ", 
        SuperscriptBox["#1", "3"]}], "+", 
       RowBox[{"16", " ", 
        SuperscriptBox["#1", "4"]}], "+", 
       SuperscriptBox["#1", "6"]}], "&"}], ",", "2"}], "]"}]}], 
  "}"}]], "Output",
 ImageSize->{380, 74},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->581242713]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->94357774],

Cell[TextData[{
 "In this case ",
 Cell[BoxData[
  ButtonBox["ToRadicals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToRadicals"]], "InlineFormula"],
 " succeeds on the reduced expression:"
}], "ExampleText",
 CellID->8392417],

Cell[BoxData[
 RowBox[{
  RowBox[{"e", "=", 
   RowBox[{
    RowBox[{"RootReduce", "[", 
     RowBox[{
      RowBox[{"Sqrt", "[", "2", "]"}], "+", 
      RowBox[{"Root", "[", 
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{"#", "^", "3"}], "+", 
          RowBox[{"11", "#"}], "+", "3"}], "&"}], ",", "1"}], "]"}]}], "]"}], 
    "-", 
    RowBox[{"Sqrt", "[", "2", "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->371190027],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToRadicals", "[", 
  RowBox[{"{", 
   RowBox[{"e", ",", 
    RowBox[{"RootReduce", "[", "e", "]"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->395713125],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     SqrtBox["2"]}], "+", 
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", "329"}], "+", 
        RowBox[{"102", " ", "#1"}], "+", 
        RowBox[{"133", " ", 
         SuperscriptBox["#1", "2"]}], "+", 
        RowBox[{"6", " ", 
         SuperscriptBox["#1", "3"]}], "+", 
        RowBox[{"16", " ", 
         SuperscriptBox["#1", "4"]}], "+", 
        SuperscriptBox["#1", "6"]}], "&"}], ",", "2"}], "]"}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"-", "11"}], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox["2", 
        RowBox[{"3", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "27"}], "+", 
           SqrtBox["16701"]}], ")"}]}]], ")"}], 
      RowBox[{"1", "/", "3"}]]}], "+", 
    FractionBox[
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "27"}], "+", 
          SqrtBox["16701"]}], ")"}]}], ")"}], 
      RowBox[{"1", "/", "3"}]], 
     SuperscriptBox["3", 
      RowBox[{"2", "/", "3"}]]]}]}], "}"}]], "Output",
 ImageSize->{392, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->441718100]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->58686330],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToRadicals",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToRadicals"]], "InlineFormula"],
 " converts ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " objects containing parameters:"
}], "ExampleText",
 CellID->258305433],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToRadicals", "[", 
  RowBox[{"Root", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"#", "^", "3"}], "-", "a"}], "&"}], ",", "1"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->389356533],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"-", "1"}], ")"}], 
   RowBox[{"2", "/", "3"}]], " ", 
  SuperscriptBox["a", 
   RowBox[{"1", "/", "3"}]]}]], "Output",
 ImageSize->{74, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->672035316]
}, Open  ]],

Cell[TextData[{
 "The result may not be equal to the ",
 Cell[BoxData[
  ButtonBox["Root",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Root"]], "InlineFormula"],
 " object for some values of the parameter:"
}], "ExampleText",
 CellID->7424825],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Root", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"#", "^", "3"}], "-", "a"}], "&"}], ",", "1"}], "]"}], ",", 
    "%"}], "}"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", "\[Rule]", 
      RowBox[{"-", "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"a", "\[Rule]", "1"}], "}"}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->997382],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1"}], ",", 
     RowBox[{"-", "1"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"-", "1"}], ")"}], 
      RowBox[{"2", "/", "3"}]]}], "}"}]}], "}"}]], "Output",
 ImageSize->{161, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->402246864]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2305],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Solve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Solve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NSolve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NSolve"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Root",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Root"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RootReduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/RootReduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Roots",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Roots"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToNumberField",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToNumberField"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29665]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27583],

Cell[TextData[ButtonBox["Algebraic Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AlgebraicNumbers"]], "Tutorials",
 CellID->12133]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->3652938],

Cell[TextData[ButtonBox["Algebraic Numbers",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicNumbers"]], "MoreAbout",
 CellID->660337033],

Cell[TextData[ButtonBox["Algebraic Number Theory",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicNumberTheory"]], "MoreAbout",
 CellID->91883369],

Cell[TextData[ButtonBox["Algebraic Transformations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicTransformations"]], "MoreAbout",
 CellID->2716392],

Cell[TextData[ButtonBox["Number Recognition",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NumberRecognition"]], "MoreAbout",
 CellID->109678112],

Cell[TextData[ButtonBox["Polynomial Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialAlgebra"]], "MoreAbout",
 CellID->120454464],

Cell[TextData[ButtonBox["Polynomial Equations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialEquations"]], "MoreAbout",
 CellID->178877673]
}, Open  ]],

Cell["New in 3  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ToRadicals - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 13.3488672}", "context" -> "System`", 
    "keywords" -> {
     "algebraic number", "AlgebraicNumber", "radical expression", "root"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ToRadicals[expr] attempts to express all Root objects in expr in terms \
of radicals. ", "synonyms" -> {"to radicals"}, "title" -> "ToRadicals", 
    "type" -> "Symbol", "uri" -> "ref/ToRadicals"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[10738, 286, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->337157260]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 51165, 1856}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2945, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3568, 91, 4194, 83, 70, "ObjectNameGrid"],
Cell[7765, 176, 721, 23, 70, "Usage",
 CellID->17691]
}, Open  ]],
Cell[CellGroupData[{
Cell[8523, 204, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9001, 221, 418, 13, 70, "Notes",
 CellID->26706],
Cell[9422, 236, 289, 9, 70, "Notes",
 CellID->28826],
Cell[9714, 247, 588, 21, 70, "Notes",
 CellID->26216],
Cell[10305, 270, 396, 11, 70, "Notes",
 CellID->82730543]
}, Closed]],
Cell[CellGroupData[{
Cell[10738, 286, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->337157260],
Cell[CellGroupData[{
Cell[11123, 300, 148, 5, 70, "ExampleSection",
 CellID->350100512],
Cell[CellGroupData[{
Cell[11296, 309, 414, 16, 28, "Input",
 CellID->424304078],
Cell[11713, 327, 880, 34, 72, "Output",
 CellID->255583061]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12642, 367, 216, 7, 70, "ExampleSection",
 CellID->16791],
Cell[12861, 376, 224, 8, 70, "ExampleText",
 CellID->151149825],
Cell[CellGroupData[{
Cell[13110, 388, 328, 12, 70, "Input",
 CellID->43014127],
Cell[13441, 402, 1001, 36, 71, "Output",
 CellID->102647576]
}, Open  ]],
Cell[14457, 441, 224, 8, 70, "ExampleText",
 CellID->9517185],
Cell[CellGroupData[{
Cell[14706, 453, 389, 14, 70, "Input",
 CellID->205945966],
Cell[15098, 469, 2578, 86, 287, "Output",
 CellID->232668601]
}, Open  ]],
Cell[17691, 558, 125, 3, 70, "ExampleDelimiter",
 CellID->197357319],
Cell[17819, 563, 250, 8, 70, "ExampleText",
 CellID->210840089],
Cell[CellGroupData[{
Cell[18094, 575, 640, 22, 70, "Input",
 CellID->536763697],
Cell[18737, 599, 488, 18, 80, "Output",
 CellID->7339004]
}, Open  ]],
Cell[CellGroupData[{
Cell[19262, 622, 198, 6, 70, "Input",
 CellID->757170322],
Cell[19463, 630, 1070, 30, 58, "Output",
 CellID->78509262]
}, Open  ]],
Cell[CellGroupData[{
Cell[20570, 665, 106, 3, 70, "Input",
 CellID->210068940],
Cell[20679, 670, 268, 10, 36, "Output",
 CellID->590329781]
}, Open  ]],
Cell[20962, 683, 125, 3, 70, "ExampleDelimiter",
 CellID->110749414],
Cell[21090, 688, 344, 12, 70, "ExampleText",
 CellID->29342416],
Cell[CellGroupData[{
Cell[21459, 704, 406, 13, 70, "Input",
 CellID->330049002],
Cell[21868, 719, 2685, 89, 128, "Output",
 CellID->294096313]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24602, 814, 218, 7, 70, "ExampleSection",
 CellID->10467],
Cell[CellGroupData[{
Cell[24845, 825, 222, 7, 70, "ExampleSubsection",
 CellID->6850],
Cell[25070, 834, 352, 12, 70, "ExampleText",
 CellID->1016387942],
Cell[CellGroupData[{
Cell[25447, 850, 396, 13, 70, "Input",
 CellID->803365611],
Cell[25846, 865, 386, 13, 39, "Output",
 CellID->561756452]
}, Open  ]],
Cell[26247, 881, 125, 3, 70, "ExampleDelimiter",
 CellID->129433265],
Cell[26375, 886, 243, 8, 70, "ExampleText",
 CellID->168109149],
Cell[CellGroupData[{
Cell[26643, 898, 301, 10, 70, "Input",
 CellID->688276313],
Cell[26947, 910, 204, 7, 36, "Output",
 CellID->243614191]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[27200, 923, 225, 7, 70, "ExampleSubsection",
 CellID->29934],
Cell[27428, 932, 357, 12, 70, "ExampleText",
 CellID->262079544],
Cell[CellGroupData[{
Cell[27810, 948, 460, 15, 70, "Input",
 CellID->580926546],
Cell[28273, 965, 451, 15, 39, "Output",
 CellID->128151594]
}, Open  ]],
Cell[28739, 983, 124, 3, 70, "ExampleDelimiter",
 CellID->46448385],
Cell[28866, 988, 245, 8, 70, "ExampleText",
 CellID->278117794],
Cell[CellGroupData[{
Cell[29136, 1000, 368, 13, 70, "Input",
 CellID->73230325],
Cell[29507, 1015, 272, 11, 72, "Output",
 CellID->14314049]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[29840, 1033, 232, 7, 70, "ExampleSection",
 CellID->6975],
Cell[30075, 1042, 545, 20, 70, "ExampleText",
 CellID->187094559],
Cell[30623, 1064, 403, 15, 70, "Input",
 CellID->561969033],
Cell[CellGroupData[{
Cell[31051, 1083, 173, 5, 70, "Input",
 CellID->87296241],
Cell[31227, 1090, 161, 5, 36, "Output",
 CellID->452526827]
}, Open  ]],
Cell[31403, 1098, 125, 3, 70, "ExampleDelimiter",
 CellID->165394112],
Cell[31531, 1103, 243, 8, 70, "ExampleText",
 CellID->67862664],
Cell[CellGroupData[{
Cell[31799, 1115, 222, 8, 70, "Input",
 CellID->392105870],
Cell[32024, 1125, 723, 24, 39, "Output",
 CellID->62937955]
}, Open  ]],
Cell[32762, 1152, 201, 8, 70, "ExampleText",
 CellID->66654400],
Cell[CellGroupData[{
Cell[32988, 1164, 106, 3, 70, "Input",
 CellID->112027226],
Cell[33097, 1169, 2861, 102, 180, "Output",
 CellID->590116151]
}, Open  ]],
Cell[35973, 1274, 299, 12, 70, "ExampleText",
 CellID->94759533],
Cell[CellGroupData[{
Cell[36297, 1290, 270, 9, 70, "Input",
 CellID->682322081],
Cell[36570, 1301, 2860, 102, 180, "Output",
 CellID->70590773]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39479, 1409, 226, 7, 70, "ExampleSection",
 CellID->29075],
Cell[39708, 1418, 237, 8, 70, "ExampleText",
 CellID->126612032],
Cell[39948, 1428, 342, 13, 70, "Input",
 CellID->32044389],
Cell[CellGroupData[{
Cell[40315, 1445, 192, 6, 70, "Input",
 CellID->621408264],
Cell[40510, 1453, 1265, 45, 95, "Output",
 CellID->581242713]
}, Open  ]],
Cell[41790, 1501, 124, 3, 70, "ExampleDelimiter",
 CellID->94357774],
Cell[41917, 1506, 233, 8, 70, "ExampleText",
 CellID->8392417],
Cell[42153, 1516, 457, 16, 70, "Input",
 CellID->371190027],
Cell[CellGroupData[{
Cell[42635, 1536, 192, 6, 70, "Input",
 CellID->395713125],
Cell[42830, 1544, 1331, 47, 94, "Output",
 CellID->441718100]
}, Open  ]],
Cell[44176, 1594, 124, 3, 70, "ExampleDelimiter",
 CellID->58686330],
Cell[44303, 1599, 338, 12, 70, "ExampleText",
 CellID->258305433],
Cell[CellGroupData[{
Cell[44666, 1615, 237, 9, 70, "Input",
 CellID->389356533],
Cell[44906, 1626, 320, 12, 36, "Output",
 CellID->672035316]
}, Open  ]],
Cell[45241, 1641, 248, 8, 70, "ExampleText",
 CellID->7424825],
Cell[CellGroupData[{
Cell[45514, 1653, 463, 18, 70, "Input",
 CellID->997382],
Cell[45980, 1673, 448, 17, 39, "Output",
 CellID->402246864]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[46489, 1697, 310, 9, 70, "SeeAlsoSection",
 CellID->2305],
Cell[46802, 1708, 1421, 53, 70, "SeeAlso",
 CellID->29665]
}, Open  ]],
Cell[CellGroupData[{
Cell[48260, 1766, 314, 9, 70, "TutorialsSection",
 CellID->27583],
Cell[48577, 1777, 144, 3, 70, "Tutorials",
 CellID->12133]
}, Open  ]],
Cell[CellGroupData[{
Cell[48758, 1785, 317, 9, 70, "MoreAboutSection",
 CellID->3652938],
Cell[49078, 1796, 145, 3, 70, "MoreAbout",
 CellID->660337033],
Cell[49226, 1801, 155, 3, 70, "MoreAbout",
 CellID->91883369],
Cell[49384, 1806, 159, 3, 70, "MoreAbout",
 CellID->2716392],
Cell[49546, 1811, 147, 3, 70, "MoreAbout",
 CellID->109678112],
Cell[49696, 1816, 147, 3, 70, "MoreAbout",
 CellID->120454464],
Cell[49846, 1821, 151, 3, 70, "MoreAbout",
 CellID->178877673]
}, Open  ]],
Cell[50012, 1827, 50, 0, 70, "History"],
Cell[50065, 1829, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

