(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9951,        360]
NotebookOptionsPosition[      7354,        274]
NotebookOutlinePosition[      8653,        311]
CellTagsIndexPosition[      8569,        306]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"The Representation of Equations and Solutions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/TheRepresentationOfEquationsAndSolutions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"The Representation of Equations and Solutions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Roots" :> Documentation`HelpLookup["paclet:ref/Roots"], 
          "Reduce" :> Documentation`HelpLookup["paclet:ref/Reduce"], "Solve" :> 
          Documentation`HelpLookup["paclet:ref/Solve"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Roots\"\>", 2->"\<\"Reduce\"\>", 
       3->"\<\"Solve\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ToRules", "ObjectName",
 CellID->13114],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ToRules",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ToRules"], "[", 
       StyleBox["eqns", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]takes logical combinations of equations, in the form \
generated by ",
     Cell[BoxData[
      ButtonBox["Roots",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Roots"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["Reduce",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Reduce"]], "InlineFormula"],
     ", and converts them to lists of rules, of the form produced by ",
     Cell[BoxData[
      ButtonBox["Solve",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18042]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToRules",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToRules"]], "InlineFormula"],
 " discards nonequalities (",
 Cell[BoxData["!="], "InlineFormula"],
 "), and thus gives only \"generic\" solutions. "
}], "Notes",
 CellID->32749]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->404945085],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->107506225],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToRules", "[", 
  RowBox[{
   RowBox[{"x", "\[Equal]", "1"}], "||", 
   RowBox[{"x", "\[Equal]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->119111866],

Cell[BoxData[
 RowBox[{"Sequence", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "2"}], "}"}]}], "]"}]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->126256541]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->773968472],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"ToRules", "[", 
   RowBox[{
    RowBox[{"x", "\[Equal]", "1"}], "||", 
    RowBox[{"x", "\[Equal]", "2"}]}], "]"}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->147219109],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "2"}], "}"}]}], "}"}]], "Output",
 ImageSize->{118, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->629156]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14025],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Roots",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Roots"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Reduce",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Reduce"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Solve",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Solve"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26362]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->1728],

Cell[TextData[ButtonBox["The Representation of Equations and Solutions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/TheRepresentationOfEquationsAndSolutions"]], "Tutorials",
 CellID->31261]
}, Open  ]],

Cell["New in 1", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ToRules - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 13.9582578}", "context" -> "System`", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "ToRules[eqns] takes logical combinations of equations, in the form \
generated by Roots and Reduce, and converts them to lists of rules, of the \
form produced by Solve. ", "synonyms" -> {"to rules"}, "title" -> "ToRules", 
    "type" -> "Symbol", "uri" -> "ref/ToRules"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3905, 131, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->404945085]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8426, 299}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1405, 34, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2028, 61, 45, 1, 70, "ObjectName",
 CellID->13114],
Cell[2076, 64, 997, 31, 70, "Usage",
 CellID->18042]
}, Open  ]],
Cell[CellGroupData[{
Cell[3110, 100, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3588, 117, 280, 9, 70, "Notes",
 CellID->32749]
}, Closed]],
Cell[CellGroupData[{
Cell[3905, 131, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->404945085],
Cell[CellGroupData[{
Cell[4290, 145, 148, 5, 70, "ExampleSection",
 CellID->107506225],
Cell[CellGroupData[{
Cell[4463, 154, 189, 6, 28, "Input",
 CellID->119111866],
Cell[4655, 162, 326, 11, 36, "Output",
 CellID->126256541]
}, Open  ]],
Cell[4996, 176, 125, 3, 70, "ExampleDelimiter",
 CellID->773968472],
Cell[CellGroupData[{
Cell[5146, 183, 215, 7, 28, "Input",
 CellID->147219109],
Cell[5364, 192, 311, 11, 36, "Output",
 CellID->629156]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5736, 210, 311, 9, 70, "SeeAlsoSection",
 CellID->14025],
Cell[6050, 221, 680, 26, 70, "SeeAlso",
 CellID->26362]
}, Open  ]],
Cell[CellGroupData[{
Cell[6767, 252, 313, 9, 70, "TutorialsSection",
 CellID->1728],
Cell[7083, 263, 199, 4, 70, "Tutorials",
 CellID->31261]
}, Open  ]],
Cell[7297, 270, 27, 0, 70, "History"],
Cell[7327, 272, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

