(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     26040,        973]
NotebookOptionsPosition[     20204,        764]
NotebookOutlinePosition[     21497,        800]
CellTagsIndexPosition[     21412,        795]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Characters in Strings" :> 
          Documentation`HelpLookup["paclet:tutorial/CharactersInStrings"]}, #,
          2]& , Evaluator -> Automatic], {
       1->"\<\"Characters in Strings\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"UpperCaseQ" :> 
          Documentation`HelpLookup["paclet:ref/UpperCaseQ"], "ToLowerCase" :> 
          Documentation`HelpLookup["paclet:ref/ToLowerCase"], "StringReplace" :> 
          Documentation`HelpLookup["paclet:ref/StringReplace"], "IgnoreCase" :> 
          Documentation`HelpLookup["paclet:ref/IgnoreCase"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"UpperCaseQ\"\>", 
       2->"\<\"ToLowerCase\"\>", 3->"\<\"StringReplace\"\>", 
       4->"\<\"IgnoreCase\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Character Operations" :> 
          Documentation`HelpLookup["paclet:guide/CharacterOperations"], 
          "String Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/StringManipulation"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Character Operations\"\>", 
       2->"\<\"String Manipulation\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ToUpperCase", "ObjectName",
 CellID->12490],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ToUpperCase",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ToUpperCase"], "[", 
       StyleBox["string", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]yields a string in which all letters have been \
converted to uppercase. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3375]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToUpperCase",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToUpperCase"]], "InlineFormula"],
 " handles both ordinary and special characters. "
}], "Notes",
 CellID->6546],

Cell[TextData[{
 "Variant lowercase characters such as ",
 Cell[TextData[ButtonBox["\\[CurlyPhi]",
  BaseStyle->"Link",
  ButtonData->"paclet:ref/character/CurlyPhi"]], "InlineCharacterName"],
 " are converted to their non\[Hyphen]variant uppercase forms. "
}], "Notes",
 CellID->30439]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->497368073],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->13742426],

Cell["Convert characters in a string to uppercase:", "ExampleText",
 CellID->32340],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToUpperCase", "[", "\"\<abcd\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->766],

Cell[BoxData["\<\"ABCD\"\>"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->7633]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18321],

Cell["Everything other than lowercase letters is left unchanged:", \
"ExampleText",
 CellID->636],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToUpperCase", "[", "\"\<ABC xyz 123\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18677],

Cell[BoxData["\<\"ABC XYZ 123\"\>"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->17995]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30906],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToUpperCase",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToUpperCase"]], "InlineFormula"],
 " threads itself element-wise over lists:"
}], "ExampleText",
 CellID->19463],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToUpperCase", "[", 
  RowBox[{"{", 
   RowBox[{"\"\<a\>\"", ",", "\"\<b\>\"", ",", "\"\<c\>\""}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->5249],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"A\"\>", ",", "\<\"B\"\>", ",", "\<\"C\"\>"}], "}"}]], "Output",\

 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->11620]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->8056],

Cell["Accented characters:", "ExampleText",
 CellID->6133],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToUpperCase", "[", "\"\<\[ADoubleDot]\[EAcute]\>\"", "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->29566],

Cell[BoxData["\<\"\[CapitalADoubleDot]\[CapitalEAcute]\"\>"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->15955]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->57],

Cell["Greek letters:", "ExampleText",
 CellID->25421],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToUpperCase", "[", 
  "\"\<\[Alpha]\[Beta]\[Gamma]\[Delta]\[Epsilon]\[Zeta]\[Eta]\[Theta]\>\"", 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20461],

Cell[BoxData["\<\"\[CapitalAlpha]\[CapitalBeta]\[CapitalGamma]\[CapitalDelta]\
\[CapitalEpsilon]\[CapitalZeta]\[CapitalEta]\[CapitalTheta]\"\>"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->22501]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26660],

Cell["Script letters:", "ExampleText",
 CellID->18916],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToUpperCase", "[", 
  "\"\<\[ScriptA]\[ScriptB]\[ScriptC]\[ScriptD]\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->3163],

Cell[BoxData["\<\"\[ScriptCapitalA]\[ScriptCapitalB]\[ScriptCapitalC]\
\[ScriptCapitalD]\"\>"], "Output",
 ImageSize->{34, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->28738]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->470],

Cell["\<\
The uppercase form of the German \[SZ] character is a pair of characters:\
\>", "ExampleText",
 CellID->15199],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToUpperCase", "[", "\"\<\[SZ]\>\"", "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->14115],

Cell[BoxData["\<\"SS\"\>"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->366]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ToLowerCase",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToLowerCase"]], "InlineFormula"],
 " does not give back the original character:"
}], "ExampleText",
 CellID->1465],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToLowerCase", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15232],

Cell[BoxData["\<\"ss\"\>"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->19874]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->19078],

Cell[TextData[{
 "For a few characters, ",
 Cell[BoxData[
  ButtonBox["ToLowerCase",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToLowerCase"]], "InlineFormula"],
 " is not the inverse of ",
 Cell[BoxData[
  ButtonBox["ToUpperCase",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToUpperCase"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->4337],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"Characters", "[", 
    RowBox[{"FromCharacterCode", "[", 
     RowBox[{"Range", "[", 
      RowBox[{
       RowBox[{"2", "^", "16"}], "-", "1"}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"LowerCaseQ", "[", "#", "]"}], "&&", 
     RowBox[{
      RowBox[{"ToLowerCase", "[", 
       RowBox[{"ToUpperCase", "[", "#", "]"}], "]"}], "=!=", "#"}]}], "&"}]}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->16800],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"\[SZ]\"\>", ",", "\<\"\[YDoubleDot]\"\>", 
   ",", "\<\"\[DotlessI]\"\>", ",", "\<\"\[CurlyEpsilon]\"\>", 
   ",", "\<\"\[FinalSigma]\"\>", ",", "\<\"\[CurlyPhi]\"\>", 
   ",", "\<\"\[CurlyTheta]\"\>", ",", "\<\"\[CurlyPi]\"\>", 
   ",", "\<\"\[CurlyKappa]\"\>", ",", "\<\"\[CurlyRho]\"\>", 
   ",", "\<\"\[DotlessJ]\"\>"}], "}"}]], "Output",
 ImageSize->{208, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16191683]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToUpperCase", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->27993],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"SS\"\>", ",", "\<\"Y\"\>", ",", "\<\"I\"\>", 
   ",", "\<\"\[CapitalEpsilon]\"\>", ",", "\<\"\[CapitalSigma]\"\>", 
   ",", "\<\"\[CapitalPhi]\"\>", ",", "\<\"\[CapitalTheta]\"\>", 
   ",", "\<\"\[CapitalPi]\"\>", ",", "\<\"\[CapitalKappa]\"\>", 
   ",", "\<\"\[CapitalRho]\"\>", ",", "\<\"J\"\>"}], "}"}]], "Output",
 ImageSize->{214, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->5958]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToLowerCase", "[", "%", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->16757],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"ss\"\>", ",", "\<\"y\"\>", ",", "\<\"i\"\>", 
   ",", "\<\"\[Epsilon]\"\>", ",", "\<\"\[Sigma]\"\>", ",", "\<\"\[Phi]\"\>", 
   ",", "\<\"\[Theta]\"\>", ",", "\<\"\[Pi]\"\>", ",", "\<\"\[Kappa]\"\>", 
   ",", "\<\"\[Rho]\"\>", ",", "\<\"j\"\>"}], "}"}]], "Output",
 ImageSize->{215, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->23671]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24682],

Cell["\<\
Check that the German \[SZ] character is the only one to have a \
multicharacter uppercase form:\
\>", "ExampleText",
 CellID->26617],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Select", "[", 
  RowBox[{
   RowBox[{"Characters", "[", 
    RowBox[{"FromCharacterCode", "[", 
     RowBox[{"Range", "[", 
      RowBox[{
       RowBox[{"2", "^", "16"}], "-", "1"}], "]"}], "]"}], "]"}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"LetterQ", "[", "#", "]"}], "&&", 
     RowBox[{
      RowBox[{"StringLength", "[", 
       RowBox[{"ToUpperCase", "[", "#", "]"}], "]"}], "!=", "1"}]}], "&"}]}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31065],

Cell[BoxData[
 RowBox[{"{", "\<\"\[SZ]\"\>", "}"}]], "Output",
 ImageSize->{25, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->939034042]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->25820],

Cell[TextData[{
 "Find the names of characters for which ",
 Cell[BoxData[
  ButtonBox["ToLowerCase",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToLowerCase"]], "InlineFormula"],
 " is not the inverse of ",
 Cell[BoxData[
  ButtonBox["ToUpperCase",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToUpperCase"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->5312],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "/@", 
  RowBox[{"Select", "[", 
   RowBox[{
    RowBox[{"Characters", "[", 
     RowBox[{"FromCharacterCode", "[", 
      RowBox[{"Range", "[", 
       RowBox[{
        RowBox[{"2", "^", "16"}], "-", "1"}], "]"}], "]"}], "]"}], ",", 
    RowBox[{
     RowBox[{
      RowBox[{"LowerCaseQ", "[", "#", "]"}], "&&", 
      RowBox[{
       RowBox[{"ToLowerCase", "[", 
        RowBox[{"ToUpperCase", "[", "#", "]"}], "]"}], "=!=", "#"}]}], 
     "&"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->20204],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    StyleBox["\"\<\\[SZ]\>\"",
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", 
   TagBox[
    StyleBox["\"\<\\[YDoubleDot]\>\"",
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", 
   TagBox[
    StyleBox["\"\<\\[DotlessI]\>\"",
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", 
   TagBox[
    StyleBox["\"\<\\[CurlyEpsilon]\>\"",
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", 
   TagBox[
    StyleBox["\"\<\\[FinalSigma]\>\"",
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", 
   TagBox[
    StyleBox["\"\<\\[CurlyPhi]\>\"",
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", 
   TagBox[
    StyleBox["\"\<\\[CurlyTheta]\>\"",
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", 
   TagBox[
    StyleBox["\"\<\\[CurlyPi]\>\"",
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", 
   TagBox[
    StyleBox["\"\<\\[CurlyKappa]\>\"",
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", 
   TagBox[
    StyleBox["\"\<\\[CurlyRho]\>\"",
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm], ",", 
   TagBox[
    StyleBox["\"\<\\[DotlessJ]\>\"",
     ShowSpecialCharacters->False,
     ShowStringCharacters->True,
     NumberMarks->True],
    FullForm]}], "}"}]], "Output",
 ImageSize->{472, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->546632036]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3719],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["UpperCaseQ",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UpperCaseQ"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ToLowerCase",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToLowerCase"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StringReplace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StringReplace"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["IgnoreCase",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/IgnoreCase"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15469]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25048],

Cell[TextData[ButtonBox["Characters in Strings",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/CharactersInStrings"]], "Tutorials",
 CellID->14565]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with ToUpperCase",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=ToUpperCase"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->423191937],

Cell[TextData[ButtonBox["Character Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CharacterOperations"]], "MoreAbout",
 CellID->21476498],

Cell[TextData[ButtonBox["String Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StringManipulation"]], "MoreAbout",
 CellID->601189013]
}, Open  ]],

Cell["New in 2  |  Last modified in 3", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ToUpperCase - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 18.7083794}", "context" -> "System`", 
    "keywords" -> {"convert to upper case", "toupper", "uc", "uppercase"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "ToUpperCase[string] yields a string in which all letters have been \
converted to uppercase. ", "synonyms" -> {"to upper case"}, "title" -> 
    "ToUpperCase", "type" -> "Symbol", "uri" -> "ref/ToUpperCase"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4475, 141, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->497368073]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21269, 788}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2215, 52, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2838, 79, 49, 1, 70, "ObjectName",
 CellID->12490],
Cell[2890, 82, 525, 16, 70, "Usage",
 CellID->3375]
}, Open  ]],
Cell[CellGroupData[{
Cell[3452, 103, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3930, 120, 219, 7, 70, "Notes",
 CellID->6546],
Cell[4152, 129, 286, 7, 70, "Notes",
 CellID->30439]
}, Closed]],
Cell[CellGroupData[{
Cell[4475, 141, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->497368073],
Cell[CellGroupData[{
Cell[4860, 155, 147, 5, 70, "ExampleSection",
 CellID->13742426],
Cell[5010, 162, 83, 1, 70, "ExampleText",
 CellID->32340],
Cell[CellGroupData[{
Cell[5118, 167, 112, 3, 28, "Input",
 CellID->766],
Cell[5233, 172, 164, 5, 36, "Output",
 CellID->7633]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5446, 183, 216, 7, 70, "ExampleSection",
 CellID->18321],
Cell[5665, 192, 97, 2, 70, "ExampleText",
 CellID->636],
Cell[CellGroupData[{
Cell[5787, 198, 121, 3, 70, "Input",
 CellID->18677],
Cell[5911, 203, 172, 5, 36, "Output",
 CellID->17995]
}, Open  ]],
Cell[6098, 211, 121, 3, 70, "ExampleDelimiter",
 CellID->30906],
Cell[6222, 216, 219, 7, 70, "ExampleText",
 CellID->19463],
Cell[CellGroupData[{
Cell[6466, 227, 186, 6, 70, "Input",
 CellID->5249],
Cell[6655, 235, 235, 8, 36, "Output",
 CellID->11620]
}, Open  ]],
Cell[6905, 246, 120, 3, 70, "ExampleDelimiter",
 CellID->8056],
Cell[7028, 251, 58, 1, 70, "ExampleText",
 CellID->6133],
Cell[CellGroupData[{
Cell[7111, 256, 134, 4, 70, "Input",
 CellID->29566],
Cell[7248, 262, 197, 5, 36, "Output",
 CellID->15955]
}, Open  ]],
Cell[7460, 270, 118, 3, 70, "ExampleDelimiter",
 CellID->57],
Cell[7581, 275, 53, 1, 70, "ExampleText",
 CellID->25421],
Cell[CellGroupData[{
Cell[7659, 280, 178, 5, 70, "Input",
 CellID->20461],
Cell[7840, 287, 281, 6, 36, "Output",
 CellID->22501]
}, Open  ]],
Cell[8136, 296, 121, 3, 70, "ExampleDelimiter",
 CellID->26660],
Cell[8260, 301, 54, 1, 70, "ExampleText",
 CellID->18916],
Cell[CellGroupData[{
Cell[8339, 306, 152, 4, 70, "Input",
 CellID->3163],
Cell[8494, 312, 231, 6, 36, "Output",
 CellID->28738]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8774, 324, 224, 7, 70, "ExampleSection",
 CellID->470],
Cell[9001, 333, 120, 3, 70, "ExampleText",
 CellID->15199],
Cell[CellGroupData[{
Cell[9146, 340, 115, 3, 70, "Input",
 CellID->14115],
Cell[9264, 345, 161, 5, 36, "Output",
 CellID->366]
}, Open  ]],
Cell[9440, 353, 221, 7, 70, "ExampleText",
 CellID->1465],
Cell[CellGroupData[{
Cell[9686, 364, 103, 3, 70, "Input",
 CellID->15232],
Cell[9792, 369, 163, 5, 36, "Output",
 CellID->19874]
}, Open  ]],
Cell[9970, 377, 121, 3, 70, "ExampleDelimiter",
 CellID->19078],
Cell[10094, 382, 359, 13, 70, "ExampleText",
 CellID->4337],
Cell[CellGroupData[{
Cell[10478, 399, 497, 16, 70, "Input",
 CellID->16800],
Cell[10978, 417, 516, 12, 36, "Output",
 CellID->16191683]
}, Open  ]],
Cell[CellGroupData[{
Cell[11531, 434, 103, 3, 70, "Input",
 CellID->27993],
Cell[11637, 439, 487, 11, 36, "Output",
 CellID->5958]
}, Open  ]],
Cell[CellGroupData[{
Cell[12161, 455, 103, 3, 70, "Input",
 CellID->16757],
Cell[12267, 460, 435, 10, 36, "Output",
 CellID->23671]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[12751, 476, 224, 7, 70, "ExampleSection",
 CellID->24682],
Cell[12978, 485, 143, 4, 70, "ExampleText",
 CellID->26617],
Cell[CellGroupData[{
Cell[13146, 493, 494, 16, 70, "Input",
 CellID->31065],
Cell[13643, 511, 192, 6, 36, "Output",
 CellID->939034042]
}, Open  ]],
Cell[13850, 520, 121, 3, 70, "ExampleDelimiter",
 CellID->25820],
Cell[13974, 525, 376, 13, 70, "ExampleText",
 CellID->5312],
Cell[CellGroupData[{
Cell[14375, 542, 543, 17, 70, "Input",
 CellID->20204],
Cell[14921, 561, 1971, 73, 71, "Output",
 CellID->546632036]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16953, 641, 310, 9, 70, "SeeAlsoSection",
 CellID->3719],
Cell[17266, 652, 965, 35, 70, "SeeAlso",
 CellID->15469]
}, Open  ]],
Cell[CellGroupData[{
Cell[18268, 692, 314, 9, 70, "TutorialsSection",
 CellID->25048],
Cell[18585, 703, 151, 3, 70, "Tutorials",
 CellID->14565]
}, Open  ]],
Cell[CellGroupData[{
Cell[18773, 711, 305, 8, 70, "RelatedLinksSection"],
Cell[19081, 721, 367, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19485, 738, 319, 9, 70, "MoreAboutSection",
 CellID->423191937],
Cell[19807, 749, 150, 3, 70, "MoreAbout",
 CellID->21476498],
Cell[19960, 754, 149, 3, 70, "MoreAbout",
 CellID->601189013]
}, Open  ]],
Cell[20124, 760, 50, 0, 70, "History"],
Cell[20177, 762, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

