(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     64204,       2008]
NotebookOptionsPosition[     55413,       1704]
NotebookOutlinePosition[     57059,       1746]
CellTagsIndexPosition[     56973,       1741]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"HankelMatrix" :> 
          Documentation`HelpLookup["paclet:ref/HankelMatrix"], 
          "HilbertMatrix" :> 
          Documentation`HelpLookup["paclet:ref/HilbertMatrix"], "Table" :> 
          Documentation`HelpLookup["paclet:ref/Table"], "PadRight" :> 
          Documentation`HelpLookup["paclet:ref/PadRight"], "Band" :> 
          Documentation`HelpLookup["paclet:ref/Band"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"HankelMatrix\"\>", 2->"\<\"HilbertMatrix\"\>", 
       3->"\<\"Table\"\>", 4->"\<\"PadRight\"\>", 
       5->"\<\"Band\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Constructing Matrices" :> 
          Documentation`HelpLookup["paclet:guide/ConstructingMatrices"], 
          "New in 6.0: Matrix & Linear Algebra Functions" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60MatrixAndLinearAlgebraFunctions"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Constructing Matrices\"\>", 
       2->"\<\"New in 6.0: Matrix & Linear Algebra Functions\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ToeplitzMatrix", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ToeplitzMatrix",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ToeplitzMatrix"], "[", 
       StyleBox["n", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "\[Times]",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " Toeplitz matrix with first row and first column being successive \
integers."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ToeplitzMatrix",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ToeplitzMatrix"], "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["c", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["c", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"], ",", 
         SubscriptBox[
          StyleBox["c", "TI"], 
          StyleBox["n", "TI"]]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Toeplitz matrix whose first column consists \
of elements ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["1", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["2", "TR"]]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      StyleBox["\[Ellipsis]", "TR"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["ToeplitzMatrix",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/ToeplitzMatrix"], "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["c", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["c", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"], ",", 
          SubscriptBox[
           StyleBox["c", "TI"], 
           StyleBox["m", "TI"]]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["r", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["r", "TI"], 
           StyleBox["2", "TR"]], ",", "\[Ellipsis]", ",", " ", 
          SubscriptBox[
           StyleBox["r", "TI"], 
           StyleBox["n", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the Toeplitz matrix with elements ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " down the first column, and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " across the first row."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->120885565]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The element ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["r", "TI"], "1"]], "InlineFormula"],
 " must be the same as ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["c", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 ". ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->516655824]
}], "Notes",
 CellID->150337515]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->19060650],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->168838952],

Cell["4\[Times]4 Toeplitz matrix:", "ExampleText",
 CellID->186515667],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToeplitzMatrix", "[", "4", "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->771626980],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "2", "3", "4"},
     {"2", "1", "2", "3"},
     {"3", "2", "1", "2"},
     {"4", "3", "2", "1"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$3628]]]], "Output",
 ImageSize->{76, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->88549512]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->190130345],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToeplitzMatrix", "[", 
   RowBox[{"{", 
    RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "}"}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->644590182],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"a", "b", "c", "d"},
     {"b", "a", "b", "c"},
     {"c", "b", "a", "b"},
     {"d", "c", "b", "a"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$3633]]]], "Output",
 ImageSize->{76, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->474707549]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->58909028],

Cell[TextData[{
 "Toeplitz matrix",
 " with first column ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["c", "TI"], 
     StyleBox["1", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 " and first row ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["c", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["r", "TI"], 
     StyleBox["2", "TR"]], ",", 
    StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->33573967],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToeplitzMatrix", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["c", "1"], ",", 
      SubscriptBox["c", "2"], ",", 
      SubscriptBox["c", "3"], ",", 
      SubscriptBox["c", "4"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["c", "1"], ",", 
      SubscriptBox["r", "2"], ",", 
      SubscriptBox["r", "3"], ",", 
      SubscriptBox["r", "4"]}], "}"}]}], "]"}], " ", "//", " ", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->112635235],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztl71SAjEQgMMdp/KjA2phyWv4AlrZOKM1DOMMFI6OUtBRUlJS8giUlJSU
lJSUlJSU5ybZ3IU1xyUe+DMjM5DbzSa72Ww+LneNTuvpudFpNxu127fGa6vd
fK/dvLyBys8xxurwvb5i8BzCk/jWwxDac/j1QaxC60F7ockBtGVhxbWMq0Px
EaN0uUJkai9nCYR2NBqh1kdfvM1DW0I5T0a76o+E3Ov1ND/KarFYTCaTSBtE
o4QNY542F8OYPltRjwWjlU+silZWRypL8/mcRj8cDvU1aaMC3L8S0euRsi/0
B8boNptNt9uNo/OVVgaYsCMkXzu8FB3787h6OW+/34dQ+KMXRefNZrPAmP9K
Zu2p8AplBcW17VXs2Gq1UmvI48kytXKWuD71WeJaflCZlscowepR+UY5t8Mq
lv+WFa9UE7GqKBesZpFZtydZlch2XoJwP2Qr4hrp6T+xikLM9q0s20Ubx7gP
yDTa75PxdntMo9wX02iFZshhJsqpN4SKlb8k2lVwFvzjEJ8zqxl/K4d+hnwm
4p1jbovWs7iQ7pLIx1ZeXMmXRLhDkO8wTEujjV3eXJnnyrRySv9hmGfLtD3+
bzjS7SLMQjkT3f6Jl91KnX5KukuUZT0MBoOds9CaTyMcveXKkxvfX3Uv8K69
Xq/DMJl4rmRTev6Gz2tLel8ul+PxmD/qb/5wZcDboh3psjKMnmtKD7kf0+nU
cCOCNOEK0uiRlWG0X9EnqpatW2LaDXtf7LK7YcdVG0fnwR6b95fSS7WcMx5k
W4xCT9srdKGWSVc2ZQ09yYsvf7wnsrSqa78s9wEkUHTi\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{96, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->38474212]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1293636265],

Cell["Machine-number Toeplitz matrix:", "ExampleText",
 CellID->217109417],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "[", 
   RowBox[{"ToeplitzMatrix", "[", "4", "]"}], "]"}], " ", "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->70636349],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1.`", "2.`", "3.`", "4.`"},
     {"2.`", "1.`", "2.`", "3.`"},
     {"3.`", "2.`", "1.`", "2.`"},
     {"4.`", "3.`", "2.`", "1.`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{104, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->401878461]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToeplitzMatrix", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1.", ",", "2.", ",", "4.", ",", "8."}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1.", ",", ".5", ",", ".25", ",", ".125"}], "}"}]}], "]"}], " ", 
  "//", "MatrixForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->59498748],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1.`", "0.5`", "0.25`", "0.125`"},
     {"2.`", "1.`", "0.5`", "0.25`"},
     {"4.`", "2.`", "1.`", "0.5`"},
     {"8.`", "4.`", "2.`", "1.`"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{146, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->280102406]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9753638],

Cell["20-digit-precision Toeplitz matrix:", "ExampleText",
 CellID->74590583],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"N", "[", 
   RowBox[{
    RowBox[{"ToeplitzMatrix", "[", "3", "]"}], ",", "20"}], "]"}], " ", "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->169939581],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1.`20.", "2.`20.", "3.`20."},
     {"2.`20.", "1.`20.", "2.`20."},
     {"3.`20.", "2.`20.", "1.`20."}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{481, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->255012646]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToeplitzMatrix", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1`20", ",", "2`20", ",", "4`20"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1`20", ",", ".5`20", ",", ".25`20"}], "}"}]}], "]"}], " ", "//",
   "MatrixForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->792865027],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1.`20.", "0.5`20.", "0.25`20."},
     {"2.`20.", "1.`20.", "0.5`20."},
     {"4.`20.", "2.`20.", "1.`20."}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{495, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->161504086]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->245868555],

Cell["Toeplitz matrices with complex entries:", "ExampleText",
 CellID->22453216],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToeplitzMatrix", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "+", 
      RowBox[{"2", " ", "I"}]}], ",", 
     RowBox[{"3", "+", 
      RowBox[{"4", " ", "I"}]}], ",", 
     RowBox[{"5", "+", 
      RowBox[{"6", " ", "I"}]}]}], "}"}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->199377755],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWDtTAjEQPu7BQ3RUGB8lvf9DK38E4zijhaODFnSUWDhDByU/gZKSkpKS
kpKSkvLcJBsuLstdvENwRp2BZJfN5tvNJl/ibf3t4f6p/vZ4V6/dNOovD493
r7Xr5waovJzjOF34XF060A+hJz/dMITW/A7Et9fv90P557xLudVqoexJK192
p9PpcDgUXSF74LAo9cKzss6jXrQFaA822BVR76NdCdoA2gKxC1AfoN0K7WQy
oeh6vZ6JOVh5kTa873grIZetfJU434aXI/J7OixKXi6XzWYzit7TWpWAtVx7
Rg6T5ziOGZ3HlY2LTK9YnuiLZJyS2+02ABdddxWLOx6P4/Jpny8aSzovSWsX
J0eRwsaB7fM1Ulmz8/lcY+F2itD7RK9RuRt2oONH8vfjYT2uxROdBWY80blB
c33CzBowa3RMZtP1RFFXiazrVKGDolJHmiW6UyKfh1xlmFZCvuCwr42q6pVG
VW4jIh/n4OqgjHrhjVv3MuoraEd3UJHMx6P4+Lcy1mObzKWZsErGF6zQSIb7
JSzEMyLdj3TuklWccdy1Tfb5LsulQ78fvqGxHVnNahehyMt+WEfz3WniTOnW
Kivv2PKYHTp+v6fjnzMrX1UrXPpUTMtCSSz2d1iq0+lYWEXvMtMK7hKLxSLE
OsnCPlqvbx363aZ232w2GwwGomveouDah68vesrukk/4UfwO4G/ko9GIuZFD
YjFmGt1PcUucvW0sUE1f3lH0RUyZaDeckm4UPQOiiFyou6Sa2x6PHIZqT4iX
C/cCE/Yu1IrMNWY4yrhPcGTljUNit+k9VSA4PAOdempy6LIwxznxRd9SFTK3
QpSVKcph/HtJ5gv/x+XkPgH9jStU\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->182107324]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToeplitzMatrix", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "I"}]}], ",", 
      RowBox[{"3", "+", 
       RowBox[{"4", " ", "I"}]}], ",", 
      RowBox[{"5", "+", 
       RowBox[{"6", " ", "I"}]}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "+", 
       RowBox[{"2", " ", "I"}]}], ",", 
      RowBox[{"3", "+", 
       RowBox[{"4", " ", "I"}]}], ",", 
      RowBox[{"5", "+", 
       RowBox[{"6", " ", "I"}]}]}], "}"}]}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->44515224],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWL1uwjAQDvnhp6GiBZV2ZO97tFMfIkKVYKhaUQY2RjpUYoORR2BkZGRk
ZGRkZGRMz/aFmMMJJgRRqa0E9h2X83e+s79cX7x24/XNazfrXu255X00mvXP
2tN7C1RWxjCMAXweHwyY+zDjn4Hvwyh/O+zbGo1GPv8zvrjc7XZRtriVzaeL
xWIymbApky1wmOd65llYZ1HPxhyMVxF2edTbaFeA0YExR+wc1Dtot0U7n88p
uuFwKGN2tl64jdp3vBWTXS1fBZVvycs1+T0ZFiFvNptOpxNGbwVasQF7e21J
e3h4jVLM01nMbFxkQcayRJ8nzwm51+sBcDY1t7GYs9ksbj/194vGkszLodzF
yWGkcHDg+OxGymt2tVoFWFQnheltog9QmREn0LBD+fh4lB734gnvAjme8N6g
e32jWNVR5KhEVgvqiaKuEDmoU4EOikpcaZrobolc9VWVIVsx+V6Ffe+pSpBp
VGUiEdm4hqoOXNQzb6q8u6gvox09QXmynhrF97+VlI80mUuXCXNa6Djj/RJW
SochC1pxx3Fbmux0LAsmQ38ZPkqHFfUiZvt0GZZKzo/Jcnkqb+nyoB469f2Q
jL/utHxVtHAFt2pSFjvEgn+H5fr9voZV2NfJVvAusl6vfayTNNkryo72heK0
LpfL8XjMpvJbGrxWYndHb+lL8pOeFz1EYnem06miI4DE4J7Q6M/FXXH2urFA
Ne70cbQjpxxzGc5Kxwu9Y8KITajbQzV7Pt4q+sd1kOx5E2qN5wr3IsyYTbyc
yltFYhfVD+YIDktCJ1plFbpTmKtKfNFesEzWFohOZSrXj+/3+H7h/+iMzA+f
x5bo\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{150, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->555719761]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->123587516],

Cell["Nonsquare Toeplitz matrices:", "ExampleText",
 CellID->106017548],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToeplitzMatrix", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "6", ",", "7"}], "}"}]}], "]"}], " ", "//", " ", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->162840172],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "6", "7"},
     {"2", "1", "6"},
     {"3", "2", "1"},
     {"4", "3", "2"},
     {"5", "4", "3"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{61, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->380411024]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToeplitzMatrix", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", "4", ",", "5", ",", "6", ",", "7"}], "}"}]}], "]"}], 
  " ", "//", " ", "MatrixForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->405684640],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"1", "4", "5", "6", "7"},
     {"2", "1", "4", "5", "6"},
     {"3", "2", "1", "4", "5"}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 ImageSize->{91, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->361594962]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->4337000],

Cell["A common symbolic notation for Toeplitz matrices:", "ExampleText",
 CellID->488156585],

Cell[BoxData[
 RowBox[{
  RowBox[{"tm", "[", "n_", "]"}], ":=", 
  RowBox[{"ToeplitzMatrix", "[", 
   RowBox[{
    RowBox[{"Array", "[", 
     RowBox[{
      RowBox[{
       SubscriptBox["t", 
        RowBox[{"#", "-", "1"}]], "&"}], ",", 
      RowBox[{"{", "n", "}"}]}], "]"}], ",", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"{", 
       SubscriptBox["t", "0"], "}"}], ",", 
      RowBox[{"Array", "[", 
       RowBox[{
        RowBox[{
         SubscriptBox["t", 
          RowBox[{"-", "#"}]], "&"}], ",", 
        RowBox[{"{", 
         RowBox[{"n", "-", "1"}], "}"}]}], "]"}]}], "]"}]}], "]"}]}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->531724818],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"tm", "[", "5", "]"}], " ", "//", " ", "MatrixForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->210977478],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztmb2S2jAQgI2Mj587JnDkCEl1T5NMijwEc5OZuyKTzOUKOpfMVZQueQRK
l5SUlJSUlJSUzq4kI7EIWzY6JpPADJa03pV25dVnjfxt8PL4/cfg5elhcP/l
efDr8enh9/3nn88g8iue573C/2vfg3oCNf5/TRIoxfUWrj4IO1AyKPuy3YMy
gPIDaqEg4T+u53kBl04mEym9Jlq3pH1H2n3S7mltuHo3vB2Gobzvc3mVV5fL
ZRzHWA2krwzKqrTCtm/wuYycGb2CqBeLBfUqiiJpzduNXW/CVr+KfgKiceDF
O6MWI1pte618n/ztdjscDlVsfioV4cnnrvrFWNnOWsn1WDyZXUXuV03+Z9i3
eHs0GoGrWGU779l8Pr8i1jSKZsHRbbzDWaGrgNqJWYNkhpTe95rn03q9NnlL
e6UrNK/dTfZXkT6qWnHoK6ZVW5Z3R0rhDUy7gMGR3lzH8D6dI9muGEcNSftf
1ELyYq7hU83i9icpr1v12iLWNMPz+I2jVw0cshv9KjFzuSzfKcfTd169lHc8
l3Pp3TRqvRW9O8Z+auXjy2BtUdYXZTm1bziJgnpBdyyumE7t6tKuWcprN5zM
G9WW9d2/OIbwP9DCnE336lmM70m9hnWvh/uD4mzvSLncOnJ1u6wvy3tbrt8c
kZ/Cexr9tZWWK5KbRzsP713znOZfndjbZXFR3p/Kc7pDcvOWuvD+wnslRXoG
hhylnMcZtN9j0PWsr8+ifO9KGSV0zcqTPO6fyvezcf9sRDdr0fjsZr8MMV1y
neahG+6nXKd8dsV1GtWF+xfuu9aiKyN9LpT3HxOdb+PxOLNXPXNTmp7K+fYR
uSCQ+j6gexRF0WazwWrKf8r5VuKG86m8Jr0UXq1Wq+l0ilX9rDKOY3mqz/O6
xPn9WxLdfJqkn2srq9lsZjhPhimXURfd77vmuql/pmfx3hm+8etKgbeWK67T
+/SbgXgWarUp7xnklWtWoj2D58mjl09UzRGObcP5DrHztd7Ex4ed1LHvB/17
+jdJr/IHXBsMaw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{137, 73},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->77979798]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2123667759],

Cell["Size-20 Toeplitz matrix:", "ExampleText",
 CellID->462478930],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixPlot", "[", 
  RowBox[{"ToeplitzMatrix", "[", "20", "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->439346617],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztnL9vEzEUx51cErtCCKksFFpIGfkbmGHq34CiCqkdKFXboRLqUIYOdIIB
oU5IrIxFYmJlQUgICTEABUH50aVTly7He47TvNjvUhPu0jR5kXqOc777fHPx
e89+9d1MY2Xu9p3Gyvxso35zqbE4Nz+7XL9xdwk+SkpKqW34e3lBwfsU3tm/
7TSFMtyOwzaBBhOurLuyDGUZysuuriq2uXtNQaVCWo3bnedxi41T+1KXvDqe
S1Xa9ebxtMWkV0+4M1ab9aNtcJZzfVIzeewZ+qVkitTjr8iE+/Wm4/jtFu64
es9UWq/H0auUrlzPVDV6XLffYNxpnnTlFVcmabufl103L7seTvc3e3iWFZ2F
7ZZqlm5LFFS8+kWvfvWY+vQx5zszQNTHbCvqK6peC50uKHO4rPTBqtL7a8rs
rZf07kZJ72yWzKdHWn/ZmtBfn10z359f17svZsyvV7f0n9eL+vebe+bn2/v6
x7sH+tv7h2bnwxP9+eNT3zYoO2l2kRrtL3yv8euFqBzz+jTdWgXozEtY2s/K
ra9zdMCJqPZ5gaJO1fQYzktgHat5a+2MWFVGxb/r7Oe15fR0Ko7xfn1Rndkn
M3Qn7V+m5V/74hWCCJak1C/4vqzoX5j3oBqIxhE1EI0jaiAaR9RANEDUQDSO
qIFoHFED0QARS6EKdUSoQDSOiHZqHBHt1DgitVPjiGinxhHRTq29Ql2oQh0R
akR0o3bKRTdrr6gAPheqUIVaIDUiplLvwMVUqwA/h/1CFepwUpsTy9ar1SSY
bUZEWmq9XKS1n+N+aBfONsMcenPO6c/P2QxL0Uq78HA/k4UaOsU2A5Wz0s7f
28+fZugMchR96avZOb2UZkjsviATXzsJhYEKd7FJbqmVy/evfPHWTv+TYNWG
3i9irEC9HjdWsPuxHbSP9LlCFapQe6FGjFCor+BGKNanoEI4TqhCHRFqRISl
dspFWKsQj4PjhSrUEaFGRDdqp1x0s8fh8XAeoQpVqPlRO+f3meubIiIt9Rlc
pLU+B78PfC8+t9S5wqmHlUJFqMzOKqje1zfZTE3OaplMTS5aT+cVFtV5qI5a
5VS4b4hY5RQxnqE+khvP2O+B4yMYJ0V6aKEK9bRTI0YW1Gq5kYUdqeCcHObm
QhWqUAukRkRY6h24CGszAZh93tksCVWoI0KNiKnUTrmYarPP+F/X3Q2hCnVI
qTjDS7iZXkSUo/bKRTn7n09cMbW3HtDxrbEKjLcnmBsXrcSrV0+ZKptfyllN
9r1obS24iobNERRxZYIcgTnSQNnBypkitAQrecZsqdOM1TsF95RWJlXzXqRg
eobvioj01Gdxkd6uesKVyvtrgTUIVahDSo2I9NROuUhvVyrjPTkHq0IV6qhQ
I6IbtVMuutm7Y/A+0MNloQpVqDlScayecOPjiNhKvQQXW+1dqPjkg3RB8esN
mqNj7bF9pYVo6TKLrGWqsppzVtP9/o5sLYN5hUQVrypzXl64nbXn5YPxbKf+
UdvP0sp64pY8ve5/1cjT63ql0no9jj6gT69Tpb+3N1AN\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 184},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->691909814]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30658091],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ToeplitzMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToeplitzMatrix"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["c", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["c", "TI"], 
      StyleBox["2", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
 " is Hermitian if ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["c", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 " is real:"
}], "ExampleText",
 CellID->960474342],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"Join", "[", 
    RowBox[{
     RowBox[{"RandomReal", "[", 
      RowBox[{"1", ",", "1"}], "]"}], ",", 
     RowBox[{"RandomComplex", "[", 
      RowBox[{
       RowBox[{"1", "+", "I"}], ",", "2"}], "]"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"t", "=", 
   RowBox[{"ToeplitzMatrix", "[", "c", "]"}]}], ";"}], "\n", 
 RowBox[{"MatrixForm", "[", "t", "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->34602517],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW71PGzEUd+4jgQQoTVWJoQN7h6qo/AcVnfpHRKgSDFUrysDGyMiYkT+B
oUOWVoyMjIyMjIwZXX9d7uXds89OrhcSDonc2bGf38fPz/YP83VwevTt++D0
+HCw++Vk8PPo+PDX7sGPE1EVtxhr/WGMvd9h4p2LN/Urf/6KX/2K31L5GV9d
Xal2XH1zrerOz89NXaxaJur1/v5+NBrJV1mOma6PmJaUleWzjcqRecbmua7k
ZRryqfYR6Iflyv4pkCP7dcTzNerfMWWjvvqJUT+sV2r6ufRKgV6wXYzkpEh+
pmfXYqdN34jTflgr0bNjxvuQRfju7g5HczgcwhinE2lGhRjoWPw2ImvbSC/V
N8nLxkDkOWwJLKdO3TrWb92jRlS5IAeiQZb7Tl3W6FGdepT7B2uKEer2Dx27
xMt63KpdqiucFVJCz6kbaUk5VmaINp6tbp/B3CTrP6ryeDw+OzubaGHGELV6
Glk8vU7W0v6WtW2UAxJQnkQK4wd5KMs/xRE2aU/VNlPWjYVlmG6zYobFfVKn
pbTf7XEvsxjGxaZNOfI3CTvLfOGXQe2e2EKa7anyxcWFgO7EEo3929vbEG/a
UTxfrdQlseWHQuuuaR0ygl/+88d0FbmT1Ck471eNe1+PYl/R+HfHisplsnXY
umP3DT0TxIZWbGsn9hrZIqk/Pj5O4kL6OWFsah9cllkj04dexeaJL5ScMPvu
FO4a7YjuFjSn5EWk1XCfXCl6E1hrs7EYAcpqGpv02EWp/nMpAhHB+/UQhOan
LojQ/ITm2Hng/OKcc1SZ3G8UpLwK8GjZDgbv/+lcka3+NIJ7yAryVGLJfFR7
rHOIvcXshbFA+txqcQh6sWTPVWiqxRtS8obRRiNUbCU0iRCE0C4am86LZQj1
OyOERKxsZSZ3pgUp78hajMxZdy1+rXggVu37MZf9fnq9DdDDT2LonhLqvE22
+qxa5bxIi1NozriYDT7NacnZla19kNvJvs84qh63c1uQY8IZvG/qN3m+tsD+
baJelvto3Oy8gMftoP54/B6SQ40Hn5kd2+AJ5e0hv9Lelh+/m5YlLSGWGv4z
5z8/VeSXbV6tHzpeUaXXzYZvpFYixlaFb9x3tq4n6vSu4XlEWftrtrnTMJBF
O+tmIGl8v5zIzIvfhm1cRrbRjvo64hlyCqw/fvPMiIatzGsXy1bSCP8f8QlG
c4XxmAerDS9ZzG+0LvPykjQWV9n/VeKyYSVnt7R6VvKArH25MVMz35sRWxW2
dH/B9qx5eV1+LANfOkvLy8tLz5b5jVrYcjgcPj09cYDNl86CYjY49BZxn9N+
9L01rNmQh4eH62t17Rn+9XI0Gpk7s24WtmEV7S2WiVV0c8f13oHecupS751n
FbP45uaGuCUl0pmZObR/GrZx8WxjyLls9e8lazSLlXzq9qvf/0M0fGJeft58
YjWYn/9slzDbzaP6bi1rxOe71BzxkdjfhPyVoWEXF8n2VnvbOPQsP8vtYhnB
SOwPlLamV55jafQ2fOEz4GuxzNJ4LNutYZ1b0HpvEKqv/dtlNNwgbsUDkVw/
n7vaN413+DRuNZpXjX/M+td961atG6qg/2eetf4Bu5Sd0Q==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{444, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->473142220]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HermitianMatrixQ", "[", "t", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->108605986],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->15616036]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " has all real eigenvalues:"
}], "ExampleText",
 CellID->89844012],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", "=", 
  RowBox[{"Eigenvalues", "[", "t", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->50496672],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.3665084530275986`", ",", "0.7334134460641653`", ",", 
   RowBox[{"-", "0.27111263909716027`"}]}], "}"}]], "Output",
 ImageSize->{210, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->349487494]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " is diagonalizable by a unitary matrix:"
}], "ExampleText",
 CellID->171758757],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"u", "=", 
   RowBox[{"Transpose", "[", 
    RowBox[{"Eigenvectors", "[", "t", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"Chop", "[", 
   RowBox[{
    RowBox[{"ConjugateTranspose", "[", "u", "]"}], ".", "t", ".", "u"}], 
   "]"}], " ", "//", " ", "MatrixForm"}]}], "Input",
 CellLabel->"In[4]:=",
 CellID->186739251],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {"2.3665084530275995`", "0", "0"},
     {"0", "0.7334134460641648`", "0"},
     {"0", "0", 
      RowBox[{"-", "0.2711126390971602`"}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$, BoxForm`opts$3676]]]], "Output",
 ImageSize->{209, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]//MatrixForm=",
 CellID->465541343]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->50101003],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ToeplitzMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ToeplitzMatrix"], "[", 
   StyleBox[
    RowBox[{"c", ",", "r"}], "TI"], "]"}]], "InlineFormula"],
 " is a circulant matrix when ",
 Cell[BoxData[
  RowBox[{
   StyleBox["r", "TI"], "=", 
   RowBox[{
    ButtonBox["RotateRight",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/RotateRight"], "[", 
    RowBox[{
     ButtonBox["Reverse",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Reverse"], "[", 
     StyleBox["c", "TI"], "]"}], "]"}]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->84123990],

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "4"}], ";"}], "\n", 
 RowBox[{
  RowBox[{"c", " ", "=", " ", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", "n"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"r", "=", 
   RowBox[{"RotateRight", "[", 
    RowBox[{"Reverse", "[", "c", "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"t", "=", 
   RowBox[{"ToeplitzMatrix", "[", 
    RowBox[{"c", ",", "r"}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->241435709],

Cell[TextData[{
 "The eigenvalues ",
 Cell[BoxData[
  FormBox["v", TraditionalForm]], "InlineMath"],
 " can be found from:"
}], "ExampleText",
 CellID->98420419],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"v", " ", "=", " ", 
  RowBox[{"Chop", "[", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Block", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"\[Omega]", "=", 
         RowBox[{"2.", "\[Pi]", " ", "I", " ", 
          RowBox[{"j", "/", "n"}]}]}], "}"}], ",", 
       RowBox[{"r", ".", 
        RowBox[{"Exp", "[", 
         RowBox[{"\[Omega]", " ", 
          RowBox[{"Range", "[", 
           RowBox[{"0", ",", 
            RowBox[{"n", "-", "1"}]}], "]"}]}], "]"}]}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0", ",", 
       RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->328596080],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"2.638360109170814`", ",", 
   RowBox[{"0.2717898562868285`", "\[InvisibleSpace]", "-", 
    RowBox[{"0.07378388970347938`", " ", "\[ImaginaryI]"}]}], ",", 
   "0.37997506516236257`", ",", 
   RowBox[{"0.27178985628682883`", "\[InvisibleSpace]", "+", 
    RowBox[{"0.07378388970347971`", " ", "\[ImaginaryI]"}]}]}], 
  "}"}]], "Output",
 ImageSize->{428, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->448758431]
}, Open  ]],

Cell[TextData[{
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{"t", "=", 
    RowBox[{"F", ".", "\[CapitalLambda]", ".", 
     SuperscriptBox["F", "\[ConjugateTranspose]"]}]}], TraditionalForm]], 
  "InlineMath"],
 " where ",
 Cell[BoxData[
  FormBox["F", TraditionalForm]], "InlineMath"],
 " is the ",
 Cell[BoxData[
  ButtonBox["Fourier",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fourier"]], "InlineFormula"],
 " matrix and ",
 Cell[BoxData[
  FormBox["\[CapitalLambda]", TraditionalForm]], "InlineMath"],
 " is ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["DiagonalMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DiagonalMatrix"], "[", 
   StyleBox["v", "TI"], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->7025968],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"Abs", "[", 
   RowBox[{"t", " ", "-", 
    RowBox[{"Map", "[", 
     RowBox[{"Fourier", ",", 
      RowBox[{"ConjugateTranspose", "[", 
       RowBox[{"Map", "[", 
        RowBox[{"Fourier", ",", 
         RowBox[{"DiagonalMatrix", "[", "v", "]"}]}], "]"}], "]"}]}], "]"}]}],
    "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->29433403],

Cell[BoxData["0.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->510309791]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->581219043],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HankelMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HankelMatrix"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ToeplitzMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ToeplitzMatrix"]], "InlineFormula"],
 " are related by reversed identity matrix: "
}], "ExampleText",
 CellID->222524165],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"h", "=", 
    RowBox[{"HankelMatrix", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["a", "2"], ",", 
        SubscriptBox["a", "1"], ",", 
        SubscriptBox["a", "0"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox["a", "0"], ",", 
        SubscriptBox["a", 
         RowBox[{"-", "1"}]], ",", 
        SubscriptBox["a", 
         RowBox[{"-", "2"}]]}], "}"}]}], "]"}]}], ")"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->360176644],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdVjtPAzEMTu9BgfLog5eY2PkfMCBGfkCFkGBAIGDo1rFjx479CR07duzY
sWPHjh07HnbscDnjwqETCKjUJPbZzpf4EV82X25v7psvd9fNk/On5uPt3fXz
ydnDE7DCkjHmCv6nRwbWCazs/ypJYKaxjmOIXPsz+zDEQB7AjOxtKxVbqX6/
z1IbnhaM1koEcyCs1ZhvQhLEcd3KtNttlqFPkV1Op9PhcIjLiHHQB7fRFnPL
Yp/KCv6awz2ZTORevV7PRxC/afGZ/LMgXVGl1sWOm7mkCNdyuWy1Wimu0HEJ
GuH8VlxlYYu0Op0OgMBl8IYrGI/Ha+zNULn9iK0FHDORgoF2AweDm7PWrTfm
8/nqU1dV7r7KpZhOY8nfJ407jOmQpXE+5LnhvEDhvkL7wqFmuvSBVEr/RymM
rNi8ryTHzJf5rlvZEto1jzbsHa3C5LMeMxap7epGtsrUEr2a5NtLj1+ZM3o+
ytzWo17m1d/Ghb5xnvWrh0RWTbJVZrPAqb9STRq5T6FVk71c2r81t39eqsL3
5nLwMMlGge1Hwm63+6kVX6sh6AOPRh/vWDrtb3yrUOMXi0WSo4pIfjXRqgud
YDabDQYDXPrvCzxY3KkUyVYptatKyZwmXKPRSHmd4QIYbZGepAgu8HimJ5E9
HNIf9SauutRXyNH7k0ZQuksAHileRTCeA7hDCoVYoEc0WvWoK3JOm9olXJ4L
mqT8Lt+UXgHpP8ZJ\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{85, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->253149802]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToeplitzMatrix", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["a", "0"], ",", 
      SubscriptBox["a", "1"], ",", 
      SubscriptBox["a", "2"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["a", "0"], ",", 
      SubscriptBox["a", 
       RowBox[{"-", "1"}]], ",", 
      SubscriptBox["a", 
       RowBox[{"-", "2"}]]}], "}"}]}], "]"}], "//", "MatrixForm"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16341238],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdVj1TAjEQDfchyMHIh6JjRe//kMKx5AfcMMxA4eggBR0lJSUlP4GSkpKS
kpKSkpIybpINyYXceYo6DszcJXnsbV6ym5d9Dvud9kvY77bCeqMXvnW6rff6
42sPIDdDCGnC83BHoE+hx58mpdCKdxneLhGtD+0tQxlA+Y/jhPgcnU6niF4a
VlVjXNPG8CYFPh4Oh/i/y3GPd9fr9Xw+Z10POTiGtyAGLyEuHMnJCpLrarUy
55pMJjoD/+ALebrGDPlUVldWK52t2oP9fj8YDBQvV6KCmuD5qa/gB3kV+Xg0
GgEJ1nUOvJzlcnkBrWfxHSDOrB1oKzF2YtUQYAhz1DuPxna7jV91yYreWNEK
jeaSPo/KO5bHLlq7mO2srcooiBSP+fpJssZxJsFKjc/Rip0L/7DrKtr3iOdS
eSkYX5e1McHoeOT43Kfz7tNkNYmqhtS/7LfmsudvOjUxz6M963NnxYvFRleP
IrWrRwnxLNrlT1j1V9SkmnoVNjW5TvX1fz3bf29l6gCLCQtJDfdTVBvj8TjR
S6B5kTeCTT3KiOMFzM1FXqn6Rp8B9H6321FNUY7rDZtyBDG4GG82m9lsxrr6
XQOXF1Ytp9QB5pm0n2/TSvBaLBaWmxo2ANn+Pq+s4Ssnox+pT8x6zqPJdYpU
EKk09tWrbFKzOBCR0xWFZZ0DeyhSxzfYM9Y2JalY7OTXonRi3YYxFlZ6lU8y
H9Umxkk=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{85, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]//MatrixForm=",
 CellID->10998382]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"Reverse", "[", 
    RowBox[{"IdentityMatrix", "[", "3", "]"}], "]"}], ".", "h"}], "//", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->44023477],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzdVj1TAjEQDfchyMHIh6JjRe//kMKx5AfcMMxA4eggBR0lJSUlP4GSkpKS
kpKSkpIybpINyYXceYo6DszcJXnsbV6ym5d9Dvud9kvY77bCeqMXvnW6rff6
42sPIDdDCGnC83BHoE+hx58mpdCKdxneLhGtD+0tQxlA+Y/jhPgcnU6niF4a
VlVjXNPG8CYFPh4Oh/i/y3GPd9fr9Xw+Z10POTiGtyAGLyEuHMnJCpLrarUy
55pMJjoD/+ALebrGDPlUVldWK52t2oP9fj8YDBQvV6KCmuD5qa/gB3kV+Xg0
GgEJ1nUOvJzlcnkBrWfxHSDOrB1oKzF2YtUQYAhz1DuPxna7jV91yYreWNEK
jeaSPo/KO5bHLlq7mO2srcooiBSP+fpJssZxJsFKjc/Rip0L/7DrKtr3iOdS
eSkYX5e1McHoeOT43Kfz7tNkNYmqhtS/7LfmsudvOjUxz6M963NnxYvFRleP
IrWrRwnxLNrlT1j1V9SkmnoVNjW5TvX1fz3bf29l6gCLCQtJDfdTVBvj8TjR
S6B5kTeCTT3KiOMFzM1FXqn6Rp8B9H6321FNUY7rDZtyBDG4GG82m9lsxrr6
XQOXF1Ytp9QB5pm0n2/TSvBaLBaWmxo2ANn+Pq+s4Ssnox+pT8x6zqPJdYpU
EKk09tWrbFKzOBCR0xWFZZ0DeyhSxzfYM9Y2JalY7OTXonRi3YYxFlZ6lU8y
H9Umxkk=\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{85, 43},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]//MatrixForm=",
 CellID->1278536]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1305812373],

Cell[TextData[{
 "When  ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["r", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 " is not the same as ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["c", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 ", the value of ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["c", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 " is used and  ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["r", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 " ignored:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->516655824],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ToeplitzMatrix", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["c", "1"], ",", 
      SubscriptBox["c", "2"], ",", 
      SubscriptBox["c", "3"], ",", 
      SubscriptBox["c", "4"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["r", "1"], ",", 
      SubscriptBox["r", "2"], ",", 
      SubscriptBox["r", "3"], ",", 
      SubscriptBox["r", "4"]}], "}"}]}], "]"}], " ", "//", " ", 
  "MatrixForm"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->7437777],

Cell[BoxData[
 RowBox[{
  RowBox[{"ToeplitzMatrix", "::", "\<\"crs\"\>"}], ":", 
  " ", "\<\"Warning: The column element \\!\\(c\\_1\\) and row element \
\\!\\(r\\_1\\) at positions \\!\\(1\\) and \\!\\(1\\) are not the same. Using \
column element.\"\>"}]], "Message", "MSG",
 CellID->555982437],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztl71SAjEQgMMdp/KjA2phyWv4AlrZOKM1DOMMFI6OUtBRUlJS8giUlJSU
lJSUlJSU5ybZ3IU1xyUe+DMjM5DbzSa72Ww+LneNTuvpudFpNxu127fGa6vd
fK/dvLyBys8xxurwvb5i8BzCk/jWwxDac/j1QaxC60F7ockBtGVhxbWMq0Px
EaN0uUJkai9nCYR2NBqh1kdfvM1DW0I5T0a76o+E3Ov1ND/KarFYTCaTSBtE
o4QNY542F8OYPltRjwWjlU+silZWRypL8/mcRj8cDvU1aaMC3L8S0euRsi/0
B8boNptNt9uNo/OVVgaYsCMkXzu8FB3787h6OW+/34dQ+KMXRefNZrPAmP9K
Zu2p8AplBcW17VXs2Gq1UmvI48kytXKWuD71WeJaflCZlscowepR+UY5t8Mq
lv+WFa9UE7GqKBesZpFZtydZlch2XoJwP2Qr4hrp6T+xikLM9q0s20Ubx7gP
yDTa75PxdntMo9wX02iFZshhJsqpN4SKlb8k2lVwFvzjEJ8zqxl/K4d+hnwm
4p1jbovWs7iQ7pLIx1ZeXMmXRLhDkO8wTEujjV3eXJnnyrRySv9hmGfLtD3+
bzjS7SLMQjkT3f6Jl91KnX5KukuUZT0MBoOds9CaTyMcveXKkxvfX3Uv8K69
Xq/DMJl4rmRTev6Gz2tLel8ul+PxmD/qb/5wZcDboh3psjKMnmtKD7kf0+nU
cCOCNOEK0uiRlWG0X9EnqpatW2LaDXtf7LK7YcdVG0fnwR6b95fSS7WcMx5k
W4xCT9srdKGWSVc2ZQ09yYsvf7wnsrSqa78s9wEkUHTi\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{96, 57},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]//MatrixForm=",
 CellID->134944639]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->589267740],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot3D", "[", 
  RowBox[{
   RowBox[{"ToeplitzMatrix", "[", "15", "]"}], ",", 
   RowBox[{"InterpolationOrder", "\[Rule]", "0"}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->176375359],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{275, 226},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->226006036]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["HankelMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HankelMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HilbertMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/HilbertMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Table",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Table"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PadRight",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadRight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Band",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Band"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->15690418]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Constructing Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ConstructingMatrices"]], "MoreAbout",
 CellID->11222202],

Cell[TextData[ButtonBox["New in 6.0: Matrix & Linear Algebra Functions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60MatrixAndLinearAlgebraFunctions"]], "MoreAbout",
 CellID->568955236]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ToeplitzMatrix - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 26, 56.0359240}", "context" -> "System`", 
    "keywords" -> {
     "Toeplitz", "circulant matrices", "constant diagonal matrices", 
      "structured matrix", "matrix constructor"}, "index" -> True, "label" -> 
    "Mathematica Symbol", "language" -> "en", "paclet" -> "", "status" -> 
    "None", "summary" -> 
    "ToeplitzMatrix[n] gives the n*n Toeplitz matrix with first row and first \
column being successive integers. ToeplitzMatrix[{c_1, c_2, ..., c_n}] gives \
the Toeplitz matrix whose first column consists of elements c_1, c_2, .... \
ToeplitzMatrix[{c_1, c_2, ..., c_m}, {r_1, r_2, ..., r_n}] gives the Toeplitz \
matrix with elements c_i down the first column, and r_i across the first \
row.", "synonyms" -> {"Toeplitz matrix"}, "title" -> "ToeplitzMatrix", "type" -> 
    "Symbol", "uri" -> "ref/ToeplitzMatrix"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6450, 211, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->19060650]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 56831, 1734}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1794, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2417, 68, 57, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2477, 71, 3057, 98, 70, "Usage",
 CellID->120885565]
}, Open  ]],
Cell[CellGroupData[{
Cell[5571, 174, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[6049, 191, 364, 15, 70, "Notes",
 CellID->150337515]
}, Closed]],
Cell[CellGroupData[{
Cell[6450, 211, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->19060650],
Cell[CellGroupData[{
Cell[6834, 225, 148, 5, 70, "ExampleSection",
 CellID->168838952],
Cell[6985, 232, 70, 1, 70, "ExampleText",
 CellID->186515667],
Cell[CellGroupData[{
Cell[7080, 237, 143, 4, 28, "Input",
 CellID->771626980],
Cell[7226, 243, 817, 24, 92, "Output",
 CellID->88549512]
}, Open  ]],
Cell[8058, 270, 125, 3, 70, "ExampleDelimiter",
 CellID->190130345],
Cell[CellGroupData[{
Cell[8208, 277, 215, 7, 70, "Input",
 CellID->644590182],
Cell[8426, 286, 818, 24, 92, "Output",
 CellID->474707549]
}, Open  ]],
Cell[9259, 313, 124, 3, 70, "ExampleDelimiter",
 CellID->58909028],
Cell[9386, 318, 568, 23, 70, "ExampleText",
 CellID->33573967],
Cell[CellGroupData[{
Cell[9979, 345, 530, 18, 28, "Input",
 CellID->112635235],
Cell[10512, 365, 1059, 21, 92, "Output",
 Evaluatable->False,
 CellID->38474212]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11620, 392, 221, 7, 70, "ExampleSection",
 CellID->1293636265],
Cell[11844, 401, 74, 1, 70, "ExampleText",
 CellID->217109417],
Cell[CellGroupData[{
Cell[11943, 406, 179, 6, 70, "Input",
 CellID->70636349],
Cell[12125, 414, 832, 24, 92, "Output",
 CellID->401878461]
}, Open  ]],
Cell[CellGroupData[{
Cell[12994, 443, 327, 10, 70, "Input",
 CellID->59498748],
Cell[13324, 455, 842, 24, 92, "Output",
 CellID->280102406]
}, Open  ]],
Cell[14181, 482, 123, 3, 70, "ExampleDelimiter",
 CellID->9753638],
Cell[14307, 487, 77, 1, 70, "ExampleText",
 CellID->74590583],
Cell[CellGroupData[{
Cell[14409, 492, 206, 7, 70, "Input",
 CellID->169939581],
Cell[14618, 501, 803, 23, 78, "Output",
 CellID->255012646]
}, Open  ]],
Cell[CellGroupData[{
Cell[15458, 529, 318, 10, 70, "Input",
 CellID->792865027],
Cell[15779, 541, 807, 23, 78, "Output",
 CellID->161504086]
}, Open  ]],
Cell[16601, 567, 125, 3, 70, "ExampleDelimiter",
 CellID->245868555],
Cell[16729, 572, 81, 1, 70, "ExampleText",
 CellID->22453216],
Cell[CellGroupData[{
Cell[16835, 577, 364, 13, 70, "Input",
 CellID->199377755],
Cell[17202, 592, 1106, 22, 70, "Output",
 Evaluatable->False,
 CellID->182107324]
}, Open  ]],
Cell[CellGroupData[{
Cell[18345, 619, 621, 22, 70, "Input",
 CellID->44515224],
Cell[18969, 643, 1082, 22, 70, "Output",
 Evaluatable->False,
 CellID->555719761]
}, Open  ]],
Cell[20066, 668, 125, 3, 70, "ExampleDelimiter",
 CellID->123587516],
Cell[20194, 673, 71, 1, 70, "ExampleText",
 CellID->106017548],
Cell[CellGroupData[{
Cell[20290, 678, 322, 10, 70, "Input",
 CellID->162840172],
Cell[20615, 690, 801, 25, 108, "Output",
 CellID->380411024]
}, Open  ]],
Cell[CellGroupData[{
Cell[21453, 720, 322, 10, 70, "Input",
 CellID->405684640],
Cell[21778, 732, 787, 23, 78, "Output",
 CellID->361594962]
}, Open  ]],
Cell[22580, 758, 123, 3, 70, "ExampleDelimiter",
 CellID->4337000],
Cell[22706, 763, 92, 1, 70, "ExampleText",
 CellID->488156585],
Cell[22801, 766, 670, 24, 70, "Input",
 CellID->531724818],
Cell[CellGroupData[{
Cell[23496, 794, 141, 4, 70, "Input",
 CellID->210977478],
Cell[23640, 800, 1276, 25, 70, "Output",
 Evaluatable->False,
 CellID->77979798]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24965, 831, 238, 7, 70, "ExampleSection",
 CellID->2123667759],
Cell[25206, 840, 67, 1, 70, "ExampleText",
 CellID->462478930],
Cell[CellGroupData[{
Cell[25298, 845, 148, 4, 70, "Input",
 CellID->439346617],
Cell[25449, 851, 1782, 33, 70, "Output",
 Evaluatable->False,
 CellID->691909814]
}, Open  ]],
Cell[27246, 887, 124, 3, 70, "ExampleDelimiter",
 CellID->30658091],
Cell[27373, 892, 584, 22, 70, "ExampleText",
 CellID->960474342],
Cell[CellGroupData[{
Cell[27982, 918, 473, 15, 70, "Input",
 CellID->34602517],
Cell[28458, 935, 1858, 34, 70, "Output",
 Evaluatable->False,
 CellID->473142220]
}, Open  ]],
Cell[CellGroupData[{
Cell[30353, 974, 112, 3, 70, "Input",
 CellID->108605986],
Cell[30468, 979, 160, 5, 36, "Output",
 CellID->15616036]
}, Open  ]],
Cell[30643, 987, 140, 5, 70, "ExampleText",
 CellID->89844012],
Cell[CellGroupData[{
Cell[30808, 996, 129, 4, 70, "Input",
 CellID->50496672],
Cell[30940, 1002, 288, 8, 36, "Output",
 CellID->349487494]
}, Open  ]],
Cell[31243, 1013, 154, 5, 70, "ExampleText",
 CellID->171758757],
Cell[CellGroupData[{
Cell[31422, 1022, 359, 11, 70, "Input",
 CellID->186739251],
Cell[31784, 1035, 853, 24, 78, "Output",
 CellID->465541343]
}, Open  ]],
Cell[32652, 1062, 124, 3, 70, "ExampleDelimiter",
 CellID->50101003],
Cell[32779, 1067, 641, 23, 70, "ExampleText",
 CellID->84123990],
Cell[33423, 1092, 480, 16, 70, "Input",
 CellID->241435709],
Cell[33906, 1110, 161, 6, 70, "ExampleText",
 CellID->98420419],
Cell[CellGroupData[{
Cell[34092, 1120, 695, 21, 70, "Input",
 CellID->328596080],
Cell[34790, 1143, 506, 13, 36, "Output",
 CellID->448758431]
}, Open  ]],
Cell[35311, 1159, 744, 28, 70, "ExampleText",
 CellID->7025968],
Cell[CellGroupData[{
Cell[36080, 1191, 392, 12, 70, "Input",
 CellID->29433403],
Cell[36475, 1205, 160, 5, 36, "Output",
 CellID->510309791]
}, Open  ]],
Cell[36650, 1213, 125, 3, 70, "ExampleDelimiter",
 CellID->581219043],
Cell[36778, 1218, 368, 12, 70, "ExampleText",
 CellID->222524165],
Cell[CellGroupData[{
Cell[37171, 1234, 567, 20, 70, "Input",
 CellID->360176644],
Cell[37741, 1256, 971, 20, 70, "Output",
 Evaluatable->False,
 CellID->253149802]
}, Open  ]],
Cell[CellGroupData[{
Cell[38749, 1281, 490, 17, 70, "Input",
 CellID->16341238],
Cell[39242, 1300, 962, 20, 70, "Output",
 Evaluatable->False,
 CellID->10998382]
}, Open  ]],
Cell[CellGroupData[{
Cell[40241, 1325, 205, 7, 70, "Input",
 CellID->44023477],
Cell[40449, 1334, 961, 20, 70, "Output",
 Evaluatable->False,
 CellID->1278536]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[41459, 1360, 231, 7, 70, "ExampleSection",
 CellID->1305812373],
Cell[41693, 1369, 590, 24, 70, "ExampleText",
 CellID->516655824],
Cell[CellGroupData[{
Cell[42308, 1397, 528, 18, 70, "Input",
 CellID->7437777],
Cell[42839, 1417, 296, 6, 70, "Message",
 CellID->555982437],
Cell[43138, 1425, 1060, 21, 70, "Output",
 Evaluatable->False,
 CellID->134944639]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[44247, 1452, 228, 7, 70, "ExampleSection",
 CellID->589267740],
Cell[CellGroupData[{
Cell[44500, 1463, 265, 7, 70, "Input",
 CellID->176375359],
Cell[44768, 1472, 8338, 141, 70, "Output",
 Evaluatable->False,
 CellID->226006036]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[53167, 1620, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[53486, 1631, 1193, 44, 70, "SeeAlso",
 CellID->15690418]
}, Open  ]],
Cell[CellGroupData[{
Cell[54716, 1680, 299, 8, 70, "MoreAboutSection"],
Cell[55018, 1690, 152, 3, 70, "MoreAbout",
 CellID->11222202],
Cell[55173, 1695, 198, 4, 70, "MoreAbout",
 CellID->568955236]
}, Open  ]],
Cell[55386, 1702, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

