(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     46399,       1729]
NotebookOptionsPosition[     37385,       1411]
NotebookOutlinePosition[     38721,       1449]
CellTagsIndexPosition[     38635,       1444]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Putting Expressions into Different Forms" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/PuttingExpressionsIntoDifferentForms"], 
          "Structural Operations on Rational Expressions" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/StructuralOperationsOnRationalExpressions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Putting Expressions into Different Forms\"\>", 
       2->"\<\"Structural Operations on Rational Expressions\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Apart" :> Documentation`HelpLookup["paclet:ref/Apart"], 
          "Cancel" :> Documentation`HelpLookup["paclet:ref/Cancel"], 
          "Collect" :> Documentation`HelpLookup["paclet:ref/Collect"], 
          "Factor" :> Documentation`HelpLookup["paclet:ref/Factor"], 
          "PolynomialGCD" :> 
          Documentation`HelpLookup["paclet:ref/PolynomialGCD"], 
          "PadeApproximant" :> 
          Documentation`HelpLookup["paclet:ref/PadeApproximant"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Apart\"\>", 2->"\<\"Cancel\"\>", 
       3->"\<\"Collect\"\>", 4->"\<\"Factor\"\>", 5->"\<\"PolynomialGCD\"\>", 
       6->"\<\"PadeApproximant\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Algebraic Transformations" :> 
          Documentation`HelpLookup["paclet:guide/AlgebraicTransformations"], 
          "Formula Manipulation" :> 
          Documentation`HelpLookup["paclet:guide/FormulaManipulation"], 
          "Polynomial Factoring & Decomposition" :> 
          Documentation`HelpLookup["paclet:guide/PolynomialFactoring"], 
          "Rational Functions" :> 
          Documentation`HelpLookup["paclet:guide/RationalFunctions"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Algebraic Transformations\"\>", 
       2->"\<\"Formula Manipulation\"\>", 
       3->"\<\"Polynomial Factoring & Decomposition\"\>", 
       4->"\<\"Rational Functions\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Together", "ObjectName"], Cell[BoxData[
     TooltipBox[
      TogglerBox[Dynamic[
        FrontEnd`CurrentValue[
         FrontEnd`EvaluationNotebook[], {
         TaggingRules, "ModificationHighlight"}]], {True->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVVly2zAMDQhxEylSsizLaxJn73KafvQAuUDv/1eApJuosceeTDAWF4B8
eFgk71///HoVV1dXK3p+0wNfIzdCLL4I6p1sYBYuPy3SI2AmRBpuaE/TPRsE
3Isg8mrB9l6ILQhhLkbd93MBuwVxAthdZwPr5wVVzBc8wAvMX8TFqPkqE8q6
rDCsKPjZ/g1guz+PKvLFfGsDU1R4A8zDhgLangX9x/WGM7A1qSQ7rraYkaLf
LHZ5FWY9H7rew/n4/6vWPKT2mXFBaH/NGejzqi/VnFEFJ2Rb1Lo+jtofllPD
RVJjdZLr51Eb/ED1K+QI109LcIg+sdSIWqa5g85L6MiNoRloTws+pdBKiFGl
mx3N0jcAlcsKeFivVkteVOgMSNsC18sYS/iIMdZoK43WSdQVK1SLlYy09bZ2
aEO+aoPiACNak0EBbtfLRIz9KJRcroaSKwE11BprpRHqiJ0BrxtJG4pLYqWc
RZO4BQwSbGT4rFivaLjjQdscjSvlih48Mu+WDisOBcB5ehgeDEZQlikkKh3b
KA1FMTDg9yFxLSe4XC37begHTDh5seS1I/gaW025Yo/yUFbmSalShzon1Kch
JTNn2hKS1hyWVIkf5n2LHEQgt0zeUNTkMaYrDdkMZdo3fJCDHx7hxzAC+8rs
XYBokTPfEJk6JVlZx3Yl0UnTYMPvSUt6zghf8dhIi5VDnwO+Hcb1MHK1msK+
oy5qkYS7wVC3cfiq8ojBcMtFMJXnDiIcLPFJClDFGkJBhXGEZV6VcCQFoey7
tyvBF6lw0uKH6nyQ5fqhrKx/Kxe8+3coucpGN4U5+RYux7vnhGO5P7hKenqz
xSO3ivjisf345fg5Pt1ScCRkkzR1U1Dur+NCec4LZ49Ynx9P04GmOvlnqcKZ
79BfJfcjkg==
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlLlKQ0EYRi/iA9gpWIgvIXbjM1iKWAjW2vgeZnWN+AgWZhEULCxELFyi
ZnfJavbeJOr/33xXcj8CNnY5EA7k3GWYmTuzq+uLa2OWZS38/MYt0DbDHH8Q
8uTB64bRNrmsQkaPRoQSGX1ZqZPR9/eEazL6klIlowf8wiUZ3ecV3snowYDw
SEafUmJk9HmlQh4cX4GM7vUId2T0VFIho28or2T0w5DQIKN3PoUaGX1FaZLR
0ymh6sz7hHLk9PMzoU5Gz6SFmvFsCbd9Xzj9qyc0nfe49xfuTyYUEzoQbmh8
+N8e37HTbVpk9MSzUCajbypFMvq0UiOjzyklMnqvKzRMJCwU+/vjzemTSpns
nh97feJmd0e4cvppTKiQ0bsdoW5ecorZDgpPtD6xqFA2fp+Qp/vtdUj1v797
Oqdwnb2Ov++fUVpk9PCJUCC7n4t5wz5xj9/+rj6ceXbPP86NbEb58/k56qP+
n/0bdGyYqQ==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}], False->
       GraphicsBox[RasterBox[CompressedData["
1:eJytVdd22zAMDUBxSaJm5HgljrPTJN177/nWh35AfqD//1aAVGrrJLbbk+BI
FEmQFxcXlDQ9//3zHNfW1gZ0/6IbbsYOhahvCGrO9qHM/mnhmMMLoKv0RD6V
cPyZHTTcDI5NkYnQq4UQ0BdiAkKYZagl1OOw5fWtcgyvPp7AnefsGG0DBIeA
9RZVrNfcwBasb4nlbP9u4cbc/XD/zXcIgC2qYYazJTQiGSYHS0Hr8Yu5LV/h
ePvR5oMOKswAQ0M8R5OloFMWSNRE+IAVeALv38KX26wAV1uU5Ojv16PQy8q+
gMP+9ABW5C9KbkZi6qv19DGc/ID9b+CrZTjbbVagH3p91oIcL+GZ6JDNUet4
HpWUXxx5BaWZxRh1FQgH6JqoKcarF/2/dblez7IE0XmWGlFL/6ygchIqCmPo
CTSmDq9SaCUUhfI7K3pKlwJESZiAveHGxoA7ESYGpM2B62WMJXzEoojRRhpt
IlFHPKFyjGRBQ2fjBG0WttpMcYIFWhNAAXaHA0+M4yiUXK6UxJWAGmKNsdII
cYGVAadTSQPKS2KkEovGc8swk2ALhg8Tww1qdrjRNmSTtOUqHDhk3jktVpwK
QOLoZngwWICyTMFTqdhHMrQTDQPeazzXdgWXK+e4KV3AhH0US1Ergo8x16QV
R5QXZWWeJJW6qLNHPWq8mEFpS0hac1pSeX4YxjlyEhmFZfKGsqaIhd+Sks+Q
0i7lhZx8cwYPmx5wrMA+yaCwyMqnRCb2IiubsF9JTKRJMeX3JKd5VoS3OEyl
xShBFxLebXrDpsfVSlv2FZ2iHMn4NBg6bZy+ihxiZvjIFWAixyeIcLDNT1KC
qogha1Gh14NB6LXpSEpC2bm3y8O3FmHniF9U55INhnttz7pZuWDu79BqFZxJ
F2bhWzjo7Zx6HMvng6ukuztzvGJXa66NmF/+crzrHe1ScmTkk/SouqB8vq42
0jl0EnuF9/RsMR1Io4U/S5Wt+A79AaDyK/w=
         "], {{0, 0}, {86, 25}},
         ColorFunction->(Apply[RGBColor, 
           Part[CompressedData["
1:eJztlUtrE1EYhgfxBwguFBTEvyAiFhfzHxRFvC0E17rQhYLiT7D3u/gTXNg2
3sBFFyIutE1qm17UZJKZZJK0KFjBtur7Td4jnhe7dTMPhAfyQObMnO9Mjl69
fvraniAI7v/+7A3IRri7/8VGWJwHVTH72qohZp+ZBnUx+yWjJWYfHwNvxOwX
jKaYfXAAzIrZ+/tARcw+NAhKYvaTRiJmP2gUxH+vLxKzl5cMMXtfL3gvZn84
Cdpi9hvGJzH7yxegJWa/YnTE7Mtl0HTPfZ/xyPWVZZCGvQ/Au65fSV9aNMLJ
CfDW9a0fIBWz/9wBHbcOf/74PX83W99j128ZNTH71BMQidmfFkAiZj9irIvZ
Fz+AWMx+yEjF7KeMVOw/32x/iuHoCHjt+s42aIfTU6DWna/Prm9vgVb4cc0I
h4fAgusZ62L2A0YsZj9h1MX+9bN9LHfP75zrZ42a2L9/3+wXjVTM7q8jm9NE
5q8wA+JwoB/8eX+eNxIx+00jErP3GA2xvy7uG88R+z2jI2Y/bLTE/v1l76WG
mxP/+r7ZN7+Bupj9mFERsz9/Bppi9myeEzH7QgnUxOy3jYaY/a7RFrNfNtpi
9nNGXcw+NgoaYnbOk2///PJ/bXXFcP37JojF7CPDIBazf/0CKmL2+TlQEbPf
MZpi9olxkIrZS0UQidn3G1Ux+3EjErOfMapi9mBX8p73vOc973n/P/0XnFJ2
Rg==
            "], #]]& ),
         ColorFunctionScaling->False],
        Background->None,
        ImageSize->{86, 25},
        PlotRange->{{0, 86}, {0, 25}}]}, "\"\<Click me\>\""],
      "Toggle changes in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Together",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Together"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]puts terms in a sum over a common denominator, and \
cancels factors in the result. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17723]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Together",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Together"]], "InlineFormula"],
 " makes a sum of terms into a single rational function. "
}], "Notes",
 CellID->5371],

Cell[TextData[{
 "The denominator of the result of ",
 Cell[BoxData[
  ButtonBox["Together",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Together"]], "InlineFormula"],
 " is typically the lowest common multiple of the denominators of each of the \
terms in the sum. "
}], "Notes",
 CellID->16808],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Together",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Together"]], "InlineFormula"],
 " avoids expanding out denominators unless it is necessary. "
}], "Notes",
 CellID->1620],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Together",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Together"]], "InlineFormula"],
 " is effectively the inverse of ",
 Cell[BoxData[
  ButtonBox["Apart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Apart"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->18981],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Together",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Together"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     ButtonBox["Modulus",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Modulus"], "->", 
     StyleBox["p", "TI"]}]}], "]"}]], "InlineFormula"],
 " generates a result modulo ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13156],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Together",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Together"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     ButtonBox["Extension",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Extension"], "->", 
     ButtonBox["Automatic",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Automatic"]}]}], "]"}]], "InlineFormula"],
 " allows operations to be performed on algebraic numbers in ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23298],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Together",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Together"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    RowBox[{
     ButtonBox["Trig",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Trig"], "->", 
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"]}]}], "]"}]], "InlineFormula"],
 " treats trigonometric functions as rational functions of exponentials, and \
manipulates them accordingly. "
}], "Notes",
 CellID->30149],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Together",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Together"]], "InlineFormula"],
 " automatically threads over lists, as well as equations, inequalities and \
logic functions."
}], "Notes",
 Background->Dynamic[
   If[CurrentValue[{TaggingRules, "ModificationHighlight"}] === True, 
    RGBColor[0.92, 1, 0.59], None]],
 CellID->82730543]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->308709282],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->32489856],

Cell["Combine terms over a common denominator:", "ExampleText",
 CellID->410889973],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Together", "[", 
  RowBox[{
   RowBox[{"a", "/", "b"}], "+", 
   RowBox[{"c", "/", "d"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->455690262],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"b", " ", "c"}], "+", 
   RowBox[{"a", " ", "d"}]}], 
  RowBox[{"b", " ", "d"}]]], "Output",
 ImageSize->{55, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->267250877]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->234005964],

Cell["\<\
Cancel common factors between the numerator and the denominator:\
\>", "ExampleText",
 CellID->374019751],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Together", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", "1"}], ")"}]}], "+", 
   RowBox[{"x", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", "1"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->358654287],

Cell[BoxData[
 FractionBox["x", 
  RowBox[{
   RowBox[{"-", "1"}], "+", "x"}]]], "Output",
 ImageSize->{43, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->412882931]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19149],

Cell["Combine a sum of any number of terms:", "ExampleText",
 CellID->390972937],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Together", "[", 
  RowBox[{
   FractionBox["1", "x"], "+", 
   FractionBox["1", 
    RowBox[{"x", "+", "1"}]], "+", 
   FractionBox["1", 
    RowBox[{"x", "+", "2"}]], "+", 
   FractionBox["1", 
    RowBox[{"x", "+", "3"}]]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->192459],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{"3", "+", 
     RowBox[{"11", " ", "x"}], "+", 
     RowBox[{"9", " ", 
      SuperscriptBox["x", "2"]}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["x", "3"]}]}], ")"}]}], 
  RowBox[{"x", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"3", "+", "x"}], ")"}]}]]], "Output",
 ImageSize->{146, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->27681023]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->329447550],

Cell["Here all factors of the denominator divide the numerator:", \
"ExampleText",
 CellID->249427449],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Together", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "^", "2"}], "/", 
    RowBox[{"(", 
     RowBox[{"x", "-", "y"}], ")"}]}], "-", 
   RowBox[{"x", " ", 
    RowBox[{"y", "/", 
     RowBox[{"(", 
      RowBox[{"x", "-", "y"}], ")"}]}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->90432514],

Cell[BoxData["x"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->133024195]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->6125857],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Together",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Together"]], "InlineFormula"],
 " threads over equations and inequalities:"
}], "ExampleText",
 CellID->192215993],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Together", "[", 
  RowBox[{"1", "<", 
   RowBox[{
    RowBox[{"1", "/", "x"}], "+", 
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}]}]}], "<", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->184154545],

Cell[BoxData[
 RowBox[{"1", "<", 
  FractionBox[
   RowBox[{"1", "+", 
    RowBox[{"2", " ", "x"}]}], 
   RowBox[{"x", " ", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}]}]], "<", "2"}]], "Output",
 ImageSize->{101, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->444860703]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->32581],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Extension",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->31598],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Together",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Together"]], "InlineFormula"],
 " treats algebraic numbers as independent variables:"
}], "ExampleText",
 CellID->295457362],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Together", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"x", "^", "2"}], "-", "2"}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"Sqrt", "[", "2", "]"}], "+", "x"}], ")"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->21424822],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "2"}], "+", 
   SuperscriptBox["x", "2"]}], 
  RowBox[{
   SqrtBox["2"], "+", "x"}]]], "Output",
 ImageSize->{52, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->444828772]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Together", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Sqrt", "[", "2", "]"}], "+", "x"}], ")"}]}], "+", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", "2"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1741563],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "2"}], "+", 
   SqrtBox["2"], "+", "x", "+", 
   SuperscriptBox["x", "2"]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SqrtBox["2"], "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", 
     SuperscriptBox["x", "2"]}], ")"}]}]]], "Output",
 ImageSize->{123, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->855482422]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->128834415],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Extension",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Extension"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Together",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Together"]], "InlineFormula"],
 " recognizes algebraically dependent coefficients:"
}], "ExampleText",
 CellID->19319446],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Together", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "-", "2"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Sqrt", "[", "2", "]"}], "+", "x"}], ")"}]}], ",", 
   RowBox[{"Extension", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->414093647],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   SqrtBox["2"]}], "+", "x"}]], "Output",
 ImageSize->{56, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->224281166]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Together", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sqrt", "[", "2", "]"}], "+", "x"}], ")"}]}], "+", 
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", "2"}], ")"}]}]}], ",", 
   RowBox[{"Extension", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->403603556],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"-", "1"}], "+", 
   SqrtBox["2"], "-", "x"}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SqrtBox["2"], "-", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     SqrtBox["2"], "+", "x"}], ")"}]}]]], "Output",
 ImageSize->{127, 45},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->125523453]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Modulus",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->21845],

Cell["Computations over rational numbers:", "ExampleText",
 CellID->254577196],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Together", "[", 
  RowBox[{
   RowBox[{"1", "/", "x"}], "+", 
   RowBox[{"1", "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", "x"}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->659222465],

Cell[BoxData[
 FractionBox[
  RowBox[{"1", "+", 
   RowBox[{"2", " ", "x"}]}], 
  RowBox[{"x", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}]}]]], "Output",
 ImageSize->{59, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->225933613]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Together", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", "-", "1"}], ")"}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "2"}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"x", "-", "3"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"x", "-", "4"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"x", "-", "5"}], ")"}]}], ")"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->252096947],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "2"}], "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}], ")"}]}], 
  RowBox[{
   RowBox[{"-", "60"}], "+", 
   RowBox[{"47", " ", "x"}], "-", 
   RowBox[{"12", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   SuperscriptBox["x", "3"]}]]], "Output",
 ImageSize->{134, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->10852533]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->643084640],

Cell["The same computations over integers modulo 2:", "ExampleText",
 CellID->924992008],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Together", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", "x"}], "+", 
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}]}]}], ",", 
   RowBox[{"Modulus", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->127242312],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"x", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}]}]]], "Output",
 ImageSize->{59, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->442246043]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Together", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "1"}], ")"}], 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "2"}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"x", "-", "3"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"x", "-", "4"}], ")"}], 
       RowBox[{"(", 
        RowBox[{"x", "-", "5"}], ")"}]}], ")"}]}]}], ",", 
   RowBox[{"Modulus", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->246758866],

Cell[BoxData[
 FractionBox["1", 
  RowBox[{"1", "+", "x"}]]], "Output",
 ImageSize->{35, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->437967548]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Trig",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->13675],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["Together",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Together"]], "InlineFormula"],
 " treats trigonometric functions as independent variables:"
}], "ExampleText",
 CellID->411074813],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Together", "[", 
  RowBox[{
   RowBox[{"1", "/", 
    RowBox[{"Sin", "[", "x", "]"}]}], "+", 
   RowBox[{"1", "/", 
    RowBox[{"Cos", "[", "x", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->138321982],

Cell[BoxData[
 RowBox[{
  RowBox[{"Csc", "[", "x", "]"}], "+", 
  RowBox[{"Sec", "[", "x", "]"}]}]], "Output",
 ImageSize->{101, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->196686622]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->259853513],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Trig",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trig"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Together",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Together"]], "InlineFormula"],
 " recognizes dependencies between trigonometric functions:"
}], "ExampleText",
 CellID->25147952],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Together", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", 
     RowBox[{"Sin", "[", "x", "]"}]}], "+", 
    RowBox[{"1", "/", 
     RowBox[{"Cos", "[", "x", "]"}]}]}], ",", 
   RowBox[{"Trig", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->212562188],

Cell[BoxData[
 RowBox[{
  RowBox[{"Csc", "[", "x", "]"}], " ", 
  RowBox[{"Sec", "[", "x", "]"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Cos", "[", "x", "]"}], "+", 
    RowBox[{"Sin", "[", "x", "]"}]}], ")"}]}]], "Output",
 ImageSize->{205, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->44158358]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->245],

Cell["Test whether a function is a rational function:", "ExampleText",
 CellID->118340717],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"rationalFunctionQ", "[", 
    RowBox[{"e_", ",", "vars_"}], "]"}], ":=", "\[IndentingNewLine]", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"r", "=", 
       RowBox[{"Together", "[", "e", "]"}]}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Apply", "[", 
      RowBox[{"And", ",", 
       RowBox[{
        RowBox[{
         RowBox[{"PolynomialQ", "[", 
          RowBox[{"#", ",", "vars"}], "]"}], "&"}], "/@", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Denominator", "[", "r", "]"}], ",", 
          RowBox[{"Numerator", "[", "r", "]"}]}], "}"}]}]}], "]"}]}], 
    "\[IndentingNewLine]", "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->66018903],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"rationalFunctionQ", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"1", "/", "x"}], "+", 
    RowBox[{"y", "/", "x"}]}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->222720888],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->330034369]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->14399],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Apart",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Apart"]], "InlineFormula"],
 " acts as a partial inverse of ",
 Cell[BoxData[
  ButtonBox["Together",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Together"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->134941247],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Together", "[", 
  RowBox[{
   RowBox[{"a", "/", "b"}], "+", 
   RowBox[{"c", "/", "d"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->285994815],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"b", " ", "c"}], "+", 
   RowBox[{"a", " ", "d"}]}], 
  RowBox[{"b", " ", "d"}]]], "Output",
 ImageSize->{55, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->277952536]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Apart", "[", "%", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->305087715],

Cell[BoxData[
 RowBox[{
  FractionBox["a", "b"], "+", 
  FractionBox["c", "d"]}]], "Output",
 ImageSize->{39, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->310213659]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->502130038],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Together",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Together"]], "InlineFormula"],
 " combines terms over a common denominator and cancels common factors:"
}], "ExampleText",
 CellID->268979689],

Cell[BoxData[
 RowBox[{
  RowBox[{"r", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "1"}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", "1"}], ")"}]}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"x", "-", "2"}], ")"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"x", "^", "2"}], "-", "4"}], ")"}]}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->206530521],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Together", "[", "r", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->36687592],

Cell[BoxData[
 FractionBox[
  RowBox[{"3", "+", 
   RowBox[{"2", " ", "x"}]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "x"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", "x"}], ")"}]}]]], "Output",
 ImageSize->{93, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->597180604]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Cancel",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Cancel"]], "InlineFormula"],
 " only cancels common factors between numerators and denominators:"
}], "ExampleText",
 CellID->171692318],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Cancel", "[", "r", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->542592671],

Cell[BoxData[
 RowBox[{
  FractionBox["1", 
   RowBox[{"1", "+", "x"}]], "+", 
  FractionBox["1", 
   RowBox[{"2", "+", "x"}]]}]], "Output",
 ImageSize->{79, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->114590738]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->122412715],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Numerator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Numerator"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Denominator",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Denominator"]], "InlineFormula"],
 " to extract numerators and denominators:"
}], "ExampleText",
 CellID->223320927],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"expr", "=", 
  RowBox[{"Together", "[", 
   RowBox[{
    RowBox[{"1", "/", "x"}], "+", 
    RowBox[{"1", "/", "y"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->467288730],

Cell[BoxData[
 FractionBox[
  RowBox[{"x", "+", "y"}], 
  RowBox[{"x", " ", "y"}]]], "Output",
 ImageSize->{35, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->419013890]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Numerator", "[", "expr", "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->579233874],

Cell[BoxData[
 RowBox[{"x", "+", "y"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->540568832]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Denominator", "[", "expr", "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->341862065],

Cell[BoxData[
 RowBox[{"x", " ", "y"}]], "Output",
 ImageSize->{21, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->413226367]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->26392],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Apart",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Apart"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Cancel",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Cancel"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Collect",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Collect"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Factor",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Factor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolynomialGCD",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PolynomialGCD"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PadeApproximant",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PadeApproximant"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13531]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32145],

Cell[TextData[ButtonBox["Putting Expressions into Different Forms",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/PuttingExpressionsIntoDifferentForms"]], "Tutorials",
 CellID->30497],

Cell[TextData[ButtonBox["Structural Operations on Rational Expressions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:tutorial/StructuralOperationsOnRationalExpressions"]], "Tutorials",
 CellID->19466]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->354987502],

Cell[TextData[ButtonBox["Algebraic Transformations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AlgebraicTransformations"]], "MoreAbout",
 CellID->549947287],

Cell[TextData[ButtonBox["Formula Manipulation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/FormulaManipulation"]], "MoreAbout",
 CellID->305011930],

Cell[TextData[ButtonBox["Polynomial Factoring & Decomposition",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/PolynomialFactoring"]], "MoreAbout",
 CellID->584079857],

Cell[TextData[ButtonBox["Rational Functions",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RationalFunctions"]], "MoreAbout",
 CellID->94322456]
}, Open  ]],

Cell["New in 1  |  Last modified in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Together - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 2.5517158}", "context" -> "System`", 
    "keywords" -> {
     "collecting over common denominators", "collecting terms", 
      "common denominator", "rational function"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Together[expr] puts terms in a sum over a common denominator, and \
cancels factors in the result. ", "synonyms" -> {}, "title" -> "Together", 
    "type" -> "Symbol", "uri" -> "ref/Together"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12038, 339, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->308709282]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 38491, 1437}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 3063, 68, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3686, 95, 4192, 83, 70, "ObjectNameGrid"],
Cell[7881, 180, 529, 16, 70, "Usage",
 CellID->17723]
}, Open  ]],
Cell[CellGroupData[{
Cell[8447, 201, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8925, 218, 221, 7, 70, "Notes",
 CellID->5371],
Cell[9149, 227, 301, 9, 70, "Notes",
 CellID->16808],
Cell[9453, 238, 225, 7, 70, "Notes",
 CellID->1620],
Cell[9681, 247, 318, 12, 70, "Notes",
 CellID->18981],
Cell[10002, 261, 473, 18, 70, "Notes",
 CellID->13156],
Cell[10478, 281, 582, 20, 70, "Notes",
 CellID->23298],
Cell[11063, 303, 543, 18, 70, "Notes",
 CellID->30149],
Cell[11609, 323, 392, 11, 70, "Notes",
 CellID->82730543]
}, Closed]],
Cell[CellGroupData[{
Cell[12038, 339, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->308709282],
Cell[CellGroupData[{
Cell[12423, 353, 147, 5, 70, "ExampleSection",
 CellID->32489856],
Cell[12573, 360, 83, 1, 70, "ExampleText",
 CellID->410889973],
Cell[CellGroupData[{
Cell[12681, 365, 175, 6, 28, "Input",
 CellID->455690262],
Cell[12859, 373, 272, 10, 52, "Output",
 CellID->267250877]
}, Open  ]],
Cell[13146, 386, 125, 3, 70, "ExampleDelimiter",
 CellID->234005964],
Cell[13274, 391, 115, 3, 70, "ExampleText",
 CellID->374019751],
Cell[CellGroupData[{
Cell[13414, 398, 356, 13, 70, "Input",
 CellID->358654287],
Cell[13773, 413, 220, 8, 49, "Output",
 CellID->412882931]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14042, 427, 216, 7, 70, "ExampleSection",
 CellID->19149],
Cell[14261, 436, 80, 1, 70, "ExampleText",
 CellID->390972937],
Cell[CellGroupData[{
Cell[14366, 441, 307, 11, 70, "Input",
 CellID->192459],
Cell[14676, 454, 595, 21, 58, "Output",
 CellID->27681023]
}, Open  ]],
Cell[15286, 478, 125, 3, 70, "ExampleDelimiter",
 CellID->329447550],
Cell[15414, 483, 102, 2, 70, "ExampleText",
 CellID->249427449],
Cell[CellGroupData[{
Cell[15541, 489, 328, 12, 70, "Input",
 CellID->90432514],
Cell[15872, 503, 158, 5, 36, "Output",
 CellID->133024195]
}, Open  ]],
Cell[16045, 511, 123, 3, 70, "ExampleDelimiter",
 CellID->6125857],
Cell[16171, 516, 218, 7, 70, "ExampleText",
 CellID->192215993],
Cell[CellGroupData[{
Cell[16414, 527, 264, 9, 70, "Input",
 CellID->184154545],
Cell[16681, 538, 336, 12, 53, "Output",
 CellID->444860703]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[17066, 556, 218, 7, 70, "ExampleSection",
 CellID->32581],
Cell[CellGroupData[{
Cell[17309, 567, 226, 7, 70, "ExampleSubsection",
 CellID->31598],
Cell[17538, 576, 245, 8, 70, "ExampleText",
 CellID->295457362],
Cell[CellGroupData[{
Cell[17808, 588, 284, 10, 70, "Input",
 CellID->21424822],
Cell[18095, 600, 281, 11, 58, "Output",
 CellID->444828772]
}, Open  ]],
Cell[CellGroupData[{
Cell[18413, 616, 337, 12, 70, "Input",
 CellID->1741563],
Cell[18753, 630, 463, 18, 66, "Output",
 CellID->855482422]
}, Open  ]],
Cell[19231, 651, 125, 3, 70, "ExampleDelimiter",
 CellID->128834415],
Cell[19359, 656, 476, 17, 70, "ExampleText",
 CellID->19319446],
Cell[CellGroupData[{
Cell[19860, 677, 361, 12, 70, "Input",
 CellID->414093647],
Cell[20224, 691, 211, 8, 38, "Output",
 CellID->224281166]
}, Open  ]],
Cell[CellGroupData[{
Cell[20472, 704, 417, 14, 70, "Input",
 CellID->403603556],
Cell[20892, 720, 395, 16, 66, "Output",
 CellID->125523453]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21336, 742, 224, 7, 70, "ExampleSubsection",
 CellID->21845],
Cell[21563, 751, 78, 1, 70, "ExampleText",
 CellID->254577196],
Cell[CellGroupData[{
Cell[21666, 756, 226, 8, 70, "Input",
 CellID->659222465],
Cell[21895, 766, 297, 11, 53, "Output",
 CellID->225933613]
}, Open  ]],
Cell[CellGroupData[{
Cell[22229, 782, 462, 17, 70, "Input",
 CellID->252096947],
Cell[22694, 801, 505, 19, 53, "Output",
 CellID->10852533]
}, Open  ]],
Cell[23214, 823, 125, 3, 70, "ExampleDelimiter",
 CellID->643084640],
Cell[23342, 828, 88, 1, 70, "ExampleText",
 CellID->924992008],
Cell[CellGroupData[{
Cell[23455, 833, 290, 10, 70, "Input",
 CellID->127242312],
Cell[23748, 845, 250, 9, 53, "Output",
 CellID->442246043]
}, Open  ]],
Cell[CellGroupData[{
Cell[24035, 859, 535, 19, 70, "Input",
 CellID->246758866],
Cell[24573, 880, 201, 7, 51, "Output",
 CellID->437967548]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[24823, 893, 221, 7, 70, "ExampleSubsection",
 CellID->13675],
Cell[25047, 902, 251, 8, 70, "ExampleText",
 CellID->411074813],
Cell[CellGroupData[{
Cell[25323, 914, 239, 8, 70, "Input",
 CellID->138321982],
Cell[25565, 924, 241, 8, 36, "Output",
 CellID->196686622]
}, Open  ]],
Cell[25821, 935, 125, 3, 70, "ExampleDelimiter",
 CellID->259853513],
Cell[25949, 940, 464, 17, 70, "ExampleText",
 CellID->25147952],
Cell[CellGroupData[{
Cell[26438, 961, 303, 10, 70, "Input",
 CellID->212562188],
Cell[26744, 973, 361, 12, 36, "Output",
 CellID->44158358]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[27166, 992, 221, 7, 70, "ExampleSection",
 CellID->245],
Cell[27390, 1001, 90, 1, 70, "ExampleText",
 CellID->118340717],
Cell[27483, 1004, 762, 23, 70, "Input",
 CellID->66018903],
Cell[CellGroupData[{
Cell[28270, 1031, 259, 9, 70, "Input",
 CellID->222720888],
Cell[28532, 1042, 161, 5, 36, "Output",
 CellID->330034369]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28742, 1053, 233, 7, 70, "ExampleSection",
 CellID->14399],
Cell[28978, 1062, 326, 12, 70, "ExampleText",
 CellID->134941247],
Cell[CellGroupData[{
Cell[29329, 1078, 175, 6, 70, "Input",
 CellID->285994815],
Cell[29507, 1086, 272, 10, 52, "Output",
 CellID->277952536]
}, Open  ]],
Cell[CellGroupData[{
Cell[29816, 1101, 101, 3, 70, "Input",
 CellID->305087715],
Cell[29920, 1106, 222, 8, 49, "Output",
 CellID->310213659]
}, Open  ]],
Cell[30157, 1117, 125, 3, 70, "ExampleDelimiter",
 CellID->502130038],
Cell[30285, 1122, 246, 7, 70, "ExampleText",
 CellID->268979689],
Cell[30534, 1131, 452, 17, 70, "Input",
 CellID->206530521],
Cell[CellGroupData[{
Cell[31011, 1152, 103, 3, 70, "Input",
 CellID->36687592],
Cell[31117, 1157, 346, 13, 53, "Output",
 CellID->597180604]
}, Open  ]],
Cell[31478, 1173, 238, 7, 70, "ExampleText",
 CellID->171692318],
Cell[CellGroupData[{
Cell[31741, 1184, 102, 3, 70, "Input",
 CellID->542592671],
Cell[31846, 1189, 270, 10, 51, "Output",
 CellID->114590738]
}, Open  ]],
Cell[32131, 1202, 125, 3, 70, "ExampleDelimiter",
 CellID->122412715],
Cell[32259, 1207, 363, 13, 70, "ExampleText",
 CellID->223320927],
Cell[CellGroupData[{
Cell[32647, 1224, 204, 7, 70, "Input",
 CellID->467288730],
Cell[32854, 1233, 224, 8, 51, "Output",
 CellID->419013890]
}, Open  ]],
Cell[CellGroupData[{
Cell[33115, 1246, 108, 3, 70, "Input",
 CellID->579233874],
Cell[33226, 1251, 180, 6, 36, "Output",
 CellID->540568832]
}, Open  ]],
Cell[CellGroupData[{
Cell[33443, 1262, 110, 3, 70, "Input",
 CellID->341862065],
Cell[33556, 1267, 180, 6, 36, "Output",
 CellID->413226367]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[33797, 1280, 311, 9, 70, "SeeAlsoSection",
 CellID->26392],
Cell[34111, 1291, 1439, 53, 70, "SeeAlso",
 CellID->13531]
}, Open  ]],
Cell[CellGroupData[{
Cell[35587, 1349, 314, 9, 70, "TutorialsSection",
 CellID->32145],
Cell[35904, 1360, 190, 4, 70, "Tutorials",
 CellID->30497],
Cell[36097, 1366, 200, 4, 70, "Tutorials",
 CellID->19466]
}, Open  ]],
Cell[CellGroupData[{
Cell[36334, 1375, 319, 9, 70, "MoreAboutSection",
 CellID->354987502],
Cell[36656, 1386, 161, 3, 70, "MoreAbout",
 CellID->549947287],
Cell[36820, 1391, 151, 3, 70, "MoreAbout",
 CellID->305011930],
Cell[36974, 1396, 167, 3, 70, "MoreAbout",
 CellID->584079857],
Cell[37144, 1401, 146, 3, 70, "MoreAbout",
 CellID->94322456]
}, Open  ]],
Cell[37305, 1407, 50, 0, 70, "History"],
Cell[37358, 1409, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

