(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    290149,       5944]
NotebookOptionsPosition[    281928,       5670]
NotebookOutlinePosition[    283599,       5711]
CellTagsIndexPosition[    283512,       5706]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntroductionToDynamic"], 
          "Generalized Input" :> 
          Documentation`HelpLookup["paclet:tutorial/GeneralizedInput"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Introduction to Dynamic\"\>",
        2->"\<\"Generalized Input\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"CheckboxBar" :> 
          Documentation`HelpLookup["paclet:ref/CheckboxBar"], "SetterBar" :> 
          Documentation`HelpLookup["paclet:ref/SetterBar"], "Toggler" :> 
          Documentation`HelpLookup["paclet:ref/Toggler"], "Manipulate" :> 
          Documentation`HelpLookup["paclet:ref/Manipulate"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"CheckboxBar\"\>", 
       2->"\<\"SetterBar\"\>", 3->"\<\"Toggler\"\>", 
       4->"\<\"Manipulate\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Control Objects" :> 
          Documentation`HelpLookup["paclet:guide/ControlObjects"], 
          "Creating Inspectors" :> 
          Documentation`HelpLookup["paclet:guide/CreatingInspectors"], 
          "Toolbars" :> Documentation`HelpLookup["paclet:guide/Toolbars"], 
          "User Interface Structuring & Layout" :> 
          Documentation`HelpLookup[
           "paclet:guide/UserInterfaceStructuringAndLayout"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Control Objects\"\>", 
       2->"\<\"Creating Inspectors\"\>", 3->"\<\"Toolbars\"\>", 
       4->"\<\"User Interface Structuring & Layout\"\>"}, "\<\"more \
about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["TogglerBar", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["TogglerBar",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TogglerBar"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]represents a toggler bar with setting ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " and with toggler buttons for values ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["val", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " to include in the list ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["TogglerBar",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TogglerBar"], "[", 
       RowBox[{
        RowBox[{
         ButtonBox["Dynamic",
          BaseStyle->"Link",
          ButtonData->"paclet:ref/Dynamic"], "[", 
         StyleBox["x", "TI"], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["val", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]takes the setting to be the dynamically updated current \
value of ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     ", with the values in the list ",
     Cell[BoxData[
      StyleBox["x", "TI"]], "InlineFormula"],
     " being reset every time a toggler button is clicked."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["TogglerBar",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TogglerBar"], "[", 
       RowBox[{
        StyleBox["x", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           SubscriptBox[
            StyleBox["val", "TI"], 
            StyleBox["1", "TR"]], "->", 
           SubscriptBox[
            StyleBox["lbl", "TI"], 
            StyleBox["1", "TR"]]}], ",", 
          RowBox[{
           SubscriptBox[
            StyleBox["val", "TI"], 
            StyleBox["2", "TR"]], "->", 
           SubscriptBox[
            StyleBox["lbl", "TI"], 
            StyleBox["2", "TR"]]}], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a toggler bar in which the toggler button \
associated with value ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["val", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " has label ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["lbl", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Multiple toggler buttons in a ",
 Cell[BoxData[
  ButtonBox["TogglerBar",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TogglerBar"]], "InlineFormula"],
 " can be depressed at the same time. The values associated with all \
depressed buttons are given in a list."
}], "Notes",
 CellID->334953226],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["val", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["lbl", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " can be strings, boxes, graphics or any other expressions, including \
dynamic expressions. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->482460219]
}], "Notes",
 CellID->8400],

Cell["The following options can be given: ", "Notes",
 CellID->19514],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Appearance",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Appearance"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "the overall appearance of the toggler bar ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaselinePosition",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaselinePosition"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "alignment relative to surrounding text", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaseStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaseStyle"], 
    RowBox[{"{", "}"}], Cell[
    "base style specifications for the toggler bar ", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Enabled",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Enabled"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "whether the toggler bar is enabled, or grayed out ", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->15505],

Cell[TextData[{
 "Possible settings for the ",
 Cell[BoxData[
  ButtonBox["Appearance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Appearance"]], "InlineFormula"],
 " option include:"
}], "Notes",
 CellID->570291772],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], "\"\<Horizontal\>\"", Cell[
    "equally spaced horizontally", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Vertical\>\"", Cell[
    "equally spaced vertically", "TableText"]},
   {Cell["      ", "TableRowIcon"], "\"\<Row\>\"", Cell[
    "laid out like text, allowing linewrapping", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True}}}},
 CellID->39473540],

Cell[TextData[{
 "The settings for ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 " are appended to the default style typically given by the ",
 Cell[BoxData["\"\<TogglerBar\>\""], "InlineFormula"],
 " style in the current stylesheet. "
}], "Notes",
 CellID->307511469]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->559056075],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->25445231],

Cell["Create togglers with a specified state:", "ExampleText",
 CellID->681402169],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TogglerBar", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "5"}], "}"}], ",", 
   RowBox[{"Range", "[", "5", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->263830634],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{BoxForm`var$$ = {2, 5}}, 
   InterpretationBox[
    InterpretationBox[
     StyleBox[GridBox[{
        {
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 1], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 1]& ], {True}, "1"], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 2], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 2]& ], {True}, "2"], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 3], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 3]& ], {True}, "3"], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 4], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 4]& ], {True}, "4"], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 5], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 5]& ], {True}, "5"]}
       },
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Deployed->True],
     TogglerBar[
      Dynamic[BoxForm`var$$], {1, 2, 3, 4, 5}]],
    TogglerBar[BoxForm`var$$, {1, 2, 3, 4, 5}]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{69, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->92158956]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->299343996],

Cell[TextData[{
 "Dynamically change the value of ",
 Cell[BoxData[
  FormBox["x", TraditionalForm]], "InlineMath"],
 StyleBox[":",
  Deletable->True]
}], "ExampleText",
 CellID->25513002],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"TogglerBar", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"Range", "[", "5", "]"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->71253264],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        SetterBox[Dynamic[
          MemberQ[$CellContext`x, 1], 
          BoxForm`TogglerBarFunction[$CellContext`x, 1]& ], {True}, "1"], 
        SetterBox[Dynamic[
          MemberQ[$CellContext`x, 2], 
          BoxForm`TogglerBarFunction[$CellContext`x, 2]& ], {True}, "2"], 
        SetterBox[Dynamic[
          MemberQ[$CellContext`x, 3], 
          BoxForm`TogglerBarFunction[$CellContext`x, 3]& ], {True}, "3"], 
        SetterBox[Dynamic[
          MemberQ[$CellContext`x, 4], 
          BoxForm`TogglerBarFunction[$CellContext`x, 4]& ], {True}, "4"], 
        SetterBox[Dynamic[
          MemberQ[$CellContext`x, 5], 
          BoxForm`TogglerBarFunction[$CellContext`x, 5]& ], {True}, "5"]}
      },
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     Deployed->True],
    TogglerBar[
     Dynamic[$CellContext`x], {1, 2, 3, 4, 5}]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{7., {0., 6.}}]}], "}"}]], "Output",
 ImageSize->{107, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->251720894]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->78508357],

Cell["Include labels:", "ExampleText",
 CellID->68484507],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TogglerBar", "[", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"1", "\[Rule]", "\"\< I \>\""}], ",", 
     RowBox[{"2", "\[Rule]", "\"\< II \>\""}], ",", 
     RowBox[{"3", "\[Rule]", "\"\< III \>\""}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->293611724],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{BoxForm`var$$ = {1}}, 
   InterpretationBox[
    InterpretationBox[
     StyleBox[GridBox[{
        {
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 1], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 1]& ], {True}, "\<\" I \"\>"], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 2], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 2]& ], {True}, "\<\" II \"\>"], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 3], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 3]& ], {True}, "\<\" III \"\>"]}
       },
       BaselinePosition->{1, 1},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Deployed->True],
     TogglerBar[
      Dynamic[BoxForm`var$$], {1 -> " I ", 2 -> " II ", 3 -> " III "}]],
    TogglerBar[BoxForm`var$$, {1 -> " I ", 2 -> " II ", 3 -> " III "}]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{106, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1943448579]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->796606324],

Cell["Values and labels can be any expression:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->482460219],

Cell[BoxData[{
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", 
       RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
     RowBox[{"Axes", "\[Rule]", "False"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "40"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"f", "=", 
   RowBox[{
    SqrtBox["y"], 
    RowBox[{"Tan", "[", 
     RowBox[{
      RowBox[{"\[Alpha]", " ", "y"}], "-", "\[Beta]"}], "]"}]}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"s", "=", "\"\<\[Alpha]\[Beta]\[Gamma]\>\""}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->512949927],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"TogglerBar", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"g", ",", "f", ",", "s"}], "}"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->177086986],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        SetterBox[Dynamic[
          MemberQ[$CellContext`x, 
           Graphics[{{{}, {}, {
               Hue[0.67, 0.6, 0.6], 
               Line[CompressedData["
1:eJwl2Xk4VN//AHBrlsTMHUKlaF9ISmnB+1S2IqWkTQgVkrWEpFIJSUIq2VKW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                "]]}}}, {
            AspectRatio -> GoldenRatio^(-1), AxesOrigin -> {0, 0}, ImageSize -> 
             40, 
             PlotRange -> {{0, 2 Pi}, {-0.9999998592131705, 
               0.9999998782112116}}, PlotRangeClipping -> True, 
             PlotRangePadding -> {
               Scaled[0.02], 
               Scaled[0.02]}}]], BoxForm`TogglerBarFunction[$CellContext`x, 
           Graphics[{{{}, {}, {
               Hue[0.67, 0.6, 0.6], 
               Line[CompressedData["
1:eJwl2Xk4VN//AHBrlsTMHUKlaF9ISmnB+1S2IqWkTQgVkrWEpFIJSUIq2VKW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                "]]}}}, {
            AspectRatio -> GoldenRatio^(-1), AxesOrigin -> {0, 0}, ImageSize -> 
             40, PlotRange -> {{0, 2 Pi}, {-0.9999998592131705, 
               0.9999998782112116}}, PlotRangeClipping -> True, 
             PlotRangePadding -> {
               Scaled[0.02], 
               Scaled[0.02]}}]]& ], {True}, 
         GraphicsBox[{{}, {}, 
           {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwl2Xk4VN//AHBrlsTMHUKlaF9ISmnB+1S2IqWkTQgVkrWEpFIJSUIq2VKW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             "]]}},
          AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
          AxesOrigin->{0, 0},
          ImageSize->40,
          
          PlotRange->
           NCache[{{0, 2 Pi}, {-0.9999998592131705, 0.9999998782112116}}, {{
             0, 6.283185307179586}, {-0.9999998592131705, 
             0.9999998782112116}}],
          PlotRangeClipping->True,
          PlotRangePadding->{
            Scaled[0.02], 
            Scaled[0.02]}]], 
        SetterBox[Dynamic[
          
          MemberQ[$CellContext`x, $CellContext`y^Rational[1, 2] 
           Tan[$CellContext`y $CellContext`\[Alpha] - $CellContext`\[Beta]]], 
          BoxForm`TogglerBarFunction[$CellContext`x, $CellContext`y^
            Rational[1, 2] 
           Tan[$CellContext`y $CellContext`\[Alpha] - $CellContext`\[Beta]]]& \
], {True}, 
         RowBox[{
          SqrtBox["y"], " ", 
          RowBox[{"Tan", "[", 
           RowBox[{
            RowBox[{"y", " ", "\[Alpha]"}], "-", "\[Beta]"}], "]"}]}]], 
        SetterBox[Dynamic[
          MemberQ[$CellContext`x, "\[Alpha]\[Beta]\[Gamma]"], 
          BoxForm`TogglerBarFunction[$CellContext`x, 
           "\[Alpha]\[Beta]\[Gamma]"]& ], {
         True}, "\<\"\[Alpha]\[Beta]\[Gamma]\"\>"]}
      },
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     Deployed->True],
    TogglerBar[
     Dynamic[$CellContext`x], {
      Graphics[{{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Line[CompressedData["
1:eJwl2Xk4VN//AHBrlsTMHUKlaF9ISmnB+1S2IqWkTQgVkrWEpFIJSUIq2VKW
8illTzghhSKlEopCsszMtY6ZCf3O9/n9dZ7X88y5d+a9nXuf0XD03H1UTERE
5JmoiMj/VnEs29C19qIhr/z/10V95ZvmxtrD7YLmkTlkFT7Tdm6J8QTvW/lG
n8n6W9GFXxhzHi48qghMI2uryeXK9JgboHYx9f0esn6xj1mSFJMC64xnWO+9
mQK73VVb78TkwFosLAu4ngM3h23z4mMwrFd6ZKQWjGFT9XbZLb6NcKW0zFjW
uBG8Ai2P5Hl9g6IzVbqlLc1wsvholNiCn7A4e+4HM3Y7fO7dJpPp2A3dPS0H
qqW7IEKbJ1J4oBc0pB6Lbmf2gPeKmluv0tkg9H27NpvfC91Huy+kFrLB2694
wVrxPrBJFXG/8JYNzy7MUCue0QcblTZsQX1s+OSgu/jR/D4Q+/eIizU5sLVv
5mY9iz6I+XTNFOdxwOl4mqJoch/kBuwUlFVwwbKl+bSefj8InU48/eExCP/N
7G247TgADswR/1K/QXj579C8F24DUF0euPVe8CDEOsfWN/kMQLRqxLf9UYPw
wtxv01jIACz5kCX2+ckgrLOMWNybNgDWG3ts6tiDkOu06FrkrwF4yjjyr9Bt
CFTjrU9WHmCDYnlv7S2fIUivEKudfoQNASe84k4FDoH591YTSxc2GL05v2x1
xBD4Nomnlfuxoe1s8p4nj4bgRq5PukUsG6T/tGU+6B2Cd0byDnPescGxzGZX
9LFhCN2LecFrObC6UIVS9RwGH96CCF99DojltDbdPzMMAfNXvbffyoG0VLt9
eWHDoHXfwXqeFQc6Lx2z+/p4GPTSbhpudOeA43Y/9zn0MLxaH1T/I5W4+VZY
1pkRYJzYyGkQ58Lqxn3bdS6MwOHu5twCGS6I1arKlYSNQJhzETtWgQtpJUk3
3t0dgb5DNwvXzeZCZ1J6PPflCOzPv3ZKaTUXHJ0LHuqKjMLPKq9V6+y44DT0
+dWrsFFwDXHtEORwwSEwel9x9Ci0585xCszngq24BTfnzij46dVvGynmgo1S
1eyUrFGISize1EDyaLbhud+5mlHoMF0Qu7SJCysvXtfcKD0GMpMfNTxGubBc
dluVDmMM1BLcrU/xubAkVuLgMpUxeF28rMVnggvq6Wevqiwdg+ug/GW/BA2s
WtdOnukYGEYHna1h0cBnmNzJuzoG67ITn67VoWH0rqh29o0x6HiXF/1Kl4ah
+WXVabfHIERUWLB1PQ39urojNzPHoLjx7pvVQMOP/fMtvd6OgWiEQW+eBQ2V
qVPiWlI84LJVTm0+RkP5spKEhQo8qD39eeEuVxpe5p7WmaPMA05F4fR97jTk
v2bbTV/CA1pyyH+HDw2Zva0v+kx4cGdBbun3czREriryzAjlwSFtT/PLsTTU
rW7uOR3Fg6FtaStk4mmQXjt+2DieB2ZskSuhd2i4vEHPojudXJ/VleqWRMPZ
LUVL51fzYOyCwslvGTQUGzWnDL3nwe72Y9M0HtHAMxmfWfGZBzOkDys6ZtPg
Y64n6dDNg9YropH1OTS4WRf9ShIfhzfbY9q2FdOQZdO8/+T0cdCK3zjdpoSG
nv3jH/RZ41Au4pJ9sJSGI4f1ytvmj8OnmOObdryiYf+xogTVLePgrDca2fyW
BlP/oj23LoyD7jzxuAtfyPcNbK5zDhuHFS4b41nNJH5B45t1o8ehKFZNLOUb
DYYX9VY1pYzDs0AvpZQ2GtZFFMkx8Ti8WuaubvSLhlORzZd+vhmH9IuqxxI6
aciNGhfmNIzDqlt5VF8XDVqxen2W7ePALvdK8eyhYWFiUXXk5Djkr6sJ1hig
wTG5Wd9Wkg+XWq6ObGTTkJo6nrdiBh9mDva+t+DQMCddL61uDh9yt0T+d4Cm
4WDmPtWEhXxQd7fKtR6k4c6jM9GumnzY2F0222yI1NfTomBpfT60XM9QURmh
Ydez5rHmrXwYXJmfPUoclTvunmnOh5HJa/drR2mQLdI7ZHKIDw2CxnxbHg1m
L/Z9UnLiw/RZ7R9njdMQ+vLMtt9u5PvsHNv1kVjsVZHe5UA+WH25dWqJgIbH
M6iMyRA+REr82vWZePchd8Uz1/jwI6tZ119IgzDrTchgLB9u1pirs/7S8ICn
PuSayAdtLpOVTmxhdNa+6yEfQpeKzlg5Qer/5pd62yd8KJAdmfGU2Egr4vHO
cj5MZlktjJ2kgR3YrVL7hg+WGsEb+MRxNYZXt3zgw8QLzb3WUzToz7w79rKZ
D/sSt57JJP7tNOK09icf1vllpwwRRz3f8elpLx/+BexsWP2P5PNfJlo6xIcn
dmriJ4jbLcRy7gv40GQvaZhAHJpgqzZbTADpBsLgV8QrewuvxckKYFx/qPoH
8de1TOEMlgC2LumkhomDL51wuTpbAI+3vz06SbzkY/VXkYUCGA1IKv9H3DhX
3ThQUwC35JzVBMT+7oF5I7oCyG6fE9JHrF7yWeOkgQAmdr1nNxLXSGlH9xgL
gGcWcDiH2Gtv+JS9pQByVml9vkys8qDLvcVGAB28kV1WxK8GDdp22xPLf29S
JHY1vLPt/XEBPPDi2X4gv5+KHC4y9hLAizs27AvEJS0Wi7G/AAzDqJBlxI5L
MuPWXxTA99db5taS+MqeFhXPDRdA5X6xCnvi3MpD3itiBJD8ycONQ/JzkFHY
8TBBADeMs2b5EIvZMSznPhDAgm0fP3JIfrOz3UpvZwvAXCAf7UBsLXi9nJkv
gB28sL11pD4mTObdjSgVQJmz6/wVxBadTafP1QvgVBnV9JFP6kF7ZTfvC/n9
V/SLlIkTz4Xt9moXAAqKemBN6pGjYqDtRAvg/KGwW3ljJL87M3rNmEJy/nj8
lhwm+U0S2VepKoTscUemBOmP9v6D1ZvmC+FI7llTAekn7VCFtJVrhEDrmjXV
kH5rLPU/pLhXCA3ms30mekl+ZJtqrx8Wgro0PZ77h+Rnv9Z6qWNC0Da4HOFA
+tlr5Jei0E8I4tbezamk35nLzRs67ghhZ5zN7MIfZD5JpTBrUoUwcNJHG30n
8f49bP0sSwjJsUFnK1tpcL6f0HahWAi5Nz+V5pD5U6zS36vxTQiHjmjTmh9p
uM4z0JT9KQSGzcF6/w8kP59veg7/EcKS+Jie0noapkdv4FWOC4Eb3v5Oq44G
O6lwcWflv8D21vPIraRhze/vJhbz/oLfY0rnFZmH0lWrInSX/IWG5NjVb8pJ
PoO/MST1/kLbqN9ICZmnkrwlczNs/oLUUHmgaS4N/3W/Wd976y8UC48qcVJo
uFg5K6gx6S98DH4qcp7Md5tUD1yc/hfqZTeskblHg4jtTJPwgr9Qeeyc1zRy
PuxpOrpn+Ze/8G5Q7vDDa2QeVEh4uCtOQCqvMsrjNJk3KVseDMZMwJswuU2b
t9JwtabxR8i9CSiefXpRHDnf3gzZqSg9JJ83XqXSvokGY6Oz1zcUTMC8i12z
9pHzcUtf3pmQ5gn4cfl53o+FpP/XLLJQnDMJ2eHjKw3JebvqrdSYXvokXIzv
yrUu5YLn4C3tuieTgJ5d6Yso4sJT1YVutoWT8Hrf5Z3FuVzQckcdF95Ogozs
ghx+FjnfmQG1tX2TUHjduFvhFhcWHupPOrRyCk5kH3G9e4ILyvR7k/NFU1Ap
2Rm0gOLCnZv4SB+egqiLZsp2clxQ0c0N2lMzBS8zlzlGTyMOuJ27pIXs76pV
+C7kwCxxx7mNwinQ0pbgK3RxYK7y+Ji64T8Y6xzxHHjOgcWgkV75+h9k+I8z
z23jQMLbElFxVxF0SPHnIl8HNgz+fBZAu4sgx2eJWSvJ85+pMGOozUsEHXuc
cKDLig2jmrG/8v1F0EK1IzvWb2WDZcyJimNhIkjJPfVJ9CI2iB2ec7EuUwSV
fArtnOgdgBPD50RiekRQULOISCN5PtVX2/xP3VkUNV4NO1B/sB/MbD/7OLqI
om8dVT0aVv1gfe94zwN3UXRQcEXU07QfTqhG1S8+LYra/yb0D6/phwSltnua
oaLoQ/HRb/fl+oE/4/T69Vmi6Gy5SVxyaR/kT2V572SLoqsxJmFLlPtgxU9G
97lTYuiA3ki3WtEfeJJFuRT4iCM5ntQHr45uCGo/3LQiVAL92H102SWPX+Ct
v948OU4SBTWaxq0JbgNhipHjQPQ01Npjcb9m5Wdo9EpwOJMmhebKBSz1+fwW
NpjOn/pxXxp9/Cp3bErkGdQab8hCiTJoQ6Pd3JzIpzj9+d0NndmyqJGlrp9+
pgYrLdB0s3s0HVkvyV1o8rsJfxKVDlEtlUMSdSmPdFvbcIG0b0Zj7QwUF7Cq
oCr+F9ZUYrg5VsujFdEP9tu+7MZ0FE9xzVcFtOo6s2tx7R/MHpxbqdWqgExS
qkpqm/7g/t2mnkvbFVA1vefJsfY/uHvmnVq1HuKJG9+iRv7g1uQNwdI8BbQx
xmLqtlovdtxXPsKVZSD15Y5brnn14h3HRQ+/Xs5AW5Ocm7uYfXjB1avanm4M
JFNrE9K0uR/7fNUNdnRnoHWF4gkvt/fjV4s63+/1YKCl7ce8k/b0Y7vX+m76
Pgx0s63dxvJoP04QHX4oE8hAJwY+VjiH9WMqyHbWw3AG8reMNnGs78di3jqS
LVkM5HpkovHm7gFs9ap9z/vHDKQVrvT7ycEBnKoQmYb/Y6CgeH3/KscBbPi0
BzKeMdD355KKbT4DOHDgXqBvMQOF/2GxX8YM4OGj0wZn1DBQ44eSM1s+DuDO
g22tW/4wkI7x5jk229hYzmBfpkMfAyWXtX3Qt2LjtfOafIMHGIgjrxA/+wAb
h3XVyZXQDDTLxseqwoWNtd1LDHX4DORWNM30yVU2Djp3N22eDBM9dog1l3zN
xkqp+9wmljPRbulIjcx1HGwY0rRulhYTlR3/JB9pwMEuzjvF12szkcnSiPcu
RhxcutQ00XcNE+n3pz6X2c3Bjs/XNfRvYqKqRh1OrzsHP61UWt1iwUQa6mlX
Z9/nYLPfTYICDybqXmDx3Eici8+tiDqb48VEpqVxIy+luTjX22wyy4eJzt1U
714hz8Wzp0pFEv2Y6G1HYd2YChdzZ2ZIhQQz0VS0brjOSi6OM/NXsoxiok9a
0v+Z7uPin9lzdHqeMFF9igL79wMuVhr+mtuRw0Srn5mEeWVx8fb1N3VbnjNR
xqkv2SP/cXHea8n17wuY6OnvW5e7Crg49AfXMLeMiVYwzO1c35JXWYUKi+B6
JhLk1VbL9XGxv89Rl5kcJtqT5mifvZjGYebc4xtpJtpcu2pazHIa31545rjd
EBMdZ4u98lxJ48KvYccyxpgoYsDUhbGOxiMb/3NeN8VEXb5j7j1GNPYQH3Gw
UaBQpKuFbbcDjc99P+sQyKTQ4vGZ+ZucaRxZIOGQzKKQyZ8j8hHHaZx9fKZ9
jzKFKN7zN9M9aNz7bsNhP3UKccwPaj4IpLFT3IUD8ToUYsiBpEYMjX1Oyhwo
WUOhvttKqr1xNA4xidnfvpZCeyfPamTcpnEq/8G+xRspFJv3VU4qicbttm/3
Fm6h0IJI1/W2mTTmrN21t9WIQikhu9taH9F4Qr7FesqEQpvOvnPf9R+NZ1f0
7zExp5Dn1+T96s9pvH+R/O6veyi00rcQ7SmhsctUvJVwL4UiIvlG4aU0PtM8
z2rufgotk/ReXVhO4/hwnV3HbCm04ln4m9FKGjdxrC15zhRylYmslHhHY8vC
e9tn+lFo4+yRa54t5Hojjv+U/Cm0Re7eLn4rjS+tWp6vFEgh/bE29YDvNC5+
XKymFEwhH4vHnY4dNJ6f8mWQFUqhRem+v75201j/e2I6K4zES7yRP6+HxvtU
nQ+yIijksGVC5cgfEu/Y4SoqikIv717xeddHY95VhdvMeAqxMCsEcWnMqP5q
zrxD9m+627yNpvEKsWQRZgLJR/3DNeaDNHYI0nRjJFPooerOqbXDNA58MTKX
kUqh0ya+7vNGaHyLV9KkkEbstvSnyCiN67y2GShkUCjZ+Vhz9hiNu58whuWz
KGSdePngaR6N//U3Z8g/JvGNsutcN05j3aPHGPJPKTTHKvTffT6JT5pW9Yxn
5P6nA+LMBTR27RgNmJFLIVOhjxaHOPnApS65QgodL2txU/lL4hO//Y5cMYVG
Nk/IpxE3NTF3yJVQSLHgRuGCCRpzGS2icqUU8ij0PZJELG2ZWji9nEJru8MV
FCZJPK8dPzH9FYUM2wpe+RMb1KxUn15JIXG9H6daifdL8j7LvqZQ5s0/K3Sn
SP1tKQuXfUOhyUvlv68QR56/bChbQ6GY9B1p5HkbZ5aaj8jUUei/yJAjzH80
rhRQWTLvKbS7wWKBOfH3da22Mg0U2jWV9CeImOd7nynTSKENOa5PM4iZz13e
SH+i0EkfchoRa3K1z0p/ppDyN7OtncQmK8a1pb9SaI3nDuYosYNLebfUNwpF
Vz/9Rd4/8Nn0K3elWinUcNwtn7x/4PhOC0up76Qefp0PJ+8f+Nk8RXGpdtKf
pYMOA8R1tm1F036S+4W82viF+PfdNPdpnaQeSkZnFhGLNLtqTOumUC07biya
eJaizlfJHrI/6fFXR2JdK36EZC+FrlttLtEk3hmFQbKf7L92LJVL4uH2LnRU
gk3i07AsPIv4srTlIwkuhZYkJJ46SJxsrGQnMUghpscnRwniFyHfKYlhCnnX
/NyTQeLPnXALEudRKErsj+Enkr8D+82XCcYpdMJRJMmO+HXeiq9cAYWaq0t3
dJH833Vja7dOUkjkU3zmFyGNJd68//7hH6mfNWO7thJ7aDwJrxZlIQ0Z/x2P
SD0ZfTvZ9UyShQLfXkB2pP5y1lhGZ0ixkPUiG70npD5n3VhpkCjDQg6d3Iuj
pH4Hjen4qzNYaHqmGsud1Pe9PK/tdkrEuWXL/w3ReJqC1fgeZRY6EMR9zSD2
ctN5uE2VhcZ/+OfPIv1kojE8qavGQk/OhsUpk/4bjvJ9Pn0RC/kVBtkXkP48
3L/HTnQJC73l2mSH99K4xlh3+vhSFkouibe0If2cNDHq3KlJ9gs9E7+R/jdz
81N5octCOVfk7S6S+ZBXbVP9dB0Lcbqvn1Rpp/FcDT2fh+tZKMp/9GsmmScj
zePvbuizkMFwa3FOy//iH3D+mBELFfVpVTk10Vjm/gFNWxMW6n0nzC77SONT
ExtarMxY6IJoxpBCI4235QlXG1iwkHnD2ltJ72k8qh7Uw7JmoVl2PLPD1TS2
D7KNlbFhofzTzgsDq0h9Neujf/tIPHepOdyooHFK1OTd/kMstGOnmTCtjMbb
J4J3VDix0NLf3954FND4fvPFfA9fFoqfdUPn7gMa91Sv6og6zUJCVFgkfZ/0
Q36HTM4ZFpoBRjs9k8l5FG1gT59loSvs0AKNuzR+v00g43WZhTbYNfnOjqIx
/6WXvfctcn2rla5OfjQ2fDwv4uZtFtKuP+hk5Evm7Z2G/Od3SX4bW8/O8aKx
/GlN2eEkFvIPd5me60rjBSt7830yWOjcgEW5jy2ZT6n2sqeKWEhRXNTMHNE4
Lkp+bdwLFmq1/HQ7WZ/GLUFl9vkvWai++ahS33oaOx+YXTCKWejf02nJTjo0
DqCa7U/XsFDoanVxWoPGDy9bFvi1sFAP217RQZTGQhcDh4C/LPSpPiIm7wU5
318uR6cnWajq+eOLiJzn92aoqHv/YyH3k5Jd1c+4WD93uMNFXBE1BX8RKcnk
4uC/mfb7pysizrmVNaa3uFg8irLXm62InuSYhwo9uFgu78/hsY2KqOK/vYuq
53CxreQXgyF9RbT1/dw0R2UufrKvUo1jqIjqKX4Rn8nFlhOJP7q3KKKEmFX5
8lJcHG28+/Dn7YooM/m0YucgByt+K7XNO6iIemsWZS2p4mC1yZuHvAOJ/ySo
rnckz0edO17cDlJEnQ152s6HOPjUWxnl8mBFVDj4qe6qNQfX3bz4SfaSIpJv
Yt0pMOFgv8Xe2x5eU0Q/LhW/yV7OwY07d+k1JyqiixJWBhJDbBySJs8ywIqo
tVhp76kzbNxjeq1OWkIJ2dpz1nw4MYAdzR3UF01TQue3BeooOw3gH5Zr/TZL
K6EJwa+ofeR59fPeDo1AOSX0W1vMt8JsAFc6rQkYUCRWRos2LhrASefbljQs
UkJWox52Fd/7sXXRiiuxpkootfHQ+HqTfly1+D3MvaaEmp1eaziK92E36QwJ
DZmZyM9Ydnu9fQ8uSl1oUHVzJpIq03Ir1ejCDZv0q3czlVGoT0l11e0OzHe7
t8chShlpF1mXvI39hmt2peydMVMFTbZ/e6se1YgdN+hnZsapoHt+tllqiRU4
7ds5919qqui9y5UNice9sGaosGmI2HVXlcvUIi9cuObMJrG5qkgHurQqajzx
uygv2QXETLsjP7dVeuBRI6csZ2JGgaPWoQJ3bPLcrPsP8SWuhOe5ey64P5xl
y52niugajfpXxx3wKb3oqinijurmQZlaezzVLbdCQZ3cz2mvcUylHankaUJt
4huvrXrTCmyxPo9/25vYavNqldf39uMox/amUeIkv6yV01x2YRXGoU2SGqpI
aaqxeU6VJU4ra05TIi59Yr5Lq9ACF6l89F5H7FRassky0Qz/bKhS8Cd+22Ys
Eu2CsFsQOhNGfEKh4jsq0sejy8ra7xAXe7GKjiStx9JXCp+8IL62dsHxB66r
cMzqNUp1xIoqXwLDUpbiOT9zglqJ3z+oXlR3Qh1nXNfs7ic+KWaUouzFwDqb
Hpn/JV6oc/1//3eV/x8h6tFh
           "]]}}}, {
       AspectRatio -> GoldenRatio^(-1), AxesOrigin -> {0, 0}, ImageSize -> 40,
         PlotRange -> {{0, 2 Pi}, {-0.9999998592131705, 0.9999998782112116}}, 
        PlotRangeClipping -> True, PlotRangePadding -> {
          Scaled[0.02], 
          Scaled[0.02]}}], $CellContext`y^Rational[1, 2] 
      Tan[$CellContext`y $CellContext`\[Alpha] - $CellContext`\[Beta]], 
      "\[Alpha]\[Beta]\[Gamma]"}]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{7., {0., 6.}}]}], "}"}]], "Output",
 ImageSize->{221, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->228008507]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->445532085],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Appearance",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->547197110],

Cell["Set the orientation:", "ExampleText",
 CellID->163409260],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"TogglerBar", "[", 
    RowBox[{
     RowBox[{"{", "}"}], ",", 
     RowBox[{"Range", "[", "3", "]"}], ",", 
     RowBox[{"Appearance", "\[Rule]", "a"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"\"\<Horizontal\>\"", ",", "\"\<Vertical\>\""}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->222157194],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = {}}, 
     InterpretationBox[
      InterpretationBox[
       StyleBox[GridBox[{
          {
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 1], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 1]& ], {True}, "1"], 
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 2], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 2]& ], {True}, "2"], 
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 3], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 3]& ], {True}, "3"]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Deployed->True],
       TogglerBar[
        Dynamic[BoxForm`var$$], {1, 2, 3}]],
      TogglerBar[BoxForm`var$$, {1, 2, 3}, Appearance -> "Horizontal"]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = {}}, 
     InterpretationBox[
      InterpretationBox[
       StyleBox[GridBox[{
          {
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 1], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 1]& ], {True}, "1",
            Appearance->"Palette"]},
          {
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 2], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 2]& ], {True}, "2",
            Appearance->"Palette"]},
          {
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 3], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 3]& ], {True}, "3",
            Appearance->"Palette"]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.5599999999999999]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Deployed->True],
       TogglerBar[
        Dynamic[BoxForm`var$$], {1, 2, 3}, Appearance -> "Vertical"]],
      TogglerBar[BoxForm`var$$, {1, 2, 3}, Appearance -> "Vertical"]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ]}], "}"}]], "Output",
 ImageSize->{90, 65},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->889237436]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->255204788],

Cell["\"Row\" allows linewrapping, while \"Horizontal\" does not:", \
"ExampleText",
 CellID->572967398],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TogglerBar", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"Range", "[", "30", "]"}], ",", 
   RowBox[{"Appearance", "\[Rule]", "\"\<Horizontal\>\""}]}], "]"}]], "Input",\

 CellLabel->"In[1]:=",
 CellID->223347823],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{BoxForm`var$$ = {}}, 
   InterpretationBox[
    InterpretationBox[
     StyleBox[GridBox[{
        {
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 1], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 1]& ], {True}, "1"], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 2], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 2]& ], {True}, "2"], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 3], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 3]& ], {True}, "3"], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 4], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 4]& ], {True}, "4"], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 5], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 5]& ], {True}, "5"], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 6], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 6]& ], {True}, "6"], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 7], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 7]& ], {True}, "7"], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 8], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 8]& ], {True}, "8"], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 9], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 9]& ], {True}, "9"], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 10], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 10]& ], {True}, "10"], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 11], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 11]& ], {True}, "11"], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 12], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 12]& ], {True}, "12"], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 13], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 13]& ], {True}, "13"], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 14], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 14]& ], {True}, "14"], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 15], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 15]& ], {True}, "15"], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 16], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 16]& ], {True}, "16"], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 17], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 17]& ], {True}, "17"], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 18], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 18]& ], {True}, "18"], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 19], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 19]& ], {True}, "19"], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 20], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 20]& ], {True}, "20"], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 21], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 21]& ], {True}, "21"], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 22], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 22]& ], {True}, "22"], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 23], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 23]& ], {True}, "23"], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 24], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 24]& ], {True}, "24"], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 25], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 25]& ], {True}, "25"], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 26], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 26]& ], {True}, "26"], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 27], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 27]& ], {True}, "27"], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 28], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 28]& ], {True}, "28"], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 29], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 29]& ], {True}, "29"], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 30], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 30]& ], {True}, "30"]}
       },
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Deployed->True],
     TogglerBar[
      Dynamic[BoxForm`var$$], {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 
      15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30}]],
    TogglerBar[
    BoxForm`var$$, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17,
      18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30}, Appearance -> 
     "Horizontal"]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{541, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->227079357]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TogglerBar", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"Range", "[", "30", "]"}], ",", 
   RowBox[{"Appearance", "\[Rule]", "\"\<Row\>\""}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->662520130],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{BoxForm`var$$ = {}}, 
   InterpretationBox[
    InterpretationBox[
     StyleBox[
      RowBox[{
       SetterBox[Dynamic[
         MemberQ[BoxForm`var$$, 1], BoxForm`TogglerBarFunction[
         BoxForm`var$$, 1]& ], {True}, "1"], 
       SetterBox[Dynamic[
         MemberQ[BoxForm`var$$, 2], BoxForm`TogglerBarFunction[
         BoxForm`var$$, 2]& ], {True}, "2"], 
       SetterBox[Dynamic[
         MemberQ[BoxForm`var$$, 3], BoxForm`TogglerBarFunction[
         BoxForm`var$$, 3]& ], {True}, "3"], 
       SetterBox[Dynamic[
         MemberQ[BoxForm`var$$, 4], BoxForm`TogglerBarFunction[
         BoxForm`var$$, 4]& ], {True}, "4"], 
       SetterBox[Dynamic[
         MemberQ[BoxForm`var$$, 5], BoxForm`TogglerBarFunction[
         BoxForm`var$$, 5]& ], {True}, "5"], 
       SetterBox[Dynamic[
         MemberQ[BoxForm`var$$, 6], BoxForm`TogglerBarFunction[
         BoxForm`var$$, 6]& ], {True}, "6"], 
       SetterBox[Dynamic[
         MemberQ[BoxForm`var$$, 7], BoxForm`TogglerBarFunction[
         BoxForm`var$$, 7]& ], {True}, "7"], 
       SetterBox[Dynamic[
         MemberQ[BoxForm`var$$, 8], BoxForm`TogglerBarFunction[
         BoxForm`var$$, 8]& ], {True}, "8"], 
       SetterBox[Dynamic[
         MemberQ[BoxForm`var$$, 9], BoxForm`TogglerBarFunction[
         BoxForm`var$$, 9]& ], {True}, "9"], 
       SetterBox[Dynamic[
         MemberQ[BoxForm`var$$, 10], BoxForm`TogglerBarFunction[
         BoxForm`var$$, 10]& ], {True}, "10"], 
       SetterBox[Dynamic[
         MemberQ[BoxForm`var$$, 11], BoxForm`TogglerBarFunction[
         BoxForm`var$$, 11]& ], {True}, "11"], 
       SetterBox[Dynamic[
         MemberQ[BoxForm`var$$, 12], BoxForm`TogglerBarFunction[
         BoxForm`var$$, 12]& ], {True}, "12"], 
       SetterBox[Dynamic[
         MemberQ[BoxForm`var$$, 13], BoxForm`TogglerBarFunction[
         BoxForm`var$$, 13]& ], {True}, "13"], 
       SetterBox[Dynamic[
         MemberQ[BoxForm`var$$, 14], BoxForm`TogglerBarFunction[
         BoxForm`var$$, 14]& ], {True}, "14"], 
       SetterBox[Dynamic[
         MemberQ[BoxForm`var$$, 15], BoxForm`TogglerBarFunction[
         BoxForm`var$$, 15]& ], {True}, "15"], 
       SetterBox[Dynamic[
         MemberQ[BoxForm`var$$, 16], BoxForm`TogglerBarFunction[
         BoxForm`var$$, 16]& ], {True}, "16"], 
       SetterBox[Dynamic[
         MemberQ[BoxForm`var$$, 17], BoxForm`TogglerBarFunction[
         BoxForm`var$$, 17]& ], {True}, "17"], 
       SetterBox[Dynamic[
         MemberQ[BoxForm`var$$, 18], BoxForm`TogglerBarFunction[
         BoxForm`var$$, 18]& ], {True}, "18"], 
       SetterBox[Dynamic[
         MemberQ[BoxForm`var$$, 19], BoxForm`TogglerBarFunction[
         BoxForm`var$$, 19]& ], {True}, "19"], 
       SetterBox[Dynamic[
         MemberQ[BoxForm`var$$, 20], BoxForm`TogglerBarFunction[
         BoxForm`var$$, 20]& ], {True}, "20"], 
       SetterBox[Dynamic[
         MemberQ[BoxForm`var$$, 21], BoxForm`TogglerBarFunction[
         BoxForm`var$$, 21]& ], {True}, "21"], 
       SetterBox[Dynamic[
         MemberQ[BoxForm`var$$, 22], BoxForm`TogglerBarFunction[
         BoxForm`var$$, 22]& ], {True}, "22"], 
       SetterBox[Dynamic[
         MemberQ[BoxForm`var$$, 23], BoxForm`TogglerBarFunction[
         BoxForm`var$$, 23]& ], {True}, "23"], 
       SetterBox[Dynamic[
         MemberQ[BoxForm`var$$, 24], BoxForm`TogglerBarFunction[
         BoxForm`var$$, 24]& ], {True}, "24"], 
       SetterBox[Dynamic[
         MemberQ[BoxForm`var$$, 25], BoxForm`TogglerBarFunction[
         BoxForm`var$$, 25]& ], {True}, "25"], 
       SetterBox[Dynamic[
         MemberQ[BoxForm`var$$, 26], BoxForm`TogglerBarFunction[
         BoxForm`var$$, 26]& ], {True}, "26"], 
       SetterBox[Dynamic[
         MemberQ[BoxForm`var$$, 27], BoxForm`TogglerBarFunction[
         BoxForm`var$$, 27]& ], {True}, "27"], 
       SetterBox[Dynamic[
         MemberQ[BoxForm`var$$, 28], BoxForm`TogglerBarFunction[
         BoxForm`var$$, 28]& ], {True}, "28"], 
       SetterBox[Dynamic[
         MemberQ[BoxForm`var$$, 29], BoxForm`TogglerBarFunction[
         BoxForm`var$$, 29]& ], {True}, "29"], 
       SetterBox[Dynamic[
         MemberQ[BoxForm`var$$, 30], BoxForm`TogglerBarFunction[
         BoxForm`var$$, 30]& ], {True}, "30"]}],
      Deployed->True],
     TogglerBar[
      Dynamic[BoxForm`var$$], {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 
      15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30}, 
      Appearance -> "Row"]],
    TogglerBar[
    BoxForm`var$$, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17,
      18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30}, Appearance -> 
     "Row"]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{353, 46},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->24555414]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Background",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->62433962],

Cell["Change the background color:", "ExampleText",
 CellID->334399289],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"TogglerBar", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2", ",", "5"}], "}"}], ",", 
     RowBox[{"Range", "[", "5", "]"}], ",", 
     RowBox[{"Background", "\[Rule]", "c"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"c", ",", 
     RowBox[{"{", 
      RowBox[{"Pink", ",", "Gray", ",", "Yellow", ",", "Purple"}], "}"}]}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->344487064],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = {2, 5}}, 
     InterpretationBox[
      InterpretationBox[
       StyleBox[GridBox[{
          {
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 1], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 1]& ], {True}, "1",
            Background->RGBColor[1, 0.5, 0.5]], 
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 2], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 2]& ], {True}, "2",
            Background->RGBColor[1, 0.5, 0.5]], 
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 3], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 3]& ], {True}, "3",
            Background->RGBColor[1, 0.5, 0.5]], 
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 4], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 4]& ], {True}, "4",
            Background->RGBColor[1, 0.5, 0.5]], 
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 5], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 5]& ], {True}, "5",
            Background->RGBColor[1, 0.5, 0.5]]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Deployed->True],
       TogglerBar[
        Dynamic[BoxForm`var$$], {1, 2, 3, 4, 5}, Background -> 
        RGBColor[1, 0.5, 0.5]]],
      TogglerBar[
      BoxForm`var$$, {1, 2, 3, 4, 5}, Background -> RGBColor[1, 0.5, 0.5]]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = {2, 5}}, 
     InterpretationBox[
      InterpretationBox[
       StyleBox[GridBox[{
          {
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 1], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 1]& ], {True}, "1",
            Background->GrayLevel[0.5]], 
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 2], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 2]& ], {True}, "2",
            Background->GrayLevel[0.5]], 
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 3], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 3]& ], {True}, "3",
            Background->GrayLevel[0.5]], 
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 4], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 4]& ], {True}, "4",
            Background->GrayLevel[0.5]], 
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 5], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 5]& ], {True}, "5",
            Background->GrayLevel[0.5]]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Deployed->True],
       TogglerBar[
        Dynamic[BoxForm`var$$], {1, 2, 3, 4, 5}, Background -> 
        GrayLevel[0.5]]],
      TogglerBar[
      BoxForm`var$$, {1, 2, 3, 4, 5}, Background -> GrayLevel[0.5]]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = {2, 5}}, 
     InterpretationBox[
      InterpretationBox[
       StyleBox[GridBox[{
          {
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 1], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 1]& ], {True}, "1",
            Background->RGBColor[1, 1, 0]], 
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 2], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 2]& ], {True}, "2",
            Background->RGBColor[1, 1, 0]], 
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 3], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 3]& ], {True}, "3",
            Background->RGBColor[1, 1, 0]], 
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 4], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 4]& ], {True}, "4",
            Background->RGBColor[1, 1, 0]], 
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 5], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 5]& ], {True}, "5",
            Background->RGBColor[1, 1, 0]]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Deployed->True],
       TogglerBar[
        Dynamic[BoxForm`var$$], {1, 2, 3, 4, 5}, Background -> 
        RGBColor[1, 1, 0]]],
      TogglerBar[
      BoxForm`var$$, {1, 2, 3, 4, 5}, Background -> RGBColor[1, 1, 0]]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], ",", 
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = {2, 5}}, 
     InterpretationBox[
      InterpretationBox[
       StyleBox[GridBox[{
          {
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 1], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 1]& ], {True}, "1",
            Background->RGBColor[0.5, 0, 0.5]], 
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 2], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 2]& ], {True}, "2",
            Background->RGBColor[0.5, 0, 0.5]], 
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 3], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 3]& ], {True}, "3",
            Background->RGBColor[0.5, 0, 0.5]], 
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 4], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 4]& ], {True}, "4",
            Background->RGBColor[0.5, 0, 0.5]], 
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 5], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 5]& ], {True}, "5",
            Background->RGBColor[0.5, 0, 0.5]]}
         },
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Deployed->True],
       TogglerBar[
        Dynamic[BoxForm`var$$], {1, 2, 3, 4, 5}, Background -> 
        RGBColor[0.5, 0, 0.5]]],
      TogglerBar[
      BoxForm`var$$, {1, 2, 3, 4, 5}, Background -> RGBColor[0.5, 0, 0.5]]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ]}], "}"}]], "Output",
 ImageSize->{332, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->139871165]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "BaselinePosition",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->788277890],

Cell["Align with surrounding text:", "ExampleText",
 CellID->7865244],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Row", "[", 
  RowBox[{
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"TogglerBar", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", "5"}], "}"}], ",", 
       RowBox[{"Range", "[", "5", "]"}], ",", 
       RowBox[{"BaselinePosition", "\[Rule]", "p"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"{", 
        RowBox[{"Top", ",", "Center", ",", "Bottom"}], "}"}]}], "}"}]}], 
    "]"}], ",", "\"\<xxx\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->29425190],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = {2, 5}}, 
     InterpretationBox[
      InterpretationBox[
       StyleBox[GridBox[{
          {
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 1], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 1]& ], {True}, "1",
            BaselinePosition->Top], 
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 2], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 2]& ], {True}, "2",
            BaselinePosition->Top], 
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 3], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 3]& ], {True}, "3",
            BaselinePosition->Top], 
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 4], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 4]& ], {True}, "4",
            BaselinePosition->Top], 
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 5], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 5]& ], {True}, "5",
            BaselinePosition->Top]}
         },
         BaselinePosition->{1, 1},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Deployed->True],
       TogglerBar[
        Dynamic[BoxForm`var$$], {1, 2, 3, 4, 5}, BaselinePosition -> Top]],
      TogglerBar[BoxForm`var$$, {1, 2, 3, 4, 5}, BaselinePosition -> Top]],
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], "xxx", 
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = {2, 5}}, 
     InterpretationBox[
      InterpretationBox[
       StyleBox[GridBox[{
          {
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 1], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 1]& ], {True}, "1",
            BaselinePosition->Center], 
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 2], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 2]& ], {True}, "2",
            BaselinePosition->Center], 
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 3], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 3]& ], {True}, "3",
            BaselinePosition->Center], 
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 4], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 4]& ], {True}, "4",
            BaselinePosition->Center], 
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 5], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 5]& ], {True}, "5",
            BaselinePosition->Center]}
         },
         BaselinePosition->{1, 1},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Deployed->True],
       TogglerBar[
        Dynamic[BoxForm`var$$], {1, 2, 3, 4, 5}, BaselinePosition -> Center]],
      
      TogglerBar[BoxForm`var$$, {1, 2, 3, 4, 5}, BaselinePosition -> Center]],
     
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ], "xxx", 
   TagBox[
    DynamicModuleBox[{BoxForm`var$$ = {2, 5}}, 
     InterpretationBox[
      InterpretationBox[
       StyleBox[GridBox[{
          {
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 1], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 1]& ], {True}, "1",
            BaselinePosition->Bottom], 
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 2], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 2]& ], {True}, "2",
            BaselinePosition->Bottom], 
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 3], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 3]& ], {True}, "3",
            BaselinePosition->Bottom], 
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 4], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 4]& ], {True}, "4",
            BaselinePosition->Bottom], 
           SetterBox[Dynamic[
             MemberQ[BoxForm`var$$, 5], BoxForm`TogglerBarFunction[
             BoxForm`var$$, 5]& ], {True}, "5",
            BaselinePosition->Bottom]}
         },
         BaselinePosition->{1, 1},
         GridBoxSpacings->{"Columns" -> {
             Offset[0.27999999999999997`], {
              Offset[0.]}, 
             Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
           "Rows" -> {
             Offset[0.2], {
              Offset[0.4]}, 
             Offset[0.2]}, "RowsIndexed" -> {}}],
        Deployed->True],
       TogglerBar[
        Dynamic[BoxForm`var$$], {1, 2, 3, 4, 5}, BaselinePosition -> Bottom]],
      
      TogglerBar[BoxForm`var$$, {1, 2, 3, 4, 5}, BaselinePosition -> Bottom]],
     
     DynamicModuleValues:>{}],
    Setting[#, {0}]& ]}],
  Row[{
    TogglerBar[{2, 5}, {1, 2, 3, 4, 5}, BaselinePosition -> Top], 
    TogglerBar[{2, 5}, {1, 2, 3, 4, 5}, BaselinePosition -> Center], 
    TogglerBar[{2, 5}, {1, 2, 3, 4, 5}, BaselinePosition -> Bottom]}, 
   "xxx"]]], "Output",
 ImageSize->{268, 44},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->403137839]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Enabled",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->478789917],

Cell[TextData[{
 "By default, ",
 Cell[BoxData[
  ButtonBox["TogglerBar",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TogglerBar"]], "InlineFormula"],
 " is enabled:"
}], "ExampleText",
 CellID->85613096],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TogglerBar", "[", 
  RowBox[{
   RowBox[{"{", "}"}], ",", 
   RowBox[{"Range", "[", "5", "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->745797472],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{BoxForm`var$$ = {}}, 
   InterpretationBox[
    InterpretationBox[
     StyleBox[GridBox[{
        {
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 1], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 1]& ], {True}, "1"], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 2], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 2]& ], {True}, "2"], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 3], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 3]& ], {True}, "3"], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 4], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 4]& ], {True}, "4"], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 5], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 5]& ], {True}, "5"]}
       },
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Deployed->True],
     TogglerBar[
      Dynamic[BoxForm`var$$], {1, 2, 3, 4, 5}]],
    TogglerBar[BoxForm`var$$, {1, 2, 3, 4, 5}]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{69, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->175535375]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->471273535],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  ButtonBox["Enabled",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Enabled"]], "InlineFormula"],
 " \[Rule] ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 ", the toggler bar is disabled but visible in its current state:"
}], "ExampleText",
 CellID->85404114],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TogglerBar", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"2", ",", "5"}], "}"}], ",", 
   RowBox[{"Range", "[", "5", "]"}], ",", 
   RowBox[{"Enabled", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->286289235],

Cell[BoxData[
 TagBox[
  DynamicModuleBox[{BoxForm`var$$ = {2, 5}}, 
   InterpretationBox[
    InterpretationBox[
     StyleBox[GridBox[{
        {
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 1], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 1]& ], {True}, "1",
          Enabled->False], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 2], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 2]& ], {True}, "2",
          Enabled->False], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 3], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 3]& ], {True}, "3",
          Enabled->False], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 4], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 4]& ], {True}, "4",
          Enabled->False], 
         SetterBox[Dynamic[
           MemberQ[BoxForm`var$$, 5], BoxForm`TogglerBarFunction[
           BoxForm`var$$, 5]& ], {True}, "5",
          Enabled->False]}
       },
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      Deployed->True],
     TogglerBar[
      Dynamic[BoxForm`var$$], {1, 2, 3, 4, 5}, Enabled -> False]],
    TogglerBar[BoxForm`var$$, {1, 2, 3, 4, 5}, Enabled -> False]],
   DynamicModuleValues:>{}],
  Setting[#, {0}]& ]], "Output",
 ImageSize->{69, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->25894925]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->240578837],

Cell["Select what harmonics to show:", "ExampleText",
 CellID->714459113],

Cell[BoxData[{
 RowBox[{
  RowBox[{"x", "=", 
   RowBox[{"{", 
    RowBox[{"Graphics", "[", 
     RowBox[{
      RowBox[{"{", "}"}], ",", 
      RowBox[{"ImageSize", "\[Rule]", "100"}], ",", 
      RowBox[{"AspectRatio", "\[Rule]", 
       RowBox[{"1", "/", "GoldenRatio"}]}]}], "]"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"g", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"Sin", "[", 
        RowBox[{"n", " ", "x"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", 
         RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
       RowBox[{"ImageSize", "\[Rule]", "100"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"n", ",", "3"}], "}"}]}], "]"}]}], ";"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->243956583],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TogglerBar", "[", 
  RowBox[{
   RowBox[{"Dynamic", "[", "x", "]"}], ",", "g"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->368108556],

Cell[BoxData[
 InterpretationBox[
  StyleBox[GridBox[{
     {
      SetterBox[Dynamic[
        MemberQ[$CellContext`x, 
         Graphics[{{{}, {}, {
             Hue[0.67, 0.6, 0.6], 
             Line[CompressedData["
1:eJwl2Xk4VN//AHBrITFzh1Ap2heSUlT0PpWtSClpE0JCskZIKm1IElLJlrKU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              "]]}}}, {
          AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0},
            ImageSize -> 100, 
           PlotRange -> {{0, 2 Pi}, {-0.9999998592131705, 
             0.9999998782112116}}, PlotRangeClipping -> True, 
           PlotRangePadding -> {
             Scaled[0.02], 
             Scaled[0.02]}}]], BoxForm`TogglerBarFunction[$CellContext`x, 
         Graphics[{{{}, {}, {
             Hue[0.67, 0.6, 0.6], 
             Line[CompressedData["
1:eJwl2Xk4VN//AHBrITFzh1Ap2heSUlT0PpWtSClpE0JCskZIKm1IElLJlrKU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              "]]}}}, {
          AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0},
            ImageSize -> 100, 
           PlotRange -> {{0, 2 Pi}, {-0.9999998592131705, 
             0.9999998782112116}}, PlotRangeClipping -> True, 
           PlotRangePadding -> {
             Scaled[0.02], 
             Scaled[0.02]}}]]& ], {True}, 
       GraphicsBox[{{}, {}, 
         {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwl2Xk4VN//AHBrITFzh1Ap2heSUlT0PpWtSClpE0JCskZIKm1IElLJlrKU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           "]]}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->True,
        AxesOrigin->{0, 0},
        ImageSize->100,
        PlotRange->
         NCache[{{0, 2 Pi}, {-0.9999998592131705, 0.9999998782112116}}, {{
           0, 6.283185307179586}, {-0.9999998592131705, 0.9999998782112116}}],
        
        PlotRangeClipping->True,
        PlotRangePadding->{
          Scaled[0.02], 
          Scaled[0.02]}]], 
      SetterBox[Dynamic[
        MemberQ[$CellContext`x, 
         Graphics[{{{}, {}, {
             Hue[0.67, 0.6, 0.6], 
             Line[CompressedData["
1:eJwVmnk4VV8Xx7koma7pXmOihFQapPKL9k5IqCRDgynSIJEGKnMJTUJShiKl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              "]]}}}, {
          AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0},
            ImageSize -> 100, 
           PlotRange -> {{0, 2 Pi}, {-0.9999996658276197, 
             0.9999993650500513}}, PlotRangeClipping -> True, 
           PlotRangePadding -> {
             Scaled[0.02], 
             Scaled[0.02]}}]], BoxForm`TogglerBarFunction[$CellContext`x, 
         Graphics[{{{}, {}, {
             Hue[0.67, 0.6, 0.6], 
             Line[CompressedData["
1:eJwVmnk4VV8Xx7koma7pXmOihFQapPKL9k5IqCRDgynSIJEGKnMJTUJShiKl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              "]]}}}, {
          AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0},
            ImageSize -> 100, 
           PlotRange -> {{0, 2 Pi}, {-0.9999996658276197, 
             0.9999993650500513}}, PlotRangeClipping -> True, 
           PlotRangePadding -> {
             Scaled[0.02], 
             Scaled[0.02]}}]]& ], {True}, 
       GraphicsBox[{{}, {}, 
         {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVmnk4VV8Xx7koma7pXmOihFQapPKL9k5IqCRDgynSIJEGKnMJTUJShiKl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           "]]}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->True,
        AxesOrigin->{0, 0},
        ImageSize->100,
        PlotRange->
         NCache[{{0, 2 Pi}, {-0.9999996658276197, 0.9999993650500513}}, {{
           0, 6.283185307179586}, {-0.9999996658276197, 0.9999993650500513}}],
        
        PlotRangeClipping->True,
        PlotRangePadding->{
          Scaled[0.02], 
          Scaled[0.02]}]], 
      SetterBox[Dynamic[
        MemberQ[$CellContext`x, 
         Graphics[{{{}, {}, {
             Hue[0.67, 0.6, 0.6], 
             Line[CompressedData["
1:eJwVmnk8VO8Xxy1jN5bBjKVkqZQsCVHReVKhiDZLWZKkvlJUloooZUkSQiiR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              "]]}}}, {
          AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0},
            ImageSize -> 100, 
           PlotRange -> {{0, 2 Pi}, {-0.9999990687548602, 
             0.9999987329187721}}, PlotRangeClipping -> True, 
           PlotRangePadding -> {
             Scaled[0.02], 
             Scaled[0.02]}}]], BoxForm`TogglerBarFunction[$CellContext`x, 
         Graphics[{{{}, {}, {
             Hue[0.67, 0.6, 0.6], 
             Line[CompressedData["
1:eJwVmnk8VO8Xxy1jN5bBjKVkqZQsCVHReVKhiDZLWZKkvlJUloooZUkSQiiR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              "]]}}}, {
          AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0},
            ImageSize -> 100, 
           PlotRange -> {{0, 2 Pi}, {-0.9999990687548602, 
             0.9999987329187721}}, PlotRangeClipping -> True, 
           PlotRangePadding -> {
             Scaled[0.02], 
             Scaled[0.02]}}]]& ], {True}, 
       GraphicsBox[{{}, {}, 
         {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwVmnk8VO8Xxy1jN5bBjKVkqZQsCVHReVKhiDZLWZKkvlJUloooZUkSQiiR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           "]]}},
        AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
        Axes->True,
        AxesOrigin->{0, 0},
        ImageSize->100,
        PlotRange->
         NCache[{{0, 2 Pi}, {-0.9999990687548602, 0.9999987329187721}}, {{
           0, 6.283185307179586}, {-0.9999990687548602, 0.9999987329187721}}],
        
        PlotRangeClipping->True,
        PlotRangePadding->{
          Scaled[0.02], 
          Scaled[0.02]}]]}
    },
    BaselinePosition->{1, 1},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}],
   Deployed->True],
  TogglerBar[
   Dynamic[$CellContext`x], {
    Graphics[{{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Line[CompressedData["
1:eJwl2Xk4VN//AHBrITFzh1Ap2heSUlT0PpWtSClpE0JCskZIKm1IElLJlrKU
Tyl7wgkpFCmVUCoky8xc65iZLL/zfX5/nef1PHPunXlv595n1B089xwTExER
eSYqIvK/VRzLNHSuu7CZV/7/6+Le8k3zYu3gdkHz8FyyCp9pObXEeIL3rXzD
z2T9o+DCL4w5B+cfVQSlkbXV+FJleswNUL2Q+n4vWb/YxSxNikmB9UYzrfbd
TIE97iqtd2JyYB0WlgVez4GbQzZ58TEY9BQfGaqGYNhUvUNmq28jXC4tM5Ix
agSvIIujeV7foOh0lU5pSzOcLD4WJbbwFyzJnvfBlN0On3u2S2c6dEFXd8vB
aqlOiNDiiRQe7AH16Y9FdzC7wXtlza1X6WwQ+r5dl83vga5jXedTC9ng7V+8
cJ14L1iniriff8uGZ+dnqhbP7IWNihu2ol42fLLXWfJoQS+ITT3iYg0ObOud
tUXXvBdiPl0zwXkccDyepiCa3Au5gbsEZRVcsGhp9tPV7wOh44mnPzwG4L9Z
PQ23HfrBnjkcUOo/AC+nDs9/4dYP1eVB2+6FDECsU2x9k08/RKtEfDsQNQAv
zPw3jYb2w9IPWWKfnwzAeouIJT1p/WC1sdu6jj0AuY6Lr0X+7oenjKNThW6D
oBJvdbLyIBsUyntqb/kMQnqFWO2Mo2wIPOEVdypoEMy+txpbuLDB8M255Wsi
BsG3STyt3J8NbWeS9z55NAg3cn3SzWPZIPW3LfNBzyC8M5Szn/uODQ5l1ruj
nYfgyj7MC1nHgTWFypSK5xD48BZG+OpzQCynten+6SEIXLD6vd02DqSl2u7P
CxsCzfv2VvMtOdBx0dn26+Mh0E27uXmjOwccdvi7z6WH4JVecP2PVOLmW2FZ
p4eBcWIjp0GcC2sa9+/QPj8MR7qacwukuSBWqyJbEjYMYU5F7Fh5LqSVJN14
d3cYeg/fLFw/hwsdSenx3JfDcCD/2inFNVxwcCp4qCMyAr+qvFavt+WC4+Dn
V6/CRsA11PWnIIcL9kHR+4ujR6A9d65jUD4XbMTNuTl3RsBft377cDEXrBWr
5qRkjUBUYvGmBpJH0w3P/c/WjMBPk4Wxy5q4sOrCdY2NUqMgPfFR3WOECytk
tldpM0ZBNcHd6hSfC0tjJQ4tVx6F18XLW3zGuaCWfuaq8rJRuA5KXw5I0MCq
de3gmYzC5ujgMzUsGvgM4zt5V0dhfXbi03XaNIzcFdXKvjEKP9/lRb/SoWFw
QVl12u1RCBUVFmzTo6FPR2f4ZuYoFDfefbMGaPhxYIGF19tREI0w6Mkzp6Ey
dVJcczoPuGzlU1ucaShfXpKwSJ4HtX6fF+12peFlrp/2XCUecCoKZ+x3pyH/
Ndt2xlIe0JKDATt9aMjsaX3Ra8yDOwtzS7+fpSFydZFnxhUeHNbyNLsUS0Pd
muZuvygeDG5PWykdT4PUurEjRvE8MGWLXL5yh4ZLG3TNu9LJ9VmdqW5JNJzZ
WrRsQTUPRs/Ln/yWQUOxYXPK4Hse7Gl3nqb+iAae8disis88mCl1RMEhmwYf
M11J+y4etF4WjazPocHNquh3kvgYvNkR07a9mIYs6+YDJ2eMgWb8xhnWJTR0
Hxj7oM8ag3IRl+xDpTQcPaJb3rZgDD7FHN+08xUNB5yLElS2joGT7khk81sa
TAKK9t46PwY688Xjzn8h3zeouc4pbAxWumyMZzWT+AWPbdGJHoOiWFWxlG80
bL6gu7opZQyeBXkpprTRsD6iSJaJx+DVcnc1w980nIpsvvjrzRikX1BxTuig
ITdqTJjTMAarb+VRvZ00aMbq9lq0jwG73CvFs5uGRYlF1ZETY5C/viZEvZ8G
h+RmfRtJPlxsuTq8kU1DaupY3sqZfJg10PPenEPD3HTdtLq5fMjdGvnfQZqG
Q5n7VRIW8UHN3TLXaoCGO49OR7tq8GFjV9kc00FSX0+LQqT0+dByPUNZeZiG
3c+aR5u38WFgVX72CHFU7ph7phkfhieu3a8doUGmSPew8WE+NAga8214NJi+
2P9J0ZEPM2a3f5w9RsOVl6e3/3Ej32fX6O6PxGKvinQvBfHB8sutU0sFNDye
SWVMhPIhUuL37s/Eew67K5y+xocfWc06AUIahFlvQgdi+XCzxkyN9Y+GBzy1
QddEPmhxmax0YnPDM3adD/lwZZnozFXjpP5vfqm3ecKHApnhmU+JDTUjHu8q
58NEluWi2Aka2EFdyrVv+GChHrKBTxxXs/nq1g98GH+hsc9qkgb9WXdHXzbz
YX/ittOZxH8chx3X/eLDev/slEHiqOc7Pz3t4cNU4K6GNVMkn1OZaNkgH57Y
qoqfIG43F8u5L+BDk53k5gTiKwk2qnPEBJBuIAx5Rbyqp/BanIwAxvQHq38Q
f13HFM5kCWDb0g5qiDjk4gmXq3ME8HjH22MTxEs/Vn8VWSSAkcCk8inixnlq
RkEaArgl66QqIA5wD8ob1hFAdvvc0F5itZLP6icNBDC++z27kbhmulZ0t5EA
eKaBR3KIvfaFT9pZCCBntebnS8TKDzrdW6wF8JM3vNuS+NWAQdseO2K5700K
xK6b72x/f1wAD7x4Nh/I76cih4qMvATw4o41+zxxSYv5EhwggM1hVOhyYoel
mXF6FwTw/fXWebUkvjJ+ouK54QKoPCBWYUecW3nYe2WMAJI/ebhxSH4OMQp/
PkwQwA2jrNk+xGK2DIt5DwSwcPvHjxyS3+xst9Lb2QIwE8hF2xNbCV6vYOYL
YCcvbF8dqY9x4/l3I0oFUObkumAlsXlHk9/ZegGcKqOaPvJJPWit6uJ9Ib//
sn6REnHi2bA9Xu0CQMFRD6xIPXKUDbQcaQGcOxx2K2+U5HdXRo8pU0jOH48/
kkMkv0ki+ytVhJA95sCUIP3R3neoetMCIRzNPWMiIP2kdUU+bdVaIdA6pk01
pN8aSwMOK+wTQoPZHJ/xHpIfmaba60eEoCZFj+X+Jfk5oKk33VkIWgaXIuxJ
P3sN/1YQ+gtB3Mq7OZX0O3OFWcPPO0LYFWc9p/AHmU/TU5g1qULoP+mjhb6T
eP8ZsnqWJYTk2OAzla00ON1PaDtfLITcm59Kc8j8KVbu61H/JoTDR7VojY80
XOcZaMj8EgLD+lB9wAeSn883PYf+CmFpfEx3aT0NM6I38CrHhMANb3+nWUeD
7fRwcSelf8D21vXIraRh7Z/vxubz/4H/Y0r7FZmHUlWrI3SW/oOG5Ng1b8pJ
PkO+MSR1/0HbiP9wCZmnkryl8zKs/8H0wfIgk1wa/ut6o9dz6x8UC48pclJo
uFA5O7gx6R98DHkqco7Md+tUD1yc/g/qZTaslb5Hg4jNLOPwgn9Q6XzWaxo5
H/Y2Hdu74ss/eDcge+ThNTIPKiQ83BXGIZVXGeXhR+ZNytYHAzHj8CZMdtOW
bTRcrWn8EXpvHIrn+C2OI+fbm0FbZcWH5PNGq5XbN9FgZHjm+oaCcZh/oXP2
fnI+bu3NOx3aPA4/Lj3P+7GI9P/axeYKcycgO3xs1WZy3q5+O31UN30CLsR3
5lqVcsFz4JZW3ZMJQM8u90YUceGpyiI3m8IJeL3/0q7iXC5ouqOf599OgLTM
whx+FjnfmYG1tb0TUHjdqEv+FhcWHe5LOrxqEk5kH3W9e4ILSvR743NFk1Ap
2RG8kOLCnZv4aC+ehKgLpkq2slxQ1skN3lszCS8zlztETyMOvJ27tIXs76yV
/y7kwGxxh3mNwknQ1JLgy3dyYJ7S2Kja5ikY7Rj27H/OgSWgnl75egoyAsaY
Z7dzIOFtiai4qwg6rPBrsa89GwZ+PQuk3UWQw7PErFXk+c9EmDHY5iWCnB8n
HOy0ZMOIRuzv/AARtEj16E69bWywiDlR4RwmghTdU59EL2aD2JG5F+oyRVDJ
pysd4z39cGLorEhMtwgKbhYRaSTPp/qqW6bUnERR49Wwg/WH+sDU5rOPg4so
+vazqlvdsg+s7h3vfuAuig4JLot6mvTBCZWo+iV+oqj9X0Lf0No+SFBsu6dx
RRR9KD727b5sH/Bn+unpZYmiM+XGccmlvZA/meW9iy2KrsYYhy1V6oWVvxhd
Z0+JoYO6w12qRX/hSRblUuAjjmR50z94/eyC4PYjTSuvSKAfe44tv+jxG7z1
9cyS4yRRcKNJ3NqQNhCmGDr0R09Drd3m92tWfYZGrwT702nT0TzZwGU+n9/C
BpMFkz/uS6GPX2WdJ0WeQa3RhiyUKI02NNrOy4l8itOf393QkS2DGllq+umn
a7DiQg0320czkNXS3EXGf5rwJ1GpUJVSWSRRl/JIp7UNF0j5ZjTWzkRxgasL
quJ/Yw1FhptDtRxaGf3ggM3LLkxH8RTWfpVHq68zO5fU/sXsgXmVmq3yyDil
qqS26S/u22PiuaxdHlXTe584t//FXbPu1Kp2E4/f+BY1/Be3Jm8IkeLJo40x
5pO3VXuww/7yYa4MA6mtcNh6zasH7zwueuT1CgbaluTU3MnsxQuvXtXydGMg
6Vrr0KYtfdjnq06IgzsDrS8UT3i5ow+/Wtzxfp8HAy1rd/ZO2tuHbV/ru+n7
MNDNtnZri2N9OEF06KF0EAOd6P9Y4RTWh6lgm9kPwxkowCLa2KG+D4t5a0u2
ZDGQ69Hxxpt7+rHlq/a97x8zkGa44p8nh/pxqnxkGv6PgYLj9QOqHPrx5qfd
kPGMgb4/l1Ro8+nHQf33gnyLGSj8L4v9MqYfDx2bNjCzhoEaP5Sc3vqxH3cc
amvd+peBtI22zLXezsayBvsz7XsZKLms7YO+JRuvm9/kG9LPQBw5+fg5B9k4
rLNOtoRmoNnWPpYVLmys5V6yWZvPQG5F00yeXGXj4LN30+ZLM9Fj+1gzydds
rJi63218BRPtkYpUz1zPwZtDm9bP1mSisuOf5CINONjFaZe4nhYTGS+LeO9i
yMGly0wSfdcykX5f6nPpPRzs8Hx9Q98mJqpq1Ob0uHPw00rFNS3mTKSulnZ1
zn0ONv3TJCjwYKKuhebPDcW5+OzKqDM5XkxkUho3/FKKi3O9TSeyfJjo7E21
rpVyXDxnslQk0Z+J3v4srBtV5mLurIzpoSFMNBmtE669iovjTAMULaKY6JOm
1H8m+7n4V/Zc7e4nTFSfIs/+84CLFYe+5v7MYaI1z4zDvLK4eIfeTZ2W50yU
cepL9vB/XJz3WlLvfQETPf1z61JnARdf+cHdnFvGRCsZZraub8mrrHyFeUg9
Ewnyaqtle7k4wOeYyywOE+1Nc7DLXkLjMDPu8Y00E22pXT0tZgWNby86fdx2
kImOs8Veea6iceHXMOeMUSaK6DdxYayn8fDG/5zWTzJRp++oe7chjT3Eh+2t
5SkU6Wpu02VP47Pfz9gHMSm0ZGxW/iYnGkcWSNgnsyhk/PeoXMRxGmcfn2XX
rUQhivf8zQwPGve823DEX41CHLNDGg+CaOwYd/5gvDaFGLIgqR5DY5+T0gdL
1lKo97aiSk8cjUONYw60r6PQvokz6hm3aZzKf7B/yUYKxeZ9lZ2eRON2m7f7
CrdSaGGkq55NJo0563bvazWkUEronrbWRzQel2uxmjSm0KYz79x3/0fjORV9
e43NKOT5NfmA2nMaH1gst+frXgqt8i1Ee0to7DIZbyncR6GISL5heCmNTzfP
t5x3gELLJb3XFJbTOD5ce7ezDYVWPgt/M1JJ4yaOlQXPiUKu0pGVEu9obFF4
b8csfwptnDN8zbOFXG/YYUoxgEJbZe/t5rfS+OLqFfmKQRTSH21TC/xO4+LH
xaqKIRTyMX/c4fCTxgtSvgywrlBocbrv769dNNb/npjOCiPxEm/kz++m8X4V
p0OsCArZbx1XPvqXxDt2qIqKotDLu5d93vXSmHdV/jYznkIszApFXBozqr+a
Me+Q/ZvuNm+nabxSLFmEmUDyUf9wrdkAje2DNdwYyRR6qLJrct0QjYNeDM9j
pFLIz9jXff4wjW/xSprk04jdlv0SGaFxndd2A/kMCiU7OTdnj9K46wljSC6L
QlaJlw758Wg81decIfeYxDfKtmP9GI11jjkz5J5SaK7llan7fBKfNM3qmc/I
/f0C48wENHb9ORI4M5dCJkIfTQ5x8sGLnbKFFDpe1uKm/I/EJ37HHdliCg1v
GZdLI25qYu6ULaGQQsGNwoXjNOYyWkRlSynkUeh7NIlYyiK1cEY5hdZ1hcvL
T5B4Xjt+YsYrCm1uK3gVQGxQs0ptRiWFxHV/nGolPiDJ+yzzmkKZN/+u1Jkk
9be1LFzmDYUmLpb/uUwcee7SZpkaCsWk70wjz9s4s9RsWLqOQv9Fhh5lTtG4
UkBlSb+n0J4G84VmxN/Xt9pIN1Bo92TS32Binu99pnQjhTbkuD7NIGY+d3kj
9YlCJ33IaUSswdU6I/WZQkrfTLd1EBuvHNOS+kqhtZ47mSPE9i7lXdO/USi6
+ulv8v6Bz6Rfvju9lUINx93yyfsHju8wt5j+ndTD73Ph5P0DP5uvID69nfRn
6YB9P3GdTVvRtF/kfqGvNn4h/nM3zX1aB6mHkpFZRcQiza7q07ooVMuOG40m
nq2g/VWym+xPevzVgVjHkh8h2UOh65ZbSjSId0VhkOwj+685p3JJPNzeXRmR
YJP4NCwPzyK+JGXxSIJLoaUJiacOEScbKdpKDFCI6fHJQYL4Reh3SmKIQt41
v/ZmkPhzx92CxXkUihL7u/kTyd/BA2bLBWMUOuEgkmRL/Dpv5VeugELN1aU7
O0n+77qxtVonKCTyKT7zi5DGEm/ef/8wRepn7ejubcQe6k/Cq0VZSF06YOcj
Uk+G3052PpNkoaC355Etqb+ctRbRGdNZyGqxte4TUp+zb6wySJRmIfsO7oUR
Ur8DRnT81ZksNCNTleVO6vtentcOW0Xi3LIVU4M0niZvObZXiYUOBnNfM4i9
3LQfbldhobEfAfmzST8Zqw9N6Kiy0JMzYXFKpP+Gonyfz1jMQv6FwXYFpD+P
9O21FV3KQm+51tnhPTSuMdKZMbaMhZJL4i2sST8njY84dWiQ/ULPxG+k/03d
/JVf6LBQzmU52wtkPuRVW1c/Xc9CnK7rJ5XbaTxPXdfnoR4LRQWMfM0k82S4
eezdDX0WMhhqLc5p+V/8A885G7JQUa9mlWMTjaXvH9SwMWahnnfC7LKPND41
vqHF0pSFzotmDMo30nh7nnCNgTkLmTWsu5X0nsYjasHdLCsWmm3LMz1STWO7
YJtYaWsWyvdzWhRUReqrWR9N7Sfx3K1qf6OCxilRE3f7DrPQzl2mwrQyGu8Y
D9lZ4chCy/58e+NRQOP7zRfyPXxZKH72De27D2jcXb36Z5QfCwlRYZHUfdIP
+T+lc06z0Eww3OWZTM6jaAM7+gwLXWZfKVC/S+P32wXSXpdYaINtk++cKBrz
X3rZed8i17dc5eroT+PNj+dH3LzNQlr1hxwNfcm8vdOQ//wuyW9j65m5XjSW
89OQGUpioYBwlxm5rjReuKon3yeDhc72m5f72JD5lGonc6qIhRTERU3NEI3j
ouTWxb1goVaLT7eT9WncElxml/+Sheqbjyn26tHY6eCcghHMQlNPpyU7atM4
kGq286thoStr1MRpdRo/vGRR4N/CQt1sOwV7URoLXQzsA/+x0Kf6iJi8F+R8
f7kC+U2wUNXzxxcQOc/vzVRW855iIfeTkp3Vz7hYP3fop4u4AmoK+SJSksnF
If8y7Q7MUECcs6tqTG5xsXgUZac7RwE9yTG7IvTgYtm8v0dGNyqgiv/2La6e
y8U2kl8MBvUV0Lb389IclLj4yf5KVc5mBVRP8Yv4TC62GE/80bVVASXErM6X
m87F0UZ7jnzeoYAyk/0UOgY4WOFbqU3eIQXUU7M4a2kVB6tO3DzsHUT8N0FF
z4E8H3XsfHE7WAF1NORpOR3m4FNvpZXKQxRQ4cCnuqtWHFx388InmYsKSK6J
dafAmIP9l3hvf3hNAf24WPwmewUHN+7arducqIAuSFgaSAyycWiaHMsAK6DW
YsV9p06zcbfJtTopCUVkY8dZ++FEP3Yws1dbPE0RndsepK3k2I9/WKzz3yKl
iMYFv6P2k+fVz/t+qgfJKqI/WmK+Fab9uNJxbWC/ArESWrxxcT9OOte2tGGx
IrIc8bCt+N6HrYpWXo41UUSpjYfH9Iz7cNWS9zDvmiJqdnyt7iDei92kMiTU
pWchfyOZHfV23bgodZFB1c1ZaHqZplupeidu2KRfvYephK74lFRX3f6J+W73
9tpHKSGtIquSt7HfcM3ulH0zZymjifZvb9WiGrHDBv3MzDhldM/fJks1sQKn
fTvr/ltVBb13ubwh8bgX1rgibBokdt1d5TK52AsXrj29SWyeCtKGTs2KGk/8
LspLZiEx0/bor+2VHnjE0DHLiZhR4KB5uMAdGz837fpLfJEr4Xn2ngvuC2fZ
cOerILpGvf7VcXt8Sje6apL4Z3XzgHStHZ7skl0pr0bu57jPKKbSllTyNKEW
8Y3Xlj1pBTZYn8e/7U1suWWN8ut7B3CUQ3vTCHGSf9aqaS67sTLj8CZJdRWk
ONnYPLfKAqeVNacpEpc+MdutWWiOi5Q/eq8ndiwt2WSRaIp/NVTJBxC/bTMS
iXZB2C0YnQ4jPiFf8R0V6eOR5WXtd4iLvVhFR5P0sNTlwicviK+tW3j8getq
HLNmrWIdsYLyl6CwlGV47q+c4Fbidw+qF9edUMMZ1zW6+ohPihmmKHkxsPam
R2b/iIe1rv/v/67y/wMoLNIt
         "]]}}}, {
     AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
      ImageSize -> 100, 
      PlotRange -> {{0, 2 Pi}, {-0.9999998592131705, 0.9999998782112116}}, 
      PlotRangeClipping -> True, PlotRangePadding -> {
        Scaled[0.02], 
        Scaled[0.02]}}], 
    Graphics[{{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Line[CompressedData["
1:eJwVmnk4VV8Xx7koma7pXmOihFQapPKL9k5IqCRDgynSIJEGKnMJTUJShiKl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         "]]}}}, {
     AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
      ImageSize -> 100, 
      PlotRange -> {{0, 2 Pi}, {-0.9999996658276197, 0.9999993650500513}}, 
      PlotRangeClipping -> True, PlotRangePadding -> {
        Scaled[0.02], 
        Scaled[0.02]}}], 
    Graphics[{{{}, {}, {
        Hue[0.67, 0.6, 0.6], 
        Line[CompressedData["
1:eJwVmnk8VO8Xxy1jN5bBjKVkqZQsCVHReVKhiDZLWZKkvlJUloooZUkSQiiR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         "]]}}}, {
     AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
      ImageSize -> 100, 
      PlotRange -> {{0, 2 Pi}, {-0.9999990687548602, 0.9999987329187721}}, 
      PlotRangeClipping -> True, PlotRangePadding -> {
        Scaled[0.02], 
        Scaled[0.02]}}]}]]], "Output",
 ImageSize->{322, 67},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->313996383]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Dynamic", "[", 
  RowBox[{"Show", "[", "x", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->483911032],

Cell[BoxData[
 DynamicBox[ToBoxes[
   Show[$CellContext`x], StandardForm],
  ImageSizeCache->{49., {2., 8.}}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->71618353]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->258987245],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["CheckboxBar",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CheckboxBar"]], "InlineFormula"],
 " is a special case of ",
 Cell[BoxData[
  ButtonBox["TogglerBar",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TogglerBar"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->814512658],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"CheckboxBar", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"Range", "[", "5", "]"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->9502163],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[
     RowBox[{
      TagBox[GridBox[{
         {
          CheckboxBox[Dynamic[
            MemberQ[$CellContext`x, 1], 
            BoxForm`TogglerBarFunction[$CellContext`x, 1]& ]], "1"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       "Grid"], "  ", 
      TagBox[GridBox[{
         {
          CheckboxBox[Dynamic[
            MemberQ[$CellContext`x, 2], 
            BoxForm`TogglerBarFunction[$CellContext`x, 2]& ]], "2"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       "Grid"], "  ", 
      TagBox[GridBox[{
         {
          CheckboxBox[Dynamic[
            MemberQ[$CellContext`x, 3], 
            BoxForm`TogglerBarFunction[$CellContext`x, 3]& ]], "3"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       "Grid"], "  ", 
      TagBox[GridBox[{
         {
          CheckboxBox[Dynamic[
            MemberQ[$CellContext`x, 4], 
            BoxForm`TogglerBarFunction[$CellContext`x, 4]& ]], "4"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       "Grid"], "  ", 
      TagBox[GridBox[{
         {
          CheckboxBox[Dynamic[
            MemberQ[$CellContext`x, 5], 
            BoxForm`TogglerBarFunction[$CellContext`x, 5]& ]], "5"}
        },
        GridBoxSpacings->{"Columns" -> {
            Offset[0.27999999999999997`], {
             Offset[0.]}, 
            Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, 
          "Rows" -> {
            Offset[0.2], {
             Offset[0.4]}, 
            Offset[0.2]}, "RowsIndexed" -> {}}],
       "Grid"]}],
     Deployed->True],
    CheckboxBar[
     Dynamic[$CellContext`x], {1, 2, 3, 4, 5}]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{7., {0., 6.}}]}], "}"}]], "Output",
 ImageSize->{186, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->365312766]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"TogglerBar", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "y", "]"}], ",", 
     RowBox[{"Range", "[", "5", "]"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "y", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32818520],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        SetterBox[Dynamic[
          MemberQ[$CellContext`y, 1], 
          BoxForm`TogglerBarFunction[$CellContext`y, 1]& ], {True}, "1"], 
        SetterBox[Dynamic[
          MemberQ[$CellContext`y, 2], 
          BoxForm`TogglerBarFunction[$CellContext`y, 2]& ], {True}, "2"], 
        SetterBox[Dynamic[
          MemberQ[$CellContext`y, 3], 
          BoxForm`TogglerBarFunction[$CellContext`y, 3]& ], {True}, "3"], 
        SetterBox[Dynamic[
          MemberQ[$CellContext`y, 4], 
          BoxForm`TogglerBarFunction[$CellContext`y, 4]& ], {True}, "4"], 
        SetterBox[Dynamic[
          MemberQ[$CellContext`y, 5], 
          BoxForm`TogglerBarFunction[$CellContext`y, 5]& ], {True}, "5"]}
      },
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     Deployed->True],
    TogglerBar[
     Dynamic[$CellContext`y], {1, 2, 3, 4, 5}]], ",", 
   DynamicBox[ToBoxes[$CellContext`y, StandardForm],
    ImageSizeCache->{7., {2., 6.}}]}], "}"}]], "Output",
 ImageSize->{107, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->60995835]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2042136532],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TogglerBar",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TogglerBar"]], "InlineFormula"],
 " is built using ",
 Cell[BoxData[
  ButtonBox["Toggler",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Toggler"]], "InlineFormula"],
 " and can be used to track a list of values:"
}], "ExampleText",
 CellID->1105046970],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"TogglerBar", "[", 
    RowBox[{
     RowBox[{"Dynamic", "[", "x", "]"}], ",", 
     RowBox[{"Range", "[", "5", "]"}]}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "x", "]"}]}], "}"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->1085845534],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   InterpretationBox[
    StyleBox[GridBox[{
       {
        SetterBox[Dynamic[
          MemberQ[$CellContext`x, 1], 
          BoxForm`TogglerBarFunction[$CellContext`x, 1]& ], {True}, "1"], 
        SetterBox[Dynamic[
          MemberQ[$CellContext`x, 2], 
          BoxForm`TogglerBarFunction[$CellContext`x, 2]& ], {True}, "2"], 
        SetterBox[Dynamic[
          MemberQ[$CellContext`x, 3], 
          BoxForm`TogglerBarFunction[$CellContext`x, 3]& ], {True}, "3"], 
        SetterBox[Dynamic[
          MemberQ[$CellContext`x, 4], 
          BoxForm`TogglerBarFunction[$CellContext`x, 4]& ], {True}, "4"], 
        SetterBox[Dynamic[
          MemberQ[$CellContext`x, 5], 
          BoxForm`TogglerBarFunction[$CellContext`x, 5]& ], {True}, "5"]}
      },
      BaselinePosition->{1, 1},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     Deployed->True],
    TogglerBar[
     Dynamic[$CellContext`x], {1, 2, 3, 4, 5}]], ",", 
   DynamicBox[ToBoxes[$CellContext`x, StandardForm],
    ImageSizeCache->{7., {0., 6.}}]}], "}"}]], "Output",
 ImageSize->{107, 23},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->1228592374]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Toggler", "[", 
    RowBox[{"Dynamic", "[", "y", "]"}], "]"}], ",", 
   RowBox[{"Dynamic", "[", "y", "]"}]}], "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->489857732],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TogglerBox[Dynamic[$CellContext`y], {True->"True", False->"False"}, 
    DynamicBox[ToBoxes[$CellContext`y, StandardForm],
     ImageSizeCache->{28., {0., 8.}}]], ",", 
   DynamicBox[ToBoxes[$CellContext`y, StandardForm],
    ImageSizeCache->{28., {0., 8.}}]}], "}"}]], "Output",
 ImageSize->{95, 22},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1734082773]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["CheckboxBar",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CheckboxBar"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SetterBar",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SetterBar"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Toggler",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Toggler"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Manipulate",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Manipulate"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225],

Cell[TextData[ButtonBox["Generalized Input",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/GeneralizedInput"]], "Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Control Objects",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ControlObjects"]], "MoreAbout",
 CellID->230458710],

Cell[TextData[ButtonBox["Creating Inspectors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CreatingInspectors"]], "MoreAbout",
 CellID->538888387],

Cell[TextData[ButtonBox["Toolbars",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Toolbars"]], "MoreAbout",
 CellID->120181598],

Cell[TextData[ButtonBox["User Interface Structuring & Layout",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/UserInterfaceStructuringAndLayout"]], "MoreAbout",
 CellID->321401051]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TogglerBar - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 3.3642366}", "context" -> "System`", 
    "keywords" -> {"multiple selection control"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "TogglerBar[x, {val_1, val_2, ...}] represents a toggler bar with setting \
x and with toggler buttons for values val_i to include in the list x. \
TogglerBar[Dynamic[x], {val_1, val_2, ...}] takes the setting to be the \
dynamically updated current value of x, with the values in the list x being \
reset every time a toggler button is clicked. TogglerBar[x, {val_1 -> lbl_1, \
val_2 -> lbl_2, ...}] represents a toggler bar in which the toggler button \
associated with value val_i has label lbl_i.", "synonyms" -> {"toggler bar"}, 
    "title" -> "TogglerBar", "type" -> "Symbol", "uri" -> "ref/TogglerBar"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[12284, 367, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->559056075]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 283368, 5699}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2633, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3256, 87, 1575, 37, 70, "ObjectNameGrid"],
Cell[4834, 126, 3310, 104, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[8181, 235, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[8659, 252, 317, 9, 70, "Notes",
 CellID->334953226],
Cell[8979, 263, 449, 17, 70, "Notes",
 CellID->8400],
Cell[9431, 282, 69, 1, 70, "Notes",
 CellID->19514],
Cell[9503, 285, 1548, 40, 70, "3ColumnTableMod",
 CellID->15505],
Cell[11054, 327, 222, 8, 70, "Notes",
 CellID->570291772],
Cell[11279, 337, 618, 13, 70, "2ColumnTableMod",
 CellID->39473540],
Cell[11900, 352, 347, 10, 70, "Notes",
 CellID->307511469]
}, Closed]],
Cell[CellGroupData[{
Cell[12284, 367, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->559056075],
Cell[CellGroupData[{
Cell[12669, 381, 147, 5, 70, "ExampleSection",
 CellID->25445231],
Cell[12819, 388, 82, 1, 70, "ExampleText",
 CellID->681402169],
Cell[CellGroupData[{
Cell[12926, 393, 211, 7, 28, "Input",
 CellID->263830634],
Cell[13140, 402, 1483, 40, 44, "Output",
 CellID->92158956]
}, Open  ]],
Cell[14638, 445, 125, 3, 70, "ExampleDelimiter",
 CellID->299343996],
Cell[14766, 450, 188, 7, 70, "ExampleText",
 CellID->25513002],
Cell[CellGroupData[{
Cell[14979, 461, 284, 9, 70, "Input",
 CellID->71253264],
Cell[15266, 472, 1421, 38, 70, "Output",
 CellID->251720894]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16736, 516, 219, 7, 70, "ExampleSection",
 CellID->78508357],
Cell[16958, 525, 57, 1, 70, "ExampleText",
 CellID->68484507],
Cell[CellGroupData[{
Cell[17040, 530, 341, 10, 70, "Input",
 CellID->293611724],
Cell[17384, 542, 1313, 35, 70, "Output",
 CellID->1943448579]
}, Open  ]],
Cell[18712, 580, 125, 3, 70, "ExampleDelimiter",
 CellID->796606324],
Cell[18840, 585, 131, 2, 70, "ExampleText",
 CellID->482460219],
Cell[18974, 589, 658, 22, 70, "Input",
 CellID->512949927],
Cell[CellGroupData[{
Cell[19657, 615, 313, 10, 70, "Input",
 CellID->177086986],
Cell[19973, 627, 39064, 674, 70, "Output",
 CellID->228008507]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[59086, 1307, 222, 7, 70, "ExampleSection",
 CellID->445532085],
Cell[CellGroupData[{
Cell[59333, 1318, 231, 7, 70, "ExampleSubsection",
 CellID->547197110],
Cell[59567, 1327, 63, 1, 70, "ExampleText",
 CellID->163409260],
Cell[CellGroupData[{
Cell[59655, 1332, 433, 14, 70, "Input",
 CellID->222157194],
Cell[60091, 1348, 2619, 72, 70, "Output",
 CellID->889237436]
}, Open  ]],
Cell[62725, 1423, 125, 3, 70, "ExampleDelimiter",
 CellID->255204788],
Cell[62853, 1428, 104, 2, 70, "ExampleText",
 CellID->572967398],
Cell[CellGroupData[{
Cell[62982, 1434, 250, 8, 70, "Input",
 CellID->223347823],
Cell[63235, 1444, 5338, 119, 70, "Output",
 CellID->227079357]
}, Open  ]],
Cell[CellGroupData[{
Cell[68610, 1568, 241, 7, 70, "Input",
 CellID->662520130],
Cell[68854, 1577, 4878, 112, 70, "Output",
 CellID->24555414]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[73781, 1695, 230, 7, 70, "ExampleSubsection",
 CellID->62433962],
Cell[74014, 1704, 71, 1, 70, "ExampleText",
 CellID->334399289],
Cell[CellGroupData[{
Cell[74110, 1709, 469, 15, 70, "Input",
 CellID->344487064],
Cell[74582, 1726, 7079, 179, 70, "Output",
 CellID->139871165]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[81710, 1911, 237, 7, 70, "ExampleSubsection",
 CellID->788277890],
Cell[81950, 1920, 69, 1, 70, "ExampleText",
 CellID->7865244],
Cell[CellGroupData[{
Cell[82044, 1925, 546, 17, 70, "Input",
 CellID->29425190],
Cell[82593, 1944, 5516, 142, 70, "Output",
 CellID->403137839]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[88158, 2092, 228, 7, 70, "ExampleSubsection",
 CellID->478789917],
Cell[88389, 2101, 209, 8, 70, "ExampleText",
 CellID->85613096],
Cell[CellGroupData[{
Cell[88623, 2113, 181, 6, 70, "Input",
 CellID->745797472],
Cell[88807, 2121, 1480, 40, 70, "Output",
 CellID->175535375]
}, Open  ]],
Cell[90302, 2164, 125, 3, 70, "ExampleDelimiter",
 CellID->471273535],
Cell[90430, 2169, 380, 13, 70, "ExampleText",
 CellID->85404114],
Cell[CellGroupData[{
Cell[90835, 2186, 261, 8, 70, "Input",
 CellID->286289235],
Cell[91099, 2196, 1649, 45, 70, "Output",
 CellID->25894925]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[92809, 2248, 227, 7, 70, "ExampleSection",
 CellID->240578837],
Cell[93039, 2257, 73, 1, 70, "ExampleText",
 CellID->714459113],
Cell[93115, 2260, 812, 26, 70, "Input",
 CellID->243956583],
Cell[CellGroupData[{
Cell[93952, 2290, 164, 5, 70, "Input",
 CellID->368108556],
Cell[94119, 2297, 175707, 2951, 70, "Output",
 CellID->313996383]
}, Open  ]],
Cell[CellGroupData[{
Cell[269863, 5253, 134, 4, 70, "Input",
 CellID->483911032],
Cell[270000, 5259, 250, 8, 70, "Output",
 CellID->71618353]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[270299, 5273, 237, 7, 70, "ExampleSection",
 CellID->258987245],
Cell[270539, 5282, 334, 12, 70, "ExampleText",
 CellID->814512658],
Cell[CellGroupData[{
Cell[270898, 5298, 284, 9, 70, "Input",
 CellID->9502163],
Cell[271185, 5309, 2989, 90, 70, "Output",
 CellID->365312766]
}, Open  ]],
Cell[CellGroupData[{
Cell[274211, 5404, 284, 9, 70, "Input",
 CellID->32818520],
Cell[274498, 5415, 1420, 38, 70, "Output",
 CellID->60995835]
}, Open  ]],
Cell[275933, 5456, 126, 3, 70, "ExampleDelimiter",
 CellID->2042136532],
Cell[276062, 5461, 363, 12, 70, "ExampleText",
 CellID->1105046970],
Cell[CellGroupData[{
Cell[276450, 5477, 286, 9, 70, "Input",
 CellID->1085845534],
Cell[276739, 5488, 1454, 39, 70, "Output",
 CellID->1228592374]
}, Open  ]],
Cell[CellGroupData[{
Cell[278230, 5532, 221, 7, 70, "Input",
 CellID->489857732],
Cell[278454, 5541, 453, 12, 70, "Output",
 CellID->1734082773]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[278968, 5560, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[279287, 5571, 955, 35, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[280279, 5611, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[280600, 5622, 159, 3, 70, "Tutorials",
 CellID->445434225],
Cell[280762, 5627, 148, 3, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[CellGroupData[{
Cell[280947, 5635, 299, 8, 70, "MoreAboutSection"],
Cell[281249, 5645, 141, 3, 70, "MoreAbout",
 CellID->230458710],
Cell[281393, 5650, 149, 3, 70, "MoreAbout",
 CellID->538888387],
Cell[281545, 5655, 128, 3, 70, "MoreAbout",
 CellID->120181598],
Cell[281676, 5660, 180, 3, 70, "MoreAbout",
 CellID->321401051]
}, Open  ]],
Cell[281871, 5666, 27, 0, 70, "History"],
Cell[281901, 5668, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

