(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25653,        943]
NotebookOptionsPosition[     19772,        738]
NotebookOutlinePosition[     21115,        776]
CellTagsIndexPosition[     21030,        771]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"WorkingPrecision" :> 
         Documentation`HelpLookup["paclet:ref/WorkingPrecision"], "Chop" :> 
         Documentation`HelpLookup["paclet:ref/Chop"]}, #, 2]& , Evaluator -> 
       Automatic], {1->"\<\"WorkingPrecision\"\>", 
      2->"\<\"Chop\"\>"}, "\<\"see also\"\>", 
      StyleBox["\<\"see also\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Tolerance", "ObjectName",
 CellID->31215],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["Tolerance",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Tolerance"]], "InlineFormula"],
     " \[LineSeparator]is an option for various numerical options which \
specifies the tolerance that should be allowed in computing results."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->58]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"Tolerance", "->", 
   StyleBox["t", "TI"]}]], "InlineFormula"],
 " specifies that a tolerance value ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " should be allowed."
}], "Notes",
 CellID->12275]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->781075233],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->716753306],

Cell[TextData[{
 "Compute the singular values larger then ",
 Cell[BoxData[
  FormBox[
   FractionBox["1", "100"], TraditionalForm]], "InlineMath"],
 " of the largest singular value:"
}], "ExampleText",
 CellID->68392051],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"N", "[", 
    RowBox[{"HilbertMatrix", "[", "10", "]"}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->48239645],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SingularValueList", "[", 
  RowBox[{"m", ",", 
   RowBox[{"Tolerance", "\[Rule]", "0.01"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->73341556],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.7519196702651776`", ",", "0.34292954848350893`", ",", 
   "0.03574181627163922`"}], "}"}]], "Output",
 ImageSize->{202, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->465041195]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->184606651],

Cell["\<\
Numerically approximate all the singular values of a positive definite \
matrix:\
\>", "ExampleText",
 CellID->417180813],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"HilbertMatrix", "[", "16", "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->84761113],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SingularValueList", "[", 
  RowBox[{
   RowBox[{"N", "[", "m", "]"}], ",", 
   RowBox[{"Tolerance", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->65729681],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.8600364427433271`", ",", "0.44013143636233815`", ",", 
   "0.061114262916307095`", ",", "0.006297815269922941`", ",", 
   "0.0005146753583779205`", ",", "0.0000341275697165957`", ",", 
   "1.8529753628436258`*^-6", ",", "8.253135278318192`*^-8", ",", 
   "3.004576164931264`*^-9", ",", "8.861708123711805`*^-11", ",", 
   "2.0859386978046283`*^-12", ",", "3.8281107400193036`*^-14", ",", 
   "5.398334365678472`*^-16", ",", "1.0436266522035359`*^-17", ",", 
   "7.602763519749519`*^-18", ",", "4.261253418034127`*^-18"}], 
  "}"}]], "Output",
 ImageSize->{512, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->7483542]
}, Open  ]],

Cell["\<\
Compare with the numerical values of the exact singular values:\
\>", "ExampleText",
 CellID->181232589],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", 
  RowBox[{"SingularValueList", "[", "m", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->353932071],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.8600364427433271`", ",", "0.44013143636233815`", ",", 
   "0.06111426291630709`", ",", "0.006297815269922938`", ",", 
   "0.0005146753583779354`", ",", "0.00003412756971658616`", ",", 
   "1.8529753628386086`*^-6", ",", "8.253135278123955`*^-8", ",", 
   "3.0045761593828615`*^-9", ",", "8.861708844367059`*^-11", ",", 
   "2.085937152775827`*^-12", ",", "3.827669089575262`*^-14", ",", 
   "5.277456405490515`*^-16", ",", "5.14339953206079`*^-18", ",", 
   "3.159250701855795`*^-20", ",", "9.197419820651453`*^-23"}], 
  "}"}]], "Output",
 ImageSize->{505, 54},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->237793961]
}, Open  ]],

Cell["\<\
Some values less than the default tolerance are computed poorly due to \
numerical roundoff:\
\>", "ExampleText",
 CellID->808728826],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SingularValueList", "[", 
  RowBox[{"N", "[", "m", "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->176221480],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.8600364427433271`", ",", "0.44013143636233815`", ",", 
   "0.061114262916307095`", ",", "0.006297815269922941`", ",", 
   "0.0005146753583779205`", ",", "0.0000341275697165957`", ",", 
   "1.8529753628436258`*^-6", ",", "8.253135278318192`*^-8", ",", 
   "3.004576164931264`*^-9", ",", "8.861708123711805`*^-11", ",", 
   "2.0859386978046283`*^-12"}], "}"}]], "Output",
 ImageSize->{497, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->31080495]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->206837104],

Cell["\<\
Get the complete singular value decomposition of a nearly singular matrix:\
\>", "ExampleText",
 CellID->329429965],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.", ",", 
       SuperscriptBox["10.", 
        RowBox[{"-", "14"}]]}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->175672384],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"u", ",", "w", ",", "v"}], "}"}], "=", 
  RowBox[{"SingularValueDecomposition", "[", 
   RowBox[{
    RowBox[{"N", "[", "m", "]"}], ",", 
    RowBox[{"Tolerance", "\[Rule]", "0"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->344566741],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.7071067811865476`", ",", 
       RowBox[{"-", "0.7071067811865476`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.7071067811865476`", ",", "0.7071067811865476`"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.4142135623730951`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "7.071067811865475`*^-15"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.9999999999999999`", ",", 
       RowBox[{"-", "5.`*^-15"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5.`*^-15", ",", "0.9999999999999999`"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{493, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->970827256]
}, Open  ]],

Cell["Reconstruct the matrix:", "ExampleText",
 CellID->95179448],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u", ".", "w", ".", 
  RowBox[{"Transpose", "[", "v", "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->85268406],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.`", ",", "1.5777218104420236`*^-30"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "1.`*^-14"}], "}"}]}], "}"}]], "Output",
 ImageSize->{253, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->562870347]
}, Open  ]],

Cell[TextData[{
 "Without the setting for ",
 Cell[BoxData[
  ButtonBox["Tolerance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tolerance"]], "InlineFormula"],
 ", the matrix is considered effectively singular:"
}], "ExampleText",
 CellID->549322561],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"u1", ",", "w1", ",", "v1"}], "}"}], "=", 
  RowBox[{"SingularValueDecomposition", "[", 
   RowBox[{"N", "[", "m", "]"}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->357882961],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.7071067811865476`", ",", 
       RowBox[{"-", "0.7071067811865476`"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.7071067811865476`", ",", "0.7071067811865476`"}], "}"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.4142135623730951`", ",", "0.`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.`", ",", "0.`"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.9999999999999999`", ",", 
       RowBox[{"-", "5.`*^-15"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5.`*^-15", ",", "0.9999999999999999`"}], "}"}]}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{417, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->226520783]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"u1", ".", "w1", ".", 
  RowBox[{"Transpose", "[", "v1", "]"}]}]], "Input",
 CellLabel->"In[5]:=",
 CellID->756747846],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.`", ",", "5.000000000000001`*^-15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "5.000000000000001`*^-15"}], "}"}]}], "}"}]], "Output",\

 ImageSize->{218, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->91356488]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->122152716],

Cell["Detect maximum possible numerical rank:", "ExampleText",
 CellID->551939977],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1.", ",", ".1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"10.", ",", "1."}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->596118473],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixRank", "[", 
  RowBox[{"m", ",", 
   RowBox[{"Tolerance", "\[Rule]", "0"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->585619840],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->324287493]
}, Open  ]],

Cell["\<\
The two rows are only detected as independent because of representation \
error:\
\>", "ExampleText",
 CellID->289414397],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mi", "=", 
  RowBox[{"SetPrecision", "[", 
   RowBox[{"m", ",", "Infinity"}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->257365235],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", 
     FractionBox["3602879701896397", "36028797018963968"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"10", ",", "1"}], "}"}]}], "}"}]], "Output",
 ImageSize->{242, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->639181372]
}, Open  ]],

Cell["\<\
The default tolerance allows for the numerical representation error:\
\>", "ExampleText",
 CellID->271120102],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MatrixRank", "[", "m", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->45334892],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->254553372]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->123307268],

Cell["\<\
Limit roundoff error at the expensive of a larger residual for a least \
squares problem:\
\>", "ExampleText",
 CellID->637917229],

Cell[BoxData[
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"HilbertMatrix", "[", "20", "]"}]}], ";", 
  RowBox[{"b", "=", 
   RowBox[{"m", ".", 
    RowBox[{"ConstantArray", "[", 
     RowBox[{"1", ",", "20"}], "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->112506301],

Cell["\<\
With the default tolerance numerical roundoff is limited so error is \
distributed:\
\>", "ExampleText",
 CellID->53502523],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", "=", 
  RowBox[{"LeastSquares", "[", 
   RowBox[{
    RowBox[{"N", "[", "m", "]"}], ",", "b"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->155915323],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.9999999998092332`", ",", "1.000000014964043`", ",", 
   "0.9999997096147906`", ",", "1.0000023327618914`", ",", 
   "0.9999909255400236`", ",", "1.000016789334973`", ",", 
   "0.9999906300690925`", ",", "0.9999901016097482`", ",", 
   "1.0000056412889637`", ",", "1.000010691600367`", ",", 
   "1.000002552264348`", ",", "0.9999928245527323`", ",", 
   "0.9999908506885512`", ",", "0.9999971753997002`", ",", 
   "1.0000057134359275`", ",", "1.0000092180066953`", ",", 
   "1.0000042371755116`", ",", "0.999994015626889`", ",", 
   "0.9999892589322142`", ",", "1.0000073174256925`"}], "}"}]], "Output",
 ImageSize->{549, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->7703528]
}, Open  ]],

Cell["\<\
Specifying a higher tolerance will limit roundoff errors at the expense of a \
larger residual:\
\>", "ExampleText",
 CellID->22816417],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x1", "=", 
  RowBox[{"LeastSquares", "[", 
   RowBox[{
    RowBox[{"N", "[", "m", "]"}], ",", "b", ",", 
    RowBox[{"Tolerance", "\[Rule]", 
     SuperscriptBox["10", 
      RowBox[{"-", "8"}]]}]}], "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->174669911],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.9999997941350756`", ",", "1.000007907947448`", ",", 
   "0.9999318635617397`", ",", "1.000198048677443`", ",", 
   "0.9998575989513127`", ",", "0.9998550626627715`", ",", 
   "1.000028651777173`", ",", "1.0001441285579062`", ",", 
   "1.000135434078639`", ",", "1.0000432886512278`", ",", "0.99993572658515`",
    ",", "0.9998656501516787`", ",", "0.9998576520227442`", ",", 
   "0.9999097469618662`", ",", "1.0000005096852849`", ",", 
   "1.0000968404933523`", ",", "1.0001604436126499`", ",", 
   "1.0001525397049833`", ",", "1.0000369484246996`", ",", 
   "0.9997818784134389`"}], "}"}]], "Output",
 ImageSize->{450, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->36241619]
}, Open  ]],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tolerance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tolerance"], "->", "0"}]], "InlineFormula"],
 ", numerical roundoff can introduce excessive error:"
}], "ExampleText",
 CellID->151699388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x0", "=", 
  RowBox[{"LeastSquares", "[", 
   RowBox[{
    RowBox[{"N", "[", "m", "]"}], ",", "b", ",", 
    RowBox[{"Tolerance", "\[Rule]", "0"}]}], "]"}]}]], "Input",
 CellLabel->"In[4]:=",
 CellID->167441092],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1.0000018189521132`", ",", "0.9997896307294343`", ",", 
   "1.004915268297438`", ",", "0.979362045377577`", ",", 
   "0.5576850964635021`", ",", "7.045529598799857`", ",", 
   RowBox[{"-", "31.376234902852538`"}], ",", "85.23269920367379`", ",", 
   RowBox[{"-", "68.90115898982904`"}], ",", 
   RowBox[{"-", "173.65449400835706`"}], ",", "506.29844541139624`", ",", 
   RowBox[{"-", "357.9850368253945`"}], ",", 
   RowBox[{"-", "265.481009944776`"}], ",", "411.3547060262649`", ",", 
   "89.17976380211104`", ",", 
   RowBox[{"-", "23.272865787487895`"}], ",", 
   RowBox[{"-", "776.8157948669577`"}], ",", "1068.0780381616357`", ",", 
   RowBox[{"-", "568.2793593288253`"}], ",", "114.03502031766669`"}], 
  "}"}]], "Output",
 ImageSize->{467, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->280015790]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"Norm", "[", 
    RowBox[{
     RowBox[{"m", ".", "x"}], "-", "b"}], "]"}], ",", 
   RowBox[{"Norm", "[", 
    RowBox[{
     RowBox[{"m", ".", "x1"}], "-", "b"}], "]"}], ",", " ", 
   RowBox[{"Norm", "[", 
    RowBox[{
     RowBox[{"m", ".", "x0"}], "-", "b"}], "]"}]}], "}"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->191459788],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "7.928578270080922`*^-16", ",", "7.379074840534493`*^-12", ",", 
   "3.905981716097863`*^-14"}], "}"}]], "Output",
 ImageSize->{310, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->107196750]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30270],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["WorkingPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WorkingPrecision"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Chop",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Chop"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8962]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Tolerance - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 5.8174244}", "context" -> "System`", 
    "keywords" -> {
     "error tolerance", "roundoff tolerance", "relative tolerance", 
      "zero testing"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Tolerance is an option for various numerical options which specifies the \
tolerance that should be allowed in computing results.", "synonyms" -> {}, 
    "title" -> "Tolerance", "type" -> "Symbol", "uri" -> "ref/Tolerance"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[2653, 96, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->781075233]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 20888, 764}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 673, 16, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1296, 43, 47, 1, 70, "ObjectName",
 CellID->31215],
Cell[1346, 46, 502, 14, 70, "Usage",
 CellID->58]
}, Open  ]],
Cell[CellGroupData[{
Cell[1885, 65, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2363, 82, 253, 9, 70, "Notes",
 CellID->12275]
}, Closed]],
Cell[CellGroupData[{
Cell[2653, 96, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->781075233],
Cell[CellGroupData[{
Cell[3038, 110, 148, 5, 70, "ExampleSection",
 CellID->716753306],
Cell[3189, 117, 221, 7, 70, "ExampleText",
 CellID->68392051],
Cell[3413, 126, 181, 6, 70, "Input",
 CellID->48239645],
Cell[CellGroupData[{
Cell[3619, 136, 176, 5, 28, "Input",
 CellID->73341556],
Cell[3798, 143, 277, 9, 36, "Output",
 CellID->465041195]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4124, 158, 220, 7, 70, "ExampleSection",
 CellID->184606651],
Cell[4347, 167, 131, 4, 70, "ExampleText",
 CellID->417180813],
Cell[4481, 173, 151, 5, 70, "Input",
 CellID->84761113],
Cell[CellGroupData[{
Cell[4657, 182, 202, 6, 70, "Input",
 CellID->65729681],
Cell[4862, 190, 716, 16, 75, "Output",
 CellID->7483542]
}, Open  ]],
Cell[5593, 209, 114, 3, 70, "ExampleText",
 CellID->181232589],
Cell[CellGroupData[{
Cell[5732, 216, 141, 4, 70, "Input",
 CellID->353932071],
Cell[5876, 222, 715, 16, 75, "Output",
 CellID->237793961]
}, Open  ]],
Cell[6606, 241, 143, 4, 70, "ExampleText",
 CellID->808728826],
Cell[CellGroupData[{
Cell[6774, 249, 141, 4, 70, "Input",
 CellID->176221480],
Cell[6918, 255, 544, 13, 58, "Output",
 CellID->31080495]
}, Open  ]],
Cell[7477, 271, 125, 3, 70, "ExampleDelimiter",
 CellID->206837104],
Cell[7605, 276, 125, 3, 70, "ExampleText",
 CellID->329429965],
Cell[7733, 281, 323, 12, 70, "Input",
 CellID->175672384],
Cell[CellGroupData[{
Cell[8081, 297, 295, 9, 70, "Input",
 CellID->344566741],
Cell[8379, 308, 899, 29, 58, "Output",
 CellID->970827256]
}, Open  ]],
Cell[9293, 340, 65, 1, 70, "ExampleText",
 CellID->95179448],
Cell[CellGroupData[{
Cell[9383, 345, 137, 4, 70, "Input",
 CellID->85268406],
Cell[9523, 351, 336, 11, 39, "Output",
 CellID->562870347]
}, Open  ]],
Cell[9874, 365, 256, 8, 70, "ExampleText",
 CellID->549322561],
Cell[CellGroupData[{
Cell[10155, 377, 234, 7, 70, "Input",
 CellID->357882961],
Cell[10392, 386, 879, 29, 58, "Output",
 CellID->226520783]
}, Open  ]],
Cell[CellGroupData[{
Cell[11308, 420, 141, 4, 70, "Input",
 CellID->756747846],
Cell[11452, 426, 351, 12, 39, "Output",
 CellID->91356488]
}, Open  ]],
Cell[11818, 441, 125, 3, 70, "ExampleDelimiter",
 CellID->122152716],
Cell[11946, 446, 82, 1, 70, "ExampleText",
 CellID->551939977],
Cell[12031, 449, 270, 10, 70, "Input",
 CellID->596118473],
Cell[CellGroupData[{
Cell[12326, 463, 167, 5, 70, "Input",
 CellID->585619840],
Cell[12496, 470, 158, 5, 36, "Output",
 CellID->324287493]
}, Open  ]],
Cell[12669, 478, 131, 4, 70, "ExampleText",
 CellID->289414397],
Cell[CellGroupData[{
Cell[12825, 486, 163, 5, 70, "Input",
 CellID->257365235],
Cell[12991, 493, 358, 12, 51, "Output",
 CellID->639181372]
}, Open  ]],
Cell[13364, 508, 119, 3, 70, "ExampleText",
 CellID->271120102],
Cell[CellGroupData[{
Cell[13508, 515, 105, 3, 70, "Input",
 CellID->45334892],
Cell[13616, 520, 158, 5, 36, "Output",
 CellID->254553372]
}, Open  ]],
Cell[13789, 528, 125, 3, 70, "ExampleDelimiter",
 CellID->123307268],
Cell[13917, 533, 140, 4, 70, "ExampleText",
 CellID->637917229],
Cell[14060, 539, 278, 9, 70, "Input",
 CellID->112506301],
Cell[14341, 550, 133, 4, 70, "ExampleText",
 CellID->53502523],
Cell[CellGroupData[{
Cell[14499, 558, 185, 6, 70, "Input",
 CellID->155915323],
Cell[14687, 566, 776, 17, 54, "Output",
 CellID->7703528]
}, Open  ]],
Cell[15478, 586, 145, 4, 70, "ExampleText",
 CellID->22816417],
Cell[CellGroupData[{
Cell[15648, 594, 285, 9, 70, "Input",
 CellID->174669911],
Cell[15936, 605, 776, 17, 71, "Output",
 CellID->36241619]
}, Open  ]],
Cell[16727, 625, 267, 9, 70, "ExampleText",
 CellID->151699388],
Cell[CellGroupData[{
Cell[17019, 638, 235, 7, 70, "Input",
 CellID->167441092],
Cell[17257, 647, 902, 20, 71, "Output",
 CellID->280015790]
}, Open  ]],
Cell[CellGroupData[{
Cell[18196, 672, 381, 13, 70, "Input",
 CellID->191459788],
Cell[18580, 687, 287, 9, 39, "Output",
 CellID->107196750]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18928, 703, 311, 9, 70, "SeeAlsoSection",
 CellID->30270],
Cell[19242, 714, 458, 17, 70, "SeeAlso",
 CellID->8962]
}, Open  ]],
Cell[19715, 734, 27, 0, 70, "History"],
Cell[19745, 736, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

