(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    575374,      10618]
NotebookOptionsPosition[    566127,      10306]
NotebookOutlinePosition[    567470,      10344]
CellTagsIndexPosition[    567382,      10339]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Formatted Output" :> 
          Documentation`HelpLookup["paclet:tutorial/FormattedOutput"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Formatted Output\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StatusArea" :> 
          Documentation`HelpLookup["paclet:ref/StatusArea"], "Annotation" :> 
          Documentation`HelpLookup["paclet:ref/Annotation"], "Mouseover" :> 
          Documentation`HelpLookup["paclet:ref/Mouseover"], "PopupWindow" :> 
          Documentation`HelpLookup["paclet:ref/PopupWindow"], "PopupView" :> 
          Documentation`HelpLookup["paclet:ref/PopupView"], "CurrentValue" :> 
          Documentation`HelpLookup["paclet:ref/CurrentValue"], "Labeled" :> 
          Documentation`HelpLookup["paclet:ref/Labeled"], "Hyperlink" :> 
          Documentation`HelpLookup["paclet:ref/Hyperlink"], 
          "WindowStatusArea" :> 
          Documentation`HelpLookup["paclet:ref/WindowStatusArea"], 
          "MouseAnnotation" :> 
          Documentation`HelpLookup["paclet:ref/MouseAnnotation"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"StatusArea\"\>", 
       2->"\<\"Annotation\"\>", 3->"\<\"Mouseover\"\>", 
       4->"\<\"PopupWindow\"\>", 5->"\<\"PopupView\"\>", 
       6->"\<\"CurrentValue\"\>", 7->"\<\"Labeled\"\>", 
       8->"\<\"Hyperlink\"\>", 9->"\<\"WindowStatusArea\"\>", 
       10->"\<\"MouseAnnotation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Annotating & Combining Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/AnnotatingAndCombiningGraphics"], 
          "Click-Interactive Panels" :> 
          Documentation`HelpLookup["paclet:guide/ClickInteractivePanels"], 
          "Creating Inspectors" :> 
          Documentation`HelpLookup["paclet:guide/CreatingInspectors"], 
          "Creating Web Pages" :> 
          Documentation`HelpLookup["paclet:guide/CreatingWebPages"], 
          "Data Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DataVisualization"], 
          "Document Generation" :> 
          Documentation`HelpLookup["paclet:guide/DocumentGeneration"], 
          "Dynamic Graphics Elements" :> 
          Documentation`HelpLookup["paclet:guide/DynamicGraphicsElements"], 
          "Dynamic Visualization" :> 
          Documentation`HelpLookup["paclet:guide/DynamicVisualization"], 
          "Graphics Annotation & Appearance" :> 
          Documentation`HelpLookup[
           "paclet:guide/GraphicsAnnotationAndAppearance"], 
          "Graphics Options & Styling" :> 
          Documentation`HelpLookup["paclet:guide/GraphicsOptionsAndStyling"], 
          "Notebook Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NotebookFormattingAndStyling"], "Palettes" :> 
          Documentation`HelpLookup["paclet:guide/Palettes"], 
          "Stand-Alone Interfaces" :> 
          Documentation`HelpLookup["paclet:guide/StandAloneInterfaces"], 
          "Symbolic Graphics Language" :> 
          Documentation`HelpLookup["paclet:guide/SymbolicGraphicsLanguage"], 
          "User Interface Structuring & Layout" :> 
          Documentation`HelpLookup[
           "paclet:guide/UserInterfaceStructuringAndLayout"], 
          "Viewers and Annotation" :> 
          Documentation`HelpLookup["paclet:guide/ViewersAndAnnotation"], 
          "New in 6.0: Dynamic Interactivity" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60DynamicInteractivity"], 
          "New in 6.0: Formatting & Styling" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60FormattingAndStyling"], 
          "New in 6.0: Graphics & Visualization Options" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60GraphicsAndVisualizationOptions"], 
          "New in 6.0: Notebooks & Documents" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60NotebooksAndDocuments"], 
          "New in 6.0: Visualization & Graphics" :> 
          Documentation`HelpLookup[
           "paclet:guide/NewIn60VisualizationAndGraphics"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Annotating & Combining Graphics\"\>", 
       2->"\<\"Click-Interactive Panels\"\>", 
       3->"\<\"Creating Inspectors\"\>", 4->"\<\"Creating Web Pages\"\>", 
       5->"\<\"Data Visualization\"\>", 6->"\<\"Document Generation\"\>", 
       7->"\<\"Dynamic Graphics Elements\"\>", 
       8->"\<\"Dynamic Visualization\"\>", 
       9->"\<\"Graphics Annotation & Appearance\"\>", 
       10->"\<\"Graphics Options & Styling\"\>", 
       11->"\<\"Notebook Formatting & Styling\"\>", 12->"\<\"Palettes\"\>", 
       13->"\<\"Stand-Alone Interfaces\"\>", 
       14->"\<\"Symbolic Graphics Language\"\>", 
       15->"\<\"User Interface Structuring & Layout\"\>", 
       16->"\<\"Viewers and Annotation\"\>", 
       17->"\<\"New in 6.0: Dynamic Interactivity\"\>", 
       18->"\<\"New in 6.0: Formatting & Styling\"\>", 
       19->"\<\"New in 6.0: Graphics & Visualization Options\"\>", 
       20->"\<\"New in 6.0: Notebooks & Documents\"\>", 
       21->"\<\"New in 6.0: Visualization & Graphics\"\>"}, "\<\"more about\"\
\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["Tooltip", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Tooltip",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Tooltip"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["label", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]displays ",
     Cell[BoxData[
      StyleBox["label", "TI"]], "InlineFormula"],
     " as a tooltip while the mouse pointer is in the area where ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " is displayed. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15346]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 " can be used with graphics or any other expression."
}], "Notes",
 CellID->23670],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tooltip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tooltip"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula", "TemplateInclusion"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tooltip",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tooltip"], "[", 
   RowBox[{
    StyleBox["expr", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10820],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 " objects can appear within graphics. "
}], "Notes",
 CellID->104278198],

Cell["The following options can be given: ", "Notes",
 CellID->22266],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ActionDelay",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/ActionDelay"], "0", Cell[
    "how long to delay before displaying the tooltip ", "TableText"]},
   {Cell[" ", "TableRowIcon"], 
    ButtonBox["Background",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Background"], 
    ButtonBox["None",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/None"], Cell[
    "background color for the tooltip", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["BaseStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/BaseStyle"], 
    RowBox[{"{", "}"}], Cell[
    "base style specifications for the tooltip", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["LabelStyle",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/LabelStyle"], 
    RowBox[{"{", "}"}], Cell[
    "style specifications for the tooltip", "TableText"]}
  },
  GridBoxAlignment->{
   "Columns" -> {Left, Left, {Left}}, "ColumnsIndexed" -> {}, 
    "Rows" -> {{Baseline}}, "RowsIndexed" -> {}}]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->25069],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ActionDelay",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ActionDelay"], "->", "0"}]], "InlineFormula"],
 ", the tooltip is displayed immediately. "
}], "Notes",
 CellID->21378],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ActionDelay",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ActionDelay"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " uses the standard delay set on your computer system."
}], "Notes",
 CellID->642903269],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["ActionDelay",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/ActionDelay"], "->", 
   StyleBox["t", "TI"]}]], "InlineFormula"],
 " makes there be a delay of ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " seconds before the tooltip is displayed. "
}], "Notes",
 CellID->13927],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 " can be used to specify tooltips for curves and points in functions like ",
 Cell[BoxData[
  ButtonBox["Plot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plot"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ListPlot",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ListPlot"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->23038],

Cell[TextData[{
 "The settings for ",
 Cell[BoxData[
  ButtonBox["BaseStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/BaseStyle"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["LabelStyle",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/LabelStyle"]], "InlineFormula"],
 " are appended to the default styles typically given by the ",
 Cell[BoxData["\"\<Tooltip\>\""], "InlineFormula"],
 " and ",
 Cell[BoxData["\"\<TooltipLabel\>\""], "InlineFormula"],
 " styles in the current stylesheet. "
}], "Notes",
 CellID->55815475]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->139859875],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->288952768],

Cell["Use a string as a tooltip for an expression:", "ExampleText",
 CellID->73141630],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tooltip", "[", 
  RowBox[{
   RowBox[{"x", "+", "y"}], ",", "\"\<label\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->90259434],

Cell[BoxData[
 TooltipBox[
  RowBox[{"x", "+", "y"}],
  "\"label\""]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->289872337]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->610109356],

Cell["Label every curve with a tooltip:", "ExampleText",
 CellID->19012910],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Tooltip", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], ",", 
      RowBox[{"Cos", "[", "x", "]"}]}], "}"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->200755616],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    TagBox[
     TooltipBox[LineBox[CompressedData["
1:eJwt1nc4le//AHAjsjLOMco456CQiqYiH++btpQokqRCUmaiKA0lQjIioyIi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       "]],
      RowBox[{"Sin", "[", "x", "]"}]],
     Annotation[#, 
      Sin[$CellContext`x], "Tooltip"]& ]}, 
   {Hue[0.9060679774997897, 0.6, 0.6], 
    TagBox[
     TooltipBox[LineBox[CompressedData["
1:eJwV2Xk8VF8bAHC7GXuyzCDLjJC0pyI6DyUlWiWyFEIq6peKUCkqZStUKlHS
ItIiRamDUiprhCzZ11mOfZf3vv7g8/3cmXuf8yznzh1abkd3eggJCAicpH79
/++9s25iyw5ErNsw+/8fgr5UaVrv0fRGF0bTWaOUZ79+CtXUPI1SZ1wj6ijL
xL59KVF3AQXtXGn8hPK9/CgNUc0rqN7RbIkbZQNyIHrWKwZdScs6RKfcJJP0
b7o2Fi0YLuAm/iNI+zF91eTUDSQz70W2GuUjpid9xjRuI7XFP4rCZwjKqm5J
HV6fiOIcfOe1ThM0edi6ccArGdVNCH2cT/m+YOOVMYsHaMX1qVS7KYI2lF6f
P1qbgq5+r/3tN0lQT4JlwbB3Kpp7gr39zARBkQdmnIamHqHp8FMKfuMEVU0d
jO/XSENmceVn2KMEnfqmvpS8eobc15hr/x0mSCWu+idvfQaKenxD+eIQQW76
IMzxeoH0akx7bvUTJDQVWD4c/BJN+uz/JkwIqm7ZPW/Y4hUKDpwddeQRFJAh
mTtY+xpt16jeUtlLkFVsl9jg/SxUk7LGj99NkFpAge2A9xukesyfjHUSlL/e
v59MZaNglhenvJUg8YY2XZ5GLhrV4SrG1xFUl//xJLcnF/3dmU5TqCHo2eOE
z5xX79G8tRsdQ6oI2np8676+9XmobPqkjnoZQTfp7292e2EUG7gszLeQoDf+
Vsf9GPnorhg/dQcmKLFvNXMoOB+ZC0av0MojyLdC3mvQogA9C3VNuZhNkHxi
sdBAbSG6dGuvwIEnBE3JvE07ZvIZdY20fn/2kKCO8w+399//jBwj7OX/JhP0
1utsEvH+gj71nlkgkUDQ3hUrjflTRchWeGV2wGWCHvxI/o+j8R2Zd05FvXIj
aDghW7858jv6k7t6g50zQRu9frb/mviOHmjSzTr2EMQVHtv9vuoH8pexUM+z
JmiN6VbjK5dLUDv90R9HQ4IqXkwL6ZJyxLo1Mm+fEBUvortIL65Aa++2Gt+Z
4qO1OvHGlw9UIJO3yzs/DfNR9HDaUGBlBcq6OjTypYuPVl7/7eGWXoncttNu
ffnOR+d+GFgt21eF2uNcL96M4KOnr97ppN+oQnErDPuPhPLRrwRz4fklVchp
+hxaFMRH2l72eQyjauTddvzh4UN89EM4bLHA3N/ot4CCQYslHymZNsiXf61B
ypvflj3/x0OZL640HFlcj0LSVktKOvFQn3xfpJVrPTr6rmG0fQcP6Z6yWqcX
X4+2nVnp/MySh+6bSD5on6hH0d86s2aX81Ds90jPvUUNaEX5LJTSeOhUe8yA
pVMTcq4c+DjxkouSJX+GzrFoQYwPcp++D3HQOtMgpxCXFnTyM9d9XzcHNfou
NCT+LahvIsi7vZ6DGL8iukqetaA9e62y3hZw0PUE683hcq1oh+oyrYhoDgqd
XyYz29CKRG89uzSozUFeqPI293g7YmTxc0Y39CGBlNH3DRHtyGu16etXq/pQ
goha44/UdsS2WFvgpNeHir97qqfVtKMbNfPWh0r2IT3b6RQP4w4q72dL5Ct7
Uc9B3Yy/gp3ox7Ri0XqHXnQo9synimtd6LnK6XeLXHqQb+eC9jeZvei3z6YB
c5Mu1OLyh1bwvRel/90T9k2vC+2qC19c2tGLQhelm5sodqE1P7tPd6r0IW9b
odOjvE4k/OqRnNLlPtRkrW/3IqkTJQRrrfPfx0H9bVEb0EwHKpjLvG0kx0Oa
n2U+mr5oRxJaYbrNa/rRnICMQ6J9LSha7qf+g/1DyGBL02P25Rrk1mCLhUtG
UfmS3xafkwrRf0Vhbkd1J9G9g6jc2/YlfnVMahdj8wwavXZl/98jFfhB0OG+
pXsEQD+y4IKEUhO+kDy9Y5grCOPP8ixD/rbj7Utz/ls4JAhfHw9vGhtox+oF
ftfdJgShbo0RuIl24PdtfRUVokLQEy3dNtegAw/O/7PtuboQdMwJzegI6MBu
Gdk2ntuFoLhhwGy5XCc2y/XdXJclBAfZBrqLDbuwjJW+t+x7IbDfm10kbdmF
G+s7wzfmCwE50zHQbN+FA6adit+UCEFtuWGxY3AXfom2WF7vFAL3+lNmLwu7
sOZXXQsrZWHgaCjofbbuxgJVLZAXKAwh1T8jNtn14LDeTw8CzwvDnsUpDz97
9WC6wD0ho3BhYD0YdF90ugfLL3L4kn1DGO42xGSU3O3B8y9XWr54KQxfqnaJ
GbX0YKu1hVtTuoTh2cDXzZ88enHcw4dO4TtF4L7hReYC9z7MeH/+40YHEdjn
FLXW7XgfTqzYpy66XwTYE69jw8/34cczqi3nfURgS6htdmJyH87ZE+8eFC4C
tecrH7TW9+FGyYuHfD+JQLalxFC1DQfrnPAMsNUXhS5yW0N1PhcvMm7elbxU
FL5+3RQktYyLVwrYL+lbJQpLT0t5ck242Dxyc9e59aJAQgN/+ttysUuqgW26
kyicGeyWyLvAxTerB5cIxVCvdzuuO9zAxffuHJa0uSEKlvIPVH52cXHq/o6u
W3dFwWb3CYNrA1z8mvv73qKnouDWfOR6hxgPl4nkSjoUiEKvbeXT7KU8LGp4
rvvFkCjs9tvlNxTCw1JTY4WTE6KQqpGwOe0qD8sXHEuyEBCDJkfNP9bxPKxp
47a7QUoMbgcbSDk/4WETD4vPYjpiMDMsov6ghIdP3JBMdrYXg/ixO8Ov5/Jx
x8gtO8mPYiCUururNo6PU8xW+DV9FoOhuCbZurt8vC+qLObFDzHQnPGcKHjI
x/Xaot931YnB8YKIkZ1ZfFy56/jaxCEx8LISHzlYycefXllrLtIXB/HQo877
6QQHz3SbzC4Vh5sLN45PyBJstDnUoXK1ONAWZ/0LViL4TUtu7EkLcdC+8t9a
xCb4mayu6Kf94sA2FhzOWkvwLR/Bvq23xKHtSVTc3oME2+YmimkliUOF/I+q
cB+C5UXXsIdSxSHo9p21948THJ3o63TrtTjEfDD2uxpMcNjPhrLmUnH4iXnq
1jEEmyv7c15Vi8MZy9LVn+MInnWTp4U1UPFJ+DuxEwgOnNxkptcrDi9GQvKS
7hN8bMHbrGMiNHj0KOjC+ZcELz65o8Jckgau1yxS4Q3BnHwuV0GeBs8fr33f
845gT3u2Tq4GDZ5uVM0Z+kSwduon8wgdGigs67pjV0hwG3HY57yIBhZS971S
igh2vnwtQXAtdbzdMXv4J8EqVQuzq8xooBxStGyqjOA69W+VjzbRQMiWF91X
Sa3/7YyElR0Nvr+fbQutJdiq89CZ2P9ooM26+f5+K8Ebz7AzNgTQYOeTa37t
7dR6FRvrR8/SoMyZ/Vu2i2BjC5s1jpE0KGqlR87vI3hVk6iXdBwNUhXP/5Xh
Erz85Kcb+DYN7m6urWrlEaz/aMkQ+wkNLpbPTdkwQLCOaY9WzXMa3Pl7J6B6
kGDW7/vbw9/QIMvbnGczTLC6j8M54w/U9QWFZl+OUOsRlc/kFtCgs6MlY2aU
YKV7PxqTimlwQnh0ZMU4VT/DUMkd5VQ+pr3+7JogWKZ0rbFwDQ2Oa/jYOU8S
LOkxfDC7kQbBvluObJ8imDaTccurnYo/0V5l0TTBIjc8vjL7aCArN7lviLLA
IvWRn/006GhJNXk4Q/D0lxr22TEajNc3vTD5R/C4U8zOpf9ocP6MUS6mPDxs
eb5NhA4hU472BrME90cKvIyXpIOQyUTkBcpc7dy/G+XpYFdfbVdIuSfvP+kJ
Bh2MdAqzOZQ7bPVN0jXoQNipaf8ot3DbDjnr0GF/pM/yKcqNYXdvyy6ig0qp
5vZWynVqtsUFK+iwi1Yh9Ipy9RupMT9jOjQq3LM6RLnCumi+jhkdaGdzdaUp
l3Scsa2zpENEqOed21S8xcGrQq9upYMVcyRFlvIXBfLKZDcdtLuLzI5S683P
eNLCd6TDy02b/XOofORt2C/7wI0Ovdaz6zlU/nIaGet2edOhPtv/qTjlNycq
j4geo4Ph+I5H0lS+M1LNf3ifocMtu/FDNWMEPzWZGlcNo4PB7x2Gt6n6pVZn
6ZZdpcOSAd27FlR9E0XmX1yeQAdzxzmmjlQ/JCQ2ZXUk0eFfxJKgL/0Ex6+8
2XbzER0U1VvslQnBUQfEYeo1HWRS3o+d5hB8dRr7Ps+lw5/mIx+u9BJ8KT7g
3r58OtAVC9mh3QSf/dI7+bmUDmM28j3LqX4OdEpZcKqaDqf65C17Wwg+NbzX
Xq+BDvh5wfYrfwn21S7Jjuyhg+NMy6FLfwg+lBfWsY7Q4ZBN9dn2Gmo+bU3n
DozQATYHbdCvJtglLPPYbmEJ+Jd7g3uCmretHdcWqqtLwE0js95/BVT+F3ZU
O2lLQM9RNNJOzfMWv9Vn7+pLwKVSy7TsDwRvEvpbwVgtAbmB6+doZFPzprnw
1NztEiAbPkdF4glVD6+zGjvtJKDQ3ijZ9iHB6EVl8TUnCdhvv6opIplgk3UB
qjLeEpBWNhyZf4tgQ6eifNoFCShdMvbP/DJVn4eMQ5bhEmD2szdq6AI1n5zD
cy9FS8B65yO9185S+1GgvKfwXQkY2NUkF3uSYL2EfZL/siTANULzaKYbwWrV
E7uHOiWgqVVoZocRwXdUbWaXcSUgiqX9omIFwUz3+0+PDUpAxCtpF5PF1HwO
bpzi/ZOAPbF/cT2LYDm5+Ps9ypLwZd75kRWSBAtbL+Y0bZYEHfVRF8c6Pr4Q
dz5ebbskyHf9jk6n9n+BhmpTRztJsAjeMtbzg4+nvYOu1blJgmvYmQsLP/Lx
6OViw6ogSXD+xhovv8/HfZ/dQoqfSwJzZnbVnQN8rHG97lD0G0lgzw2SUHTi
Y1uXrbttP0hCsOWoSuAu6v4ybqTfUiwJdn+eSgqb83HsojnVY+2S8PxPeKOc
Oh+vvYV1dVWk4H2q15DWLx6OPKRWfvGSFJh5rqq10ufhgtWxuVuipEC+8Ki3
igYPj4rQUufESwGj5q/q77k8vD95KODeAykQ/PFRUGqGuv9X/2Bl50lB9ut9
70LKuLjJ9PSpjkEpar/iLYjy4eLFc6gPsvukoUzz2KJjiRzcFdV14YaHNEy4
Cronx3DwPYmx7u7D0tBVHef28QIHS4kwXkcGSMP52eHmooMc3DfqsLHmujQk
NEW+o6/k4EeNTb7eX6QhKZ6tduBbH1Z72oljFsjAE7FbQ8mtvVgCjbg2DslA
VZCr+equbhxgpkd7OykDbKWFzSNV3bhrvWNmjKAsvO47KvywoBsXbiqYNJeV
BQN/Q8b3xG4cuDMqLk1fFjJjBfgWO7sxx2N+0SlXWUjpD9gq874Ll0Tu1ptT
Lgs65yavmpzpxJa8vWOs3XJwt5WtuOV3G64rPCC412AOCN+bNCMS9Tg7/IuL
5sgceBDyK5mxrQR7ip5sKSuTh9ErV9W1HS9i9+NB2VJ35kKF9776It43tMRr
YZm1qwKUjbP09DtrUbm8geRJI0WIdnH+KtTditb5+PTeNVGE4tbcoPapVpT5
LfNbIVKEy09SxXLl2lB08LIwuY2KMCbn621u3Iasu1bNpO9UBP83eyZLItvQ
j1wz0nZYEQae0+a9XdKOivbvqdqeRB1X8gsJOdKBPmReuGsgrAR7g+PebMNd
SMx6t8otMSVQ6z01cO5XF9rRq3tbUEIJZi/tvpLc2YW62aU3a+SU4GT5xtgM
yW4097ZybIi6Ephr+F+ctutGh0MzwquNlMCCFjzj1deNVO1rTgYfU4If7coG
ciK9yHPk6XCXnxLoH2O+maPYi17FBvnt8FeCyZeaAwI6vciyVPM/nbNK8D2z
y/6pZS/yMz98pCJCCZabloQzr/ainwYC7tpPlCDcw6gtkHpeChLU317SpASv
vnjJ9Mz2oa4NknU6rUrwr1VIw0KGg7aHc/ed71AC15l+/Rg1DtKWfXF0FUcJ
Hix9LNW3hoNK1FbG3B9XgsNbw1pzj3GQ+pp1ZSfmKoPBeKtNbiMHFfrutJ63
WRk6zSI6Rx5xkcHrFdX+1spwnFM10PyKi26OKDj92qYMaUVBv7I/ctHh4NrD
l+2UYVr5JdH+zUUKV50iBtyVYYWc0RtZYR7yfOT5o+isMhxUYXvLOfKQRGPg
Jt83ynBG5krslSkeWuWfJh3zThkuKdSIIxE+cpWv+/XivTLY+gmz2qT4KGeT
ofNAPnX+5t4lA/P4yDOb/HeiVBmSJ4o0lyM+Kog+cDewSxli3X8MGp/lI+6C
uP13e5XBOmHUtvgiHzGKCubncZXBSr1Ean0UH/lOqb+cGVSGy2T5YYFEPlI7
+OdLyKwyuJZmetzJ4aMAs638SwwGXLecirTk81FqY3DWE1UGJBcMmD4d5qNy
//SAYnUGbBL7IjA6yUc6mTRhifkMcFdKzLAXJ6hK5bNy1DIGPMkUWWmsQdC/
7IHG5ysZQGs9LiE8nyD9HZopZasZMNCp/ztHn6CQy2cM5NYxIN8x0ohjSNDi
4dVmcVYMuFK2qPnQFoL2xniKvbFhwJ3BV+N3thN0Uf/Gz+rtDBDcXst5t5ug
xv2Du5X2MODh7ZidOfsIulqacei2OwMS1kqV/jpOUOdjrfjkYAa8f3Ns7PAN
grhhrRPCIQxY9OjazY+3CRp0e7DvYCgDppNzgsbvESSgobVw2VUGcFpEpfQf
E6RyS7Ow8BYDYmZ9hoKyCdI62aKre5cBhXYr/1POJUhv1/2oiCQGnH19Sj0x
jyBDWU0H20cMsO7YP7P/M0HbL2v0d75mgMe36St15QTt8WjebfWWAWy6G3z8
RZDL+uQPmbkMoO+snBvxm6DDs+qX/fMZ4HOylN5WT9Dxpr/chs8M0DQK1Tvc
RFDAh6Sd8I16/594p6Zmgi75q6vTy6j4C37NBHcQFLX7b6hPJQOkS9O9nnUR
FL8iqbeymgEb1xq35PcQ9IDMy77TQF3P9NLYUy5BT0ubVGb/MkA59kRcIJ+g
zPR7Ie5tDHAsP73GsJ+gPK951ga9DMjUb0nwGCLos0XTq2tcBvxdMLqjYZig
H+x7yiOEAYt/R8oajxJUIeh8xmGIAQ28JxXnxwiqbVZr/zjKgPkfHeNfjxP0
92PjJtYkA/oVSh1KJgjquJuYeWmGAQe3L9MsnySIc9pJgSPAhBjbsq73U1R9
9qgFbhNhwtdrkxkx0wRNGDY2Z4kzYf2s2nGbGapeCokWDEkmhM5/bjhMWWzQ
MT1YhglpCivGQv8RJF2hOqd1DhPqvC3fTlNWyGw4ZaHIhNNb4467zFL1jbzb
mMZgQnBAxcI0ylqHHM1l1JhwRf97ayNlvU2qT49rMGHBSvv4CcpLdBqka1lM
aBk4uP7/3wevErnrt1aHCUY2Y3weZZO2vX+SFzChNE/2VhHl9fkqSGQRE9Zs
KF97ibJVUn3qwaVMED3h3rSE8vbgOxKlK6jreUsEF1Lx7dm799iy1UzAZfKM
dZRd1qjU3DBmAq2+4VUKtT4Ppfq1k6ZM6Lb5vbmfyseR4dsPXMyYkB1wrkWH
8vFfDuKfN1D5WXn41EYqf6dfMn10NzHBt9NIahuV35DoP78itjDhZdC9FKDy
f+nI7TX9W5mQdMzeWJWqT7weUyR3NxOEpZb9FzFCkJOLzpN2eyaU+THbjah6
a8evsJJxYsI9t4it1PMPejNrc83djcofTlAsJQQFGzquiPZgwgkBFb+FVD9t
OHywJucgE+b49JeepPqtuuaCmsxRJowdGDxXRvVjotQ1vOY4E64pHvzTSPXr
AfN7bu4nmTBh/G1lLdXPw8/fPc0JYsJcsf2jMS0Ezb3IXekezgS1ioifc2oJ
qn8/URsVwYTepIt7Q6oJSukXC8qJZsJMSt9ofSVBy520CqRvMGFFbaqLbQlB
O1fY2eQ8YEKbo6OqfT5Vf2/3/rZUJrx/W7dR9yNBbUnH4qSfMiFIyj26jZrv
4xIRf9wymWAf13h6XhZBsa3YQ/oDEzwGS/+lplL7k3Ipbc0nJrzN+7rx932C
WDb16W4FTOAIRuYNJBL0Omd44N03Kh9TlmtJPEG/YhacdatmwvOYipLpUILu
FK3SiqplwhIlrR/R5whym1r/5V09ExhXGRLSQVT/e7pISLcy4cxnW+ey/wia
sy7u5jseEwpXsR4ecCGozu++UVs/E36Z+Ik7OBB0P+15o9Qwlb/tzl+NbAla
qljMcptkwp/+5v35m6l+405nSomrQE3+JY+2FQRdu+P5zVVTBR4+rs8LFiHI
/9QFv2C2Crw/ZbXE/h8fuexM0rilowKZtpZjmuN8ZCBR419ioAKvXnNvBnL4
6PtpC73VRirw7PvpkK2VfCTkoH1FaqcK2CwZOxN8m496V4Kh7m4V2POAz1oS
y0cVck6tZvYqIFt106X8Kh8lF8cZ+buowEm94vS6ID4yWSPc13pIBRLNC9Rk
nfnopHKb1btQFfD+9vukrBofOQ3NjFZeUoEPmPf63lw+2lDOfMi9ogIOy/p/
MSX5SP7yjimtayrAf2Ne0TDBQ5mj+emRiSqgusp95+UaHur5nSzllq0Ctde2
6Z+P5KG98c5lUt0q8KepXVKPw0VqWRKqh/tU4LXA3jXxzVzUXPnO6ztPBeaG
7eFwqrjogKy84KVhFYgQpIm55HGR79WvK2YFVeH2ww0TNpFcdCFkye0BNVUQ
7kxwOaDHRWlHBA/U7FSFzBhx62c7OOhIRObLlXaq8Dlazj1hPQctfuY4E+ug
Cv4pRdp+hhz0ujv75rb9qqBo6FrBZ3BQntuh78U+qhDecrNj9m8fqrCvWvwh
XBWamRtkY7360PiGRxPJn6jrMYOSCg71ouAPyaFfClThQnCHp59jLxJYfke6
94sqpINuuKJ1LxLXiNFa/lMVbEVWTukv6kVKEwGbv9SqgvFrtxd3+T1oxXPr
2z39qqBH1ylP9O1BvorDa5ax1eDA97m/3N27UXuneUDhZTXot1Ts2cHqRObJ
ZSn6EWpQZIPUq6Q70X37vaWx0WpQceC4jMVEB3L5+R/L/YYaZJOH9lPlHaj+
5f0S4Ydq4LLLZ01WcAf6FfRP0+KTGuSuEzzsXNWOCue8//5tWA3e5bgPiZ9q
Qymmy1RLXeeBxVDyieN6zej5xZNzvBapw9d3Dw1CQ6rQ5d3uW4RH1EFAwuWq
qc1HZNj4IO1yqQbgv389zubm4IQFd5+XbtEE8cULXPmRv/C5/KiELbmaMO4w
aHlDsxn3NeXHT7zXhKVLkwpCtjVju6mha0/yNMHklZSO3dlmbLBq7xXhfE0I
OKm18FNDM65L1wn88FUTcvbe+IqtWvDyW9hxYbUmdM9mRe8WasVdPgPqkkQT
Cjg589wOtmEb1d2Pfmhrwf0ddr63pDpxQsfifEcdLQg36ik+rtGJO57TGri6
WuDQ/NXAbHknDoY8OdmFWiAZZNn2dk8nzvBgB+9apgWbVrA+i6R0YomXAzsb
TbXAp2W5j+bKLvxtQ7QA304LZAc8E+lbu7G8zEHVc/ZasN7Sym3pvm7sUmu2
Sm6vFuzdolWx6Vg3HvUeObzcWQtO+n04vTW2G+vEONWectcCs3Tx1vTf3Tjs
j37m7FEt2J52VeCxQw828/3mOOeKFnyIPntgh10vnqzr3fjlqhbQDo8ltHn2
4jfrpZb7R2rBA1hy2tW/F+swd9CaYrTge7G1tF5CL5b6Uv/m6U0tSLNcZ1xb
14vrmHxpSNWCzZa9F7Ls+vCxIoV8X6wFzknZAYobOFh/6ep0rQItsNpTrrJx
Jwe333G4WV2oBQcOKom57+dgu2NJR4y/asF5wXMxrsEcbKKqxxQr1YLfLSq2
x7I4mPbf2uP36rXA5UqGWMk8Lk5Wc9MuGdGCiXQ1deN2LjZesXCx25gWbGB1
V6jyubh68/Dq8XEt6J3TtIMzzsU0/0tbtKe1QDtL++EuGR4+VvnseLAQC3wF
bn3btIaH4dJQvoEsC84/C3LF4Txcn5j3o1COBd+VbVoCY3n4RNbFant5Fph/
6i1iJ/Lw0xblnjBFFmw9uv656QsenrPWRLZJlQUPqZa+Xs3DbSTMOUqPBe//
ml5+rcrHwWJbvdj6LMg1OpVlps3HSvOU/8tdyAKWw8++jwZ8bGWVFta5mAX5
cM7jjCkfv04tTTc1ZIGCTey4sgsfhzooTfLMWFD/sUXv3V0+Vj/WLBy2ngU1
vLf3FR7ycc6lp9IqFiwo+9tV5fKMj7lZxlobN7Ggy5O+NzeHj21l9m1K2sqC
kZRRr0vVfKz9+cnNrY4s6nl7x7dgGsFlBuOpjU4sCL+7gnVRhuCAm5uyDrlQ
8Y1cfheoQPBP797yS64sKDTVD12kSfBxuYV07MUCowoLk1erCFYLDFK28WaB
gZQjjW1CcFH7z/kNh1igK7h96LwZwYx3R8zHfFiwblcPQ9yaYOycGbTkBAto
8z9aLd5P8MFv/658PMmCsdZD2TQPguWXbUvY4s+C5VqgU+FNsKdI/xuvQBZs
fv5XRsePYKn0ZfzkEOr975ue88II3jv+Zr9cFAtiPy6t600lWMRN9GhSNAsy
curd454SnPlz9xmDayx4q/enZEEGwYLJo7c3xbGg//zyxdT9Hz+1WFMVcpsF
+xRPD8/LJ3jni/BWmbssaC26tXTxZ4KnGH9IYiIL2tCo0cKvBG/lnpbKTWaB
xsUNzzk/CR6J/WAx8IgFy3b4dl2sIThpWtL23BMWHFS64DRdR/AmTyc36TQW
LL79JHZfA8GJRjNnF2SwYFWejxG3meCND22i3j1ngffBrU8U2wgmUkl3LV6w
4A0nv3xhB8HmLetyXF+zQDbdcYt6D8HczTFfSRYLbFhaiZO9BN/Maq4+k82C
Uz2vUz5zCO69FDJwO4cF43NHS1QJwbH9FbO671nwa/IB/1k/wSZ7tWTefqC8
UrZQZ5Dga4sK9X99YoHATEpgxzCVjzWO9Av5LKgOW/ALRql6rR/uXlbIggue
OkcujRFcszXqa+tnKp6JV5bZ4wTzHXQeXS9iwdzCYffSCYJFPXCo2TcWbD+l
m182SfXHMXu3gWIWmE3GOuZOEbwyaAAe/GBBkts1w6hpgrdcuqqxo4QFlcPh
NlYzBLtdZ/8TKGOBm+5oSj/lwMS8xpflLLBLcTUM+Ufw9Se7P+yvZEEY8hCZ
oPz0Nf+2XBULGiXSZR1nCc7/eDkgv5oFT815do8p1xZr7jlWw4KcPaN/6inz
q3INNetYEM27nzBOWax5p0LFHxb41dfGUp//8bw+zuC5BhZE6t4sJpRXjoRV
LmliQZ1ct9F3ytYC6i+b/7JAX7SrK4Kyu+S76JgWFjAffypfTTlQabsPamPB
n28ZwyVUfLFavVtIOwtU/pvevYVymsEF/eROFvyopw+//v/326tV6du6qdcf
NSsXplxn/qb7Xw81vyUaPaZUfoiNzdfMPhZw8TLkSuVPzKEr1YXLgiZLhd8+
VH7VD5wLleFT8xd/4pk7lX/Dowy3T4QFziJy+eZUfawDX4HvALU+3TdKklT9
gq61z5QOsyAo497VPVS9Y+8GN54ZpeZFoTytgeqHZ48VPywap/rfuFV68wAV
T55lQNQUCyxyl6U18wju/9ZiZzrDAsbppjYal2DxqtOGvH9Uf3zZ4Kn6//+/
9KYPWguxQTH+17bpToJthjdUTguzIa2oO+dHO8EHZpteZIiyIb7hxn8XWgmO
U5TzkaKzYVvalrrnjdT5zU50/5Rlw8xEVMZwJcE0G+mvQXPYUPef92fpcoI1
7B+nLpzLhliJ5DVyJdQ8+ta5RiixocIjfWNlEcHpd0wareZR5zetXLohh+DC
R7/fT6qzYYvfjdNP3xBc/9L39jNNNhQEB60YfUmd/9t9OwltNixUNxfdmkbt
N0Mild/12XBdYZsvSSDY5dmGMicDNvTdvyzfF0+wnWvYT7KIDT4PFHUqr1Hz
Wy78VXEZG+bs93h0IJxgnXShD66r2VAd0br1wSmCO90EHk2sp5zhXuS3jeBG
JqREWrDBMVvw2SorgqsrziVrWLJBYIuJQdcGgr+sm71tYcWGZyc+KUkaE5yq
8i/6+nY2lOYw24+wqfz9mgpY4MyGl2KXT8cN8rHTlbWn8lyofG9a0aTFpfZ7
CPLbtp8NO8q+MO518vGGzEmfk+5siPn6Q3dvHbX/X51wK/Bmw+MX+5gkj4/b
zcasHU6xISTZaU74BT52ezWoeSWGDW/f9g7enOXhYnoQ3/Q6G/oLBRQkR3l4
kZtw3mAsG15/SfD05vLwuLzCHqebbCju9MjrqOPhmBOGUUvusUHiT8pgzUse
zlsdMPH7GRsyjlb/e+HEw4qfZipZX9nQprvkxOFULjUvl5Jrv1HHH968ujKB
i1t8ZXwiv7PhXqx6ZU8EF2doaNBGS9gQMHJIfq4fF5ufh3Xfq9jg7Gl24Cg1
Fb4bQp8dbWWD9suwg9tqObj4By00b5oNV0pLVQdG+vCR9a3XvlO++DzuVghl
ubzcpBrKX+lNMnKU7Z8fet9PWfDCJFk83Ie7Y0oGtGfYQM64BR8Z7MNiu6/t
j6LsLDH2sYvfh9c3K69z+ceGpKrsjtruPty1p3/LYcrn42QrPSlfrSh2CKDs
oEdyRrr68K+C0ydjKW9Rg6C5lN1SGzK+UnY1Wfhja0cfDvFOVl0yywbNP6uu
f2npw9pt/gtMKPfnjRruoly8d/vqzZTXPDStaW2m4rcW3OVO+Vnhfjr1/ICT
F7tfvUU5zvmfkVFTHzZ/sjYhlXKyx/j7b41UfBoKj1/9//zigavtKC+eU1Tw
k7KemwLbr4GK78q98jrKQWaLYgUpnxI61dRJ+a9o2XRMfR9WCdrKGaRsXDjq
pk7505DOxCzlk1eefMn404f/B53Z72k=
       "]],
      RowBox[{"Cos", "[", "x", "]"}]],
     Annotation[#, 
      Cos[$CellContext`x], "Tooltip"]& ]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 10}, {-0.9999997966795732, 0.9999999999999791}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->670577979]
}, Open  ]],

Cell["Specify the tooltip explicitly:", "ExampleText",
 CellID->531413447],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"Tooltip", "[", 
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], ",", "\"\<sine\>\""}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->367578639],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], 
    TagBox[
     TooltipBox[LineBox[CompressedData["
1:eJwt1nc4le//AHAjsjLOMco456CQiqYiH++btpQokqRCUmaiKA0lQjIioyIi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       "]],
      "\"sine\""],
     Annotation[#, "sine", "Tooltip"]& ]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  PlotRange->{{0, 10}, {-0.9999993680039507, 0.9999995755730018}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->11292865]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(5)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2809],

Cell["Use graphics or any other expression as a tooltip:", "ExampleText",
 CellID->256299711],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tooltip", "[", 
  RowBox[{"x", ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Disk", "[", "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "50"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->323896900],

Cell[BoxData[
 TagBox[
  TooltipBox["x",
   GraphicsBox[
    DiskBox[{0, 0}], ImageSize -> 50]],
  Annotation[#, 
   Graphics[
    Disk[{0, 0}], ImageSize -> 50], "Tooltip"]& ]], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->235943663]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->92709676],

Cell["Label each expression with a tooltip:", "ExampleText",
 CellID->22521700],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Tooltip", "[", 
    RowBox[{
     RowBox[{"i", "!"}], ",", 
     RowBox[{
      RowBox[{"ToString", "[", "i", "]"}], "<>", "\"\<!\>\""}]}], "]"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"i", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->722271524],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    TooltipBox["1",
     "\"1!\""],
    Annotation[#, "1!", "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["2",
     "\"2!\""],
    Annotation[#, "2!", "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["6",
     "\"3!\""],
    Annotation[#, "3!", "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["24",
     "\"4!\""],
    Annotation[#, "4!", "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["120",
     "\"5!\""],
    Annotation[#, "5!", "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["720",
     "\"6!\""],
    Annotation[#, "6!", "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["5040",
     "\"7!\""],
    Annotation[#, "7!", "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["40320",
     "\"8!\""],
    Annotation[#, "8!", "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["362880",
     "\"9!\""],
    Annotation[#, "9!", "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox["3628800",
     "\"10!\""],
    Annotation[#, "10!", "Tooltip"]& ]}], "}"}]], "Output",
 ImageSize->{359, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->537714745]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->342360282],

Cell["Label each point with a tooltip:", "ExampleText",
 CellID->125627488],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Tooltip", "[", 
     RowBox[{"Prime", "[", "i", "]"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"i", ",", "10"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->504053366],

Cell[BoxData[
 GraphicsBox[{{{}, 
    {Hue[0.67, 0.6, 0.6], 
     PointBox[{{1., 2.}, {2., 3.}, {3., 5.}, {4., 7.}, {5., 11.}, {6., 13.}, {
      7., 17.}, {8., 19.}, {9., 23.}, {10., 29.}}]}, {}}, {
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{1., 2.}}]},
      "2"],
     Annotation[#, 2, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{2., 3.}}]},
      "3"],
     Annotation[#, 3, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{3., 5.}}]},
      "5"],
     Annotation[#, 5, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{4., 7.}}]},
      "7"],
     Annotation[#, 7, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{5., 11.}}]},
      "11"],
     Annotation[#, 11, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{6., 13.}}]},
      "13"],
     Annotation[#, 13, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{7., 17.}}]},
      "17"],
     Annotation[#, 17, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{8., 19.}}]},
      "19"],
     Annotation[#, 19, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{9., 23.}}]},
      "23"],
     Annotation[#, 23, "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      {Opacity[0.], PointBox[{{10., 29.}}]},
      "29"],
     Annotation[#, 29, "Tooltip"]& ]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  ImageMargins->0.,
  ImageSize->Small,
  PlotRange->{{0., 10.}, {0., 29.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->16878287]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->887736336],

Cell["Use tooltips for objects in graphics:", "ExampleText",
 CellID->157215637],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"Tooltip", "[", 
     RowBox[{
      RowBox[{"Circle", "[", "]"}], ",", "0"}], "]"}], ",", 
    RowBox[{"Tooltip", "[", 
     RowBox[{
      RowBox[{"Circle", "[", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], "]"}], ",", "1"}], "]"}]}], "}"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->607330938],

Cell[BoxData[
 GraphicsBox[{
   TagBox[
    TooltipBox[CircleBox[{0, 0}],
     "0"],
    Annotation[#, 0, "Tooltip"]& ], 
   TagBox[
    TooltipBox[CircleBox[{1, 1}],
     "1"],
    Annotation[#, 1, "Tooltip"]& ]}]], "Output",
 ImageSize->{104, 100},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 GraphicsBoxOptions->{ImageSize->{100, Automatic}},
 CellLabel->"Out[1]=",
 CellID->226580678]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->16910115],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Dynamic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Dynamic"]], "InlineFormula"],
 " to recompute the tooltip every time it is looked at:"
}], "ExampleText",
 CellID->44051271],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tooltip", "[", 
  RowBox[{"x", ",", 
   RowBox[{"Dynamic", "[", 
    RowBox[{"DateString", "[", "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->18900580],

Cell[BoxData[
 TagBox[
  TooltipBox["x",
   DynamicBox[
    ToBoxes[
     DateString[], StandardForm]]],
  Annotation[#, 
   Dynamic[
    DateString[]], "Tooltip"]& ]], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->103189462]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->105697725],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "ActionDelay",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->166210],

Cell["\<\
Delay for a specified number of seconds before the tooltip appears:\
\>", "ExampleText",
 CellID->441783184],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tooltip", "[", 
  RowBox[{
   RowBox[{"Graphics", "[", 
    RowBox[{
     RowBox[{"Disk", "[", "]"}], ",", 
     RowBox[{"ImageSize", "\[Rule]", "50"}]}], "]"}], ",", "\"\<Label\>\"", 
   ",", 
   RowBox[{"ActionDelay", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->580773851],

Cell[BoxData[
 TooltipBox[
  GraphicsBox[DiskBox[{0, 0}],
   ImageSize->50],
  "\"Label\"",
  ActionDelay->1]], "Output",
 ImageSize->{54, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->218495173]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "LabelStyle",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->74078712],

Cell["Alter the style of the tooltip:", "ExampleText",
 CellID->720845318],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"Tooltip", "[", 
    RowBox[{
     RowBox[{"Disk", "[", "]"}], ",", "\"\<Label\>\"", ",", 
     RowBox[{"LabelStyle", "\[Rule]", 
      RowBox[{"Directive", "[", 
       RowBox[{"Red", ",", "Bold"}], "]"}]}]}], "]"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "50"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->132107901],

Cell[BoxData[
 GraphicsBox[
  TagBox[
   TooltipBox[DiskBox[{0, 0}],
    "\"Label\"",
    LabelStyle->Directive[
      RGBColor[1, 0, 0], Bold]],
   Annotation[#, "Label", "Tooltip"]& ],
  ImageSize->50]], "Output",
 ImageSize->{54, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->931203881]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(4)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->647],

Cell["\<\
Make a table of polynomial factorizations, giving integer factorizations as \
tooltips:\
\>", "ExampleText",
 CellID->277455955],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Tooltip", "[", 
    RowBox[{
     RowBox[{"Factor", "[", 
      RowBox[{
       RowBox[{"x", "^", "n"}], "-", "1"}], "]"}], ",", 
     RowBox[{"FactorInteger", "[", "n", "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->147661903],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TooltipBox[
    RowBox[{
     RowBox[{"-", "1"}], "+", "x"}],
    RowBox[{
      RowBox[{"-", "1"}], "+", "x"}]], ",", 
   TooltipBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}]}],
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"2", ",", "1"}], "}"}], "}"}]], ",", 
   TooltipBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "x", "+", 
       SuperscriptBox["x", "2"]}], ")"}]}],
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"3", ",", "1"}], "}"}], "}"}]], ",", 
   TooltipBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "x"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["x", "2"]}], ")"}]}],
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"2", ",", "2"}], "}"}], "}"}]], ",", 
   TooltipBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "+", "x"}], ")"}], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "x", "+", 
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["x", "3"], "+", 
       SuperscriptBox["x", "4"]}], ")"}]}],
    RowBox[{"{", 
      RowBox[{"{", 
        RowBox[{"5", ",", "1"}], "}"}], "}"}]]}], "}"}]], "Output",
 ImageSize->{338, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->471787311]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->301393314],

Cell["Use a plot of the formula as the tooltip:", "ExampleText",
 CellID->534569348],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Table", "[", 
  RowBox[{
   RowBox[{"Tooltip", "[", 
    RowBox[{
     RowBox[{"BesselJ", "[", 
      RowBox[{"n", " ", ",", "x"}], "]"}], ",", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"BesselJ", "[", 
        RowBox[{"n", " ", ",", "x"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "20"}], "}"}]}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->294573042],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    TooltipBox[
     RowBox[{"BesselJ", "[", 
      RowBox[{"1", ",", "x"}], "]"}],
     GraphicsBox[{{{}, {}, {
         Hue[0.67, 0.6, 0.6], 
         LineBox[CompressedData["
1:eJwVl3c81d8fx42olLKpjHuta13cq6HQeTesQpNUCBGVrAahlFRSMsrIbBAp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          "]]}}}, {
      AspectRatio -> NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> 
       True, AxesOrigin -> {0, 0}, 
       PlotRange -> {{0, 20}, {-0.346124788513973, 0.5818646378536386}}, 
       PlotRangeClipping -> True, PlotRangePadding -> {
         Scaled[0.02], 
         Scaled[0.02]}}]],
    Annotation[#, 
     Graphics[{{{}, {}, {
         Hue[0.67, 0.6, 0.6], 
         Line[CompressedData["
1:eJwVl3c81d8fx42olLKpjHuta13cq6HQeTesQpNUCBGVrAahlFRSMsrIbBAp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          "]]}}}, {
      AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
       PlotRange -> {{0, 20}, {-0.346124788513973, 0.5818646378536386}}, 
       PlotRangeClipping -> True, PlotRangePadding -> {
         Scaled[0.02], 
         Scaled[0.02]}}], "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox[
     RowBox[{"BesselJ", "[", 
      RowBox[{"2", ",", "x"}], "]"}],
     GraphicsBox[{{{}, {}, {
         Hue[0.67, 0.6, 0.6], 
         LineBox[CompressedData["
1:eJwVl3c8le8bx+0tUvaKc6yjOByFovvKaNEwK0kloYy2FC31JUKSsgqJslUk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          "]]}}}, {
      AspectRatio -> NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> 
       True, AxesOrigin -> {0, 0}, 
       PlotRange -> {{0, 20}, {-0.31353044264473384`, 0.48649842612204064`}}, 
       PlotRangeClipping -> True, PlotRangePadding -> {
         Scaled[0.02], 
         Scaled[0.02]}}]],
    Annotation[#, 
     Graphics[{{{}, {}, {
         Hue[0.67, 0.6, 0.6], 
         Line[CompressedData["
1:eJwVl3c8le8bx+0tUvaKc6yjOByFovvKaNEwK0kloYy2FC31JUKSsgqJslUk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          "]]}}}, {
      AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
       PlotRange -> {{0, 20}, {-0.31353044264473384`, 0.48649842612204064`}}, 
       PlotRangeClipping -> True, PlotRangePadding -> {
         Scaled[0.02], 
         Scaled[0.02]}}], "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox[
     RowBox[{"BesselJ", "[", 
      RowBox[{"3", ",", "x"}], "]"}],
     GraphicsBox[{{{}, {}, {
         Hue[0.67, 0.6, 0.6], 
         LineBox[CompressedData["
1:eJwVl3k8lN8Xx4VU1kGprCOMfRlaJfeEyBKyRaRIIRLJFq0UKZEQskchFMqe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          "]]}}}, {
      AspectRatio -> NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> 
       True, AxesOrigin -> {0, 0}, 
       PlotRange -> {{0, 20}, {-0.2911602887178499, 0.434394155573201}}, 
       PlotRangeClipping -> True, PlotRangePadding -> {
         Scaled[0.02], 
         Scaled[0.02]}}]],
    Annotation[#, 
     Graphics[{{{}, {}, {
         Hue[0.67, 0.6, 0.6], 
         Line[CompressedData["
1:eJwVl3k8lN8Xx4VU1kGprCOMfRlaJfeEyBKyRaRIIRLJFq0UKZEQskchFMqe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          "]]}}}, {
      AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
       PlotRange -> {{0, 20}, {-0.2911602887178499, 0.434394155573201}}, 
       PlotRangeClipping -> True, PlotRangePadding -> {
         Scaled[0.02], 
         Scaled[0.02]}}], "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox[
     RowBox[{"BesselJ", "[", 
      RowBox[{"4", ",", "x"}], "]"}],
     GraphicsBox[{{{}, {}, {
         Hue[0.67, 0.6, 0.6], 
         LineBox[CompressedData["
1:eJwdl3k8lO/Xx1GRfV+SdQhjmzEjlMx1JBVpUyhfZItIklJIJWQJkSiKlKVs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          "]]}}}, {
      AspectRatio -> NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> 
       True, AxesOrigin -> {0, 0}, 
       PlotRange -> {{0, 20}, {-0.2743812117785123, 0.3996517420902108}}, 
       PlotRangeClipping -> True, PlotRangePadding -> {
         Scaled[0.02], 
         Scaled[0.02]}}]],
    Annotation[#, 
     Graphics[{{{}, {}, {
         Hue[0.67, 0.6, 0.6], 
         Line[CompressedData["
1:eJwdl3k8lO/Xx1GRfV+SdQhjmzEjlMx1JBVpUyhfZItIklJIJWQJkSiKlKVs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          "]]}}}, {
      AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
       PlotRange -> {{0, 20}, {-0.2743812117785123, 0.3996517420902108}}, 
       PlotRangeClipping -> True, PlotRangePadding -> {
         Scaled[0.02], 
         Scaled[0.02]}}], "Tooltip"]& ], ",", 
   TagBox[
    TooltipBox[
     RowBox[{"BesselJ", "[", 
      RowBox[{"5", ",", "x"}], "]"}],
     GraphicsBox[{{{}, {}, {
         Hue[0.67, 0.6, 0.6], 
         LineBox[CompressedData["
1:eJwVl3k4lN8bxi0RokTZd2OdwQxCljlPm5CkxVJJUREiEgotX0uWVEiSbJEs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          "]]}}}, {
      AspectRatio -> NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> 
       True, AxesOrigin -> {0, 0}, 
       PlotRange -> {{0, 20}, {-0.2610923731721269, 0.37409239301326197`}}, 
       PlotRangeClipping -> True, PlotRangePadding -> {
         Scaled[0.02], 
         Scaled[0.02]}}]],
    Annotation[#, 
     Graphics[{{{}, {}, {
         Hue[0.67, 0.6, 0.6], 
         Line[CompressedData["
1:eJwVl3k4lN8bxi0RokTZd2OdwQxCljlPm5CkxVJJUREiEgotX0uWVEiSbJEs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          "]]}}}, {
      AspectRatio -> GoldenRatio^(-1), Axes -> True, AxesOrigin -> {0, 0}, 
       PlotRange -> {{0, 20}, {-0.2610923731721269, 0.37409239301326197`}}, 
       PlotRangeClipping -> True, PlotRangePadding -> {
         Scaled[0.02], 
         Scaled[0.02]}}], "Tooltip"]& ]}], "}"}]], "Output",
 ImageSize->{504, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->86121669]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->194611012],

Cell[TextData[{
 "Make a grid of Lissajous curves with their formulas as tooltips ",
 ButtonBox["[more info]:",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://mathworld.wolfram.com/LissajousCurve.html"], None}]
}], "ExampleText",
 CellID->25818874],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Grid", "@", 
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"Tooltip", "[", 
     RowBox[{
      RowBox[{"ParametricPlot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Sin", "[", 
           RowBox[{"n", " ", "t"}], "]"}], ",", 
          RowBox[{"Sin", "[", 
           RowBox[{"m", " ", "t"}], "]"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"t", ",", "0", ",", 
          RowBox[{"2", "Pi"}]}], "}"}], ",", 
        RowBox[{"ImageSize", "\[Rule]", "70"}], ",", 
        RowBox[{"Frame", "\[Rule]", "True"}], ",", 
        RowBox[{"FrameTicks", "\[Rule]", "None"}], ",", 
        RowBox[{"Axes", "\[Rule]", "False"}]}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Sin", "[", 
         RowBox[{"n", " ", "t"}], "]"}], ",", 
        RowBox[{"Sin", "[", 
         RowBox[{"m", " ", "t"}], "]"}]}], "}"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"m", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "3"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->546128116],

Cell[BoxData[
 TagBox[GridBox[{
    {
     TagBox[
      TooltipBox[
       GraphicsBox[{{}, {}, 
         {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxdxX0w23ccwHHqoeVGpbq1RTthU3dr1YxiZp7noRQztaklETq0yFBVo+ox
TsVTPNWstSi2icpoop5WEoysZ0qYh6icx3qM0brRiKz7w+f7u73v3vfCkymf
XzkgJyeX9eb//H/pyn84FtKJNvumiD6LyKNTQCrO+nAy/TaY3Gpfak/PA1mh
p1vdCypAfkdZdGwOCyxM0tbTTuoAl3KKOlWcnoHhvjJ22/goaLlEv+SyOgWu
q6Xp9RyaBRlBAwOuuAXQ/WmrKnN7EZydcmOWkldAo50fJ5LM1kD/3vmnOywx
aFzqaJteuA7iJ+/qqpQgrzOPf0e9ixw2tS65eg9JTROTx2qQ2akJQ67NSG/v
AznJI0iKyuU8zVFkTzVRcn8MeTJmS71CiDSRj9NynEb6qYvi8StIxaSeqNM7
yGM6ZheHMe6d8zK5+RpZfEmgUS1BGgqr9AqlSOPeLfNtjErDfT5f7CHr4vPv
b2D0PxaV1ClDNtFoPc8xGq4xjmxi/J3KvCLF6HWm5okM4zmzgpM7GG/cikxd
wigQaBJYGDeyOnlEKXLghnf42i7SKoClE43R6CWBTpIga2NfjQxuI+vrYpaU
NpGJXzHwTc+RUwO/udo5IGdKwov0j4jBIW6DUwxpFcxNKUru918GG9M/0Dz1
+AWo7XFeIUo0B16m6galRU6D8wr3NEyThGBr4pY+32gYDJ1UNo8Z7gXFdzjZ
cvK/gm/bTg7V0uo79lVvGjlbFdcHNkeMMJzmBaD09i9nTSeEIG3mYUJXyTR4
YdDkvYC2ObDEXJFjwH8BLlpJ/QV2y2DNnMaur+sqaE+6WuaoIAZV9So9mQbr
oMNR5wzKODLIAee2PYF8J/y6VvwkMs05c5IsQna1jgv/mkPy3Wi3bMXIC9K4
0OMSZPFs+1uVGBVbotn6u0iP+ga1w1LkTyLKXMYeMvMbPGMA4/lHN0k4GbLn
77GFRIwbB3sf1mDM//D9uD6MVAkO9wpjcXPxtBQjjRvDlmEUMJhZOxiZs58G
rmC0IaSOkjEaLg/aDu0iM+TUKggYX55Y8ZyVIDPzD9WOvEZm+8Q7ELaR6+wu
I9kGsq7OKDhFhBRVTFmVPUCOmvRWP2oRg57OU6YW5DUwjBPmN3BtBcy1YLuT
FZZAq0W7hH7iAhjMCmC042dBi+Y46+5SEZhhF2vZVzgGNvqOueNzn4ECkk7L
qR+4oPLax9VPQr4Fk9na3HcNkEs/jz+W51PA3ekZHSovEmz7eufPXE44qBPI
m6goDwXX+/D9nSEksMmD+ECJTwQnooJrs3gEUMiiNBZwAsDGMxF1jPIvwaos
bT9uiBeY+U93zh3eRdDCx+ManeMO1quO6VaWu4Ba6t/Hc0NsQYvu9DI65xPw
BG/TurLcAtxutEzlhhiDYTaWTpXlhiCDGZjODdEF611W36gBHgw4+pFBTUP7
vv8C3mrZ9Q==
           "]]}},
        AxesOrigin->{0, 0},
        Frame->True,
        FrameTicks->None,
        ImageSize->70,
        Method->{"TransparentPolygonMesh" -> True},
        PlotRange->{{-0.9999998592812047, 
         0.9999998782744886}, {-0.9999998592812047, 0.9999998782744886}},
        PlotRangeClipping->True,
        PlotRangePadding->{
          Scaled[0.02], 
          Scaled[0.02]}],
       RowBox[{"{", 
         RowBox[{
           RowBox[{"Sin", "[", "t", "]"}], ",", 
           RowBox[{"Sin", "[", "t", "]"}]}], "}"}]],
      Annotation[#, {
        Sin[$CellContext`t], 
        Sin[$CellContext`t]}, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       GraphicsBox[{{}, {}, 
         {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxdmXdcju8b91NZIUKDSgotlDRsR5RoUSRklVCoNEhZDRSR1Ral+hIN7ajk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           "]]}},
        AxesOrigin->{0, 0},
        Frame->True,
        FrameTicks->None,
        ImageSize->70,
        Method->{"TransparentPolygonMesh" -> True},
        PlotRange->{{-0.9999996656179276, 
         0.9999993653390188}, {-0.9999998592812047, 0.9999998782744886}},
        PlotRangeClipping->True,
        PlotRangePadding->{
          Scaled[0.02], 
          Scaled[0.02]}],
       RowBox[{"{", 
         RowBox[{
           RowBox[{"Sin", "[", 
             RowBox[{"2", " ", "t"}], "]"}], ",", 
           RowBox[{"Sin", "[", "t", "]"}]}], "}"}]],
      Annotation[#, {
        Sin[2 $CellContext`t], 
        Sin[$CellContext`t]}, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       GraphicsBox[{{}, {}, 
         {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxdmXc81f/7/ymjrFKKUkkKLQ0tRReREJUUkWSVsopEZFdIKiQlIlIpQjJK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           "]]}},
        AxesOrigin->{0, 0},
        Frame->True,
        FrameTicks->None,
        ImageSize->70,
        Method->{"TransparentPolygonMesh" -> True},
        PlotRange->{{-0.9999990682297951, 
         0.9999987335310796}, {-0.9999998592812047, 0.9999998782744886}},
        PlotRangeClipping->True,
        PlotRangePadding->{
          Scaled[0.02], 
          Scaled[0.02]}],
       RowBox[{"{", 
         RowBox[{
           RowBox[{"Sin", "[", 
             RowBox[{"3", " ", "t"}], "]"}], ",", 
           RowBox[{"Sin", "[", "t", "]"}]}], "}"}]],
      Annotation[#, {
        Sin[3 $CellContext`t], 
        Sin[$CellContext`t]}, "Tooltip"]& ]},
    {
     TagBox[
      TooltipBox[
       GraphicsBox[{{}, {}, 
         {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxdmXdcju/7/1MRIUKDSgotlJSM6AiJFkVCVgmFSoOU1RBZWUUlSoVoaEel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           "]]}},
        AxesOrigin->{0, 0},
        Frame->True,
        FrameTicks->None,
        ImageSize->70,
        Method->{"TransparentPolygonMesh" -> True},
        PlotRange->{{-0.9999998592812047, 
         0.9999998782744886}, {-0.9999996656179276, 0.9999993653390188}},
        PlotRangeClipping->True,
        PlotRangePadding->{
          Scaled[0.02], 
          Scaled[0.02]}],
       RowBox[{"{", 
         RowBox[{
           RowBox[{"Sin", "[", "t", "]"}], ",", 
           RowBox[{"Sin", "[", 
             RowBox[{"2", " ", "t"}], "]"}]}], "}"}]],
      Annotation[#, {
        Sin[$CellContext`t], 
        Sin[2 $CellContext`t]}, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       GraphicsBox[{{}, {}, 
         {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxd1vk/1Akcx3GpWGrLovTIkSk7kZRod8tREpLkKEqRUjSddGG0wgyNTmdL
jnVNFzNSQkVh3Ld1VCqNEDJuqYwxM9v+4PP5Pvb9eLwez3/hTTrstctDUkJC
ovRH//n/0TosTodHeW2ekfGL8cKgqEAwKN801jQqHMw6tjLfOjIZrC6KO+d9
MwuMDlBerhxQBOZZ7mBxTRpB2tgQ5wS1AxzgS4j6Sb3g28RF7M/yA6DA2kZW
Jn4YLGisNTJhomV1Jx32sVE9b8+F6wpR3Xg/jvdHlOxB6rBeNgJaPb94RnQZ
NVru9MeR62jF8U3iBxEos+napTfxqJxvdEZRJnrKVov7rB61OFeX/ds3VDVt
2rXpO5pRVku25KNnPbMkKwWoU3aXQuM0muoxbpAtRMs0nlfIiFHt/G6tAIIt
LU3J9QRDCldqThIsd88pERKUtz3rxSXYw6SviSfYYPhTT5oIPdgR92FEiK7I
zOcpERRsfG7Bn0KN71C0Z31Fr0lquq3sQit+11DQMERX+36QjnMcBGc/o7S4
tfeBC4IuZb716ATpHvx9Wf6tYOhqrfCRzzngsOidTqt1ZdGM5M1cq12P3oE2
rDnbBiM+gX3Uy0Z2hjzw1I2fqZd6hsA+Q4eDEWNow95GN5oQtVSh0oWKw+B3
bjTHxRS1zG/VYceg8r6zvDf9OgLSSqvowtXoNakCi7j16NWoVw1Ht6KRL2Mn
nQ6iskH3BVER6GIZsa1uGxo51Mzc8h696Jl0U5+LNvv9rfS8G3VVv1FgNYQu
2hDkzJhCbSu1vyUL0BxWt1T8NCq19iVjrQi1H7GZqCG4YHt9q4UYpZhXDHYQ
1B5NXyEkaGpuXTdFMC86q7eNIMvy67lYgj15HNU9QoLc9H6fafS6e80qqgB1
oBbLqfBRYWZqWP846kjf2JT4ES3Pra3wuYM2abFqI42GwO3RcuTcls8gVdny
rsbKbtBsP92+7vgb8EWFg/zUWBGoNMeusiCgcPOMFXYmpRpz2sDXjW0mvM9d
4KQcZV+MQj94tKYglHxkCGy5Xbyt9K8R0Mx3d9GqBDSxgGfvmYLaxns8upqB
Wh1fnyv3Er17OM3P+T06spimQ+einCf9WSGdKDX8lbxqH0pKoQniR1Fzq2i9
6mn0gOJgGEuISsw9GXNchEYeuMukilH/sdUPqglazT3v+I1g93szlojgmPB2
ehdB3sZwuzSizDMpxgTj2H1G0iJUV9UusJePCrb63strRidCYnRtG1FOTvvm
qlo0yf6LwLkMPZD8cLdsDqq5JlCPcROdfuocoaaFMpdG3XKcMwzOiyhYVn6e
B5L+ZJZXNX8Cb6ZkGrymt4Pq95V92Y+rwAwy9YJOMLtoxkIj2hK3iWbQxLXw
TJZ2JxjxZDabb94HZn1QXT9qNgjOlawtidUfATWNJ78wDFAraZ3OvVtQ93Wu
r5Js0H9il58vpqD5XZN7dt5CPyk6UU68RjXbX19hvEUVx8zqgttRkZVPJqkL
VSafDucNoKrsqZ6HfHRph8389ilUX9ZsPU+A7pRecjldiJIczNn7RahLxKOm
QYImezQX5YhRNue8Xj/Boo8XrcUER7dpHvlGcEN8iE8DwdlX8xihBOVaJW+R
CDaXRt+fFKKnZa+0riAYzDwUtmoaVac6Zdbw0a4bLI7jFzRby25xXAfaZjtN
G0hEpWKfqIlZw6BYwb8qw28AbIkpr3F+3AvuFmrNLxN0gMsu3HlkcrYJnNBI
nZtHCQKf7nALVSKjKuXlMuNVgWBSJ7fXtyQApCaStgTn+oNqNUq3bidQQXWe
wd1CyhlQLeHt01nVXqBua5cKo8QTHLXlN4TlngLtd5e8S044BmrUkuqLKYdA
M4Z7xtUSVzTHKzsy1wVUsT/NTk1wAhckKe/lUOzAeS47T0blWoM0hTb1tARL
cHjxj6NLMQGLo8eN0xI2gEllG+kcii44ZHM4hENRB6VdFPXJ9zgvZvwX9UoG
0A==
           "]]}},
        AxesOrigin->{0, 0},
        Frame->True,
        FrameTicks->None,
        ImageSize->70,
        Method->{"TransparentPolygonMesh" -> True},
        PlotRange->{{-0.9999996656179276, 
         0.9999993653390188}, {-0.9999996656179276, 0.9999993653390188}},
        PlotRangeClipping->True,
        PlotRangePadding->{
          Scaled[0.02], 
          Scaled[0.02]}],
       RowBox[{"{", 
         RowBox[{
           RowBox[{"Sin", "[", 
             RowBox[{"2", " ", "t"}], "]"}], ",", 
           RowBox[{"Sin", "[", 
             RowBox[{"2", " ", "t"}], "]"}]}], "}"}]],
      Annotation[#, {
        Sin[2 $CellContext`t], 
        Sin[2 $CellContext`t]}, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       GraphicsBox[{{}, {}, 
         {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxcm3c81f8XxyNSaVFGtJQQlbSno5IoRMuoNIyEUBEViYYSUTRQiFQysmcc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           "]]}},
        AxesOrigin->{0, 0},
        Frame->True,
        FrameTicks->None,
        ImageSize->70,
        Method->{"TransparentPolygonMesh" -> True},
        PlotRange->{{-0.9999990682297951, 
         0.9999987335310796}, {-0.9999996656179276, 0.9999993653390188}},
        PlotRangeClipping->True,
        PlotRangePadding->{
          Scaled[0.02], 
          Scaled[0.02]}],
       RowBox[{"{", 
         RowBox[{
           RowBox[{"Sin", "[", 
             RowBox[{"3", " ", "t"}], "]"}], ",", 
           RowBox[{"Sin", "[", 
             RowBox[{"2", " ", "t"}], "]"}]}], "}"}]],
      Annotation[#, {
        Sin[3 $CellContext`t], 
        Sin[2 $CellContext`t]}, "Tooltip"]& ]},
    {
     TagBox[
      TooltipBox[
       GraphicsBox[{{}, {}, 
         {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxdmWk8Ve/3/ilDmUopSiUpNKloUrSIJFFJEUmmUqYiEZkTQoU0SBGpFCEZ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           "]]}},
        AxesOrigin->{0, 0},
        Frame->True,
        FrameTicks->None,
        ImageSize->70,
        Method->{"TransparentPolygonMesh" -> True},
        PlotRange->{{-0.9999998592812047, 
         0.9999998782744886}, {-0.9999990682297951, 0.9999987335310796}},
        PlotRangeClipping->True,
        PlotRangePadding->{
          Scaled[0.02], 
          Scaled[0.02]}],
       RowBox[{"{", 
         RowBox[{
           RowBox[{"Sin", "[", "t", "]"}], ",", 
           RowBox[{"Sin", "[", 
             RowBox[{"3", " ", "t"}], "]"}]}], "}"}]],
      Annotation[#, {
        Sin[$CellContext`t], 
        Sin[3 $CellContext`t]}, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       GraphicsBox[{{}, {}, 
         {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxcm3dczv/3/5USsoqGsjKaSGZWJyRFpbzRQKIhSYVSKCkjUoqsCqWEtPdS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           "]]}},
        AxesOrigin->{0, 0},
        Frame->True,
        FrameTicks->None,
        ImageSize->70,
        Method->{"TransparentPolygonMesh" -> True},
        PlotRange->{{-0.9999996656179276, 
         0.9999993653390188}, {-0.9999990682297951, 0.9999987335310796}},
        PlotRangeClipping->True,
        PlotRangePadding->{
          Scaled[0.02], 
          Scaled[0.02]}],
       RowBox[{"{", 
         RowBox[{
           RowBox[{"Sin", "[", 
             RowBox[{"2", " ", "t"}], "]"}], ",", 
           RowBox[{"Sin", "[", 
             RowBox[{"3", " ", "t"}], "]"}]}], "}"}]],
      Annotation[#, {
        Sin[2 $CellContext`t], 
        Sin[3 $CellContext`t]}, "Tooltip"]& ], 
     TagBox[
      TooltipBox[
       GraphicsBox[{{}, {}, 
         {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJxd0vk71Hsfx/F0kz2pDmp0V0eNIZKrsm9HkSx138qaMxxZoxyMLA3K1rRa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           "]]}},
        AxesOrigin->{0, 0},
        Frame->True,
        FrameTicks->None,
        ImageSize->70,
        Method->{"TransparentPolygonMesh" -> True},
        PlotRange->{{-0.9999990682297951, 
         0.9999987335310796}, {-0.9999990682297951, 0.9999987335310796}},
        PlotRangeClipping->True,
        PlotRangePadding->{
          Scaled[0.02], 
          Scaled[0.02]}],
       RowBox[{"{", 
         RowBox[{
           RowBox[{"Sin", "[", 
             RowBox[{"3", " ", "t"}], "]"}], ",", 
           RowBox[{"Sin", "[", 
             RowBox[{"3", " ", "t"}], "]"}]}], "}"}]],
      Annotation[#, {
        Sin[3 $CellContext`t], 
        Sin[3 $CellContext`t]}, "Tooltip"]& ]}
   }],
  "Grid"]], "Output",
 ImageSize->{230, 223},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->391556538]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->145653486],

Cell["Use the formulas as tooltips for each surface:", "ExampleText",
 CellID->2787294],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"Tooltip", "[", 
      RowBox[{"Re", "[", 
       RowBox[{"Sin", "[", 
        RowBox[{"x", "+", 
         RowBox[{"I", " ", "y"}]}], "]"}], "]"}], "]"}], ",", 
     RowBox[{"Tooltip", "[", 
      RowBox[{"Im", "[", 
       RowBox[{"Sin", "[", 
        RowBox[{"x", "+", 
         RowBox[{"I", " ", "y"}]}], "]"}], "]"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{
      RowBox[{"-", "2"}], "Pi"}], ",", 
     RowBox[{"2", "Pi"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "2"}], "}"}], ",", 
   RowBox[{"BoxRatios", "\[Rule]", "Automatic"}], ",", 
   RowBox[{"Ticks", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Range", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "2"}], "Pi"}], ",", 
        RowBox[{"2", "Pi"}], ",", "Pi"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1", ",", "2"}], "}"}]}], "}"}]}], ",", 
   RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Yellow", ",", "Cyan"}], "}"}]}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", "Automatic"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->53926046],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx9vQmcz9X+Pz62bGMLyW2jFO0LRVnOR12SiLpK2kh1q9tKq1aJEsqSFrQh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   "], {{
     {RGBColor[1, 1, 0], EdgeForm[None], GraphicsGroup3DBox[
       TagBox[
        TooltipBox[Polygon3DBox[CompressedData["
1:eJxN3QnYdWP1BvD9vee8R5EhkhIKCWlSKqX+RaaoDM1RmdIgQ0mlQmYNSEWk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          "]],
         RowBox[{"Re", "[", 
           RowBox[{"Sin", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}]],
        Annotation[#, 
         Re[
          Sin[$CellContext`x + Complex[0, 1] $CellContext`y]], 
         "Tooltip"]& ]]}, 
     {RGBColor[0, 1, 1], EdgeForm[None], GraphicsGroup3DBox[
       TagBox[
        TooltipBox[Polygon3DBox[CompressedData["
1:eJxN3XXYdUXVBvBXUM9zztkgJeiHgghICkgIAi8gDdJd0lJKSSkC0iCNICUh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          "]],
         RowBox[{"Im", "[", 
           RowBox[{"Sin", "[", 
             RowBox[{"x", "+", 
               RowBox[{"\[ImaginaryI]", " ", "y"}]}], "]"}], "]"}]],
        Annotation[#, 
         Im[
          Sin[$CellContext`x + Complex[0, 1] $CellContext`y]], 
         "Tooltip"]& ]]}, {}, {}, {}}, {
     Line3DBox[{1637, 1, 1428, 332, 16, 1439, 31, 1445, 46, 61, 76, 91, 1362, 
      106, 1367, 121, 1375, 136, 1383, 151, 1391, 166, 1399, 181, 1409, 196, 
      580, 1262, 211, 1091, 579, 212, 1780, 582, 1680, 213, 1576, 584, 214, 
      1353, 215, 586, 1682, 216, 1782, 588, 1684, 217, 589, 218, 591, 219, 
      1784, 593, 1686, 220, 1586, 595, 221, 1357, 222, 597, 1688, 223, 1786, 
      599, 1690, 224, 601, 1281, 225, 1095, 600, 210, 1350, 195, 1342, 180, 
      1334, 165, 1326, 150, 1318, 135, 1310, 120, 1302, 105, 90, 75, 1360, 60,
       1294, 45, 1286, 30, 351, 1644, 15, 1438, 350, 14, 1716, 348, 1132, 13, 
      1594, 611, 12, 1791, 11, 345, 1129, 10, 1434, 343, 1641, 9, 608, 8, 340,
       7, 1713, 338, 1125, 6, 1593, 605, 5, 1789, 4, 335, 1122, 3, 1429, 333, 
      1638, 2, 602, 1637}], 
     Line3DBox[{3188, 1797, 3065, 2135, 1812, 1827, 1842, 3066, 1857, 3076, 
      1872, 3078, 1887, 3080, 1902, 3082, 1917, 3084, 1932, 3088, 1947, 3092, 
      1962, 3096, 1977, 3100, 1992, 2359, 3210, 2007, 3104, 2358, 3209, 2008, 
      3053, 2009, 2361, 3211, 2010, 3277, 2363, 3213, 2011, 3109, 2364, 2012, 
      2872, 2013, 3278, 2367, 3215, 2014, 3279, 2369, 3216, 2015, 3060, 2016, 
      2371, 3217, 2017, 3281, 2373, 3219, 2018, 3117, 2374, 2019, 2875, 2020, 
      3282, 2377, 3220, 2021, 3118, 2376, 2006, 3311, 1991, 3305, 1976, 3299, 
      1961, 3293, 1946, 3287, 1931, 3284, 1916, 1901, 1886, 1871, 1856, 1841, 
      1826, 2145, 3189, 1811, 3121, 2379, 1810, 2893, 1809, 2892, 1808, 1807, 
      2889, 1806, 2887, 1805, 1804, 3318, 1803, 2884, 1802, 2883, 1801, 1800, 
      2880, 1799, 2876, 1798, 2378, 3188}]}},
   VertexNormals->CompressedData["
1:eJxsm3c41u37x1V2yEiSyoiIIi1kXDSoNB4NbWW0pFJKRkShiFJKKYWUaEhb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    "]],
  Axes->True,
  AxesLabel->{
    FormBox["x", TraditionalForm], 
    FormBox["y", TraditionalForm], 
    FormBox["\"\"", TraditionalForm]},
  Method->{"RotationControl" -> "Globe"},
  PlotRange->
   NCache[{{(-2) Pi, 2 Pi}, {0, 2}, {-3.7621956910836314`, 
     3.7621956910836314`}}, {{-6.283185307179586, 6.283185307179586}, {0, 
     2}, {-3.7621956910836314`, 3.7621956910836314`}}],
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{{{
      NCache[(-2) Pi, -6.283185307179586], 
      FormBox[
       RowBox[{
         RowBox[{"-", "2"}], " ", "\[Pi]"}], TraditionalForm]}, {
      NCache[-Pi, -3.141592653589793], 
      FormBox[
       RowBox[{"-", "\[Pi]"}], TraditionalForm]}, {0, 
      FormBox["0", TraditionalForm]}, {
      NCache[Pi, 3.141592653589793], 
      FormBox["\[Pi]", TraditionalForm]}, {
      NCache[2 Pi, 6.283185307179586], 
      FormBox[
       RowBox[{"2", " ", "\[Pi]"}], TraditionalForm]}}, {{0, 
      FormBox["0", TraditionalForm]}, {1, 
      FormBox["1", TraditionalForm]}, {2, 
      FormBox["2", TraditionalForm]}}}]], "Output",
 ImageSize->{229, 205},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 Graphics3DBoxOptions->{ImageSize->{225, Automatic}},
 CellLabel->"Out[1]=",
 CellID->41739973]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12432395],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Tooltip",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tooltip"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Mouseover",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mouseover"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["PopupWindow",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PopupWindow"]], "InlineFormula"],
 " can all be used to display additional information:"
}], "ExampleText",
 CellID->542353331],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tooltip", "[", 
  RowBox[{
   RowBox[{"x", "+", "y"}], ",", "\"\<label\>\""}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->192279667],

Cell[BoxData[
 TagBox[
  TooltipBox[
   RowBox[{"x", "+", "y"}],
   "\"label\""],
  Annotation[#, "label", "Tooltip"]& ]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->520843939]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mouseover", "[", 
  RowBox[{
   RowBox[{"x", "+", "y"}], ",", "\"\<label\>\""}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->496746337],

Cell[BoxData[
 PaneSelectorBox[{False->
  RowBox[{"x", "+", "y"}], True->"\<\"label\"\>"}, Dynamic[
   CurrentValue["MouseOver"]],
  FrameMargins->0,
  ImageSize->Automatic]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->39526622]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PopupWindow", "[", 
  RowBox[{
   RowBox[{"x", "+", "y"}], ",", "\"\<label\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->79103078],

Cell[BoxData[
 ButtonBox[
  RowBox[{"x", "+", "y"}],
  Appearance->None,
  BaseStyle->{},
  ButtonFrame->None,
  ButtonFunction:>CreateDocument[
    Internal`PopupWindowNotebook["label"]],
  DefaultBaseStyle->{},
  Evaluator->Automatic,
  Method->"Preemptive"]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->68424307]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4030],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StatusArea",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StatusArea"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Annotation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Annotation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Mouseover",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Mouseover"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PopupWindow",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PopupWindow"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PopupView",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/PopupView"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["CurrentValue",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/CurrentValue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Labeled",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Labeled"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Hyperlink",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Hyperlink"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WindowStatusArea",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WindowStatusArea"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MouseAnnotation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/MouseAnnotation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30921]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28884],

Cell[TextData[ButtonBox["Formatted Output",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/FormattedOutput"]], "Tutorials",
 CellID->175077611]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with Tooltip",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=Tooltip"], 
    None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->3390983],

Cell[TextData[ButtonBox["Annotating & Combining Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/AnnotatingAndCombiningGraphics"]], "MoreAbout",
 CellID->560278456],

Cell[TextData[ButtonBox["Click-Interactive Panels",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ClickInteractivePanels"]], "MoreAbout",
 CellID->32255611],

Cell[TextData[ButtonBox["Creating Inspectors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CreatingInspectors"]], "MoreAbout",
 CellID->5245223],

Cell[TextData[ButtonBox["Creating Web Pages",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/CreatingWebPages"]], "MoreAbout",
 CellID->760431035],

Cell[TextData[ButtonBox["Data Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DataVisualization"]], "MoreAbout",
 CellID->302228530],

Cell[TextData[ButtonBox["Document Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DocumentGeneration"]], "MoreAbout",
 CellID->104060484],

Cell[TextData[ButtonBox["Dynamic Graphics Elements",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicGraphicsElements"]], "MoreAbout",
 CellID->247537468],

Cell[TextData[ButtonBox["Dynamic Visualization",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DynamicVisualization"]], "MoreAbout",
 CellID->602072577],

Cell[TextData[ButtonBox["Graphics Annotation & Appearance",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsAnnotationAndAppearance"]], "MoreAbout",
 CellID->98479754],

Cell[TextData[ButtonBox["Graphics Options & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/GraphicsOptionsAndStyling"]], "MoreAbout",
 CellID->91085378],

Cell[TextData[ButtonBox["Notebook Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NotebookFormattingAndStyling"]], "MoreAbout",
 CellID->260096001],

Cell[TextData[ButtonBox["Palettes",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Palettes"]], "MoreAbout",
 CellID->690697189],

Cell[TextData[ButtonBox["Stand-Alone Interfaces",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/StandAloneInterfaces"]], "MoreAbout",
 CellID->691354],

Cell[TextData[ButtonBox["Symbolic Graphics Language",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicGraphicsLanguage"]], "MoreAbout",
 CellID->373416678],

Cell[TextData[ButtonBox["User Interface Structuring & Layout",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/UserInterfaceStructuringAndLayout"]], "MoreAbout",
 CellID->509589178],

Cell[TextData[ButtonBox["Viewers and Annotation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/ViewersAndAnnotation"]], "MoreAbout",
 CellID->282942691],

Cell[TextData[ButtonBox["New in 6.0: Dynamic Interactivity",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60DynamicInteractivity"]], "MoreAbout",
 CellID->71090839],

Cell[TextData[ButtonBox["New in 6.0: Formatting & Styling",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60FormattingAndStyling"]], "MoreAbout",
 CellID->22749858],

Cell[TextData[ButtonBox["New in 6.0: Graphics & Visualization Options",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/NewIn60GraphicsAndVisualizationOptions"]], "MoreAbout",
 CellID->397781438],

Cell[TextData[ButtonBox["New in 6.0: Notebooks & Documents",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60NotebooksAndDocuments"]], "MoreAbout",
 CellID->580556005],

Cell[TextData[ButtonBox["New in 6.0: Visualization & Graphics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/NewIn60VisualizationAndGraphics"]], "MoreAbout",
 CellID->371986697]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Tooltip - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 11.1300604}", "context" -> "System`", 
    "keywords" -> {
     "balloon help", "popup box", "screen tip", "ScreenTip", 
      "information drill down", "infotip"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Tooltip[expr, label] displays label as a tooltip while the mouse pointer \
is in the area where expr is displayed. ", "synonyms" -> {}, "title" -> 
    "Tooltip", "type" -> "Symbol", "uri" -> "ref/Tooltip"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[14091, 395, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->139859875]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 567238, 10332}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 6253, 127, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[6876, 154, 1572, 37, 70, "ObjectNameGrid"],
Cell[8451, 193, 739, 23, 70, "Usage",
 CellID->15346]
}, Open  ]],
Cell[CellGroupData[{
Cell[9227, 221, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[9705, 238, 216, 7, 70, "Notes",
 CellID->23670],
Cell[9924, 247, 485, 18, 70, "Notes",
 CellID->10820],
Cell[10412, 267, 206, 7, 70, "Notes",
 CellID->104278198],
Cell[10621, 276, 69, 1, 70, "Notes",
 CellID->22266],
Cell[10693, 279, 1352, 35, 70, "3ColumnTableMod",
 CellID->25069],
Cell[12048, 316, 270, 9, 70, "Notes",
 CellID->21378],
Cell[12321, 327, 343, 11, 70, "Notes",
 CellID->642903269],
Cell[12667, 340, 351, 12, 70, "Notes",
 CellID->13927],
Cell[13021, 354, 485, 17, 70, "Notes",
 CellID->23038],
Cell[13509, 373, 545, 17, 70, "Notes",
 CellID->55815475]
}, Closed]],
Cell[CellGroupData[{
Cell[14091, 395, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->139859875],
Cell[CellGroupData[{
Cell[14476, 409, 148, 5, 70, "ExampleSection",
 CellID->288952768],
Cell[14627, 416, 86, 1, 70, "ExampleText",
 CellID->73141630],
Cell[CellGroupData[{
Cell[14738, 421, 161, 5, 28, "Input",
 CellID->90259434],
Cell[14902, 428, 210, 8, 36, "Output",
 CellID->289872337]
}, Open  ]],
Cell[15127, 439, 125, 3, 70, "ExampleDelimiter",
 CellID->610109356],
Cell[15255, 444, 75, 1, 70, "ExampleText",
 CellID->19012910],
Cell[CellGroupData[{
Cell[15355, 449, 337, 11, 70, "Input",
 CellID->200755616],
Cell[15695, 462, 25494, 433, 70, "Output",
 CellID->670577979]
}, Open  ]],
Cell[41204, 898, 74, 1, 70, "ExampleText",
 CellID->531413447],
Cell[CellGroupData[{
Cell[41303, 903, 287, 9, 70, "Input",
 CellID->367578639],
Cell[41593, 914, 12278, 212, 70, "Output",
 CellID->11292865]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[53920, 1132, 215, 7, 70, "ExampleSection",
 CellID->2809],
Cell[54138, 1141, 93, 1, 70, "ExampleText",
 CellID->256299711],
Cell[CellGroupData[{
Cell[54256, 1146, 257, 8, 70, "Input",
 CellID->323896900],
Cell[54516, 1156, 318, 12, 70, "Output",
 CellID->235943663]
}, Open  ]],
Cell[54849, 1171, 124, 3, 70, "ExampleDelimiter",
 CellID->92709676],
Cell[54976, 1176, 79, 1, 70, "ExampleText",
 CellID->22521700],
Cell[CellGroupData[{
Cell[55080, 1181, 333, 12, 70, "Input",
 CellID->722271524],
Cell[55416, 1195, 1129, 47, 70, "Output",
 CellID->537714745]
}, Open  ]],
Cell[56560, 1245, 125, 3, 70, "ExampleDelimiter",
 CellID->342360282],
Cell[56688, 1250, 75, 1, 70, "ExampleText",
 CellID->125627488],
Cell[CellGroupData[{
Cell[56788, 1255, 283, 9, 70, "Input",
 CellID->504053366],
Cell[57074, 1266, 1843, 69, 70, "Output",
 CellID->16878287]
}, Open  ]],
Cell[58932, 1338, 125, 3, 70, "ExampleDelimiter",
 CellID->887736336],
Cell[59060, 1343, 80, 1, 70, "ExampleText",
 CellID->157215637],
Cell[CellGroupData[{
Cell[59165, 1348, 404, 14, 70, "Input",
 CellID->607330938],
Cell[59572, 1364, 410, 15, 70, "Output",
 CellID->226580678]
}, Open  ]],
Cell[59997, 1382, 124, 3, 70, "ExampleDelimiter",
 CellID->16910115],
Cell[60124, 1387, 236, 8, 70, "ExampleText",
 CellID->44051271],
Cell[CellGroupData[{
Cell[60385, 1399, 194, 6, 70, "Input",
 CellID->18900580],
Cell[60582, 1407, 308, 13, 70, "Output",
 CellID->103189462]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[60939, 1426, 222, 7, 70, "ExampleSection",
 CellID->105697725],
Cell[CellGroupData[{
Cell[61186, 1437, 229, 7, 70, "ExampleSubsection",
 CellID->166210],
Cell[61418, 1446, 118, 3, 70, "ExampleText",
 CellID->441783184],
Cell[CellGroupData[{
Cell[61561, 1453, 323, 10, 70, "Input",
 CellID->580773851],
Cell[61887, 1465, 251, 10, 70, "Output",
 CellID->218495173]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[62187, 1481, 230, 7, 70, "ExampleSubsection",
 CellID->74078712],
Cell[62420, 1490, 74, 1, 70, "ExampleText",
 CellID->720845318],
Cell[CellGroupData[{
Cell[62519, 1495, 391, 11, 70, "Input",
 CellID->132107901],
Cell[62913, 1508, 345, 13, 70, "Output",
 CellID->931203881]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[63319, 1528, 221, 7, 70, "ExampleSection",
 CellID->647],
Cell[63543, 1537, 138, 4, 70, "ExampleText",
 CellID->277455955],
Cell[CellGroupData[{
Cell[63706, 1545, 367, 12, 70, "Input",
 CellID->147661903],
Cell[64076, 1559, 1615, 59, 70, "Output",
 CellID->471787311]
}, Open  ]],
Cell[65706, 1621, 125, 3, 70, "ExampleDelimiter",
 CellID->301393314],
Cell[65834, 1626, 84, 1, 70, "ExampleText",
 CellID->534569348],
Cell[CellGroupData[{
Cell[65943, 1631, 504, 16, 70, "Input",
 CellID->294573042],
Cell[66450, 1649, 194021, 3237, 70, "Output",
 CellID->86121669]
}, Open  ]],
Cell[260486, 4889, 125, 3, 70, "ExampleDelimiter",
 CellID->194611012],
Cell[260614, 4894, 259, 7, 70, "ExampleText",
 CellID->25818874],
Cell[CellGroupData[{
Cell[260898, 4905, 1095, 32, 70, "Input",
 CellID->546128116],
Cell[261996, 4939, 135435, 2334, 70, "Output",
 CellID->391556538]
}, Open  ]],
Cell[397446, 7276, 125, 3, 70, "ExampleDelimiter",
 CellID->145653486],
Cell[397574, 7281, 87, 1, 70, "ExampleText",
 CellID->2787294],
Cell[CellGroupData[{
Cell[397686, 7286, 1270, 39, 70, "Input",
 CellID->53926046],
Cell[398959, 7327, 156878, 2597, 70, "Output",
 CellID->41739973]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[555886, 9930, 236, 7, 70, "ExampleSection",
 CellID->12432395],
Cell[556125, 9939, 490, 17, 70, "ExampleText",
 CellID->542353331],
Cell[CellGroupData[{
Cell[556640, 9960, 162, 5, 70, "Input",
 CellID->192279667],
Cell[556805, 9967, 262, 10, 70, "Output",
 CellID->520843939]
}, Open  ]],
Cell[CellGroupData[{
Cell[557104, 9982, 164, 5, 70, "Input",
 CellID->496746337],
Cell[557271, 9989, 314, 10, 70, "Output",
 CellID->39526622]
}, Open  ]],
Cell[CellGroupData[{
Cell[557622, 10004, 165, 5, 70, "Input",
 CellID->79103078],
Cell[557790, 10011, 401, 15, 70, "Output",
 CellID->68424307]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[558252, 10033, 310, 9, 70, "SeeAlsoSection",
 CellID->4030],
Cell[558565, 10044, 2467, 89, 70, "SeeAlso",
 CellID->30921]
}, Open  ]],
Cell[CellGroupData[{
Cell[561069, 10138, 314, 9, 70, "TutorialsSection",
 CellID->28884],
Cell[561386, 10149, 146, 3, 70, "Tutorials",
 CellID->175077611]
}, Open  ]],
Cell[CellGroupData[{
Cell[561569, 10157, 305, 8, 70, "RelatedLinksSection"],
Cell[561877, 10167, 359, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[562273, 10184, 317, 9, 70, "MoreAboutSection",
 CellID->3390983],
Cell[562593, 10195, 173, 3, 70, "MoreAbout",
 CellID->560278456],
Cell[562769, 10200, 157, 3, 70, "MoreAbout",
 CellID->32255611],
Cell[562929, 10205, 147, 3, 70, "MoreAbout",
 CellID->5245223],
Cell[563079, 10210, 146, 3, 70, "MoreAbout",
 CellID->760431035],
Cell[563228, 10215, 147, 3, 70, "MoreAbout",
 CellID->302228530],
Cell[563378, 10220, 149, 3, 70, "MoreAbout",
 CellID->104060484],
Cell[563530, 10225, 160, 3, 70, "MoreAbout",
 CellID->247537468],
Cell[563693, 10230, 153, 3, 70, "MoreAbout",
 CellID->602072577],
Cell[563849, 10235, 174, 3, 70, "MoreAbout",
 CellID->98479754],
Cell[564026, 10240, 162, 3, 70, "MoreAbout",
 CellID->91085378],
Cell[564191, 10245, 169, 3, 70, "MoreAbout",
 CellID->260096001],
Cell[564363, 10250, 128, 3, 70, "MoreAbout",
 CellID->690697189],
Cell[564494, 10255, 151, 3, 70, "MoreAbout",
 CellID->691354],
Cell[564648, 10260, 162, 3, 70, "MoreAbout",
 CellID->373416678],
Cell[564813, 10265, 180, 3, 70, "MoreAbout",
 CellID->509589178],
Cell[564996, 10270, 154, 3, 70, "MoreAbout",
 CellID->282942691],
Cell[565153, 10275, 171, 3, 70, "MoreAbout",
 CellID->71090839],
Cell[565327, 10280, 170, 3, 70, "MoreAbout",
 CellID->22749858],
Cell[565500, 10285, 197, 4, 70, "MoreAbout",
 CellID->397781438],
Cell[565700, 10291, 173, 3, 70, "MoreAbout",
 CellID->580556005],
Cell[565876, 10296, 179, 3, 70, "MoreAbout",
 CellID->371986697]
}, Open  ]],
Cell[566070, 10302, 27, 0, 70, "History"],
Cell[566100, 10304, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

