(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     34682,       1323]
NotebookOptionsPosition[     26783,       1047]
NotebookOutlinePosition[     28195,       1086]
CellTagsIndexPosition[     28109,       1081]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Basic Matrix Operations" :> 
          Documentation`HelpLookup["paclet:tutorial/BasicMatrixOperations"], 
          "Vectors and Matrices" :> 
          Documentation`HelpLookup["paclet:tutorial/VectorsAndMatrices"], 
          "Tensors" :> 
          Documentation`HelpLookup["paclet:tutorial/Tensors"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Basic Matrix Operations\"\>", 
       2->"\<\"Vectors and Matrices\"\>", 
       3->"\<\"Tensors\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Total" :> Documentation`HelpLookup["paclet:ref/Total"], 
          "Diagonal" :> Documentation`HelpLookup["paclet:ref/Diagonal"], 
          "Transpose" :> Documentation`HelpLookup["paclet:ref/Transpose"], 
          "Det" :> Documentation`HelpLookup["paclet:ref/Det"], 
          "DiagonalMatrix" :> 
          Documentation`HelpLookup["paclet:ref/DiagonalMatrix"], 
          "Eigenvalues" :> 
          Documentation`HelpLookup["paclet:ref/Eigenvalues"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Total\"\>", 2->"\<\"Diagonal\"\>", 
       3->"\<\"Transpose\"\>", 4->"\<\"Det\"\>", 5->"\<\"DiagonalMatrix\"\>", 
       6->"\<\"Eigenvalues\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{
         "Matrices and Linear Algebra" :> 
          Documentation`HelpLookup["paclet:guide/MatricesAndLinearAlgebra"], 
          "Matrix Operations" :> 
          Documentation`HelpLookup["paclet:guide/MatrixOperations"], 
          "Tensors" :> Documentation`HelpLookup["paclet:guide/Tensors"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Matrices and Linear Algebra\"\>", 
       2->"\<\"Matrix Operations\"\>", 
       3->"\<\"Tensors\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Tr", "ObjectName",
 CellID->4981],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Tr",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Tr"], "[", 
       StyleBox["list", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]finds the trace of the matrix or tensor ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Tr",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Tr"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["f", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]finds a generalized trace, combining terms with ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " instead of ",
     Cell[BoxData[
      ButtonBox["Plus",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["Tr",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/Tr"], "[", 
       RowBox[{
        StyleBox["list", "TI"], ",", 
        StyleBox["f", "TI"], ",", 
        StyleBox["n", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]goes down to level ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " in ",
     Cell[BoxData[
      StyleBox["list", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->941]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["Tr",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Tr"], "[", 
   StyleBox["list", "TI"], "]"}]], "InlineFormula"],
 " sums the diagonal elements ",
 Cell[BoxData[
  RowBox[{
   StyleBox["list", "TI"], "[", 
   RowBox[{"[", 
    RowBox[{
     StyleBox["i", "TI"], ",", 
     StyleBox["i", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "]"}], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->16461],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Tr",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tr"]], "InlineFormula"],
 " works for rectangular as well as square matrices and tensors. "
}], "Notes",
 CellID->29443],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Tr",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tr"]], "InlineFormula"],
 " can be used on ",
 Cell[BoxData[
  ButtonBox["SparseArray",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SparseArray"]], "InlineFormula"],
 " objects. ",
 ButtonBox[" \[RightGuillemet]",
  BaseStyle->"ExampleLink",
  ButtonData->907882006,
  ButtonNote->"907882006"]
}], "Notes",
 CellID->12245]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->720559381],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->119705326],

Cell["The trace of a matrix is the sum of the diagonal elements:", \
"ExampleText",
 CellID->917435290],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tr", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->101614021],

Cell[BoxData["15"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->198261091]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->1942],

Cell["Symbolic trace:", "ExampleText",
 CellID->222880600],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tr", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->783197136],

Cell[BoxData[
 RowBox[{"a", "+", "d"}]], "Output",
 ImageSize->{31, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->75383407]
}, Open  ]],

Cell["Trace of a numerical matrix:", "ExampleText",
 CellID->678172640],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tr", "[", 
  RowBox[{"RandomReal", "[", 
   RowBox[{"1", ",", 
    RowBox[{"{", 
     RowBox[{"100", ",", "100"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->200794172],

Cell[BoxData["49.33373875349953`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->80200478]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->293429051],

Cell["Trace of a sparse matrix:", "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->907882006],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tr", "[", 
  RowBox[{"SparseArray", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"{", 
       RowBox[{"i_", ",", "j_"}], "}"}], "/;", 
      RowBox[{
       RowBox[{"Abs", "[", 
        RowBox[{"i", "-", "j"}], "]"}], "\[LessEqual]", "1"}]}], "\[Rule]", 
     RowBox[{"j", "/", "i"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"40", ",", "40"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->55170632],

Cell[BoxData["40"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->3055008]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Generalizations & Extensions",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(6)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22710],

Cell[TextData[{
 "For a vector ",
 Cell[BoxData[
  ButtonBox["Tr",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tr"]], "InlineFormula"],
 " gives the sum of the elements:"
}], "ExampleText",
 CellID->264013661],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tr", "[", 
  RowBox[{"{", 
   RowBox[{"1", ",", "2", ",", "3"}], "}"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->24736473],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->185012253]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->60759869],

Cell[TextData[{
 "For a higher\[Hyphen]rank tensor, ",
 Cell[BoxData[
  ButtonBox["Tr",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tr"]], "InlineFormula"],
 " gives the sum of elements with equal indices:"
}], "ExampleText",
 CellID->750821942],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tr", "[", 
  RowBox[{"Array", "[", 
   RowBox[{"a", ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "3", ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->171374226],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", "[", 
   RowBox[{"1", ",", "1", ",", "1"}], "]"}], "+", 
  RowBox[{"a", "[", 
   RowBox[{"2", ",", "2", ",", "2"}], "]"}]}]], "Output",
 ImageSize->{146, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->23888478]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->134176572],

Cell["Apply a function to the diagonal elements of a matrix:", "ExampleText",
 CellID->116010959],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tr", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], ",", "f"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31230450],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"1", ",", "5", ",", "9"}], "]"}]], "Output",
 ImageSize->{69, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->546062765]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->136170005],

Cell["Extract the diagonal of a matrix as a list:", "ExampleText",
 CellID->7862026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tr", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], ",", "List"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->395768057],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "5", ",", "9"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->347947171]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->171671068],

Cell["\<\
Only consider down to level 1; this adds the rows of the matrix:\
\>", "ExampleText",
 CellID->157172200],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tr", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "5", ",", "6"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"7", ",", "8", ",", "9"}], "}"}]}], "}"}], ",", "Plus", ",", 
   "1"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->553606245],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"12", ",", "15", ",", "18"}], "}"}]], "Output",
 ImageSize->{83, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->165337376]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->222431815],

Cell["Only consider down to level 2:", "ExampleText",
 CellID->58214153],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tr", "[", 
  RowBox[{
   RowBox[{"Array", "[", 
    RowBox[{"a", ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "3", ",", "2"}], "}"}]}], "]"}], ",", "f", ",", "2"}],
   "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->394830056],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"1", ",", "1", ",", "1"}], "]"}], ",", 
     RowBox[{"a", "[", 
      RowBox[{"1", ",", "1", ",", "2"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"2", ",", "2", ",", "1"}], "]"}], ",", 
     RowBox[{"a", "[", 
      RowBox[{"2", ",", "2", ",", "2"}], "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"a", "[", 
      RowBox[{"3", ",", "3", ",", "1"}], "]"}], ",", 
     RowBox[{"a", "[", 
      RowBox[{"3", ",", "3", ",", "2"}], "]"}]}], "}"}]}], "]"}]], "Output",
 ImageSize->{510, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->602144005]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6013],

Cell["Find the determinant of a triangular matrix:", "ExampleText",
 CellID->330376683],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Tr", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "4", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0", ",", "6"}], "}"}]}], "}"}], ",", "Times"}], 
  "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->440599745],

Cell[BoxData["24"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->369671772]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "4", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"0", ",", "0", ",", "6"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->210846010],

Cell[BoxData["24"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->53524317]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3032482],

Cell[TextData[{
 "Define an inner product for the cone of positive definite matrices using ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"\[LeftAngleBracket]", 
     RowBox[{"A", ",", "B"}], "\[RightAngleBracket]"}], "=", 
    RowBox[{"Tr", "[", 
     RowBox[{"A", ".", 
      SuperscriptBox["B", "\[Transpose]"]}], "]"}]}], TraditionalForm]], 
  "InlineMath"],
 ":"
}], "ExampleText",
 CellID->738755083],

Cell[BoxData[
 RowBox[{
  RowBox[{"traceProduct", "[", 
   RowBox[{"a_", ",", "b_"}], "]"}], ":=", 
  RowBox[{"Tr", "[", 
   RowBox[{"a", ".", 
    RowBox[{"b", "\[Transpose]"}]}], "]"}]}]], "Input",
 CellLabel->"In[1]:=",
 CellID->229318183],

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}]}], "]"}]}], ";", " ", 
  RowBox[{"a", "=", 
   RowBox[{"a", ".", 
    RowBox[{"a", "\[Transpose]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"b", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}]}], "]"}]}], ";", 
  RowBox[{"b", "=", 
   RowBox[{"b", ".", 
    RowBox[{"b", "\[Transpose]"}]}]}], ";"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->58492105],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"traceProduct", "[", 
  RowBox[{"a", ",", "b"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->651194752],

Cell[BoxData["8.485664448751388`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->22347865]
}, Open  ]],

Cell[TextData[{
 "Project the matrix ",
 Cell[BoxData[
  FormBox["a", TraditionalForm]], "InlineMath"],
 " onto the space spanned by the matrix ",
 Cell[BoxData[
  FormBox["b", TraditionalForm]], "InlineMath"],
 ":"
}], "ExampleText",
 CellID->121480214],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Projection", "[", 
  RowBox[{"a", ",", "b", ",", "traceProduct"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->403527834],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0.5556301217774123`", ",", "0.683016180671717`", ",", 
     "0.47378944305014387`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.683016180671717`", ",", "1.4889469098129604`", ",", 
     "0.9602548288082332`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.47378944305014387`", ",", "0.9602548288082332`", ",", 
     "0.7187051600670524`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{431, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->344329622]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->788],

Cell["\<\
The trace of a matrix is invariant under similarity transformations:\
\>", "ExampleText",
 CellID->166816599],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"m", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "10"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"Tr", "[", "m", "]"}]}], "Input",
 CellLabel->"In[1]:=",
 CellID->259434566],

Cell[BoxData["5.650051089543125`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->168024302]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"a", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"10", ",", "10"}], "}"}]}], "]"}]}], ";"}], "\n", 
 RowBox[{"Tr", "[", 
  RowBox[{"a", ".", "m", ".", 
   RowBox[{"Inverse", "[", "a", "]"}]}], "]"}]}], "Input",
 CellLabel->"In[2]:=",
 CellID->266090172],

Cell[BoxData["5.650051089543128`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->2133383]
}, Open  ]],

Cell["\<\
The invariance means that the sum of the eigenvalues must equal the trace:\
\>", "ExampleText",
 CellID->112037172],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Total", "[", 
  RowBox[{"Eigenvalues", "[", "m", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->268106199],

Cell[BoxData[
 RowBox[{"5.6500510895431235`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{91, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->207662338]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->747115000],

Cell[TextData[{
 "The Frobenius norm is defined as ",
 Cell[BoxData[
  SqrtBox[
   RowBox[{"Tr", "[", 
    RowBox[{"A", ".", 
     RowBox[{"A", "\[Transpose]"}]}], "]"}]]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->309255161],

Cell[BoxData[
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"RandomReal", "[", 
    RowBox[{"1", ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "3"}], "}"}]}], "]"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->8332690],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sqrt", "@", 
  RowBox[{"Tr", "[", 
   RowBox[{"A", ".", 
    RowBox[{"Transpose", "[", "A", "]"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->179276052],

Cell[BoxData["1.5745514443304833`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->535876723]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Norm", "[", 
  RowBox[{"A", ",", "\"\<Frobenius\>\""}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->40166807],

Cell[BoxData["1.574551444330483`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->306178537]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3650],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Total",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Total"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Diagonal",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Diagonal"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Transpose",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Transpose"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Det",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Det"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DiagonalMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/DiagonalMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Eigenvalues",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Eigenvalues"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6703]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->3696],

Cell[TextData[ButtonBox["Basic Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/BasicMatrixOperations"]], "Tutorials",
 CellID->14229],

Cell[TextData[ButtonBox["Vectors and Matrices",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/VectorsAndMatrices"]], "Tutorials",
 CellID->39801072],

Cell[TextData[ButtonBox["Tensors",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/Tensors"]], "Tutorials",
 CellID->493403696]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->570133088],

Cell[TextData[ButtonBox["Matrices and Linear Algebra",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatricesAndLinearAlgebra"]], "MoreAbout",
 CellID->88156626],

Cell[TextData[ButtonBox["Matrix Operations",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/MatrixOperations"]], "MoreAbout",
 CellID->192258762],

Cell[TextData[ButtonBox["Tensors",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/Tensors"]], "MoreAbout",
 CellID->243051080]
}, Open  ]],

Cell["New in 4", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Tr - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 58.5531494}", "context" -> "System`", 
    "keywords" -> {
     "diagonal", "diagonal of matrix", "Frobenius norm", "matrices", 
      "spur of matrix", "tensors", "trace of matrix"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "Tr[list] finds the trace of the matrix or tensor list. Tr[list, f] finds \
a generalized trace, combining terms with f instead of Plus. Tr[list, f, n] \
goes down to level n in list. ", "synonyms" -> {}, "title" -> "Tr", "type" -> 
    "Symbol", "uri" -> "ref/Tr"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6768, 221, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->720559381]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 27966, 1074}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2795, 64, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3418, 91, 39, 1, 70, "ObjectName",
 CellID->4981],
Cell[3460, 94, 1639, 55, 70, "Usage",
 CellID->941]
}, Open  ]],
Cell[CellGroupData[{
Cell[5136, 154, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5614, 171, 468, 18, 70, "Notes",
 CellID->16461],
Cell[6085, 191, 218, 7, 70, "Notes",
 CellID->29443],
Cell[6306, 200, 425, 16, 70, "Notes",
 CellID->12245]
}, Closed]],
Cell[CellGroupData[{
Cell[6768, 221, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->720559381],
Cell[CellGroupData[{
Cell[7153, 235, 148, 5, 70, "ExampleSection",
 CellID->119705326],
Cell[7304, 242, 103, 2, 70, "ExampleText",
 CellID->917435290],
Cell[CellGroupData[{
Cell[7432, 248, 338, 11, 28, "Input",
 CellID->101614021],
Cell[7773, 261, 159, 5, 36, "Output",
 CellID->198261091]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7981, 272, 215, 7, 70, "ExampleSection",
 CellID->1942],
Cell[8199, 281, 58, 1, 70, "ExampleText",
 CellID->222880600],
Cell[CellGroupData[{
Cell[8282, 286, 247, 9, 70, "Input",
 CellID->783197136],
Cell[8532, 297, 179, 6, 36, "Output",
 CellID->75383407]
}, Open  ]],
Cell[8726, 306, 71, 1, 70, "ExampleText",
 CellID->678172640],
Cell[CellGroupData[{
Cell[8822, 311, 214, 7, 70, "Input",
 CellID->200794172],
Cell[9039, 320, 174, 5, 36, "Output",
 CellID->80200478]
}, Open  ]],
Cell[9228, 328, 125, 3, 70, "ExampleDelimiter",
 CellID->293429051],
Cell[9356, 333, 116, 2, 70, "ExampleText",
 CellID->907882006],
Cell[CellGroupData[{
Cell[9497, 339, 455, 15, 70, "Input",
 CellID->55170632],
Cell[9955, 356, 157, 5, 36, "Output",
 CellID->3055008]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[10161, 367, 239, 7, 70, "ExampleSection",
 CellID->22710],
Cell[10403, 376, 214, 8, 70, "ExampleText",
 CellID->264013661],
Cell[CellGroupData[{
Cell[10642, 388, 154, 5, 70, "Input",
 CellID->24736473],
Cell[10799, 395, 158, 5, 36, "Output",
 CellID->185012253]
}, Open  ]],
Cell[10972, 403, 124, 3, 70, "ExampleDelimiter",
 CellID->60759869],
Cell[11099, 408, 250, 8, 70, "ExampleText",
 CellID->750821942],
Cell[CellGroupData[{
Cell[11374, 420, 215, 7, 70, "Input",
 CellID->171374226],
Cell[11592, 429, 304, 10, 36, "Output",
 CellID->23888478]
}, Open  ]],
Cell[11911, 442, 125, 3, 70, "ExampleDelimiter",
 CellID->134176572],
Cell[12039, 447, 97, 1, 70, "ExampleText",
 CellID->116010959],
Cell[CellGroupData[{
Cell[12161, 452, 371, 13, 70, "Input",
 CellID->31230450],
Cell[12535, 467, 218, 7, 36, "Output",
 CellID->546062765]
}, Open  ]],
Cell[12768, 477, 125, 3, 70, "ExampleDelimiter",
 CellID->136170005],
Cell[12896, 482, 84, 1, 70, "ExampleText",
 CellID->7862026],
Cell[CellGroupData[{
Cell[13005, 487, 375, 13, 70, "Input",
 CellID->395768057],
Cell[13383, 502, 213, 7, 36, "Output",
 CellID->347947171]
}, Open  ]],
Cell[13611, 512, 125, 3, 70, "ExampleDelimiter",
 CellID->171671068],
Cell[13739, 517, 115, 3, 70, "ExampleText",
 CellID->157172200],
Cell[CellGroupData[{
Cell[13879, 524, 386, 13, 70, "Input",
 CellID->553606245],
Cell[14268, 539, 216, 7, 36, "Output",
 CellID->165337376]
}, Open  ]],
Cell[14499, 549, 125, 3, 70, "ExampleDelimiter",
 CellID->222431815],
Cell[14627, 554, 72, 1, 70, "ExampleText",
 CellID->58214153],
Cell[CellGroupData[{
Cell[14724, 559, 255, 9, 70, "Input",
 CellID->394830056],
Cell[14982, 570, 774, 25, 36, "Output",
 CellID->602144005]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15805, 601, 222, 7, 70, "ExampleSection",
 CellID->6013],
Cell[16030, 610, 87, 1, 70, "ExampleText",
 CellID->330376683],
Cell[CellGroupData[{
Cell[16142, 615, 376, 13, 70, "Input",
 CellID->440599745],
Cell[16521, 630, 159, 5, 36, "Output",
 CellID->369671772]
}, Open  ]],
Cell[CellGroupData[{
Cell[16717, 640, 339, 11, 70, "Input",
 CellID->210846010],
Cell[17059, 653, 158, 5, 36, "Output",
 CellID->53524317]
}, Open  ]],
Cell[17232, 661, 123, 3, 70, "ExampleDelimiter",
 CellID->3032482],
Cell[17358, 666, 412, 13, 70, "ExampleText",
 CellID->738755083],
Cell[17773, 681, 242, 8, 70, "Input",
 CellID->229318183],
Cell[18018, 691, 592, 20, 70, "Input",
 CellID->58492105],
Cell[CellGroupData[{
Cell[18635, 715, 131, 4, 70, "Input",
 CellID->651194752],
Cell[18769, 721, 174, 5, 36, "Output",
 CellID->22347865]
}, Open  ]],
Cell[18958, 729, 254, 9, 70, "ExampleText",
 CellID->121480214],
Cell[CellGroupData[{
Cell[19237, 742, 150, 4, 70, "Input",
 CellID->403527834],
Cell[19390, 748, 586, 19, 54, "Output",
 CellID->344329622]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[20025, 773, 231, 7, 70, "ExampleSection",
 CellID->788],
Cell[20259, 782, 119, 3, 70, "ExampleText",
 CellID->166816599],
Cell[CellGroupData[{
Cell[20403, 789, 269, 9, 70, "Input",
 CellID->259434566],
Cell[20675, 800, 175, 5, 36, "Output",
 CellID->168024302]
}, Open  ]],
Cell[CellGroupData[{
Cell[20887, 810, 337, 11, 70, "Input",
 CellID->266090172],
Cell[21227, 823, 173, 5, 36, "Output",
 CellID->2133383]
}, Open  ]],
Cell[21415, 831, 125, 3, 70, "ExampleText",
 CellID->112037172],
Cell[CellGroupData[{
Cell[21565, 838, 139, 4, 70, "Input",
 CellID->268106199],
Cell[21707, 844, 256, 7, 36, "Output",
 CellID->207662338]
}, Open  ]],
Cell[21978, 854, 125, 3, 70, "ExampleDelimiter",
 CellID->747115000],
Cell[22106, 859, 234, 9, 70, "ExampleText",
 CellID->309255161],
Cell[22343, 870, 224, 8, 70, "Input",
 CellID->8332690],
Cell[CellGroupData[{
Cell[22592, 882, 186, 6, 70, "Input",
 CellID->179276052],
Cell[22781, 890, 176, 5, 36, "Output",
 CellID->535876723]
}, Open  ]],
Cell[CellGroupData[{
Cell[22994, 900, 138, 4, 70, "Input",
 CellID->40166807],
Cell[23135, 906, 175, 5, 36, "Output",
 CellID->306178537]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23371, 918, 310, 9, 70, "SeeAlsoSection",
 CellID->3650],
Cell[23684, 929, 1434, 53, 70, "SeeAlso",
 CellID->6703]
}, Open  ]],
Cell[CellGroupData[{
Cell[25155, 987, 313, 9, 70, "TutorialsSection",
 CellID->3696],
Cell[25471, 998, 155, 3, 70, "Tutorials",
 CellID->14229],
Cell[25629, 1003, 152, 3, 70, "Tutorials",
 CellID->39801072],
Cell[25784, 1008, 129, 3, 70, "Tutorials",
 CellID->493403696]
}, Open  ]],
Cell[CellGroupData[{
Cell[25950, 1016, 319, 9, 70, "MoreAboutSection",
 CellID->570133088],
Cell[26272, 1027, 162, 3, 70, "MoreAbout",
 CellID->88156626],
Cell[26437, 1032, 145, 3, 70, "MoreAbout",
 CellID->192258762],
Cell[26585, 1037, 126, 3, 70, "MoreAbout",
 CellID->243051080]
}, Open  ]],
Cell[26726, 1043, 27, 0, 70, "History"],
Cell[26756, 1045, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

