(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13971,        524]
NotebookOptionsPosition[     10760,        418]
NotebookOutlinePosition[     12119,        455]
CellTagsIndexPosition[     12034,        450]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tracing Evaluation" :> 
          Documentation`HelpLookup["paclet:tutorial/TracingEvaluation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Tracing Evaluation\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Trace" :> Documentation`HelpLookup["paclet:ref/Trace"], 
          "StackComplete" :> 
          Documentation`HelpLookup["paclet:ref/StackComplete"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Trace\"\>", 
       2->"\<\"StackComplete\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TraceAbove", "ObjectName",
 CellID->16981],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["TraceAbove",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/TraceAbove"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Trace",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
     " and related functions which specifies whether to include evaluation \
chains which contain the evaluation chain containing the pattern ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     " sought. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->11753]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"TraceAbove", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " includes the first and last expressions in all evaluation chains within \
which the evaluation chain containing ",
 Cell[BoxData[
  StyleBox["form", "TI"]], "InlineFormula"],
 " occurs. "
}], "Notes",
 CellID->4704],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"TraceAbove", "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 " includes all expressions in these evaluation chains. "
}], "Notes",
 CellID->10838],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"TraceAbove", "->", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["backward", "TI"], ",", 
     StyleBox["forward", "TI"]}], "}"}]}]], "InlineFormula"],
 " allows you to specify separately which expressions to include in the \
backward and forward directions. "
}], "Notes",
 CellID->8597],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["TraceAbove",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraceAbove"]], "InlineFormula"],
 ", you can see the complete paths by which expressions matching ",
 Cell[BoxData[
  StyleBox["form", "TI"]], "InlineFormula"],
 " arose during an evaluation. "
}], "Notes",
 CellID->4322]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->592464897],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->518625050],

Cell["A recursive definition for finding Fibonacci numbers:", "ExampleText",
 CellID->85517671],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"fib", "[", "0", "]"}], "=", 
   RowBox[{
    RowBox[{"fib", "[", "1", "]"}], "=", "1"}]}], ";", 
  RowBox[{
   RowBox[{"fib", "[", "n_", "]"}], ":=", 
   RowBox[{
    RowBox[{"fib", "[", 
     RowBox[{"n", "-", "1"}], "]"}], "+", 
    RowBox[{"fib", "[", 
     RowBox[{"n", "-", "2"}], "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->75714580],

Cell[TextData[{
 "Show only what sums of ",
 Cell[BoxData["fib"], "InlineFormula"],
 " are encountered:"
}], "ExampleText",
 CellID->91783335],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"fib", "[", "3", "]"}], ",", " ", 
   RowBox[{
    RowBox[{"fib", "[", "x_", "]"}], "+", 
    RowBox[{"fib", "[", "y_", "]"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->387546432],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{
     RowBox[{"fib", "[", 
      RowBox[{"3", "-", "1"}], "]"}], "+", 
     RowBox[{"fib", "[", 
      RowBox[{"3", "-", "2"}], "]"}]}],
    HoldForm], ",", 
   RowBox[{"{", 
    TagBox[
     RowBox[{
      RowBox[{"fib", "[", 
       RowBox[{"2", "-", "1"}], "]"}], "+", 
      RowBox[{"fib", "[", 
       RowBox[{"2", "-", "2"}], "]"}]}],
     HoldForm], "}"}]}], "}"}]], "Output",
 ImageSize->{315, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->17835230]
}, Open  ]],

Cell[TextData[{
 "Show the beginning of the evaluation chain that leads to each sum of ",
 Cell[BoxData["fib"], "InlineFormula"],
 " :"
}], "ExampleText",
 CellID->902758101],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"fib", "[", "3", "]"}], ",", 
   RowBox[{
    RowBox[{"fib", "[", "x_", "]"}], "+", 
    RowBox[{"fib", "[", "y_", "]"}]}], ",", 
   RowBox[{"TraceAbove", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->347458106],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"fib", "[", "3", "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{"fib", "[", 
      RowBox[{"3", "-", "1"}], "]"}], "+", 
     RowBox[{"fib", "[", 
      RowBox[{"3", "-", "2"}], "]"}]}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"fib", "[", "2", "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{
       RowBox[{"fib", "[", 
        RowBox[{"2", "-", "1"}], "]"}], "+", 
       RowBox[{"fib", "[", 
        RowBox[{"2", "-", "2"}], "]"}]}],
      HoldForm], ",", 
     TagBox["2",
      HoldForm]}], "}"}], ",", 
   TagBox["3",
    HoldForm]}], "}"}]], "Output",
 ImageSize->{458, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->878785177]
}, Open  ]],

Cell[TextData[{
 "Show the entire evaluation chain that leads to each sum of ",
 Cell[BoxData["fib"], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->17157376],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"fib", "[", "3", "]"}], ",", 
   RowBox[{
    RowBox[{"fib", "[", "x_", "]"}], "+", 
    RowBox[{"fib", "[", "y_", "]"}]}], ",", 
   RowBox[{"TraceAbove", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->29144157],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"fib", "[", "3", "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{"fib", "[", 
      RowBox[{"3", "-", "1"}], "]"}], "+", 
     RowBox[{"fib", "[", 
      RowBox[{"3", "-", "2"}], "]"}]}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"fib", "[", "2", "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{
       RowBox[{"fib", "[", 
        RowBox[{"2", "-", "1"}], "]"}], "+", 
       RowBox[{"fib", "[", 
        RowBox[{"2", "-", "2"}], "]"}]}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"1", "+", "1"}],
      HoldForm], ",", 
     TagBox["2",
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"2", "+", "1"}],
    HoldForm], ",", 
   TagBox["3",
    HoldForm]}], "}"}]], "Output",
 ImageSize->{534, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->49432315]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31221],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Trace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trace"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StackComplete",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StackComplete"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->237]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19595],

Cell[TextData[ButtonBox["Tracing Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TracingEvaluation"]], "Tutorials",
 CellID->260]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TraceAbove - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 19.0052620}", "context" -> "System`", 
    "keywords" -> {"stack trace", "evaluation chain"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "TraceAbove is an option for Trace and related functions which specifies \
whether to include evaluation chains which contain the evaluation chain \
containing the pattern form sought. ", "synonyms" -> {"trace above"}, "title" -> 
    "TraceAbove", "type" -> "Symbol", "uri" -> "ref/TraceAbove"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4552, 158, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->592464897]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11891, 443}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1258, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1881, 59, 48, 1, 70, "ObjectName",
 CellID->16981],
Cell[1932, 62, 764, 22, 70, "Usage",
 CellID->11753]
}, Open  ]],
Cell[CellGroupData[{
Cell[2733, 89, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3211, 106, 381, 12, 70, "Notes",
 CellID->4704],
Cell[3595, 120, 247, 8, 70, "Notes",
 CellID->10838],
Cell[3845, 130, 329, 10, 70, "Notes",
 CellID->8597],
Cell[4177, 142, 338, 11, 70, "Notes",
 CellID->4322]
}, Closed]],
Cell[CellGroupData[{
Cell[4552, 158, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->592464897],
Cell[CellGroupData[{
Cell[4937, 172, 148, 5, 70, "ExampleSection",
 CellID->518625050],
Cell[5088, 179, 95, 1, 70, "ExampleText",
 CellID->85517671],
Cell[5186, 182, 402, 14, 70, "Input",
 CellID->75714580],
Cell[5591, 198, 142, 5, 70, "ExampleText",
 CellID->91783335],
Cell[CellGroupData[{
Cell[5758, 207, 250, 8, 28, "Input",
 CellID->387546432],
Cell[6011, 217, 576, 22, 36, "Output",
 CellID->17835230]
}, Open  ]],
Cell[6602, 242, 174, 5, 70, "ExampleText",
 CellID->902758101],
Cell[CellGroupData[{
Cell[6801, 251, 297, 9, 70, "Input",
 CellID->347458106],
Cell[7101, 262, 817, 33, 36, "Output",
 CellID->878785177]
}, Open  ]],
Cell[7933, 298, 162, 5, 70, "ExampleText",
 CellID->17157376],
Cell[CellGroupData[{
Cell[8120, 307, 295, 9, 70, "Input",
 CellID->29144157],
Cell[8418, 318, 944, 39, 36, "Output",
 CellID->49432315]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9423, 364, 311, 9, 70, "SeeAlsoSection",
 CellID->31221],
Cell[9737, 375, 453, 17, 70, "SeeAlso",
 CellID->237]
}, Open  ]],
Cell[CellGroupData[{
Cell[10227, 397, 314, 9, 70, "TutorialsSection",
 CellID->19595],
Cell[10544, 408, 144, 3, 70, "Tutorials",
 CellID->260]
}, Open  ]],
Cell[10703, 414, 27, 0, 70, "History"],
Cell[10733, 416, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

