(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12804,        478]
NotebookOptionsPosition[      9632,        373]
NotebookOutlinePosition[     11007,        411]
CellTagsIndexPosition[     10922,        406]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tracing Evaluation" :> 
          Documentation`HelpLookup["paclet:tutorial/TracingEvaluation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Tracing Evaluation\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Trace" :> Documentation`HelpLookup["paclet:ref/Trace"], 
          "StackComplete" :> 
          Documentation`HelpLookup["paclet:ref/StackComplete"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Trace\"\>", 
       2->"\<\"StackComplete\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TraceBackward", "ObjectName",
 CellID->32407],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["TraceBackward",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/TraceBackward"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Trace",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
     " and related functions which specifies whether to include preceding \
expressions on the evaluation chain that contains the pattern ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     " sought. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13977]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"TraceBackward", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " includes the first expression on the evaluation chain that contains ",
 Cell[BoxData[
  StyleBox["form", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15471],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"TraceBackward", "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 " includes all expressions before ",
 Cell[BoxData[
  StyleBox["form", "TI"]], "InlineFormula"],
 " on the evaluation chain that contains ",
 Cell[BoxData[
  StyleBox["form", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->27205],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraceBackward",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraceBackward"]], "InlineFormula"],
 " allows you to see the previous forms that an expression had during an \
evaluation. "
}], "Notes",
 CellID->2030]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->142417262],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->184408655],

Cell["A recursive definition for finding Fibonacci numbers:", "ExampleText",
 CellID->85517671],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"fib", "[", "0", "]"}], "=", 
   RowBox[{
    RowBox[{"fib", "[", "1", "]"}], "=", "1"}]}], ";", 
  RowBox[{
   RowBox[{"fib", "[", "n_", "]"}], ":=", 
   RowBox[{
    RowBox[{"fib", "[", 
     RowBox[{"n", "-", "1"}], "]"}], "+", 
    RowBox[{"fib", "[", 
     RowBox[{"n", "-", "2"}], "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->75714580],

Cell["Show only what additions of positive integers are required:", \
"ExampleText",
 CellID->91783335],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"fib", "[", "3", "]"}], ",", " ", 
   RowBox[{"Plus", "[", 
    RowBox[{"__Integer", "?", "Positive"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->387546432],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    TagBox[
     RowBox[{"1", "+", "1"}],
     HoldForm], "}"}], ",", 
   TagBox[
    RowBox[{"2", "+", "1"}],
    HoldForm]}], "}"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->711269210]
}, Open  ]],

Cell["\<\
Show the beginning of the evaluation chain that leads to each addition:\
\>", "ExampleText",
 CellID->902758101],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"fib", "[", "3", "]"}], ",", " ", 
   RowBox[{"Plus", "[", 
    RowBox[{"__Integer", "?", "Positive"}], "]"}], ",", 
   RowBox[{"TraceBackward", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->347458106],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"fib", "[", "3", "]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"fib", "[", "2", "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"1", "+", "1"}],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"2", "+", "1"}],
    HoldForm]}], "}"}]], "Output",
 ImageSize->{203, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->44439400]
}, Open  ]],

Cell["Show all intermediate evaluations that led to each addition:", \
"ExampleText",
 CellID->17157376],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"fib", "[", "3", "]"}], ",", " ", 
   RowBox[{"Plus", "[", 
    RowBox[{"__Integer", "?", "Positive"}], "]"}], ",", 
   RowBox[{"TraceBackward", "\[Rule]", "All"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->66316966],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"fib", "[", "3", "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{"fib", "[", 
      RowBox[{"3", "-", "1"}], "]"}], "+", 
     RowBox[{"fib", "[", 
      RowBox[{"3", "-", "2"}], "]"}]}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"fib", "[", "2", "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{
       RowBox[{"fib", "[", 
        RowBox[{"2", "-", "1"}], "]"}], "+", 
       RowBox[{"fib", "[", 
        RowBox[{"2", "-", "2"}], "]"}]}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"1", "+", "1"}],
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"2", "+", "1"}],
    HoldForm]}], "}"}]], "Output",
 ImageSize->{497, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->15105819]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20598],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Trace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trace"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["StackComplete",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StackComplete"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->31042]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18920],

Cell[TextData[ButtonBox["Tracing Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TracingEvaluation"]], "Tutorials",
 CellID->260]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TraceBackward - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 19.2865192}", "context" -> "System`", 
    "keywords" -> {"stack trace", "evaluation chain"}, "index" -> True, 
    "label" -> "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "TraceBackward is an option for Trace and related functions which \
specifies whether to include preceding expressions on the evaluation chain \
that contains the pattern form sought. ", "synonyms" -> {"trace backward"}, 
    "title" -> "TraceBackward", "type" -> "Symbol", "uri" -> 
    "ref/TraceBackward"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4254, 148, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->142417262]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10779, 399}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1258, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1881, 59, 51, 1, 70, "ObjectName",
 CellID->32407],
Cell[1935, 62, 766, 22, 70, "Usage",
 CellID->13977]
}, Open  ]],
Cell[CellGroupData[{
Cell[2738, 89, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3216, 106, 334, 11, 70, "Notes",
 CellID->15471],
Cell[3553, 119, 400, 14, 70, "Notes",
 CellID->27205],
Cell[3956, 135, 261, 8, 70, "Notes",
 CellID->2030]
}, Closed]],
Cell[CellGroupData[{
Cell[4254, 148, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->142417262],
Cell[CellGroupData[{
Cell[4639, 162, 148, 5, 70, "ExampleSection",
 CellID->184408655],
Cell[4790, 169, 95, 1, 70, "ExampleText",
 CellID->85517671],
Cell[4888, 172, 402, 14, 70, "Input",
 CellID->75714580],
Cell[5293, 188, 103, 2, 70, "ExampleText",
 CellID->91783335],
Cell[CellGroupData[{
Cell[5421, 194, 232, 7, 28, "Input",
 CellID->387546432],
Cell[5656, 203, 332, 14, 36, "Output",
 CellID->711269210]
}, Open  ]],
Cell[6003, 220, 122, 3, 70, "ExampleText",
 CellID->902758101],
Cell[CellGroupData[{
Cell[6150, 227, 287, 8, 70, "Input",
 CellID->347458106],
Cell[6440, 237, 492, 21, 36, "Output",
 CellID->44439400]
}, Open  ]],
Cell[6947, 261, 104, 2, 70, "ExampleText",
 CellID->17157376],
Cell[CellGroupData[{
Cell[7076, 267, 285, 8, 70, "Input",
 CellID->66316966],
Cell[7364, 277, 868, 35, 36, "Output",
 CellID->15105819]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8293, 319, 311, 9, 70, "SeeAlsoSection",
 CellID->20598],
Cell[8607, 330, 455, 17, 70, "SeeAlso",
 CellID->31042]
}, Open  ]],
Cell[CellGroupData[{
Cell[9099, 352, 314, 9, 70, "TutorialsSection",
 CellID->18920],
Cell[9416, 363, 144, 3, 70, "Tutorials",
 CellID->260]
}, Open  ]],
Cell[9575, 369, 27, 0, 70, "History"],
Cell[9605, 371, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

