(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14226,        461]
NotebookOptionsPosition[     11339,        366]
NotebookOutlinePosition[     12672,        403]
CellTagsIndexPosition[     12587,        398]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tracing Evaluation" :> 
          Documentation`HelpLookup["paclet:tutorial/TracingEvaluation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Tracing Evaluation\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Trace" :> Documentation`HelpLookup["paclet:ref/Trace"], 
          "TraceOff" :> Documentation`HelpLookup["paclet:ref/TraceOff"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Trace\"\>", 
       2->"\<\"TraceOff\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TraceDepth", "ObjectName",
 CellID->19275],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["TraceDepth",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/TraceDepth"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Trace",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
     " and related functions which specifies the maximum nesting of \
evaluation chains that are to be included. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3435]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Setting ",
 Cell[BoxData[
  RowBox[{"TraceDepth", "->", 
   StyleBox["n", "TI"]}]], "InlineFormula"],
 " keeps only parts down to level ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " in nested lists generated by ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->25976],

Cell[TextData[{
 "By setting ",
 Cell[BoxData[
  ButtonBox["TraceDepth",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraceDepth"]], "InlineFormula"],
 ", you can make ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 " and related functions skip over \"inner\" parts of a computation, making \
their operation more efficient. "
}], "Notes",
 CellID->14840]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->7415069],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->59753551],

Cell["A recursive definition for finding Fibonacci numbers:", "ExampleText",
 CellID->85517671],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"fib", "[", "0", "]"}], "=", 
   RowBox[{
    RowBox[{"fib", "[", "1", "]"}], "=", "1"}]}], ";", 
  RowBox[{
   RowBox[{"fib", "[", "n_", "]"}], ":=", 
   RowBox[{
    RowBox[{"fib", "[", 
     RowBox[{"n", "-", "1"}], "]"}], "+", 
    RowBox[{"fib", "[", 
     RowBox[{"n", "-", "2"}], "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->75714580],

Cell["Trace only evaluations through depth 3:", "ExampleText",
 CellID->825889525],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"fib", "[", "5", "]"}], ",", 
   RowBox[{"TraceDepth", "\[Rule]", "2"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->334715260],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"fib", "[", "5", "]"}],
    HoldForm], ",", 
   TagBox[
    RowBox[{
     RowBox[{"fib", "[", 
      RowBox[{"5", "-", "1"}], "]"}], "+", 
     RowBox[{"fib", "[", 
      RowBox[{"5", "-", "2"}], "]"}]}],
    HoldForm], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"fib", "[", "3", "]"}],
      HoldForm], ",", 
     TagBox[
      RowBox[{
       RowBox[{"fib", "[", 
        RowBox[{"3", "-", "1"}], "]"}], "+", 
       RowBox[{"fib", "[", 
        RowBox[{"3", "-", "2"}], "]"}]}],
      HoldForm], ",", 
     TagBox[
      RowBox[{"2", "+", "1"}],
      HoldForm], ",", 
     TagBox["3",
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"5", "+", "3"}],
    HoldForm], ",", 
   TagBox["8",
    HoldForm]}], "}"}]], "Output",
 ImageSize->{534, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->358789444]
}, Open  ]],

Cell["Trace all evaluations:", "ExampleText",
 CellID->258601656],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{"fib", "[", "5", "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->33929401],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{576, 135},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->3854399]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->21367],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Trace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trace"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TraceOff",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraceOff"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->12637]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16048],

Cell[TextData[ButtonBox["Tracing Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TracingEvaluation"]], "Tutorials",
 CellID->260]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TraceDepth - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 19.5209002}", "context" -> "System`", 
    "keywords" -> {"stack trace", "evaluation chain", "stack depth"}, "index" -> 
    True, "label" -> "Built-in Mathematica Symbol", "language" -> "en", 
    "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "TraceDepth is an option for Trace and related functions which specifies \
the maximum nesting of evaluation chains that are to be included. ", 
    "synonyms" -> {"trace depth"}, "title" -> "TraceDepth", "type" -> 
    "Symbol", "uri" -> "ref/TraceDepth"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3934, 138, 358, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->7415069]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12446, 391}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1233, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1856, 58, 48, 1, 70, "ObjectName",
 CellID->19275],
Cell[1907, 61, 648, 19, 70, "Usage",
 CellID->3435]
}, Open  ]],
Cell[CellGroupData[{
Cell[2592, 85, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3070, 102, 396, 15, 70, "Notes",
 CellID->25976],
Cell[3469, 119, 428, 14, 70, "Notes",
 CellID->14840]
}, Closed]],
Cell[CellGroupData[{
Cell[3934, 138, 358, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->7415069],
Cell[CellGroupData[{
Cell[4317, 152, 147, 5, 70, "ExampleSection",
 CellID->59753551],
Cell[4467, 159, 95, 1, 70, "ExampleText",
 CellID->85517671],
Cell[4565, 162, 402, 14, 70, "Input",
 CellID->75714580],
Cell[4970, 178, 82, 1, 70, "ExampleText",
 CellID->825889525],
Cell[CellGroupData[{
Cell[5077, 183, 194, 6, 28, "Input",
 CellID->334715260],
Cell[5274, 191, 945, 39, 36, "Output",
 CellID->358789444]
}, Open  ]],
Cell[6234, 233, 65, 1, 70, "ExampleText",
 CellID->258601656],
Cell[CellGroupData[{
Cell[6324, 238, 130, 4, 28, "Input",
 CellID->33929401],
Cell[6457, 244, 3492, 61, 156, "Output",
 Evaluatable->False,
 CellID->3854399]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10010, 312, 311, 9, 70, "SeeAlsoSection",
 CellID->21367],
Cell[10324, 323, 445, 17, 70, "SeeAlso",
 CellID->12637]
}, Open  ]],
Cell[CellGroupData[{
Cell[10806, 345, 314, 9, 70, "TutorialsSection",
 CellID->16048],
Cell[11123, 356, 144, 3, 70, "Tutorials",
 CellID->260]
}, Open  ]],
Cell[11282, 362, 27, 0, 70, "History"],
Cell[11312, 364, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

