(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     13496,        480]
NotebookOptionsPosition[     10529,        381]
NotebookOutlinePosition[     11841,        418]
CellTagsIndexPosition[     11756,        413]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tracing Evaluation" :> 
          Documentation`HelpLookup["paclet:tutorial/TracingEvaluation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Tracing Evaluation\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Trace" :> Documentation`HelpLookup["paclet:ref/Trace"], 
          "TraceDepth" :> Documentation`HelpLookup["paclet:ref/TraceDepth"], 
          "TraceOn" :> Documentation`HelpLookup["paclet:ref/TraceOn"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Trace\"\>", 
       2->"\<\"TraceDepth\"\>", 3->"\<\"TraceOn\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TraceOff", "ObjectName",
 CellID->22741],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["TraceOff",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/TraceOff"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Trace",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
     " and related functions which specifies forms inside which tracing \
should be switched off. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19763]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The setting for ",
 Cell[BoxData[
  ButtonBox["TraceOff",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraceOff"]], "InlineFormula"],
 " gives a pattern which is compared with expressions to be evaluated. If the \
pattern matches the expression, then tracing will be switched off while that \
expression is being evaluated. The pattern is also tested against tags \
associated with the evaluation. "
}], "Notes",
 CellID->10648],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["TraceOff",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraceOff"]], "InlineFormula"],
 " to avoid tracing inner parts of a computation. "
}], "Notes",
 CellID->27932],

Cell[TextData[{
 "The default setting ",
 Cell[BoxData[
  RowBox[{"TraceOff", "->", 
   ButtonBox["None",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/None"]}]], "InlineFormula"],
 " never switches off tracing. "
}], "Notes",
 CellID->18667],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TraceOn",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraceOn"]], "InlineFormula"],
 " will not work inside ",
 Cell[BoxData[
  ButtonBox["TraceOff",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraceOff"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->28953],

Cell[TextData[{
 "During the execution of ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 ", the settings for ",
 Cell[BoxData[
  ButtonBox["TraceOn",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraceOn"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["TraceOff",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraceOff"]], "InlineFormula"],
 " can be modified by resetting the values of the global variables ",
 Cell[BoxData["$TraceOn"], "InlineFormula"],
 " and ",
 Cell[BoxData["$TraceOff"], "InlineFormula"],
 ". "
}], "Notes",
 CellID->31146]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->171890752],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->573873206],

Cell[TextData[{
 "Trace evaluation of an expression that evaluates a function ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->83694623],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"g", "[", "x_", "]"}], " ", ":=", " ", 
   RowBox[{
    RowBox[{"x", "^", "2"}], " ", "+", " ", "1"}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->31069508],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{"1", "+", 
   RowBox[{"g", "[", "1", "]"}], "+", 
   RowBox[{"g", "[", 
    RowBox[{"g", "[", "1", "]"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->440553655],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWc1SE0EQnrDZBEhIggHKm0HFkpN40oNyU09W6UXPKYoqOFhayNmn8DV8
N3mCdXt3B4Yv3XTvbipshFRldnu2/6a7p2em5+P0/OT42/T89Gg6+XA2/XFy
evRz8v77WdoVtZxr/XXO7T106XuSvmV/+l2kf+d6abuSdsXF82vx3C2eb4vn
sdD/OaB3bp3ayEtIXBvgLwA/AfgNwNOS+J8AXlliraK0iQLPhJ4K8Z4DvAbw
SIEjZTQa/uqS6PlKwbd5pcNRBXCP0YKssV88kf+o6N8U6J4q3/sN0+e18N0e
8+0UxH6ijpl+zjsxY5VYoF8V5KCeHYFekt81yrfy7TbULjSHCcS5hvw8Hs4e
SX43ucopdeyN/R2BryTPFrUZVnwJZzS6TziYZg7mRfQZjkmiQ/7rRjyJH8qV
9OiarWHHtltY5lnVjrxsb03Mr5h/2wIeF4H1ran5LGa52bAqeEyNtcg8upvg
IcDkG272DxQfbCvfOXqLHMx6fdOoMadq2vSM2qCcrbTpMPL7QT/Hl9sBWKyF
1vA5HGOlx1oJrdDK+heToTHOtIyC+MgP402Tp2VgTd5GI60wNmnF665ZhN2F
1rAwwraY5XOjKWZDuAG+mnfEame2DYMNMCMgD5SBK7FmA+SfxWv7Cp7VaDCD
odmBKCImu2n2xH06l1sJHAr87acysnxu2vyn7fi1yNhRvteNPJz5WiYYGMao
nf1RxpaiI/IbBzCXN4bwHeVp+xuUP1boM3hO2QxnXdl4ISkRM2YtbjwdZoGy
8WNbOzGqbfsOnrd1xLwMbtyLiKkhqw1af96R5deFsJI9CvpxPbipgsVZiPpx
tvqM8SCQx+XYnYBvFOjp8bn1StKPw99Uxhk+uRpSOA4fb4QnrUk2r7wE+DHA
SI8zB2voCNflV60mv5yjwjuegwCL5p2v6a5B/3Zy/a7nsCLd9Tuid6DjC4B/
K9//ZFzo9QLeMANId1lEsZ9RaLuYsjdD1Dy7Zc7Lcm9EzcQ0oqbduRCwa/ZF
E+v2t32fQc0jkwXva+shXblqMAH5DOOq0jNz887VYanZSxYXhU2vxmjyqLGt
Qfe1q7Ir9v9eX7Fb425UCsrZo8nnW/tI5n16aoJk9ErVsxVxzM8khyALzz/U
/Mq5tP4B4DByKA==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{496, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->83767331]
}, Open  ]],

Cell[TextData[{
 "Omit evaluations required to get the values of ",
 Cell[BoxData[
  StyleBox["g", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->577127716],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"1", "+", 
    RowBox[{"g", "[", "1", "]"}], "+", 
    RowBox[{"g", "[", 
     RowBox[{"g", "[", "1", "]"}], "]"}]}], ",", 
   RowBox[{"TraceOff", "\[Rule]", "_g"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->335130619],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"g", "[", "1", "]"}],
      HoldForm], ",", 
     TagBox["2",
      HoldForm]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       TagBox[
        RowBox[{"g", "[", "1", "]"}],
        HoldForm], ",", 
       TagBox["2",
        HoldForm]}], "}"}], ",", 
     TagBox[
      RowBox[{"g", "[", "2", "]"}],
      HoldForm], ",", 
     TagBox["5",
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"1", "+", "2", "+", "5"}],
    HoldForm], ",", 
   TagBox["8",
    HoldForm]}], "}"}]], "Output",
 ImageSize->{297, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->10932888]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3266],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Trace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trace"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TraceDepth",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraceDepth"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TraceOn",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraceOn"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16729]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->213],

Cell[TextData[ButtonBox["Tracing Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TracingEvaluation"]], "Tutorials",
 CellID->23594]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TraceOff - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 27.0523430}", "context" -> "System`", 
    "keywords" -> {"stack trace", "evaluation chain", "trace control"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "TraceOff is an option for Trace and related functions which specifies \
forms inside which tracing should be switched off. ", 
    "synonyms" -> {"trace off"}, "title" -> "TraceOff", "type" -> "Symbol", 
    "uri" -> "ref/TraceOff"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5074, 178, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->171890752]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 11613, 406}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1333, 32, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1956, 59, 46, 1, 70, "ObjectName",
 CellID->22741],
Cell[2005, 62, 630, 19, 70, "Usage",
 CellID->19763]
}, Open  ]],
Cell[CellGroupData[{
Cell[2672, 86, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3150, 103, 450, 11, 70, "Notes",
 CellID->10648],
Cell[3603, 116, 232, 8, 70, "Notes",
 CellID->27932],
Cell[3838, 126, 247, 9, 70, "Notes",
 CellID->18667],
Cell[4088, 137, 313, 12, 70, "Notes",
 CellID->28953],
Cell[4404, 151, 633, 22, 70, "Notes",
 CellID->31146]
}, Closed]],
Cell[CellGroupData[{
Cell[5074, 178, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->171890752],
Cell[CellGroupData[{
Cell[5459, 192, 148, 5, 70, "ExampleSection",
 CellID->573873206],
Cell[5610, 199, 180, 6, 70, "ExampleText",
 CellID->83694623],
Cell[5793, 207, 209, 7, 70, "Input",
 CellID->31069508],
Cell[CellGroupData[{
Cell[6027, 218, 222, 7, 28, "Input",
 CellID->440553655],
Cell[6252, 227, 1386, 27, 58, "Output",
 Evaluatable->False,
 CellID->83767331]
}, Open  ]],
Cell[7653, 257, 168, 6, 70, "ExampleText",
 CellID->577127716],
Cell[CellGroupData[{
Cell[7846, 267, 287, 9, 70, "Input",
 CellID->335130619],
Cell[8136, 278, 757, 33, 36, "Output",
 CellID->10932888]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8954, 318, 310, 9, 70, "SeeAlsoSection",
 CellID->3266],
Cell[9267, 329, 692, 26, 70, "SeeAlso",
 CellID->16729]
}, Open  ]],
Cell[CellGroupData[{
Cell[9996, 360, 312, 9, 70, "TutorialsSection",
 CellID->213],
Cell[10311, 371, 146, 3, 70, "Tutorials",
 CellID->23594]
}, Open  ]],
Cell[10472, 377, 27, 0, 70, "History"],
Cell[10502, 379, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

