(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10433,        387]
NotebookOptionsPosition[      7655,        297]
NotebookOutlinePosition[      9026,        334]
CellTagsIndexPosition[      8942,        329]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tracing Evaluation" :> 
          Documentation`HelpLookup["paclet:tutorial/TracingEvaluation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Tracing Evaluation\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Trace" :> Documentation`HelpLookup["paclet:ref/Trace"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Trace\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TraceOriginal", "ObjectName",
 CellID->26784],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["TraceOriginal",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/TraceOriginal"]], "InlineFormula"],
     "\[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Trace",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
     " and related functions which specifies whether to test the form of each \
expression before its head and arguments are evaluated. "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21426]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "With the default ",
 Cell[BoxData[
  RowBox[{"TraceOriginal", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 ", the forms of expressions generated during an evaluation are tested only \
after their head and arguments have been evaluated. In addition, evaluation \
chains for expressions which do not change under evaluation are not included. \
"
}], "Notes",
 CellID->19786],

Cell[TextData[{
 "With ",
 Cell[BoxData[
  RowBox[{"TraceOriginal", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", the forms before evaluation of the head and arguments are also tested, \
and evaluation chains for expressions which do not change under evaluation \
are included. "
}], "Notes",
 CellID->4611]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->226089208],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->223764339],

Cell["\<\
Trace evaluation of an expression showing evaluation chains for expressions \
that change:\
\>", "ExampleText",
 CellID->266234408],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{"f", "[", 
   RowBox[{"1", ",", 
    RowBox[{"2", "+", "3"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->216694103],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"2", "+", "3"}],
      HoldForm], ",", 
     TagBox["5",
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"f", "[", 
     RowBox[{"1", ",", "5"}], "]"}],
    HoldForm]}], "}"}]], "Output",
 ImageSize->{135, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->10799482]
}, Open  ]],

Cell["\<\
Show evaluation chains even for expressions that do not change:\
\>", "ExampleText",
 CellID->363454135],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Trace", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"1", ",", 
     RowBox[{"2", "+", "3"}]}], "]"}], ",", 
   RowBox[{"TraceOriginal", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->330760274],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"f", "[", 
     RowBox[{"1", ",", 
      RowBox[{"2", "+", "3"}]}], "]"}],
    HoldForm], ",", 
   RowBox[{"{", 
    TagBox["f",
     HoldForm], "}"}], ",", 
   RowBox[{"{", 
    TagBox["1",
     HoldForm], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     TagBox[
      RowBox[{"2", "+", "3"}],
      HoldForm], ",", 
     RowBox[{"{", 
      TagBox["Plus",
       HoldForm], "}"}], ",", 
     RowBox[{"{", 
      TagBox["2",
       HoldForm], "}"}], ",", 
     RowBox[{"{", 
      TagBox["3",
       HoldForm], "}"}], ",", 
     TagBox[
      RowBox[{"2", "+", "3"}],
      HoldForm], ",", 
     TagBox["5",
      HoldForm]}], "}"}], ",", 
   TagBox[
    RowBox[{"f", "[", 
     RowBox[{"1", ",", "5"}], "]"}],
    HoldForm]}], "}"}]], "Output",
 ImageSize->{431, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->9812454]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->800],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->28433]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18822],

Cell[TextData[ButtonBox["Tracing Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TracingEvaluation"]], "Tutorials",
 CellID->260]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TraceOriginal - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 27.5367304}", "context" -> "System`", 
    "keywords" -> {"stack trace", "evaluation chain", "trace control"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "TraceOriginal is an option for Trace and related functions which \
specifies whether to test the form of each expression before its head and \
arguments are evaluated. ", "synonyms" -> {"trace original"}, "title" -> 
    "TraceOriginal", "type" -> "Symbol", "uri" -> "ref/TraceOriginal"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[3875, 131, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->226089208]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8799, 322}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1136, 30, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1759, 57, 51, 1, 70, "ObjectName",
 CellID->26784],
Cell[1813, 60, 678, 19, 70, "Usage",
 CellID->21426]
}, Open  ]],
Cell[CellGroupData[{
Cell[2528, 84, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3006, 101, 456, 12, 70, "Notes",
 CellID->19786],
Cell[3465, 115, 373, 11, 70, "Notes",
 CellID->4611]
}, Closed]],
Cell[CellGroupData[{
Cell[3875, 131, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->226089208],
Cell[CellGroupData[{
Cell[4260, 145, 148, 5, 70, "ExampleSection",
 CellID->223764339],
Cell[4411, 152, 141, 4, 70, "ExampleText",
 CellID->266234408],
Cell[CellGroupData[{
Cell[4577, 160, 178, 6, 28, "Input",
 CellID->216694103],
Cell[4758, 168, 421, 18, 36, "Output",
 CellID->10799482]
}, Open  ]],
Cell[5194, 189, 114, 3, 70, "ExampleText",
 CellID->363454135],
Cell[CellGroupData[{
Cell[5333, 196, 249, 8, 28, "Input",
 CellID->330760274],
Cell[5585, 206, 937, 41, 36, "Output",
 CellID->9812454]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6583, 254, 309, 9, 70, "SeeAlsoSection",
 CellID->800],
Cell[6895, 265, 190, 6, 70, "SeeAlso",
 CellID->28433]
}, Open  ]],
Cell[CellGroupData[{
Cell[7122, 276, 314, 9, 70, "TutorialsSection",
 CellID->18822],
Cell[7439, 287, 144, 3, 70, "Tutorials",
 CellID->260]
}, Open  ]],
Cell[7598, 293, 27, 0, 70, "History"],
Cell[7628, 295, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

