(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     21275,        812]
NotebookOptionsPosition[     16660,        660]
NotebookOutlinePosition[     18168,        700]
CellTagsIndexPosition[     18083,        695]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tracing Evaluation" :> 
          Documentation`HelpLookup["paclet:tutorial/TracingEvaluation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Tracing Evaluation\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Trace" :> Documentation`HelpLookup["paclet:ref/Trace"], "On" :> 
          Documentation`HelpLookup["paclet:ref/On"], "Print" :> 
          Documentation`HelpLookup["paclet:ref/Print"], "TraceScan" :> 
          Documentation`HelpLookup["paclet:ref/TraceScan"], "TraceDialog" :> 
          Documentation`HelpLookup["paclet:ref/TraceDialog"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Trace\"\>", 2->"\<\"On\"\>", 
       3->"\<\"Print\"\>", 4->"\<\"TraceScan\"\>", 
       5->"\<\"TraceDialog\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Symbolic Execution History" :> 
          Documentation`HelpLookup["paclet:guide/SymbolicExecutionHistory"], 
          "Tuning & Debugging" :> 
          Documentation`HelpLookup["paclet:guide/TuningAndDebugging"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Symbolic Execution History\"\>", 
       2->"\<\"Tuning & Debugging\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TracePrint", "ObjectName",
 CellID->11585],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["TracePrint",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TracePrint"], "[", 
       StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]prints all expressions used in the evaluation of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["TracePrint",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TracePrint"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["form", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]includes only those expressions which match ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["TracePrint",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TracePrint"], "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        StyleBox["s", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]includes all evaluations which use transformation rules \
associated with the symbol ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->17089]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TracePrint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TracePrint"]], "InlineFormula"],
 " indents its output in correspondence with the nesting levels for lists \
generated by ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->29807],

Cell[TextData[{
 "The indentation is done using the print form defined for the object ",
 Cell[BoxData[
  RowBox[{"Indent", "[", 
   StyleBox["d", "TI"], "]"}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->15944],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TracePrint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TracePrint"]], "InlineFormula"],
 " prints the forms of expressions before any of their elements are \
evaluated. "
}], "Notes",
 CellID->25535],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TracePrint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TracePrint"]], "InlineFormula"],
 " does not support the ",
 Cell[BoxData[
  ButtonBox["TraceBackward",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TraceBackward"]], "InlineFormula"],
 " option of ",
 Cell[BoxData[
  ButtonBox["Trace",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Trace"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->19264],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TracePrint",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TracePrint"]], "InlineFormula"],
 " yields only the forward part of the output specified by the option setting \
",
 Cell[BoxData[
  RowBox[{
   ButtonBox["TraceAbove",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraceAbove"], "->", 
   ButtonBox["All",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/All"]}]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->10812],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["TracePrint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TracePrint"], "[", 
   StyleBox["expr", "TI"], "]"}]], "InlineFormula"],
 " returns the result of evaluating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->13627]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->133457355],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->272698467],

Cell["Print all expressions used in evaluation of an expression:", \
"ExampleText",
 CellID->296166639],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TracePrint", "[", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"2", "+", "3"}], ")"}], "^", "2"}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->11411128],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{" ", "\[InvisibleSpace]", 
   TagBox[
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"2", "+", "3"}], ")"}], "2"],
    HoldForm]}],
  SequenceForm[
   Indent[1], 
   HoldForm[(2 + 3)^2]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->24514812],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"  ", "\[InvisibleSpace]", 
   TagBox["Power",
    HoldForm]}],
  SequenceForm[
   Indent[2], 
   HoldForm[Power]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->37881443],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"  ", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"2", "+", "3"}],
    HoldForm]}],
  SequenceForm[
   Indent[2], 
   HoldForm[2 + 3]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->25529625],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"   ", "\[InvisibleSpace]", 
   TagBox["Plus",
    HoldForm]}],
  SequenceForm[
   Indent[3], 
   HoldForm[Plus]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->176600026],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"   ", "\[InvisibleSpace]", 
   TagBox["2",
    HoldForm]}],
  SequenceForm[
   Indent[3], 
   HoldForm[2]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->102748281],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"   ", "\[InvisibleSpace]", 
   TagBox["3",
    HoldForm]}],
  SequenceForm[
   Indent[3], 
   HoldForm[3]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->92864260],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"  ", "\[InvisibleSpace]", 
   TagBox["5",
    HoldForm]}],
  SequenceForm[
   Indent[2], 
   HoldForm[5]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->52603423],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"  ", "\[InvisibleSpace]", 
   TagBox["2",
    HoldForm]}],
  SequenceForm[
   Indent[2], 
   HoldForm[2]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->486596535],

Cell[BoxData[
 InterpretationBox[
  RowBox[{" ", "\[InvisibleSpace]", 
   TagBox[
    SuperscriptBox["5", "2"],
    HoldForm]}],
  SequenceForm[
   Indent[1], 
   HoldForm[5^2]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->46577184],

Cell[BoxData[
 InterpretationBox[
  RowBox[{" ", "\[InvisibleSpace]", 
   TagBox["25",
    HoldForm]}],
  SequenceForm[
   Indent[1], 
   HoldForm[25]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[4]:=",
 CellID->210005027]
}, Open  ]],

Cell[BoxData["25"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->21501660]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->307144095],

Cell["A recursive definition for finding Fibonacci numbers:", "ExampleText",
 CellID->85517671],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"fib", "[", "0", "]"}], "=", 
   RowBox[{
    RowBox[{"fib", "[", "1", "]"}], "=", "1"}]}], ";", 
  RowBox[{
   RowBox[{"fib", "[", "n_", "]"}], ":=", 
   RowBox[{
    RowBox[{"fib", "[", 
     RowBox[{"n", "-", "1"}], "]"}], "+", 
    RowBox[{"fib", "[", 
     RowBox[{"n", "-", "2"}], "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->75714580],

Cell["Show all additions of positive integers:", "ExampleText",
 CellID->91783335],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TracePrint", "[", 
  RowBox[{
   RowBox[{"fib", "[", "5", "]"}], ",", 
   RowBox[{"Plus", "[", 
    RowBox[{"__Integer", "?", "Positive"}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->387546432],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"    ", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"1", "+", "1"}],
    HoldForm]}],
  SequenceForm[
   Indent[4], 
   HoldForm[1 + 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->27926465],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"   ", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"2", "+", "1"}],
    HoldForm]}],
  SequenceForm[
   Indent[3], 
   HoldForm[2 + 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->587452851],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"   ", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"1", "+", "1"}],
    HoldForm]}],
  SequenceForm[
   Indent[3], 
   HoldForm[1 + 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->116850319],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"  ", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"3", "+", "2"}],
    HoldForm]}],
  SequenceForm[
   Indent[2], 
   HoldForm[3 + 2]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->60268162],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"   ", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"1", "+", "1"}],
    HoldForm]}],
  SequenceForm[
   Indent[3], 
   HoldForm[1 + 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->121732318],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"  ", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"2", "+", "1"}],
    HoldForm]}],
  SequenceForm[
   Indent[2], 
   HoldForm[2 + 1]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->82545340],

Cell[BoxData[
 InterpretationBox[
  RowBox[{" ", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"5", "+", "3"}],
    HoldForm]}],
  SequenceForm[
   Indent[1], 
   HoldForm[5 + 3]],
  Editable->False]], "Print",
 CellLabel->"During evaluation of In[8]:=",
 CellID->36365895]
}, Open  ]],

Cell[BoxData["8"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->422967642]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->10449],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Trace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trace"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["On",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/On"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Print",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Print"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TraceScan",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraceScan"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TraceDialog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraceDialog"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29869]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->8984],

Cell[TextData[ButtonBox["Tracing Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TracingEvaluation"]], "Tutorials",
 CellID->260]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Symbolic Execution History",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicExecutionHistory"]], "MoreAbout",
 CellID->277166910],

Cell[TextData[ButtonBox["Tuning & Debugging",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TuningAndDebugging"]], "MoreAbout",
 CellID->262535217]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TracePrint - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 27.7711114}", "context" -> "System`", 
    "keywords" -> {
     "monitoring evaluation", "print trace of evaluation", 
      "real-time monitoring", "watch evaluation"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "TracePrint[expr] prints all expressions used in the evaluation of expr. \
TracePrint[expr, form] includes only those expressions which match form. \
TracePrint[expr, s] includes all evaluations which use transformation rules \
associated with the symbol s. ", "synonyms" -> {"trace print"}, "title" -> 
    "TracePrint", "type" -> "Symbol", "uri" -> "ref/TracePrint"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7105, 241, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->133457355]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17940, 688}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2256, 53, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2879, 80, 48, 1, 70, "ObjectName",
 CellID->11585],
Cell[2930, 83, 1502, 47, 70, "Usage",
 CellID->17089]
}, Open  ]],
Cell[CellGroupData[{
Cell[4469, 135, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4947, 152, 378, 13, 70, "Notes",
 CellID->29807],
Cell[5328, 167, 214, 7, 70, "Notes",
 CellID->15944],
Cell[5545, 176, 250, 8, 70, "Notes",
 CellID->25535],
Cell[5798, 186, 458, 17, 70, "Notes",
 CellID->19264],
Cell[6259, 205, 480, 17, 70, "Notes",
 CellID->10812],
Cell[6742, 224, 326, 12, 70, "Notes",
 CellID->13627]
}, Closed]],
Cell[CellGroupData[{
Cell[7105, 241, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->133457355],
Cell[CellGroupData[{
Cell[7490, 255, 148, 5, 70, "ExampleSection",
 CellID->272698467],
Cell[7641, 262, 103, 2, 70, "ExampleText",
 CellID->296166639],
Cell[CellGroupData[{
Cell[7769, 268, 177, 6, 70, "Input",
 CellID->11411128],
Cell[CellGroupData[{
Cell[7971, 278, 330, 13, 70, "Print",
 CellID->24514812],
Cell[8304, 293, 252, 10, 70, "Print",
 CellID->37881443],
Cell[8559, 305, 273, 11, 70, "Print",
 CellID->25529625],
Cell[8835, 318, 252, 10, 70, "Print",
 CellID->176600026],
Cell[9090, 330, 246, 10, 70, "Print",
 CellID->102748281],
Cell[9339, 342, 245, 10, 70, "Print",
 CellID->92864260],
Cell[9587, 354, 244, 10, 70, "Print",
 CellID->52603423],
Cell[9834, 366, 245, 10, 70, "Print",
 CellID->486596535],
Cell[10082, 378, 271, 11, 70, "Print",
 CellID->46577184],
Cell[10356, 391, 246, 10, 70, "Print",
 CellID->210005027]
}, Open  ]],
Cell[10617, 404, 158, 5, 36, "Output",
 CellID->21501660]
}, Open  ]],
Cell[10790, 412, 125, 3, 70, "ExampleDelimiter",
 CellID->307144095],
Cell[10918, 417, 95, 1, 70, "ExampleText",
 CellID->85517671],
Cell[11016, 420, 402, 14, 70, "Input",
 CellID->75714580],
Cell[11421, 436, 82, 1, 70, "ExampleText",
 CellID->91783335],
Cell[CellGroupData[{
Cell[11528, 441, 232, 7, 70, "Input",
 CellID->387546432],
Cell[CellGroupData[{
Cell[11785, 452, 275, 11, 70, "Print",
 CellID->27926465],
Cell[12063, 465, 275, 11, 70, "Print",
 CellID->587452851],
Cell[12341, 478, 275, 11, 70, "Print",
 CellID->116850319],
Cell[12619, 491, 273, 11, 70, "Print",
 CellID->60268162],
Cell[12895, 504, 275, 11, 70, "Print",
 CellID->121732318],
Cell[13173, 517, 273, 11, 70, "Print",
 CellID->82545340],
Cell[13449, 530, 272, 11, 70, "Print",
 CellID->36365895]
}, Open  ]],
Cell[13736, 544, 158, 5, 36, "Output",
 CellID->422967642]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13955, 556, 311, 9, 70, "SeeAlsoSection",
 CellID->10449],
Cell[14269, 567, 1170, 44, 70, "SeeAlso",
 CellID->29869]
}, Open  ]],
Cell[CellGroupData[{
Cell[15476, 616, 313, 9, 70, "TutorialsSection",
 CellID->8984],
Cell[15792, 627, 144, 3, 70, "Tutorials",
 CellID->260]
}, Open  ]],
Cell[CellGroupData[{
Cell[15973, 635, 299, 8, 70, "MoreAboutSection"],
Cell[16275, 645, 162, 3, 70, "MoreAbout",
 CellID->277166910],
Cell[16440, 650, 148, 3, 70, "MoreAbout",
 CellID->262535217]
}, Open  ]],
Cell[16603, 656, 27, 0, 70, "History"],
Cell[16633, 658, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

