(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     20545,        769]
NotebookOptionsPosition[     15756,        613]
NotebookOutlinePosition[     17346,        653]
CellTagsIndexPosition[     17261,        648]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Tracing Evaluation" :> 
          Documentation`HelpLookup["paclet:tutorial/TracingEvaluation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Tracing Evaluation\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Trace" :> Documentation`HelpLookup["paclet:ref/Trace"], 
          "TracePrint" :> Documentation`HelpLookup["paclet:ref/TracePrint"], 
          "TraceDialog" :> 
          Documentation`HelpLookup["paclet:ref/TraceDialog"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Trace\"\>", 2->"\<\"TracePrint\"\>",
        3->"\<\"TraceDialog\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Symbolic Execution History" :> 
          Documentation`HelpLookup[
           "paclet:guide/SymbolicExecutionHistory"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Symbolic Execution History\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TraceScan", "ObjectName",
 CellID->20600],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["TraceScan",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TraceScan"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]applies ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " to all expressions used in the evaluation of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["TraceScan",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TraceScan"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["expr", "TI"], ",", 
        StyleBox["form", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]includes only those expressions which match ",
     Cell[BoxData[
      StyleBox["form", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["TraceScan",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TraceScan"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["expr", "TI"], ",", 
        StyleBox["s", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]includes all evaluations which use transformation rules \
associated with the symbol ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     ". "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{
       ButtonBox["TraceScan",
        BaseStyle->"Link",
        ButtonData->"paclet:ref/TraceScan"], "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        StyleBox["expr", "TI"], ",", 
        StyleBox["form", "TI"], ",", 
        StyleBox["fp", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]applies ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " before evaluation and ",
     Cell[BoxData[
      StyleBox["fp", "TI"]], "InlineFormula"],
     " after evaluation to expressions used in the evaluation of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     ". "
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->28366]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "All expressions are wrapped in ",
 Cell[BoxData[
  ButtonBox["HoldForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/HoldForm"]], "InlineFormula"],
 " to prevent evaluation before ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  StyleBox["fp", "TI"]], "InlineFormula"],
 " are applied to them. "
}], "Notes",
 CellID->17192],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  StyleBox["fp", "TI"]], "InlineFormula"],
 " is given as arguments both the form before evaluation and the form after \
evaluation. "
}], "Notes",
 CellID->7546],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["TraceScan",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraceScan"], "[", 
   RowBox[{
    StyleBox["f", "TI"], ",", 
    StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
 " returns the result of evaluating ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->6164]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->81439423],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->26994907],

Cell["Print all expressions used for evaluation:", "ExampleText",
 CellID->143824474],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TraceScan", "[", 
  RowBox[{"Print", ",", 
   RowBox[{"f", "[", 
    RowBox[{"1", ",", 
     RowBox[{"2", "+", "3"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->42954193],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  RowBox[{"f", "[", 
   RowBox[{"1", ",", 
    RowBox[{"2", "+", "3"}]}], "]"}],
  HoldForm]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->265508662],

Cell[BoxData[
 TagBox["f",
  HoldForm]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->616483540],

Cell[BoxData[
 TagBox["1",
  HoldForm]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->64450963],

Cell[BoxData[
 TagBox[
  RowBox[{"2", "+", "3"}],
  HoldForm]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->606055546],

Cell[BoxData[
 TagBox["Plus",
  HoldForm]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->95152641],

Cell[BoxData[
 TagBox["2",
  HoldForm]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->9191712],

Cell[BoxData[
 TagBox["3",
  HoldForm]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->242607768],

Cell[BoxData[
 TagBox["5",
  HoldForm]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->9261323],

Cell[BoxData[
 TagBox[
  RowBox[{"f", "[", 
   RowBox[{"1", ",", "5"}], "]"}],
  HoldForm]], "Print",
 CellLabel->"During evaluation of In[19]:=",
 CellID->715256386]
}, Open  ]],

Cell[BoxData[
 RowBox[{"f", "[", 
  RowBox[{"1", ",", "5"}], "]"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->554922634]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->179665205],

Cell["\<\
Count additions and multiplications of machine numbers needed for a numerical \
computation:\
\>", "ExampleText",
 CellID->701928725],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Block", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"c", " ", "=", " ", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"TraceScan", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"c", "++"}], "&"}], ",", 
       RowBox[{"FixedPoint", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"#", "/", "2"}], "+", 
            RowBox[{"1", "/", "#"}]}], ")"}], "&"}], ",", "1."}], "]"}], ",", 
       
       RowBox[{
        RowBox[{"(", 
         RowBox[{"Plus", "|", "Times"}], ")"}], "[", 
        RowBox[{"__", "?", "MachineNumberQ"}], "]"}]}], "]"}], ",", "c"}], 
    "}"}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->656604353],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.414213562373095`", ",", "12"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[1]=",
 CellID->193303807]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->146463204],

Cell["A recursive definition for finding Fibonacci numbers:", "ExampleText",
 CellID->85517671],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"fib", "[", "0", "]"}], "=", 
   RowBox[{
    RowBox[{"fib", "[", "1", "]"}], "=", "1"}]}], ";", 
  RowBox[{
   RowBox[{"fib", "[", "n_", "]"}], ":=", 
   RowBox[{
    RowBox[{"fib", "[", 
     RowBox[{"n", "-", "1"}], "]"}], "+", 
    RowBox[{"fib", "[", 
     RowBox[{"n", "-", "2"}], "]"}]}]}], ";"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->75714580],

Cell[TextData[{
 "Count calls to ",
 Cell[BoxData["fib"], "InlineFormula"],
 " required:"
}], "ExampleText",
 CellID->575324014],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"c", " ", "=", " ", "0"}], ";", 
    RowBox[{"TraceScan", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "++"}], ")"}], "&"}], ",", 
      RowBox[{"fib", "[", "10", "]"}], ",", 
      RowBox[{"fib", "[", "_Integer", "]"}]}], "]"}]}], ",", "c"}], 
  "}"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->190961438],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"89", ",", "177"}], "}"}]], "Output",
 ImageSize->{65, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->34372375]
}, Open  ]],

Cell[TextData[{
 "Redefine ",
 Cell[BoxData["fib"], "InlineFormula"],
 " so that it saves results:"
}], "ExampleText",
 CellID->738060249],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"fib", "[", "n_", "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"fib", "[", "n", "]"}], "=", 
     RowBox[{
      RowBox[{"fib", "[", 
       RowBox[{"n", "-", "1"}], "]"}], "+", 
      RowBox[{"fib", "[", 
       RowBox[{"n", "-", "2"}], "]"}]}]}], ")"}]}], ";"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->415657876],

Cell[TextData[{
 "Count calls to ",
 Cell[BoxData["fib"], "InlineFormula"],
 " required:"
}], "ExampleText",
 CellID->531013944],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"c", " ", "=", " ", "0"}], ";", 
    RowBox[{"TraceScan", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "++"}], ")"}], "&"}], ",", 
      RowBox[{"fib", "[", "10", "]"}], ",", 
      RowBox[{"fib", "[", "_Integer", "]"}]}], "]"}]}], ",", "c"}], 
  "}"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->10980418],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"89", ",", "28"}], "}"}]], "Output",
 ImageSize->{58, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->99275275]
}, Open  ]],

Cell["\<\
The second time through it takes only one call since the value was saved:\
\>", "ExampleText",
 CellID->247582451],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"c", " ", "=", " ", "0"}], ";", 
    RowBox[{"TraceScan", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{"c", "++"}], ")"}], "&"}], ",", 
      RowBox[{"fib", "[", "10", "]"}], ",", 
      RowBox[{"fib", "[", "_Integer", "]"}]}], "]"}]}], ",", "c"}], 
  "}"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->474285052],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"89", ",", "1"}], "}"}]], "Output",
 ImageSize->{51, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->532816791]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1933],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Trace",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Trace"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TracePrint",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TracePrint"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TraceDialog",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/TraceDialog"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23844]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7303],

Cell[TextData[ButtonBox["Tracing Evaluation",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/TracingEvaluation"]], "Tutorials",
 CellID->260]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Symbolic Execution History",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/SymbolicExecutionHistory"]], "MoreAbout",
 CellID->143028236]
}, Open  ]],

Cell["New in 2", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TraceScan - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 28.0679940}", "context" -> "System`", 
    "keywords" -> {"stack trace", "evaluation chain", "scan evaluation"}, 
    "index" -> True, "label" -> "Built-in Mathematica Symbol", "language" -> 
    "en", "paclet" -> "Mathematica", "status" -> "None", "summary" -> 
    "TraceScan[f, expr] applies f to all expressions used in the evaluation \
of expr. TraceScan[f, expr, form] includes only those expressions which match \
form. TraceScan[f, expr, s] includes all evaluations which use transformation \
rules associated with the symbol s. TraceScan[f, expr, form, fp] applies f \
before evaluation and fp after evaluation to expressions used in the \
evaluation of expr. ", "synonyms" -> {"trace scan"}, "title" -> "TraceScan", 
    "type" -> "Symbol", "uri" -> "ref/TraceScan"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6561, 221, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->81439423]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 17119, 641}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1958, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2581, 76, 47, 1, 70, "ObjectName",
 CellID->20600],
Cell[2631, 79, 2408, 76, 70, "Usage",
 CellID->28366]
}, Open  ]],
Cell[CellGroupData[{
Cell[5076, 160, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5554, 177, 384, 14, 70, "Notes",
 CellID->17192],
Cell[5941, 193, 211, 7, 70, "Notes",
 CellID->7546],
Cell[6155, 202, 369, 14, 70, "Notes",
 CellID->6164]
}, Closed]],
Cell[CellGroupData[{
Cell[6561, 221, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->81439423],
Cell[CellGroupData[{
Cell[6945, 235, 147, 5, 70, "ExampleSection",
 CellID->26994907],
Cell[7095, 242, 85, 1, 70, "ExampleText",
 CellID->143824474],
Cell[CellGroupData[{
Cell[7205, 247, 211, 7, 70, "Input",
 CellID->42954193],
Cell[CellGroupData[{
Cell[7441, 258, 191, 7, 70, "Print",
 CellID->265508662],
Cell[7635, 267, 114, 4, 70, "Print",
 CellID->616483540],
Cell[7752, 273, 113, 4, 70, "Print",
 CellID->64450963],
Cell[7868, 279, 137, 5, 70, "Print",
 CellID->606055546],
Cell[8008, 286, 116, 4, 70, "Print",
 CellID->95152641],
Cell[8127, 292, 112, 4, 70, "Print",
 CellID->9191712],
Cell[8242, 298, 114, 4, 70, "Print",
 CellID->242607768],
Cell[8359, 304, 112, 4, 70, "Print",
 CellID->9261323],
Cell[8474, 310, 166, 6, 70, "Print",
 CellID->715256386]
}, Open  ]],
Cell[8655, 319, 208, 7, 36, "Output",
 CellID->554922634]
}, Open  ]],
Cell[8878, 329, 125, 3, 70, "ExampleDelimiter",
 CellID->179665205],
Cell[9006, 334, 143, 4, 70, "ExampleText",
 CellID->701928725],
Cell[CellGroupData[{
Cell[9174, 342, 737, 25, 70, "Input",
 CellID->656604353],
Cell[9914, 369, 221, 7, 36, "Output",
 CellID->193303807]
}, Open  ]],
Cell[10150, 379, 125, 3, 70, "ExampleDelimiter",
 CellID->146463204],
Cell[10278, 384, 95, 1, 70, "ExampleText",
 CellID->85517671],
Cell[10376, 387, 402, 14, 70, "Input",
 CellID->75714580],
Cell[10781, 403, 128, 5, 70, "ExampleText",
 CellID->575324014],
Cell[CellGroupData[{
Cell[10934, 412, 402, 14, 70, "Input",
 CellID->190961438],
Cell[11339, 428, 205, 7, 36, "Output",
 CellID->34372375]
}, Open  ]],
Cell[11559, 438, 138, 5, 70, "ExampleText",
 CellID->738060249],
Cell[11700, 445, 375, 13, 70, "Input",
 CellID->415657876],
Cell[12078, 460, 128, 5, 70, "ExampleText",
 CellID->531013944],
Cell[CellGroupData[{
Cell[12231, 469, 401, 14, 70, "Input",
 CellID->10980418],
Cell[12635, 485, 204, 7, 36, "Output",
 CellID->99275275]
}, Open  ]],
Cell[12854, 495, 124, 3, 70, "ExampleText",
 CellID->247582451],
Cell[CellGroupData[{
Cell[13003, 502, 402, 14, 70, "Input",
 CellID->474285052],
Cell[13408, 518, 204, 7, 36, "Output",
 CellID->532816791]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13673, 532, 310, 9, 70, "SeeAlsoSection",
 CellID->1933],
Cell[13986, 543, 700, 26, 70, "SeeAlso",
 CellID->23844]
}, Open  ]],
Cell[CellGroupData[{
Cell[14723, 574, 313, 9, 70, "TutorialsSection",
 CellID->7303],
Cell[15039, 585, 144, 3, 70, "Tutorials",
 CellID->260]
}, Open  ]],
Cell[CellGroupData[{
Cell[15220, 593, 299, 8, 70, "MoreAboutSection"],
Cell[15522, 603, 162, 3, 70, "MoreAbout",
 CellID->143028236]
}, Open  ]],
Cell[15699, 609, 27, 0, 70, "History"],
Cell[15729, 611, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

