(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16830,        529]
NotebookOptionsPosition[     13752,        431]
NotebookOutlinePosition[     15155,        470]
CellTagsIndexPosition[     15070,        465]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["BUILT-IN MATHEMATICA SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Introduction to Dynamic" :> 
          Documentation`HelpLookup["paclet:tutorial/IntroductionToDynamic"], 
          "Advanced Dynamic Functionality" :> 
          Documentation`HelpLookup[
           "paclet:tutorial/AdvancedDynamicFunctionality"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Introduction to Dynamic\"\>", 
       2->"\<\"Advanced Dynamic Functionality\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"UpdateInterval" :> 
          Documentation`HelpLookup["paclet:ref/UpdateInterval"], "Update" :> 
          Documentation`HelpLookup["paclet:ref/Update"], 
          "SynchronousUpdating" :> 
          Documentation`HelpLookup["paclet:ref/SynchronousUpdating"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"UpdateInterval\"\>", 
       2->"\<\"Update\"\>", 
       3->"\<\"SynchronousUpdating\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Options & Styling for Interactive Manipulation" :> 
          Documentation`HelpLookup[
           "paclet:guide/OptionsAndStylingForInteractiveManipulation"], 
          "Tuning & Debugging" :> 
          Documentation`HelpLookup["paclet:guide/TuningAndDebugging"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Options & Styling for Interactive Manipulation\"\>", 
       2->"\<\"Tuning & Debugging\"\>"}, "\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell[BoxData[GridBox[{
   {Cell["TrackedSymbols", "ObjectName"], Cell[BoxData[
     TooltipBox[
      StyleBox[
       StyleBox[
        GraphicsBox[RasterBox[CompressedData["
1:eJztUltygzAMjGT5bYwJkHea9Cy9QY+QC/T+f5VMm5BpOpP/dmcMtrxarQSv
l4/3Cy4Wi4HXGy/4xxzWe2tk4xVAg1gPjvfUf1Nc4dsMoCUsOL6M4/Im0Vqs
7wY7JodSYgOAEaDH8kVBZ3VmlkKX5bxJSziM65lGldABuSp63nEpDB145/TE
iFbpBtkdUivnZRoA9vK4+pR4j5krB9fUNMxOe9vZiZCDFGKT3sMksQU4pFkr
tohHD+zGBookEtTkQBCnVoo4cNgAIVxdbOcSxEmRWd6wktIxmhYVRwiaUDsV
B8aGkPlaAvu03hxO6XiTUB465Dn1PMccteUumCr0livLPVqwDk0QWcE5jSmt
Zp9VOx0Cj6CTcZue00xg52RAx1pVEw+lRNC9DISxS7sN3CHYqVqEZ7E+b+8D
HuukW9RPa6zSbn40DuvvWdCrxwnG/hAfTi+r64/REkkboIiIfpEI5UF02D9p
+c/gE6ZrEwI=
          "], {{0, 0}, {67, 20}},
          ColorFunction->(Apply[RGBColor, 
            Part[CompressedData["
1:eJx90ssuAwEUxvGJeACJhIj7I9iJzXkHwcYtkVgTsfEkrLRPYFvRloWFhYho
CYL0olrtTKd1pzecz5yzcMIvab7Ff5ImM2d4YWl8sc1xnKHvX7sjqvT//qVK
72+sYFZ6OgVmpbearGxWeu2DFc1KP02CWemDsGdWejjEjs1KH4Ats9I31tmB
WenRHVaibjigDghrf35it2alX1+BWemNOnPNSn99YXdmpT8+sIxZ6bNQpmSC
ZWkZ0tovzsGs9NAm82kNijQK99pjUebSJJxRLxxqbzaYRyOQoX640R6PMS/4
rinqgUvt81DR5/rA0/7ZYn7wvy6NQUn7bpyVaRVytAJZ7XPg03aEFWgK8r/u
q6LP/dyPb+6/C/I0ATnt0+BS4gSoE/a1z4CndyHvUXq9xkrBezsK7jCi/Qvn
YdPd
             "], #]]& ),
          ColorFunctionScaling->False],
         Background->None,
         ImageSize->{67, 20},
         PlotRange->{{0, 67}, {0, 20}}],
        Deployed->True,
        StripOnInput->False], "NewIn6Graphic",
       StripOnInput->False],
      "New in 6",
      ActionDelay->0.3]],
     Magnification->1]}
  }]], "ObjectNameGrid"],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      ButtonBox["TrackedSymbols",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/TrackedSymbols"]], "InlineFormula"],
     " \[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["Refresh",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Refresh"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["Manipulate",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
     " and related functions that specifies which symbols should trigger \
updates when their values are changed."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21081]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following settings can be used:", "Notes",
 CellID->32382],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["All",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/All"], Cell[
    "all possible symbols", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Full",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Full"], Cell[
    "symbols that appear explicitly in the input expression", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "symbols being tracked in enclosing constructs", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    RowBox[{"{", 
     RowBox[{
      StyleBox["x", "TI"], ",", 
      StyleBox["y", "TI"], ",", 
      StyleBox["z", "TI"], ",", 
      StyleBox["\[Ellipsis]", "TR"]}], "}"}], Cell[
    "an explicit list of symbols", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->2489],

Cell[TextData[{
 "When a list of symbols is given, the typical usage is ",
 Cell[BoxData[
  RowBox[{"TrackedSymbols", ":>", 
   RowBox[{"{", 
    RowBox[{
     StyleBox["x", "TI"], ",", 
     StyleBox["y", "TI"], ",", 
     StyleBox["z", "TI"], ",", 
     StyleBox["\[Ellipsis]", "TR"]}], "}"}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->2105]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->515935355],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->334837059],

Cell[TextData[{
 "Specify symbols in ",
 Cell[BoxData[
  ButtonBox["Manipulate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Manipulate"]], "InlineFormula"],
 " that will be used for updating:"
}], "ExampleText",
 CellID->1108340830],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"u", ",", "v"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", "1", ",", "2"}], "}"}], ",", 
   RowBox[{"TrackedSymbols", "->", 
    RowBox[{"{", "u", "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[1]:=",
 CellID->273490128],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = 0.29, $CellContext`v$$ = 1.612, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`u$$], 0, 1}, {
      Hold[$CellContext`v$$], 1, 2}}, Typeset`size$$ = {88.1875, {2., 8.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    True, $CellContext`u$46145$$ = 0, $CellContext`v$46146$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`u$$ = 0, $CellContext`v$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$46145$$, 0], 
        Hold[$CellContext`v$$, $CellContext`v$46146$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> {$CellContext`u$$, $CellContext`v$$}, 
      "Specifications" :> {{$CellContext`u$$, 0, 1}, {$CellContext`v$$, 1, 
         2}}, "Options" :> {TrackedSymbols -> {$CellContext`u$$}}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{250., {62., 67.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellLabel->"Out[1]=",
 CellID->1930593343]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8168],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["UpdateInterval",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/UpdateInterval"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Update",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Update"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SynchronousUpdating",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SynchronousUpdating"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26545]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32403],

Cell[TextData[ButtonBox["Introduction to Dynamic",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/IntroductionToDynamic"]], "Tutorials",
 CellID->445434225],

Cell[TextData[ButtonBox["Advanced Dynamic Functionality",
 BaseStyle->"Link",
 ButtonData->"paclet:tutorial/AdvancedDynamicFunctionality"]], "Tutorials",
 CellID->558945376]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["RELATED LINKS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "RelatedLinksSection"],

Cell[TextData[{
 ButtonBox["Demonstrations with TrackedSymbols",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/symbol.html?symbol=TrackedSymbols"]\
, None}],
 " (",
 ButtonBox["Wolfram Demonstrations Project",
  BaseStyle->"Hyperlink",
  ButtonData->{
    URL["http://demonstrations.wolfram.com/"], None}],
 ")"
}], "RelatedLinks"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection"],

Cell[TextData[ButtonBox["Options & Styling for Interactive Manipulation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/OptionsAndStylingForInteractiveManipulation"]], "MoreAbout",
 CellID->116387855],

Cell[TextData[ButtonBox["Tuning & Debugging",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/TuningAndDebugging"]], "MoreAbout",
 CellID->146673057]
}, Open  ]],

Cell["New in 6", "History"],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TrackedSymbols - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 20, 27, 28.3336258}", "context" -> "System`", 
    "keywords" -> {
     "control update", "partial variable tracking", 
      "partial dynamic tracking"}, "index" -> True, "label" -> 
    "Built-in Mathematica Symbol", "language" -> "en", "paclet" -> 
    "Mathematica", "status" -> "None", "summary" -> 
    "TrackedSymbols is an option to Refresh, Manipulate and related functions \
that specifies which symbols should trigger updates when their values are \
changed.", "synonyms" -> {"tracked symbols"}, "title" -> "TrackedSymbols", 
    "type" -> "Symbol", "uri" -> "ref/TrackedSymbols"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7543, 221, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->515935355]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14927, 458}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2427, 57, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3050, 84, 1579, 37, 70, "ObjectNameGrid"],
Cell[4632, 123, 811, 24, 70, "Usage",
 CellID->21081]
}, Open  ]],
Cell[CellGroupData[{
Cell[5480, 152, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5958, 169, 68, 1, 70, "Notes",
 CellID->32382],
Cell[6029, 172, 1125, 30, 70, "2ColumnTableMod",
 CellID->2489],
Cell[7157, 204, 349, 12, 70, "Notes",
 CellID->2105]
}, Closed]],
Cell[CellGroupData[{
Cell[7543, 221, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->515935355],
Cell[CellGroupData[{
Cell[7928, 235, 148, 5, 70, "ExampleSection",
 CellID->334837059],
Cell[8079, 242, 238, 8, 70, "ExampleText",
 CellID->1108340830],
Cell[CellGroupData[{
Cell[8342, 254, 379, 12, 28, "Input",
 CellID->273490128],
Cell[8724, 268, 1758, 37, 152, "Output",
 CellID->1930593343]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10543, 312, 310, 9, 70, "SeeAlsoSection",
 CellID->8168],
Cell[10856, 323, 726, 26, 70, "SeeAlso",
 CellID->26545]
}, Open  ]],
Cell[CellGroupData[{
Cell[11619, 354, 314, 9, 70, "TutorialsSection",
 CellID->32403],
Cell[11936, 365, 159, 3, 70, "Tutorials",
 CellID->445434225],
Cell[12098, 370, 173, 3, 70, "Tutorials",
 CellID->558945376]
}, Open  ]],
Cell[CellGroupData[{
Cell[12308, 378, 305, 8, 70, "RelatedLinksSection"],
Cell[12616, 388, 370, 12, 70, "RelatedLinks"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13023, 405, 299, 8, 70, "MoreAboutSection"],
Cell[13325, 415, 204, 4, 70, "MoreAbout",
 CellID->116387855],
Cell[13532, 421, 148, 3, 70, "MoreAbout",
 CellID->146673057]
}, Open  ]],
Cell[13695, 427, 27, 0, 70, "History"],
Cell[13725, 429, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

